/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.InputStreamsSuite$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$1$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$1$$anonfun$apply$mcV$sp$2$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$10$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$2$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$2$$anonfun$apply$mcV$sp$11$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$3$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$3$$anonfun$apply$mcV$sp$12$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$6$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$8$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$8$$anonfun$apply$mcV$sp$20$;
import org.apache.spark.streaming.InputStreamsSuite$$anonfun$testFileStream$1$;
import org.apache.spark.streaming.MultiThreadTestReceiver;
import org.apache.spark.streaming.MultiThreadTestReceiver$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestServer$;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.TestSuiteBase$class;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.spark_project.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0001\u0017\t\t\u0012J\u001c9viN#(/Z1ngN+\u0018\u000e^3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0001B\u0003\u0005\u0002\u000e\u001d5\tA!\u0003\u0002\u0010\t\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001bQ+7\u000f^*vSR,')Y:f!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011D\u0006\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0012\u0001!)q\u0004\u0001C\u0001A\u0005qA/Z:u\r&dWm\u0015;sK\u0006lGCA\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;\t\u000b!r\u0002\u0019A\u0015\u0002\u00199,wOR5mKN|e\u000e\\=\u0011\u0005\tR\u0013BA\u0016$\u0005\u001d\u0011un\u001c7fC:\u0004")
public class InputStreamsSuite
extends SparkFunSuite
implements TestSuiteBase {
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    private String checkpointDir$lzycompute() {
        InputStreamsSuite inputStreamsSuite = this;
        synchronized (inputStreamsSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase$class.checkpointDir(this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    @Override
    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    @Override
    public String framework() {
        return TestSuiteBase$class.framework(this);
    }

    @Override
    public String master() {
        return TestSuiteBase$class.master(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase$class.batchDuration(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase$class.numInputPartitions(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase$class.maxWaitTimeMillis(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase$class.useManualClock(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase$class.actuallyWait(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase$class.beforeFunction(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase$class.afterFunction(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase$class.withStreamingContext(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase$class.withTestServer(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase$class.setupStreams(this, input, operation2, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase$class.setupStreams(this, input1, input2, operation2, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase$class.runStreams(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase$class.runStreamsWithPartitions(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase$class.verifyOutput(this, output2, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase$class.runStreams$default$4(this);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase$class.runStreamsWithPartitions$default$4(this);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase$class.testOperation$default$4(this);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase$class.setupStreams$default$3(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public void testFileStream(boolean newFilesOnly) {
        ObjectRef testDir = ObjectRef.create(null);
        try {
            Bool bool;
            Duration batchDuration = Seconds$.MODULE$.apply(2L);
            testDir.elem = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            File existingFile = new File((File)testDir.elem, "0");
            Files.write((CharSequence)"0\n", (File)existingFile, (Charset)StandardCharsets.UTF_8);
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(existingFile.setLastModified(10000L), "existingFile.setLastModified(10000L)");
            if ($org_scalatest_assert_macro_left.value()) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)existingFile.lastModified()));
                int $org_scalatest_assert_macro_right = 10000;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "");
            }
            Bool $org_scalatest_assert_macro_right = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            this.withStreamingContext(new StreamingContext(this.conf(), batchDuration), (Function1)new Serializable(this, newFilesOnly, testDir, batchDuration, existingFile){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InputStreamsSuite $outer;
                private final boolean newFilesOnly$1;
                public final ObjectRef testDir$2;
                public final Duration batchDuration$3;
                private final File existingFile$3;

                public final void apply(StreamingContext ssc) {
                    ManualClock clock = (ManualClock)ssc.scheduler().clock();
                    clock.setTime(this.existingFile$3.lastModified() + this.batchDuration$3.milliseconds());
                    BatchCounter batchCounter = new BatchCounter(ssc);
                    DStream fileStream = ssc.fileStream(((File)this.testDir$2.elem).toString(), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Path x) {
                            return true;
                        }
                    }, this.newFilesOnly$1, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<LongWritable, Text> x$10) {
                            return ((Text)x$10._2()).toString();
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                    ConcurrentLinkedQueue<Seq<T>> outputQueue = new ConcurrentLinkedQueue<Seq<T>>();
                    TestOutputStream<T> outputStream = new TestOutputStream<T>(fileStream, outputQueue, ClassTag$.MODULE$.apply(String.class));
                    outputStream.register();
                    ssc.start();
                    clock.advance(this.batchDuration$3.milliseconds() / 2L);
                    Seq input = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
                    input.foreach((Function1)new Serializable(this, clock, batchCounter){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFileStream$1 $outer;
                        private final ManualClock clock$5;
                        public final BatchCounter batchCounter$3;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            File file = new File((File)this.$outer.testDir$2.elem, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                            Files.write((CharSequence)new StringBuilder().append(i).append((Object)"\n").toString(), (File)file, (Charset)StandardCharsets.UTF_8);
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(file.setLastModified(this.clock$5.getTimeMillis()), "file.setLastModified(clock.getTimeMillis())");
                            this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)file.lastModified()));
                            long $org_scalatest_assert_macro_right = this.clock$5.getTimeMillis();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, file){
                                public static final long serialVersionUID = 0L;
                                private final File file$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Created file ").append((Object)this.file$3).toString();
                                }
                                {
                                    this.file$3 = file$3;
                                }
                            });
                            this.clock$5.advance(this.$outer.batchDuration$3.milliseconds());
                            Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, i){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testFileStream$1$$anonfun$apply$9 $outer;
                                private final int i$3;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.batchCounter$3.getNumCompletedBatches()));
                                    int $org_scalatest_assert_macro_right = this.i$3;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.i$3 = i$3;
                                }
                            }, Eventually$.MODULE$.patienceConfig());
                        }

                        public /* synthetic */ $anonfun$testFileStream$1 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.clock$5 = clock$5;
                            this.batchCounter$3 = batchCounter$3;
                        }
                    });
                    Set expectedOutput = this.newFilesOnly$1 ? ((TraversableOnce)input.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$11) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$11)).toString();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toSet() : ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))).$plus$plus((GenTraversableOnce)input, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$12) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$12)).toString();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toSet();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((TraversableOnce)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputQueue).asScala()).flatten((Function1)Predef$.MODULE$.$conforms())).toSet());
                    Set $org_scalatest_assert_macro_right = expectedOutput;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                }

                public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.newFilesOnly$1 = newFilesOnly$1;
                    this.testDir$2 = testDir$2;
                    this.batchDuration$3 = batchDuration$3;
                    this.existingFile$3 = existingFile$3;
                }
            });
            return;
        }
        finally {
            if ((File)testDir.elem != null) {
                Utils$.MODULE$.deleteRecursively((File)testDir.elem);
            }
        }
    }

    public InputStreamsSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase$class.$init$(this);
        this.test("socket input stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTestServer(new TestServer(TestServer$.MODULE$.$lessinit$greater$default$1()), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(TestServer testServer) {
                        testServer.start();
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().withStreamingContext(new StreamingContext(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().conf(), this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration()), new Serializable(this, testServer){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2 $outer;
                            public final TestServer testServer$1;

                            public final void apply(StreamingContext ssc) {
                                ssc.addStreamingListener((StreamingListener)ssc.progressListener());
                                Seq input = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
                                BatchCounter batchCounter = new BatchCounter(ssc);
                                ReceiverInputDStream networkStream = ssc.socketTextStream("localhost", this.testServer$1.port(), StorageLevel$.MODULE$.MEMORY_AND_DISK());
                                ConcurrentLinkedQueue<Seq<T>> outputQueue = new ConcurrentLinkedQueue<Seq<T>>();
                                TestOutputStream<T> outputStream = new TestOutputStream<T>(networkStream, outputQueue, ClassTag$.MODULE$.apply(String.class));
                                outputStream.register();
                                ssc.start();
                                ManualClock clock = (ManualClock)ssc.scheduler().clock();
                                Seq expectedOutput = (Seq)input.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(int x$1) {
                                        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                input.indices().foreach$mVc$sp((Function1)new Serializable(this, input, clock){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10 $outer;
                                    private final Seq input$1;
                                    private final ManualClock clock$1;

                                    public final void apply(int i) {
                                        this.apply$mcVI$sp(i);
                                    }

                                    public void apply$mcVI$sp(int i) {
                                        this.$outer.testServer$1.send(new StringBuilder().append((Object)this.input$1.apply(i).toString()).append((Object)"\n").toString());
                                        this.clock$1.advance(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration().milliseconds());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.input$1 = input$1;
                                        this.clock$1 = clock$1;
                                    }
                                });
                                Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, outputQueue, clock, expectedOutput){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10 $outer;
                                    public final ConcurrentLinkedQueue outputQueue$1;
                                    private final ManualClock clock$1;
                                    public final Seq expectedOutput$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        this.clock$1.advance(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration().milliseconds());
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "--------------------------------";
                                            }
                                        });
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10$$anonfun$apply$2 $outer;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.outputQueue$1.size())).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "output";
                                            }
                                        });
                                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.outputQueue$1).asScala()).foreach((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10$$anonfun$apply$2 $outer;

                                            public final void apply(Seq<String> x) {
                                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, x){
                                                    public static final long serialVersionUID = 0L;
                                                    private final Seq x$19;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)"[").append((Object)this.x$19.mkString(",")).append((Object)"]").toString();
                                                    }
                                                    {
                                                        this.x$19 = x$19;
                                                    }
                                                });
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10$$anonfun$apply$2 $outer;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"expected output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.expectedOutput$1.size())).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "expected output";
                                            }
                                        });
                                        this.expectedOutput$1.foreach((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10$$anonfun$apply$2 $outer;

                                            public final void apply(String x) {
                                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, x){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String x$20;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)"[").append((Object)new StringOps(Predef$.MODULE$.augmentString(this.x$20)).mkString(",")).append((Object)"]").toString();
                                                    }
                                                    {
                                                        this.x$20 = x$20;
                                                    }
                                                });
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "--------------------------------";
                                            }
                                        });
                                        String[] output2 = (String[])((TraversableOnce)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.outputQueue$1).asScala()).flatten((Function1)Predef$.MODULE$.$conforms())).toArray(ClassTag$.MODULE$.apply(String.class));
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)output2.length));
                                        int $org_scalatest_assert_macro_right = this.expectedOutput$1.size();
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        Predef$.MODULE$.refArrayOps((Object[])output2).indices().foreach$mVc$sp((Function1)new Serializable(this, output2){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10$$anonfun$apply$2 $outer;
                                            private final String[] output$1;

                                            public final void apply(int i) {
                                                this.apply$mcVI$sp(i);
                                            }

                                            public void apply$mcVI$sp(int i) {
                                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(this.output$1[i]);
                                                String $org_scalatest_assert_macro_right = (String)this.$outer.expectedOutput$1.apply(i);
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.output$1 = output$1;
                                            }
                                        });
                                    }

                                    public /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.outputQueue$1 = outputQueue$1;
                                        this.clock$1 = clock$1;
                                        this.expectedOutput$1 = expectedOutput$1;
                                    }
                                }, Eventually$.MODULE$.patienceConfig());
                                Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, input, ssc){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2$$anonfun$apply$10 $outer;
                                    private final Seq input$1;
                                    private final StreamingContext ssc$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc$1.progressListener().numTotalReceivedRecords()));
                                        int $org_scalatest_assert_macro_right = this.input$1.length();
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc$1.progressListener().numTotalProcessedRecords()));
                                        int $org_scalatest_assert_macro_right2 = this.input$1.length();
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.input$1 = input$1;
                                        this.ssc$1 = ssc$1;
                                    }
                                }, Eventually$.MODULE$.patienceConfig());
                            }

                            public /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$2 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.testServer$1 = testServer$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("socket input stream - no block in a batch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withTestServer(new TestServer(TestServer$.MODULE$.$lessinit$greater$default$1()), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(TestServer testServer) {
                        testServer.start();
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().withStreamingContext(new StreamingContext(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().conf(), this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration()), new Serializable(this, testServer){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$11 $outer;
                            private final TestServer testServer$2;

                            public final void apply(StreamingContext ssc) {
                                ssc.addStreamingListener((StreamingListener)ssc.progressListener());
                                BatchCounter batchCounter = new BatchCounter(ssc);
                                ReceiverInputDStream networkStream = ssc.socketTextStream("localhost", this.testServer$2.port(), StorageLevel$.MODULE$.MEMORY_AND_DISK());
                                ConcurrentLinkedQueue<Seq<T>> outputQueue = new ConcurrentLinkedQueue<Seq<T>>();
                                TestOutputStream<T> outputStream = new TestOutputStream<T>(networkStream, outputQueue, ClassTag$.MODULE$.apply(String.class));
                                outputStream.register();
                                ssc.start();
                                ManualClock clock = (ManualClock)ssc.scheduler().clock();
                                clock.advance(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration().milliseconds());
                                if (batchCounter.waitUntilBatchesCompleted(1, 30000L)) {
                                    networkStream.generatedRDDs().foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$11$$anonfun$apply$13 $outer;

                                        public final void apply(Tuple2<Time, RDD<String>> x0$1) {
                                            Tuple2<Time, RDD<String>> tuple2 = x0$1;
                                            if (tuple2 != null) {
                                                RDD rdd = (RDD)tuple2._2();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]"));
                                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    return;
                                }
                                throw this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().fail("Timeout: cannot finish all batches in 30 seconds");
                            }

                            public /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$11 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.testServer$2 = testServer$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("binary records stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ObjectRef testDir = ObjectRef.create(null);
                try {
                    Bool bool;
                    Duration batchDuration = Seconds$.MODULE$.apply(2L);
                    testDir.elem = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                    File existingFile = new File((File)testDir.elem, "0");
                    Files.write((CharSequence)"0\n", (File)existingFile, (Charset)StandardCharsets.UTF_8);
                    Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(existingFile.setLastModified(10000L), "existingFile.setLastModified(10000L)");
                    if ($org_scalatest_assert_macro_left.value()) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)existingFile.lastModified()));
                        int $org_scalatest_assert_macro_right = 10000;
                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    } else {
                        bool = Bool$.MODULE$.simpleMacroBool(false, "");
                    }
                    Bool $org_scalatest_assert_macro_right = bool;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), batchDuration), new Serializable(this, testDir, batchDuration, existingFile){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;
                        public final ObjectRef testDir$1;
                        public final Duration batchDuration$1;
                        private final File existingFile$1;

                        public final void apply(StreamingContext ssc) {
                            ManualClock clock = (ManualClock)ssc.scheduler().clock();
                            clock.setTime(this.existingFile$1.lastModified() + this.batchDuration$1.milliseconds());
                            BatchCounter batchCounter = new BatchCounter(ssc);
                            DStream fileStream = ssc.binaryRecordsStream(((File)this.testDir$1.elem).toString(), 1);
                            ConcurrentLinkedQueue<Seq<T>> outputQueue = new ConcurrentLinkedQueue<Seq<T>>();
                            TestOutputStream<T> outputStream = new TestOutputStream<T>(fileStream, outputQueue, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                            outputStream.register();
                            ssc.start();
                            clock.advance(this.batchDuration$1.milliseconds() / 2L);
                            int numCopies = 3;
                            byte[] input = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4, 5}), ClassTag$.MODULE$.Byte());
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numCopies).foreach$mVc$sp((Function1)new Serializable(this, clock, batchCounter, input){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$12 $outer;
                                private final ManualClock clock$2;
                                public final BatchCounter batchCounter$1;
                                private final byte[] input$2;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    Thread.sleep(this.$outer.batchDuration$1.milliseconds());
                                    File file = new File((File)this.$outer.testDir$1.elem, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                                    Files.write((byte[])((byte[])Predef$.MODULE$.byteArrayOps(this.input$2).map((Function1)new Serializable(this, i){
                                        public static final long serialVersionUID = 0L;
                                        private final int i$1;

                                        public final byte apply(byte b) {
                                            return (byte)(b + this.i$1);
                                        }
                                        {
                                            this.i$1 = i$1;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), (File)file);
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(file.setLastModified(this.clock$2.getTimeMillis()), "file.setLastModified(clock.getTimeMillis())");
                                    this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)file.lastModified()));
                                    long $org_scalatest_assert_macro_right = this.clock$2.getTimeMillis();
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                    this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, file){
                                        public static final long serialVersionUID = 0L;
                                        private final File file$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                                        }
                                        {
                                            this.file$1 = file$1;
                                        }
                                    });
                                    this.clock$2.advance(this.$outer.batchDuration$1.milliseconds());
                                    Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, i){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$12$$anonfun$apply$4 $outer;
                                        private final int i$1;

                                        public final void apply() {
                                            this.apply$mcV$sp();
                                        }

                                        public void apply$mcV$sp() {
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.batchCounter$1.getNumCompletedBatches()));
                                            int $org_scalatest_assert_macro_right = this.i$1;
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.i$1 = i$1;
                                        }
                                    }, Eventually$.MODULE$.patienceConfig());
                                }

                                public /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$12 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.clock$2 = clock$2;
                                    this.batchCounter$1 = batchCounter$1;
                                    this.input$2 = input$2;
                                }
                            });
                            Seq obtainedOutput = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputQueue).asScala()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Seq<Object> apply(Seq<byte[]> x$2) {
                                    return (Seq)x$2.flatten((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final ArrayOps<Object> apply(byte[] xs) {
                                            return Predef$.MODULE$.byteArrayOps(xs);
                                        }
                                    });
                                }
                            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                            obtainedOutput.indices().foreach$mVc$sp((Function1)new Serializable(this, input, obtainedOutput){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$12 $outer;
                                private final byte[] input$2;
                                private final Seq obtainedOutput$1;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(this.obtainedOutput$1.apply(i));
                                    byte[] $org_scalatest_assert_macro_right = (byte[])Predef$.MODULE$.byteArrayOps(this.input$2).map((Function1)new Serializable(this, i){
                                        public static final long serialVersionUID = 0L;
                                        private final int i$2;

                                        public final byte apply(byte b) {
                                            return (byte)(b + this.i$2);
                                        }
                                        {
                                            this.i$2 = i$2;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.input$2 = input$2;
                                    this.obtainedOutput$1 = obtainedOutput$1;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$3 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.testDir$1 = testDir$1;
                            this.batchDuration$1 = batchDuration$1;
                            this.existingFile$1 = existingFile$1;
                        }
                    });
                    return;
                }
                finally {
                    if ((File)testDir.elem != null) {
                        Utils$.MODULE$.deleteRecursively((File)testDir.elem);
                    }
                }
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("file input stream - newFilesOnly = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testFileStream(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("file input stream - newFilesOnly = false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testFileStream(false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("file input stream - wildcard", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                block5: {
                    File testDir = null;
                    try {
                        Bool bool;
                        Duration batchDuration = Seconds$.MODULE$.apply(2L);
                        testDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                        File testSubDir1 = Utils$.MODULE$.createDirectory(testDir.toString(), "tmp1");
                        File testSubDir2 = Utils$.MODULE$.createDirectory(testDir.toString(), "tmp2");
                        File existingFile = new File(testDir, "0");
                        Files.write((CharSequence)"0\n", (File)existingFile, (Charset)StandardCharsets.UTF_8);
                        Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(existingFile.setLastModified(10000L), "existingFile.setLastModified(10000L)");
                        if ($org_scalatest_assert_macro_left.value()) {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)existingFile.lastModified()));
                            int $org_scalatest_assert_macro_right = 10000;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        } else {
                            bool = Bool$.MODULE$.simpleMacroBool(false, "");
                        }
                        Bool $org_scalatest_assert_macro_right = bool;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        String pathWithWildCard = new StringBuilder().append((Object)testDir.toString()).append((Object)"/*/").toString();
                        this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), batchDuration), new Serializable(this, batchDuration, testSubDir1, testSubDir2, existingFile, pathWithWildCard){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;
                            private final Duration batchDuration$2;
                            public final File testSubDir1$1;
                            public final File testSubDir2$1;
                            private final File existingFile$2;
                            private final String pathWithWildCard$1;

                            public final void apply(StreamingContext ssc) {
                                ManualClock clock = (ManualClock)ssc.scheduler().clock();
                                clock.setTime(this.existingFile$2.lastModified() + this.batchDuration$2.milliseconds());
                                BatchCounter batchCounter = new BatchCounter(ssc);
                                DStream fileStream = ssc.fileStream(this.pathWithWildCard$1, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class)).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Tuple2<LongWritable, Text> x$3) {
                                        return ((Text)x$3._2()).toString();
                                    }
                                }, ClassTag$.MODULE$.apply(String.class));
                                ConcurrentLinkedQueue<Seq<T>> outputQueue = new ConcurrentLinkedQueue<Seq<T>>();
                                TestOutputStream<T> outputStream = new TestOutputStream<T>(fileStream, outputQueue, ClassTag$.MODULE$.apply(String.class));
                                outputStream.register();
                                ssc.start();
                                clock.advance(this.batchDuration$2.milliseconds() / 2L);
                                Seq input1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
                                input1.foreach((Function1)new Serializable(this, clock, batchCounter){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$13 $outer;
                                    private final ManualClock clock$3;
                                    private final BatchCounter batchCounter$2;

                                    public final void apply(int i) {
                                        this.apply$mcVI$sp(i);
                                    }

                                    public void apply$mcVI$sp(int i) {
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$createFileAndAdvenceTime$1(i, this.$outer.testSubDir1$1, this.clock$3, this.batchCounter$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.clock$3 = clock$3;
                                        this.batchCounter$2 = batchCounter$2;
                                    }
                                });
                                Seq input2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7, 8, 9, 10}));
                                input2.foreach((Function1)new Serializable(this, clock, batchCounter){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$13 $outer;
                                    private final ManualClock clock$3;
                                    private final BatchCounter batchCounter$2;

                                    public final void apply(int i) {
                                        this.apply$mcVI$sp(i);
                                    }

                                    public void apply$mcVI$sp(int i) {
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$createFileAndAdvenceTime$1(i, this.$outer.testSubDir2$1, this.clock$3, this.batchCounter$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.clock$3 = clock$3;
                                        this.batchCounter$2 = batchCounter$2;
                                    }
                                });
                                Set expectedOutput = ((TraversableOnce)((TraversableLike)input1.$plus$plus((GenTraversableOnce)input2, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(int x$4) {
                                        return ((Object)BoxesRunTime.boxToInteger((int)x$4)).toString();
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).toSet();
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(((TraversableOnce)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputQueue).asScala()).flatten((Function1)Predef$.MODULE$.$conforms())).toSet());
                                Set $org_scalatest_assert_macro_right = expectedOutput;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            }

                            public /* synthetic */ $anonfun$6 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }

                            public final void org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$createFileAndAdvenceTime$1(int data, File dir, ManualClock clock$3, BatchCounter batchCounter$2) {
                                File file = new File(this.testSubDir1$1, ((Object)BoxesRunTime.boxToInteger((int)data)).toString());
                                Files.write((CharSequence)new StringBuilder().append(data).append((Object)"\n").toString(), (File)file, (Charset)StandardCharsets.UTF_8);
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(file.setLastModified(clock$3.getTimeMillis()), "file.setLastModified(clock.getTimeMillis())");
                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)file.lastModified()));
                                long $org_scalatest_assert_macro_right = clock$3.getTimeMillis();
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, file){
                                    public static final long serialVersionUID = 0L;
                                    private final File file$2;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Created file ").append((Object)this.file$2).toString();
                                    }
                                    {
                                        this.file$2 = file$2;
                                    }
                                });
                                clock$3.advance(this.batchDuration$2.milliseconds());
                                Eventually$.MODULE$.eventually(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().eventuallyTimeout(), (Function0)new Serializable(this, batchCounter$2, data){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$13 $outer;
                                    private final BatchCounter batchCounter$2;
                                    private final int data$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.batchCounter$2.getNumCompletedBatches()));
                                        int $org_scalatest_assert_macro_right = this.data$1;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.batchCounter$2 = batchCounter$2;
                                        this.data$1 = data$1;
                                    }
                                }, Eventually$.MODULE$.patienceConfig());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.batchDuration$2 = batchDuration$2;
                                this.testSubDir1$1 = testSubDir1$1;
                                this.testSubDir2$1 = testSubDir2$1;
                                this.existingFile$2 = existingFile$2;
                                this.pathWithWildCard$1 = pathWithWildCard$1;
                            }
                        });
                        if (testDir == null) break block5;
                    }
                    catch (Throwable throwable) {
                        if (testDir != null) {
                            Utils$.MODULE$.deleteRecursively(testDir);
                        }
                        throw throwable;
                    }
                    Utils$.MODULE$.deleteRecursively(testDir);
                }
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multi-thread receiver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numThreads = 10;
                int numRecordsPerThread = 1000;
                int numTotalRecords = numThreads * numRecordsPerThread;
                MultiThreadTestReceiver testReceiver = new MultiThreadTestReceiver(numThreads, numRecordsPerThread);
                MultiThreadTestReceiver$.MODULE$.haveAllThreadsFinished_$eq(false);
                ConcurrentLinkedQueue<E> outputQueue = new ConcurrentLinkedQueue<E>();
                this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), this.$outer.batchDuration()), new Serializable(this, numTotalRecords, testReceiver, outputQueue){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final int numTotalRecords$1;
                    private final MultiThreadTestReceiver testReceiver$1;
                    private final ConcurrentLinkedQueue outputQueue$2;

                    public final void apply(StreamingContext ssc) {
                        ReceiverInputDStream networkStream = ssc.receiverStream((Receiver)this.testReceiver$1, ClassTag$.MODULE$.Int());
                        DStream countStream = networkStream.count();
                        TestOutputStream<T> outputStream = new TestOutputStream<T>(countStream, this.outputQueue$2, ClassTag$.MODULE$.Long());
                        outputStream.register();
                        ssc.start();
                        ManualClock clock = (ManualClock)ssc.scheduler().clock();
                        long startTime = System.currentTimeMillis();
                        while (!(MultiThreadTestReceiver$.MODULE$.haveAllThreadsFinished() && BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$output$2(this.outputQueue$2).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) >= (long)this.numTotalRecords$1 || System.currentTimeMillis() - startTime >= 5000L)) {
                            Thread.sleep(100L);
                            clock.advance(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration().milliseconds());
                        }
                        Thread.sleep(1000L);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numTotalRecords$1 = numTotalRecords$1;
                        this.testReceiver$1 = testReceiver$1;
                        this.outputQueue$2 = outputQueue$2;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "--------------------------------";
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this, outputQueue){
                    public static final long serialVersionUID = 0L;
                    private final ConcurrentLinkedQueue outputQueue$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.outputQueue$2.size())).toString();
                    }
                    {
                        this.outputQueue$2 = outputQueue$2;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "output";
                    }
                });
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputQueue).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(Seq<Object> x) {
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final Seq x$21;

                            public final String apply() {
                                return new StringBuilder().append((Object)"[").append((Object)this.x$21.mkString(",")).append((Object)"]").toString();
                            }
                            {
                                this.x$21 = x$21;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "--------------------------------";
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$output$2(outputQueue).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                int $org_scalatest_assert_macro_right = numTotalRecords;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final Iterable org$apache$spark$streaming$InputStreamsSuite$$anonfun$$output$2(ConcurrentLinkedQueue outputQueue$2) {
                return (Iterable)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)outputQueue$2).asScala()).flatten((Function1)Predef$.MODULE$.$conforms());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("queue input stream - oneAtATime = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq input = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3", "4", "5"}));
                Seq expectedOutput = (Seq)input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(String x$5) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$5}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                ConcurrentLinkedQueue<E> outputQueue = new ConcurrentLinkedQueue<E>();
                this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), this.$outer.batchDuration()), new Serializable(this, input, outputQueue){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final Seq input$3;
                    private final ConcurrentLinkedQueue outputQueue$3;

                    public final void apply(StreamingContext ssc) {
                        Queue queue = new Queue();
                        InputDStream queueStream = ssc.queueStream(queue, true, ClassTag$.MODULE$.apply(String.class));
                        TestOutputStream<T> outputStream = new TestOutputStream<T>(queueStream, this.outputQueue$3, ClassTag$.MODULE$.apply(String.class));
                        outputStream.register();
                        ssc.start();
                        ManualClock clock = (ManualClock)ssc.scheduler().clock();
                        Iterator inputIterator = this.input$3.toIterator();
                        this.input$3.indices().foreach$mVc$sp((Function1)new Serializable(this, queue, clock, inputIterator, ssc){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$20 $outer;
                            public final Queue queue$1;
                            private final ManualClock clock$4;
                            private final Iterator inputIterator$1;
                            public final StreamingContext ssc$2;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.inputIterator$1.take(2).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$20$$anonfun$apply$8 $outer;

                                    public final Queue<RDD<String>> apply(String i) {
                                        Queue queue = this.$outer.queue$1;
                                        synchronized (queue) {
                                            SparkContext qual$1 = this.$outer.ssc$2.sparkContext();
                                            Seq x$13 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{i}));
                                            int x$14 = qual$1.makeRDD$default$2();
                                            MutableList mutableList = this.$outer.queue$1.$plus$eq((Object)qual$1.makeRDD(x$13, x$14, ClassTag$.MODULE$.apply(String.class)));
                                            return (Queue)mutableList;
                                        }
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                this.clock$4.advance(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration().milliseconds());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.queue$1 = queue$1;
                                this.clock$4 = clock$4;
                                this.inputIterator$1 = inputIterator$1;
                                this.ssc$2 = ssc$2;
                            }
                        });
                        Thread.sleep(1000L);
                    }

                    public /* synthetic */ $anonfun$8 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.input$3 = input$3;
                        this.outputQueue$3 = outputQueue$3;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "--------------------------------";
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this, outputQueue){
                    public static final long serialVersionUID = 0L;
                    private final ConcurrentLinkedQueue outputQueue$3;

                    public final String apply() {
                        return new StringBuilder().append((Object)"output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.outputQueue$3.size())).toString();
                    }
                    {
                        this.outputQueue$3 = outputQueue$3;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "output";
                    }
                });
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputQueue).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Seq<String> x) {
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final Seq x$22;

                            public final String apply() {
                                return new StringBuilder().append((Object)"[").append((Object)this.x$22.mkString(",")).append((Object)"]").toString();
                            }
                            {
                                this.x$22 = x$22;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this, expectedOutput){
                    public static final long serialVersionUID = 0L;
                    private final Seq expectedOutput$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"expected output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.expectedOutput$2.size())).toString();
                    }
                    {
                        this.expectedOutput$2 = expectedOutput$2;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "expected output";
                    }
                });
                expectedOutput.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Seq<String> x) {
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final Seq x$23;

                            public final String apply() {
                                return new StringBuilder().append((Object)"[").append((Object)this.x$23.mkString(",")).append((Object)"]").toString();
                            }
                            {
                                this.x$23 = x$23;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "--------------------------------";
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.output$3(outputQueue).size()));
                int $org_scalatest_assert_macro_right = expectedOutput.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ((IterableLike)this.output$3(outputQueue).zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, expectedOutput){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final Seq expectedOutput$2;

                    public final void apply(Tuple2<Seq<String>, Object> x0$2) {
                        Tuple2<Seq<String>, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Seq e = (Seq)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            Seq $org_scalatest_assert_macro_left = e;
                            Seq $org_scalatest_assert_macro_right = (Seq)this.expectedOutput$2.apply(i);
                            Seq seq = $org_scalatest_assert_macro_left;
                            Seq seq2 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null));
                            this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.expectedOutput$2 = expectedOutput$2;
                    }
                });
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Iterable output$3(ConcurrentLinkedQueue outputQueue$3) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)outputQueue$3).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Seq<String> x$6) {
                        return x$6.nonEmpty();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("queue input stream - oneAtATime = false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ConcurrentLinkedQueue<E> outputQueue = new ConcurrentLinkedQueue<E>();
                Seq input = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3", "4", "5"}));
                Seq expectedOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4", "5"}))}));
                this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), this.$outer.batchDuration()), new Serializable(this, outputQueue, input){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final ConcurrentLinkedQueue outputQueue$4;
                    private final Seq input$4;

                    public final void apply(StreamingContext ssc) {
                        Queue queue = new Queue();
                        InputDStream queueStream = ssc.queueStream(queue, false, ClassTag$.MODULE$.apply(String.class));
                        TestOutputStream<T> outputStream = new TestOutputStream<T>(queueStream, this.outputQueue$4, ClassTag$.MODULE$.apply(String.class));
                        outputStream.register();
                        ssc.start();
                        ManualClock clock = (ManualClock)ssc.scheduler().clock();
                        Iterator inputIterator = this.input$4.toIterator();
                        inputIterator.take(3).foreach((Function1)new Serializable(this, queue, ssc){
                            public static final long serialVersionUID = 0L;
                            private final Queue queue$2;
                            private final StreamingContext ssc$3;

                            public final Queue<RDD<String>> apply(String i) {
                                Queue queue = this.queue$2;
                                synchronized (queue) {
                                    SparkContext qual$2 = this.ssc$3.sparkContext();
                                    Seq x$15 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{i}));
                                    int x$16 = qual$2.makeRDD$default$2();
                                    MutableList mutableList = this.queue$2.$plus$eq((Object)qual$2.makeRDD(x$15, x$16, ClassTag$.MODULE$.apply(String.class)));
                                    return (Queue)mutableList;
                                }
                            }
                            {
                                this.queue$2 = queue$2;
                                this.ssc$3 = ssc$3;
                            }
                        });
                        clock.advance(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration().milliseconds());
                        Thread.sleep(1000L);
                        inputIterator.foreach((Function1)new Serializable(this, queue, ssc){
                            public static final long serialVersionUID = 0L;
                            private final Queue queue$2;
                            private final StreamingContext ssc$3;

                            public final Queue<RDD<String>> apply(String i) {
                                Queue queue = this.queue$2;
                                synchronized (queue) {
                                    SparkContext qual$3 = this.ssc$3.sparkContext();
                                    Seq x$17 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{i}));
                                    int x$18 = qual$3.makeRDD$default$2();
                                    MutableList mutableList = this.queue$2.$plus$eq((Object)qual$3.makeRDD(x$17, x$18, ClassTag$.MODULE$.apply(String.class)));
                                    return (Queue)mutableList;
                                }
                            }
                            {
                                this.queue$2 = queue$2;
                                this.ssc$3 = ssc$3;
                            }
                        });
                        clock.advance(this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().batchDuration().milliseconds());
                        Thread.sleep(1000L);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.outputQueue$4 = outputQueue$4;
                        this.input$4 = input$4;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "--------------------------------";
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this, outputQueue){
                    public static final long serialVersionUID = 0L;
                    private final ConcurrentLinkedQueue outputQueue$4;

                    public final String apply() {
                        return new StringBuilder().append((Object)"output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.outputQueue$4.size())).toString();
                    }
                    {
                        this.outputQueue$4 = outputQueue$4;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "output";
                    }
                });
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputQueue).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(Seq<String> x) {
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final Seq x$24;

                            public final String apply() {
                                return new StringBuilder().append((Object)"[").append((Object)this.x$24.mkString(",")).append((Object)"]").toString();
                            }
                            {
                                this.x$24 = x$24;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this, expectedOutput){
                    public static final long serialVersionUID = 0L;
                    private final Seq expectedOutput$3;

                    public final String apply() {
                        return new StringBuilder().append((Object)"expected output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.expectedOutput$3.size())).toString();
                    }
                    {
                        this.expectedOutput$3 = expectedOutput$3;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "expected output";
                    }
                });
                expectedOutput.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(Seq<String> x) {
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final Seq x$25;

                            public final String apply() {
                                return new StringBuilder().append((Object)"[").append((Object)this.x$25.mkString(",")).append((Object)"]").toString();
                            }
                            {
                                this.x$25 = x$25;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "--------------------------------";
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.output$4(outputQueue).size()));
                int $org_scalatest_assert_macro_right = expectedOutput.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ((IterableLike)this.output$4(outputQueue).zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, expectedOutput){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final Seq expectedOutput$3;

                    public final void apply(Tuple2<Seq<String>, Object> x0$3) {
                        Tuple2<Seq<String>, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            Seq e = (Seq)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            Seq $org_scalatest_assert_macro_left = e;
                            Seq $org_scalatest_assert_macro_right = (Seq)this.expectedOutput$3.apply(i);
                            Seq seq = $org_scalatest_assert_macro_left;
                            Seq seq2 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null));
                            this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.expectedOutput$3 = expectedOutput$3;
                    }
                });
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Iterable output$4(ConcurrentLinkedQueue outputQueue$4) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)outputQueue$4).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Seq<String> x$7) {
                        return x$7.nonEmpty();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("test track the number of input stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InputStreamsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withStreamingContext(new StreamingContext(this.$outer.conf(), this.$outer.batchDuration()), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(StreamingContext ssc) {
                        public class Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1
                        extends ReceiverInputDStream<String> {
                            public final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$40 $outer;

                            public Receiver<String> getReceiver() {
                                return null;
                            }

                            public /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$40 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$TestReceiverInputDStream$$$outer() {
                                return this.$outer;
                            }

                            public Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1($anonfun$10$$anonfun$apply$mcV$sp$40 $outer, StreamingContext ssc$4) {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(ssc$4, ClassTag$.MODULE$.apply(String.class));
                            }
                        }
                        Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1[] receiverInputStreams = (Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1[])((Object[])new Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1[]{new Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1(this, ssc), new Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1(this, ssc)});
                        public class Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1
                        extends InputDStream<String> {
                            public final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$40 $outer;

                            public void start() {
                            }

                            public void stop() {
                            }

                            public Option<RDD<String>> compute(Time validTime) {
                                return None$.MODULE$;
                            }

                            public /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$40 org$apache$spark$streaming$InputStreamsSuite$$anonfun$$anonfun$TestInputDStream$$$outer() {
                                return this.$outer;
                            }

                            public Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1($anonfun$10$$anonfun$apply$mcV$sp$40 $outer, StreamingContext ssc$4) {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(ssc$4, ClassTag$.MODULE$.apply(String.class));
                            }
                        }
                        Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1[] inputStreams = (Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1[])((Object[])new Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1[]{new Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1(this, ssc), new Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1(this, ssc), new Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestInputDStream$1(this, ssc)});
                        InputDStream[] $org_scalatest_assert_macro_left = ssc.graph().getInputStreams();
                        int $org_scalatest_assert_macro_right = receiverInputStreams.length + inputStreams.length;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right));
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        ReceiverInputDStream[] $org_scalatest_assert_macro_left2 = ssc.graph().getReceiverInputStreams();
                        int $org_scalatest_assert_macro_right2 = receiverInputStreams.length;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2));
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(ssc.graph().getReceiverInputStreams());
                        Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1[] $org_scalatest_assert_macro_right3 = receiverInputStreams;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getInputStreams()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(InputDStream<?> x$8) {
                                return x$8.id();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                        int[] $org_scalatest_assert_macro_right4 = (int[])Array$.MODULE$.tabulate(5, (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int i) {
                                return this.apply$mcII$sp(i);
                            }

                            public int apply$mcII$sp(int i) {
                                return i;
                            }
                        }, ClassTag$.MODULE$.Int());
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])receiverInputStreams).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Org_apache_spark_streaming_InputStreamsSuite$$anonfun$10$$anonfun$apply$mcV$sp$40$TestReceiverInputDStream$1 x$9) {
                                return x$9.id();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                        int[] $org_scalatest_assert_macro_right5 = new int[]{0, 1};
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ InputStreamsSuite org$apache$spark$streaming$InputStreamsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

