/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.util.BatchedWriteAheadLog;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.streaming.util.WriteAheadLogUtilsSuite$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u00015\u0011qc\u0016:ji\u0016\f\u0005.Z1e\u0019><W\u000b^5mgN+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002A1A\u0005\ne\ta\u0001\\8h\t&\u0014X#\u0001\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012\u0001\u00027b]\u001eT\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t11\u000b\u001e:j]\u001eDaa\t\u0001!\u0002\u0013Q\u0012a\u00027pO\u0012K'\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0005G>tgM\u0003\u0002-\u0011\u00051\u0001.\u00193p_BL!AL\u0015\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0019\u0001\u0004\u0001)A\u0005O\u0005Y\u0001.\u00193p_B\u001cuN\u001c4!\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003Q\t7o]3si\u0012\u0013\u0018N^3s\u0019><7\t\\1tgV\u0011A'\u0012\u000b\u0004k1\u0003FC\u0001\u001c:!\t1r'\u0003\u00029\u0005\tiqK]5uK\u0006CW-\u00193M_\u001eDqAO\u0019\u0002\u0002\u0003\u000f1(\u0001\u0006fm&$WM\\2fIE\u00022\u0001P!D\u001b\u0005i$B\u0001 @\u0003\u001d\u0011XM\u001a7fGRT\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005v\u0012\u0001b\u00117bgN$\u0016m\u001a\t\u0003\t\u0016c\u0001\u0001B\u0003Gc\t\u0007qIA\u0001U#\tAe\u0007\u0005\u0002J\u00156\tq(\u0003\u0002L\u007f\t9aj\u001c;iS:<\u0007\"\u0002\u00162\u0001\u0004i\u0005CA\bO\u0013\tyeAA\u0005Ta\u0006\u00148nQ8oM\"9\u0011+\rI\u0001\u0002\u0004\u0011\u0016!C5t\u0005\u0006$8\r[3e!\tI5+\u0003\u0002U\u007f\t9!i\\8mK\u0006t\u0007\"\u0002,\u0001\t\u00039\u0016AF1tg\u0016\u0014HOU3dK&4XM\u001d'pO\u000ec\u0017m]:\u0016\u0005asFCA-`)\t1$\fC\u0004\\+\u0006\u0005\t9\u0001/\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002=\u0003v\u0003\"\u0001\u00120\u0005\u000b\u0019+&\u0019A$\t\u000b)*\u0006\u0019A'\t\u000f\u0005\u0004\u0011\u0013!C\u0001E\u0006q\u0012m]:feR$%/\u001b<fe2{wm\u00117bgN$C-\u001a4bk2$HEM\u000b\u0003G:,\u0012\u0001\u001a\u0016\u0003%\u0016\\\u0013A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-|\u0014AC1o]>$\u0018\r^5p]&\u0011Q\u000e\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002$a\u0005\u00049u!\u00029\u0003\u0011\u0003\t\u0018aF,sSR,\u0017\t[3bI2{w-\u0016;jYN\u001cV/\u001b;f!\t1\"OB\u0003\u0002\u0005!\u00051oE\u0002si^\u0004\"!S;\n\u0005Y|$AB!osJ+g\r\u0005\u0002Jq&\u0011\u0011p\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006'I$\ta\u001f\u000b\u0002c\u001a!QP\u001d\u0001\u007f\u0005IiunY6Xe&$X-\u00115fC\u0012dun\u001a\u0019\u0014\u0005q4\u0004BB\n}\t\u0003\t\t\u0001\u0006\u0002\u0002\u0004A\u0019\u0011Q\u0001?\u000e\u0003IDq!!\u0003}\t\u0003\nY!A\u0003xe&$X\r\u0006\u0004\u0002\u000e\u0005M\u00111\u0005\t\u0004-\u0005=\u0011bAA\t\u0005\tIrK]5uK\u0006CW-\u00193M_\u001e\u0014VmY8sI\"\u000bg\u000e\u001a7f\u0011!\t)\"a\u0002A\u0002\u0005]\u0011A\u0002:fG>\u0014H\r\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiBH\u0001\u0004]&|\u0017\u0002BA\u0011\u00037\u0011!BQ=uK\n+hMZ3s\u0011!\t)#a\u0002A\u0002\u0005\u001d\u0012\u0001\u0002;j[\u0016\u00042!SA\u0015\u0013\r\tYc\u0010\u0002\u0005\u0019>tw\rC\u0004\u00020q$\t%!\r\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003/\t\u0019\u0004\u0003\u0005\u00026\u00055\u0002\u0019AA\u0007\u0003\u0019A\u0017M\u001c3mK\"9\u0011\u0011\b?\u0005B\u0005m\u0012a\u0002:fC\u0012\fE\u000e\u001c\u000b\u0003\u0003{\u0001b!a\u0010\u0002D\u0005]QBAA!\u0015\t\u0019a$\u0003\u0003\u0002F\u0005\u0005#\u0001C%uKJ\fGo\u001c:\t\u000f\u0005%C\u0010\"\u0011\u0002L\u0005)1\r\\3b]R1\u0011QJA*\u0003/\u00022!SA(\u0013\r\t\tf\u0010\u0002\u0005+:LG\u000f\u0003\u0005\u0002V\u0005\u001d\u0003\u0019AA\u0014\u0003)!\bN]3tQRKW.\u001a\u0005\b\u00033\n9\u00051\u0001S\u0003E9\u0018-\u001b;G_J\u001cu.\u001c9mKRLwN\u001c\u0005\b\u0003;bH\u0011IA0\u0003\u0015\u0019Gn\\:f)\t\tiE\u0002\u0004\u0002dI\u0004\u0011Q\r\u0002\u0013\u001b>\u001c7n\u0016:ji\u0016\f\u0005.Z1e\u0019><\u0017g\u0005\u0003\u0002b\u0005\r\u0001B\u0003\u0016\u0002b\t\u0015\r\u0011\"\u0001\u0002jU\tQ\n\u0003\u0006\u0002n\u0005\u0005$\u0011!Q\u0001\n5\u000bQaY8oM\u0002BqaEA1\t\u0003\t\t\b\u0006\u0003\u0002t\u0005U\u0004\u0003BA\u0003\u0003CBaAKA8\u0001\u0004ieABA=e\u0002\tYH\u0001\nN_\u000e\\wK]5uK\u0006CW-\u00193M_\u001e\u00144\u0003BA<\u0003\u0007A!BKA<\u0005\u000b\u0007I\u0011AA5\u0011)\ti'a\u001e\u0003\u0002\u0003\u0006I!\u0014\u0005\f\u0003\u0007\u000b9H!A!\u0002\u0013\t))A\u0001y!\rI\u0015qQ\u0005\u0004\u0003\u0013{$aA%oi\"91#a\u001e\u0005\u0002\u00055ECBAH\u0003#\u000b\u0019\n\u0005\u0003\u0002\u0006\u0005]\u0004B\u0002\u0016\u0002\f\u0002\u0007Q\n\u0003\u0005\u0002\u0004\u0006-\u0005\u0019AAC\u0011%\t9J]A\u0001\n\u0013\tI*A\u0006sK\u0006$'+Z:pYZ,GCAAN!\rY\u0012QT\u0005\u0004\u0003?c\"AB(cU\u0016\u001cG\u000f")
public class WriteAheadLogUtilsSuite
extends SparkFunSuite {
    private final String logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
    private final Configuration hadoopConf = new Configuration();

    private String logDir() {
        return this.logDir;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public <T extends WriteAheadLog> WriteAheadLog assertDriverLogClass(SparkConf conf, boolean isBatched, ClassTag<T> evidence$1) {
        WriteAheadLog log = WriteAheadLogUtils$.MODULE$.createLogForDriver(conf, this.logDir(), this.hadoopConf());
        if (isBatched) {
            WriteAheadLog $org_scalatest_assert_macro_left = log;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.streaming.util.BatchedWriteAheadLog", $org_scalatest_assert_macro_left instanceof BatchedWriteAheadLog);
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            WriteAheadLog parentLog = ((BatchedWriteAheadLog)log).wrappedLog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(parentLog.getClass());
            Class $org_scalatest_assert_macro_right = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        } else {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(log.getClass());
            Class $org_scalatest_assert_macro_right = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        }
        return log;
    }

    public <T extends WriteAheadLog> boolean assertDriverLogClass$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public <T extends WriteAheadLog> WriteAheadLog assertReceiverLogClass(SparkConf conf, ClassTag<T> evidence$2) {
        void var3_3;
        WriteAheadLog log = WriteAheadLogUtils$.MODULE$.createLogForReceiver(conf, this.logDir(), this.hadoopConf());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(log.getClass());
        Class $org_scalatest_assert_macro_right = ((ClassTag)Predef$.MODULE$.implicitly(evidence$2)).runtimeClass();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        return var3_3;
    }

    public WriteAheadLogUtilsSuite() {
        this.test("log selection and creation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf emptyConf = new SparkConf();
                this.$outer.assertDriverLogClass(emptyConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                this.$outer.assertReceiverLogClass(emptyConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                SparkConf driverWALConf = new SparkConf().set("spark.streaming.driver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
                this.$outer.assertDriverLogClass(driverWALConf, true, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
                this.$outer.assertReceiverLogClass(driverWALConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                SparkConf receiverWALConf = new SparkConf().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
                this.$outer.assertDriverLogClass(receiverWALConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                this.$outer.assertReceiverLogClass(receiverWALConf, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
                SparkConf receiverWALConf2 = new SparkConf().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog1.class.getName());
                this.$outer.assertReceiverLogClass(receiverWALConf2, ClassTag$.MODULE$.apply(MockWriteAheadLog1.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final WriteAheadLog apply() {
                        SparkConf receiverWALConf3 = new SparkConf().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog2.class.getName());
                        return this.$outer.org$apache$spark$streaming$util$WriteAheadLogUtilsSuite$$anonfun$$$outer().assertReceiverLogClass(receiverWALConf3, ClassTag$.MODULE$.apply(MockWriteAheadLog1.class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }

            public /* synthetic */ WriteAheadLogUtilsSuite org$apache$spark$streaming$util$WriteAheadLogUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("wrap WriteAheadLog in BatchedWriteAheadLog when batching is enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf justBatchingConf = this.getBatchedSparkConf$1();
                this.$outer.assertDriverLogClass(justBatchingConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                this.$outer.assertReceiverLogClass(justBatchingConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                SparkConf driverWALConf = this.getBatchedSparkConf$1().set("spark.streaming.driver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
                this.$outer.assertDriverLogClass(driverWALConf, true, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
                this.$outer.assertReceiverLogClass(driverWALConf, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                SparkConf receiverWALConf = this.getBatchedSparkConf$1().set("spark.streaming.receiver.writeAheadLog.class", MockWriteAheadLog0.class.getName());
                this.$outer.assertDriverLogClass(receiverWALConf, true, ClassTag$.MODULE$.apply(FileBasedWriteAheadLog.class));
                this.$outer.assertReceiverLogClass(receiverWALConf, ClassTag$.MODULE$.apply(MockWriteAheadLog0.class));
            }

            private final SparkConf getBatchedSparkConf$1() {
                return new SparkConf().set("spark.streaming.driver.writeAheadLog.allowBatching", "true");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("batching is enabled by default in WriteAheadLog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = new SparkConf();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.isBatchingEnabled(conf, true), "WriteAheadLogUtils.isBatchingEnabled(conf, true)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.isBatchingEnabled(conf, false), "WriteAheadLogUtils.isBatchingEnabled(conf, false)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("closeFileAfterWrite is disabled by default in WriteAheadLog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WriteAheadLogUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = new SparkConf();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.shouldCloseFileAfterWrite(conf, true), "WriteAheadLogUtils.shouldCloseFileAfterWrite(conf, true)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(WriteAheadLogUtils$.MODULE$.shouldCloseFileAfterWrite(conf, false), "WriteAheadLogUtils.shouldCloseFileAfterWrite(conf, false)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class MockWriteAheadLog0
    extends WriteAheadLog {
        public WriteAheadLogRecordHandle write(ByteBuffer record, long time) {
            return null;
        }

        public ByteBuffer read(WriteAheadLogRecordHandle handle) {
            return null;
        }

        public Iterator<ByteBuffer> readAll() {
            return null;
        }

        public void clean(long threshTime, boolean waitForCompletion) {
        }

        public void close() {
        }
    }

    public static class MockWriteAheadLog1
    extends MockWriteAheadLog0 {
        private final SparkConf conf;

        public SparkConf conf() {
            return this.conf;
        }

        public MockWriteAheadLog1(SparkConf conf) {
            this.conf = conf;
        }
    }

    public static class MockWriteAheadLog2
    extends MockWriteAheadLog0 {
        private final SparkConf conf;

        public SparkConf conf() {
            return this.conf;
        }

        public MockWriteAheadLog2(SparkConf conf, int x) {
            this.conf = conf;
        }
    }
}

