/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils;
import org.junit.Assert;
import org.junit.Test;
import org.spark_project.guava.collect.Iterators;

public class JavaWriteAheadLogSuite
extends WriteAheadLog {
    private int index = -1;
    private final List<Record> records = new ArrayList<Record>();

    public WriteAheadLogRecordHandle write(ByteBuffer record, long time) {
        ++this.index;
        this.records.add(new Record(time, this.index, record));
        return new JavaWriteAheadLogSuiteHandle(this.index);
    }

    public ByteBuffer read(WriteAheadLogRecordHandle handle) {
        if (handle instanceof JavaWriteAheadLogSuiteHandle) {
            int reqdIndex = ((JavaWriteAheadLogSuiteHandle)handle).index;
            for (Record record : this.records) {
                if (record.index != reqdIndex) continue;
                return record.buffer;
            }
        }
        return null;
    }

    public Iterator<ByteBuffer> readAll() {
        return Iterators.transform(this.records.iterator(), input -> input.buffer);
    }

    public void clean(long threshTime, boolean waitForCompletion) {
        for (int i = 0; i < this.records.size(); ++i) {
            if (this.records.get((int)i).time >= threshTime) continue;
            this.records.remove(i);
            --i;
        }
    }

    public void close() {
        this.records.clear();
    }

    @Test
    public void testCustomWAL() {
        SparkConf conf = new SparkConf();
        conf.set("spark.streaming.driver.writeAheadLog.class", JavaWriteAheadLogSuite.class.getName());
        conf.set("spark.streaming.driver.writeAheadLog.allowBatching", "false");
        WriteAheadLog wal = WriteAheadLogUtils.createLogForDriver((SparkConf)conf, null, null);
        String data1 = "data1";
        WriteAheadLogRecordHandle handle = wal.write(JavaUtils.stringToBytes((String)data1), 1234L);
        Assert.assertTrue((boolean)(handle instanceof JavaWriteAheadLogSuiteHandle));
        Assert.assertEquals((Object)data1, (Object)JavaUtils.bytesToString((ByteBuffer)wal.read(handle)));
        wal.write(JavaUtils.stringToBytes((String)"data2"), 1235L);
        wal.write(JavaUtils.stringToBytes((String)"data3"), 1236L);
        wal.write(JavaUtils.stringToBytes((String)"data4"), 1237L);
        wal.clean(1236L, false);
        Iterator dataIterator = wal.readAll();
        ArrayList<String> readData = new ArrayList<String>();
        while (dataIterator.hasNext()) {
            readData.add(JavaUtils.bytesToString((ByteBuffer)((ByteBuffer)dataIterator.next())));
        }
        Assert.assertEquals(readData, Arrays.asList("data3", "data4"));
    }

    static class Record {
        long time;
        int index;
        ByteBuffer buffer;

        Record(long tym, int idx, ByteBuffer buf) {
            this.index = idx;
            this.time = tym;
            this.buffer = buf;
        }
    }

    static class JavaWriteAheadLogSuiteHandle
    extends WriteAheadLogRecordHandle {
        int index = -1;

        JavaWriteAheadLogSuiteHandle(int idx) {
            this.index = idx;
        }
    }
}

