/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.File;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.SparkConf;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestInputStream;
import org.apache.spark.streaming.TestOutputStreamWithPartitions;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.TestSuiteBase$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class TestSuiteBase$class {
    public static String framework(TestSuiteBase $this) {
        return $this.getClass().getSimpleName();
    }

    public static String master(TestSuiteBase $this) {
        return "local[2]";
    }

    public static Duration batchDuration(TestSuiteBase $this) {
        return Seconds$.MODULE$.apply(1L);
    }

    public static String checkpointDir(TestSuiteBase $this) {
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        $this.logDebug((Function0)new Serializable($this, dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointDir: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1}));
            }
            {
                this.dir$1 = dir$1;
            }
        });
        return dir.toString();
    }

    public static int numInputPartitions(TestSuiteBase $this) {
        return 2;
    }

    public static int maxWaitTimeMillis(TestSuiteBase $this) {
        return 10000;
    }

    public static boolean useManualClock(TestSuiteBase $this) {
        return true;
    }

    public static boolean actuallyWait(TestSuiteBase $this) {
        return false;
    }

    public static void beforeFunction(TestSuiteBase $this) {
        if ($this.useManualClock()) {
            $this.logInfo((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using manual clock";
                }
            });
            $this.conf().set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
        } else {
            $this.logInfo((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using real clock";
                }
            });
            $this.conf().set("spark.streaming.clock", "org.apache.spark.util.SystemClock");
        }
    }

    public static void afterFunction(TestSuiteBase $this) {
        System.clearProperty("spark.streaming.clock");
    }

    public static Object withStreamingContext(TestSuiteBase $this, StreamingContext ssc, Function1 block) {
        Object object;
        try {
            object = block.apply((Object)ssc);
        }
        catch (Throwable throwable) {
            try {
                ssc.stop(true);
            }
            catch (Exception exception) {
                $this.logError((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error stopping StreamingContext";
                    }
                }, exception);
            }
            throw throwable;
        }
        try {
            ssc.stop(true);
        }
        catch (Exception exception) {
            $this.logError((Function0)new /* invalid duplicate definition of identical inner class */, exception);
        }
        return object;
    }

    public static Object withTestServer(TestSuiteBase $this, TestServer testServer, Function1 block) {
        Object object;
        try {
            object = block.apply((Object)testServer);
        }
        catch (Throwable throwable) {
            try {
                testServer.stop();
            }
            catch (Exception exception) {
                $this.logError((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error stopping TestServer";
                    }
                }, exception);
            }
            throw throwable;
        }
        try {
            testServer.stop();
        }
        catch (Exception exception) {
            $this.logError((Function0)new /* invalid duplicate definition of identical inner class */, exception);
        }
        return object;
    }

    public static StreamingContext setupStreams(TestSuiteBase $this, Seq input, Function1 operation2, int numPartitions, ClassTag evidence$4, ClassTag evidence$5) {
        StreamingContext ssc = new StreamingContext($this.conf(), $this.batchDuration());
        if ($this.checkpointDir() != null) {
            ssc.checkpoint($this.checkpointDir());
        }
        TestInputStream inputStream = new TestInputStream(ssc, input, numPartitions, evidence$4);
        DStream operatedStream = (DStream)operation2.apply(inputStream);
        TestOutputStreamWithPartitions outputStream = new TestOutputStreamWithPartitions(operatedStream, new ConcurrentLinkedQueue(), evidence$5);
        outputStream.register();
        return ssc;
    }

    public static StreamingContext setupStreams(TestSuiteBase $this, Seq input1, Seq input2, Function2 operation2, ClassTag evidence$6, ClassTag evidence$7, ClassTag evidence$8) {
        StreamingContext ssc = new StreamingContext($this.conf(), $this.batchDuration());
        if ($this.checkpointDir() != null) {
            ssc.checkpoint($this.checkpointDir());
        }
        TestInputStream inputStream1 = new TestInputStream(ssc, input1, $this.numInputPartitions(), evidence$6);
        TestInputStream inputStream2 = new TestInputStream(ssc, input2, $this.numInputPartitions(), evidence$7);
        DStream operatedStream = (DStream)operation2.apply(inputStream1, inputStream2);
        TestOutputStreamWithPartitions outputStream = new TestOutputStreamWithPartitions(operatedStream, new ConcurrentLinkedQueue(), evidence$8);
        outputStream.register();
        return ssc;
    }

    public static int setupStreams$default$3(TestSuiteBase $this) {
        return $this.numInputPartitions();
    }

    public static Seq runStreams(TestSuiteBase $this, StreamingContext ssc, int numBatches, int numExpectedOutput, Function0 preStop, ClassTag evidence$9) {
        return (Seq)$this.runStreamsWithPartitions(ssc, numBatches, numExpectedOutput, (Function0<BoxedUnit>)preStop, evidence$9).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<V> apply(Seq<Seq<V>> x$2) {
                return ((SeqLike)x$2.flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Function0 runStreams$default$4(TestSuiteBase $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        };
    }

    public static Seq runStreamsWithPartitions(TestSuiteBase $this, StreamingContext ssc, int numBatches, int numExpectedOutput, Function0 preStop, ClassTag evidence$10) {
        int $org_scalatest_assert_macro_left = numBatches;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Number of batches to run stream computation is zero", Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        int $org_scalatest_assert_macro_left2 = numExpectedOutput;
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder().append((Object)"Number of expected outputs after ").append((Object)BoxesRunTime.boxToInteger((int)numBatches)).append((Object)" is zero").toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        $this.logInfo((Function0)new Serializable($this, numBatches, numExpectedOutput){
            public static final long serialVersionUID = 0L;
            private final int numBatches$1;
            private final int numExpectedOutput$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numBatches = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBatches$1)).append((Object)", numExpectedOutput = ").append((Object)BoxesRunTime.boxToInteger((int)this.numExpectedOutput$1)).toString();
            }
            {
                this.numBatches$1 = numBatches$1;
                this.numExpectedOutput$1 = numExpectedOutput$1;
            }
        });
        TestOutputStreamWithPartitions outputStream = (TestOutputStreamWithPartitions)((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DStream<?> x$3) {
                return x$3 instanceof TestOutputStreamWithPartitions;
            }
        })).head());
        ConcurrentLinkedQueue output2 = outputStream.output();
        try {
            ssc.start();
            ManualClock clock = (ManualClock)ssc.scheduler().clock();
            $this.logInfo((Function0)new Serializable($this, clock){
                public static final long serialVersionUID = 0L;
                private final ManualClock clock$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Manual clock before advancing = ").append((Object)BoxesRunTime.boxToLong((long)this.clock$1.getTimeMillis())).toString();
                }
                {
                    this.clock$1 = clock$1;
                }
            });
            if ($this.actuallyWait()) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches).foreach$mVc$sp((Function1)new Serializable($this, clock){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TestSuiteBase $outer;
                    private final ManualClock clock$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ TestSuiteBase$.anonfun.runStreamsWithPartitions.1 $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Actually waiting for ").append((Object)this.$outer.org$apache$spark$streaming$TestSuiteBase$$anonfun$$$outer().batchDuration()).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.clock$1.advance(this.$outer.batchDuration().milliseconds());
                        Thread.sleep(this.$outer.batchDuration().milliseconds());
                    }

                    public /* synthetic */ TestSuiteBase org$apache$spark$streaming$TestSuiteBase$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.clock$1 = clock$1;
                    }
                });
            } else {
                clock.advance((long)numBatches * $this.batchDuration().milliseconds());
            }
            $this.logInfo((Function0)new Serializable($this, clock){
                public static final long serialVersionUID = 0L;
                private final ManualClock clock$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Manual clock after advancing = ").append((Object)BoxesRunTime.boxToLong((long)this.clock$1.getTimeMillis())).toString();
                }
                {
                    this.clock$1 = clock$1;
                }
            });
            long startTime = System.currentTimeMillis();
            while (output2.size() < numExpectedOutput && System.currentTimeMillis() - startTime < (long)$this.maxWaitTimeMillis()) {
                $this.logInfo((Function0)new Serializable($this, output2, numExpectedOutput){
                    public static final long serialVersionUID = 0L;
                    private final ConcurrentLinkedQueue output$3;
                    private final int numExpectedOutput$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.output$3.size())).append((Object)", numExpectedOutput = ").append((Object)BoxesRunTime.boxToInteger((int)this.numExpectedOutput$1)).toString();
                    }
                    {
                        this.output$3 = output$3;
                        this.numExpectedOutput$1 = numExpectedOutput$1;
                    }
                });
                ssc.awaitTerminationOrTimeout(50L);
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            $this.logInfo((Function0)new Serializable($this, timeTaken){
                public static final long serialVersionUID = 0L;
                private final long timeTaken$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Output generated in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTaken$1)).append((Object)" milliseconds").toString();
                }
                {
                    this.timeTaken$1 = timeTaken$1;
                }
            });
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(output2).asScala()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TestSuiteBase $outer;

                public final void apply(Seq<Seq<V>> x) {
                    this.$outer.logInfo((Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final Seq x$4;

                        public final String apply() {
                            return new StringBuilder().append((Object)"[").append((Object)this.x$4.mkString(",")).append((Object)"]").toString();
                        }
                        {
                            this.x$4 = x$4;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            long $org_scalatest_assert_macro_left3 = timeTaken;
            int $org_scalatest_assert_macro_right3 = $this.maxWaitTimeMillis();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder().append((Object)"Operation timed out after ").append((Object)BoxesRunTime.boxToLong((long)timeTaken)).append((Object)" ms").toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)$this).convertToEqualizer((Object)BoxesRunTime.boxToInteger((int)output2.size()));
            int $org_scalatest_assert_macro_right4 = numExpectedOutput;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Unexpected number of outputs generated", Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
            Thread.sleep(100L);
            preStop.apply$mcV$sp();
            return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(output2).asScala()).toSeq();
        }
        finally {
            ssc.stop(true);
        }
    }

    public static Function0 runStreamsWithPartitions$default$4(TestSuiteBase $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        };
    }

    public static void verifyOutput(TestSuiteBase $this, Seq output2, Seq expectedOutput, boolean useSet, ClassTag evidence$11) {
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "--------------------------------";
            }
        });
        $this.logInfo((Function0)new Serializable($this, output2){
            public static final long serialVersionUID = 0L;
            private final Seq output$4;

            public final String apply() {
                return new StringBuilder().append((Object)"output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.output$4.size())).toString();
            }
            {
                this.output$4 = output$4;
            }
        });
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "output";
            }
        });
        output2.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSuiteBase $outer;

            public final void apply(Seq<V> x) {
                this.$outer.logInfo((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Seq x$5;

                    public final String apply() {
                        return new StringBuilder().append((Object)"[").append((Object)this.x$5.mkString(",")).append((Object)"]").toString();
                    }
                    {
                        this.x$5 = x$5;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.logInfo((Function0)new Serializable($this, expectedOutput){
            public static final long serialVersionUID = 0L;
            private final Seq expectedOutput$1;

            public final String apply() {
                return new StringBuilder().append((Object)"expected output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.expectedOutput$1.size())).toString();
            }
            {
                this.expectedOutput$1 = expectedOutput$1;
            }
        });
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "expected output";
            }
        });
        expectedOutput.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSuiteBase $outer;

            public final void apply(Seq<V> x) {
                this.$outer.logInfo((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Seq x$6;

                    public final String apply() {
                        return new StringBuilder().append((Object)"[").append((Object)this.x$6.mkString(",")).append((Object)"]").toString();
                    }
                    {
                        this.x$6 = x$6;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "--------------------------------";
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), output2.size()).foreach((Function1)new Serializable($this, output2, expectedOutput, useSet){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSuiteBase $outer;
            private final Seq output$4;
            private final Seq expectedOutput$1;
            private final boolean useSet$1;

            public final Assertion apply(int i) {
                Assertion assertion;
                if (this.useSet$1) {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this.$outer).convertToEqualizer((Object)((TraversableOnce)this.output$4.apply(i)).toSet());
                    Set $org_scalatest_assert_macro_right = ((TraversableOnce)this.expectedOutput$1.apply(i)).toSet();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set comparison failed\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected output (", " items):\\n", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.expectedOutput$1.size()), this.expectedOutput$1.mkString("\n")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated output (", " items): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.output$4.size()), this.output$4.mkString("\n")}))).toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
                } else {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this.$outer).convertToEqualizer((Object)((TraversableOnce)this.output$4.apply(i)).toList());
                    List $org_scalatest_assert_macro_right = ((TraversableOnce)this.expectedOutput$1.apply(i)).toList();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ordered list comparison failed\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected output (", " items):\\n", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.expectedOutput$1.size()), this.expectedOutput$1.mkString("\n")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated output (", " items): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.output$4.size()), this.output$4.mkString("\n")}))).toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
                }
                return assertion;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$4 = output$4;
                this.expectedOutput$1 = expectedOutput$1;
                this.useSet$1 = useSet$1;
            }
        });
        $this.logInfo((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Output verified successfully";
            }
        });
    }

    public static void testOperation(TestSuiteBase $this, Seq input, Function1 operation2, Seq expectedOutput, boolean useSet, ClassTag evidence$12, ClassTag evidence$13) {
        $this.testOperation(input, operation2, expectedOutput, -1, useSet, evidence$12, evidence$13);
    }

    public static void testOperation(TestSuiteBase $this, Seq input, Function1 operation2, Seq expectedOutput, int numBatches, boolean useSet, ClassTag evidence$14, ClassTag evidence$15) {
        int numBatches_ = numBatches > 0 ? numBatches : expectedOutput.size();
        $this.withStreamingContext($this.setupStreams(input, operation2, $this.setupStreams$default$3(), evidence$14, evidence$15), new Serializable($this, numBatches_, expectedOutput, useSet, evidence$15){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSuiteBase $outer;
            private final int numBatches_$1;
            private final Seq expectedOutput$2;
            private final boolean useSet$2;
            private final ClassTag evidence$15$1;

            public final void apply(StreamingContext ssc) {
                Seq<Seq<V>> output2 = this.$outer.runStreams(ssc, this.numBatches_$1, this.expectedOutput$2.size(), this.$outer.runStreams$default$4(), this.evidence$15$1);
                this.$outer.verifyOutput(output2.toSeq(), this.expectedOutput$2, this.useSet$2, this.evidence$15$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numBatches_$1 = numBatches_$1;
                this.expectedOutput$2 = expectedOutput$2;
                this.useSet$2 = useSet$2;
                this.evidence$15$1 = evidence$15$1;
            }
        });
    }

    public static void testOperation(TestSuiteBase $this, Seq input1, Seq input2, Function2 operation2, Seq expectedOutput, boolean useSet, ClassTag evidence$16, ClassTag evidence$17, ClassTag evidence$18) {
        $this.testOperation(input1, input2, operation2, expectedOutput, -1, useSet, evidence$16, evidence$17, evidence$18);
    }

    public static void testOperation(TestSuiteBase $this, Seq input1, Seq input2, Function2 operation2, Seq expectedOutput, int numBatches, boolean useSet, ClassTag evidence$19, ClassTag evidence$20, ClassTag evidence$21) {
        int numBatches_ = numBatches > 0 ? numBatches : expectedOutput.size();
        $this.withStreamingContext($this.setupStreams(input1, input2, operation2, evidence$19, evidence$20, evidence$21), new Serializable($this, numBatches_, expectedOutput, useSet, evidence$21){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSuiteBase $outer;
            private final int numBatches_$2;
            private final Seq expectedOutput$3;
            private final boolean useSet$3;
            private final ClassTag evidence$21$1;

            public final void apply(StreamingContext ssc) {
                Seq<Seq<V>> output2 = this.$outer.runStreams(ssc, this.numBatches_$2, this.expectedOutput$3.size(), this.$outer.runStreams$default$4(), this.evidence$21$1);
                this.$outer.verifyOutput(output2.toSeq(), this.expectedOutput$3, this.useSet$3, this.evidence$21$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numBatches_$2 = numBatches_$2;
                this.expectedOutput$3 = expectedOutput$3;
                this.useSet$3 = useSet$3;
                this.evidence$21$1 = evidence$21$1;
            }
        });
    }

    public static boolean testOperation$default$4(TestSuiteBase $this) {
        return false;
    }

    public static void $init$(TestSuiteBase $this) {
        $this.org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(new SparkConf().setMaster($this.master()).setAppName($this.framework()));
        $this.org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(Eventually$.MODULE$.timeout(Span$.MODULE$.apply(10L, (Units)org.scalatest.time.Seconds$.MODULE$)));
        $this.before((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSuiteBase $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.beforeFunction();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        $this.after((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TestSuiteBase $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.afterFunction();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
    }
}

