/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestReceiver;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.TestSuiteBase$class;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.JobGeneratorSuite$;
import org.apache.spark.streaming.scheduler.JobGeneratorSuite$$anonfun$1$;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u001b\t\t\"j\u001c2HK:,'/\u0019;peN+\u0018\u000e^3\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u001bQ+7\u000f^*vSR,')Y:f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!aB\u0003\u001d\u0005!\u0005Q$A\tK_\n<UM\\3sCR|'oU;ji\u0016\u0004\"A\u0007\u0010\u0007\u000b\u0005\u0011\u0001\u0012A\u0010\u0014\u0007y\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u001dJ!\u0001\u000b\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b]qB\u0011\u0001\u0016\u0015\u0003uAq\u0001\f\u0010C\u0002\u0013\u0005Q&A\u0005xC&$H*\u0019;dQV\ta\u0006\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005M\"\u0014\u0001B;uS2T\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028a\tq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0007BB\u001d\u001fA\u0003%a&\u0001\u0006xC&$H*\u0019;dQ\u0002Bqa\u000f\u0010\u0002\u0002\u0013%A(A\u0006sK\u0006$'+Z:pYZ,G#A\u001f\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0014\u0001\u00027b]\u001eL!AQ \u0003\r=\u0013'.Z2u\u0001")
public class JobGeneratorSuite
extends SparkFunSuite
implements TestSuiteBase {
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    public static CountDownLatch waitLatch() {
        return JobGeneratorSuite$.MODULE$.waitLatch();
    }

    private String checkpointDir$lzycompute() {
        JobGeneratorSuite jobGeneratorSuite = this;
        synchronized (jobGeneratorSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase$class.checkpointDir(this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    @Override
    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    @Override
    public String framework() {
        return TestSuiteBase$class.framework(this);
    }

    @Override
    public String master() {
        return TestSuiteBase$class.master(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase$class.batchDuration(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase$class.numInputPartitions(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase$class.maxWaitTimeMillis(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase$class.useManualClock(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase$class.actuallyWait(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase$class.beforeFunction(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase$class.afterFunction(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase$class.withStreamingContext(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase$class.withTestServer(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase$class.setupStreams(this, input, operation2, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase$class.setupStreams(this, input1, input2, operation2, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase$class.runStreams(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase$class.runStreamsWithPartitions(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase$class.verifyOutput(this, output2, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation2, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase$class.testOperation(this, input, operation2, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation2, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase$class.testOperation(this, input1, input2, operation2, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase$class.testOperation$default$4(this);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase$class.setupStreams$default$3(this);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase$class.runStreamsWithPartitions$default$4(this);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase$class.runStreams$default$4(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public JobGeneratorSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase$class.$init$(this);
        this.test("SPARK-6222: Do not clear received block data too soon", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobGeneratorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File checkpointDir2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                SparkConf testConf = this.$outer.conf();
                testConf.set("spark.streaming.clock", "org.apache.spark.streaming.util.ManualClock");
                testConf.set("spark.streaming.receiver.writeAheadLog.rollingInterval", "1");
                this.$outer.withStreamingContext(new StreamingContext(testConf, this.$outer.batchDuration()), new Serializable(this, checkpointDir2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final File checkpointDir$1;

                    public final void apply(StreamingContext ssc) {
                        ManualClock clock = (ManualClock)ssc.scheduler().clock();
                        int numBatches = 10;
                        int longBatchNumber = 3;
                        long longBatchTime = (long)longBatchNumber * this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().batchDuration().milliseconds();
                        PatienceConfiguration.Timeout testTimeout = Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((scala.concurrent.duration.Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()));
                        ReceiverInputDStream inputStream = ssc.receiverStream((Receiver)new TestReceiver(), ClassTag$.MODULE$.Int());
                        inputStream.foreachRDD((Function2)new Serializable(this, longBatchTime){
                            public static final long serialVersionUID = 0L;
                            private final long longBatchTime$1;

                            public final void apply(RDD<Object> rdd, Time time) {
                                if (time.milliseconds() == this.longBatchTime$1) {
                                    while (JobGeneratorSuite$.MODULE$.waitLatch().getCount() > 0L) {
                                        JobGeneratorSuite$.MODULE$.waitLatch().await();
                                    }
                                }
                            }
                            {
                                this.longBatchTime$1 = longBatchTime$1;
                            }
                        });
                        BatchCounter batchCounter = new BatchCounter(ssc);
                        ssc.checkpoint(this.checkpointDir$1.getAbsolutePath());
                        ssc.start();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().convertToEqualizer(inputStream.rememberDuration());
                        Duration $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().batchDuration();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                        ReceiverTracker receiverTracker = ssc.scheduler().receiverTracker();
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches).foreach$mVc$sp((Function1)new Serializable(this, clock, testTimeout, inputStream, receiverTracker){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final ManualClock clock$1;
                            private final PatienceConfiguration.Timeout testTimeout$1;
                            private final ReceiverInputDStream inputStream$1;
                            private final ReceiverTracker receiverTracker$1;

                            public final void apply(int batchNum) {
                                this.apply$mcVI$sp(batchNum);
                            }

                            public void apply$mcVI$sp(int batchNum) {
                                this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$waitForNewReceivedBlocks$1(this.testTimeout$1, this.receiverTracker$1);
                                this.clock$1.advance(this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().batchDuration().milliseconds());
                                this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$waitForBlocksToBeAllocatedToBatch$1(this.clock$1.getTimeMillis(), this.testTimeout$1, this.inputStream$1, this.receiverTracker$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.clock$1 = clock$1;
                                this.testTimeout$1 = testTimeout$1;
                                this.inputStream$1 = inputStream$1;
                                this.receiverTracker$1 = receiverTracker$1;
                            }
                        });
                        Eventually$.MODULE$.eventually(testTimeout, (Function0)new Serializable(this, numBatches, ssc){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final int numBatches$1;
                            private final StreamingContext ssc$1;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return this.ssc$1.scheduler().getPendingTimes().contains((Object)new Time((long)this.numBatches$1 * this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().batchDuration().milliseconds()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.numBatches$1 = numBatches$1;
                                this.ssc$1 = ssc$1;
                            }
                        }, Eventually$.MODULE$.patienceConfig(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                        Seq $org_scalatest_assert_macro_left2 = this.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$getBlocksOfBatch$1(longBatchTime, inputStream, receiverTracker);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"blocks of incomplete batch already deleted", Prettifier$.MODULE$.default(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
                        int $org_scalatest_assert_macro_left3 = batchCounter.getNumCompletedBatches();
                        int $org_scalatest_assert_macro_right2 = longBatchNumber;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                        JobGeneratorSuite$.MODULE$.waitLatch().countDown();
                        ssc.stop(ssc.stop$default$1());
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }

                    public final Seq org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$getBlocksOfBatch$1(long batchTime, ReceiverInputDStream inputStream$1, ReceiverTracker receiverTracker$1) {
                        return receiverTracker$1.getBlocksOfBatchAndStream(new Time(batchTime), inputStream$1.id());
                    }

                    public final void org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$waitForNewReceivedBlocks$1(PatienceConfiguration.Timeout testTimeout$1, ReceiverTracker receiverTracker$1) {
                        Eventually$.MODULE$.eventually(testTimeout$1, (Function0)new Serializable(this, receiverTracker$1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final ReceiverTracker receiverTracker$1;

                            public final Assertion apply() {
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.receiverTracker$1.hasUnallocatedBlocks(), "receiverTracker.hasUnallocatedBlocks", Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.receiverTracker$1 = receiverTracker$1;
                            }
                        }, Eventually$.MODULE$.patienceConfig(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
                    }

                    public final void org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$waitForBlocksToBeAllocatedToBatch$1(long batchTime, PatienceConfiguration.Timeout testTimeout$1, ReceiverInputDStream inputStream$1, ReceiverTracker receiverTracker$1) {
                        Eventually$.MODULE$.eventually(testTimeout$1, (Function0)new Serializable(this, inputStream$1, receiverTracker$1, batchTime){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final ReceiverInputDStream inputStream$1;
                            private final ReceiverTracker receiverTracker$1;
                            private final long batchTime$1;

                            public final Assertion apply() {
                                Seq $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$getBlocksOfBatch$1(this.batchTime$1, this.inputStream$1, this.receiverTracker$1);
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$anonfun$$$outer().org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.inputStream$1 = inputStream$1;
                                this.receiverTracker$1 = receiverTracker$1;
                                this.batchTime$1 = batchTime$1;
                            }
                        }, Eventually$.MODULE$.patienceConfig(), new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.checkpointDir$1 = checkpointDir$1;
                    }
                });
            }

            public /* synthetic */ JobGeneratorSuite org$apache$spark$streaming$scheduler$JobGeneratorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JobGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }
}

