/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u0001\u0003\u0005\tQ!\u0001\u0004#TiJ,\u0017-\\$sCBD'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0011\u00011\"\u0005\u000b\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\ta!#\u0003\u0002\u0014\u001b\ta1+\u001a:jC2L'0\u00192mKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015Y\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000f\u0005\u0002!\u0019!C\u0005E\u0005a\u0011N\u001c9viN#(/Z1ngV\t1\u0005E\u0002%S-j\u0011!\n\u0006\u0003M\u001d\nq!\\;uC\ndWM\u0003\u0002)\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005)*#aC!se\u0006L()\u001e4gKJ\u0004$\u0001\f\u001b\u0011\u00075\u0002$'D\u0001/\u0015\ty#!A\u0004egR\u0014X-Y7\n\u0005Er#\u0001D%oaV$Hi\u0015;sK\u0006l\u0007CA\u001a5\u0019\u0001!\u0011\"\u000e\u001c\u0002\u0002\u0003\u0005)\u0011\u0001\u001d\u0003\u0007}#\u0013\u0007\u0003\u00048\u0001\u0001\u0006IaI\u0001\u000eS:\u0004X\u000f^*ue\u0016\fWn\u001d\u0011\u0012\u0005eb\u0004C\u0001\u0007;\u0013\tYTBA\u0004O_RD\u0017N\\4\u0011\u00051i\u0014B\u0001 \u000e\u0005\r\te.\u001f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u00035yW\u000f\u001e9viN#(/Z1ngV\t!\tE\u0002%S\r\u0003$\u0001\u0012%\u0011\u00075*u)\u0003\u0002G]\t9Ai\u0015;sK\u0006l\u0007CA\u001aI\t%I%*!A\u0001\u0002\u000b\u0005\u0001HA\u0002`IIBaa\u0013\u0001!\u0002\u0013\u0011\u0015AD8viB,Ho\u0015;sK\u0006l7\u000f\t\u0005\b\u001b\u0002\u0001\r\u0011\"\u0003O\u0003QIg\u000e];u'R\u0014X-Y7OC6,\u0017I\u001c3J\tV\tq\nE\u0002Q1ns!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Qc\u0012A\u0002\u001fs_>$h(C\u0001\u000f\u0013\t9V\"A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&aA*fc*\u0011q+\u0004\t\u0005\u0019qsf-\u0003\u0002^\u001b\t1A+\u001e9mKJ\u0002\"aX2\u000f\u0005\u0001\f\u0007C\u0001*\u000e\u0013\t\u0011W\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012\u000e!\taq-\u0003\u0002i\u001b\t\u0019\u0011J\u001c;\t\u000f)\u0004\u0001\u0019!C\u0005W\u0006A\u0012N\u001c9viN#(/Z1n\u001d\u0006lW-\u00118e\u0013\u0012{F%Z9\u0015\u00051|\u0007C\u0001\u0007n\u0013\tqWB\u0001\u0003V]&$\bb\u00029j\u0003\u0003\u0005\raT\u0001\u0004q\u0012\n\u0004B\u0002:\u0001A\u0003&q*A\u000bj]B,Ho\u0015;sK\u0006lg*Y7f\u0003:$\u0017\n\u0012\u0011)\u0005E$\bC\u0001\u0007v\u0013\t1XB\u0001\u0005w_2\fG/\u001b7f\u0011\u001dA\b\u00011A\u0005\u0002e\f\u0001C]3nK6\u0014WM\u001d#ve\u0006$\u0018n\u001c8\u0016\u0003i\u0004\"aH>\n\u0005q\u0014!\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000fy\u0004\u0001\u0019!C\u0001\u007f\u0006!\"/Z7f[\n,'\u000fR;sCRLwN\\0%KF$2\u0001\\A\u0001\u0011\u001d\u0001X0!AA\u0002iDq!!\u0002\u0001A\u0003&!0A\tsK6,WNY3s\tV\u0014\u0018\r^5p]\u0002B\u0011\"!\u0003\u0001\u0001\u0004%\t!a\u0003\u0002)\rDWmY6q_&tG/\u00138Qe><'/Z:t+\t\ti\u0001E\u0002\r\u0003\u001fI1!!\u0005\u000e\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0006\u0001\u0001\u0004%\t!a\u0006\u00021\rDWmY6q_&tG/\u00138Qe><'/Z:t?\u0012*\u0017\u000fF\u0002m\u00033A\u0011\u0002]A\n\u0003\u0003\u0005\r!!\u0004\t\u0011\u0005u\u0001\u0001)Q\u0005\u0003\u001b\tQc\u00195fG.\u0004x.\u001b8u\u0013:\u0004&o\\4sKN\u001c\b\u0005C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0001\u0002$\u0005A!0\u001a:p)&lW-\u0006\u0002\u0002&A\u0019q$a\n\n\u0007\u0005%\"A\u0001\u0003US6,\u0007\"CA\u0017\u0001\u0001\u0007I\u0011AA\u0018\u00031QXM]8US6,w\fJ3r)\ra\u0017\u0011\u0007\u0005\na\u0006-\u0012\u0011!a\u0001\u0003KA\u0001\"!\u000e\u0001A\u0003&\u0011QE\u0001\nu\u0016\u0014x\u000eV5nK\u0002B\u0011\"!\u000f\u0001\u0001\u0004%\t!a\t\u0002\u0013M$\u0018M\u001d;US6,\u0007\"CA\u001f\u0001\u0001\u0007I\u0011AA \u00035\u0019H/\u0019:u)&lWm\u0018\u0013fcR\u0019A.!\u0011\t\u0013A\fY$!AA\u0002\u0005\u0015\u0002\u0002CA#\u0001\u0001\u0006K!!\n\u0002\u0015M$\u0018M\u001d;US6,\u0007\u0005\u0003\u0005\u0002J\u0001\u0001\r\u0011\"\u0001z\u00035\u0011\u0017\r^2i\tV\u0014\u0018\r^5p]\"I\u0011Q\n\u0001A\u0002\u0013\u0005\u0011qJ\u0001\u0012E\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8`I\u0015\fHc\u00017\u0002R!A\u0001/a\u0013\u0002\u0002\u0003\u0007!\u0010C\u0004\u0002V\u0001\u0001\u000b\u0015\u0002>\u0002\u001d\t\fGo\u00195EkJ\fG/[8oA!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111L\u0001\r]Vl'+Z2fSZ,'o]\u000b\u0002M\"I\u0011q\f\u0001A\u0002\u0013%\u0011\u0011M\u0001\u0011]Vl'+Z2fSZ,'o]0%KF$2\u0001\\A2\u0011!\u0001\u0018QLA\u0001\u0002\u00041\u0007bBA4\u0001\u0001\u0006KAZ\u0001\u000e]Vl'+Z2fSZ,'o\u001d\u0011)\u0007\u0005\u0015D\u000fC\u0004\u0002n\u0001!\t!a\u001c\u0002\u000bM$\u0018M\u001d;\u0015\u00071\f\t\b\u0003\u0005\u0002t\u0005-\u0004\u0019AA\u0013\u0003\u0011!\u0018.\\3\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u00059!/Z:uCJ$Hc\u00017\u0002|!A\u00111OA;\u0001\u0004\t)\u0003C\u0004\u0002\u0000\u0001!\t!!!\u0002\tM$x\u000e\u001d\u000b\u0002Y\"9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0015AC:fi\u000e{g\u000e^3yiR\u0019A.!#\t\u0011\u0005-\u00151\u0011a\u0001\u0003\u001b\u000b1a]:d!\ry\u0012qR\u0005\u0004\u0003#\u0013!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u001d\t)\n\u0001C\u0001\u0003/\u000b\u0001c]3u\u0005\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8\u0015\u00071\fI\nC\u0004\u0002\u001c\u0006M\u0005\u0019\u0001>\u0002\u0011\u0011,(/\u0019;j_:Dq!a(\u0001\t\u0003\t\t+\u0001\u0005sK6,WNY3s)\ra\u00171\u0015\u0005\b\u00037\u000bi\n1\u0001{\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u000ba\"\u00193e\u0013:\u0004X\u000f^*ue\u0016\fW\u000eF\u0002m\u0003WC\u0001\"!,\u0002&\u0002\u0007\u0011qV\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\r\u0003\u00022\u0006U\u0006\u0003B\u00171\u0003g\u00032aMA[\t-\t9,a+\u0002\u0002\u0003\u0005)\u0011\u0001\u001d\u0003\u0007}#C\u0007C\u0004\u0002<\u0002!\t!!0\u0002\u001f\u0005$GmT;uaV$8\u000b\u001e:fC6$2\u0001\\A`\u0011!\t\t-!/A\u0002\u0005\r\u0017\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0007BAc\u0003\u0013\u0004B!L#\u0002HB\u00191'!3\u0005\u0017\u0005-\u0017qXA\u0001\u0002\u0003\u0015\t\u0001\u000f\u0002\u0004?\u0012*\u0004bBAh\u0001\u0011\u0005\u0011\u0011[\u0001\u0010O\u0016$\u0018J\u001c9viN#(/Z1ngR\u0011\u00111\u001b\t\u0006\u0019\u0005U\u0017\u0011\\\u0005\u0004\u0003/l!!B!se\u0006L\b\u0007BAn\u0003?\u0004B!\f\u0019\u0002^B\u00191'a8\u0005\u0017\u0005\u0005\u0018QZA\u0001\u0002\u0003\u0015\t\u0001\u000f\u0002\u0004?\u00122\u0004bBAs\u0001\u0011\u0005\u0011q]\u0001\u0011O\u0016$x*\u001e;qkR\u001cFO]3b[N$\"!!;\u0011\u000b1\t).a;1\t\u00055\u0018\u0011\u001f\t\u0005[\u0015\u000by\u000fE\u00024\u0003c$1\"a=\u0002d\u0006\u0005\t\u0011!B\u0001q\t\u0019q\fJ\u001c\t\u000f\u0005]\b\u0001\"\u0001\u0002z\u00069r-\u001a;SK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fWn\u001d\u000b\u0003\u0003w\u0004R\u0001DAk\u0003{\u0004D!a@\u0003\bA)QF!\u0001\u0003\u0006%\u0019!1\u0001\u0018\u0003)I+7-Z5wKJLe\u000e];u\tN#(/Z1n!\r\u0019$q\u0001\u0003\f\u0005\u0013\t)0!A\u0001\u0002\u000b\u0005\u0001HA\u0002`IaBqA!\u0004\u0001\t\u0003\tY&A\bhKRtU/\u001c*fG\u0016Lg/\u001a:t\u0011\u0019\u0011\t\u0002\u0001C\u0001\u001d\u00069r-\u001a;J]B,Ho\u0015;sK\u0006lg*Y7f\u0003:$\u0017\n\u0012\u0005\b\u0005+\u0001A\u0011\u0001B\f\u000319WM\\3sCR,'j\u001c2t)\u0011\u0011IBa\n\u0011\tAC&1\u0004\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011\u0005\u0002\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002\u0002B\u0013\u0005?\u00111AS8c\u0011!\t\u0019Ha\u0005A\u0002\u0005\u0015\u0002b\u0002B\u0016\u0001\u0011\u0005!QF\u0001\u000eG2,\u0017M]'fi\u0006$\u0017\r^1\u0015\u00071\u0014y\u0003\u0003\u0005\u0002t\t%\u0002\u0019AA\u0013\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005k\tA#\u001e9eCR,7\t[3dWB|\u0017N\u001c;ECR\fGc\u00017\u00038!A\u00111\u000fB\u0019\u0001\u0004\t)\u0003C\u0004\u0003<\u0001!\tA!\u0010\u0002'\rdW-\u0019:DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0015\u00071\u0014y\u0004\u0003\u0005\u0002t\te\u0002\u0019AA\u0013\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003\u0003\u000bQC]3ti>\u0014Xm\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\rC\u0004\u0003H\u0001!\t!!!\u0002\u0011Y\fG.\u001b3bi\u0016DqAa\u0013\u0001\t\u0003\u0011i%A\u0011hKRl\u0015\r_%oaV$8\u000b\u001e:fC6\u0014V-\\3nE\u0016\u0014H)\u001e:bi&|g\u000eF\u0001{\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'\n1b\u001e:ji\u0016|%M[3diR\u0019AN!\u0016\t\u0011\t]#q\na\u0001\u00053\n1a\\8t!\u0011\u0011YF!\u001a\u000e\u0005\tu#\u0002\u0002B0\u0005C\n!![8\u000b\u0005\t\r\u0014\u0001\u00026bm\u0006LAAa\u001a\u0003^\t\u0011rJ\u00196fGR|U\u000f\u001e9viN#(/Z1nQ\u0019\u0011yEa\u001b\u0003xA)AB!\u001c\u0003r%\u0019!qN\u0007\u0003\rQD'o\\<t!\u0011\u0011YFa\u001d\n\t\tU$Q\f\u0002\f\u0013>+\u0005pY3qi&|gn\t\u0002\u0003r!9!1\u0010\u0001\u0005\n\tu\u0014A\u0003:fC\u0012|%M[3diR\u0019ANa \t\u0011\t\u0005%\u0011\u0010a\u0001\u0005\u0007\u000b1a\\5t!\u0011\u0011YF!\"\n\t\t\u001d%Q\f\u0002\u0012\u001f\nTWm\u0019;J]B,Ho\u0015;sK\u0006l\u0007F\u0002B=\u0005W\u00129\b")
public final class DStreamGraph
implements scala.Serializable,
Logging {
    private final ArrayBuffer<InputDStream<?>> inputStreams;
    private final ArrayBuffer<DStream<?>> outputStreams;
    private volatile Seq<Tuple2<String, Object>> inputStreamNameAndID;
    private Duration rememberDuration;
    private boolean checkpointInProgress;
    private Time zeroTime;
    private Time startTime;
    private Duration batchDuration;
    private volatile int numReceivers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArrayBuffer<InputDStream<?>> inputStreams() {
        return this.inputStreams;
    }

    private ArrayBuffer<DStream<?>> outputStreams() {
        return this.outputStreams;
    }

    private Seq<Tuple2<String, Object>> inputStreamNameAndID() {
        return this.inputStreamNameAndID;
    }

    private void inputStreamNameAndID_$eq(Seq<Tuple2<String, Object>> x$1) {
        this.inputStreamNameAndID = x$1;
    }

    public Duration rememberDuration() {
        return this.rememberDuration;
    }

    public void rememberDuration_$eq(Duration x$1) {
        this.rememberDuration = x$1;
    }

    public boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    public void checkpointInProgress_$eq(boolean x$1) {
        this.checkpointInProgress = x$1;
    }

    public Time zeroTime() {
        return this.zeroTime;
    }

    public void zeroTime_$eq(Time x$1) {
        this.zeroTime = x$1;
    }

    public Time startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Time x$1) {
        this.startTime = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void batchDuration_$eq(Duration x$1) {
        this.batchDuration = x$1;
    }

    private int numReceivers() {
        return this.numReceivers;
    }

    private void numReceivers_$eq(int x$1) {
        this.numReceivers = x$1;
    }

    public synchronized void start(Time time) {
        Predef$.MODULE$.require(this.zeroTime() == null, (Function0 & Serializable & scala.Serializable)() -> "DStream graph computation already started");
        this.zeroTime_$eq(time);
        this.startTime_$eq(time);
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.initialize(this.zeroTime());
            return BoxedUnit.UNIT;
        });
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.remember(this.rememberDuration());
            return BoxedUnit.UNIT;
        });
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.validateAtStart();
            return BoxedUnit.UNIT;
        });
        this.numReceivers_$eq(this.inputStreams().count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$start$5(x$4))));
        this.inputStreamNameAndID_$eq((Seq<Tuple2<String, Object>>)((Seq)this.inputStreams().map((Function1 & Serializable & scala.Serializable)is -> new Tuple2((Object)is.name(), (Object)BoxesRunTime.boxToInteger((int)is.id())), ArrayBuffer$.MODULE$.canBuildFrom())));
        this.inputStreams().par().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.start();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void restart(Time time) {
        this.startTime_$eq(time);
    }

    public synchronized void stop() {
        this.inputStreams().par().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void setContext(StreamingContext ssc) {
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.setContext(ssc);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void setBatchDuration(Duration duration) {
        Predef$.MODULE$.require(this.batchDuration() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Batch duration already set as ").append(this.batchDuration()).append(". Cannot set it again.").toString());
        this.batchDuration_$eq(duration);
    }

    public synchronized void remember(Duration duration) {
        Predef$.MODULE$.require(this.rememberDuration() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Remember duration already set as ").append(this.rememberDuration()).append(". Cannot set it again.").toString());
        this.rememberDuration_$eq(duration);
    }

    public void addInputStream(InputDStream<?> inputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            inputStream.setGraph(this);
            this.inputStreams().$plus$eq(inputStream);
        }
    }

    public void addOutputStream(DStream<?> outputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            outputStream.setGraph(this);
            this.outputStreams().$plus$eq(outputStream);
        }
    }

    public synchronized InputDStream<?>[] getInputStreams() {
        return (InputDStream[])this.inputStreams().toArray(ClassTag$.MODULE$.apply(InputDStream.class));
    }

    public synchronized DStream<?>[] getOutputStreams() {
        return (DStream[])this.outputStreams().toArray(ClassTag$.MODULE$.apply(DStream.class));
    }

    public synchronized ReceiverInputDStream<?>[] getReceiverInputStreams() {
        return (ReceiverInputDStream[])((TraversableOnce)((TraversableLike)this.inputStreams().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$getReceiverInputStreams$1(x$8)))).map((Function1 & Serializable & scala.Serializable)x$9 -> (ReceiverInputDStream)x$9, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ReceiverInputDStream.class));
    }

    public int getNumReceivers() {
        return this.numReceivers();
    }

    public Seq<Tuple2<String, Object>> getInputStreamNameAndID() {
        return this.inputStreamNameAndID();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Job> generateJobs(Time time) {
        void var2_4;
        ArrayBuffer arrayBuffer;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Generating jobs for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            arrayBuffer = (ArrayBuffer)this.outputStreams().flatMap((Function1 & Serializable & scala.Serializable)outputStream -> {
                Option<Job> jobOption = outputStream.generateJob(time);
                jobOption.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                    x$10.setCallSite(outputStream.creationSite());
                    return BoxedUnit.UNIT;
                });
                return Option$.MODULE$.option2Iterable(jobOption);
            }, ArrayBuffer$.MODULE$.canBuildFrom());
        }
        ArrayBuffer jobs = arrayBuffer;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Generated ").append(jobs.length()).append(" jobs for time ").append(time).toString());
        return var2_4;
    }

    public void clearMetadata(Time time) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Clearing metadata for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                x$11.clearMetadata(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Cleared old metadata for time ").append(time).toString());
    }

    public void updateCheckpointData(Time time) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Updating checkpoint data for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                x$12.updateCheckpointData(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updated checkpoint data for time ").append(time).toString());
    }

    public void clearCheckpointData(Time time) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Clearing checkpoint data for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                x$13.clearCheckpointData(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleared checkpoint data for time ").append(time).toString());
    }

    public void restoreCheckpointData() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restoring checkpoint data");
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                x$14.restoreCheckpointData();
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restored checkpoint data");
    }

    public synchronized void validate() {
        Predef$.MODULE$.require(this.batchDuration() != null, (Function0 & Serializable & scala.Serializable)() -> "Batch duration has not been set");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getOutputStreams())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No output operations registered, so nothing to execute");
    }

    public Duration getMaxInputStreamRememberDuration() {
        return (Duration)((TraversableOnce)((TraversableLike)this.inputStreams().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.rememberDuration(), ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$getMaxInputStreamRememberDuration$2(x$16)))).maxBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.milliseconds()), (Ordering)Ordering.Long$.MODULE$);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DStreamGraph.writeObject used");
            DStreamGraph dStreamGraph = this;
            synchronized (dStreamGraph) {
                this.checkpointInProgress_$eq(true);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Enabled checkpoint mode");
                oos.defaultWriteObject();
                this.checkpointInProgress_$eq(false);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disabled checkpoint mode");
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DStreamGraph.readObject used");
            DStreamGraph dStreamGraph = this;
            synchronized (dStreamGraph) {
                this.checkpointInProgress_$eq(true);
                ois.defaultReadObject();
                this.checkpointInProgress_$eq(false);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$start$5(InputDStream x$4) {
        return x$4 instanceof ReceiverInputDStream;
    }

    public static final /* synthetic */ boolean $anonfun$getReceiverInputStreams$1(InputDStream x$8) {
        return x$8 instanceof ReceiverInputDStream;
    }

    public static final /* synthetic */ boolean $anonfun$getMaxInputStreamRememberDuration$2(Duration x$16) {
        return x$16 != null;
    }

    public DStreamGraph() {
        Logging.$init$((Logging)this);
        this.inputStreams = new ArrayBuffer();
        this.outputStreams = new ArrayBuffer();
        this.inputStreamNameAndID = Nil$.MODULE$;
        this.rememberDuration = null;
        this.checkpointInProgress = false;
        this.zeroTime = null;
        this.startTime = null;
        this.batchDuration = null;
        this.numReceivers = 0;
    }
}

