/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.CheckpointWriter;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.api.python.PythonDStream$;
import org.apache.spark.streaming.scheduler.ClearCheckpointData;
import org.apache.spark.streaming.scheduler.ClearMetadata;
import org.apache.spark.streaming.scheduler.DoCheckpoint;
import org.apache.spark.streaming.scheduler.GenerateJobs;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobGeneratorEvent;
import org.apache.spark.streaming.scheduler.JobScheduler;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobSet$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pE\u001e+g.\u001a:bi>\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1b!\u0001\u0005j]R,'O\\1m\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!\u0011!Q\u0001\nq\tAB[8c'\u000eDW\rZ;mKJ\u001c\u0001\u0001\u0005\u0002\u001e=5\t!!\u0003\u0002 \u0005\ta!j\u001c2TG\",G-\u001e7fe\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"a\t\u0013\u0011\u0005u\u0001\u0001\"\u0002\u000e!\u0001\u0004a\u0002b\u0002\u0014\u0001\u0005\u0004%IaJ\u0001\u0004gN\u001cW#\u0001\u0015\u0011\u0005%RS\"\u0001\u0003\n\u0005-\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u0019i\u0003\u0001)A\u0005Q\u0005!1o]2!\u0011\u001dy\u0003A1A\u0005\nA\nAaY8oMV\t\u0011\u0007\u0005\u00023g5\ta!\u0003\u00025\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0019\u0002\u000b\r|gN\u001a\u0011\t\u000fa\u0002!\u0019!C\u0005s\u0005)qM]1qQV\t!\b\u0005\u0002*w%\u0011A\b\u0002\u0002\r\tN#(/Z1n\u000fJ\f\u0007\u000f\u001b\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001e\u0002\r\u001d\u0014\u0018\r\u001d5!\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005\u000bQa\u00197pG.,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u001a\tA!\u001e;jY&\u0011q\t\u0012\u0002\u0006\u00072|7m\u001b\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\"\u0002\r\rdwnY6!\u0011\u001dY\u0005A1A\u0005\n1\u000bQ\u0001^5nKJ,\u0012!\u0014\t\u0003\u001dBk\u0011a\u0014\u0006\u0003\u000b\u0012I!!U(\u0003\u001dI+7-\u001e:sS:<G+[7fe\"11\u000b\u0001Q\u0001\n5\u000ba\u0001^5nKJ\u0004\u0003\u0002C+\u0001\u0011\u000b\u0007I\u0011\u0002,\u0002!MDw.\u001e7e\u0007\",7m\u001b9pS:$X#A,\u0011\u00059A\u0016BA-\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0017\u0001\t\u0006\u0004%I\u0001X\u0001\u0011G\",7m\u001b9pS:$xK]5uKJ,\u0012!\u0018\t\u0003SyK!a\u0018\u0003\u0003!\rCWmY6q_&tGo\u0016:ji\u0016\u0014\bbB1\u0001\u0001\u0004%IAY\u0001\nKZ,g\u000e\u001e'p_B,\u0012a\u0019\t\u0004\u0007\u00124\u0017BA3E\u0005%)e/\u001a8u\u0019>|\u0007\u000f\u0005\u0002\u001eO&\u0011\u0001N\u0001\u0002\u0012\u0015>\u0014w)\u001a8fe\u0006$xN]#wK:$\bb\u00026\u0001\u0001\u0004%Ia[\u0001\u000eKZ,g\u000e\u001e'p_B|F%Z9\u0015\u00051|\u0007C\u0001\bn\u0013\tqwB\u0001\u0003V]&$\bb\u00029j\u0003\u0003\u0005\raY\u0001\u0004q\u0012\n\u0004B\u0002:\u0001A\u0003&1-\u0001\u0006fm\u0016tG\u000fT8pa\u0002Bq\u0001\u001e\u0001A\u0002\u0013%Q/\u0001\nmCN$\bK]8dKN\u001cX\r\u001a\"bi\u000eDW#\u0001<\u0011\u0005%:\u0018B\u0001=\u0005\u0005\u0011!\u0016.\\3\t\u000fi\u0004\u0001\u0019!C\u0005w\u00061B.Y:u!J|7-Z:tK\u0012\u0014\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002my\"9\u0001/_A\u0001\u0002\u00041\bB\u0002@\u0001A\u0003&a/A\nmCN$\bK]8dKN\u001cX\r\u001a\"bi\u000eD\u0007\u0005C\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u000bM$\u0018M\u001d;\u0015\u00031Dq!a\u0002\u0001\t\u0003\tI!\u0001\u0003ti>\u0004Hc\u00017\u0002\f!9\u0011QBA\u0003\u0001\u00049\u0016a\u00059s_\u000e,7o\u001d*fG\u0016Lg/\u001a3ECR\f\u0007bBA\t\u0001\u0011\u0005\u00111C\u0001\u0012_:\u0014\u0015\r^2i\u0007>l\u0007\u000f\\3uS>tGc\u00017\u0002\u0016!9\u0011qCA\b\u0001\u00041\u0018\u0001\u0002;j[\u0016Dq!a\u0007\u0001\t\u0003\ti\"\u0001\fp]\u000eCWmY6q_&tGoQ8na2,G/[8o)\u0015a\u0017qDA\u0011\u0011\u001d\t9\"!\u0007A\u0002YDq!a\t\u0002\u001a\u0001\u0007q+\u0001\rdY\u0016\f'o\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\rT1uKJDq!a\n\u0001\t\u0013\tI#\u0001\u0007qe>\u001cWm]:Fm\u0016tG\u000fF\u0002m\u0003WAq!!\f\u0002&\u0001\u0007a-A\u0003fm\u0016tG\u000fC\u0004\u00022\u0001!I!a\u0001\u0002\u001dM$\u0018M\u001d;GSJ\u001cH\u000fV5nK\"9\u0011Q\u0007\u0001\u0005\n\u0005\r\u0011a\u0002:fgR\f'\u000f\u001e\u0005\b\u0003s\u0001A\u0011BA\u001e\u000319WM\\3sCR,'j\u001c2t)\ra\u0017Q\b\u0005\b\u0003/\t9\u00041\u0001w\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\nQb\u00197fCJlU\r^1eCR\fGc\u00017\u0002F!9\u0011qCA \u0001\u00041\bbBA%\u0001\u0011%\u00111J\u0001\u0014G2,\u0017M]\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u000b\u0004Y\u00065\u0003bBA\f\u0003\u000f\u0002\rA\u001e\u0005\b\u0003#\u0002A\u0011BA*\u00031!wn\u00115fG.\u0004x.\u001b8u)\u0015a\u0017QKA,\u0011\u001d\t9\"a\u0014A\u0002YDq!a\t\u0002P\u0001\u0007q\u000bC\u0004\u0002\\\u0001!I!!\u0018\u0002/5\f'o\u001b\"bi\u000eDg)\u001e7msB\u0013xnY3tg\u0016$Gc\u00017\u0002`!9\u0011qCA-\u0001\u00041\b")
public class JobGenerator
implements Logging {
    private boolean shouldCheckpoint;
    private CheckpointWriter checkpointWriter;
    public final JobScheduler org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler;
    private final StreamingContext ssc;
    private final SparkConf conf;
    private final DStreamGraph graph;
    private final Clock clock;
    private final RecurringTimer timer;
    private EventLoop<JobGeneratorEvent> eventLoop;
    private Time lastProcessedBatch;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StreamingContext ssc() {
        return this.ssc;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private DStreamGraph graph() {
        return this.graph;
    }

    public Clock clock() {
        return this.clock;
    }

    private RecurringTimer timer() {
        return this.timer;
    }

    private boolean shouldCheckpoint$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldCheckpoint = this.ssc().checkpointDuration() != null && this.ssc().checkpointDir() != null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldCheckpoint;
    }

    private boolean shouldCheckpoint() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldCheckpoint$lzycompute() : this.shouldCheckpoint;
    }

    private CheckpointWriter checkpointWriter$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.checkpointWriter = this.shouldCheckpoint() ? new CheckpointWriter(this, this.ssc().conf(), this.ssc().checkpointDir(), this.ssc().sparkContext().hadoopConfiguration()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.checkpointWriter;
    }

    private CheckpointWriter checkpointWriter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.checkpointWriter$lzycompute() : this.checkpointWriter;
    }

    private EventLoop<JobGeneratorEvent> eventLoop() {
        return this.eventLoop;
    }

    private void eventLoop_$eq(EventLoop<JobGeneratorEvent> x$1) {
        this.eventLoop = x$1;
    }

    private Time lastProcessedBatch() {
        return this.lastProcessedBatch;
    }

    private void lastProcessedBatch_$eq(Time x$1) {
        this.lastProcessedBatch = x$1;
    }

    public synchronized void start() {
        if (this.eventLoop() != null) {
            return;
        }
        this.checkpointWriter();
        this.eventLoop_$eq(new EventLoop<JobGeneratorEvent>(this){
            private final /* synthetic */ JobGenerator $outer;

            public void onReceive(JobGeneratorEvent event) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(event);
            }

            public void onError(Throwable e) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError("Error in job generator", e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("JobGenerator");
            }
        });
        this.eventLoop().start();
        if (this.ssc().isCheckpointPresent()) {
            this.restart();
        } else {
            this.startFirstTime();
        }
    }

    public synchronized void stop(boolean processReceivedData) {
        if (this.eventLoop() == null) {
            return;
        }
        if (processReceivedData) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping JobGenerator gracefully");
            long timeWhenStopStarted = System.currentTimeMillis();
            long stopTimeoutMs = this.conf().getTimeAsMs("spark.streaming.gracefulStopTimeout", new StringBuilder(2).append(10L * this.ssc().graph().batchDuration().milliseconds()).append("ms").toString());
            int pollTime = 100;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for all received blocks to be consumed for job generation");
            while (!this.hasTimedOut$1(timeWhenStopStarted, stopTimeoutMs) && this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().hasUnallocatedBlocks()) {
                Thread.sleep(pollTime);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waited for all received blocks to be consumed for job generation");
            long stopTime = this.timer().stop(false);
            this.graph().stop();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped generation timer");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for jobs to be processed and checkpoints to be written");
            while (!this.hasTimedOut$1(timeWhenStopStarted, stopTimeoutMs) && !this.haveAllBatchesBeenProcessed$1(stopTime)) {
                Thread.sleep(pollTime);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waited for jobs to be processed and checkpoints to be written");
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping JobGenerator immediately");
            this.timer().stop(true);
            this.graph().stop();
        }
        this.eventLoop().stop();
        if (this.shouldCheckpoint()) {
            this.checkpointWriter().stop();
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped JobGenerator");
    }

    public void onBatchCompletion(Time time) {
        this.eventLoop().post((Object)new ClearMetadata(time));
    }

    public void onCheckpointCompletion(Time time, boolean clearCheckpointDataLater) {
        block0: {
            if (!clearCheckpointDataLater) break block0;
            this.eventLoop().post((Object)new ClearCheckpointData(time));
        }
    }

    public void org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(JobGeneratorEvent event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Got event ").append(event).toString());
        JobGeneratorEvent jobGeneratorEvent = event;
        if (jobGeneratorEvent instanceof GenerateJobs) {
            GenerateJobs generateJobs = (GenerateJobs)jobGeneratorEvent;
            Time time = generateJobs.time();
            this.generateJobs(time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jobGeneratorEvent instanceof ClearMetadata) {
            ClearMetadata clearMetadata = (ClearMetadata)jobGeneratorEvent;
            Time time = clearMetadata.time();
            this.clearMetadata(time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jobGeneratorEvent instanceof DoCheckpoint) {
            DoCheckpoint doCheckpoint = (DoCheckpoint)jobGeneratorEvent;
            Time time = doCheckpoint.time();
            boolean clearCheckpointDataLater = doCheckpoint.clearCheckpointDataLater();
            this.doCheckpoint(time, clearCheckpointDataLater);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jobGeneratorEvent instanceof ClearCheckpointData) {
            ClearCheckpointData clearCheckpointData = (ClearCheckpointData)jobGeneratorEvent;
            Time time = clearCheckpointData.time();
            this.clearCheckpointData(time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jobGeneratorEvent);
        }
    }

    private void startFirstTime() {
        Time startTime = new Time(this.timer().getStartTime());
        this.graph().start(startTime.$minus(this.graph().batchDuration()));
        this.timer().start(startTime.milliseconds());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Started JobGenerator at ").append(startTime).toString());
    }

    private void restart() {
        if (this.clock() instanceof ManualClock) {
            long lastTime = this.ssc().initialCheckpoint().checkpointTime().milliseconds();
            long jumpTime = this.ssc().sc().conf().getLong("spark.streaming.manualClock.jump", 0L);
            ((ManualClock)this.clock()).setTime(lastTime + jumpTime);
        }
        Duration batchDuration = this.ssc().graph().batchDuration();
        Time checkpointTime = this.ssc().initialCheckpoint().checkpointTime();
        Time restartTime = new Time(this.timer().getRestartTime(this.graph().zeroTime().milliseconds()));
        Seq<Time> downTimes = checkpointTime.until(restartTime, batchDuration);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Batches during down time (").append(downTimes.size()).append(" batches): ").append(downTimes.mkString(", ")).toString());
        Time[] pendingTimes = (Time[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().initialCheckpoint().pendingTimes())).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Batches pending processing (").append(pendingTimes.length).append(" batches): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pendingTimes)).mkString(", ")).toString());
        Time[] timesToReschedule = (Time[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pendingTimes)).$plus$plus(downTimes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Time.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.$less(restartTime))))).distinct())).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Batches to reschedule (").append(timesToReschedule.length).append(" batches): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timesToReschedule)).mkString(", ")).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timesToReschedule)).foreach((Function1 & Serializable & scala.Serializable)time -> {
            JobGenerator.$anonfun$restart$5(this, time);
            return BoxedUnit.UNIT;
        });
        this.timer().start(restartTime.milliseconds());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Restarted JobGenerator at ").append(restartTime).toString());
    }

    private void generateJobs(Time time) {
        this.ssc().sparkContext().setLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS(), "true");
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().allocateBlocksToBatch(time);
            return this.graph().generateJobs(time);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq jobs = (Seq)success.value();
            Map<Object, StreamInputInfo> streamIdToInputInfos = this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().getInfo(time);
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, (Seq<Job>)jobs, streamIdToInputInfos));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError(new StringBuilder(31).append("Error generating jobs for time ").append(time).toString(), e);
            PythonDStream$.MODULE$.stopStreamingContextIfPythonProcessIsDead(e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        this.eventLoop().post((Object)new DoCheckpoint(time, false));
    }

    private void clearMetadata(Time time) {
        this.ssc().graph().clearMetadata(time);
        if (this.shouldCheckpoint()) {
            this.eventLoop().post((Object)new DoCheckpoint(time, true));
        } else {
            Duration maxRememberDuration = this.graph().getMaxInputStreamRememberDuration();
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().cleanupOldBlocksAndBatches(time.$minus(maxRememberDuration));
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().cleanup(time.$minus(maxRememberDuration));
            this.markBatchFullyProcessed(time);
        }
    }

    private void clearCheckpointData(Time time) {
        this.ssc().graph().clearCheckpointData(time);
        Duration maxRememberDuration = this.graph().getMaxInputStreamRememberDuration();
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().cleanupOldBlocksAndBatches(time.$minus(maxRememberDuration));
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().cleanup(time.$minus(maxRememberDuration));
        this.markBatchFullyProcessed(time);
    }

    private void doCheckpoint(Time time, boolean clearCheckpointDataLater) {
        block1: {
            block0: {
                if (!this.shouldCheckpoint() || !time.$minus(this.graph().zeroTime()).isMultipleOf(this.ssc().checkpointDuration())) break block0;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Checkpointing graph for time ").append(time).toString());
                this.ssc().graph().updateCheckpointData(time);
                this.checkpointWriter().write(new Checkpoint(this.ssc(), time), clearCheckpointDataLater);
                break block1;
            }
            if (!clearCheckpointDataLater) break block1;
            this.markBatchFullyProcessed(time);
        }
    }

    private void markBatchFullyProcessed(Time time) {
        this.lastProcessedBatch_$eq(time);
    }

    private static final Clock liftedTree1$1(String clockClass$1) {
        Clock clock;
        try {
            clock = (Clock)Utils$.MODULE$.classForName(clockClass$1).newInstance();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ClassNotFoundException) || !clockClass$1.startsWith("org.apache.spark.streaming")) {
                throw throwable;
            }
            String newClockClass = clockClass$1.replace("org.apache.spark.streaming", "org.apache.spark");
            Clock clock2 = (Clock)Utils$.MODULE$.classForName(newClockClass).newInstance();
            clock = clock2;
        }
        return clock;
    }

    private final boolean hasTimedOut$1(long timeWhenStopStarted$1, long stopTimeoutMs$1) {
        boolean timedOut;
        block0: {
            boolean bl = timedOut = System.currentTimeMillis() - timeWhenStopStarted$1 > stopTimeoutMs$1;
            if (!timedOut) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Timed out while stopping the job generator (timeout = ").append(stopTimeoutMs$1).append(")").toString());
        }
        return timedOut;
    }

    private final boolean haveAllBatchesBeenProcessed$1(long stopTime$1) {
        return this.lastProcessedBatch() != null && this.lastProcessedBatch().milliseconds() == stopTime$1;
    }

    public static final /* synthetic */ void $anonfun$restart$5(JobGenerator $this, Time time) {
        $this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().allocateBlocksToBatch(time);
        $this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, $this.graph().generateJobs(time), JobSet$.MODULE$.apply$default$3()));
    }

    public JobGenerator(JobScheduler jobScheduler) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler = jobScheduler;
        Logging.$init$((Logging)this);
        this.ssc = jobScheduler.ssc();
        this.conf = this.ssc().conf();
        this.graph = this.ssc().graph();
        String clockClass = this.ssc().sc().conf().get("spark.streaming.clock", "org.apache.spark.util.SystemClock");
        this.clock = JobGenerator.liftedTree1$1(clockClass);
        this.timer = new RecurringTimer(this.clock(), this.ssc().graph().batchDuration().milliseconds(), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)longTime -> this.eventLoop().post((Object)new GenerateJobs(new Time(longTime))), "JobGenerator");
        this.eventLoop = null;
        this.lastProcessedBatch = null;
    }
}

