/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.python.PythonDStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.scheduler.ErrorReported;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager$;
import org.apache.spark.streaming.scheduler.InputInfoTracker;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobCompleted;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.JobScheduler$;
import org.apache.spark.streaming.scheduler.JobSchedulerEvent;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobStarted;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tUb!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pEN\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1b!\u0001\u0005j]R,'O\\1m\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!Q1A\u0005\u0002q\t1a]:d\u0007\u0001)\u0012!\b\t\u0003=}i\u0011\u0001B\u0005\u0003A\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\t\u0002!\u0011!Q\u0001\nu\tAa]:dA!)A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"\"A\n\u0015\u0011\u0005\u001d\u0002Q\"\u0001\u0002\t\u000bi\u0019\u0003\u0019A\u000f\t\u000f)\u0002!\u0019!C\u0005W\u00059!n\u001c2TKR\u001cX#\u0001\u0017\u0011\t5\u0012DgN\u0007\u0002])\u0011q\u0006M\u0001\u0005kRLGNC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#aA'baB\u0011a$N\u0005\u0003m\u0011\u0011A\u0001V5nKB\u0011q\u0005O\u0005\u0003s\t\u0011aAS8c'\u0016$\bBB\u001e\u0001A\u0003%A&\u0001\u0005k_\n\u001cV\r^:!\u0011\u001di\u0004A1A\u0005\ny\n\u0011C\\;n\u0007>t7-\u001e:sK:$(j\u001c2t+\u0005y\u0004C\u0001\bA\u0013\t\tuBA\u0002J]RDaa\u0011\u0001!\u0002\u0013y\u0014A\u00058v[\u000e{gnY;se\u0016tGOS8cg\u0002Bq!\u0012\u0001C\u0002\u0013%a)A\u0006k_\n,\u00050Z2vi>\u0014X#A$\u0011\u0005![U\"A%\u000b\u0005)s\u0013AC2p]\u000e,(O]3oi&\u0011A*\u0013\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0003\u0004O\u0001\u0001\u0006IaR\u0001\rU>\u0014W\t_3dkR|'\u000f\t\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u00031QwNY$f]\u0016\u0014\u0018\r^8s+\u0005\u0011\u0006CA\u0014T\u0013\t!&A\u0001\u0007K_\n<UM\\3sCR|'\u000f\u0003\u0004W\u0001\u0001\u0006IAU\u0001\u000eU>\u0014w)\u001a8fe\u0006$xN\u001d\u0011\t\u000fa\u0003!\u0019!C\u00013\u0006)1\r\\8dWV\t!\f\u0005\u0002\\;6\tAL\u0003\u00020\r%\u0011a\f\u0018\u0002\u0006\u00072|7m\u001b\u0005\u0007A\u0002\u0001\u000b\u0011\u0002.\u0002\r\rdwnY6!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\f1\u0002\\5ti\u0016tWM\u001d\"vgV\tA\r\u0005\u0002(K&\u0011aM\u0001\u0002\u0015'R\u0014X-Y7j]\u001ed\u0015n\u001d;f]\u0016\u0014()^:\t\r!\u0004\u0001\u0015!\u0003e\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u0011\u001dQ\u0007\u00011A\u0005\u0002-\fqB]3dK&4XM\u001d+sC\u000e\\WM]\u000b\u0002YB\u0011q%\\\u0005\u0003]\n\u0011qBU3dK&4XM\u001d+sC\u000e\\WM\u001d\u0005\ba\u0002\u0001\r\u0011\"\u0001r\u0003M\u0011XmY3jm\u0016\u0014HK]1dW\u0016\u0014x\fJ3r)\t\u0011X\u000f\u0005\u0002\u000fg&\u0011Ao\u0004\u0002\u0005+:LG\u000fC\u0004w_\u0006\u0005\t\u0019\u00017\u0002\u0007a$\u0013\u0007\u0003\u0004y\u0001\u0001\u0006K\u0001\\\u0001\u0011e\u0016\u001cW-\u001b<feR\u0013\u0018mY6fe\u0002BqA\u001f\u0001A\u0002\u0013\u000510\u0001\tj]B,H/\u00138g_R\u0013\u0018mY6feV\tA\u0010\u0005\u0002({&\u0011aP\u0001\u0002\u0011\u0013:\u0004X\u000f^%oM>$&/Y2lKJD\u0011\"!\u0001\u0001\u0001\u0004%\t!a\u0001\u0002)%t\u0007/\u001e;J]\u001a|GK]1dW\u0016\u0014x\fJ3r)\r\u0011\u0018Q\u0001\u0005\bm~\f\t\u00111\u0001}\u0011\u001d\tI\u0001\u0001Q!\nq\f\u0011#\u001b8qkRLeNZ8Ue\u0006\u001c7.\u001a:!\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty!A\rfq\u0016\u001cW\u000f^8s\u00032dwnY1uS>tW*\u00198bO\u0016\u0014XCAA\t!\u0015q\u00111CA\f\u0013\r\t)b\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u001d\nI\"C\u0002\u0002\u001c\t\u0011\u0011$\u0012=fGV$xN]!mY>\u001c\u0017\r^5p]6\u000bg.Y4fe\"I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011E\u0001\u001eKb,7-\u001e;pe\u0006cGn\\2bi&|g.T1oC\u001e,'o\u0018\u0013fcR\u0019!/a\t\t\u0013Y\fi\"!AA\u0002\u0005E\u0001\u0002CA\u0014\u0001\u0001\u0006K!!\u0005\u00025\u0015DXmY;u_J\fE\u000e\\8dCRLwN\\'b]\u0006<WM\u001d\u0011\t\u0013\u0005-\u0002\u00011A\u0005\n\u00055\u0012!C3wK:$Hj\\8q+\t\ty\u0003E\u0003\\\u0003c\t)$C\u0002\u00024q\u0013\u0011\"\u0012<f]Rdun\u001c9\u0011\u0007\u001d\n9$C\u0002\u0002:\t\u0011\u0011CS8c'\u000eDW\rZ;mKJ,e/\u001a8u\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty$A\u0007fm\u0016tG\u000fT8pa~#S-\u001d\u000b\u0004e\u0006\u0005\u0003\"\u0003<\u0002<\u0005\u0005\t\u0019AA\u0018\u0011!\t)\u0005\u0001Q!\n\u0005=\u0012AC3wK:$Hj\\8qA!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013!B:uCJ$H#\u0001:\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\u0005!1\u000f^8q)\r\u0011\u00181\u000b\u0005\t\u0003+\ni\u00051\u0001\u0002X\u00051\u0002O]8dKN\u001c\u0018\t\u001c7SK\u000e,\u0017N^3e\t\u0006$\u0018\rE\u0002\u000f\u00033J1!a\u0017\u0010\u0005\u001d\u0011un\u001c7fC:Dq!a\u0018\u0001\t\u0003\t\t'\u0001\u0007tk\nl\u0017\u000e\u001e&pEN+G\u000fF\u0002s\u0003GBq!!\u001a\u0002^\u0001\u0007q'\u0001\u0004k_\n\u001cV\r\u001e\u0005\b\u0003S\u0002A\u0011AA6\u0003=9W\r\u001e)f]\u0012Lgn\u001a+j[\u0016\u001cHCAA7!\u0015\ty'a 5\u001d\u0011\t\t(a\u001f\u000f\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u001c\u0003\u0019a$o\\8u}%\t\u0001#C\u0002\u0002~=\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0006\r%aA*fc*\u0019\u0011QP\b\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006Y!/\u001a9peR,%O]8s)\u0015\u0011\u00181RAP\u0011!\ti)!\"A\u0002\u0005=\u0015aA7tOB!\u0011\u0011SAM\u001d\u0011\t\u0019*!&\u0011\u0007\u0005Mt\"C\u0002\u0002\u0018>\ta\u0001\u0015:fI\u00164\u0017\u0002BAN\u0003;\u0013aa\u0015;sS:<'bAAL\u001f!A\u0011\u0011UAC\u0001\u0004\t\u0019+A\u0001f!\u0011\ty'!*\n\t\u0005\u001d\u00161\u0011\u0002\n)\"\u0014xn^1cY\u0016Dq!a+\u0001\t\u0003\ti+A\u0005jgN#\u0018M\u001d;fIR\u0011\u0011q\u000b\u0005\b\u0003c\u0003A\u0011BAZ\u00031\u0001(o\\2fgN,e/\u001a8u)\r\u0011\u0018Q\u0017\u0005\t\u0003o\u000by\u000b1\u0001\u00026\u0005)QM^3oi\"9\u00111\u0018\u0001\u0005\n\u0005u\u0016A\u00045b]\u0012dWMS8c'R\f'\u000f\u001e\u000b\u0006e\u0006}\u0016\u0011\u001a\u0005\t\u0003\u0003\fI\f1\u0001\u0002D\u0006\u0019!n\u001c2\u0011\u0007\u001d\n)-C\u0002\u0002H\n\u00111AS8c\u0011!\tY-!/A\u0002\u00055\u0017!C:uCJ$H+[7f!\rq\u0011qZ\u0005\u0004\u0003#|!\u0001\u0002'p]\u001eDq!!6\u0001\t\u0013\t9.A\niC:$G.\u001a&pE\u000e{W\u000e\u001d7fi&|g\u000eF\u0003s\u00033\fY\u000e\u0003\u0005\u0002B\u0006M\u0007\u0019AAb\u0011!\ti.a5A\u0002\u00055\u0017!D2p[BdW\r^3e)&lW\rC\u0004\u0002b\u0002!I!a9\u0002\u0017!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u000b\u0006e\u0006\u0015\u0018q\u001d\u0005\t\u0003\u001b\u000by\u000e1\u0001\u0002\u0010\"A\u0011\u0011UAp\u0001\u0004\t\u0019K\u0002\u0004\u0002l\u0002!\u0011Q\u001e\u0002\u000b\u0015>\u0014\u0007*\u00198eY\u0016\u00148cBAu\u0003_\fYp\u0005\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q\u001f\u0019\u0002\t1\fgnZ\u0005\u0005\u0003s\f\u0019P\u0001\u0004PE*,7\r\u001e\t\u0005\u0003c\fi0\u0003\u0003\u0002\u0000\u0006M(\u0001\u0003*v]:\f'\r\\3\t\u0017\u0005\u0005\u0017\u0011\u001eB\u0001B\u0003%\u00111\u0019\u0005\bI\u0005%H\u0011\u0001B\u0003)\u0011\u00119Aa\u0003\u0011\t\t%\u0011\u0011^\u0007\u0002\u0001!A\u0011\u0011\u0019B\u0002\u0001\u0004\t\u0019\r\u0003\u0005\u0003\u0010\u0005%H\u0011AA&\u0003\r\u0011XO\\\u0004\t\u0005'\u0011\u0001\u0012\u0001\u0003\u0003\u0016\u0005a!j\u001c2TG\",G-\u001e7feB\u0019qEa\u0006\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0003\u001aM\u0019!qC\u0007\t\u000f\u0011\u00129\u0002\"\u0001\u0003\u001eQ\u0011!Q\u0003\u0005\u000b\u0005C\u00119B1A\u0005\u0002\t\r\u0012a\u0006\"B)\u000eCu\fV%N\u000b~\u0003&k\u0014)F%RKvlS#Z+\t\u0011)\u0003\u0005\u0003\u0002r\n\u001d\u0012\u0002BAN\u0003gD\u0011Ba\u000b\u0003\u0018\u0001\u0006IA!\n\u00021\t\u000bEk\u0011%`)&kUi\u0018)S\u001fB+%\u000bV-`\u0017\u0016K\u0006\u0005\u0003\u0006\u00030\t]!\u0019!C\u0001\u0005G\t\u0011dT+U!V#vl\u0014)`\u0013\u0012{\u0006KU(Q\u000bJ#\u0016lX&F3\"I!1\u0007B\fA\u0003%!QE\u0001\u001b\u001fV#\u0006+\u0016+`\u001fB{\u0016\nR0Q%>\u0003VI\u0015+Z?.+\u0015\f\t")
public class JobScheduler
implements Logging {
    private final StreamingContext ssc;
    private final Map<Time, JobSet> jobSets;
    private final int numConcurrentJobs;
    private final ThreadPoolExecutor jobExecutor;
    private final JobGenerator jobGenerator;
    private final Clock clock;
    private final StreamingListenerBus listenerBus;
    private ReceiverTracker receiverTracker;
    private InputInfoTracker inputInfoTracker;
    private Option<ExecutorAllocationManager> executorAllocationManager;
    private EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String OUTPUT_OP_ID_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY();
    }

    public static String BATCH_TIME_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    private Map<Time, JobSet> jobSets() {
        return this.jobSets;
    }

    private int numConcurrentJobs() {
        return this.numConcurrentJobs;
    }

    private ThreadPoolExecutor jobExecutor() {
        return this.jobExecutor;
    }

    private JobGenerator jobGenerator() {
        return this.jobGenerator;
    }

    public Clock clock() {
        return this.clock;
    }

    public StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker receiverTracker() {
        return this.receiverTracker;
    }

    public void receiverTracker_$eq(ReceiverTracker x$1) {
        this.receiverTracker = x$1;
    }

    public InputInfoTracker inputInfoTracker() {
        return this.inputInfoTracker;
    }

    public void inputInfoTracker_$eq(InputInfoTracker x$1) {
        this.inputInfoTracker = x$1;
    }

    private Option<ExecutorAllocationManager> executorAllocationManager() {
        return this.executorAllocationManager;
    }

    private void executorAllocationManager_$eq(Option<ExecutorAllocationManager> x$1) {
        this.executorAllocationManager = x$1;
    }

    public EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    }

    private void org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(EventLoop<JobSchedulerEvent> x$1) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = x$1;
    }

    public synchronized void start() {
        ExecutorAllocationClient executorAllocationClient;
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() != null) {
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting JobScheduler");
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(new EventLoop<JobSchedulerEvent>(this){
            private final /* synthetic */ JobScheduler $outer;

            public void onReceive(JobSchedulerEvent event) {
                this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(event);
            }

            public void onError(Throwable e) {
                this.$outer.reportError("Error in job scheduler", e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("JobScheduler");
            }
        });
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().start();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getInputStreams())).foreach((Function1 & Serializable & scala.Serializable)inputDStream -> {
            JobScheduler.$anonfun$start$2(this, inputDStream);
            return BoxedUnit.UNIT;
        });
        this.listenerBus().start();
        this.receiverTracker_$eq(new ReceiverTracker(this.ssc(), ReceiverTracker$.MODULE$.$lessinit$greater$default$2()));
        this.inputInfoTracker_$eq(new InputInfoTracker(this.ssc()));
        SchedulerBackend schedulerBackend = this.ssc().sparkContext().schedulerBackend();
        if (schedulerBackend instanceof ExecutorAllocationClient) {
            SchedulerBackend schedulerBackend2 = schedulerBackend;
            executorAllocationClient = (ExecutorAllocationClient)schedulerBackend2;
        } else {
            executorAllocationClient = null;
        }
        ExecutorAllocationClient executorAllocClient = executorAllocationClient;
        this.executorAllocationManager_$eq(ExecutorAllocationManager$.MODULE$.createIfEnabled(executorAllocClient, this.receiverTracker(), this.ssc().conf(), this.ssc().graph().batchDuration().milliseconds(), this.clock()));
        this.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)streamingListener -> {
            JobScheduler.$anonfun$start$4(this, streamingListener);
            return BoxedUnit.UNIT;
        });
        this.receiverTracker().start();
        this.jobGenerator().start();
        this.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started JobScheduler");
    }

    public synchronized void stop(boolean processAllReceivedData) {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping JobScheduler");
        if (this.receiverTracker() != null) {
            this.receiverTracker().stop(processAllReceivedData);
        }
        if (this.executorAllocationManager() != null) {
            this.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.stop();
                return BoxedUnit.UNIT;
            });
        }
        this.jobGenerator().stop(processAllReceivedData);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping job executor");
        this.jobExecutor().shutdown();
        boolean terminated = processAllReceivedData ? this.jobExecutor().awaitTermination(1L, TimeUnit.HOURS) : this.jobExecutor().awaitTermination(2L, TimeUnit.SECONDS);
        Object object = !terminated ? this.jobExecutor().shutdownNow() : BoxedUnit.UNIT;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped job executor");
        this.listenerBus().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(null);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped JobScheduler");
    }

    public void submitJobSet(JobSet jobSet) {
        if (jobSet.jobs().isEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("No jobs added for time ").append(jobSet.time()).toString());
        } else {
            this.listenerBus().post(new StreamingListenerBatchSubmitted(jobSet.toBatchInfo()));
            this.jobSets().put(jobSet.time(), jobSet);
            jobSet.jobs().foreach((Function1 & Serializable & scala.Serializable)job -> {
                JobScheduler.$anonfun$submitJobSet$2(this, job);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Added jobs for time ").append(jobSet.time()).toString());
        }
    }

    public Seq<Time> getPendingTimes() {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.jobSets()).asScala()).keys().toSeq();
    }

    public void reportError(String msg, Throwable e) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().post((Object)new ErrorReported(msg, e));
    }

    public synchronized boolean isStarted() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() != null;
    }

    public void org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(JobSchedulerEvent event) {
        block5: {
            try {
                JobSchedulerEvent jobSchedulerEvent = event;
                if (jobSchedulerEvent instanceof JobStarted) {
                    JobStarted jobStarted = (JobStarted)jobSchedulerEvent;
                    Job job = jobStarted.job();
                    long startTime = jobStarted.startTime();
                    this.handleJobStart(job, startTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof JobCompleted) {
                    JobCompleted jobCompleted = (JobCompleted)jobSchedulerEvent;
                    Job job = jobCompleted.job();
                    long completedTime = jobCompleted.completedTime();
                    this.handleJobCompletion(job, completedTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof ErrorReported) {
                    ErrorReported errorReported = (ErrorReported)jobSchedulerEvent;
                    String m = errorReported.msg();
                    Throwable e = errorReported.e();
                    this.handleError(m, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError((Object)jobSchedulerEvent);
            }
            catch (Throwable e) {
                this.reportError("Error in job scheduler", e);
            }
        }
    }

    private void handleJobStart(Job job, long startTime) {
        JobSet jobSet = this.jobSets().get(job.time());
        boolean isFirstJobOfJobSet = !jobSet.hasStarted();
        jobSet.handleJobStart(job);
        if (isFirstJobOfJobSet) {
            this.listenerBus().post(new StreamingListenerBatchStarted(jobSet.toBatchInfo()));
        }
        job.setStartTime(startTime);
        this.listenerBus().post(new StreamingListenerOutputOperationStarted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Starting job ").append(job.id()).append(" from job set of time ").append(jobSet.time()).toString());
    }

    private void handleJobCompletion(Job job, long completedTime) {
        Try<?> try_;
        JobSet jobSet = this.jobSets().get(job.time());
        jobSet.handleJobCompletion(job);
        job.setEndTime(completedTime);
        this.listenerBus().post(new StreamingListenerOutputOperationCompleted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Finished job ").append(job.id()).append(" from job set of time ").append(jobSet.time()).toString());
        if (jobSet.hasCompleted()) {
            this.listenerBus().post(new StreamingListenerBatchCompleted(jobSet.toBatchInfo()));
        }
        if ((try_ = job.result()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.reportError(new StringBuilder(18).append("Error running job ").append(job).toString(), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (jobSet.hasCompleted()) {
                this.jobSets().remove(jobSet.time());
                this.jobGenerator().onBatchCompletion(jobSet.time());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Total delay: %.3f s for time %s (execution: %.3f s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)jobSet.totalDelay() / 1000.0)), jobSet.time().toString(), BoxesRunTime.boxToDouble((double)((double)jobSet.processingDelay() / 1000.0))})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void handleError(String msg, Throwable e) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
        this.ssc().waiter().notifyError(e);
        PythonDStream$.MODULE$.stopStreamingContextIfPythonProcessIsDead(e);
    }

    public static final /* synthetic */ void $anonfun$start$3(JobScheduler $this, RateController rateController) {
        $this.ssc().addStreamingListener(rateController);
    }

    public static final /* synthetic */ void $anonfun$start$2(JobScheduler $this, InputDStream inputDStream) {
        inputDStream.rateController().foreach((Function1 & Serializable & scala.Serializable)rateController -> {
            JobScheduler.$anonfun$start$3($this, rateController);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$start$4(JobScheduler $this, StreamingListener streamingListener) {
        $this.ssc().addStreamingListener(streamingListener);
    }

    public static final /* synthetic */ void $anonfun$submitJobSet$2(JobScheduler $this, Job job) {
        $this.jobExecutor().execute(new JobHandler($this, job));
    }

    public JobScheduler(StreamingContext ssc) {
        this.ssc = ssc;
        Logging.$init$((Logging)this);
        this.jobSets = new ConcurrentHashMap<Time, JobSet>();
        this.numConcurrentJobs = ssc.conf().getInt("spark.streaming.concurrentJobs", 1);
        this.jobExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.numConcurrentJobs(), "streaming-job-executor");
        this.jobGenerator = new JobGenerator(this);
        this.clock = this.jobGenerator().clock();
        this.listenerBus = new StreamingListenerBus(ssc.sparkContext().listenerBus());
        this.receiverTracker = null;
        this.inputInfoTracker = null;
        this.executorAllocationManager = None$.MODULE$;
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = null;
    }

    public class JobHandler
    implements Runnable,
    Logging {
        private final Job job;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ JobScheduler $outer;

        public String logName() {
            return Logging.logName$((Logging)this);
        }

        public Logger log() {
            return Logging.log$((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.logInfo$((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.logDebug$((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.logTrace$((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.logWarning$((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.logError$((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
        }

        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$((Logging)this);
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        @Override
        public void run() {
            Properties oldProps = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().getLocalProperties();
            try {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperties((Properties)SerializationUtils.clone((Serializable)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().savedProperties().get()));
                String formattedTime = UIUtils$.MODULE$.formatBatchTime(this.job.time().milliseconds(), this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().graph().batchDuration().milliseconds(), false, UIUtils$.MODULE$.formatBatchTime$default$4());
                String batchUrl = new StringBuilder(21).append("/streaming/batch/?id=").append(this.job.time().milliseconds()).toString();
                String batchLinkText = new StringBuilder(32).append("[output operation ").append(this.job.outputOpId()).append(", batch time ").append(formattedTime).append("]").toString();
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setJobDescription(new StringBuilder(34).append("Streaming job from <a href=\"").append(batchUrl).append("\">").append(batchLinkText).append("</a>").toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.job.time().milliseconds())).toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToInteger((int)this.job.outputOpId())).toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS(), "true");
                EventLoop<JobSchedulerEvent> _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                if (_eventLoop != null) {
                    _eventLoop.post((Object)new JobStarted(this.job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    SparkHadoopWriterUtils$.MODULE$.disableOutputSpecValidation().withValue((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.job.run());
                    _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                    if (_eventLoop != null) {
                        _eventLoop.post((Object)new JobCompleted(this.job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    }
                }
            }
            finally {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperties(oldProps);
            }
        }

        public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer() {
            return this.$outer;
        }

        public JobHandler(JobScheduler $outer, Job job) {
            this.job = job;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.$init$((Logging)this);
        }
    }
}

