/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogRandomReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogWriter;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BufferLike;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r=d!B\u0001\u0003\u0001\u0011a!A\u0006$jY\u0016\u0014\u0015m]3e/JLG/Z!iK\u0006$Gj\\4\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i\u0011\u0003\u0005\u0002\u000f\u001f5\t!!\u0003\u0002\u0011\u0005\tiqK]5uK\u0006CW-\u00193M_\u001e\u0004\"AE\u000b\u000e\u0003MQ!\u0001\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!AF\n\u0003\u000f1{wmZ5oO\"A\u0001\u0004\u0001B\u0001B\u0003%!$\u0001\u0003d_:47\u0001\u0001\t\u00037qi\u0011AB\u0005\u0003;\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nA\u0002\\8h\t&\u0014Xm\u0019;pef\u0004\"!\t\u0016\u000f\u0005\tB\u0003CA\u0012'\u001b\u0005!#BA\u0013\u001a\u0003\u0019a$o\\8u})\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003aQj\u0011!\r\u0006\u00031IR!a\r\u0005\u0002\r!\fGm\\8q\u0013\t)\u0014GA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005\u0019\"o\u001c7mS:<\u0017J\u001c;feZ\fGnU3dgB\u0011\u0011HO\u0007\u0002M%\u00111H\n\u0002\u0004\u0013:$\b\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u00175\f\u0007PR1jYV\u0014Xm\u001d\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006\u00192\r\\8tK\u001aKG.Z!gi\u0016\u0014xK]5uKB\u0011\u0011(Q\u0005\u0003\u0005\u001a\u0012qAQ8pY\u0016\fg\u000eC\u0003E\u0001\u0011\u0005Q)\u0001\u0004=S:LGO\u0010\u000b\b\r\u001eC\u0015JS&M!\tq\u0001\u0001C\u0003\u0019\u0007\u0002\u0007!\u0004C\u0003 \u0007\u0002\u0007\u0001\u0005C\u0003/\u0007\u0002\u0007q\u0006C\u00038\u0007\u0002\u0007\u0001\bC\u0003>\u0007\u0002\u0007\u0001\bC\u0003@\u0007\u0002\u0007\u0001\tC\u0004O\u0001\t\u0007I\u0011B(\u0002\u0011A\f7\u000f\u001e'pON,\u0012\u0001\u0015\t\u0004#ZCV\"\u0001*\u000b\u0005M#\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003+\u001a\n!bY8mY\u0016\u001cG/[8o\u0013\t9&KA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA-e\u001d\tq!l\u0002\u0004\\\u0005!\u0005A\u0001X\u0001\u0017\r&dWMQ1tK\u0012<&/\u001b;f\u0003\",\u0017\r\u001a'pOB\u0011a\"\u0018\u0004\u0007\u0003\tA\t\u0001\u00020\u0014\u0005u{\u0006CA\u001da\u0013\t\tgE\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\tv#\ta\u0019\u000b\u00029\u001a!Q-\u0018!g\u0005\u001daunZ%oM>\u001cB\u0001Z0hUB\u0011\u0011\b[\u0005\u0003S\u001a\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002:W&\u0011AN\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t]\u0012\u0014)\u001a!C\u0001_\u0006I1\u000f^1siRKW.Z\u000b\u0002aB\u0011\u0011(]\u0005\u0003e\u001a\u0012A\u0001T8oO\"AA\u000f\u001aB\tB\u0003%\u0001/\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002B\u0001B\u001e3\u0003\u0016\u0004%\ta\\\u0001\bK:$G+[7f\u0011!AHM!E!\u0002\u0013\u0001\u0018\u0001C3oIRKW.\u001a\u0011\t\u0011i$'Q3A\u0005\u0002m\fA\u0001]1uQV\t\u0001\u0005\u0003\u0005~I\nE\t\u0015!\u0003!\u0003\u0015\u0001\u0018\r\u001e5!\u0011\u0015!E\r\"\u0001\u0000)!\t\t!!\u0002\u0002\b\u0005%\u0001cAA\u0002I6\tQ\fC\u0003o}\u0002\u0007\u0001\u000fC\u0003w}\u0002\u0007\u0001\u000fC\u0003{}\u0002\u0007\u0001\u0005C\u0005\u0002\u000e\u0011\f\t\u0011\"\u0001\u0002\u0010\u0005!1m\u001c9z)!\t\t!!\u0005\u0002\u0014\u0005U\u0001\u0002\u00038\u0002\fA\u0005\t\u0019\u00019\t\u0011Y\fY\u0001%AA\u0002AD\u0001B_A\u0006!\u0003\u0005\r\u0001\t\u0005\n\u00033!\u0017\u0013!C\u0001\u00037\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001e)\u001a\u0001/a\b,\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000b'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\t)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\re#\u0003%\t!a\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011q\u00073\u0012\u0002\u0013\u0005\u0011\u0011H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYDK\u0002!\u0003?A\u0011\"a\u0010e\u0003\u0003%\t%!\u0011\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\nAA[1wC&\u00191&a\u0012\t\u0013\u0005MC-!A\u0005\u0002\u0005U\u0013\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001\u001d\t\u0013\u0005eC-!A\u0005\u0002\u0005m\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\n\u0019\u0007E\u0002:\u0003?J1!!\u0019'\u0005\r\te.\u001f\u0005\n\u0003K\n9&!AA\u0002a\n1\u0001\u001f\u00132\u0011%\tI\u0007ZA\u0001\n\u0003\nY'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0007\u0005\u0004\u0002p\u0005E\u0014QL\u0007\u0002)&\u0019\u00111\u000f+\u0003\u0011%#XM]1u_JD\u0011\"a\u001ee\u0003\u0003%\t!!\u001f\u0002\u0011\r\fg.R9vC2$2\u0001QA>\u0011)\t)'!\u001e\u0002\u0002\u0003\u0007\u0011Q\f\u0005\n\u0003\u007f\"\u0017\u0011!C!\u0003\u0003\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002q!I\u0011Q\u00113\u0002\u0002\u0013\u0005\u0013qQ\u0001\ti>\u001cFO]5oOR\u0011\u00111\t\u0005\n\u0003\u0017#\u0017\u0011!C!\u0003\u001b\u000ba!Z9vC2\u001cHc\u0001!\u0002\u0010\"Q\u0011QMAE\u0003\u0003\u0005\r!!\u0018\b\u0013\u0005MU,!A\t\u0002\u0005U\u0015a\u0002'pO&sgm\u001c\t\u0005\u0003\u0007\t9J\u0002\u0005f;\u0006\u0005\t\u0012AAM'\u0015\t9*a'k!%\ti*a)qa\u0002\n\t!\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\u0014\u0002\u000fI,h\u000e^5nK&!\u0011QUAP\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\b\t\u0006]E\u0011AAU)\t\t)\n\u0003\u0006\u0002\u0006\u0006]\u0015\u0011!C#\u0003\u000fC!\"a,\u0002\u0018\u0006\u0005I\u0011QAY\u0003\u0015\t\u0007\u000f\u001d7z)!\t\t!a-\u00026\u0006]\u0006B\u00028\u0002.\u0002\u0007\u0001\u000f\u0003\u0004w\u0003[\u0003\r\u0001\u001d\u0005\u0007u\u00065\u0006\u0019\u0001\u0011\t\u0015\u0005m\u0016qSA\u0001\n\u0003\u000bi,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00161\u001a\t\u0006s\u0005\u0005\u0017QY\u0005\u0004\u0003\u00074#AB(qi&|g\u000e\u0005\u0004:\u0003\u000f\u0004\b\u000fI\u0005\u0004\u0003\u00134#A\u0002+va2,7\u0007\u0003\u0006\u0002N\u0006e\u0016\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00131\u0011)\t\t.a&\u0002\u0002\u0013%\u00111[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002VB!\u0011QIAl\u0013\u0011\tI.a\u0012\u0003\r=\u0013'.Z2u\u0011%\ti.\u0018b\u0001\n\u0003\ty.\u0001\u0007m_\u001e4\u0015\u000e\\3SK\u001e,\u00070\u0006\u0002\u0002bB!\u00111]Av\u001b\t\t)O\u0003\u0003\u0002h\u0006%\u0018\u0001C7bi\u000eD\u0017N\\4\u000b\u0005\r1\u0013\u0002BAw\u0003K\u0014QAU3hKbD\u0001\"!=^A\u0003%\u0011\u0011]\u0001\u000eY><g)\u001b7f%\u0016<W\r\u001f\u0011\t\u000f\u0005UX\f\"\u0001\u0002x\u0006iA/[7f)>dun\u001a$jY\u0016$R\u0001IA}\u0003wDaA\\Az\u0001\u0004\u0001\bbBA\u007f\u0003g\u0004\r\u0001]\u0001\tgR|\u0007\u000fV5nK\"9!\u0011A/\u0005\u0002\t\r\u0011!D4fi\u000e\u000bG\u000e\\3s\u001d\u0006lW\r\u0006\u0002\u0003\u0006A!\u0011(!1!\u0011\u001d\u0011I!\u0018C\u0001\u0005\u0017\t\u0011\u0003\\8h\r&dWm\u001d+pY><\u0017J\u001c4p)\u0011\u0011iAa\b\u0011\r\t=!\u0011DA\u0001\u001d\u0011\u0011\tB!\u0006\u000f\u0007\r\u0012\u0019\"C\u0001(\u0013\r\u00119BJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YB!\b\u0003\u0007M+\u0017OC\u0002\u0003\u0018\u0019B\u0001B!\t\u0003\b\u0001\u0007!1E\u0001\u0006M&dWm\u001d\t\u0007\u0005\u001f\u0011IB!\n\u0011\t\t\u001d\"QF\u0007\u0003\u0005SQ1Aa\u000b3\u0003\t17/\u0003\u0003\u00030\t%\"\u0001\u0002)bi\"DqAa\r^\t\u0003\u0011)$\u0001\ttKF$v\u000eU1s\u0013R,'/\u0019;peV1!q\u0007B3\u0005\u0003\"\u0002B!\u000f\u0003N\tu#\u0011\u000e\t\u0007\u0005\u001f\u0011YD!\u0010\n\t\u0005M$Q\u0004\t\u0005\u0005\u007f\u0011\t\u0005\u0004\u0001\u0005\u0011\t\r#\u0011\u0007b\u0001\u0005\u000b\u0012\u0011aT\t\u0005\u0005\u000f\ni\u0006E\u0002:\u0005\u0013J1Aa\u0013'\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001Ba\u0014\u00032\u0001\u0007!\u0011K\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004BAa\u0015\u0003Z5\u0011!Q\u000b\u0006\u0004\u0005/2\u0013AC2p]\u000e,(O]3oi&!!1\fB+\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0005\u0003`\tE\u0002\u0019\u0001B1\u0003\u0019\u0019x.\u001e:dKB1!q\u0002B\r\u0005G\u0002BAa\u0010\u0003f\u0011A!q\rB\u0019\u0005\u0004\u0011)EA\u0001J\u0011!\u0011YG!\rA\u0002\t5\u0014a\u00025b]\u0012dWM\u001d\t\bs\t=$1\rB\u001d\u0013\r\u0011\tH\n\u0002\n\rVt7\r^5p]FBqA!\u001e\u0001A\u0003%\u0001+A\u0005qCN$Hj\\4tA!I!\u0011\u0010\u0001C\u0002\u0013%!1P\u0001\u000bG\u0006dG.\u001a:OC6,WC\u0001B\u0003\u0011!\u0011y\b\u0001Q\u0001\n\t\u0015\u0011aC2bY2,'OT1nK\u0002B\u0011Ba!\u0001\u0005\u0004%I!!\u0011\u0002\u001dQD'/Z1ea>|GNT1nK\"A!q\u0011\u0001!\u0002\u0013\t\u0019%A\buQJ,\u0017\r\u001a9p_2t\u0015-\\3!\u0011%\u0011Y\t\u0001b\u0001\n\u0013\u0011i)\u0001\u0007g_J\\'j\\5o!>|G.\u0006\u0002\u0003\u0010B!!\u0011\u0013BQ\u001d\u0011\u0011\u0019J!(\u000f\t\tU%\u0011\u0014\b\u0005\u0005#\u00119*C\u0002\u0003X\u0019JAAa'\u0003V\u0005Aam\u001c:lU>Lg.\u0003\u0003\u0003\u0018\t}%\u0002\u0002BN\u0005+JAAa)\u0003&\naai\u001c:l\u0015>Lg\u000eU8pY*!!q\u0003BP\u0011!\u0011I\u000b\u0001Q\u0001\n\t=\u0015!\u00044pe.Tu.\u001b8Q_>d\u0007\u0005C\u0005\u0003P\u0001\u0011\r\u0011\"\u0003\u0003.V\u0011!q\u0016\t\u0005\u0005'\u0012\t,\u0003\u0003\u00034\nU#aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\"A!q\u0017\u0001!\u0002\u0013\u0011y+A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002BqAa/\u0001\t#\n\t%A\u0004m_\u001et\u0015-\\3\t\u0013\t}\u0006\u00011A\u0005\n\tm\u0014AD2veJ,g\u000e\u001e'pOB\u000bG\u000f\u001b\u0005\n\u0005\u0007\u0004\u0001\u0019!C\u0005\u0005\u000b\f!cY;se\u0016tG\u000fT8h!\u0006$\bn\u0018\u0013fcR!!q\u0019Bg!\rI$\u0011Z\u0005\u0004\u0005\u00174#\u0001B+oSRD!\"!\u001a\u0003B\u0006\u0005\t\u0019\u0001B\u0003\u0011!\u0011\t\u000e\u0001Q!\n\t\u0015\u0011aD2veJ,g\u000e\u001e'pOB\u000bG\u000f\u001b\u0011\t\u0013\tU\u0007\u00011A\u0005\n\t]\u0017\u0001E2veJ,g\u000e\u001e'pO^\u0013\u0018\u000e^3s+\t\u0011I\u000eE\u0002\u000f\u00057L1A!8\u0003\u0005q1\u0015\u000e\\3CCN,Gm\u0016:ji\u0016\f\u0005.Z1e\u0019><wK]5uKJD\u0011B!9\u0001\u0001\u0004%IAa9\u0002)\r,(O]3oi2{wm\u0016:ji\u0016\u0014x\fJ3r)\u0011\u00119M!:\t\u0015\u0005\u0015$q\\A\u0001\u0002\u0004\u0011I\u000e\u0003\u0005\u0003j\u0002\u0001\u000b\u0015\u0002Bm\u0003E\u0019WO\u001d:f]RdunZ,sSR,'\u000f\t\u0005\t\u0005[\u0004\u0001\u0019!C\u0005_\u0006I2-\u001e:sK:$Hj\\4Xe&$XM]*uCJ$H+[7f\u0011%\u0011\t\u0010\u0001a\u0001\n\u0013\u0011\u00190A\u000fdkJ\u0014XM\u001c;M_\u001e<&/\u001b;feN#\u0018M\u001d;US6,w\fJ3r)\u0011\u00119M!>\t\u0013\u0005\u0015$q^A\u0001\u0002\u0004\u0001\bb\u0002B}\u0001\u0001\u0006K\u0001]\u0001\u001bGV\u0014(/\u001a8u\u0019><wK]5uKJ\u001cF/\u0019:u)&lW\r\t\u0005\t\u0005{\u0004\u0001\u0019!C\u0005_\u0006A2-\u001e:sK:$Hj\\4Xe&$XM]*u_B$\u0016.\\3\t\u0013\r\u0005\u0001\u00011A\u0005\n\r\r\u0011\u0001H2veJ,g\u000e\u001e'pO^\u0013\u0018\u000e^3s'R|\u0007\u000fV5nK~#S-\u001d\u000b\u0005\u0005\u000f\u001c)\u0001C\u0005\u0002f\t}\u0018\u0011!a\u0001a\"91\u0011\u0002\u0001!B\u0013\u0001\u0018!G2veJ,g\u000e\u001e'pO^\u0013\u0018\u000e^3s'R|\u0007\u000fV5nK\u0002Bqa!\u0004\u0001\t\u0003\u0019y!A\u0003xe&$X\r\u0006\u0004\u0004\u0012\r]1q\u0005\t\u0004\u001d\rM\u0011bAB\u000b\u0005\tib)\u001b7f\u0005\u0006\u001cX\rZ,sSR,\u0017\t[3bI2{wmU3h[\u0016tG\u000f\u0003\u0005\u0004\u001a\r-\u0001\u0019AB\u000e\u0003)\u0011\u0017\u0010^3Ck\u001a4WM\u001d\t\u0005\u0007;\u0019\u0019#\u0004\u0002\u0004 )!1\u0011EA&\u0003\rq\u0017n\\\u0005\u0005\u0007K\u0019yB\u0001\u0006CsR,')\u001e4gKJDqa!\u000b\u0004\f\u0001\u0007\u0001/\u0001\u0003uS6,\u0007bBB\u0017\u0001\u0011\u00051qF\u0001\u0005e\u0016\fG\r\u0006\u0003\u0004\u001c\rE\u0002\u0002CB\u001a\u0007W\u0001\ra!\u000e\u0002\u000fM,w-\\3oiB\u0019aba\u000e\n\u0007\re\"AA\rXe&$X-\u00115fC\u0012dun\u001a*fG>\u0014H\rS1oI2,\u0007bBB\u001f\u0001\u0011\u00051qH\u0001\be\u0016\fG-\u00117m)\t\u0019\t\u0005\u0005\u0004\u0004D\r\u001d31D\u0007\u0003\u0007\u000bR1aAA&\u0013\u0011\t\u0019h!\u0012\t\u000f\r-\u0003\u0001\"\u0001\u0004N\u0005)1\r\\3b]R1!qYB(\u0007'Bqa!\u0015\u0004J\u0001\u0007\u0001/\u0001\u0006uQJ,7\u000f\u001b+j[\u0016Dqa!\u0016\u0004J\u0001\u0007\u0001)A\txC&$hi\u001c:D_6\u0004H.\u001a;j_:Dqa!\u0017\u0001\t\u0003\u0019Y&A\u0003dY>\u001cX\r\u0006\u0002\u0003H\"91q\f\u0001\u0005\n\r\u0005\u0014\u0001D4fi2{wm\u0016:ji\u0016\u0014H\u0003\u0002Bm\u0007GBqa!\u001a\u0004^\u0001\u0007\u0001/A\u0006dkJ\u0014XM\u001c;US6,\u0007bBB5\u0001\u0011%11L\u0001\u0014S:LG/[1mSj,wJ\u001d*fG>4XM\u001d\u0005\b\u0007[\u0002A\u0011BB.\u0003-\u0011Xm]3u/JLG/\u001a:")
public class FileBasedWriteAheadLog
extends WriteAheadLog
implements Logging {
    private final String logDirectory;
    private final Configuration hadoopConf;
    private final int rollingIntervalSecs;
    private final int maxFailures;
    private final boolean closeFileAfterWrite;
    private final ArrayBuffer<LogInfo> pastLogs;
    private final Option<String> callerName;
    private final String threadpoolName;
    private final ForkJoinPool forkJoinPool;
    private final ExecutionContextExecutorService executionContext;
    private Option<String> currentLogPath;
    private FileBasedWriteAheadLogWriter currentLogWriter;
    private long currentLogWriterStartTime;
    private long currentLogWriterStopTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <I, O> Iterator<O> seqToParIterator(ExecutionContext executionContext, Seq<I> seq, Function1<I, Iterator<O>> function1) {
        return FileBasedWriteAheadLog$.MODULE$.seqToParIterator(executionContext, seq, function1);
    }

    public static Seq<LogInfo> logFilesTologInfo(Seq<Path> seq) {
        return FileBasedWriteAheadLog$.MODULE$.logFilesTologInfo(seq);
    }

    public static Option<String> getCallerName() {
        return FileBasedWriteAheadLog$.MODULE$.getCallerName();
    }

    public static String timeToLogFile(long l, long l2) {
        return FileBasedWriteAheadLog$.MODULE$.timeToLogFile(l, l2);
    }

    public static Regex logFileRegex() {
        return FileBasedWriteAheadLog$.MODULE$.logFileRegex();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArrayBuffer<LogInfo> pastLogs() {
        return this.pastLogs;
    }

    private Option<String> callerName() {
        return this.callerName;
    }

    private String threadpoolName() {
        return this.threadpoolName;
    }

    private ForkJoinPool forkJoinPool() {
        return this.forkJoinPool;
    }

    private ExecutionContextExecutorService executionContext() {
        return this.executionContext;
    }

    public String logName() {
        return new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).stripSuffix("$")).append(((String)this.callerName().map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("_").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).replaceAll("[ ]", "_")).toString();
    }

    private Option<String> currentLogPath() {
        return this.currentLogPath;
    }

    private void currentLogPath_$eq(Option<String> x$1) {
        this.currentLogPath = x$1;
    }

    private FileBasedWriteAheadLogWriter currentLogWriter() {
        return this.currentLogWriter;
    }

    private void currentLogWriter_$eq(FileBasedWriteAheadLogWriter x$1) {
        this.currentLogWriter = x$1;
    }

    private long currentLogWriterStartTime() {
        return this.currentLogWriterStartTime;
    }

    private void currentLogWriterStartTime_$eq(long x$1) {
        this.currentLogWriterStartTime = x$1;
    }

    private long currentLogWriterStopTime() {
        return this.currentLogWriterStopTime;
    }

    private void currentLogWriterStopTime_$eq(long x$1) {
        this.currentLogWriterStopTime = x$1;
    }

    @Override
    public synchronized FileBasedWriteAheadLogSegment write(ByteBuffer byteBuffer, long time) {
        FileBasedWriteAheadLogSegment fileSegment = null;
        IntRef failures = IntRef.create((int)0);
        Exception lastException = null;
        boolean succeeded = false;
        while (!succeeded && failures.elem < this.maxFailures) {
            try {
                fileSegment = this.getLogWriter(time).write(byteBuffer);
                if (this.closeFileAfterWrite) {
                    this.resetWriter();
                }
                succeeded = true;
            }
            catch (Exception ex) {
                lastException = ex;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to write to write ahead log");
                this.resetWriter();
                ++failures.elem;
            }
        }
        if (fileSegment == null) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Failed to write to write ahead log after ").append(failures$1.elem).append(" failures").toString());
            throw lastException;
        }
        return fileSegment;
    }

    @Override
    public ByteBuffer read(WriteAheadLogRecordHandle segment) {
        FileBasedWriteAheadLogSegment fileSegment = (FileBasedWriteAheadLogSegment)segment;
        ByteBuffer byteBuffer = null;
        try (FileBasedWriteAheadLogRandomReader reader = null;){
            reader = new FileBasedWriteAheadLogRandomReader(fileSegment.path(), this.hadoopConf);
            byteBuffer = reader.read(fileSegment);
        }
        return byteBuffer;
    }

    @Override
    public synchronized java.util.Iterator<ByteBuffer> readAll() {
        ArrayBuffer logFilesToRead = (ArrayBuffer)((BufferLike)this.pastLogs().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.path(), ArrayBuffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.currentLogPath()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Reading from the logs:\n").append(logFilesToRead.mkString("\n")).toString());
        return !this.closeFileAfterWrite ? (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)logFilesToRead.iterator().map((Function1 & Serializable & scala.Serializable)file -> this.readFile$1((String)file)), (Function1)Predef$.MODULE$.$conforms()).flatten()).asJava() : (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(FileBasedWriteAheadLog$.MODULE$.seqToParIterator((ExecutionContext)this.executionContext(), logFilesToRead, (Function1 & Serializable & scala.Serializable)file -> this.readFile$1((String)file))).asJava();
    }

    @Override
    public void clean(long threshTime, boolean waitForCompletion) {
        ArrayBuffer arrayBuffer;
        FileBasedWriteAheadLog fileBasedWriteAheadLog = this;
        synchronized (fileBasedWriteAheadLog) {
            ArrayBuffer expiredLogs = (ArrayBuffer)this.pastLogs().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileBasedWriteAheadLog.$anonfun$clean$1(threshTime, x$3)));
            this.pastLogs().$minus$minus$eq((TraversableOnce)expiredLogs);
            arrayBuffer = expiredLogs;
        }
        ArrayBuffer oldLogFiles = arrayBuffer;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Attempting to clear ").append(oldLogFiles.size()).append(" old log files in ").append($this.logDirectory).append(" ").append(new StringBuilder(13).append("older than ").append(threshTime).append(": ").append(((TraversableOnce)oldLogFiles.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.path(), ArrayBuffer$.MODULE$.canBuildFrom())).mkString("\n")).toString()).toString());
        oldLogFiles.foreach((Function1 & Serializable & scala.Serializable)logInfo -> {
            BoxedUnit boxedUnit;
            block5: {
                if (!this.executionContext().isShutdown()) {
                    try {
                        Future f = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.deleteFile$1((LogInfo)logInfo, threshTime), (ExecutionContext)this.executionContext());
                        if (waitForCompletion) {
                            boxedUnit = Await$.MODULE$.ready((Awaitable)f, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
                            break block5;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (RejectedExecutionException e) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Execution context shutdown before deleting old WriteAheadLogs. This would not affect recovery correctness.", e);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
    }

    @Override
    public synchronized void close() {
        if (!this.executionContext().isShutdown()) {
            if (this.currentLogWriter() != null) {
                this.currentLogWriter().close();
            }
            this.executionContext().shutdown();
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped write ahead log manager");
    }

    private synchronized FileBasedWriteAheadLogWriter getLogWriter(long currentTime) {
        block0: {
            if (this.currentLogWriter() != null && currentTime <= this.currentLogWriterStopTime()) break block0;
            this.resetWriter();
            this.currentLogPath().foreach((Function1 & Serializable & scala.Serializable)x$5 -> this.pastLogs().$plus$eq((Object)new LogInfo(this.currentLogWriterStartTime(), this.currentLogWriterStopTime(), (String)x$5)));
            this.currentLogWriterStartTime_$eq(currentTime);
            this.currentLogWriterStopTime_$eq(currentTime + (long)this.rollingIntervalSecs * 1000L);
            Path newLogPath = new Path(this.logDirectory, FileBasedWriteAheadLog$.MODULE$.timeToLogFile(this.currentLogWriterStartTime(), this.currentLogWriterStopTime()));
            this.currentLogPath_$eq((Option<String>)new Some((Object)newLogPath.toString()));
            this.currentLogWriter_$eq(new FileBasedWriteAheadLogWriter((String)this.currentLogPath().get(), this.hadoopConf));
        }
        return this.currentLogWriter();
    }

    private synchronized void initializeOrRecover() {
        Path logDirectoryPath = new Path(this.logDirectory);
        FileSystem fileSystem = HdfsUtils$.MODULE$.getFileSystemForPath(logDirectoryPath, this.hadoopConf);
        try {
            if (fileSystem.getFileStatus(logDirectoryPath).isDirectory()) {
                Seq<LogInfo> logFileInfo = FileBasedWriteAheadLog$.MODULE$.logFilesTologInfo((Seq<Path>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem.listStatus(logDirectoryPath))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPath(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                this.pastLogs().clear();
                this.pastLogs().$plus$plus$eq(logFileInfo);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Recovered ").append(logFileInfo.size()).append(" write ahead log files from ").append($this.logDirectory).toString());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Recovered files are:\n").append(((TraversableOnce)logFileInfo.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.path(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    private synchronized void resetWriter() {
        block0: {
            if (this.currentLogWriter() == null) break block0;
            this.currentLogWriter().close();
            this.currentLogWriter_$eq(null);
        }
    }

    private final Iterator readFile$1(String file) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Creating log reader with ").append(file).toString());
        FileBasedWriteAheadLogReader reader = new FileBasedWriteAheadLogReader(file, this.hadoopConf);
        return CompletionIterator$.MODULE$.apply((Iterator)reader, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JFunction0.mcV.sp & Serializable & scala.Serializable cfr_ignored_0 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close();
        });
    }

    public static final /* synthetic */ boolean $anonfun$clean$1(long threshTime$1, LogInfo x$3) {
        return x$3.endTime() < threshTime$1;
    }

    private final void deleteFile$1(LogInfo walInfo, long threshTime$1) {
        try {
            Path path = new Path(walInfo.path());
            FileSystem fs = HdfsUtils$.MODULE$.getFileSystemForPath(path, this.hadoopConf);
            fs.delete(path, true);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Cleared log file ").append(walInfo).toString());
        }
        catch (Exception ex) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error clearing write ahead log file ").append(walInfo).toString(), ex);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleared log files in ").append($this.logDirectory).append(" older than ").append(threshTime$1).toString());
    }

    public FileBasedWriteAheadLog(SparkConf conf, String logDirectory, Configuration hadoopConf, int rollingIntervalSecs, int maxFailures, boolean closeFileAfterWrite) {
        this.logDirectory = logDirectory;
        this.hadoopConf = hadoopConf;
        this.rollingIntervalSecs = rollingIntervalSecs;
        this.maxFailures = maxFailures;
        this.closeFileAfterWrite = closeFileAfterWrite;
        Logging.$init$((Logging)this);
        this.pastLogs = new ArrayBuffer();
        this.callerName = FileBasedWriteAheadLog$.MODULE$.getCallerName();
        this.threadpoolName = new StringBuilder(20).append("WriteAheadLogManager").append(this.callerName().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(5).append(" for ").append((String)c).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        this.forkJoinPool = ThreadUtils$.MODULE$.newForkJoinPool(this.threadpoolName(), 20);
        this.executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.forkJoinPool());
        this.currentLogPath = None$.MODULE$;
        this.currentLogWriter = null;
        this.currentLogWriterStartTime = -1L;
        this.currentLogWriterStopTime = -1L;
        this.initializeOrRecover();
    }

    public static class LogInfo
    implements Product,
    scala.Serializable {
        private final long startTime;
        private final long endTime;
        private final String path;

        public long startTime() {
            return this.startTime;
        }

        public long endTime() {
            return this.endTime;
        }

        public String path() {
            return this.path;
        }

        public LogInfo copy(long startTime, long endTime, String path) {
            return new LogInfo(startTime, endTime, path);
        }

        public long copy$default$1() {
            return this.startTime();
        }

        public long copy$default$2() {
            return this.endTime();
        }

        public String copy$default$3() {
            return this.path();
        }

        public String productPrefix() {
            return "LogInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.startTime());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.endTime());
                    break;
                }
                case 2: {
                    object = this.path();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.startTime()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.endTime()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LogInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            LogInfo logInfo = (LogInfo)x$1;
            if (this.startTime() != logInfo.startTime()) return false;
            if (this.endTime() != logInfo.endTime()) return false;
            String string = this.path();
            String string2 = logInfo.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!logInfo.canEqual(this)) return false;
            return true;
        }

        public LogInfo(long startTime, long endTime, String path) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.path = path;
            Product.$init$((Product)this);
        }
    }
}

