/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0001\t1\u0011ADR5mK\n\u000b7/\u001a3Xe&$X-\u00115fC\u0012dunZ,sSR,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bU\u0001\"AD\n\u000e\u0003=Q!\u0001E\t\u0002\t1\fgn\u001a\u0006\u0002%\u0005!!.\u0019<b\u0013\t!rB\u0001\u0004PE*,7\r\u001e\t\u0003-ei\u0011a\u0006\u0006\u00031E\t!![8\n\u0005i9\"!C\"m_N,\u0017M\u00197f\u0011!a\u0002A!A!\u0002\u0013q\u0012\u0001\u00029bi\"\u001c\u0001\u0001\u0005\u0002 Q9\u0011\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0003Gu\ta\u0001\u0010:p_Rt$\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"\u0013A\u0002)sK\u0012,g-\u0003\u0002*U\t11\u000b\u001e:j]\u001eT!a\n\u0013\t\u00111\u0002!\u0011!Q\u0001\n5\n!\u0002[1e_>\u00048i\u001c8g!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0003d_:4'B\u0001\u001a\t\u0003\u0019A\u0017\rZ8pa&\u0011Ag\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bY\u0002A\u0011A\u001c\u0002\rqJg.\u001b;?)\rA$h\u000f\t\u0003s\u0001i\u0011A\u0001\u0005\u00069U\u0002\rA\b\u0005\u0006YU\u0002\r!\f\u0005\t{\u0001A)\u0019!C\u0005}\u000511\u000f\u001e:fC6,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005F\n!AZ:\n\u0005\u0011\u000b%A\u0005$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6DqA\u0012\u0001A\u0002\u0013%q)\u0001\u0006oKb$xJ\u001a4tKR,\u0012\u0001\u0013\t\u0003\u0013*k\u0011\u0001J\u0005\u0003\u0017\u0012\u0012A\u0001T8oO\"9Q\n\u0001a\u0001\n\u0013q\u0015A\u00048fqR|eMZ:fi~#S-\u001d\u000b\u0003\u001fJ\u0003\"!\u0013)\n\u0005E##\u0001B+oSRDqa\u0015'\u0002\u0002\u0003\u0007\u0001*A\u0002yIEBa!\u0016\u0001!B\u0013A\u0015a\u00038fqR|eMZ:fi\u0002Bqa\u0016\u0001A\u0002\u0013%\u0001,\u0001\u0004dY>\u001cX\rZ\u000b\u00023B\u0011\u0011JW\u0005\u00037\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0004^\u0001\u0001\u0007I\u0011\u00020\u0002\u0015\rdwn]3e?\u0012*\u0017\u000f\u0006\u0002P?\"91\u000bXA\u0001\u0002\u0004I\u0006BB1\u0001A\u0003&\u0011,A\u0004dY>\u001cX\r\u001a\u0011\t\u000b\r\u0004A\u0011\u00013\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005\u0015D\u0007CA\u001dg\u0013\t9'AA\u000fGS2,')Y:fI^\u0013\u0018\u000e^3BQ\u0016\fG\rT8h'\u0016<W.\u001a8u\u0011\u0015I'\r1\u0001k\u0003\u0011!\u0017\r^1\u0011\u0005-tW\"\u00017\u000b\u00055\f\u0012a\u00018j_&\u0011q\u000e\u001c\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B9\u0001\t\u0003\u0012\u0018!B2m_N,G#A(\t\u000bQ\u0004A\u0011\u0002:\u0002\u000b\u0019dWo\u001d5\t\u000bY\u0004A\u0011\u0002:\u0002\u0015\u0005\u001c8/\u001a:u\u001fB,g\u000e")
public class FileBasedWriteAheadLogWriter
implements Closeable {
    private FSDataOutputStream stream;
    private final String path;
    private final Configuration hadoopConf;
    private long nextOffset;
    private boolean closed;
    private volatile boolean bitmap$0;

    private FSDataOutputStream stream$lzycompute() {
        FileBasedWriteAheadLogWriter fileBasedWriteAheadLogWriter = this;
        synchronized (fileBasedWriteAheadLogWriter) {
            if (!this.bitmap$0) {
                this.stream = HdfsUtils$.MODULE$.getOutputStream(this.path, this.hadoopConf);
                this.bitmap$0 = true;
            }
        }
        this.hadoopConf = null;
        return this.stream;
    }

    private FSDataOutputStream stream() {
        return !this.bitmap$0 ? this.stream$lzycompute() : this.stream;
    }

    private long nextOffset() {
        return this.nextOffset;
    }

    private void nextOffset_$eq(long x$1) {
        this.nextOffset = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized FileBasedWriteAheadLogSegment write(ByteBuffer data) {
        void var3_3;
        this.assertOpen();
        data.rewind();
        int lengthToWrite = data.remaining();
        FileBasedWriteAheadLogSegment segment = new FileBasedWriteAheadLogSegment(this.path, this.nextOffset(), lengthToWrite);
        this.stream().writeInt(lengthToWrite);
        Utils$.MODULE$.writeByteBuffer(data, (OutputStream)this.stream());
        this.flush();
        this.nextOffset_$eq(this.stream().getPos());
        return var3_3;
    }

    @Override
    public synchronized void close() {
        this.closed_$eq(true);
        this.stream().close();
    }

    private void flush() {
        this.stream().hflush();
        this.stream().getWrappedStream().flush();
    }

    private void assertOpen() {
        HdfsUtils$.MODULE$.checkState(!this.closed(), (Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stream is closed. Create a new Writer to write to file.");
    }

    public FileBasedWriteAheadLogWriter(String path, Configuration hadoopConf) {
        this.path = path;
        this.hadoopConf = hadoopConf;
        this.nextOffset = this.stream().getPos();
        this.closed = false;
    }
}

