/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.FileInputDStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.TimeStampedHashMap;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\red!B#G\u0001!\u0003\u0006\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011A\u0004!\u0011!Q\u0001\nED\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003/\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\r\u0001\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006Y!!\f\t\u0015\u0005e\u0002A!A!\u0002\u0017\tY\u0004\u0003\u0006\u0002>\u0001\u0011\t\u0011)A\u0006\u0003\u007fAq!!\u0016\u0001\t\u0003\t9\u0006C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u0010\u0001!\u0002\u0013\t\t\bC\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0003\u0002\u0004\"A\u00111\u0012\u0001!\u0002\u0013\t)\tC\u0004\u0002\u000e\u0002!I!a$\t\u0015\u0005]\u0005A1A\u0005R!\u000bI\n\u0003\u0005\u0002h\u0002\u0001\u000b\u0011BAN\u0011%\tI\u000f\u0001b\u0001\n\u0013\tY\u000f\u0003\u0005\u0002t\u0002\u0001\u000b\u0011BAw\u0011%\t)\u0010\u0001b\u0001\n\u0013\t9\u0010\u0003\u0005\u0002\u0000\u0002\u0001\u000b\u0011BA}\u0011%\u0011\t\u0001\u0001b\u0001\n\u0013\t\u0019\t\u0003\u0005\u0003\u0004\u0001\u0001\u000b\u0011BAC\u0011)\u0011)\u0001\u0001a\u0001\n\u0003A\u0015Q\u0016\u0005\u000b\u0005\u000f\u0001\u0001\u0019!C\u0001\u0011\n%\u0001\u0002\u0003B\b\u0001\u0001\u0006K!a,\t\u0013\te\u0001\u00011A\u0005\n\tm\u0001\"\u0003B\u0012\u0001\u0001\u0007I\u0011\u0002B\u0013\u0011!\u0011I\u0003\u0001Q!\n\tu\u0001\"\u0003B\u0017\u0001\u0001\u0007I\u0011\u0002B\u0018\u0011%\u00119\u0004\u0001a\u0001\n\u0013\u0011I\u0004\u0003\u0005\u0003>\u0001\u0001\u000b\u0015\u0002B\u0019\u0011%\u0011\t\u0005\u0001a\u0001\n\u0013\tY\u000fC\u0005\u0003D\u0001\u0001\r\u0011\"\u0003\u0003F!A!\u0011\n\u0001!B\u0013\ti\u000fC\u0005\u0003N\u0001\u0001\r\u0011\"\u0003\u0003P!I!\u0011\u000b\u0001A\u0002\u0013%!1\u000b\u0005\t\u0005/\u0002\u0001\u0015)\u0003\u0002\u0002!I!1\f\u0001A\u0002\u0013%!Q\f\u0005\n\u0005K\u0002\u0001\u0019!C\u0005\u0005OB\u0001Ba\u001b\u0001A\u0003&!q\f\u0005\b\u0005_\u0002A\u0011IAq\u0011\u001d\u0011\t\b\u0001C!\u0003CDqAa\u001d\u0001\t\u0003\u0012)\b\u0003\u0005\u0003\n\u0002!\t\u0006\u0013BF\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqAa&\u0001\t\u0013\u0011I\nC\u0004\u0003&\u0002!IAa*\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"9!Q\u0019\u0001\u0005\n\t=\u0003bBA\u0004\u0001\u0011%!Q\f\u0005\b\u0005\u000f\u0004A\u0011BAq\u0011\u001d\u0011I\r\u0001C\u0005\u0005\u00174q!a(\u0001\u0001!\u000b\t\u000bC\u0004\u0002VU\"\t!!+\t\u000f\u0005-V\u0007\"\u0003\u0002.\"9\u00111Z\u001b\u0005B\u00055\u0007bBAmk\u0011\u0005\u00131\u001c\u0005\b\u0003?,D\u0011IAq\u0011\u001d\t\u0019/\u000eC!\u0003K<\u0001B!=G\u0011\u0003A%1\u001f\u0004\b\u000b\u001aC\t\u0001\u0013B{\u0011\u001d\t)&\u0010C\u0001\u0007\u0007Aqa!\u0002>\t\u0003\u00199\u0001C\u0004\u0004\fu\"\ta!\u0004\t\u0013\rUQ(%A\u0005\u0002\r]\u0001\"CB\u001f{E\u0005I\u0011AB \u0011%\u0019\u0019&PI\u0001\n\u0003\u0019)\u0006C\u0005\u0004ju\n\t\u0011\"\u0003\u0004l\t\u0001b)\u001b7f\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\u0006\u0003\u000f\"\u000bq\u0001Z:ue\u0016\fWN\u0003\u0002J\u0015\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u00172\u000bQa\u001d9be.T!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sOV)\u0011KX5\u0002DM\u0011\u0001A\u0015\t\u0004'R3V\"\u0001$\n\u0005U3%\u0001D%oaV$Hi\u0015;sK\u0006l\u0007\u0003B,[9\"l\u0011\u0001\u0017\u0006\u00023\u0006)1oY1mC&\u00111\f\u0017\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005usF\u0002\u0001\u0003\u0006?\u0002\u0011\r!\u0019\u0002\u0002\u0017\u000e\u0001\u0011C\u00012f!\t96-\u0003\u0002e1\n9aj\u001c;iS:<\u0007CA,g\u0013\t9\u0007LA\u0002B]f\u0004\"!X5\u0005\u000b)\u0004!\u0019A1\u0003\u0003Y\u000bAaX:tGB\u0011QN\\\u0007\u0002\u0011&\u0011q\u000e\u0013\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\f\u0011\u0002Z5sK\u000e$xN]=\u0011\u0005ILhBA:x!\t!\b,D\u0001v\u0015\t1\b-\u0001\u0004=e>|GOP\u0005\u0003qb\u000ba\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u0001\u0010W\u0001\u0007M&dG/\u001a:\u0011\r]s\u0018\u0011AA\t\u0013\ty\bLA\u0005Gk:\u001cG/[8ocA!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011A\u00014t\u0015\r\tY\u0001T\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005=\u0011Q\u0001\u0002\u0005!\u0006$\b\u000eE\u0002X\u0003'I1!!\u0006Y\u0005\u001d\u0011un\u001c7fC:\fAB\\3x\r&dWm](oYf\fAaY8oMB)q+!\b\u0002\"%\u0019\u0011q\u0004-\u0003\r=\u0003H/[8o!\u0011\t\u0019#a\n\u000e\u0005\u0005\u0015\"\u0002BA\r\u0003\u0013IA!!\u000b\u0002&\ti1i\u001c8gS\u001e,(/\u0019;j_:\f!a[7\u0011\u000b\u0005=\u0012Q\u0007/\u000e\u0005\u0005E\"bAA\u001a1\u00069!/\u001a4mK\u000e$\u0018\u0002BA\u001c\u0003c\u0011\u0001b\u00117bgN$\u0016mZ\u0001\u0003m6\u0004R!a\f\u00026!\f!AZ7\u0011\r\u0005=\u0012QGA!!\ri\u00161\t\u0003\b\u0003\u000b\u0002!\u0019AA$\u0005\u00051\u0015c\u00012\u0002JA1\u00111JA)9\"l!!!\u0014\u000b\t\u0005=\u0013\u0011B\u0001\n[\u0006\u0004(/\u001a3vG\u0016LA!a\u0015\u0002N\tY\u0011J\u001c9vi\u001a{'/\\1u\u0003\u0019a\u0014N\\5u}Qa\u0011\u0011LA2\u0003K\n9'!\u001b\u0002lQA\u00111LA/\u0003?\n\t\u0007\u0005\u0004T\u0001qC\u0017\u0011\t\u0005\b\u0003WI\u00019AA\u0017\u0011\u001d\tI$\u0003a\u0002\u0003wAq!!\u0010\n\u0001\b\ty\u0004C\u0003l\u0013\u0001\u0007A\u000eC\u0003q\u0013\u0001\u0007\u0011\u000fC\u0004}\u0013A\u0005\t\u0019A?\t\u0013\u0005]\u0011\u0002%AA\u0002\u0005E\u0001\"CA\r\u0013A\u0005\t\u0019AA\u000e\u0003M\u0019XM]5bY&T\u0018M\u00197f\u0007>tgm\u00149u+\t\t\t\bE\u0003X\u0003;\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tIHS\u0001\u0005kRLG.\u0003\u0003\u0002~\u0005]$!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\fAc]3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4PaR\u0004\u0013\u0001F7j]J+W.Z7cKJ$UO]1uS>t7+\u0006\u0002\u0002\u0006B\u0019Q.a\"\n\u0007\u0005%\u0005J\u0001\u0005EkJ\fG/[8o\u0003Ui\u0017N\u001c*f[\u0016l'-\u001a:EkJ\fG/[8o'\u0002\nQa\u00197pG.,\"!!%\u0011\t\u0005U\u00141S\u0005\u0005\u0003+\u000b9HA\u0003DY>\u001c7.\u0001\bdQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0016\u0005\u0005m\u0005cAAOk5\t\u0001A\u0001\u0010GS2,\u0017J\u001c9vi\u0012\u001bFO]3b[\u000eCWmY6q_&tG\u000fR1uCN\u0019Q'a)\u0011\tM\u000b)KV\u0005\u0004\u0003O3%!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u000b\u0003\u00037\u000b1\u0002[1e_>\u0004h)\u001b7fgV\u0011\u0011q\u0016\t\t\u0003c\u000bY,a0\u0002F6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,A\u0004nkR\f'\r\\3\u000b\u0007\u0005e\u0006,\u0001\u0006d_2dWm\u0019;j_:LA!!0\u00024\n9\u0001*Y:i\u001b\u0006\u0004\bcA7\u0002B&\u0019\u00111\u0019%\u0003\tQKW.\u001a\t\u0005/\u0006\u001d\u0017/C\u0002\u0002Jb\u0013Q!\u0011:sCf\fa!\u001e9eCR,G\u0003BAh\u0003+\u00042aVAi\u0013\r\t\u0019\u000e\u0017\u0002\u0005+:LG\u000fC\u0004\u0002Xb\u0002\r!a0\u0002\tQLW.Z\u0001\bG2,\u0017M\\;q)\u0011\ty-!8\t\u000f\u0005]\u0017\b1\u0001\u0002@\u00069!/Z:u_J,GCAAh\u0003!!xn\u0015;sS:<G#A9\u0002\u001f\rDWmY6q_&tG\u000fR1uC\u0002\nQ$\u001b8ji&\fG.T8e)&lW-S4o_J,G\u000b\u001b:fg\"|G\u000eZ\u000b\u0003\u0003[\u00042aVAx\u0013\r\t\t\u0010\u0017\u0002\u0005\u0019>tw-\u0001\u0010j]&$\u0018.\u00197N_\u0012$\u0016.\\3JO:|'/\u001a+ie\u0016\u001c\bn\u001c7eA\u0005!b.^7CCR\u001c\u0007.Z:U_J+W.Z7cKJ,\"!!?\u0011\u0007]\u000bY0C\u0002\u0002~b\u00131!\u00138u\u0003UqW/\u001c\"bi\u000eDWm\u001d+p%\u0016lW-\u001c2fe\u0002\n!\u0003Z;sCRLwN\u001c+p%\u0016lW-\u001c2fe\u0006\u0019B-\u001e:bi&|g\u000eV8SK6,WNY3sA\u0005A\"-\u0019;dQRKW.\u001a+p'\u0016dWm\u0019;fI\u001aKG.Z:\u00029\t\fGo\u00195US6,Gk\\*fY\u0016\u001cG/\u001a3GS2,7o\u0018\u0013fcR!\u0011q\u001aB\u0006\u0011%\u0011i\u0001GA\u0001\u0002\u0004\ty+A\u0002yIE\n\u0011DY1uG\"$\u0016.\\3U_N+G.Z2uK\u00124\u0015\u000e\\3tA!\u001a\u0011Da\u0005\u0011\u0007]\u0013)\"C\u0002\u0003\u0018a\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002+I,7-\u001a8uYf\u001cV\r\\3di\u0016$g)\u001b7fgV\u0011!Q\u0004\t\u0006\u0003c\u0013y\"]\u0005\u0005\u0005C\t\u0019LA\u0004ICND7+\u001a;\u00023I,7-\u001a8uYf\u001cV\r\\3di\u0016$g)\u001b7fg~#S-\u001d\u000b\u0005\u0003\u001f\u00149\u0003C\u0005\u0003\u000em\t\t\u00111\u0001\u0003\u001e\u00051\"/Z2f]Rd\u0017pU3mK\u000e$X\r\u001a$jY\u0016\u001c\b\u0005K\u0002\u001d\u0005'\tQBZ5mKR{Wj\u001c3US6,WC\u0001B\u0019!\u001d\t)Ha\rr\u0003[LAA!\u000e\u0002x\t\u0011B+[7f'R\fW\u000e]3e\u0011\u0006\u001c\b.T1q\u0003E1\u0017\u000e\\3U_6{G\rV5nK~#S-\u001d\u000b\u0005\u0003\u001f\u0014Y\u0004C\u0005\u0003\u000ey\t\t\u00111\u0001\u00032\u0005qa-\u001b7f)>lu\u000e\u001a+j[\u0016\u0004\u0003fA\u0010\u0003\u0014\u00051B.Y:u\u001d\u0016<h)\u001b7f\r&tG-\u001b8h)&lW-\u0001\u000emCN$h*Z<GS2,g)\u001b8eS:<G+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002P\n\u001d\u0003\"\u0003B\u0007C\u0005\u0005\t\u0019AAw\u0003]a\u0017m\u001d;OK^4\u0015\u000e\\3GS:$\u0017N\\4US6,\u0007\u0005K\u0002#\u0005'\tQa\u00189bi\",\"!!\u0001\u0002\u0013}\u0003\u0018\r\u001e5`I\u0015\fH\u0003BAh\u0005+B\u0011B!\u0004%\u0003\u0003\u0005\r!!\u0001\u0002\r}\u0003\u0018\r\u001e5!Q\r)#1C\u0001\u0004?\u001a\u001cXC\u0001B0!\u0011\t\u0019A!\u0019\n\t\t\r\u0014Q\u0001\u0002\u000b\r&dWmU=ti\u0016l\u0017aB0gg~#S-\u001d\u000b\u0005\u0003\u001f\u0014I\u0007C\u0005\u0003\u000e\u001d\n\t\u00111\u0001\u0003`\u0005!qLZ:!Q\rA#1C\u0001\u0006gR\f'\u000f^\u0001\u0005gR|\u0007/A\u0004d_6\u0004X\u000f^3\u0015\t\t]$Q\u0011\t\u0006/\u0006u!\u0011\u0010\t\u0006\u0005w\u0012\tIV\u0007\u0003\u0005{R1Aa K\u0003\r\u0011H\rZ\u0005\u0005\u0005\u0007\u0013iHA\u0002S\t\u0012CqAa\",\u0001\u0004\ty,A\u0005wC2LG\rV5nK\u0006i1\r\\3be6+G/\u00193bi\u0006$B!a4\u0003\u000e\"9\u0011q\u001b\u0017A\u0002\u0005}\u0016\u0001\u00044j]\u0012tUm\u001e$jY\u0016\u001cH\u0003BAc\u0005'CqA!&.\u0001\u0004\ti/A\u0006dkJ\u0014XM\u001c;US6,\u0017!C5t\u001d\u0016<h)\u001b7f)!\t\tBa'\u0003 \n\u0005\u0006b\u0002BO]\u0001\u0007\u0011\u0011A\u0001\u0005a\u0006$\b\u000eC\u0004\u0003\u0016:\u0002\r!!<\t\u000f\t\rf\u00061\u0001\u0002n\u00061Rn\u001c3US6,\u0017j\u001a8pe\u0016$\u0006N]3tQ>dG-\u0001\u0006gS2,7\u000fV8S\t\u0012#BA!\u001f\u0003*\"9!1V\u0018A\u0002\t5\u0016!\u00024jY\u0016\u001c\b#\u0002BX\u0005s\u000bh\u0002\u0002BY\u0005ks1\u0001\u001eBZ\u0013\u0005I\u0016b\u0001B\\1\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B^\u0005{\u00131aU3r\u0015\r\u00119\fW\u0001\u000fO\u0016$h)\u001b7f\u001b>$G+[7f)\u0011\tiOa1\t\u000f\tu\u0005\u00071\u0001\u0002\u0002\u0005iA-\u001b:fGR|'/\u001f)bi\"\fQA]3tKR\f!B]3bI>\u0013'.Z2u)\u0011\tyM!4\t\u000f\t=G\u00071\u0001\u0003R\u0006\u0019q.[:\u0011\t\tM'Q\\\u0007\u0003\u0005+TAAa6\u0003Z\u0006\u0011\u0011n\u001c\u0006\u0003\u00057\fAA[1wC&!!q\u001cBk\u0005Ey%M[3di&s\u0007/\u001e;TiJ,\u0017-\u001c\u0015\u0006i\t\r(q\u001e\t\u0006/\n\u0015(\u0011^\u0005\u0004\u0005OD&A\u0002;ie><8\u000f\u0005\u0003\u0003T\n-\u0018\u0002\u0002Bw\u0005+\u00141\"S(Fq\u000e,\u0007\u000f^5p]\u000e\u0012!\u0011^\u0001\u0011\r&dW-\u00138qkR$5\u000b\u001e:fC6\u0004\"aU\u001f\u0014\u000bu\u00129P!@\u0011\u0007]\u0013I0C\u0002\u0003|b\u0013a!\u00118z%\u00164\u0007cA,\u0003\u0000&\u00191\u0011\u0001-\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\tM\u0018!\u00043fM\u0006,H\u000e\u001e$jYR,'\u000f\u0006\u0003\u0002\u0012\r%\u0001b\u0002BO\u007f\u0001\u0007\u0011\u0011A\u0001\u001eG\u0006d7-\u001e7bi\u0016tU/\u001c\"bi\u000eDWm\u001d+p%\u0016lW-\u001c2feR1\u0011\u0011`B\b\u0007'Aqa!\u0005A\u0001\u0004\t))A\u0007cCR\u001c\u0007\u000eR;sCRLwN\u001c\u0005\b\u0003\u0003\u0003\u0005\u0019AAC\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gUA1\u0011DB\u0018\u0007c\u0019\u0019$\u0006\u0002\u0004\u001c)\u001aQp!\b,\u0005\r}\u0001\u0003BB\u0011\u0007Wi!aa\t\u000b\t\r\u00152qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u000bY\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007[\u0019\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$QaX!C\u0002\u0005$QA[!C\u0002\u0005$q!!\u0012B\u0005\u0004\u0019)$E\u0002c\u0007o\u0001\u0002\"a\u0013\u0002R\re21\b\t\u0004;\u000e=\u0002cA/\u00042\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\u0002b!\u0011\u0004F\r\u001d3\u0011J\u000b\u0003\u0007\u0007RC!!\u0005\u0004\u001e\u0011)qL\u0011b\u0001C\u0012)!N\u0011b\u0001C\u00129\u0011Q\t\"C\u0002\r-\u0013c\u00012\u0004NAA\u00111JA)\u0007\u001f\u001a\t\u0006E\u0002^\u0007\u000b\u00022!XB$\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kUA1qKB.\u0007;\u001ay&\u0006\u0002\u0004Z)\"\u00111DB\u000f\t\u0015y6I1\u0001b\t\u0015Q7I1\u0001b\t\u001d\t)e\u0011b\u0001\u0007C\n2AYB2!!\tY%!\u0015\u0004f\r\u001d\u0004cA/\u0004\\A\u0019Ql!\u0018\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007[\u0002Baa\u001c\u0004v5\u00111\u0011\u000f\u0006\u0005\u0007g\u0012I.\u0001\u0003mC:<\u0017\u0002BB<\u0007c\u0012aa\u00142kK\u000e$\b")
public class FileInputDStream<K, V, F extends InputFormat<K, V>>
extends InputDStream<Tuple2<K, V>> {
    private final String directory;
    private final Function1<Path, Object> filter;
    private final ClassTag<K> km;
    private final ClassTag<V> vm;
    private final ClassTag<F> fm;
    private final Option<SerializableConfiguration> serializableConfOpt;
    private final Duration minRememberDurationS;
    private final FileInputDStreamCheckpointData checkpointData;
    private final long initialModTimeIgnoreThreshold;
    private final int numBatchesToRemember;
    private final Duration durationToRemember;
    private transient HashMap<Time, String[]> batchTimeToSelectedFiles;
    private transient HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    private transient TimeStampedHashMap<String, Object> fileToModTime;
    private transient long lastNewFileFindingTime;
    private transient Path _path;
    private transient FileSystem _fs;

    public static <K, V, F extends InputFormat<K, V>> Option<Configuration> $lessinit$greater$default$5() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, V, F extends InputFormat<K, V>> boolean $lessinit$greater$default$4() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V, F extends InputFormat<K, V>> Function1<Path, Object> $lessinit$greater$default$3() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static int calculateNumBatchesToRemember(Duration duration, Duration duration2) {
        return FileInputDStream$.MODULE$.calculateNumBatchesToRemember(duration, duration2);
    }

    public static boolean defaultFilter(Path path) {
        return FileInputDStream$.MODULE$.defaultFilter(path);
    }

    private Option<SerializableConfiguration> serializableConfOpt() {
        return this.serializableConfOpt;
    }

    private Duration minRememberDurationS() {
        return this.minRememberDurationS;
    }

    private Clock clock() {
        return this.ssc().scheduler().clock();
    }

    public FileInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    private long initialModTimeIgnoreThreshold() {
        return this.initialModTimeIgnoreThreshold;
    }

    private int numBatchesToRemember() {
        return this.numBatchesToRemember;
    }

    private Duration durationToRemember() {
        return this.durationToRemember;
    }

    public HashMap<Time, String[]> batchTimeToSelectedFiles() {
        return this.batchTimeToSelectedFiles;
    }

    public void batchTimeToSelectedFiles_$eq(HashMap<Time, String[]> x$1) {
        this.batchTimeToSelectedFiles = x$1;
    }

    public HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    }

    private void org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq(HashSet<String> x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = x$1;
    }

    private TimeStampedHashMap<String, Object> fileToModTime() {
        return this.fileToModTime;
    }

    private void fileToModTime_$eq(TimeStampedHashMap<String, Object> x$1) {
        this.fileToModTime = x$1;
    }

    private long lastNewFileFindingTime() {
        return this.lastNewFileFindingTime;
    }

    private void lastNewFileFindingTime_$eq(long x$1) {
        this.lastNewFileFindingTime = x$1;
    }

    private Path _path() {
        return this._path;
    }

    private void _path_$eq(Path x$1) {
        this._path = x$1;
    }

    private FileSystem _fs() {
        return this._fs;
    }

    private void _fs_$eq(FileSystem x$1) {
        this._fs = x$1;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<Tuple2<K, V>>> compute(Time validTime) {
        String[] newFiles = this.findNewFiles(validTime.milliseconds());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("New files at time ").append(validTime).append(":\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).mkString("\n")).toString());
        HashMap<Time, String[]> hashMap = this.batchTimeToSelectedFiles();
        synchronized (hashMap) {
            this.batchTimeToSelectedFiles().$plus$eq(new Tuple2((Object)validTime, (Object)newFiles));
        }
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)));
        Some rdds = new Some(this.org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])newFiles)));
        Map metadata = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"files"), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).mkString("\n"))}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), 0L, (Map<String, Object>)metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        return rdds;
    }

    @Override
    public void clearMetadata(Time time) {
        super.clearMetadata(time);
        HashMap<Time, String[]> hashMap = this.batchTimeToSelectedFiles();
        synchronized (hashMap) {
            HashMap oldFiles = (HashMap)this.batchTimeToSelectedFiles().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileInputDStream.$anonfun$clearMetadata$1(this, time, x$2)));
            this.batchTimeToSelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.keys());
            this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.values().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Cleared ").append(oldFiles.size()).append(" old files that were older than ").append(time.$minus(this.rememberDuration())).append(": ").append(oldFiles.keys().mkString(", ")).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Cleared files are:\n").append(((TraversableOnce)oldFiles.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(p._1(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p._2())).mkString(", ")), HashMap$.MODULE$.canBuildFrom())).mkString("\n")).toString());
        }
        this.fileToModTime().clearOldValues(this.lastNewFileFindingTime() - 1L);
    }

    private String[] findNewFiles(long currentTime) {
        String[] stringArray;
        try {
            this.lastNewFileFindingTime_$eq(this.clock().getTimeMillis());
            long modTimeIgnoreThreshold = package$.MODULE$.max(this.initialModTimeIgnoreThreshold(), currentTime - this.durationToRemember().milliseconds());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Getting new files for time ").append(currentTime).append(", ").append(new StringBuilder(26).append("ignoring files older than ").append(modTimeIgnoreThreshold).toString()).toString());
            PathFilter newFileFilter = new PathFilter(this, currentTime, modTimeIgnoreThreshold){
                private final /* synthetic */ FileInputDStream $outer;
                private final long currentTime$1;
                private final long modTimeIgnoreThreshold$1;

                public boolean accept(Path path) {
                    return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(path, this.currentTime$1, this.modTimeIgnoreThreshold$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.currentTime$1 = currentTime$1;
                    this.modTimeIgnoreThreshold$1 = modTimeIgnoreThreshold$1;
                }
            };
            PathFilter directoryFilter = new PathFilter(this){
                private final /* synthetic */ FileInputDStream $outer;

                public boolean accept(Path path) {
                    return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fs().getFileStatus(path).isDirectory();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Path[] directories = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().globStatus(this.directoryPath(), directoryFilter))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
            String[] newFiles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directories)).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().listStatus(dir, newFileFilter))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            long timeTaken = this.clock().getTimeMillis() - this.lastNewFileFindingTime();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Finding new files took ").append(timeTaken).append(" ms").toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("# cached file times = ").append(this.fileToModTime().size()).toString());
            if (timeTaken > this.slideDuration().milliseconds()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Time taken to find new files exceeds the batch size. Consider increasing the batch size or reducing the number of files in the monitored directory.");
            }
            stringArray = newFiles;
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error finding new files", e);
            this.reset();
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public boolean org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(Path path, long currentTime, long modTimeIgnoreThreshold) {
        String pathStr = path.toString();
        if (!BoxesRunTime.unboxToBoolean((Object)this.filter.apply((Object)path))) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(pathStr).append(" rejected by filter").toString());
            return false;
        }
        long modTime = this.getFileModTime(path);
        if (modTime <= modTimeIgnoreThreshold) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append(pathStr).append(" ignored as mod time ").append(modTime).append(" <= ignore time ").append(modTimeIgnoreThreshold).toString());
            return false;
        }
        if (modTime > currentTime) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append(pathStr).append(" not selected as mod time ").append(modTime).append(" > current time ").append(currentTime).toString());
            return false;
        }
        if (this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().contains((Object)pathStr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(pathStr).append(" already considered").toString());
            return false;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(pathStr).append(" accepted with mod time ").append(modTime).toString());
        return true;
    }

    public RDD<Tuple2<K, V>> org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD(Seq<String> files) {
        Seq fileRDDs = (Seq)files.map((Function1 & Serializable & scala.Serializable)file -> {
            void var3_6;
            block4: {
                RDD rDD;
                Option option = this.serializableConfOpt().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.value());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Configuration config = (Configuration)some.value();
                    rDD = this.context().sparkContext().newAPIHadoopFile(file, $this.fm.runtimeClass(), $this.km.runtimeClass(), $this.vm.runtimeClass(), config);
                } else if (None$.MODULE$.equals(option)) {
                    rDD = this.context().sparkContext().newAPIHadoopFile(file, $this.km, $this.vm, $this.fm);
                } else {
                    throw new MatchError((Object)option);
                }
                RDD rdd = rDD;
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).isEmpty()) break block4;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(190).append("File ").append((String)file).append(" has no data in it. Spark Streaming can only ingest ").append("files that have been \"moved\" to the directory assigned to the file stream. ").append("Refer to the streaming programming guide for more details.").toString());
            }
            return var3_6;
        }, Seq$.MODULE$.canBuildFrom());
        return new UnionRDD(this.context().sparkContext(), fileRDDs, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private long getFileModTime(Path path) {
        return BoxesRunTime.unboxToLong((Object)this.fileToModTime().getOrElseUpdate((Object)path.toString(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().getFileStatus(path).getModificationTime()));
    }

    private Path directoryPath() {
        block0: {
            if (this._path() != null) break block0;
            this._path_$eq(new Path(this.directory));
        }
        return this._path();
    }

    public FileSystem org$apache$spark$streaming$dstream$FileInputDStream$$fs() {
        block0: {
            if (this._fs() != null) break block0;
            this._fs_$eq(this.directoryPath().getFileSystem(this.ssc().sparkContext().hadoopConfiguration()));
        }
        return this._fs();
    }

    private void reset() {
        this._fs_$eq(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(this.getClass().getSimpleName()).append(".readObject used").toString());
            ois.defaultReadObject();
            this.generatedRDDs_$eq(new HashMap());
            this.batchTimeToSelectedFiles_$eq((HashMap<Time, String[]>)new HashMap());
            this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq((HashSet<String>)new HashSet());
            this.fileToModTime_$eq((TimeStampedHashMap<String, Object>)new TimeStampedHashMap(true));
        });
    }

    public static final /* synthetic */ boolean $anonfun$clearMetadata$1(FileInputDStream $this, Time time$1, Tuple2 x$2) {
        return ((Time)x$2._1()).$less(time$1.$minus($this.rememberDuration()));
    }

    public FileInputDStream(StreamingContext _ssc, String directory, Function1<Path, Object> filter, boolean newFilesOnly, Option<Configuration> conf, ClassTag<K> km, ClassTag<V> vm, ClassTag<F> fm) {
        this.directory = directory;
        this.filter = filter;
        this.km = km;
        this.vm = vm;
        this.fm = fm;
        super(_ssc, ClassTag$.MODULE$.apply(Tuple2.class));
        this.serializableConfOpt = conf.map((Function1 & Serializable & scala.Serializable)x$1 -> new SerializableConfiguration(x$1));
        this.minRememberDurationS = Seconds$.MODULE$.apply(this.ssc().conf().getTimeAsSeconds("spark.streaming.fileStream.minRememberDuration", this.ssc().conf().get("spark.streaming.minRememberDuration", "60s")));
        this.checkpointData = new FileInputDStreamCheckpointData();
        this.initialModTimeIgnoreThreshold = newFilesOnly ? this.clock().getTimeMillis() : 0L;
        this.numBatchesToRemember = FileInputDStream$.MODULE$.calculateNumBatchesToRemember(this.slideDuration(), this.minRememberDurationS());
        this.durationToRemember = this.slideDuration().$times(this.numBatchesToRemember());
        this.remember(this.durationToRemember());
        this.batchTimeToSelectedFiles = new HashMap();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = new HashSet();
        this.fileToModTime = new TimeStampedHashMap(true);
        this.lastNewFileFindingTime = 0L;
        this._path = null;
        this._fs = null;
    }

    public class FileInputDStreamCheckpointData
    extends DStreamCheckpointData<Tuple2<K, V>> {
        private HashMap<Time, String[]> hadoopFiles() {
            return this.data();
        }

        @Override
        public void update(Time time) {
            this.hadoopFiles().clear();
            HashMap<Time, String[]> hashMap = this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles();
            synchronized (hashMap) {
                HashMap cfr_ignored_0 = (HashMap)this.hadoopFiles().$plus$plus$eq(this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles());
            }
        }

        @Override
        public void cleanup(Time time) {
        }

        @Override
        public void restore() {
            ((IterableLike)this.hadoopFiles().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (Time)x$6._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String[] f;
                Time t;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    t = (Time)tuple2._1();
                    f = (String[])tuple2._2();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Restoring files for time ").append(t).append(" - ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f)).mkString("[", ", ", "]")).toString());
                    HashMap<Time, String[]> hashMap = this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles();
                    synchronized (hashMap) {
                        this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles().$plus$eq(new Tuple2((Object)t, (Object)f));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f)));
                HashMap hashMap = this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(new Tuple2((Object)t, this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])f))));
                return hashMap;
            });
        }

        @Override
        public String toString() {
            return new StringBuilder(15).append("[\n").append(this.hadoopFiles().size()).append(" file sets\n").append(((TraversableOnce)this.hadoopFiles().map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(p._1(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p._2())).mkString(", ")), HashMap$.MODULE$.canBuildFrom())).mkString("\n")).append("\n]").toString();
        }

        public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer() {
            return FileInputDStream.this;
        }

        public FileInputDStreamCheckpointData() {
            if (FileInputDStream.this == null) {
                throw null;
            }
            super(FileInputDStream.this, ClassTag$.MODULE$.apply(Tuple2.class));
        }
    }
}

