/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogRandomReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogWriter;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BufferLike;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r=d!B&M\u000193\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u001d\u0004!\u0011!Q\u0001\n!D\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\t{\u0002\u0011\t\u0011)A\u0005}\"I\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003\u000f\u0001!\u0011!Q\u0001\n\u0005%\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003GA\u0001Ba,\u0001A\u0003%\u0011Q\u0005\u0005\n\u0005c\u0003!\u0019!C\u0005\u0005gC\u0001B!.\u0001A\u0003%!Q\t\u0005\n\u0005o\u0003!\u0019!C\u0005\u0003KC\u0001B!/\u0001A\u0003%\u0011q\u0015\u0005\n\u0005w\u0003!\u0019!C\u0005\u0005{C\u0001Ba6\u0001A\u0003%!q\u0018\u0005\n\u0005\u0017\u0003!\u0019!C\u0005\u00053D\u0001B!9\u0001A\u0003%!1\u001c\u0005\b\u0005G\u0004A\u0011KAS\u0011%\u0011)\u000f\u0001a\u0001\n\u0013\u0011\u0019\fC\u0005\u0003h\u0002\u0001\r\u0011\"\u0003\u0003j\"A!1\u001f\u0001!B\u0013\u0011)\u0005C\u0005\u0003v\u0002\u0001\r\u0011\"\u0003\u0003x\"I!q \u0001A\u0002\u0013%1\u0011\u0001\u0005\t\u0007\u000b\u0001\u0001\u0015)\u0003\u0003z\"I1q\u0001\u0001A\u0002\u0013%\u0011\u0011\f\u0005\n\u0007\u0013\u0001\u0001\u0019!C\u0005\u0007\u0017A\u0001ba\u0004\u0001A\u0003&\u00111\f\u0005\n\u0007#\u0001\u0001\u0019!C\u0005\u00033B\u0011ba\u0005\u0001\u0001\u0004%Ia!\u0006\t\u0011\re\u0001\u0001)Q\u0005\u00037Bqaa\u0007\u0001\t\u0003\u0019i\u0002C\u0004\u0004:\u0001!\taa\u000f\t\u000f\r\u001d\u0003\u0001\"\u0001\u0004J!911\u000b\u0001\u0005\u0002\rU\u0003bBB0\u0001\u0011\u00051\u0011\r\u0005\b\u0007G\u0002A\u0011BB3\u0011\u001d\u0019Y\u0007\u0001C\u0005\u0007CBqa!\u001c\u0001\t\u0013\u0019\tg\u0002\u0005\u0002:1C\tATA\u001e\r\u001dYE\n#\u0001O\u0003{Aq!a\u0004)\t\u0003\t)E\u0002\u0004\u0002H!\u0002\u0015\u0011\n\u0005\u000b\u0003/R#Q3A\u0005\u0002\u0005e\u0003BCA1U\tE\t\u0015!\u0003\u0002\\!Q\u00111\r\u0016\u0003\u0016\u0004%\t!!\u0017\t\u0015\u0005\u0015$F!E!\u0002\u0013\tY\u0006\u0003\u0006\u0002h)\u0012)\u001a!C\u0001\u0003SB\u0011\"a\u001b+\u0005#\u0005\u000b\u0011\u00025\t\u000f\u0005=!\u0006\"\u0001\u0002n!I\u0011\u0011\u0010\u0016\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u0007S\u0013\u0013!C\u0001\u0003\u000bC\u0011\"a'+#\u0003%\t!!\"\t\u0013\u0005u%&%A\u0005\u0002\u0005}\u0005\"CARU\u0005\u0005I\u0011IAS\u0011%\t)LKA\u0001\n\u0003\t9\fC\u0005\u0002:*\n\t\u0011\"\u0001\u0002<\"I\u0011q\u0019\u0016\u0002\u0002\u0013\u0005\u0013\u0011\u001a\u0005\n\u0003'T\u0013\u0011!C\u0001\u0003+D\u0011\"!7+\u0003\u0003%\t%a7\t\u0013\u0005u'&!A\u0005B\u0005}\u0007\"CAqU\u0005\u0005I\u0011IAr\u000f%\t9\u000fKA\u0001\u0012\u0003\tIOB\u0005\u0002H!\n\t\u0011#\u0001\u0002l\"9\u0011qB \u0005\u0002\u0005e\b\"CAo\u007f\u0005\u0005IQIAp\u0011%\tYpPA\u0001\n\u0003\u000bi\u0010C\u0005\u0003\u0006}\n\t\u0011\"!\u0003\b!I!\u0011D \u0002\u0002\u0013%!1\u0004\u0005\n\u0005GA#\u0019!C\u0001\u0005KA\u0001B!\u000e)A\u0003%!q\u0005\u0005\b\u0005oAC\u0011\u0001B\u001d\u0011\u001d\u0011\t\u0005\u000bC\u0001\u0005\u0007BqAa\u0012)\t\u0003\u0011I\u0005C\u0004\u0003p!\"\tA!\u001d\u0003-\u0019KG.\u001a\"bg\u0016$wK]5uK\u0006CW-\u00193M_\u001eT!!\u0014(\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u001fB\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005E\u0013\u0016!B:qCJ\\'BA*U\u0003\u0019\t\u0007/Y2iK*\tQ+A\u0002pe\u001e\u001c2\u0001A,\\!\tA\u0016,D\u0001M\u0013\tQFJA\u0007Xe&$X-\u00115fC\u0012dun\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=B\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Av\u0013q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003I\u0016l\u0011\u0001U\u0005\u0003MB\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\u00191|w\rR5sK\u000e$xN]=\u0011\u0005%\u0014hB\u00016q!\tYg.D\u0001m\u0015\ti'-\u0001\u0004=e>|GO\u0010\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\\\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002r]\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005]\\X\"\u0001=\u000b\u0005\u0005L(B\u0001>S\u0003\u0019A\u0017\rZ8pa&\u0011A\u0010\u001f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002'I|G\u000e\\5oO&sG/\u001a:wC2\u001cVmY:\u0011\u0007}\f\t!D\u0001o\u0013\r\t\u0019A\u001c\u0002\u0004\u0013:$\u0018aC7bq\u001a\u000b\u0017\u000e\\;sKN\f1c\u00197pg\u00164\u0015\u000e\\3BMR,'o\u0016:ji\u0016\u00042a`A\u0006\u0013\r\tiA\u001c\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Qq\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001C\u0001-\u0001\u0011\u0015\tw\u00011\u0001d\u0011\u00159w\u00011\u0001i\u0011\u0015)x\u00011\u0001w\u0011\u0015ix\u00011\u0001\u007f\u0011\u0019\t)a\u0002a\u0001}\"9\u0011qA\u0004A\u0002\u0005%\u0011\u0001\u00039bgRdunZ:\u0016\u0005\u0005\u0015\u0002CBA\u0014\u0003c\t)$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u001diW\u000f^1cY\u0016T1!a\fo\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\tICA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcAA\u001cU9\u0011\u0001lJ\u0001\u0017\r&dWMQ1tK\u0012<&/\u001b;f\u0003\",\u0017\r\u001a'pOB\u0011\u0001\fK\n\u0004Q\u0005}\u0002cA@\u0002B%\u0019\u00111\t8\u0003\r\u0005s\u0017PU3g)\t\tYDA\u0004M_\u001eLeNZ8\u0014\u000f)\ny$a\u0013\u0002RA\u0019q0!\u0014\n\u0007\u0005=cNA\u0004Qe>$Wo\u0019;\u0011\u0007}\f\u0019&C\u0002\u0002V9\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011b\u001d;beR$\u0016.\\3\u0016\u0005\u0005m\u0003cA@\u0002^%\u0019\u0011q\f8\u0003\t1{gnZ\u0001\u000bgR\f'\u000f\u001e+j[\u0016\u0004\u0013aB3oIRKW.Z\u0001\tK:$G+[7fA\u0005!\u0001/\u0019;i+\u0005A\u0017!\u00029bi\"\u0004C\u0003CA8\u0003g\n)(a\u001e\u0011\u0007\u0005E$&D\u0001)\u0011\u001d\t9&\ra\u0001\u00037Bq!a\u00192\u0001\u0004\tY\u0006\u0003\u0004\u0002hE\u0002\r\u0001[\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002p\u0005u\u0014qPAA\u0011%\t9F\rI\u0001\u0002\u0004\tY\u0006C\u0005\u0002dI\u0002\n\u00111\u0001\u0002\\!A\u0011q\r\u001a\u0011\u0002\u0003\u0007\u0001.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d%\u0006BA.\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+s\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!)+\u0007!\fI)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003O\u0003B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0003mC:<'BAAY\u0003\u0011Q\u0017M^1\n\u0007M\fY+\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001\u007f\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!0\u0002DB\u0019q0a0\n\u0007\u0005\u0005gNA\u0002B]fD\u0001\"!29\u0003\u0003\u0005\rA`\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0007CBAg\u0003\u001f\fi,\u0004\u0002\u0002.%!\u0011\u0011[A\u0017\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0011q\u001b\u0005\n\u0003\u000bT\u0014\u0011!a\u0001\u0003{\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002}\u0006AAo\\*ue&tw\r\u0006\u0002\u0002(\u00061Q-];bYN$B!!\u0003\u0002f\"I\u0011QY\u001f\u0002\u0002\u0003\u0007\u0011QX\u0001\b\u0019><\u0017J\u001c4p!\r\t\thP\n\u0006\u007f\u00055\u0018\u0011\u000b\t\f\u0003_\f)0a\u0017\u0002\\!\fy'\u0004\u0002\u0002r*\u0019\u00111\u001f8\u0002\u000fI,h\u000e^5nK&!\u0011q_Ay\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003S\fQ!\u00199qYf$\u0002\"a\u001c\u0002\u0000\n\u0005!1\u0001\u0005\b\u0003/\u0012\u0005\u0019AA.\u0011\u001d\t\u0019G\u0011a\u0001\u00037Ba!a\u001aC\u0001\u0004A\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0013\u0011)\u0002E\u0003\u0000\u0005\u0017\u0011y!C\u0002\u0003\u000e9\u0014aa\u00149uS>t\u0007\u0003C@\u0003\u0012\u0005m\u00131\f5\n\u0007\tMaN\u0001\u0004UkBdWm\r\u0005\n\u0005/\u0019\u0015\u0011!a\u0001\u0003_\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tu\u0001\u0003BAU\u0005?IAA!\t\u0002,\n1qJ\u00196fGR\fA\u0002\\8h\r&dWMU3hKb,\"Aa\n\u0011\t\t%\"\u0011G\u0007\u0003\u0005WQAA!\f\u00030\u0005AQ.\u0019;dQ&twM\u0003\u0002N]&!!1\u0007B\u0016\u0005\u0015\u0011VmZ3y\u00035awn\u001a$jY\u0016\u0014VmZ3yA\u0005iA/[7f)>dun\u001a$jY\u0016$R\u0001\u001bB\u001e\u0005{Aq!a\u0016H\u0001\u0004\tY\u0006C\u0004\u0003@\u001d\u0003\r!a\u0017\u0002\u0011M$x\u000e\u001d+j[\u0016\fQbZ3u\u0007\u0006dG.\u001a:OC6,GC\u0001B#!\u0011y(1\u00025\u0002#1|wMR5mKN$v\u000e\\8h\u0013:4w\u000e\u0006\u0003\u0003L\tu\u0003C\u0002B'\u0005/\nyG\u0004\u0003\u0003P\tMcbA6\u0003R%\tq.C\u0002\u0003V9\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003Z\tm#aA*fc*\u0019!Q\u000b8\t\u000f\t}\u0013\n1\u0001\u0003b\u0005)a-\u001b7fgB1!Q\nB,\u0005G\u0002BA!\u001a\u0003l5\u0011!q\r\u0006\u0004\u0005SJ\u0018A\u00014t\u0013\u0011\u0011iGa\u001a\u0003\tA\u000bG\u000f[\u0001\u0011g\u0016\fHk\u001c)be&#XM]1u_J,bAa\u001d\u0003\"\nuD\u0003\u0003B;\u0005\u0013\u0013IJ!*\u0011\r\t5#q\u000fB=\u0013\u0011\t\tNa\u0017\u0011\t\tm$Q\u0010\u0007\u0001\t\u001d\u0011yH\u0013b\u0001\u0005\u0003\u0013\u0011aT\t\u0005\u0005\u0007\u000bi\fE\u0002\u0000\u0005\u000bK1Aa\"o\u0005\u001dqu\u000e\u001e5j]\u001eDqAa#K\u0001\u0004\u0011i)\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!!q\u0012BK\u001b\t\u0011\tJC\u0002\u0003\u0014:\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\u00119J!%\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bb\u0002BN\u0015\u0002\u0007!QT\u0001\u0007g>,(oY3\u0011\r\t5#q\u000bBP!\u0011\u0011YH!)\u0005\u000f\t\r&J1\u0001\u0003\u0002\n\t\u0011\nC\u0004\u0003(*\u0003\rA!+\u0002\u000f!\fg\u000e\u001a7feB9qPa+\u0003 \nU\u0014b\u0001BW]\nIa)\u001e8di&|g.M\u0001\na\u0006\u001cH\u000fT8hg\u0002\n!bY1mY\u0016\u0014h*Y7f+\t\u0011)%A\u0006dC2dWM\u001d(b[\u0016\u0004\u0013A\u0004;ie\u0016\fG\r]8pY:\u000bW.Z\u0001\u0010i\"\u0014X-\u00193q_>dg*Y7fA\u0005aam\u001c:l\u0015>Lg\u000eU8pYV\u0011!q\u0018\t\u0005\u0005\u0003\u0014\tN\u0004\u0003\u0003D\n5g\u0002\u0002Bc\u0005\u0013tAAa\u0014\u0003H&\u0019!1\u00138\n\t\t-'\u0011S\u0001\tM>\u00148N[8j]&!!Q\u000bBh\u0015\u0011\u0011YM!%\n\t\tM'Q\u001b\u0002\r\r>\u00148NS8j]B{w\u000e\u001c\u0006\u0005\u0005+\u0012y-A\u0007g_J\\'j\\5o!>|G\u000eI\u000b\u0003\u00057\u0004BAa$\u0003^&!!q\u001cBI\u0005})\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]*feZL7-Z\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013a\u00027pO:\u000bW.Z\u0001\u000fGV\u0014(/\u001a8u\u0019><\u0007+\u0019;i\u0003I\u0019WO\u001d:f]Rdun\u001a)bi\"|F%Z9\u0015\t\t-(\u0011\u001f\t\u0004\u007f\n5\u0018b\u0001Bx]\n!QK\\5u\u0011%\t)\rFA\u0001\u0002\u0004\u0011)%A\bdkJ\u0014XM\u001c;M_\u001e\u0004\u0016\r\u001e5!\u0003A\u0019WO\u001d:f]RdunZ,sSR,'/\u0006\u0002\u0003zB\u0019\u0001La?\n\u0007\tuHJ\u0001\u000fGS2,')Y:fI^\u0013\u0018\u000e^3BQ\u0016\fG\rT8h/JLG/\u001a:\u0002)\r,(O]3oi2{wm\u0016:ji\u0016\u0014x\fJ3r)\u0011\u0011Yoa\u0001\t\u0013\u0005\u0015w#!AA\u0002\te\u0018!E2veJ,g\u000e\u001e'pO^\u0013\u0018\u000e^3sA\u0005I2-\u001e:sK:$Hj\\4Xe&$XM]*uCJ$H+[7f\u0003u\u0019WO\u001d:f]RdunZ,sSR,'o\u0015;beR$\u0016.\\3`I\u0015\fH\u0003\u0002Bv\u0007\u001bA\u0011\"!2\u001b\u0003\u0003\u0005\r!a\u0017\u00025\r,(O]3oi2{wm\u0016:ji\u0016\u00148\u000b^1siRKW.\u001a\u0011\u00021\r,(O]3oi2{wm\u0016:ji\u0016\u00148\u000b^8q)&lW-\u0001\u000fdkJ\u0014XM\u001c;M_\u001e<&/\u001b;feN#x\u000e\u001d+j[\u0016|F%Z9\u0015\t\t-8q\u0003\u0005\n\u0003\u000bl\u0012\u0011!a\u0001\u00037\n\u0011dY;se\u0016tG\u000fT8h/JLG/\u001a:Ti>\u0004H+[7fA\u0005)qO]5uKR11qDB\u0013\u0007k\u00012\u0001WB\u0011\u0013\r\u0019\u0019\u0003\u0014\u0002\u001e\r&dWMQ1tK\u0012<&/\u001b;f\u0003\",\u0017\r\u001a'pON+w-\\3oi\"91qE\u0010A\u0002\r%\u0012A\u00032zi\u0016\u0014UO\u001a4feB!11FB\u0019\u001b\t\u0019iC\u0003\u0003\u00040\u0005=\u0016a\u00018j_&!11GB\u0017\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0007oy\u0002\u0019AA.\u0003\u0011!\u0018.\\3\u0002\tI,\u0017\r\u001a\u000b\u0005\u0007S\u0019i\u0004C\u0004\u0004@\u0001\u0002\ra!\u0011\u0002\u000fM,w-\\3oiB\u0019\u0001la\u0011\n\u0007\r\u0015CJA\rXe&$X-\u00115fC\u0012dun\u001a*fG>\u0014H\rS1oI2,\u0017a\u0002:fC\u0012\fE\u000e\u001c\u000b\u0003\u0007\u0017\u0002ba!\u0014\u0004R\r%RBAB(\u0015\ri\u0015qV\u0005\u0005\u0003#\u001cy%A\u0003dY\u0016\fg\u000e\u0006\u0004\u0003l\u000e]31\f\u0005\b\u00073\u0012\u0003\u0019AA.\u0003)!\bN]3tQRKW.\u001a\u0005\b\u0007;\u0012\u0003\u0019AA\u0005\u0003E9\u0018-\u001b;G_J\u001cu.\u001c9mKRLwN\\\u0001\u0006G2|7/\u001a\u000b\u0003\u0005W\fAbZ3u\u0019><wK]5uKJ$BA!?\u0004h!91\u0011\u000e\u0013A\u0002\u0005m\u0013aC2veJ,g\u000e\u001e+j[\u0016\f1#\u001b8ji&\fG.\u001b>f\u001fJ\u0014VmY8wKJ\f1B]3tKR<&/\u001b;fe\u0002")
public class FileBasedWriteAheadLog
extends WriteAheadLog
implements Logging {
    private final String logDirectory;
    private final Configuration hadoopConf;
    private final int rollingIntervalSecs;
    private final int maxFailures;
    private final boolean closeFileAfterWrite;
    private final ArrayBuffer<LogInfo> pastLogs;
    private final Option<String> callerName;
    private final String threadpoolName;
    private final ForkJoinPool forkJoinPool;
    private final ExecutionContextExecutorService executionContext;
    private Option<String> currentLogPath;
    private FileBasedWriteAheadLogWriter currentLogWriter;
    private long currentLogWriterStartTime;
    private long currentLogWriterStopTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <I, O> Iterator<O> seqToParIterator(ExecutionContext executionContext, Seq<I> seq, Function1<I, Iterator<O>> function1) {
        return FileBasedWriteAheadLog$.MODULE$.seqToParIterator(executionContext, seq, function1);
    }

    public static Seq<LogInfo> logFilesTologInfo(Seq<Path> seq) {
        return FileBasedWriteAheadLog$.MODULE$.logFilesTologInfo(seq);
    }

    public static Option<String> getCallerName() {
        return FileBasedWriteAheadLog$.MODULE$.getCallerName();
    }

    public static String timeToLogFile(long l, long l2) {
        return FileBasedWriteAheadLog$.MODULE$.timeToLogFile(l, l2);
    }

    public static Regex logFileRegex() {
        return FileBasedWriteAheadLog$.MODULE$.logFileRegex();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArrayBuffer<LogInfo> pastLogs() {
        return this.pastLogs;
    }

    private Option<String> callerName() {
        return this.callerName;
    }

    private String threadpoolName() {
        return this.threadpoolName;
    }

    private ForkJoinPool forkJoinPool() {
        return this.forkJoinPool;
    }

    private ExecutionContextExecutorService executionContext() {
        return this.executionContext;
    }

    public String logName() {
        return new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).stripSuffix("$")).append(((String)this.callerName().map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("_").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).replaceAll("[ ]", "_")).toString();
    }

    private Option<String> currentLogPath() {
        return this.currentLogPath;
    }

    private void currentLogPath_$eq(Option<String> x$1) {
        this.currentLogPath = x$1;
    }

    private FileBasedWriteAheadLogWriter currentLogWriter() {
        return this.currentLogWriter;
    }

    private void currentLogWriter_$eq(FileBasedWriteAheadLogWriter x$1) {
        this.currentLogWriter = x$1;
    }

    private long currentLogWriterStartTime() {
        return this.currentLogWriterStartTime;
    }

    private void currentLogWriterStartTime_$eq(long x$1) {
        this.currentLogWriterStartTime = x$1;
    }

    private long currentLogWriterStopTime() {
        return this.currentLogWriterStopTime;
    }

    private void currentLogWriterStopTime_$eq(long x$1) {
        this.currentLogWriterStopTime = x$1;
    }

    @Override
    public synchronized FileBasedWriteAheadLogSegment write(ByteBuffer byteBuffer, long time) {
        FileBasedWriteAheadLogSegment fileSegment = null;
        IntRef failures = IntRef.create((int)0);
        Exception lastException = null;
        boolean succeeded = false;
        while (!succeeded && failures.elem < this.maxFailures) {
            try {
                fileSegment = this.getLogWriter(time).write(byteBuffer);
                if (this.closeFileAfterWrite) {
                    this.resetWriter();
                }
                succeeded = true;
            }
            catch (Exception ex) {
                lastException = ex;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to write to write ahead log");
                this.resetWriter();
                ++failures.elem;
            }
        }
        if (fileSegment == null) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Failed to write to write ahead log after ").append(failures$1.elem).append(" failures").toString());
            throw lastException;
        }
        return fileSegment;
    }

    @Override
    public ByteBuffer read(WriteAheadLogRecordHandle segment) {
        FileBasedWriteAheadLogSegment fileSegment = (FileBasedWriteAheadLogSegment)segment;
        ByteBuffer byteBuffer = null;
        try (FileBasedWriteAheadLogRandomReader reader = null;){
            reader = new FileBasedWriteAheadLogRandomReader(fileSegment.path(), this.hadoopConf);
            byteBuffer = reader.read(fileSegment);
        }
        return byteBuffer;
    }

    @Override
    public synchronized java.util.Iterator<ByteBuffer> readAll() {
        ArrayBuffer logFilesToRead = (ArrayBuffer)((BufferLike)this.pastLogs().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.path(), ArrayBuffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.currentLogPath()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Reading from the logs:\n").append(logFilesToRead.mkString("\n")).toString());
        return !this.closeFileAfterWrite ? (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)logFilesToRead.iterator().map((Function1 & Serializable & scala.Serializable)file -> this.readFile$1((String)file)), (Function1)Predef$.MODULE$.$conforms()).flatten()).asJava() : (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(FileBasedWriteAheadLog$.MODULE$.seqToParIterator((ExecutionContext)this.executionContext(), logFilesToRead, (Function1 & Serializable & scala.Serializable)file -> this.readFile$1((String)file))).asJava();
    }

    @Override
    public void clean(long threshTime, boolean waitForCompletion) {
        ArrayBuffer arrayBuffer;
        FileBasedWriteAheadLog fileBasedWriteAheadLog = this;
        synchronized (fileBasedWriteAheadLog) {
            ArrayBuffer expiredLogs = (ArrayBuffer)this.pastLogs().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileBasedWriteAheadLog.$anonfun$clean$1(threshTime, x$3)));
            this.pastLogs().$minus$minus$eq((TraversableOnce)expiredLogs);
            arrayBuffer = expiredLogs;
        }
        ArrayBuffer oldLogFiles = arrayBuffer;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Attempting to clear ").append(oldLogFiles.size()).append(" old log files in ").append($this.logDirectory).append(" ").append(new StringBuilder(13).append("older than ").append(threshTime).append(": ").append(((TraversableOnce)oldLogFiles.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.path(), ArrayBuffer$.MODULE$.canBuildFrom())).mkString("\n")).toString()).toString());
        oldLogFiles.foreach((Function1 & Serializable & scala.Serializable)logInfo -> {
            BoxedUnit boxedUnit;
            block5: {
                if (!this.executionContext().isShutdown()) {
                    try {
                        Future f = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.deleteFile$1((LogInfo)logInfo, threshTime), (ExecutionContext)this.executionContext());
                        if (waitForCompletion) {
                            boxedUnit = Await$.MODULE$.ready((Awaitable)f, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
                            break block5;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (RejectedExecutionException e) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Execution context shutdown before deleting old WriteAheadLogs. This would not affect recovery correctness.", e);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
    }

    @Override
    public synchronized void close() {
        if (!this.executionContext().isShutdown()) {
            if (this.currentLogWriter() != null) {
                this.currentLogWriter().close();
            }
            this.executionContext().shutdown();
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped write ahead log manager");
    }

    private synchronized FileBasedWriteAheadLogWriter getLogWriter(long currentTime) {
        block0: {
            if (this.currentLogWriter() != null && currentTime <= this.currentLogWriterStopTime()) break block0;
            this.resetWriter();
            this.currentLogPath().foreach((Function1 & Serializable & scala.Serializable)x$5 -> this.pastLogs().$plus$eq((Object)new LogInfo(this.currentLogWriterStartTime(), this.currentLogWriterStopTime(), (String)x$5)));
            this.currentLogWriterStartTime_$eq(currentTime);
            this.currentLogWriterStopTime_$eq(currentTime + (long)this.rollingIntervalSecs * 1000L);
            Path newLogPath = new Path(this.logDirectory, FileBasedWriteAheadLog$.MODULE$.timeToLogFile(this.currentLogWriterStartTime(), this.currentLogWriterStopTime()));
            this.currentLogPath_$eq((Option<String>)new Some((Object)newLogPath.toString()));
            this.currentLogWriter_$eq(new FileBasedWriteAheadLogWriter((String)this.currentLogPath().get(), this.hadoopConf));
        }
        return this.currentLogWriter();
    }

    private synchronized void initializeOrRecover() {
        Path logDirectoryPath = new Path(this.logDirectory);
        FileSystem fileSystem = HdfsUtils$.MODULE$.getFileSystemForPath(logDirectoryPath, this.hadoopConf);
        try {
            if (fileSystem.getFileStatus(logDirectoryPath).isDirectory()) {
                Seq<LogInfo> logFileInfo = FileBasedWriteAheadLog$.MODULE$.logFilesTologInfo((Seq<Path>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem.listStatus(logDirectoryPath))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPath(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                this.pastLogs().clear();
                this.pastLogs().$plus$plus$eq(logFileInfo);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Recovered ").append(logFileInfo.size()).append(" write ahead log files from ").append($this.logDirectory).toString());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Recovered files are:\n").append(((TraversableOnce)logFileInfo.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.path(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    private synchronized void resetWriter() {
        block0: {
            if (this.currentLogWriter() == null) break block0;
            this.currentLogWriter().close();
            this.currentLogWriter_$eq(null);
        }
    }

    private final Iterator readFile$1(String file) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Creating log reader with ").append(file).toString());
        FileBasedWriteAheadLogReader reader = new FileBasedWriteAheadLogReader(file, this.hadoopConf);
        return CompletionIterator$.MODULE$.apply((Iterator)reader, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JFunction0.mcV.sp & Serializable & scala.Serializable cfr_ignored_0 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close();
        });
    }

    public static final /* synthetic */ boolean $anonfun$clean$1(long threshTime$1, LogInfo x$3) {
        return x$3.endTime() < threshTime$1;
    }

    private final void deleteFile$1(LogInfo walInfo, long threshTime$1) {
        try {
            Path path = new Path(walInfo.path());
            FileSystem fs = HdfsUtils$.MODULE$.getFileSystemForPath(path, this.hadoopConf);
            fs.delete(path, true);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Cleared log file ").append(walInfo).toString());
        }
        catch (Exception ex) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error clearing write ahead log file ").append(walInfo).toString(), ex);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleared log files in ").append($this.logDirectory).append(" older than ").append(threshTime$1).toString());
    }

    public FileBasedWriteAheadLog(SparkConf conf, String logDirectory, Configuration hadoopConf, int rollingIntervalSecs, int maxFailures, boolean closeFileAfterWrite) {
        this.logDirectory = logDirectory;
        this.hadoopConf = hadoopConf;
        this.rollingIntervalSecs = rollingIntervalSecs;
        this.maxFailures = maxFailures;
        this.closeFileAfterWrite = closeFileAfterWrite;
        Logging.$init$((Logging)this);
        this.pastLogs = new ArrayBuffer();
        this.callerName = FileBasedWriteAheadLog$.MODULE$.getCallerName();
        this.threadpoolName = new StringBuilder(20).append("WriteAheadLogManager").append(this.callerName().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(5).append(" for ").append((String)c).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        this.forkJoinPool = ThreadUtils$.MODULE$.newForkJoinPool(this.threadpoolName(), 20);
        this.executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.forkJoinPool());
        this.currentLogPath = None$.MODULE$;
        this.currentLogWriter = null;
        this.currentLogWriterStartTime = -1L;
        this.currentLogWriterStopTime = -1L;
        this.initializeOrRecover();
    }

    public static class LogInfo
    implements Product,
    scala.Serializable {
        private final long startTime;
        private final long endTime;
        private final String path;

        public long startTime() {
            return this.startTime;
        }

        public long endTime() {
            return this.endTime;
        }

        public String path() {
            return this.path;
        }

        public LogInfo copy(long startTime, long endTime, String path) {
            return new LogInfo(startTime, endTime, path);
        }

        public long copy$default$1() {
            return this.startTime();
        }

        public long copy$default$2() {
            return this.endTime();
        }

        public String copy$default$3() {
            return this.path();
        }

        public String productPrefix() {
            return "LogInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.startTime());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.endTime());
                    break;
                }
                case 2: {
                    object = this.path();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.startTime()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.endTime()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LogInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            LogInfo logInfo = (LogInfo)x$1;
            if (this.startTime() != logInfo.startTime()) return false;
            if (this.endTime() != logInfo.endTime()) return false;
            String string = this.path();
            String string2 = logInfo.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!logInfo.canEqual(this)) return false;
            return true;
        }

        public LogInfo(long startTime, long endTime, String path) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.path = path;
            Product.$init$((Product)this);
        }
    }
}

