/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.util.BatchedWriteAheadLog;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.util.control.NonFatal$;

public final class WriteAheadLogUtils$
implements Logging {
    public static WriteAheadLogUtils$ MODULE$;
    private final String RECEIVER_WAL_ENABLE_CONF_KEY;
    private final String RECEIVER_WAL_CLASS_CONF_KEY;
    private final String RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    private final String RECEIVER_WAL_MAX_FAILURES_CONF_KEY;
    private final String RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    private final String DRIVER_WAL_CLASS_CONF_KEY;
    private final String DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    private final String DRIVER_WAL_MAX_FAILURES_CONF_KEY;
    private final String DRIVER_WAL_BATCHING_CONF_KEY;
    private final String DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY;
    private final String DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    private final int DEFAULT_ROLLING_INTERVAL_SECS;
    private final int DEFAULT_MAX_FAILURES;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new WriteAheadLogUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String RECEIVER_WAL_ENABLE_CONF_KEY() {
        return this.RECEIVER_WAL_ENABLE_CONF_KEY;
    }

    public String RECEIVER_WAL_CLASS_CONF_KEY() {
        return this.RECEIVER_WAL_CLASS_CONF_KEY;
    }

    public String RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY() {
        return this.RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    }

    public String RECEIVER_WAL_MAX_FAILURES_CONF_KEY() {
        return this.RECEIVER_WAL_MAX_FAILURES_CONF_KEY;
    }

    public String RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY() {
        return this.RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    }

    public String DRIVER_WAL_CLASS_CONF_KEY() {
        return this.DRIVER_WAL_CLASS_CONF_KEY;
    }

    public String DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY() {
        return this.DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    }

    public String DRIVER_WAL_MAX_FAILURES_CONF_KEY() {
        return this.DRIVER_WAL_MAX_FAILURES_CONF_KEY;
    }

    public String DRIVER_WAL_BATCHING_CONF_KEY() {
        return this.DRIVER_WAL_BATCHING_CONF_KEY;
    }

    public String DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY() {
        return this.DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY;
    }

    public String DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY() {
        return this.DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    }

    public int DEFAULT_ROLLING_INTERVAL_SECS() {
        return this.DEFAULT_ROLLING_INTERVAL_SECS;
    }

    public int DEFAULT_MAX_FAILURES() {
        return this.DEFAULT_MAX_FAILURES;
    }

    public boolean enableReceiverLog(SparkConf conf) {
        return conf.getBoolean(this.RECEIVER_WAL_ENABLE_CONF_KEY(), false);
    }

    public int getRollingIntervalSecs(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getInt(this.DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY(), this.DEFAULT_ROLLING_INTERVAL_SECS()) : conf.getInt(this.RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY(), this.DEFAULT_ROLLING_INTERVAL_SECS());
    }

    public int getMaxFailures(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getInt(this.DRIVER_WAL_MAX_FAILURES_CONF_KEY(), this.DEFAULT_MAX_FAILURES()) : conf.getInt(this.RECEIVER_WAL_MAX_FAILURES_CONF_KEY(), this.DEFAULT_MAX_FAILURES());
    }

    public boolean isBatchingEnabled(SparkConf conf, boolean isDriver) {
        return isDriver && conf.getBoolean(this.DRIVER_WAL_BATCHING_CONF_KEY(), true);
    }

    public long getBatchingTimeout(SparkConf conf) {
        return conf.getLong(this.DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY(), 5000L);
    }

    public boolean shouldCloseFileAfterWrite(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getBoolean(this.DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY(), false) : conf.getBoolean(this.RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY(), false);
    }

    public WriteAheadLog createLogForDriver(SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        return this.createLog(true, sparkConf, fileWalLogDirectory, fileWalHadoopConf);
    }

    public WriteAheadLog createLogForReceiver(SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        return this.createLog(false, sparkConf, fileWalLogDirectory, fileWalHadoopConf);
    }

    private WriteAheadLog createLog(boolean isDriver, SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        Option classNameOption = isDriver ? sparkConf.getOption(this.DRIVER_WAL_CLASS_CONF_KEY()) : sparkConf.getOption(this.RECEIVER_WAL_CLASS_CONF_KEY());
        WriteAheadLog wal = (WriteAheadLog)classNameOption.map((Function1 & java.io.Serializable & Serializable)className -> {
            WriteAheadLog writeAheadLog;
            try {
                writeAheadLog = MODULE$.instantiateClass(Utils$.MODULE$.classForName(className), sparkConf);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new SparkException(new StringBuilder(44).append("Could not create a write ahead log of class ").append((String)className).toString(), e);
                }
                throw throwable;
            }
            return writeAheadLog;
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> new FileBasedWriteAheadLog(sparkConf, fileWalLogDirectory, fileWalHadoopConf, MODULE$.getRollingIntervalSecs(sparkConf, isDriver), MODULE$.getMaxFailures(sparkConf, isDriver), MODULE$.shouldCloseFileAfterWrite(sparkConf, isDriver)));
        return this.isBatchingEnabled(sparkConf, isDriver) ? new BatchedWriteAheadLog(wal, sparkConf) : wal;
    }

    private WriteAheadLog instantiateClass(Class<? extends WriteAheadLog> cls, SparkConf conf) {
        WriteAheadLog writeAheadLog;
        try {
            writeAheadLog = cls.getConstructor(SparkConf.class).newInstance(conf);
        }
        catch (NoSuchMethodException nsme) {
            writeAheadLog = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return writeAheadLog;
    }

    private WriteAheadLogUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.RECEIVER_WAL_ENABLE_CONF_KEY = "spark.streaming.receiver.writeAheadLog.enable";
        this.RECEIVER_WAL_CLASS_CONF_KEY = "spark.streaming.receiver.writeAheadLog.class";
        this.RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY = "spark.streaming.receiver.writeAheadLog.rollingIntervalSecs";
        this.RECEIVER_WAL_MAX_FAILURES_CONF_KEY = "spark.streaming.receiver.writeAheadLog.maxFailures";
        this.RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY = "spark.streaming.receiver.writeAheadLog.closeFileAfterWrite";
        this.DRIVER_WAL_CLASS_CONF_KEY = "spark.streaming.driver.writeAheadLog.class";
        this.DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY = "spark.streaming.driver.writeAheadLog.rollingIntervalSecs";
        this.DRIVER_WAL_MAX_FAILURES_CONF_KEY = "spark.streaming.driver.writeAheadLog.maxFailures";
        this.DRIVER_WAL_BATCHING_CONF_KEY = "spark.streaming.driver.writeAheadLog.allowBatching";
        this.DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY = "spark.streaming.driver.writeAheadLog.batchingTimeout";
        this.DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY = "spark.streaming.driver.writeAheadLog.closeFileAfterWrite";
        this.DEFAULT_ROLLING_INTERVAL_SECS = 60;
        this.DEFAULT_MAX_FAILURES = 3;
    }
}

