/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.apache.spark.streaming.CheckpointInputDStream;
import org.apache.spark.streaming.CheckpointSuite$;
import org.apache.spark.streaming.CheckpointWriter;
import org.apache.spark.streaming.DStreamCheckpointTester;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.ObjectInputStreamWithLoader;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStreamWithPartitions;
import org.apache.spark.streaming.TestOutputStreamWithPartitions$;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.FileInputDStream;
import org.apache.spark.streaming.dstream.PairDStreamFunctions;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.ConstantEstimator;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.RateTestInputDStream;
import org.apache.spark.streaming.scheduler.RateTestReceiver;
import org.apache.spark.streaming.scheduler.RateTestReceiver$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.ResetSystemProperties;
import org.apache.spark.util.Utils$;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.time.SpanSugar$;
import org.sparkproject.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0007\u000f\u0001]AQ\u0001\f\u0001\u0005\u00025BQa\f\u0001\u0005BABQ\u0001\u000e\u0001\u0005BUBQ\u0001\u0010\u0001\u0005BUBQ!\u0010\u0001\u0005\u0002y:Q!\u001c\b\t\n94Q!\u0004\b\t\n=DQ\u0001L\u0004\u0005\u0002mDq\u0001`\u0004A\u0002\u0013\u0005Q\u0010C\u0005\u0002\u0004\u001d\u0001\r\u0011\"\u0001\u0002\u0006!9\u00111B\u0004!B\u0013q\b\"CA\u0007\u000f\u0005\u0005I\u0011BA\b\u0005=\u0019\u0005.Z2la>Lg\u000e^*vSR,'BA\b\u0011\u0003%\u0019HO]3b[&twM\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\r\u001dA\r2\u0003CA\r\u001b\u001b\u0005\u0001\u0012BA\u000e\u0011\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011QDH\u0007\u0002\u001d%\u0011qD\u0004\u0002\u000e)\u0016\u001cHoU;ji\u0016\u0014\u0015m]3\u0011\u0005u\t\u0013B\u0001\u0012\u000f\u0005UaunY1m'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\u0004\"!\b\u0013\n\u0005\u0015r!a\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oiR+7\u000f^3s!\t9#&D\u0001)\u0015\tI\u0003#\u0001\u0003vi&d\u0017BA\u0016)\u0005U\u0011Vm]3u'f\u001cH/Z7Qe>\u0004XM\u001d;jKN\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005u\u0001\u0011!\u00042bi\u000eDG)\u001e:bi&|g.F\u00012!\ti\"'\u0003\u00024\u001d\tAA)\u001e:bi&|g.\u0001\u0006cK\u001a|'/Z#bG\"$\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG/A\u0005bMR,'/R1dQ\u0006A\u0012\r\u001a<b]\u000e,G+[7f/&$\bNU3bY\u0012+G.Y=\u0016\u0005}\u0012Fc\u0001!dQR\u0011\u0011i\u0017\t\u0004\u0005*keBA\"I\u001d\t!u)D\u0001F\u0015\t1e#\u0001\u0004=e>|GOP\u0005\u0002s%\u0011\u0011\nO\u0001\ba\u0006\u001c7.Y4f\u0013\tYEJ\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tI\u0005\bE\u0002C\u001dBK!a\u0014'\u0003\u0007M+\u0017\u000f\u0005\u0002R%2\u0001A!B*\u0006\u0005\u0004!&!\u0001,\u0012\u0005UC\u0006CA\u001cW\u0013\t9\u0006HA\u0004O_RD\u0017N\\4\u0011\u0005]J\u0016B\u0001.9\u0005\r\te.\u001f\u0005\b9\u0016\t\t\u0011q\u0001^\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0004=\u0006\u0004V\"A0\u000b\u0005\u0001D\u0014a\u0002:fM2,7\r^\u0005\u0003E~\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006I\u0016\u0001\r!Z\u0001\u0004gN\u001c\u0007CA\u000fg\u0013\t9gB\u0001\tTiJ,\u0017-\\5oO\u000e{g\u000e^3yi\")\u0011.\u0002a\u0001U\u0006Qa.^7CCR\u001c\u0007.Z:\u0011\u0005]Z\u0017B\u000179\u0005\u0011auN\\4\u0002\u001f\rCWmY6q_&tGoU;ji\u0016\u0004\"!H\u0004\u0014\u0007\u001d\u00018\u000f\u0005\u00028c&\u0011!\u000f\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018AA5p\u0015\u0005A\u0018\u0001\u00026bm\u0006L!A_;\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u00039\faDY1uG\"$\u0006N]3f'\"|W\u000f\u001c3CY>\u001c7.\u0011'p]\u001e$\u0016.\\3\u0016\u0003y\u0004\"aN@\n\u0007\u0005\u0005\u0001HA\u0004C_>dW-\u00198\u0002E\t\fGo\u00195UQJ,Wm\u00155pk2$'\t\\8dW\u0006cuN\\4US6,w\fJ3r)\r1\u0014q\u0001\u0005\t\u0003\u0013Q\u0011\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\u0002?\t\fGo\u00195UQJ,Wm\u00155pk2$'\t\\8dW\u0006cuN\\4US6,\u0007%A\u0006sK\u0006$'+Z:pYZ,GCAA\t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\fo\u0006!A.\u00198h\u0013\u0011\tY\"!\u0006\u0003\r=\u0013'.Z2u\u0001")
public class CheckpointSuite
extends SparkFunSuite
implements TestSuiteBase,
LocalStreamingContext,
DStreamCheckpointTester,
ResetSystemProperties {
    private Properties oldProperties;
    private transient StreamingContext ssc;
    private transient boolean stopSparkContext;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    public static void batchThreeShouldBlockALongTime_$eq(boolean bl) {
        CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime_$eq(bl);
    }

    public static boolean batchThreeShouldBlockALongTime() {
        return CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime();
    }

    public /* synthetic */ void org$apache$spark$util$ResetSystemProperties$$super$beforeEach() {
        TestSuiteBase.beforeEach$(this);
    }

    public /* synthetic */ void org$apache$spark$util$ResetSystemProperties$$super$afterEach() {
        LocalStreamingContext.afterEach$(this);
    }

    @Override
    public <U, V> void testCheckpointedOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatchesBeforeRestart, Duration batchDuration, boolean stopSparkContextAfterTest, ClassTag<U> evidence$1, ClassTag<V> evidence$2) {
        DStreamCheckpointTester.testCheckpointedOperation$(this, input, operation, expectedOutput, numBatchesBeforeRestart, batchDuration, stopSparkContextAfterTest, evidence$1, evidence$2);
    }

    @Override
    public <U, V> Duration testCheckpointedOperation$default$5() {
        return DStreamCheckpointTester.testCheckpointedOperation$default$5$(this);
    }

    @Override
    public <U, V> boolean testCheckpointedOperation$default$6() {
        return DStreamCheckpointTester.testCheckpointedOperation$default$6$(this);
    }

    @Override
    public StreamingContext createContextForCheckpointOperation(Duration batchDuration) {
        return DStreamCheckpointTester.createContextForCheckpointOperation$(this, batchDuration);
    }

    @Override
    public <V> TestOutputStreamWithPartitions<V> getTestOutputStream(DStream<?>[] streams, ClassTag<V> evidence$3) {
        return DStreamCheckpointTester.getTestOutputStream$(this, streams, evidence$3);
    }

    @Override
    public <V> Seq<Seq<V>> generateOutput(StreamingContext ssc, Time targetBatchTime, String checkpointDir, boolean stopSparkContext, ClassTag<V> evidence$4) {
        return DStreamCheckpointTester.generateOutput$(this, ssc, targetBatchTime, checkpointDir, stopSparkContext, evidence$4);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        TestSuiteBase.afterEach$(this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public String framework() {
        return TestSuiteBase.framework$(this);
    }

    @Override
    public String master() {
        return TestSuiteBase.master$(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase.beforeFunction$(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase.afterFunction$(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$(this, input, operation, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$(this);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$(this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$(this);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$(this);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$(this, output, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$(this);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    public Properties oldProperties() {
        return this.oldProperties;
    }

    public void oldProperties_$eq(Properties x$1) {
        this.oldProperties = x$1;
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    private String checkpointDir$lzycompute() {
        CheckpointSuite checkpointSuite = this;
        synchronized (checkpointSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$(this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    @Override
    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    @Override
    public Duration batchDuration() {
        return Milliseconds$.MODULE$.apply(500L);
    }

    @Override
    public void beforeEach() {
        ResetSystemProperties.beforeEach$((ResetSystemProperties)this);
        Utils$.MODULE$.deleteRecursively(new File(this.checkpointDir()));
    }

    @Override
    public void afterEach() {
        try {
            Utils$.MODULE$.deleteRecursively(new File(this.checkpointDir()));
        }
        finally {
            ResetSystemProperties.afterEach$((ResetSystemProperties)this);
        }
    }

    public <V> Iterable<Seq<V>> advanceTimeWithRealDelay(StreamingContext ssc, long numBatches, ClassTag<V> evidence$6) {
        ManualClock clock = (ManualClock)ssc.scheduler().clock();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Manual clock before advancing = ").append(clock.getTimeMillis()).toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), (int)numBatches).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            clock.advance(this.batchDuration().milliseconds());
            Thread.sleep(this.batchDuration().milliseconds());
        });
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Manual clock after advancing = ").append(clock.getTimeMillis()).toString());
        Thread.sleep(this.batchDuration().milliseconds());
        TestOutputStreamWithPartitions<V> outputStream = this.getTestOutputStream(ssc.graph().getOutputStreams(), evidence$6);
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputStream.output()).asScala()).map((Function1 & Serializable & scala.Serializable)x$26 -> (Seq)x$26.flatten((Function1)Predef$.MODULE$.$conforms()), Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$4(int x$3) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
    }

    private final void waitForCompletionOfBatch$1(long numBatches) {
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(50).millis()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool bool;
            Time lastProcessed;
            Time $org_scalatest_assert_macro_left = lastProcessed = this.ssc().scheduler().jobGenerator().lastProcessedBatch();
            Object $org_scalatest_assert_macro_right = null;
            Time time = $org_scalatest_assert_macro_left;
            Object var8_5 = null;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, time == null ? var8_5 != null : !time.equals(var8_5), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                Time $org_scalatest_assert_macro_left3 = lastProcessed;
                Time $org_scalatest_assert_macro_right2 = new Time(this.batchDuration().milliseconds() * numBatches);
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">=", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$greater$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }

    public static final /* synthetic */ Seq $anonfun$new$34(int x$6) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
    }

    public static final /* synthetic */ Seq $anonfun$new$35(int x) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4))}));
    }

    public static final /* synthetic */ Seq $anonfun$new$54(int x$17) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
    }

    public static final /* synthetic */ Seq $anonfun$new$55(int x) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)x))}));
    }

    private final void writeFile$1(int i, Clock clock, File testDir$1) {
        File file = new File(testDir$1, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        Files.write((CharSequence)new StringBuilder(1).append(i).append("\n").toString(), (File)file, (Charset)StandardCharsets.UTF_8);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(file.setLastModified(clock.getTimeMillis()), "file.setLastModified(clock.getTimeMillis())", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)file.lastModified()));
        long $org_scalatest_assert_macro_right = clock.getTimeMillis();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
    }

    public static final /* synthetic */ int $anonfun$new$66(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$18.split("/"))).last())).toInt();
    }

    private static final Seq recordedFiles$1(StreamingContext ssc) {
        Iterable iterable;
        FileInputDStream fileInputDStream = (FileInputDStream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getInputStreams())).head();
        HashMap hashMap = fileInputDStream.batchTimeToSelectedFiles();
        synchronized (hashMap) {
            iterable = (Iterable)fileInputDStream.batchTimeToSelectedFiles().values().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
        }
        Iterable filenames = iterable;
        return (Seq)((TraversableOnce)filenames.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)CheckpointSuite.$anonfun$new$66(x$18)), Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.Int$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$new$68(String s) {
        void var1_1;
        block0: {
            int i = new StringOps(Predef$.MODULE$.augmentString(s)).toInt();
            if (i != 3 || !CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime()) break block0;
            Thread.sleep(6000L);
        }
        return (int)var1_1;
    }

    public static final /* synthetic */ Object $anonfun$new$70(CheckpointSuite $this, ObjectRef clock$2, Duration batchDuration$1, BatchCounter batchCounter$2, File testDir$1, int i) {
        $this.writeFile$1(i, (Clock)((ManualClock)clock$2.elem), testDir$1);
        ((ManualClock)clock$2.elem).advance(batchDuration$1.milliseconds());
        return i != 3 ? Eventually$.MODULE$.eventually($this.eventuallyTimeout(), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounter$2.getNumCompletedBatches()));
            int $org_scalatest_assert_macro_right = i;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
        }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710)) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$79(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$98(CheckpointSuite $this, File tempDir) {
        FileSystem fs = FileSystem.get((URI)tempDir.toURI(), (Configuration)new Configuration());
        String checkpointDir = new StringBuilder(14).append(tempDir.getAbsolutePath()).append("/checkpoint-01").toString();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, (Option)new Some((Object)fs)).length()));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 892));
        fs.create(new Path(checkpointDir, "this-is-matched-before-due-to-parent-path")).close();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, (Option)new Some((Object)fs)).length()));
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        fs.mkdirs(new Path(checkpointDir, "checkpoint-1000000000"));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, (Option)new Some((Object)fs)).length()));
        int $org_scalatest_assert_macro_right3 = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$102(int i) {
        return new Tuple2.mcII.sp(i, i);
    }

    /*
     * WARNING - void declaration
     */
    private static final List findAllMarkedRDDs$1(RDD rdd) {
        List list;
        List markedRDDs = ((TraversableOnce)rdd.dependencies().flatMap((Function1 & Serializable & scala.Serializable)dep -> CheckpointSuite.findAllMarkedRDDs$1(dep.rdd()), Seq$.MODULE$.canBuildFrom())).toList();
        if (rdd.checkpointData().isDefined()) {
            RDD rDD = rdd;
            list = markedRDDs.$colon$colon((Object)rDD);
        } else {
            void var1_1;
            list = var1_1;
        }
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$new$105(String x$24) {
        return new StringOps(Predef$.MODULE$.augmentString(x$24)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$new$103(VolatileBooleanRef shouldCheckpointAllMarkedRDDs$1, VolatileBooleanRef rddsCheckpointed$1, RDD rdd) {
        shouldCheckpointAllMarkedRDDs$1.elem = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)rdd.sparkContext().getLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS())).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)CheckpointSuite.$anonfun$new$105(x$24))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        List stateRDDs = CheckpointSuite.findAllMarkedRDDs$1(rdd);
        rdd.count();
        rddsCheckpointed$1.elem = stateRDDs.size() == 2 && stateRDDs.forall((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)x$25.isCheckpointed()));
    }

    public CheckpointSuite() {
        TestSuiteBase.$init$(this);
        LocalStreamingContext.$init$(this);
        DStreamCheckpointTester.$init$(this);
        ResetSystemProperties.$init$((ResetSystemProperties)this);
        this.test("non-existent checkpoint dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new StreamingContext("nosuchdirectory"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228)), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("basic rdd checkpoints + dstream graph checkpoint recovery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HashMap currCheckpointFiles;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.batchDuration());
            Duration $org_scalatest_assert_macro_right = Milliseconds$.MODULE$.apply(500L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"batchDuration for this test must be 1 second", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            this.conf().set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
            Duration stateStreamCheckpointInterval = Seconds$.MODULE$.apply(1L);
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            long firstNumBatches = (long)stateStreamCheckpointInterval.$div(this.batchDuration());
            long secondNumBatches = firstNumBatches * 2L;
            scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$3 -> CheckpointSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
            Function1 & Serializable & scala.Serializable operation = (Function1 & Serializable & scala.Serializable)st -> {
                Function2 & Serializable & scala.Serializable updateFunc = (Function2 & Serializable & scala.Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)))));
                return DStream$.MODULE$.toPairDStreamFunctions(st.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(stateStreamCheckpointInterval).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t._1(), (Object)BoxesRunTime.boxToInteger((int)t._2$mcI$sp())), ClassTag$.MODULE$.apply(Tuple2.class));
            };
            this.ssc_$eq(this.setupStreams((Seq)input, (Function1)operation, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)));
            ObjectRef stateStream = ObjectRef.create((Object)((DStream)((DStream)((DStream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getOutputStreams())).head()).dependencies().head()).dependencies().head()));
            this.ssc().start();
            this.advanceTimeWithRealDelay(this.ssc(), firstNumBatches, ClassTag$.MODULE$.Nothing());
            this.waitForCompletionOfBatch$1(firstNumBatches);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Checkpoint data of state stream = \n").append(((DStream)stateStream$1.elem).checkpointData()).toString());
            HashMap $org_scalatest_assert_macro_left2 = currCheckpointFiles = ((DStream)stateStream.elem).checkpointData().currentCheckpointFiles();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"No checkpointed RDDs in state stream before first failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            currCheckpointFiles.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Time time = (Time)tuple2._1();
                String file = (String)tuple2._2();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fs.exists(new Path(file)), "fs.exists(new org.apache.hadoop.fs.Path(file))", Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(81).append("Checkpoint file '").append(file).append("' for time ").append(time).append(" for state stream before first failure does not exist").toString(), Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
                return assertion;
            });
            currCheckpointFiles = ((DStream)stateStream.elem).checkpointData().currentCheckpointFiles();
            scala.collection.mutable.Iterable checkpointFiles = (scala.collection.mutable.Iterable)currCheckpointFiles.map((Function1 & Serializable & scala.Serializable)x -> new File((String)x._2()), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
            this.advanceTimeWithRealDelay(this.ssc(), secondNumBatches - firstNumBatches, ClassTag$.MODULE$.Nothing());
            this.waitForCompletionOfBatch$1(secondNumBatches);
            checkpointFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(file.exists(), "file.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(34).append("Checkpoint file '").append(file).append("' was not deleted").toString(), Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
            });
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
            this.ssc_$eq(new StreamingContext(this.checkpointDir()));
            stateStream.elem = (DStream)((DStream)((DStream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getOutputStreams())).head()).dependencies().head()).dependencies().head();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Restored data of state stream = \n[").append(((DStream)stateStream$1.elem).generatedRDDs().mkString("\n")).append("]").toString());
            HashMap $org_scalatest_assert_macro_left3 = ((DStream)stateStream.elem).generatedRDDs();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"No restored RDDs in state stream after recovery from first failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            this.ssc().start();
            this.advanceTimeWithRealDelay(this.ssc(), 1L, ClassTag$.MODULE$.Nothing());
            this.waitForCompletionOfBatch$1(secondNumBatches + 1L);
            HashMap $org_scalatest_assert_macro_left4 = currCheckpointFiles = ((DStream)stateStream.elem).checkpointData().currentCheckpointFiles();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"No checkpointed RDDs in state stream before second failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            currCheckpointFiles.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Time time = (Time)tuple2._1();
                String file = (String)tuple2._2();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fs.exists(new Path(file)), "fs.exists(new org.apache.hadoop.fs.Path(file))", Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(83).append("Checkpoint file '").append(file).append("' for time ").append(time).append(" for state stream before seconds failure does not exist").toString(), Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                return assertion;
            });
            StreamingContext qual$2 = this.ssc();
            boolean x$2 = qual$2.stop$default$1();
            qual$2.stop(x$2);
            this.ssc_$eq(new StreamingContext(this.checkpointDir()));
            stateStream.elem = (DStream)((DStream)((DStream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getOutputStreams())).head()).dependencies().head()).dependencies().head();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Restored data of state stream = \n[").append(((DStream)stateStream$1.elem).generatedRDDs().mkString("\n")).append("]").toString());
            HashMap $org_scalatest_assert_macro_left5 = ((DStream)stateStream.elem).generatedRDDs();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"No restored RDDs in state stream after recovery from second failure", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            this.ssc().conf().set("spark.streaming.manualClock.jump", ((Object)BoxesRunTime.boxToLong((long)(this.batchDuration().milliseconds() * 7L))).toString());
            this.ssc().start();
            this.advanceTimeWithRealDelay(this.ssc(), 4L, ClassTag$.MODULE$.Nothing());
            StreamingContext qual$3 = this.ssc();
            boolean x$32 = qual$3.stop$default$1();
            qual$3.stop(x$32);
            this.ssc_$eq(null);
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("recovery of conf through checkpoints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String key = "spark.mykey";
            String value = "myvalue";
            System.setProperty(key, value);
            this.ssc_$eq(new StreamingContext(this.master(), this.framework(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            SparkConf originalConf = this.ssc().conf();
            Checkpoint cp = new Checkpoint(this.ssc(), new Time(1000L));
            SparkConf cpConf = cp.createSparkConf();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(cpConf.get("spark.master"));
            String $org_scalatest_assert_macro_right = originalConf.get("spark.master");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(cpConf.get("spark.app.name"));
            String $org_scalatest_assert_macro_right2 = originalConf.get("spark.app.name");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(cpConf.get(key));
            String $org_scalatest_assert_macro_right3 = value;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            StreamingContext qual$4 = this.ssc();
            boolean x$4 = qual$4.stop$default$1();
            qual$4.stop(x$4);
            Checkpoint newCp = (Checkpoint)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)cp));
            SparkConf newCpConf = newCp.createSparkConf();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(newCpConf.get("spark.master"));
            String $org_scalatest_assert_macro_right4 = originalConf.get("spark.master");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(newCpConf.get("spark.app.name"));
            String $org_scalatest_assert_macro_right5 = originalConf.get("spark.app.name");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(newCpConf.get(key));
            String $org_scalatest_assert_macro_right6 = value;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            SparkConf $org_scalatest_assert_macro_left7 = newCpConf;
            String $org_scalatest_assert_macro_right7 = "spark.driver.host";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            SparkConf $org_scalatest_assert_macro_left8 = newCpConf;
            String $org_scalatest_assert_macro_right8 = "spark.driver.port";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            this.ssc_$eq(new StreamingContext(null, newCp, null));
            SparkConf restoredConf = this.ssc().conf();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(restoredConf.get(key));
            String $org_scalatest_assert_macro_right9 = value;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            StreamingContext qual$5 = this.ssc();
            boolean x$5 = qual$5.stop$default$1();
            qual$5.stop(x$5);
            try {
                String newMaster = "local[100]";
                System.setProperty("spark.master", newMaster);
                SparkConf newCpConf2 = newCp.createSparkConf();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(newCpConf2.get("spark.master"));
                String $org_scalatest_assert_macro_right10 = newMaster;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(newCpConf2.get("spark.app.name"));
                String $org_scalatest_assert_macro_right11 = originalConf.get("spark.app.name");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
                this.ssc_$eq(new StreamingContext(null, newCp, null));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(this.ssc().sparkContext().master());
                String $org_scalatest_assert_macro_right12 = newMaster;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
            }
            finally {
                System.clearProperty("spark.master");
            }
            return assertion;
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("get correct spark.driver.[host|port] from checkpoint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf newCpConf1;
            SparkConf newCpConf;
            Map conf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.host"), (Object)"localhost"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.port"), (Object)"9999")}));
            conf.foreach((Function1 & Serializable & scala.Serializable)kv -> System.setProperty((String)kv._1(), (String)kv._2()));
            this.ssc_$eq(new StreamingContext(this.master(), this.framework(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            SparkConf originalConf = this.ssc().conf();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originalConf.get("spark.driver.host"));
            String $org_scalatest_assert_macro_right = "localhost";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(originalConf.get("spark.driver.port"));
            String $org_scalatest_assert_macro_right2 = "9999";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            Checkpoint cp = new Checkpoint(this.ssc(), new Time(1000L));
            StreamingContext qual$6 = this.ssc();
            boolean x$6 = qual$6.stop$default$1();
            qual$6.stop(x$6);
            Checkpoint newCp = (Checkpoint)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)cp));
            SparkConf $org_scalatest_assert_macro_left3 = newCpConf = newCp.createSparkConf();
            String $org_scalatest_assert_macro_right3 = "spark.driver.host";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            SparkConf $org_scalatest_assert_macro_left4 = newCpConf;
            String $org_scalatest_assert_macro_right4 = "spark.driver.port";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(newCpConf.get("spark.driver.host"));
            String $org_scalatest_assert_macro_right5 = "localhost";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(newCpConf.get("spark.driver.port"));
            String $org_scalatest_assert_macro_right6 = "9999";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            this.ssc_$eq(new StreamingContext(null, newCp, null));
            SparkConf restoredConf = this.ssc().conf();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(restoredConf.get("spark.driver.host"));
            String $org_scalatest_assert_macro_right7 = "localhost";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(restoredConf.get("spark.driver.port"));
            String $org_scalatest_assert_macro_right8 = "9999";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            StreamingContext qual$7 = this.ssc();
            boolean x$7 = qual$7.stop$default$1();
            qual$7.stop(x$7);
            conf.foreach((Function1 & Serializable & scala.Serializable)kv -> System.clearProperty((String)kv._1()));
            SparkConf $org_scalatest_assert_macro_left9 = newCpConf1 = newCp.createSparkConf();
            String $org_scalatest_assert_macro_right9 = "spark.driver.host";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            SparkConf $org_scalatest_assert_macro_left10 = newCpConf1;
            String $org_scalatest_assert_macro_right10 = "spark.driver.port";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.contains($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
            this.ssc_$eq(new StreamingContext(null, newCp, null));
            SparkConf restoredConf1 = this.ssc().conf();
            SparkConf defaultConf = new SparkConf();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(restoredConf1.get("spark.driver.host"));
            String $org_scalatest_assert_macro_right11 = (String)defaultConf.get(package$.MODULE$.DRIVER_HOST_ADDRESS());
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(restoredConf1.get("spark.driver.port"));
            String $org_scalatest_assert_macro_right12 = "9999";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "!==", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$bang$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        this.test("SPARK-30199 get ui port and blockmanager port", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map conf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.ui.port"), (Object)"30001"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.blockManager.port"), (Object)"30002")}));
            conf.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string = System.setProperty(k, v);
                return string;
            });
            this.ssc_$eq(new StreamingContext(this.master(), this.framework(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            conf.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().conf().get(k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
                return assertion;
            });
            Checkpoint cp = new Checkpoint(this.ssc(), new Time(1000L));
            StreamingContext qual$8 = this.ssc();
            boolean x$8 = qual$8.stop$default$1();
            qual$8.stop(x$8);
            Checkpoint newCp = (Checkpoint)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)cp));
            SparkConf newCpConf = newCp.createSparkConf();
            conf.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Bool bool;
                Bool $org_scalatest_assert_macro_left;
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    SparkConf $org_scalatest_assert_macro_left2 = newCpConf;
                    String $org_scalatest_assert_macro_right = k;
                    $org_scalatest_assert_macro_left = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left.value()) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(newCpConf.get(k));
                        String $org_scalatest_assert_macro_right2 = v;
                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    } else {
                        bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
                return assertion;
            });
            this.ssc_$eq(new StreamingContext(null, newCp, null));
            conf.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().conf().get(k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
                return assertion;
            });
            StreamingContext qual$9 = this.ssc();
            boolean x$9 = qual$9.stop$default$1();
            qual$9.stop(x$9);
            conf.foreach((Function1 & Serializable & scala.Serializable)kv -> System.clearProperty((String)kv._1()));
            SparkConf newCpConf1 = newCp.createSparkConf();
            conf.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                SparkConf $org_scalatest_assert_macro_left = newCpConf1;
                String $org_scalatest_assert_macro_right = k;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
                return assertion;
            });
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        this.test("recovery with map and reduceByKey operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable & scala.Serializable)s -> DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$4, x$5) -> x$4 + x$5), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.testCheckpointedOperation$default$5(), this.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class)), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        this.test("recovery with invertible reduceByKeyAndWindow operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int n = 10;
            int w = 4;
            scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).map((Function1 & Serializable & scala.Serializable)x$6 -> CheckpointSuite.$anonfun$new$34(BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
            Seq output = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3))}))}))).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n - w + 1).map((Function1 & Serializable & scala.Serializable)x -> CheckpointSuite.$anonfun$new$35(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            Function1 & Serializable & scala.Serializable operation = (Function1 & Serializable & scala.Serializable)st -> {
                PairDStreamFunctions qual$10 = DStream$.MODULE$.toPairDStreamFunctions(st.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                JFunction2.mcIII.sp & Serializable & scala.Serializable x$102 = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$7, x$8) -> x$7 + x$8;
                JFunction2.mcIII.sp & Serializable & scala.Serializable x$11 = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$9, x$10) -> x$9 - x$10;
                Duration x$12 = this.batchDuration().$times(w);
                Duration x$13 = this.batchDuration();
                int x$14 = qual$10.reduceByKeyAndWindow$default$5();
                Function1 x$15 = qual$10.reduceByKeyAndWindow$default$6();
                return qual$10.reduceByKeyAndWindow((Function2)x$102, (Function2)x$11, x$12, x$13, x$14, x$15).checkpoint(this.batchDuration().$times(2));
            };
            this.testCheckpointedOperation((Seq)input, (Function1)operation, (Seq)output, 7, this.testCheckpointedOperation$default$5(), this.testCheckpointedOperation$default$6(), (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        this.test("recovery with saveAsHadoopFiles operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            try {
                this.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable & scala.Serializable)s -> {
                    void var2_2;
                    DStream output = DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$11, x$12) -> x$11 + x$12);
                    PairDStreamFunctions qual$11 = DStream$.MODULE$.toPairDStreamFunctions(output, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                    String x$16 = tempDir.toURI().toString();
                    String x$17 = "result";
                    Class<Text> x$18 = Text.class;
                    Class<IntWritable> x$19 = IntWritable.class;
                    Class<TextOutputFormat> x$20 = TextOutputFormat.class;
                    JobConf x$21 = qual$11.saveAsHadoopFiles$default$6();
                    qual$11.saveAsHadoopFiles(x$16, x$17, x$18, x$19, x$20, x$21);
                    return var2_2;
                }, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.testCheckpointedOperation$default$5(), this.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
        this.test("recovery with saveAsNewAPIHadoopFiles operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            try {
                this.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable & scala.Serializable)s -> {
                    void var2_2;
                    DStream output = DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$13, x$14) -> x$13 + x$14);
                    PairDStreamFunctions qual$12 = DStream$.MODULE$.toPairDStreamFunctions(output, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                    String x$22 = tempDir.toURI().toString();
                    String x$23 = "result";
                    Class<Text> x$24 = Text.class;
                    Class<IntWritable> x$25 = IntWritable.class;
                    Class<org.apache.hadoop.mapreduce.lib.output.TextOutputFormat> x$26 = org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class;
                    Configuration x$27 = qual$12.saveAsNewAPIHadoopFiles$default$6();
                    qual$12.saveAsNewAPIHadoopFiles(x$22, x$23, x$24, x$25, x$26, x$27);
                    return var2_2;
                }, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.testCheckpointedOperation$default$5(), this.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("recovery with saveAsHadoopFile inside transform operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            try {
                this.testCheckpointedOperation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable & scala.Serializable)s -> s.transform((Function2 & Serializable & scala.Serializable)(rdd, time) -> {
                    void var3_3;
                    RDD output = RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$15, x$16) -> x$15 + x$16);
                    PairRDDFunctions qual$13 = RDD$.MODULE$.rddToPairRDDFunctions(output, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$);
                    String x$28 = new File(tempDir, new StringBuilder(7).append("result-").append(time.milliseconds()).toString()).getAbsolutePath();
                    Class<Text> x$29 = Text.class;
                    Class<IntWritable> x$30 = IntWritable.class;
                    Class<TextOutputFormat> x$31 = TextOutputFormat.class;
                    JobConf x$32 = qual$13.saveAsHadoopFile$default$5();
                    Option x$33 = qual$13.saveAsHadoopFile$default$6();
                    qual$13.saveAsHadoopFile(x$28, x$29, x$30, x$31, x$32, x$33);
                    return var3_3;
                }, ClassTag$.MODULE$.apply(Tuple2.class)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)})), 3, this.testCheckpointedOperation$default$5(), this.testCheckpointedOperation$default$6(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("recovery with updateStateByKey operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$17 -> CheckpointSuite.$anonfun$new$54(BoxesRunTime.unboxToInt((Object)x$17)), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
            scala.collection.immutable.Seq output = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x -> CheckpointSuite.$anonfun$new$55(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
            Function1 & Serializable & scala.Serializable operation = (Function1 & Serializable & scala.Serializable)st -> {
                Function2 & Serializable & scala.Serializable updateFunc = (Function2 & Serializable & scala.Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)))));
                return DStream$.MODULE$.toPairDStreamFunctions(st.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(this.batchDuration().$times(2)).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t._1(), (Object)BoxesRunTime.boxToInteger((int)t._2$mcI$sp())), ClassTag$.MODULE$.apply(Tuple2.class));
            };
            this.testCheckpointedOperation((Seq)input, (Function1)operation, (Seq)output, 7, this.testCheckpointedOperation$default$5(), this.testCheckpointedOperation$default$6(), (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        this.test("recovery maintains rate controller", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.conf(), this.batchDuration()));
            this.ssc().checkpoint(this.checkpointDir());
            RateTestInputDStream dstream = new RateTestInputDStream(this){
                private final Some<ReceiverInputDStream.ReceiverRateController> rateController;

                public Some<ReceiverInputDStream.ReceiverRateController> rateController() {
                    return this.rateController;
                }
                {
                    this.rateController = new Some((Object)new ReceiverInputDStream.ReceiverRateController((ReceiverInputDStream)this, this.id(), (RateEstimator)new ConstantEstimator(200L)));
                }
            };
            TestOutputStreamWithPartitions output = new TestOutputStreamWithPartitions(dstream.checkpoint(this.batchDuration().$times(2)), TestOutputStreamWithPartitions$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
            output.register();
            this.runStreams(this.ssc(), 5, 5, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            this.ssc_$eq(new StreamingContext(this.checkpointDir()));
            this.ssc().start();
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Option<RateTestReceiver> $org_scalatest_assert_macro_left = RateTestReceiver$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
            }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
            this.advanceTimeWithRealDelay(this.ssc(), 2L, ClassTag$.MODULE$.Nothing());
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((RateTestReceiver)((Object)((Object)((Object)RateTestReceiver$.MODULE$.getActive().get())))).getDefaultBlockGeneratorRateLimit()));
                int $org_scalatest_assert_macro_right = 200;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
            }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            StreamingContext qual$14 = this.ssc();
            boolean x$34 = qual$14.stop$default$1();
            qual$14.stop(x$34);
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        this.test("recovery with file input stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object r;
            Duration batchDuration = Seconds$.MODULE$.apply(2L);
            File testDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            ConcurrentLinkedQueue outputBuffer = new ConcurrentLinkedQueue();
            try {
                ObjectRef clock = ObjectRef.create(null);
                this.withStreamingContext(new StreamingContext(this.conf(), batchDuration), (Function1 & Serializable & scala.Serializable)ssc -> {
                    ssc.checkpoint(this.checkpointDir());
                    clock$2.elem = (ManualClock)ssc.scheduler().clock();
                    BatchCounter batchCounter = new BatchCounter((StreamingContext)ssc);
                    DStream fileStream = ssc.textFileStream(testDir.toString());
                    CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime_$eq(true);
                    DStream mappedStream = fileStream.map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)CheckpointSuite.$anonfun$new$68(s)), ClassTag$.MODULE$.Int());
                    DStream reducedStream = mappedStream.reduceByWindow((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$19, x$20) -> x$19 + x$20, batchDuration.$times(30), batchDuration);
                    TestOutputStream outputStream = new TestOutputStream(reducedStream, outputBuffer, ClassTag$.MODULE$.Int());
                    outputStream.register();
                    ssc.start();
                    ((ManualClock)clock$2.elem).advance(batchDuration.milliseconds() / 2L);
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).foreach((Function1 & Serializable & scala.Serializable)i -> CheckpointSuite.$anonfun$new$70(this, clock, batchDuration, batchCounter, testDir, BoxesRunTime.unboxToInt((Object)i)));
                    Eventually$.MODULE$.eventually(this.eventuallyTimeout(), (Function0 & Serializable & scala.Serializable)() -> {
                        Bool bool;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CheckpointSuite.recordedFiles$1(ssc));
                        Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
                        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        if ($org_scalatest_assert_macro_left2.value()) {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounter.getNumStartedBatches()));
                            int $org_scalatest_assert_macro_right2 = 3;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        } else {
                            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                        }
                        Bool $org_scalatest_assert_macro_right3 = bool;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                        return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
                    }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
                    ((ManualClock)clock$2.elem).advance(batchDuration.milliseconds());
                    Eventually$.MODULE$.eventually(this.eventuallyTimeout(), (Function0 & Serializable & scala.Serializable)() -> {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Checkpoint$.MODULE$.getCheckpointFiles(this.checkpointDir(), Checkpoint$.MODULE$.getCheckpointFiles$default$2()).size()));
                        int $org_scalatest_assert_macro_right = 6;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
                    }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
                    ssc.stop(ssc.stop$default$1());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounter.getNumCompletedBatches()));
                    int $org_scalatest_assert_macro_right = 2;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputStream.output()).asScala()).toSeq().flatten((Function1)Predef$.MODULE$.$conforms()));
                    Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
                });
                CheckpointSuite$.MODULE$.batchThreeShouldBlockALongTime_$eq(false);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    this.writeFile$1(i, (Clock)((ManualClock)clock$2.elem), testDir);
                    ((ManualClock)clock$2.elem).advance(batchDuration.milliseconds());
                });
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> "*********** RESTARTING ************");
                r = this.withStreamingContext(new StreamingContext(this.checkpointDir()), (Function1 & Serializable & scala.Serializable)ssc -> {
                    ssc.conf().set("spark.streaming.manualClock.jump", ((Object)BoxesRunTime.boxToLong((long)(batchDuration.milliseconds() / 2L + batchDuration.milliseconds() * 3L))).toString());
                    long oldClockTime = ((ManualClock)clock$2.elem).getTimeMillis();
                    clock$2.elem = (ManualClock)ssc.scheduler().clock();
                    BatchCounter batchCounter = new BatchCounter((StreamingContext)ssc);
                    TestOutputStream outputStream = (TestOutputStream)((Object)((Object)((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams())).head())));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CheckpointSuite.recordedFiles$1(ssc));
                    Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
                    ssc.start();
                    Eventually$.MODULE$.eventually(this.eventuallyTimeout(), (Function0 & Serializable & scala.Serializable)() -> {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((ManualClock)clock$2.elem).getTimeMillis()));
                        long $org_scalatest_assert_macro_right = oldClockTime;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
                    }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 760));
                    int numBatchesAfterRestart = 5;
                    Eventually$.MODULE$.eventually(this.eventuallyTimeout(), (Function0 & Serializable & scala.Serializable)() -> {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounter.getNumCompletedBatches()));
                        int $org_scalatest_assert_macro_right = numBatchesAfterRestart;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
                    }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
                    ((TraversableLike)((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CheckpointSuite.$anonfun$new$79(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$21 -> {
                        Tuple2 tuple2 = x$21;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        int i = tuple2._1$mcI$sp();
                        int index = tuple2._2$mcI$sp();
                        this.writeFile$1(i, (Clock)((ManualClock)clock$2.elem), testDir);
                        ((ManualClock)clock$2.elem).advance(batchDuration.milliseconds());
                        Assertion assertion = (Assertion)Eventually$.MODULE$.eventually(this.eventuallyTimeout(), (Function0 & Serializable & scala.Serializable)() -> {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchCounter.getNumCompletedBatches()));
                            int $org_scalatest_assert_macro_right = index + numBatchesAfterRestart + 1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
                        }, Eventually$.MODULE$.patienceConfig(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
                        return assertion;
                    });
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Output after restart = ").append(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(outputStream.output()).asScala()).mkString("[", ", ", "]")).toString());
                    int $org_scalatest_assert_macro_left2 = outputStream.output().size();
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"No files processed after restart", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
                    ssc.stop(ssc.stop$default$1());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(CheckpointSuite.recordedFiles$1(ssc));
                    Range.Inclusive $org_scalatest_assert_macro_right3 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9);
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
                    outputBuffer.addAll(outputStream.output());
                    Seq expectedOutput = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 10, 15, 21, 28, 36, 45}));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((TraversableOnce)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)outputBuffer).asScala()).flatten((Function1)Predef$.MODULE$.$conforms())).toSet());
                    Set $org_scalatest_assert_macro_right4 = expectedOutput.toSet();
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
                });
            }
            catch (Throwable throwable) {
                block10: {
                    try {
                        Utils$.MODULE$.deleteRecursively(testDir);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        if (throwable3 instanceof IOException) {
                            IOException iOException = (IOException)throwable3;
                            if (Utils$.MODULE$.isWindows()) {
                                this.logWarning((Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block10;
                            }
                        }
                        throw throwable2;
                    }
                }
                throw throwable;
            }
            Object r2 = r;
            try {
                Utils$.MODULE$.deleteRecursively(testDir);
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 instanceof IOException) {
                    IOException iOException = (IOException)throwable4;
                    if (Utils$.MODULE$.isWindows()) {
                        this.logWarning((Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
            return r2;
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
        this.test("DStreamCheckpointData.restore invoking times", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.withStreamingContext(new StreamingContext(this.conf(), this.batchDuration()), (Function1 & Serializable & scala.Serializable)ssc -> {
                ssc.checkpoint(this.checkpointDir());
                CheckpointInputDStream inputDStream = new CheckpointInputDStream((StreamingContext)ssc);
                CheckpointInputDStream.FileInputDStreamCheckpointData checkpointData = inputDStream.checkpointData();
                DStream mappedDStream = inputDStream.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$22 -> x$22 + 100, ClassTag$.MODULE$.Int());
                TestOutputStreamWithPartitions outputStream = new TestOutputStreamWithPartitions(mappedDStream, TestOutputStreamWithPartitions$.MODULE$.$lessinit$greater$default$2(), ClassTag$.MODULE$.Int());
                outputStream.register();
                mappedDStream.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                    rdd.count();
                    return BoxedUnit.UNIT;
                });
                mappedDStream.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                    rdd.count();
                    return BoxedUnit.UNIT;
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
                long batchDurationMillis = ssc.progressListener().batchDuration();
                this.generateOutput((StreamingContext)ssc, new Time(batchDurationMillis * 3L), this.checkpointDir(), true, (ClassTag)ClassTag$.MODULE$.Nothing());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
            });
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "*********** RESTARTING ************");
            return (Assertion)this.withStreamingContext(new StreamingContext(this.checkpointDir()), (Function1 & Serializable & scala.Serializable)ssc -> {
                CheckpointInputDStream.FileInputDStreamCheckpointData checkpointData = ((CheckpointInputDStream)((Object)((Object)((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getInputStreams())).head())))).checkpointData();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
                ssc.start();
                ssc.stop(ssc.stop$default$1());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointData.restoredTimes()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
            });
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
        this.test("recovery from checkpoint contains array object", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL jar = TestUtils$.MODULE$.createJarWithClasses((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testClz"})), "testStringValue", TestUtils$.MODULE$.createJarWithClasses$default$3(), TestUtils$.MODULE$.createJarWithClasses$default$4());
            ClassLoader appClassLoader = this.getClass().getClassLoader();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> appClassLoader.loadClass("testClz"), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
            MutableURLClassLoader loader = new MutableURLClassLoader((URL[])((Object[])new URL[]{jar}), appClassLoader);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(loader.loadClass("testClz").getConstructor(new Class[0]).newInstance(new Object[0]).toString());
            String $org_scalatest_assert_macro_right = "testStringValue";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
            Class<?> arrayObj = Class.forName("[LtestClz;", false, (ClassLoader)loader);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new ObjectOutputStream(bos).writeObject(arrayObj);
            ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader((InputStream)new ByteArrayInputStream(bos.toByteArray()), (ClassLoader)loader);
            String $org_scalatest_assert_macro_left2 = ((Class)ois.readObject()).getName();
            String $org_scalatest_assert_macro_right2 = "[LtestClz;";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
            ois.close();
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
        this.test("SPARK-11267: the race condition of two checkpoints in a batch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JobGenerator jobGenerator = (JobGenerator)Mockito.mock(JobGenerator.class);
            String checkpointDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toString();
            CheckpointWriter checkpointWriter = new CheckpointWriter(jobGenerator, this.conf(), checkpointDir, new Configuration());
            byte[] bytes1 = (byte[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 1, ClassTag$.MODULE$.Byte());
            new CheckpointWriter.CheckpointWriteHandler(checkpointWriter, new Time(2000L), bytes1, false).run();
            byte[] bytes2 = (byte[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 2, ClassTag$.MODULE$.Byte());
            new CheckpointWriter.CheckpointWriteHandler(checkpointWriter, new Time(1000L), bytes2, true).run();
            Seq checkpointFiles = (Seq)((TraversableLike)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, Checkpoint$.MODULE$.getCheckpointFiles$default$2()).reverse()).map((Function1 & Serializable & scala.Serializable)path -> new File(path.toUri()), Seq$.MODULE$.canBuildFrom());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)checkpointFiles.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Files.toByteArray((File)((File)checkpointFiles.apply(0))));
            byte[] $org_scalatest_assert_macro_right2 = bytes2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Files.toByteArray((File)((File)checkpointFiles.apply(1))));
            byte[] $org_scalatest_assert_macro_right3 = bytes1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
            checkpointWriter.stop();
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
        this.test("SPARK-28912: Fix MatchError in getCheckpointFiles", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)tempDir -> {
            CheckpointSuite.$anonfun$new$98(this, tempDir);
            return BoxedUnit.UNIT;
        }), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887));
        this.test("SPARK-6847: stack overflow when updateStateByKey is followed by a checkpointed dstream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.framework(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            BatchCounter batchCounter = new BatchCounter(this.ssc());
            this.ssc().checkpoint(this.checkpointDir());
            CheckpointInputDStream inputDStream = new CheckpointInputDStream(this.ssc());
            Function2 & Serializable & scala.Serializable updateFunc = (Function2 & Serializable & scala.Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)))));
            VolatileBooleanRef shouldCheckpointAllMarkedRDDs = VolatileBooleanRef.create((boolean)false);
            VolatileBooleanRef rddsCheckpointed = VolatileBooleanRef.create((boolean)false);
            DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(inputDStream.map((Function1 & Serializable & scala.Serializable)i -> CheckpointSuite.$anonfun$new$102(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(this.batchDuration()), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Int()).checkpoint(this.batchDuration()).foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                CheckpointSuite.$anonfun$new$103(shouldCheckpointAllMarkedRDDs, rddsCheckpointed, rdd);
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            batchCounter.waitUntilBatchesCompleted(1, 10000L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(shouldCheckpointAllMarkedRDDs.elem, "shouldCheckpointAllMarkedRDDs", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 969));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(rddsCheckpointed.elem, "rddsCheckpointed", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 970));
        }, new Position("CheckpointSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
    }
}

