/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.RDDOperationScope;
import org.apache.spark.rdd.RDDOperationScope$;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.DummyDStream;
import org.apache.spark.streaming.DummyInputDStream;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.util.ManualClock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000193Aa\u0002\u0005\u0001#!)!\u0004\u0001C\u00017!)Q\u0004\u0001C!=!)Q\u0005\u0001C!=!)a\u0005\u0001C\u0005=!)q\u0005\u0001C\u0005Q!)\u0001\b\u0001C\u0005s\t\tBi\u0015;sK\u0006l7kY8qKN+\u0018\u000e^3\u000b\u0005%Q\u0011!C:ue\u0016\fW.\u001b8h\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005Q\u0011BA\u000b\u000b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011q\u0003G\u0007\u0002\u0011%\u0011\u0011\u0004\u0003\u0002\u0016\u0019>\u001c\u0017\r\\*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u0018\u0001\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012A!\u00168ji\u0006I\u0011M\u001a;fe\u0016\u000b7\r[\u0001\u0017CN\u001cXM\u001d;Qe>\u0004XM\u001d;jKNtu\u000e^*fi\u0006\u0011\u0012m]:feR\u001c6m\u001c9f\u0007>\u0014(/Z2u)\u0011y\u0012&M\u001a\t\u000b)*\u0001\u0019A\u0016\u0002\u0013\t\f7/Z*d_B,\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u000b\u0003\r\u0011H\rZ\u0005\u0003a5\u0012\u0011C\u0015#E\u001fB,'/\u0019;j_:\u001c6m\u001c9f\u0011\u0015\u0011T\u00011\u0001,\u0003!\u0011H\rZ*d_B,\u0007\"\u0002\u001b\u0006\u0001\u0004)\u0014!\u00032bi\u000eDG+[7f!\t\u0001c'\u0003\u00028C\t!Aj\u001c8h\u00035\t7o]3si\u0012+g-\u001b8fIV\u0011!(\u0012\u000b\u0003?mBQ\u0001\u0010\u0004A\u0002u\nqa\u001c9uS>t7\u000fE\u0002!}\u0001K!aP\u0011\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002!\u0003\u000eK!AQ\u0011\u0003\r=\u0003H/[8o!\t!U\t\u0004\u0001\u0005\u000b\u00193!\u0019A$\u0003\u0003Q\u000b\"\u0001S&\u0011\u0005\u0001J\u0015B\u0001&\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\t'\n\u00055\u000b#aA!os\u0002")
public class DStreamScopeSuite
extends SparkFunSuite
implements LocalStreamingContext {
    private transient StreamingContext ssc;
    private transient boolean stopSparkContext;

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        SparkConf conf = new SparkConf().setMaster("local").setAppName("test");
        conf.set("spark.streaming.clock", ManualClock.class.getName());
        Duration batchDuration = Seconds$.MODULE$.apply(1L);
        this.ssc_$eq(new StreamingContext(new SparkContext(conf), batchDuration));
        this.assertPropertiesNotSet();
    }

    @Override
    public void afterEach() {
        try {
            this.assertPropertiesNotSet();
        }
        finally {
            LocalStreamingContext.afterEach$(this);
        }
    }

    private void assertPropertiesNotSet() {
        StreamingContext $org_scalatest_assert_macro_left = this.ssc();
        Object $org_scalatest_assert_macro_right = null;
        StreamingContext streamingContext = $org_scalatest_assert_macro_left;
        Object var4_3 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var4_3 != null : !streamingContext.equals(var4_3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        String $org_scalatest_assert_macro_left2 = this.ssc().sc().getLocalProperty(SparkContext$.MODULE$.RDD_SCOPE_KEY());
        Object $org_scalatest_assert_macro_right2 = null;
        String string = $org_scalatest_assert_macro_left2;
        Object var8_7 = null;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string != null ? !string.equals(var8_7) : var8_7 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        String $org_scalatest_assert_macro_left3 = this.ssc().sc().getLocalProperty(SparkContext$.MODULE$.RDD_SCOPE_NO_OVERRIDE_KEY());
        Object $org_scalatest_assert_macro_right3 = null;
        String string2 = $org_scalatest_assert_macro_left3;
        Object var12_11 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, !(string2 != null ? !string2.equals(var12_11) : var12_11 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    private void assertScopeCorrect(RDDOperationScope baseScope, RDDOperationScope rddScope, long batchTime) {
        Tuple2 tuple2 = new Tuple2((Object)baseScope.id(), (Object)baseScope.name());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String baseScopeId = (String)tuple2._1();
        String baseScopeName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)baseScopeId, (Object)baseScopeName);
        Tuple2 tuple23 = tuple22;
        String baseScopeId2 = (String)tuple23._1();
        String baseScopeName2 = (String)tuple23._2();
        String formattedBatchTime = UIUtils$.MODULE$.formatBatchTime(batchTime, this.ssc().graph().batchDuration().milliseconds(), false, UIUtils$.MODULE$.formatBatchTime$default$4());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rddScope.id());
        String $org_scalatest_assert_macro_right = new StringBuilder(1).append(baseScopeId2).append("_").append(batchTime).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rddScope.name().replaceAll("\\n", " "));
        String $org_scalatest_assert_macro_right2 = new StringBuilder(3).append(baseScopeName2).append(" @ ").append(formattedBatchTime).toString();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        Option $org_scalatest_assert_macro_left3 = rddScope.parent();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
    }

    private <T> void assertDefined(Seq<Option<T>> options) {
        ((IterableLike)options.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option o = (Option)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(o.isDefined(), "o.isDefined", Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(18).append("Option ").append(i).append(" was empty!").toString(), Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            return assertion;
        });
    }

    private final void testStream$1(DStream stream2, DummyInputDStream inputStream$1, Option countScopeBase$1, Option countScope1$1, Option countScope2$1, Option countScope3$1) {
        block0: {
            DStream dStream = stream2;
            DummyInputDStream dummyInputDStream = inputStream$1;
            if (!(dStream == null ? dummyInputDStream != null : !dStream.equals((Object)dummyInputDStream))) break block0;
            Option myScopeBase = stream2.baseScope().map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson(s));
            Option myScope1 = ((RDD)stream2.getOrCompute(new Time(1000L)).get()).scope();
            Option myScope2 = ((RDD)stream2.getOrCompute(new Time(2000L)).get()).scope();
            Option myScope3 = ((RDD)stream2.getOrCompute(new Time(3000L)).get()).scope();
            this.assertDefined((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{myScopeBase, myScope1, myScope2, myScope3}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(myScopeBase);
            Option $org_scalatest_assert_macro_right = countScopeBase$1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(myScope1);
            Option $org_scalatest_assert_macro_right2 = countScope1$1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(myScope2);
            Option $org_scalatest_assert_macro_right3 = countScope2$1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(myScope3);
            Option $org_scalatest_assert_macro_right4 = countScope3$1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            stream2.dependencies().foreach((Function1 & Serializable & scala.Serializable)stream -> {
                this.testStream$1(stream, inputStream$1, countScopeBase$1, countScope1$1, countScope2$1, countScope3$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private final void assertNestedScopeCorrect$1(RDDOperationScope rddScope, long batchTime, Option transformScopeBase$1) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rddScope.name());
        String $org_scalatest_assert_macro_right = "reduceByKey";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(rddScope.parent().isDefined(), "rddScope.parent.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.assertScopeCorrect((RDDOperationScope)transformScopeBase$1.get(), (RDDOperationScope)rddScope.parent().get(), batchTime);
    }

    public static final /* synthetic */ void $anonfun$new$24(DStreamScopeSuite $this, Option foreachBaseScope$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option rddScope = (Option)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(((RDDOperationScope)rddScope.get()).name());
        String $org_scalatest_assert_macro_right = "reduceByKey";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((RDDOperationScope)rddScope.get()).parent().isDefined(), "rddScope.get.parent.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        $this.assertScopeCorrect((RDDOperationScope)foreachBaseScope$1.get(), (RDDOperationScope)((RDDOperationScope)rddScope.get()).parent().get(), (idx + 1) * 1000);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public DStreamScopeSuite() {
        LocalStreamingContext.$init$(this);
        this.test("dstream without scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DummyDStream dummyStream = new DummyDStream(this.ssc());
            dummyStream.initialize(new Time(0L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dummyStream.baseScope());
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((RDD)dummyStream.getOrCompute(new Time(1000L)).get()).scope());
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((RDD)dummyStream.getOrCompute(new Time(2000L)).get()).scope());
            None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((RDD)dummyStream.getOrCompute(new Time(3000L)).get()).scope());
            None$ $org_scalatest_assert_macro_right4 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("input dstream without scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyInputDStream inputStream = new DummyInputDStream(this.ssc());
            inputStream.initialize(new Time(0L));
            Option baseScope = inputStream.baseScope().map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson(s));
            Option scope1 = ((RDD)inputStream.getOrCompute(new Time(1000L)).get()).scope();
            Option scope2 = ((RDD)inputStream.getOrCompute(new Time(2000L)).get()).scope();
            Option scope3 = ((RDD)inputStream.getOrCompute(new Time(3000L)).get()).scope();
            this.assertDefined((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{baseScope, scope1, scope2, scope3}));
            String $org_scalatest_assert_macro_left = ((RDDOperationScope)baseScope.get()).name();
            String $org_scalatest_assert_macro_right = "dummy stream";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            this.assertScopeCorrect((RDDOperationScope)baseScope.get(), (RDDOperationScope)scope1.get(), 1000L);
            this.assertScopeCorrect((RDDOperationScope)baseScope.get(), (RDDOperationScope)scope2.get(), 2000L);
            this.assertScopeCorrect((RDDOperationScope)baseScope.get(), (RDDOperationScope)scope3.get(), 3000L);
        }, new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("scoping simple operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyInputDStream inputStream = new DummyInputDStream(this.ssc());
            DStream mappedStream = inputStream.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> i + 1, ClassTag$.MODULE$.Int());
            DStream filteredStream = mappedStream.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> i % 2 == 0);
            filteredStream.initialize(new Time(0L));
            Option mappedScopeBase = mappedStream.baseScope().map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson(s));
            Option mappedScope1 = ((RDD)mappedStream.getOrCompute(new Time(1000L)).get()).scope();
            Option mappedScope2 = ((RDD)mappedStream.getOrCompute(new Time(2000L)).get()).scope();
            Option mappedScope3 = ((RDD)mappedStream.getOrCompute(new Time(3000L)).get()).scope();
            Option filteredScopeBase = filteredStream.baseScope().map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson(s));
            Option filteredScope1 = ((RDD)filteredStream.getOrCompute(new Time(1000L)).get()).scope();
            Option filteredScope2 = ((RDD)filteredStream.getOrCompute(new Time(2000L)).get()).scope();
            Option filteredScope3 = ((RDD)filteredStream.getOrCompute(new Time(3000L)).get()).scope();
            this.assertDefined((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{mappedScopeBase, mappedScope1, mappedScope2, mappedScope3}));
            this.assertDefined((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{filteredScopeBase, filteredScope1, filteredScope2, filteredScope3}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((RDDOperationScope)mappedScopeBase.get()).name());
            String $org_scalatest_assert_macro_right = "map";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((RDDOperationScope)filteredScopeBase.get()).name());
            String $org_scalatest_assert_macro_right2 = "filter";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            this.assertScopeCorrect((RDDOperationScope)mappedScopeBase.get(), (RDDOperationScope)mappedScope1.get(), 1000L);
            this.assertScopeCorrect((RDDOperationScope)mappedScopeBase.get(), (RDDOperationScope)mappedScope2.get(), 2000L);
            this.assertScopeCorrect((RDDOperationScope)mappedScopeBase.get(), (RDDOperationScope)mappedScope3.get(), 3000L);
            this.assertScopeCorrect((RDDOperationScope)filteredScopeBase.get(), (RDDOperationScope)filteredScope1.get(), 1000L);
            this.assertScopeCorrect((RDDOperationScope)filteredScopeBase.get(), (RDDOperationScope)filteredScope2.get(), 2000L);
            this.assertScopeCorrect((RDDOperationScope)filteredScopeBase.get(), (RDDOperationScope)filteredScope3.get(), 3000L);
        }, new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("scoping nested operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyInputDStream inputStream = new DummyInputDStream(this.ssc());
            DStream countStream = inputStream.countByWindow(Seconds$.MODULE$.apply(10L), Seconds$.MODULE$.apply(1L));
            countStream.initialize(new Time(0L));
            Option countScopeBase = countStream.baseScope().map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson(s));
            Option countScope1 = ((RDD)countStream.getOrCompute(new Time(1000L)).get()).scope();
            Option countScope2 = ((RDD)countStream.getOrCompute(new Time(2000L)).get()).scope();
            Option countScope3 = ((RDD)countStream.getOrCompute(new Time(3000L)).get()).scope();
            this.assertDefined((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{countScopeBase, countScope1, countScope2, countScope3}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((RDDOperationScope)countScopeBase.get()).name());
            String $org_scalatest_assert_macro_right = "countByWindow";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            this.assertScopeCorrect((RDDOperationScope)countScopeBase.get(), (RDDOperationScope)countScope1.get(), 1000L);
            this.assertScopeCorrect((RDDOperationScope)countScopeBase.get(), (RDDOperationScope)countScope2.get(), 2000L);
            this.assertScopeCorrect((RDDOperationScope)countScopeBase.get(), (RDDOperationScope)countScope3.get(), 3000L);
            this.testStream$1(countStream, inputStream, countScopeBase, countScope1, countScope2, countScope3);
        }, new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("transform should allow RDD operations to be captured in scopes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyInputDStream inputStream = new DummyInputDStream(this.ssc());
            DStream transformedStream = inputStream.transform((Function1 & Serializable & scala.Serializable)x$1 -> RDD$.MODULE$.rddToPairRDDFunctions(x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 + x$4), ClassTag$.MODULE$.apply(Tuple2.class));
            transformedStream.initialize(new Time(0L));
            Option transformScopeBase = transformedStream.baseScope().map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson(s));
            Option transformScope1 = ((RDD)transformedStream.getOrCompute(new Time(1000L)).get()).scope();
            Option transformScope2 = ((RDD)transformedStream.getOrCompute(new Time(2000L)).get()).scope();
            Option transformScope3 = ((RDD)transformedStream.getOrCompute(new Time(3000L)).get()).scope();
            this.assertDefined((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{transformScopeBase, transformScope1, transformScope2, transformScope3}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((RDDOperationScope)transformScopeBase.get()).name());
            String $org_scalatest_assert_macro_right = "transform";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            this.assertNestedScopeCorrect$1((RDDOperationScope)transformScope1.get(), 1000L, transformScopeBase);
            this.assertNestedScopeCorrect$1((RDDOperationScope)transformScope2.get(), 2000L, transformScopeBase);
            this.assertNestedScopeCorrect$1((RDDOperationScope)transformScope3.get(), 3000L, transformScopeBase);
        }, new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("foreachRDD should allow RDD operations to be captured in scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyInputDStream inputStream = new DummyInputDStream(this.ssc());
            ArrayBuffer generatedRDDs = new ArrayBuffer();
            inputStream.foreachRDD((Function1 & Serializable & scala.Serializable)rdd -> {
                generatedRDDs.$plus$eq((Object)RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1 & Serializable & scala.Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$5))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$6, x$7) -> x$6 + x$7));
                return BoxedUnit.UNIT;
            });
            BatchCounter batchCounter = new BatchCounter(this.ssc());
            this.ssc().start();
            ManualClock clock = (ManualClock)this.ssc().scheduler().clock();
            clock.advance(3000L);
            batchCounter.waitUntilBatchesCompleted(3, 10000L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)generatedRDDs.size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            Option foreachBaseScope = ((DStream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getOutputStreams())).head()).baseScope().map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson(s));
            this.assertDefined((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{foreachBaseScope}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((RDDOperationScope)foreachBaseScope.get()).name());
            String $org_scalatest_assert_macro_right2 = "foreachRDD";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            Seq rddScopes = ((SeqLike)generatedRDDs.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.scope(), ArrayBuffer$.MODULE$.canBuildFrom())).toSeq();
            this.assertDefined(rddScopes);
            ((IterableLike)rddScopes.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DStreamScopeSuite.$anonfun$new$24(this, foreachBaseScope, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("DStreamScopeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
    }
}

