/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.FileGeneratingThread;
import org.apache.spark.streaming.KillingThread;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

public final class MasterFailureTest$
implements Logging {
    public static MasterFailureTest$ MODULE$;
    private volatile boolean killed;
    private volatile int killCount;
    private volatile boolean setupCalled;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MasterFailureTest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean killed() {
        return this.killed;
    }

    public void killed_$eq(boolean x$1) {
        this.killed = x$1;
    }

    public int killCount() {
        return this.killCount;
    }

    public void killCount_$eq(int x$1) {
        this.killCount = x$1;
    }

    public boolean setupCalled() {
        return this.setupCalled;
    }

    public void setupCalled_$eq(boolean x$1) {
        this.setupCalled = x$1;
    }

    public void main(String[] args) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() < 2) {
            Predef$.MODULE$.println((Object)"Usage: MasterFailureTest <local/HDFS directory> <# batches> [<batch size in milliseconds>]");
            System.exit(1);
        }
        String directory = args[0];
        int numBatches = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        Duration batchDuration = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).size() > 2 ? Milliseconds$.MODULE$.apply((long)new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt()) : Seconds$.MODULE$.apply(1L);
        Predef$.MODULE$.println((Object)"\n\n========================= MAP TEST =========================\n\n");
        this.testMap(directory, numBatches, batchDuration);
        Predef$.MODULE$.println((Object)"\n\n================= UPDATE-STATE-BY-KEY TEST =================\n\n");
        this.testUpdateStateByKey(directory, numBatches, batchDuration);
        Predef$.MODULE$.println((Object)"\n\nSUCCESS\n\n");
    }

    public void testMap(String directory, int numBatches, Duration batchDuration) {
        scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches).map((Function1 & Serializable & scala.Serializable)x$1 -> MasterFailureTest$.$anonfun$testMap$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
        Range.Inclusive expectedOutput = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches);
        Function1 & Serializable & scala.Serializable operation = (Function1 & Serializable & scala.Serializable)st -> st.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)MasterFailureTest$.$anonfun$testMap$3(x$2)), ClassTag$.MODULE$.Int());
        Seq output = this.testOperation(directory, batchDuration, (Seq<String>)input, (Function1)operation, (Seq)expectedOutput, (ClassTag)ClassTag$.MODULE$.Int());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Expected output, size = ").append(expectedOutput.size()).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> expectedOutput.mkString("[", ",", "]"));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Output, size = ").append(output.size()).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> output.mkString("[", ",", "]"));
        Set $org_scalatest_assert_macro_left = ((TraversableOnce)output.distinct()).toSet();
        Set $org_scalatest_assert_macro_right = expectedOutput.toSet();
        Set set = $org_scalatest_assert_macro_left;
        Set set2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public void testUpdateStateByKey(String directory, int numBatches, Duration batchDuration) {
        scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches).map((Function1 & Serializable & scala.Serializable)i -> MasterFailureTest$.$anonfun$testUpdateStateByKey$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
        IndexedSeq expectedOutput = (IndexedSeq)((TraversableLike)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)numBatches)).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)i)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)j -> MasterFailureTest$.$anonfun$testUpdateStateByKey$4(BoxesRunTime.unboxToLong((Object)j)), IndexedSeq$.MODULE$.canBuildFrom());
        Function1 & Serializable & scala.Serializable operation = (Function1 & Serializable & scala.Serializable)st -> {
            Function2 & Serializable & scala.Serializable updateFunc = (Function2 & Serializable & scala.Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)values.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$4, x$5) -> x$4 + x$5)) + BoxesRunTime.unboxToLong((Object)state.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return DStream$.MODULE$.toPairDStreamFunctions(st.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.split(" "))), ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToLong((long)1L)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.Long()).checkpoint(batchDuration.$times(5));
        };
        Seq output = this.testOperation(directory, batchDuration, (Seq<String>)input, (Function1)operation, (Seq)expectedOutput, (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Expected output, size = ").append(expectedOutput.size()).append("\n").append(expectedOutput).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Output, size = ").append(output.size()).append("\n").append(output).toString());
        output.foreach((Function1 & Serializable & scala.Serializable)o -> {
            IndexedSeq $org_scalatest_assert_macro_left = expectedOutput;
            Tuple2 $org_scalatest_assert_macro_right = o;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(25).append("Expected value ").append(o).append(" not found").toString(), Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        });
        Tuple2 $org_scalatest_assert_macro_left = (Tuple2)output.last();
        Tuple2 $org_scalatest_assert_macro_right = (Tuple2)expectedOutput.last();
        Tuple2 tuple2 = $org_scalatest_assert_macro_left;
        Tuple2 tuple22 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
    }

    public <T> Seq<T> testOperation(String directory, Duration batchDuration, Seq<String> input, Function1<DStream<String>, DStream<T>> operation, Seq<T> expectedOutput, ClassTag<T> evidence$1) {
        Set $org_scalatest_assert_macro_left = ((TraversableOnce)expectedOutput.distinct()).toSet();
        Set $org_scalatest_assert_macro_right = expectedOutput.toSet();
        Set set = $org_scalatest_assert_macro_left;
        Set set2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.reset();
        String uuid = UUID.randomUUID().toString();
        Path rootDir = new Path(directory, uuid);
        FileSystem fs = rootDir.getFileSystem(new Configuration());
        Path checkpointDir = new Path(rootDir, "checkpoint");
        Path testDir = new Path(rootDir, "test");
        fs.mkdirs(checkpointDir);
        fs.mkdirs(testDir);
        StreamingContext ssc = StreamingContext$.MODULE$.getOrCreate(checkpointDir.toString(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.setupStreams(batchDuration, operation, checkpointDir, testDir, evidence$1), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.setupCalled(), "MasterFailureTest.this.setupCalled", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Setup was not called in the first call to StreamingContext.getOrCreate", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        FileGeneratingThread fileGeneratingThread = new FileGeneratingThread(input, testDir, batchDuration.milliseconds());
        fileGeneratingThread.start();
        Object lastExpectedOutput = expectedOutput.last();
        long maxTimeToRun = (long)expectedOutput.size() * batchDuration.milliseconds() * 2L;
        Seq<Object> mergedOutput = this.runStreams(ssc, lastExpectedOutput, maxTimeToRun, evidence$1);
        fileGeneratingThread.join();
        ssc.stop(ssc.stop$default$1());
        fs.delete(checkpointDir, true);
        fs.delete(testDir, true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Finished test after ").append(MODULE$.killCount()).append(" failures").toString());
        return mergedOutput;
    }

    private <T> StreamingContext setupStreams(Duration batchDuration, Function1<DStream<String>, DStream<T>> operation, Path checkpointDir, Path testDir, ClassTag<T> evidence$2) {
        this.setupCalled_$eq(true);
        StreamingContext ssc = new StreamingContext("local[4]", "MasterFailureTest", batchDuration, null, (Seq)Nil$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        ssc.checkpoint(checkpointDir.toString());
        DStream inputStream = ssc.textFileStream(testDir.toString());
        DStream operatedStream = (DStream)operation.apply((Object)inputStream);
        TestOutputStream outputStream = new TestOutputStream(operatedStream, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), evidence$2);
        outputStream.register();
        return ssc;
    }

    private <T> Seq<T> runStreams(StreamingContext _ssc, T lastExpectedOutput, long maxTimeToRun, ClassTag<T> evidence$3) {
        StreamingContext ssc = _ssc;
        LongRef totalTimeRan = LongRef.create((long)0L);
        BooleanRef isLastOutputGenerated = BooleanRef.create((boolean)false);
        BooleanRef isTimedOut = BooleanRef.create((boolean)false);
        ArrayBuffer mergedOutput = new ArrayBuffer();
        String checkpointDir = ssc.checkpointDir();
        Duration batchDuration = ssc.graph().batchDuration();
        while (!isLastOutputGenerated.elem && !isTimedOut.elem) {
            ConcurrentLinkedQueue outputQueue = ((TestOutputStream)((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams())).head())).output();
            this.killed_$eq(false);
            KillingThread killingThread = new KillingThread(ssc, batchDuration.milliseconds() * 10L);
            killingThread.start();
            LongRef timeRan = LongRef.create((long)0L);
            try {
                try {
                    System.clearProperty("spark.streaming.clock");
                    System.clearProperty("spark.driver.port");
                    ssc.start();
                    long startTimeNs = System.nanoTime();
                    while (!(this.killed() || isLastOutputGenerated.elem || isTimedOut.elem)) {
                        Thread.sleep(100L);
                        timeRan.elem = System.nanoTime() - startTimeNs;
                        isLastOutputGenerated.elem = MasterFailureTest$.output$3(outputQueue).nonEmpty() && BoxesRunTime.equals((Object)MasterFailureTest$.output$3(outputQueue).last(), lastExpectedOutput);
                        isTimedOut.elem = timeRan.elem + totalTimeRan.elem > TimeUnit.MILLISECONDS.toNanos(maxTimeToRun);
                    }
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error running streaming context", e);
                }
            }
            finally {
                StreamingContext qual$1 = ssc;
                boolean x$1 = qual$1.stop$default$1();
                qual$1.stop(x$1);
            }
            if (killingThread.isAlive()) {
                killingThread.interrupt();
                killingThread.join();
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Has been killed = ").append(MODULE$.killed()).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Is last output generated = ").append(isLastOutputGenerated$1.elem).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Is timed out = ").append(isTimedOut$1.elem).toString());
            mergedOutput.$plus$plus$eq((TraversableOnce)MasterFailureTest$.output$3(outputQueue).toSeq());
            totalTimeRan.elem += timeRan.elem;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("New output = ").append(MasterFailureTest$.output$3(outputQueue).toSeq()).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Merged output = ").append(mergedOutput).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Time ran = ").append(timeRan$1.elem).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Total time ran = ").append(TimeUnit.NANOSECONDS.toMillis(totalTimeRan$1.elem)).toString());
            if (isLastOutputGenerated.elem || isTimedOut.elem) continue;
            int sleepTime = Random$.MODULE$.nextInt((int)batchDuration.milliseconds() * 10);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(132).append("\n-------------------------------------------\n   Restarting stream computation in ").append(sleepTime).append(" ms   ").append("\n-------------------------------------------\n").toString());
            Thread.sleep(sleepTime);
            ssc = StreamingContext$.MODULE$.getOrCreate(checkpointDir, (Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception("Trying to create new context when it should be reading from checkpoint file");
            }, StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4());
        }
        return mergedOutput.toSeq();
    }

    private <T> void verifyOutput(Seq<T> output, Seq<T> expectedOutput, ClassTag<T> evidence$4) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expectedOutput.size() - 1).foreach((Function1 & Serializable & scala.Serializable)i -> MasterFailureTest$.$anonfun$verifyOutput$1(expectedOutput, BoxesRunTime.unboxToInt((Object)i)));
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Expected output, size = ").append(expectedOutput.size()).toString());
        Predef$.MODULE$.println((Object)expectedOutput.mkString("[", ",", "]"));
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Output, size = ").append(output.size()).toString());
        Predef$.MODULE$.println((Object)output.mkString("[", ",", "]"));
        output.foreach((Function1 & Serializable & scala.Serializable)o -> {
            Seq $org_scalatest_assert_macro_left = expectedOutput;
            Object $org_scalatest_assert_macro_right = o;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(25).append("Expected value ").append(o).append(" not found").toString(), Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        });
    }

    private void reset() {
        this.killed_$eq(false);
        this.killCount_$eq(0);
        this.setupCalled_$eq(false);
    }

    public static final /* synthetic */ String $anonfun$testMap$1(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    public static final /* synthetic */ int $anonfun$testMap$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ String $anonfun$testUpdateStateByKey$2(int x$3) {
        return "a";
    }

    public static final /* synthetic */ String $anonfun$testUpdateStateByKey$1(int i) {
        return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), i).map((Function1 & Serializable & scala.Serializable)x$3 -> MasterFailureTest$.$anonfun$testUpdateStateByKey$2(BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
    }

    public static final /* synthetic */ Tuple2 $anonfun$testUpdateStateByKey$4(long j) {
        return new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)j));
    }

    private static final Iterable output$3(ConcurrentLinkedQueue outputQueue$1) {
        return (Iterable)((GenericTraversableTemplate)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)outputQueue$1).asScala()).flatten((Function1)Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Assertion $anonfun$verifyOutput$1(Seq expectedOutput$3, int i) {
        Object $org_scalatest_assert_macro_right;
        Object $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "!=", $org_scalatest_assert_macro_right, !BoxesRunTime.equals((Object)($org_scalatest_assert_macro_left = expectedOutput$3.apply(i)), (Object)($org_scalatest_assert_macro_right = expectedOutput$3.apply(i + 1))), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Expected output has consecutive duplicate sequence of values", Prettifier$.MODULE$.default(), new Position("MasterFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
    }

    private MasterFailureTest$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.killed = false;
        this.killCount = 0;
        this.setupCalled = false;
    }
}

