/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.ThreadSignaler$;
import org.scalatest.concurrent.TimeLimits;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Sequencing$;
import org.scalatest.enablers.Timed;
import org.scalatest.enablers.Timed$;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.matchers.TypeMatcherHelper$;
import org.scalatest.matchers.dsl.ResultOfNotWordForAny;
import org.scalatest.matchers.should.Matchers$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001\u0002\u0013&\u0001ABQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\ra\t\u0003\u0004K\u0001\u0001\u0006Ia\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0013)\u0006BB-\u0001A\u0003%a\u000bC\u0004[\u0001\u0001\u0007I\u0011B.\t\u000f}\u0003\u0001\u0019!C\u0005A\"1a\r\u0001Q!\nqCQa\u001b\u0001\u0005\n14AA\u001e\u0001\u0005o\")\u0011\t\u0004C\u0001}\"I\u00111\u0001\u0007C\u0002\u0013\u0005\u0011Q\u0001\u0005\t\u00037a\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0004\u0007C\u0002\u0013\u0005\u0011Q\u0001\u0005\t\u0003?a\u0001\u0015!\u0003\u0002\b!I\u0011\u0011\u0005\u0007C\u0002\u0013\u0005\u0011Q\u0001\u0005\t\u0003Ga\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0005\u0007A\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003_a\u0001\u0019!C\u0001\u0003cA\u0001\"!\u000e\rA\u0003&\u0011\u0011\u0006\u0005\n\u0003sa\u0001\u0019!C\u0001\u0003OA\u0011\"a\u000f\r\u0001\u0004%\t!!\u0010\t\u0011\u0005\u0005C\u0002)Q\u0005\u0003SA\u0011\"!\u0012\r\u0001\u0004%\t!a\n\t\u0013\u0005\u001dC\u00021A\u0005\u0002\u0005%\u0003\u0002CA'\u0019\u0001\u0006K!!\u000b\t\u0013\u0005EC\u00021A\u0005\u0002\u0005\u001d\u0002\"CA*\u0019\u0001\u0007I\u0011AA+\u0011!\tI\u0006\u0004Q!\n\u0005%\u0002bBA/\u0019\u0011\u0005\u0013q\f\u0005\b\u0003/cA\u0011IAM\u0011\u001d\tY\r\u0004C!\u0003\u001bDq!!5\r\t\u0003\n\u0019NA\nCY>\u001c7nR3oKJ\fGo\u001c:Tk&$XM\u0003\u0002'O\u0005A!/Z2fSZ,'O\u0003\u0002)S\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003U-\nQa\u001d9be.T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u00011\u0003\u0002\u00012km\u0002\"AM\u001a\u000e\u0003%J!\u0001N\u0015\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t1\u0014(D\u00018\u0015\tAT&A\u0005tG\u0006d\u0017\r^3ti&\u0011!h\u000e\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s!\tat(D\u0001>\u0015\tqt'\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001Q\u001f\u0003\u0015QKW.\u001a'j[&$8/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0007B\u0011A\tA\u0007\u0002K\u0005yA-\u001a4bk2$8+[4oC2,'/F\u0001H!\ta\u0004*\u0003\u0002J{\tA1+[4oC2,'/\u0001\teK\u001a\fW\u000f\u001c;TS\u001et\u0017\r\\3sA\u0005y!\r\\8dW&sG/\u001a:wC2l5/F\u0001N!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\rIe\u000e^\u0001\u0011E2|7m[%oi\u0016\u0014h/\u00197Ng\u0002\nAaY8oMV\ta\u000b\u0005\u00023/&\u0011\u0001,\u000b\u0002\n'B\f'o[\"p]\u001a\fQaY8oM\u0002\naB\u00197pG.<UM\\3sCR|'/F\u0001]!\t!U,\u0003\u0002_K\tq!\t\\8dW\u001e+g.\u001a:bi>\u0014\u0018A\u00052m_\u000e\\w)\u001a8fe\u0006$xN]0%KF$\"!\u00193\u0011\u00059\u0013\u0017BA2P\u0005\u0011)f.\u001b;\t\u000f\u0015L\u0011\u0011!a\u00019\u0006\u0019\u0001\u0010J\u0019\u0002\u001f\tdwnY6HK:,'/\u0019;pe\u0002B#A\u00035\u0011\u00059K\u0017B\u00016P\u0005!1x\u000e\\1uS2,\u0017AE:u_B\u0014En\\2l\u000f\u0016tWM]1u_J$\"!\\;\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00027b]\u001eT\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n1A\u000b\u001b:fC\u0012DQAW\u0006A\u0002q\u0013!\u0004V3ti\ncwnY6HK:,'/\u0019;pe2K7\u000f^3oKJ\u001c2\u0001\u0004=|!\tq\u00150\u0003\u0002{\u001f\n1\u0011I\\=SK\u001a\u0004\"\u0001\u0012?\n\u0005u,#A\u0006\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d'jgR,g.\u001a:\u0015\u0003}\u00042!!\u0001\r\u001b\u0005\u0001\u0011A\u00039vg\",G\rR1uCV\u0011\u0011q\u0001\t\u0007\u0003\u0013\t\t\"!\u0006\u000e\u0005\u0005-!b\u0001 \u0002\u000e)\u0019\u0011qB9\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003'\tYAA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u00079\u000b9\"C\u0002\u0002\u001a=\u00131!\u00118z\u0003-\u0001Xo\u001d5fI\u0012\u000bG/\u0019\u0011\u0002\u0013\u0005$G-\u001a3ECR\f\u0017AC1eI\u0016$G)\u0019;bA\u0005i\u0011\r\u001a3fI6+G/\u00193bi\u0006\fa\"\u00193eK\u0012lU\r^1eCR\f\u0007%A\u000bp]\u001e+g.\u001a:bi\u0016\u0014En\\2l\u0007\u0006dG.\u001a3\u0016\u0005\u0005%\u0002c\u0001(\u0002,%\u0019\u0011QF(\u0003\u000f\t{w\u000e\\3b]\u0006IrN\\$f]\u0016\u0014\u0018\r^3CY>\u001c7nQ1mY\u0016$w\fJ3r)\r\t\u00171\u0007\u0005\tKV\t\t\u00111\u0001\u0002*\u00051rN\\$f]\u0016\u0014\u0018\r^3CY>\u001c7nQ1mY\u0016$\u0007\u0005\u000b\u0002\u0017Q\u0006yqN\\!eI\u0012\u000bG/Y\"bY2,G-A\np]\u0006#G\rR1uC\u000e\u000bG\u000e\\3e?\u0012*\u0017\u000fF\u0002b\u0003\u007fA\u0001\"\u001a\r\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0011_:\fE\r\u001a#bi\u0006\u001c\u0015\r\u001c7fI\u0002B#!\u00075\u0002#=t\u0007+^:i\u00052|7m[\"bY2,G-A\u000bp]B+8\u000f\u001b\"m_\u000e\\7)\u00197mK\u0012|F%Z9\u0015\u0007\u0005\fY\u0005\u0003\u0005f7\u0005\u0005\t\u0019AA\u0015\u0003Iyg\u000eU;tQ\ncwnY6DC2dW\r\u001a\u0011)\u0005qA\u0017!D8o\u000bJ\u0014xN]\"bY2,G-A\tp]\u0016\u0013(o\u001c:DC2dW\rZ0%KF$2!YA,\u0011!)g$!AA\u0002\u0005%\u0012AD8o\u000bJ\u0014xN]\"bY2,G\r\t\u0015\u0003?!\f1b\u001c8QkND'\t\\8dWR)\u0011-!\u0019\u0002r!9\u00111\r\u0011A\u0002\u0005\u0015\u0014a\u00022m_\u000e\\\u0017\n\u001a\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N\u0015\u0002\u000fM$xN]1hK&!\u0011qNA5\u00055\u0019FO]3b[\ncwnY6JI\"9\u00111\u000f\u0011A\u0002\u0005U\u0014aC1se\u0006L()\u001e4gKJ\u0004D!a\u001e\u0002\fB1\u0011\u0011PAB\u0003\u000fk!!a\u001f\u000b\t\u0005u\u0014qP\u0001\b[V$\u0018M\u00197f\u0015\r\t\tiT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAC\u0003w\u00121\"\u0011:sCf\u0014UO\u001a4feB!\u0011\u0011RAF\u0019\u0001!A\"!$\u0002r\u0005\u0005\t\u0011!B\u0001\u0003\u001f\u00131a\u0018\u00133#\u0011\t\t*!\u0006\u0011\u00079\u000b\u0019*C\u0002\u0002\u0016>\u0013qAT8uQ&tw-A\u0004p]\u0016\u0013(o\u001c:\u0015\u000b\u0005\fY*!.\t\u000f\u0005u\u0015\u00051\u0001\u0002 \u00069Q.Z:tC\u001e,\u0007\u0003BAQ\u0003_sA!a)\u0002,B\u0019\u0011QU(\u000e\u0005\u0005\u001d&bAAU_\u00051AH]8pizJ1!!,P\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011WAZ\u0005\u0019\u0019FO]5oO*\u0019\u0011QV(\t\u000f\u0005]\u0016\u00051\u0001\u0002:\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0003w\u000b)M\u0004\u0003\u0002>\u0006\u0005g\u0002BAS\u0003\u007fK\u0011\u0001U\u0005\u0004\u0003\u0007|\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\fIMA\u0005UQJ|w/\u00192mK*\u0019\u00111Y(\u0002\u001f=tw)\u001a8fe\u0006$XM\u00117pG.$2!YAh\u0011\u001d\t\u0019G\ta\u0001\u0003K\n\u0011b\u001c8BI\u0012$\u0015\r^1\u0015\u000b\u0005\f).!7\t\u000f\u0005]7\u00051\u0001\u0002\u0016\u0005!A-\u0019;b\u0011\u001d\tYn\ta\u0001\u0003+\t\u0001\"\\3uC\u0012\fG/\u0019")
public class BlockGeneratorSuite
extends SparkFunSuite
implements BeforeAndAfter,
TimeLimits {
    private final Signaler defaultSignaler;
    private final int blockIntervalMs;
    private final SparkConf conf;
    private volatile BlockGenerator blockGenerator;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public <T> T failAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.failAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> Prettifier failAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position failAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> failAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> T failAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.failAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> T cancelAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.cancelAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> Prettifier cancelAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position cancelAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> cancelAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> T cancelAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.cancelAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public Signaler defaultSignaler() {
        return this.defaultSignaler;
    }

    private int blockIntervalMs() {
        return this.blockIntervalMs;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private Thread stopBlockGenerator(BlockGenerator blockGenerator) {
        void var2_2;
        Thread thread = new Thread(null, blockGenerator){
            private final BlockGenerator blockGenerator$1;

            public void run() {
                this.blockGenerator$1.stop();
            }
            {
                this.blockGenerator$1 = blockGenerator$1;
            }
        };
        thread.start();
        return var2_2;
    }

    public static final /* synthetic */ String $anonfun$new$8(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    public static final /* synthetic */ void $anonfun$new$9(BlockGeneratorSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int d = tuple2._1$mcI$sp();
        String m = (String)tuple2._2();
        $this.blockGenerator().addDataWithCallback((Object)BoxesRunTime.boxToInteger((int)d), (Object)m);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BlockGeneratorSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        TimeLimits.$init$((TimeLimits)this);
        this.defaultSignaler = ThreadSignaler$.MODULE$;
        this.blockIntervalMs = 10;
        this.conf = new SparkConf().set("spark.streaming.blockInterval", new StringBuilder(2).append(this.blockIntervalMs()).append("ms").toString());
        this.blockGenerator = null;
        this.after((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.blockGenerator() != null) {
                this.blockGenerator().stop();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("block generation and data callbacks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestBlockGeneratorListener listener = new TestBlockGeneratorListener();
            ManualClock clock = new ManualClock();
            Predef$.MODULE$.require(this.blockIntervalMs() > 5);
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onAddDataCalled())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onGenerateBlockCalled())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onPushBlockCalled())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
            this.blockGenerator_$eq(new BlockGenerator((BlockGeneratorListener)listener, 0, this.conf(), (Clock)clock));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.blockGenerator().isActive()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"block generator active before start()", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.blockGenerator().isStopped()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"block generator stopped before start()", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onAddDataCalled()));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onGenerateBlockCalled()));
            boolean $org_scalatest_assert_macro_right4 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onPushBlockCalled()));
            boolean $org_scalatest_assert_macro_right5 = false;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            this.blockGenerator().start();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.blockGenerator().isActive(), "BlockGeneratorSuite.this.blockGenerator.isActive()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"block generator active after start()", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.blockGenerator().isStopped()));
            boolean $org_scalatest_assert_macro_right6 = false;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"block generator stopped after start()", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            this.withClue("callbacks called before adding data", (Function0 & Serializable & scala.Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onAddDataCalled()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onGenerateBlockCalled()));
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onPushBlockCalled()));
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            });
            Range.Inclusive data1 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
            BlockGenerator blockGenerator = this.blockGenerator();
            data1.foreach$mVc$sp((Function1 & Serializable & scala.Serializable)data -> {
                blockGenerator.addData(data);
                return BoxedUnit.UNIT;
            });
            this.withClue("callbacks called on adding data without metadata and without block generation", (Function0 & Serializable & scala.Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onAddDataCalled()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onGenerateBlockCalled()));
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onPushBlockCalled()));
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            });
            clock.advance((long)this.blockIntervalMs());
            this.withClue("blocks not generated or pushed", (Function0 & Serializable & scala.Serializable)() -> (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second()), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(listener.onGenerateBlockCalled(), "listener.onGenerateBlockCalled", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(listener.onPushBlockCalled(), "listener.onPushBlockCalled", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87)));
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(listener.pushedData()).asScala()).toSeq(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.contain()).theSameElementsInOrderAs((GenTraversable)data1, Sequencing$.MODULE$.sequencingNatureOfGenSeq(Equality$.MODULE$.default()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onAddDataCalled()));
            boolean $org_scalatest_assert_macro_right7 = false;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Range.Inclusive data2 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 20);
            IndexedSeq metadata2 = (IndexedSeq)data2.map((Function1 & Serializable & scala.Serializable)x$1 -> BlockGeneratorSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
            ((IterableLike)data2.zip((GenIterable)metadata2, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BlockGeneratorSuite.$anonfun$new$9(this, x0$1);
                return BoxedUnit.UNIT;
            });
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(listener.onAddDataCalled(), "listener.onAddDataCalled", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(listener.addedData()).asScala()).toSeq(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.contain()).theSameElementsInOrderAs((GenTraversable)data2, Sequencing$.MODULE$.sequencingNatureOfGenSeq(Equality$.MODULE$.default()));
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(listener.addedMetadata()).asScala()).toSeq(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.contain()).theSameElementsInOrderAs((GenTraversable)metadata2, Sequencing$.MODULE$.sequencingNatureOfGenSeq(Equality$.MODULE$.default()));
            clock.advance((long)this.blockIntervalMs());
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second()), (Function0 & Serializable & scala.Serializable)() -> {
                IndexedSeq combined = (IndexedSeq)data1.$plus$plus((GenTraversableOnce)data2, IndexedSeq$.MODULE$.canBuildFrom());
                return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(listener.pushedData()).asScala()).toSeq(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.contain()).theSameElementsInOrderAs((GenTraversable)combined, Sequencing$.MODULE$.sequencingNatureOfGenSeq(Equality$.MODULE$.default()));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Range.Inclusive data3 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(21), 30);
            String metadata3 = "metadata";
            this.blockGenerator().addMultipleDataWithCallback(data3.iterator(), (Object)metadata3);
            IndexedSeq combinedMetadata = (IndexedSeq)metadata2.$colon$plus((Object)metadata3, IndexedSeq$.MODULE$.canBuildFrom());
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(listener.addedMetadata()).asScala()).toSeq(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.contain()).theSameElementsInOrderAs((GenTraversable)combinedMetadata, Sequencing$.MODULE$.sequencingNatureOfGenSeq(Equality$.MODULE$.default()));
            clock.advance((long)this.blockIntervalMs());
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second()), (Function0 & Serializable & scala.Serializable)() -> {
                IndexedSeq combinedData = (IndexedSeq)((TraversableLike)data1.$plus$plus((GenTraversableOnce)data2, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)data3, IndexedSeq$.MODULE$.canBuildFrom());
                return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(listener.pushedData()).asScala()).toSeq(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.contain()).theSameElementsInOrderAs((GenTraversable)combinedData, Sequencing$.MODULE$.sequencingNatureOfGenSeq(Equality$.MODULE$.default()));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Thread thread = this.stopBlockGenerator(this.blockGenerator());
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                clock.advance((long)this.blockIntervalMs());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.blockGenerator().isStopped(), "BlockGeneratorSuite.this.blockGenerator.isStopped()", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            thread.join();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.blockGenerator().addData((Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.blockGenerator().addDataWithCallback((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.blockGenerator().addMultipleDataWithCallback(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.blockGenerator().start(), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            this.blockGenerator().stop();
        }, new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("stop ensures correct shutdown", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestBlockGeneratorListener listener = new TestBlockGeneratorListener();
            ManualClock clock = new ManualClock();
            this.blockGenerator_$eq(new BlockGenerator((BlockGeneratorListener)listener, 0, this.conf(), (Clock)clock));
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onGenerateBlockCalled())).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
            this.blockGenerator().start();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.blockGenerator().isActive(), "BlockGeneratorSuite.this.blockGenerator.isActive()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"block generator", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.blockGenerator().isStopped()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Range.Inclusive data2 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000);
            BlockGenerator blockGenerator = this.blockGenerator();
            data2.foreach$mVc$sp((Function1 & Serializable & scala.Serializable)data -> {
                blockGenerator.addData(data);
                return BoxedUnit.UNIT;
            });
            clock.advance(1L);
            Thread thread = this.stopBlockGenerator(this.blockGenerator());
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.blockGenerator().isActive()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.blockGenerator().isStopped()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.blockGenerator().addData((Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.blockGenerator().addDataWithCallback((Object)BoxesRunTime.boxToInteger((int)1), null), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.blockGenerator().addMultipleDataWithCallback(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), null), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Exception exception = (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Nothing$)this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(200).milliseconds(), (Function0 & Serializable & scala.Serializable)() -> {
                thread.join();
                throw new SparkException("BlockGenerator.stop() completed before generating timer was stopped");
            }, this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184), Timed$.MODULE$.timed()), ClassTag$.MODULE$.apply(Exception.class), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            ResultOfNotWordForAny $org_scalatest_type_matcher_macro_left = Matchers$.MODULE$.convertToAnyShouldWrapper((Object)exception, new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.not());
            TypeMatcherHelper$.MODULE$.assertATypeShouldBeTrue(Matchers$.MODULE$.convertToAnyShouldWrapper((Object)exception, new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.not()).left(), Matchers$.MODULE$.a(ClassTag$.MODULE$.apply(SparkException.class)), Matchers$.MODULE$.convertToAnyShouldWrapper((Object)exception, new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.not()).shouldBeTrue(), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.blockGenerator().isStopped()));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                clock.advance((long)this.blockIntervalMs());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)thread.isAlive()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.blockGenerator().isStopped(), "BlockGeneratorSuite.this.blockGenerator.isStopped()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(listener.pushedData()).asScala()).toSeq());
            Range.Inclusive $org_scalatest_assert_macro_right4 = data2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"All data not pushed by stop()", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        }, new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("block push errors are reported", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestBlockGeneratorListener listener = new TestBlockGeneratorListener(this){

                public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
                    throw new SparkException("test");
                }
            };
            this.blockGenerator_$eq(new BlockGenerator((BlockGeneratorListener)listener, 0, this.conf(), BlockGenerator$.MODULE$.$lessinit$greater$default$4()));
            this.blockGenerator().start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)listener.onErrorCalled()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            this.blockGenerator().addData((Object)BoxesRunTime.boxToInteger((int)1));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(listener.onErrorCalled(), "listener.onErrorCalled", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            this.blockGenerator().stop();
        }, new Position("BlockGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
    }

    public class TestBlockGeneratorListener
    implements BlockGeneratorListener {
        private final ConcurrentLinkedQueue<Object> pushedData;
        private final ConcurrentLinkedQueue<Object> addedData;
        private final ConcurrentLinkedQueue<Object> addedMetadata;
        private volatile boolean onGenerateBlockCalled;
        private volatile boolean onAddDataCalled;
        private volatile boolean onPushBlockCalled;
        private volatile boolean onErrorCalled;

        public ConcurrentLinkedQueue<Object> pushedData() {
            return this.pushedData;
        }

        public ConcurrentLinkedQueue<Object> addedData() {
            return this.addedData;
        }

        public ConcurrentLinkedQueue<Object> addedMetadata() {
            return this.addedMetadata;
        }

        public boolean onGenerateBlockCalled() {
            return this.onGenerateBlockCalled;
        }

        public void onGenerateBlockCalled_$eq(boolean x$1) {
            this.onGenerateBlockCalled = x$1;
        }

        public boolean onAddDataCalled() {
            return this.onAddDataCalled;
        }

        public void onAddDataCalled_$eq(boolean x$1) {
            this.onAddDataCalled = x$1;
        }

        public boolean onPushBlockCalled() {
            return this.onPushBlockCalled;
        }

        public void onPushBlockCalled_$eq(boolean x$1) {
            this.onPushBlockCalled = x$1;
        }

        public boolean onErrorCalled() {
            return this.onErrorCalled;
        }

        public void onErrorCalled_$eq(boolean x$1) {
            this.onErrorCalled = x$1;
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.pushedData().addAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(arrayBuffer).asJava());
            this.onPushBlockCalled_$eq(true);
        }

        public void onError(String message, Throwable throwable) {
            this.onErrorCalled_$eq(true);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.onGenerateBlockCalled_$eq(true);
        }

        public void onAddData(Object data, Object metadata) {
            this.addedData().add(data);
            this.addedMetadata().add(metadata);
            this.onAddDataCalled_$eq(true);
        }

        public /* synthetic */ BlockGeneratorSuite org$apache$spark$streaming$receiver$BlockGeneratorSuite$TestBlockGeneratorListener$$$outer() {
            return BlockGeneratorSuite.this;
        }

        public TestBlockGeneratorListener() {
            if (BlockGeneratorSuite.this == null) {
                throw null;
            }
            this.pushedData = new ConcurrentLinkedQueue();
            this.addedData = new ConcurrentLinkedQueue();
            this.addedMetadata = new ConcurrentLinkedQueue();
            this.onGenerateBlockCalled = false;
            this.onAddDataCalled = false;
            this.onPushBlockCalled = false;
            this.onErrorCalled = false;
        }
    }
}

