/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.Streaming$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.streaming.DummyInputDStream;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.StreamManualClock;
import org.apache.spark.streaming.scheduler.StreamManualClock$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.SpanSugar$;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001\u0002\u000f\u001e\u0001!BQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004L\u0001\u0001\u0006I!\u0012\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0011\u001d\t\u0006\u00011A\u0005\nICa\u0001\u0017\u0001!B\u0013q\u0005bB-\u0001\u0001\u0004%IA\u0017\u0005\b=\u0002\u0001\r\u0011\"\u0003`\u0011\u0019\t\u0007\u0001)Q\u00057\")!\r\u0001C!G\")A\r\u0001C\u0001K\")1\u000e\u0001C\u0005Y\"I\u0011q\u0001\u0001\u0012\u0002\u0013%\u0011\u0011\u0002\u0005\n\u0003?\u0001\u0011\u0013!C\u0005\u0003CA\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005E\u0002\u0001)A\u0005\u0003SA\u0011\"a\r\u0001\u0005\u0004%I!a\n\t\u0011\u0005U\u0002\u0001)A\u0005\u0003SA\u0011\"a\u000e\u0001\u0005\u0004%I!a\n\t\u0011\u0005e\u0002\u0001)A\u0005\u0003SA\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003\u007fAq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0002\u001f\u000bb,7-\u001e;pe\u0006cGn\\2bi&|g.T1oC\u001e,'oU;ji\u0016T!AH\u0010\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0011\"\u0003%\u0019HO]3b[&twM\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0015.ce\u0002\"AK\u0016\u000e\u0003\u0005J!\u0001L\u0011\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tqs&D\u0001 \u0013\t\u0001tDA\u0007UKN$8+^5uK\n\u000b7/\u001a\t\u0003e]j\u0011a\r\u0006\u0003iU\nq!\\8dW&$xN\u0003\u00027K\u0005i1oY1mCR,7\u000f\u001e9mkNL!\u0001O\u001a\u0003\u00195{7m[5u_N+x-\u0019:\u0011\u0005ijT\"A\u001e\u000b\u0005q*\u0013!C:dC2\fG/Z:u\u0013\tq4HA\nQe&4\u0018\r^3NKRDw\u000e\u001a+fgR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003B\u0011!\tA\u0007\u0002;\u0005\u0019\"-\u0019;dQ\u0012+(/\u0019;j_:l\u0015\u000e\u001c7jgV\tQ\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0003M_:<\u0017\u0001\u00062bi\u000eDG)\u001e:bi&|g.T5mY&\u001c\b%\u0001\tbY2|7-\u0019;j_:\u001cE.[3oiV\ta\n\u0005\u0002+\u001f&\u0011\u0001+\t\u0002\u0019\u000bb,7-\u001e;pe\u0006cGn\\2bi&|gn\u00117jK:$\u0018\u0001F1mY>\u001c\u0017\r^5p]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002T-B\u0011a\tV\u0005\u0003+\u001e\u0013A!\u00168ji\"9q+BA\u0001\u0002\u0004q\u0015a\u0001=%c\u0005\t\u0012\r\u001c7pG\u0006$\u0018n\u001c8DY&,g\u000e\u001e\u0011\u0002\u000b\rdwnY6\u0016\u0003m\u0003\"A\u0011/\n\u0005uk\"!E*ue\u0016\fW.T1ok\u0006d7\t\\8dW\u0006I1\r\\8dW~#S-\u001d\u000b\u0003'\u0002Dqa\u0016\u0005\u0002\u0002\u0003\u00071,\u0001\u0004dY>\u001c7\u000eI\u0001\u000bE\u00164wN]3FC\u000eDG#A*\u0002\u0013\t\f7/[2UKN$HCA*g\u0011\u001597\u00021\u0001i\u0003=!WmY8n[&\u001c8/[8oS:<\u0007C\u0001$j\u0013\tQwIA\u0004C_>dW-\u00198\u0002+]LG\u000f[!mY>\u001c\u0017\r^5p]6\u000bg.Y4feR\u0019Q.\u001f@\u0015\u0005Ms\u0007\"B8\r\u0001\u0004\u0001\u0018\u0001\u00022pIf\u0004RAR9tmNK!A]$\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\"u\u0013\t)XDA\bSK\u000e,\u0017N^3s)J\f7m[3s!\t\u0011u/\u0003\u0002y;\tIR\t_3dkR|'/\u00117m_\u000e\fG/[8o\u001b\u0006t\u0017mZ3s\u0011\u001dQH\u0002%AA\u0002m\fAaY8oMB\u0011!\u0006`\u0005\u0003{\u0006\u0012\u0011b\u00159be.\u001cuN\u001c4\t\u0011}d\u0001\u0013!a\u0001\u0003\u0003\tAB\\;n%\u0016\u001cW-\u001b<feN\u00042ARA\u0002\u0013\r\t)a\u0012\u0002\u0004\u0013:$\u0018aH<ji\"\fE\u000e\\8dCRLwN\\'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0002\u0016\u0004w\u000651FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eq)\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002?]LG\u000f[!mY>\u001c\u0017\r^5p]6\u000bg.Y4fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002$)\"\u0011\u0011AA\u0007\u0003Ey\u0016\r\u001a3CCR\u001c\u0007\u000e\u0015:pGRKW.Z\u000b\u0003\u0003S\u0001R!a\u000b\u0002.Mk\u0011\u0001A\u0005\u0004\u0003_i$!\u0004)sSZ\fG/Z'fi\"|G-\u0001\n`C\u0012$')\u0019;dQB\u0013xn\u0019+j[\u0016\u0004\u0013!E0sKF,Xm\u001d;Fq\u0016\u001cW\u000f^8sg\u0006\u0011rL]3rk\u0016\u001cH/\u0012=fGV$xN]:!\u00035y6.\u001b7m\u000bb,7-\u001e;pe\u0006qql[5mY\u0016CXmY;u_J\u0004\u0013AG0fq\u0016\u001cW\u000f^8s\u00032dwnY1uS>tW*\u00198bO\u0016\u0014XCAA !\u0019\tY#!\f\u0002BA!a)a\u0011w\u0013\r\t)e\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u00027}+\u00070Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8NC:\fw-\u001a:!\u0003A\tG\r\u001a\"bi\u000eD\u0007K]8d)&lW\rF\u0003T\u0003\u001b\n\t\u0006\u0003\u0004\u0002P]\u0001\rA^\u0001\b[\u0006t\u0017mZ3s\u0011\u0019\t\u0019f\u0006a\u0001\u000b\u00061A/[7f\u001bN\f\u0001C]3rk\u0016\u001cH/\u0012=fGV$xN]:\u0015\u000bM\u000bI&a\u0017\t\r\u0005=\u0003\u00041\u0001w\u0011\u001d\ti\u0006\u0007a\u0001\u0003\u0003\t\u0001B\\3x\u000bb,7m]\u0001\rW&dG.\u0012=fGV$xN\u001d\u000b\u0004'\u0006\r\u0004BBA(3\u0001\u0007a/\u0001\u000fhKR,\u00050Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0015\t\u0005\u0005\u0013\u0011\u000e\u0005\b\u0003WR\u0002\u0019AA7\u0003\r\u00198o\u0019\t\u0004]\u0005=\u0014bAA9?\t\u00012\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010^\u0001\u0015o&$\bn\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0015\t\u0005]\u0014\u0011\u0011\u000b\u0004'\u0006e\u0004BB8\u001c\u0001\u0004\tY\b\u0005\u0004G\u0003{\nigU\u0005\u0004\u0003\u007f:%!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015Q8\u00041\u0001|\u0001")
public class ExecutorAllocationManagerSuite
extends SparkFunSuite
implements TestSuiteBase,
MockitoSugar,
PrivateMethodTester {
    private final long batchDurationMillis;
    private ExecutorAllocationClient allocationClient;
    private StreamManualClock clock;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> _addBatchProcTime;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> _requestExecutors;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> _killExecutor;
    private final PrivateMethodTester.PrivateMethod<Option<ExecutorAllocationManager>> _executorAllocationManager;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public String framework() {
        return TestSuiteBase.framework$(this);
    }

    @Override
    public String master() {
        return TestSuiteBase.master$(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase.beforeFunction$(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase.afterFunction$(this);
    }

    @Override
    public void afterEach() {
        TestSuiteBase.afterEach$(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$(this, input, operation, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$(this);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$(this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$(this);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$(this);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$(this, output, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$(this);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private String checkpointDir$lzycompute() {
        ExecutorAllocationManagerSuite executorAllocationManagerSuite = this;
        synchronized (executorAllocationManagerSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$(this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    @Override
    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    private long batchDurationMillis() {
        return this.batchDurationMillis;
    }

    private ExecutorAllocationClient allocationClient() {
        return this.allocationClient;
    }

    private void allocationClient_$eq(ExecutorAllocationClient x$1) {
        this.allocationClient = x$1;
    }

    private StreamManualClock clock() {
        return this.clock;
    }

    private void clock_$eq(StreamManualClock x$1) {
        this.clock = x$1;
    }

    @Override
    public void beforeEach() {
        this.allocationClient_$eq((ExecutorAllocationClient)this.mock(ClassTag$.MODULE$.apply(ExecutorAllocationClient.class)));
        this.clock_$eq(new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1()));
    }

    public void basicTest(boolean decommissioning) {
        this.conf().set(package$.MODULE$.DECOMMISSION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)decommissioning));
        int x$1 = 1;
        SparkConf x$2 = this.conf();
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            ExecutorAllocationManagerSuite.$anonfun$basicTest$1(this, decommissioning, x0$1, x1$1);
            return BoxedUnit.UNIT;
        };
        this.withAllocationManager(x$2, x$1, (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)x$3);
    }

    private void withAllocationManager(SparkConf conf, int numReceivers, Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit> body) {
        ReceiverTracker receiverTracker = (ReceiverTracker)this.mock(ClassTag$.MODULE$.apply(ReceiverTracker.class));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)receiverTracker.numReceivers())).thenReturn((Object)BoxesRunTime.boxToInteger((int)numReceivers));
        ExecutorAllocationManager manager = new ExecutorAllocationManager(this.allocationClient(), receiverTracker, conf, this.batchDurationMillis(), (Clock)this.clock());
        try {
            manager.start();
            body.apply((Object)receiverTracker, (Object)manager);
        }
        finally {
            manager.stop();
        }
    }

    private SparkConf withAllocationManager$default$1() {
        return new SparkConf();
    }

    private int withAllocationManager$default$2() {
        return 1;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> _addBatchProcTime() {
        return this._addBatchProcTime;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> _requestExecutors() {
        return this._requestExecutors;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> _killExecutor() {
        return this._killExecutor;
    }

    private PrivateMethodTester.PrivateMethod<Option<ExecutorAllocationManager>> _executorAllocationManager() {
        return this._executorAllocationManager;
    }

    private void addBatchProcTime(ExecutorAllocationManager manager, long timeMs) {
        this.anyRefToInvoker(manager).invokePrivate(this._addBatchProcTime().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeMs)})));
    }

    private void requestExecutors(ExecutorAllocationManager manager, int newExecs) {
        this.anyRefToInvoker(manager).invokePrivate(this._requestExecutors().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)newExecs)})));
    }

    private void killExecutor(ExecutorAllocationManager manager) {
        this.anyRefToInvoker(manager).invokePrivate(this._killExecutor().apply((Seq)Nil$.MODULE$));
    }

    private Option<ExecutorAllocationManager> getExecutorAllocationManager(StreamingContext ssc) {
        return (Option)this.anyRefToInvoker(ssc.scheduler()).invokePrivate(this._executorAllocationManager().apply((Seq)Nil$.MODULE$));
    }

    private void withStreamingContext(SparkConf conf, Function1<StreamingContext, BoxedUnit> body) {
        conf.setMaster("local-cluster[1,1,1024]").setAppName(this.getClass().getSimpleName()).set("spark.streaming.dynamicAllocation.testing", "true");
        this.withStreamingContext(new StreamingContext(conf, Seconds$.MODULE$.apply(1L)), (Function1 & Serializable & scala.Serializable)ssc -> {
            ExecutorAllocationManagerSuite.$anonfun$withStreamingContext$1(body, ssc);
            return BoxedUnit.UNIT;
        });
    }

    private final void PrivateMethod$lzycompute$1() {
        ExecutorAllocationManagerSuite executorAllocationManagerSuite = this;
        synchronized (executorAllocationManagerSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void addBatchProcTimeAndVerifyAllocation$1(double batchProcTimeMs, Function0 body, ExecutorAllocationManager allocationManager$1) {
        Mockito.reset((Object[])new ExecutorAllocationClient[]{this.allocationClient()});
        Mockito.when((Object)this.allocationClient().getExecutorIds()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})));
        this.addBatchProcTime(allocationManager$1, (long)batchProcTimeMs);
        long advancedTime = BoxesRunTime.unboxToLong((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_INTERVAL().defaultValue().get()) * 1000L + 1L;
        long expectedWaitTime = this.clock().getTimeMillis() + advancedTime;
        this.clock().advance(advancedTime);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.clock().isStreamWaitingAt(expectedWaitTime), "ExecutorAllocationManagerSuite.this.clock.isStreamWaitingAt(expectedWaitTime)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        body.apply$mcV$sp();
    }

    private final void verifyTotalRequestedExecs$1(Option expectedRequestedTotalExecs) {
        if (expectedRequestedTotalExecs.nonEmpty()) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)expectedRequestedTotalExecs.get()) > 0);
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).requestTotalExecutors((Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID())), expectedRequestedTotalExecs.get())}))), (Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID())), (Object)BoxesRunTime.boxToInteger((int)0))}))), (Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().empty()));
        } else {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).requestTotalExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID())), (Object)BoxesRunTime.boxToInteger((int)0))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID())), (Object)BoxesRunTime.boxToInteger((int)0))})), Predef$.MODULE$.Map().empty());
        }
    }

    private final void verifyScaledDownExec$1(Option expectedExec, boolean decommissioning$1) {
        if (expectedExec.nonEmpty()) {
            ExecutorDecommissionInfo decomInfo = new ExecutorDecommissionInfo("spark scale down", (Option)None$.MODULE$);
            if (decommissioning$1) {
                ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).decommissionExecutor((String)ArgumentMatchers.eq((Object)expectedExec.get()), (ExecutorDecommissionInfo)ArgumentMatchers.eq((Object)decomInfo), ArgumentMatchers.eq((boolean)true), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
                ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).killExecutor((String)ArgumentMatchers.eq((Object)expectedExec.get()));
            } else {
                ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).killExecutor((String)ArgumentMatchers.eq((Object)expectedExec.get()));
                ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).decommissionExecutor((String)ArgumentMatchers.eq((Object)expectedExec.get()), (ExecutorDecommissionInfo)ArgumentMatchers.eq((Object)decomInfo), ArgumentMatchers.eq((boolean)true), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            }
        } else if (decommissioning$1) {
            ExecutorAllocationClient qual$1 = (ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never());
            Object x$1 = null;
            Object x$2 = null;
            boolean x$3 = false;
            boolean x$4 = qual$1.decommissionExecutor$default$4();
            qual$1.decommissionExecutor(null, null, x$3, x$4);
            ExecutorAllocationClient qual$2 = (ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never());
            Object x$5 = null;
            Object x$6 = null;
            boolean x$7 = true;
            boolean x$8 = qual$2.decommissionExecutor$default$4();
            qual$2.decommissionExecutor(null, null, x$7, x$8);
        } else {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).killExecutor(null);
        }
    }

    public static final /* synthetic */ void $anonfun$basicTest$1(ExecutorAllocationManagerSuite $this, boolean decommissioning$1, ReceiverTracker x0$1, ExecutorAllocationManager x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Mockito.when((Object)receiverTracker.allocatedExecutors()).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1"))})));
        $this.addBatchProcTimeAndVerifyAllocation$1($this.batchDurationMillis(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
            $this.verifyScaledDownExec$1((Option)None$.MODULE$, decommissioning$1);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1($this.batchDurationMillis() * 2L, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
            $this.verifyScaledDownExec$1((Option)None$.MODULE$, decommissioning$1);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_UP_RATIO().defaultValue().get()) + 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
            $this.verifyScaledDownExec$1((Option)None$.MODULE$, decommissioning$1);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_UP_RATIO().defaultValue().get()) - 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)None$.MODULE$);
            $this.verifyScaledDownExec$1((Option)None$.MODULE$, decommissioning$1);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_DOWN_RATIO().defaultValue().get()) + 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)None$.MODULE$);
            $this.verifyScaledDownExec$1((Option)None$.MODULE$, decommissioning$1);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_DOWN_RATIO().defaultValue().get()) - 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)None$.MODULE$);
            $this.verifyScaledDownExec$1((Option)new Some((Object)"2"), decommissioning$1);
        }, allocationManager);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$new$4(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    private final void verifyRequestedExecs$1(int numExecs, int numNewExecs, int expectedRequestedTotalExecs, ExecutorAllocationManager allocationManager) {
        Mockito.reset((Object[])new ExecutorAllocationClient[]{this.allocationClient()});
        Mockito.when((Object)this.allocationClient().getExecutorIds()).thenReturn(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numExecs).map((Function1 & Serializable & scala.Serializable)x$1 -> ExecutorAllocationManagerSuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom()));
        this.requestExecutors(allocationManager, numNewExecs);
        int defaultProfId = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).requestTotalExecutors((Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)defaultProfId)), (Object)BoxesRunTime.boxToInteger((int)expectedRequestedTotalExecs))}))), (Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)defaultProfId)), (Object)BoxesRunTime.boxToInteger((int)0))}))), (Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().empty()));
    }

    public static final /* synthetic */ void $anonfun$new$5(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$1, ExecutorAllocationManager x1$1) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.verifyRequestedExecs$1(0, 0, 0, am), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        $this.verifyRequestedExecs$1(0, 1, 1, am);
        $this.verifyRequestedExecs$1(1, 1, 2, am);
        $this.verifyRequestedExecs$1(2, 2, 4, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$7(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$2, ExecutorAllocationManager x1$2) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.verifyRequestedExecs$1(0, 1, 2, am);
        $this.verifyRequestedExecs$1(1, 1, 2, am);
        $this.verifyRequestedExecs$1(2, 2, 4, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$8(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$3, ExecutorAllocationManager x1$3) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.verifyRequestedExecs$1(0, 1, 2, am);
        $this.verifyRequestedExecs$1(0, 3, 3, am);
        $this.verifyRequestedExecs$1(1, 1, 2, am);
        $this.verifyRequestedExecs$1(1, 2, 3, am);
        $this.verifyRequestedExecs$1(2, 1, 3, am);
        $this.verifyRequestedExecs$1(2, 2, 4, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$9(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$4, ExecutorAllocationManager x1$4) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$4);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.verifyRequestedExecs$1(0, 1, 1, am);
        $this.verifyRequestedExecs$1(0, 3, 2, am);
        $this.verifyRequestedExecs$1(1, 2, 2, am);
        $this.verifyRequestedExecs$1(2, 1, 2, am);
        $this.verifyRequestedExecs$1(2, 2, 2, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void verifyKilledExec$1(Seq execIds, Map receiverExecIds, Option expectedKilledExec, Tuple2 x) {
        Tuple2 tuple2 = x;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)receiverTracker, (Object)allocationManager);
        Tuple2 tuple23 = tuple22;
        ReceiverTracker receiverTracker2 = (ReceiverTracker)tuple23._1();
        ExecutorAllocationManager allocationManager2 = (ExecutorAllocationManager)tuple23._2();
        Mockito.reset((Object[])new ExecutorAllocationClient[]{this.allocationClient()});
        Mockito.when((Object)this.allocationClient().getExecutorIds()).thenReturn((Object)execIds);
        Mockito.when((Object)receiverTracker2.allocatedExecutors()).thenReturn((Object)receiverExecIds);
        this.killExecutor(allocationManager2);
        if (expectedKilledExec.nonEmpty()) {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).killExecutor((String)ArgumentMatchers.eq((Object)expectedKilledExec.get()));
        } else {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).killExecutor(null);
        }
    }

    public static final /* synthetic */ void $anonfun$new$11(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$5, ExecutorAllocationManager x1$5) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$5);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Tuple2 rcvrTrackerAndExecAllocMgr = new Tuple2((Object)receiverTracker, (Object)allocationManager);
        $this.verifyKilledExec$1((Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1"))})), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1"))})), (Option)new Some((Object)"2"), rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new Some((Object)"2"))})), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$12(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$6, ExecutorAllocationManager x1$6) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)x1$6);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Tuple2 rcvrTrackerAndExecAllocMgr = new Tuple2((Object)receiverTracker, (Object)allocationManager);
        $this.verifyKilledExec$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new Some((Object)"2"))})), (Option)new Some((Object)"3"), rcvrTrackerAndExecAllocMgr);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void validateParams$1(int numReceivers, Option scalingIntervalSecs, Option scalingUpRatio, Option scalingDownRatio, Option minExecs, Option maxExecs) {
        Predef$.MODULE$.require(numReceivers > 0);
        ReceiverTracker receiverTracker = (ReceiverTracker)this.mock(ClassTag$.MODULE$.apply(ReceiverTracker.class));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)receiverTracker.numReceivers())).thenReturn((Object)BoxesRunTime.boxToInteger((int)numReceivers));
        SparkConf conf = new SparkConf();
        Object object = scalingIntervalSecs.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.scalingInterval", new StringBuilder(1).append(scalingIntervalSecs.get()).append("s").toString()) : BoxedUnit.UNIT;
        Object object2 = scalingUpRatio.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.scalingUpRatio", scalingUpRatio.get().toString()) : BoxedUnit.UNIT;
        Object object3 = scalingDownRatio.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.scalingDownRatio", scalingDownRatio.get().toString()) : BoxedUnit.UNIT;
        Object object4 = minExecs.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.minExecutors", minExecs.get().toString()) : BoxedUnit.UNIT;
        Object object5 = maxExecs.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.maxExecutors", maxExecs.get().toString()) : BoxedUnit.UNIT;
        new ExecutorAllocationManager(this.allocationClient(), receiverTracker, conf, this.batchDurationMillis(), (Clock)this.clock());
    }

    private static final int validateParams$default$1$1() {
        return 1;
    }

    private static final Option validateParams$default$2$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$3$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$4$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$5$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$6$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$28(ExecutorAllocationManagerSuite $this, StreamingContext ssc) {
        ssc.start();
        Option<ExecutorAllocationManager> $org_scalatest_assert_macro_left = $this.getExecutorAllocationManager(ssc);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
    }

    public static final /* synthetic */ void $anonfun$new$29(ExecutorAllocationManagerSuite $this, StreamingContext ssc) {
        ssc.start();
        Option<ExecutorAllocationManager> $org_scalatest_assert_macro_left = $this.getExecutorAllocationManager(ssc);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
    }

    public static final /* synthetic */ void $anonfun$withStreamingContext$2(RDD x$3) {
    }

    public static final /* synthetic */ void $anonfun$withStreamingContext$1(Function1 body$1, StreamingContext ssc) {
        new DummyInputDStream(ssc).foreachRDD((Function1 & Serializable & scala.Serializable)x$3 -> {
            ExecutorAllocationManagerSuite.$anonfun$withStreamingContext$2(x$3);
            return BoxedUnit.UNIT;
        });
        body$1.apply((Object)ssc);
    }

    public ExecutorAllocationManagerSuite() {
        TestSuiteBase.$init$(this);
        MockitoSugar.$init$((MockitoSugar)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.batchDurationMillis = 1000L;
        this.allocationClient = null;
        this.clock = null;
        this.test("basic functionality", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.basicTest(false), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("basic decommissioning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.basicTest(true), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("requestExecutors policy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$1 = 1;
            SparkConf x$2 = this.withAllocationManager$default$1();
            Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$5(this, x0$1, x1$1);
                return BoxedUnit.UNIT;
            };
            this.withAllocationManager(x$2, x$1, (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)x$3);
            int x$4 = 2;
            SparkConf x$5 = this.withAllocationManager$default$1();
            Function2 & Serializable & scala.Serializable x$6 = (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$7(this, x0$2, x1$2);
                return BoxedUnit.UNIT;
            };
            this.withAllocationManager(x$5, x$4, (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)x$6);
            this.withAllocationManager(new SparkConf().set("spark.streaming.dynamicAllocation.minExecutors", "2"), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$8(this, x0$3, x1$3);
                return BoxedUnit.UNIT;
            });
            this.withAllocationManager(new SparkConf().set("spark.streaming.dynamicAllocation.maxExecutors", "2"), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$9(this, x0$4, x1$4);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("killExecutor policy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withAllocationManager(this.withAllocationManager$default$1(), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$11(this, x0$5, x1$5);
                return BoxedUnit.UNIT;
            });
            this.withAllocationManager(new SparkConf().set("spark.streaming.dynamicAllocation.minExecutors", "2"), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$12(this, x0$6, x1$6);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("parameter validation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.validateParams$1(1, ExecutorAllocationManagerSuite.validateParams$default$2$1(), ExecutorAllocationManagerSuite.validateParams$default$3$1(), ExecutorAllocationManagerSuite.validateParams$default$4$1(), ExecutorAllocationManagerSuite.validateParams$default$5$1(), ExecutorAllocationManagerSuite.validateParams$default$6$1());
            int x$7 = 2;
            Some x$8 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option x$9 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$10 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$11 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$12 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$7, x$9, x$10, x$11, (Option)x$8, x$12);
            int x$13 = 2;
            Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            Option x$15 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$16 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$17 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$18 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$13, x$15, x$16, x$17, (Option)x$14, x$18);
            int x$19 = 2;
            Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            Option x$21 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$22 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$23 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$24 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            this.validateParams$1(x$19, x$21, x$22, x$23, x$24, (Option)x$20);
            int x$25 = 2;
            Some x$26 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option x$27 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$28 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$29 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$30 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            this.validateParams$1(x$25, x$27, x$28, x$29, x$30, (Option)x$26);
            Some x$31 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            Some x$32 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            int x$33 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$34 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$35 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$36 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            this.validateParams$1(x$33, x$34, x$35, x$36, (Option)x$31, (Option)x$32);
            Some x$37 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            int x$38 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$39 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$40 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$41 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$42 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$38, (Option)x$37, x$39, x$40, x$41, x$42);
            Some x$43 = new Some((Object)BoxesRunTime.boxToDouble((double)1.1));
            int x$44 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$45 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$46 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$47 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$48 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$44, x$45, (Option)x$43, x$46, x$47, x$48);
            Some x$49 = new Some((Object)BoxesRunTime.boxToDouble((double)0.1));
            int x$50 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$51 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$52 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$53 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$54 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$50, x$51, x$52, (Option)x$49, x$53, x$54);
            Some x$55 = new Some((Object)BoxesRunTime.boxToDouble((double)1.1));
            Some x$56 = new Some((Object)BoxesRunTime.boxToDouble((double)0.1));
            int x$57 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$58 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$59 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$60 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$57, x$58, (Option)x$55, (Option)x$56, x$59, x$60);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$61 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                int x$62 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$63 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$64 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$65 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$66 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$62, x$63, x$64, x$65, (Option)x$61, x$66);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$67 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                int x$68 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$69 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$70 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$71 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$72 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$68, x$69, x$70, x$71, (Option)x$67, x$72);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$73 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                int x$74 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$75 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$76 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$77 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$78 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                this.validateParams$1(x$74, x$75, x$76, x$77, x$78, (Option)x$73);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$79 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                int x$80 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$81 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$82 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$83 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$84 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                this.validateParams$1(x$80, x$81, x$82, x$83, x$84, (Option)x$79);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$85 = new Some((Object)BoxesRunTime.boxToInteger((int)4));
                Some x$86 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
                int x$87 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$88 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$89 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$90 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                this.validateParams$1(x$87, x$88, x$89, x$90, (Option)x$85, (Option)x$86);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$91 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                int x$92 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$93 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$94 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$95 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$96 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$92, (Option)x$91, x$93, x$94, x$95, x$96);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$97 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                int x$98 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$99 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$100 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$101 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$102 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$98, (Option)x$97, x$99, x$100, x$101, x$102);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$103 = new Some((Object)BoxesRunTime.boxToDouble((double)-0.1));
                int x$104 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$105 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$106 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$107 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$108 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$104, x$105, (Option)x$103, x$106, x$107, x$108);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$109 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                int x$110 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$111 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$112 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$113 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$114 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$110, x$111, (Option)x$109, x$112, x$113, x$114);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$115 = new Some((Object)BoxesRunTime.boxToDouble((double)-0.1));
                int x$116 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$117 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$118 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$119 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$120 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$116, x$117, x$118, (Option)x$115, x$119, x$120);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$121 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                int x$122 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$123 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$124 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$125 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$126 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$122, x$123, x$124, (Option)x$121, x$125, x$126);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$127 = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
                Some x$128 = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
                int x$129 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$130 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$131 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$132 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$129, x$130, (Option)x$127, (Option)x$128, x$131, x$132);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$133 = new Some((Object)BoxesRunTime.boxToDouble((double)0.3));
                Some x$134 = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
                int x$135 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$136 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$137 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$138 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$135, x$136, (Option)x$133, (Option)x$134, x$137, x$138);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("enabling and disabling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withStreamingContext(new SparkConf(), (Function1<StreamingContext, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ssc -> {
                ExecutorAllocationManagerSuite.$anonfun$new$28(this, ssc);
                return BoxedUnit.UNIT;
            });
            this.withStreamingContext(new SparkConf().set("spark.streaming.dynamicAllocation.enabled", "true"), (Function1<StreamingContext, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ssc -> {
                ExecutorAllocationManagerSuite.$anonfun$new$29(this, ssc);
                return BoxedUnit.UNIT;
            });
            SparkConf confWithBothDynamicAllocationEnabled = new SparkConf().set("spark.streaming.dynamicAllocation.enabled", "true").set(package$.MODULE$.DYN_ALLOCATION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.DYN_ALLOCATION_TESTING(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            Predef$.MODULE$.require(Utils$.MODULE$.isDynamicAllocationEnabled(confWithBothDynamicAllocationEnabled));
            this.withStreamingContext(confWithBothDynamicAllocationEnabled, (Function1<StreamingContext, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ssc -> {
                this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ssc.start(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
                return BoxedUnit.UNIT;
            });
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        this._addBatchProcTime = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "addBatchProcTime"));
        this._requestExecutors = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "requestExecutors"));
        this._killExecutor = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "killExecutor"));
        this._executorAllocationManager = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "executorAllocationManager"));
    }
}

