/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.streaming.util.CommonWriteAheadLogTests;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogRandomReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogReader;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSuite;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSuite$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogWriter;
import org.apache.spark.streaming.util.WriteAheadLogSuite$;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tYb)\u001b7f\u0005\u0006\u001cX\rZ,sSR,\u0017\t[3bI2{wmU;ji\u0016T!\u0001B\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\r\u001d\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005!I\u0011!B:qCJ\\'B\u0001\u0006\f\u0003\u0019\t\u0007/Y2iK*\tA\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001#E\u0007\u0002\u0007%\u0011!c\u0001\u0002\u0019\u0007>lWn\u001c8Xe&$X-\u00115fC\u0012dun\u001a+fgR\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0016!\t\u0001\u0002\u0001")
public class FileBasedWriteAheadLogSuite
extends CommonWriteAheadLogTests {
    public static final Iterator org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$handle$1(int value, GetMaxCounter.1 counter$1, CountDownLatch latch$1) {
        public class Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$GetMaxCounter$1 {
            private final AtomicInteger value;
            private volatile int max;

            private AtomicInteger value() {
                return this.value;
            }

            private int max() {
                return this.max;
            }

            private void max_$eq(int x$1) {
                this.max = x$1;
            }

            public synchronized void increment() {
                block0: {
                    int atInstant = this.value().incrementAndGet();
                    if (atInstant <= this.max()) break block0;
                    this.max_$eq(atInstant);
                }
            }

            public void decrement() {
                Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$GetMaxCounter$1 var1_1 = this;
                synchronized (var1_1) {
                    this.value().decrementAndGet();
                }
            }

            public synchronized int get() {
                return this.value().get();
            }

            public synchronized int getMax() {
                return this.max();
            }

            public Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$GetMaxCounter$1(FileBasedWriteAheadLogSuite $outer) {
                this.value = new AtomicInteger();
                this.max = 0;
            }
        }
        return new CompletionIterator<Object, Iterator<Object>>(null, value, counter$1, latch$1){
            private final Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$GetMaxCounter$1 counter$1;

            public void completion() {
                this.counter$1.decrement();
            }
            {
                this.counter$1 = counter$1;
                super(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value$1})));
                counter$1.increment();
                latch$1.await(10L, TimeUnit.SECONDS);
            }
        };
    }

    public FileBasedWriteAheadLogSuite() {
        super(false, false, "FileBasedWriteAheadLog");
        this.test("FileBasedWriteAheadLog - seqToParIterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            int numThreads = 8;
            ForkJoinPool fpool = ThreadUtils$.MODULE$.newForkJoinPool("wal-test-thread-pool", numThreads);
            ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)fpool);
            try {
                CountDownLatch latch = new CountDownLatch(1);
                Range.Inclusive testSeq = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000);
                Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$GetMaxCounter$1 counter = new Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$GetMaxCounter$1(null);
                VolatileObjectRef collected = VolatileObjectRef.create((Object)Nil$.MODULE$);
                Thread t = new Thread(this, executionContext, testSeq, collected, counter, latch){
                    private final /* synthetic */ FileBasedWriteAheadLogSuite $outer;
                    private final ExecutionContextExecutorService executionContext$1;
                    private final Range.Inclusive testSeq$1;
                    private final VolatileObjectRef collected$1;
                    private final Org_apache_spark_streaming_util_FileBasedWriteAheadLogSuite$GetMaxCounter$1 counter$1;
                    private final CountDownLatch latch$1;

                    public void run() {
                        Iterator iterator = FileBasedWriteAheadLog$.MODULE$.seqToParIterator((ExecutionContext)this.executionContext$1, (Seq)this.testSeq$1, (Function1 & Serializable & scala.Serializable)value -> $anon$2.$anonfun$run$1(this, BoxesRunTime.unboxToInt((Object)value)));
                        this.collected$1.elem = iterator.toSeq();
                    }

                    public static final /* synthetic */ Iterator $anonfun$run$1($anon$2 $this, int value) {
                        return FileBasedWriteAheadLogSuite.org$apache$spark$streaming$util$FileBasedWriteAheadLogSuite$$handle$1(value, $this.counter$1, $this.latch$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionContext$1 = executionContext$1;
                        this.testSeq$1 = testSeq$1;
                        this.collected$1 = collected$1;
                        this.counter$1 = counter$1;
                        this.latch$1 = latch$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.streaming.util.FileBasedWriteAheadLogSuite$$anon$2 java.lang.Object )}, serializedLambda);
                    }
                };
                t.start();
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0 & Serializable & scala.Serializable)() -> {
                    int $org_scalatest_assert_macro_left = counter.getMax();
                    int $org_scalatest_assert_macro_right = 1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
                latch.countDown();
                t.join(10000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer((Seq)collected.elem);
                Range.Inclusive $org_scalatest_assert_macro_right = testSeq;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
                int $org_scalatest_assert_macro_left2 = counter.getMax();
                int $org_scalatest_assert_macro_right2 = numThreads;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            }
            finally {
                fpool.shutdownNow();
            }
            return assertion;
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("FileBasedWriteAheadLogWriter - writing data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
            Seq<FileBasedWriteAheadLogSegment> segments = WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.testFile(), dataToWrite);
            Seq<String> writtenData = WriteAheadLogSuite$.MODULE$.readDataManually(segments);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writtenData);
            Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("FileBasedWriteAheadLogWriter - syncing of data by writing and reading immediately", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
            FileBasedWriteAheadLogWriter writer = new FileBasedWriteAheadLogWriter(this.testFile(), this.hadoopConf());
            dataToWrite.foreach((Function1 & Serializable & scala.Serializable)data -> {
                FileBasedWriteAheadLogSegment segment = writer.write(WriteAheadLogSuite$.MODULE$.stringToByteBuffer((String)data));
                String dataRead = (String)WriteAheadLogSuite$.MODULE$.readDataManually((Seq<FileBasedWriteAheadLogSegment>)((Seq)new .colon.colon((Object)segment, (List)Nil$.MODULE$))).head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(data);
                String $org_scalatest_assert_macro_right = dataRead;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            });
            writer.close();
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("FileBasedWriteAheadLogReader - sequentially reading data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<String> writtenData = WriteAheadLogSuite$.MODULE$.generateRandomData();
            WriteAheadLogSuite$.MODULE$.writeDataManually(writtenData, this.testFile(), false);
            FileBasedWriteAheadLogReader reader = new FileBasedWriteAheadLogReader(this.testFile(), this.hadoopConf());
            Seq readData = (Seq)reader.toSeq().map((Function1 & Serializable & scala.Serializable)byteBuffer -> WriteAheadLogSuite$.MODULE$.byteBufferToString((ByteBuffer)byteBuffer), Seq$.MODULE$.canBuildFrom());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(readData);
            Seq<String> $org_scalatest_assert_macro_right = writtenData;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)reader.hasNext()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> reader.next(), ClassTag$.MODULE$.apply(Exception.class), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            reader.close();
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.test("FileBasedWriteAheadLogReader - sequentially reading data written with writer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
            WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.testFile(), dataToWrite);
            Seq<String> readData = WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.testFile());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(readData);
            Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        this.test("FileBasedWriteAheadLogReader - reading data written with writer after corrupted write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
            WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.testFile(), dataToWrite);
            long fileLength = new File(this.testFile()).length();
            FileWriter fw = new FileWriter(this.testFile(), true);
            fw.append("This line appended to file!");
            fw.close();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.testFile()));
            Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            FileChannel raf = new FileOutputStream(this.testFile(), true).getChannel();
            raf.truncate(fileLength - 1L);
            raf.close();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.testFile()));
            Seq $org_scalatest_assert_macro_right2 = (Seq)dataToWrite.dropRight(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.test("FileBasedWriteAheadLogReader - handles errors when file doesn't exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
            WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.testFile(), dataToWrite);
            File tFile = new File(this.testFile());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(tFile.exists(), "tFile.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.testFile()));
            Seq<String> $org_scalatest_assert_macro_right = dataToWrite;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            tFile.delete();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(tFile.exists(), "tFile.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            FileBasedWriteAheadLogReader reader = new FileBasedWriteAheadLogReader(this.testFile(), this.hadoopConf());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(reader.hasNext(), "reader.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            reader.close();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(WriteAheadLogSuite$.MODULE$.readDataUsingReader(this.testFile()));
            Nil$ $org_scalatest_assert_macro_right2 = Nil$.MODULE$;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("FileBasedWriteAheadLogRandomReader - reading data using random reader", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<String> writtenData = WriteAheadLogSuite$.MODULE$.generateRandomData();
            Seq<FileBasedWriteAheadLogSegment> segments = WriteAheadLogSuite$.MODULE$.writeDataManually(writtenData, this.testFile(), false);
            Iterator writtenDataAndSegments = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)((SeqLike)writtenData.zip(segments, Seq$.MODULE$.canBuildFrom())).toSeq().permutations().take(10), (Function1)Predef$.MODULE$.$conforms()).flatten();
            FileBasedWriteAheadLogRandomReader reader = new FileBasedWriteAheadLogRandomReader(this.testFile(), this.hadoopConf());
            writtenDataAndSegments.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String data = (String)tuple2._1();
                FileBasedWriteAheadLogSegment segment = (FileBasedWriteAheadLogSegment)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(data);
                String $org_scalatest_assert_macro_right = WriteAheadLogSuite$.MODULE$.byteBufferToString(reader.read(segment));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
                return assertion;
            });
            reader.close();
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("FileBasedWriteAheadLogRandomReader- reading data using random reader written with writer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq<String> data = WriteAheadLogSuite$.MODULE$.generateRandomData();
            Seq<FileBasedWriteAheadLogSegment> segments = WriteAheadLogSuite$.MODULE$.writeDataUsingWriter(this.testFile(), data);
            Iterator dataAndSegments = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)((SeqLike)data.zip(segments, Seq$.MODULE$.canBuildFrom())).toSeq().permutations().take(10), (Function1)Predef$.MODULE$.$conforms()).flatten();
            FileBasedWriteAheadLogRandomReader reader = new FileBasedWriteAheadLogRandomReader(this.testFile(), this.hadoopConf());
            dataAndSegments.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String data = (String)tuple2._1();
                FileBasedWriteAheadLogSegment segment = (FileBasedWriteAheadLogSegment)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(data);
                String $org_scalatest_assert_macro_right = WriteAheadLogSuite$.MODULE$.byteBufferToString(reader.read(segment));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
                return assertion;
            });
            reader.close();
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
    }
}

