/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.DummyInputDStream;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestException;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.PairDStreamFunctions;
import org.apache.spark.util.ReturnStatementInClosureException;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001q4A\u0001F\u000b\u0001=!)q\u0005\u0001C\u0001Q!)!\u0006\u0001C)W!)!\u0007\u0001C\u0005g!)\u0011\b\u0001C\u0005u!)a\t\u0001C\u0005\u000f\")\u0011\n\u0001C\u0005\u0015\")A\n\u0001C\u0005\u001b\")q\n\u0001C\u0005!\")!\u000b\u0001C\u0005'\")Q\u000b\u0001C\u0005-\")\u0001\f\u0001C\u00053\")1\f\u0001C\u00059\")a\f\u0001C\u0005?\")Q\r\u0001C\u0005M\")\u0001\u000e\u0001C\u0005S\")1\u000e\u0001C\u0005Y\")a\u000e\u0001C\u0005_\")\u0011\u000f\u0001C\u0005e\")A\u000f\u0001C\u0005k\n\u0019Bi\u0015;sK\u0006l7\t\\8tkJ,7+^5uK*\u0011acF\u0001\ngR\u0014X-Y7j]\u001eT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001qd\t\t\u0003A\u0005j\u0011aF\u0005\u0003E]\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0013&\u001b\u0005)\u0012B\u0001\u0014\u0016\u0005UaunY1m'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtD#A\u0015\u0011\u0005\u0011\u0002\u0011A\u00032fM>\u0014X-R1dQR\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\u0018AF3ya\u0016\u001cGoQ8se\u0016\u001cG/\u0012=dKB$\u0018n\u001c8\u0015\u00051\"\u0004BB\u001b\u0004\t\u0003\u0007a'\u0001\u0003c_\u0012L\bcA\u00178Y%\u0011\u0001H\f\u0002\ty\tLh.Y7f}\u00059A/Z:u\u001b\u0006\u0004HC\u0001\u0017<\u0011\u0015aD\u00011\u0001>\u0003\t!7\u000fE\u0002?\u0003\u000ek\u0011a\u0010\u0006\u0003\u0001V\tq\u0001Z:ue\u0016\fW.\u0003\u0002C\u007f\t9Ai\u0015;sK\u0006l\u0007CA\u0017E\u0013\t)eFA\u0002J]R\f1\u0002^3ti\u001ac\u0017\r^'baR\u0011A\u0006\u0013\u0005\u0006y\u0015\u0001\r!P\u0001\u000bi\u0016\u001cHOR5mi\u0016\u0014HC\u0001\u0017L\u0011\u0015ad\u00011\u0001>\u0003E!Xm\u001d;NCB\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003Y9CQ\u0001P\u0004A\u0002u\n!\u0002^3tiJ+G-^2f)\ta\u0013\u000bC\u0003=\u0011\u0001\u0007Q(\u0001\buKN$hi\u001c:fC\u000eD'\u000b\u0012#\u0015\u00051\"\u0006\"\u0002\u001f\n\u0001\u0004i\u0014!\u0004;fgR$&/\u00198tM>\u0014X\u000e\u0006\u0002-/\")AH\u0003a\u0001{\u0005\tB/Z:u)J\fgn\u001d4pe6<\u0016\u000e\u001e5\u0015\u00051R\u0006\"\u0002\u001f\f\u0001\u0004i\u0014A\u0005;fgR\u0014V\rZ;dK\nKx+\u001b8e_^$\"\u0001L/\t\u000bqb\u0001\u0019A\u001f\u0002\u001fQ,7\u000f\u001e*fIV\u001cWMQ=LKf$\"\u0001\f1\t\u000bqj\u0001\u0019A1\u0011\u0007y\n%\r\u0005\u0003.G\u000e\u001b\u0015B\u00013/\u0005\u0019!V\u000f\u001d7fe\u0005\u0001B/Z:u\u0007>l'-\u001b8f\u0005f\\U-\u001f\u000b\u0003Y\u001dDQ\u0001\u0010\bA\u0002\u0005\f\u0001\u0004^3tiJ+G-^2f\u0005f\\U-_!oI^Kg\u000eZ8x)\ta#\u000eC\u0003=\u001f\u0001\u0007\u0011-\u0001\u000buKN$X\u000b\u001d3bi\u0016\u001cF/\u0019;f\u0005f\\U-\u001f\u000b\u0003Y5DQ\u0001\u0010\tA\u0002\u0005\fQ\u0002^3ti6\u000b\u0007OV1mk\u0016\u001cHC\u0001\u0017q\u0011\u0015a\u0014\u00031\u0001b\u0003E!Xm\u001d;GY\u0006$X*\u00199WC2,Xm\u001d\u000b\u0003YMDQ\u0001\u0010\nA\u0002\u0005\fa\u0002^3tiR\u0013\u0018M\\:g_Jl'\u0007F\u0002-mnDQa^\nA\u0002a\f1a]:d!\t!\u00130\u0003\u0002{+\t\u00012\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\u0006yM\u0001\r!\u0010")
public class DStreamClosureSuite
extends SparkFunSuite
implements LocalStreamingContext {
    private transient StreamingContext ssc;
    private final transient boolean stopSparkContext;

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterEach() {
        LocalStreamingContext.afterEach$(this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        SparkContext sc = new SparkContext("local", "test");
        this.ssc_$eq(new StreamingContext(sc, Seconds$.MODULE$.apply(1L)));
    }

    private void expectCorrectException(Function0<BoxedUnit> body) {
        try {
            body.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ReturnStatementInClosureException) {
            }
            if (throwable2 instanceof NotSerializableException ? true : throwable2 instanceof SparkException) {
                throw new TestException(new StringBuilder(118).append("Expected ReturnStatementInClosureException, but got ").append(throwable2).append(".\n").append("This means the closure provided by user is not actually cleaned.").toString());
            }
            throw throwable;
        }
    }

    private void testMap(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testFlatMap(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> DStreamClosureSuite.$anonfun$testFlatMap$2(object, BoxesRunTime.unboxToInt((Object)x$2)), ClassTag$.MODULE$.Nothing()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testFilter(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testMapPartitions(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.mapPartitions((Function1 & Serializable & scala.Serializable)x$4 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }, ds.mapPartitions$default$2(), ClassTag$.MODULE$.Nothing()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduce(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.reduce((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
                if (sp2 != null) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                throw new MatchError((Object)sp2);
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testForeachRDD(DStream<Object> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable foreachRDDF1 = (Function2 & Serializable & scala.Serializable)(rdd, t) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function1 & Serializable & scala.Serializable foreachRDDF2 = (Function1 & Serializable & scala.Serializable)rdd -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.foreachRDD(foreachRDDF1));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.foreachRDD(foreachRDDF2));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testTransform(DStream<Object> ds) {
        Object object = new Object();
        try {
            Function1 & Serializable & scala.Serializable transformF1 = (Function1 & Serializable & scala.Serializable)rdd -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function2 & Serializable & scala.Serializable transformF2 = (Function2 & Serializable & scala.Serializable)(rdd, time) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transform(transformF1, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transform(transformF2, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testTransformWith(DStream<Object> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable transformF1 = (Function2 & Serializable & scala.Serializable)(rdd1, rdd2) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function3 & Serializable & scala.Serializable transformF2 = (Function3 & Serializable & scala.Serializable)(rdd1, rdd2, time) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transformWith(ds, transformF1, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transformWith(ds, transformF2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduceByWindow(DStream<Object> ds) {
        Object object = new Object();
        try {
            JFunction2.mcIII.sp & Serializable & scala.Serializable reduceF = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByWindow$2(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByWindow$3(ds, (Function2)reduceF)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduceByKey(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            JFunction2.mcIII.sp & Serializable & scala.Serializable reduceF = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$7, x$8) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKey$2(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKey$3(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKey$4(ds, (Function2)reduceF)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testCombineByKey(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                PairDStreamFunctions qual$1 = DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                JFunction1.mcII.sp & Serializable & scala.Serializable x$1 = (JFunction1.mcII.sp & Serializable & scala.Serializable)x$9 -> {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                };
                JFunction2.mcIII.sp & Serializable & scala.Serializable x$2 = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
                    if (sp2 != null && true) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new MatchError((Object)sp2);
                };
                JFunction2.mcIII.sp & Serializable & scala.Serializable x$3 = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$2, x1$2);
                    if (sp2 != null && true) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new MatchError((Object)sp2);
                };
                HashPartitioner x$4 = new HashPartitioner(5);
                boolean x$5 = qual$1.combineByKey$default$5();
                qual$1.combineByKey((Function1)x$1, (Function2)x$2, (Function2)x$3, (Partitioner)x$4, x$5, ClassTag$.MODULE$.Int());
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduceByKeyAndWindow(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            JFunction2.mcIII.sp & Serializable & scala.Serializable reduceF = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$10, x$11) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function1 & Serializable & scala.Serializable filterF = (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$2(object, x$12));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$3(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$4(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$5(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$6(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$7(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$8(ds, (Function2)reduceF, filterF)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testUpdateStateByKey(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable updateF1 = (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function1 & Serializable & scala.Serializable updateF2 = (Function1 & Serializable & scala.Serializable)x$15 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function4 & Serializable & scala.Serializable updateF3 = (Function4 & Serializable & scala.Serializable)(x$16, x$17, x$18, x$19) -> DStreamClosureSuite.$anonfun$testUpdateStateByKey$3(object, x$16, BoxesRunTime.unboxToInt((Object)x$17), x$18, x$19);
            RDD initialRDD = ds.ssc().sparkContext().emptyRDD(ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)i -> DStreamClosureSuite.$anonfun$testUpdateStateByKey$4(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, 5, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, (Partitioner)new HashPartitioner(5), ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, (Partitioner)new HashPartitioner(5), initialRDD, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF2, (Partitioner)new HashPartitioner(5), true, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF2, (Partitioner)new HashPartitioner(5), true, initialRDD, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF3, (Partitioner)new HashPartitioner(5), true, Option$.MODULE$.apply((Object)initialRDD), ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testMapValues(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$20 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testFlatMapValues(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).flatMapValues((Function1 & Serializable & scala.Serializable)x$21 -> DStreamClosureSuite.$anonfun$testFlatMapValues$2(object, BoxesRunTime.unboxToInt((Object)x$21)), ClassTag$.MODULE$.Nothing()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testTransform2(StreamingContext ssc, DStream<Object> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable transformF = (Function2 & Serializable & scala.Serializable)(rdds, time) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ssc.transform((Seq)new .colon.colon((Object)ds, (List)Nil$.MODULE$), transformF, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$2(int i) {
        return new Tuple2.mcII.sp(i, i);
    }

    public static final /* synthetic */ Seq $anonfun$testFlatMap$2(Object nonLocalReturnKey2$1, int x$2) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$testReduceByWindow$2(DStream ds$9, Function2 reduceF$1) {
        ds$9.reduceByWindow(reduceF$1, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByWindow$3(DStream ds$9, Function2 reduceF$1) {
        ds$9.reduceByWindow(reduceF$1, reduceF$1, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKey$2(DStream ds$10, Function2 reduceF$2) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$10, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey(reduceF$2);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKey$3(DStream ds$10, Function2 reduceF$2) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$10, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey(reduceF$2, 5);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKey$4(DStream ds$10, Function2 reduceF$2) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$10, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey(reduceF$2, (Partitioner)new HashPartitioner(5));
    }

    public static final /* synthetic */ boolean $anonfun$testReduceByKeyAndWindow$2(Object nonLocalReturnKey12$1, Tuple2 x$12) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey12$1, BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$3(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$4(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$5(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L), 5);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$6(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L), (Partitioner)new HashPartitioner(5));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$7(DStream ds$12, Function2 reduceF$3) {
        PairDStreamFunctions qual$1 = DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
        Function2 x$1 = reduceF$3;
        Function2 x$2 = reduceF$3;
        Duration x$3 = Seconds$.MODULE$.apply(2L);
        Duration x$4 = qual$1.reduceByKeyAndWindow$default$4();
        int x$5 = qual$1.reduceByKeyAndWindow$default$5();
        Function1 x$6 = qual$1.reduceByKeyAndWindow$default$6();
        qual$1.reduceByKeyAndWindow(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$8(DStream ds$12, Function2 reduceF$3, Function1 filterF$1) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, reduceF$3, Seconds$.MODULE$.apply(2L), Seconds$.MODULE$.apply(3L), (Partitioner)new HashPartitioner(5), filterF$1);
    }

    public static final /* synthetic */ Option $anonfun$testUpdateStateByKey$3(Object nonLocalReturnKey13$1, Time x$16, int x$17, Seq x$18, Option x$19) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey13$1, BoxedUnit.UNIT);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testUpdateStateByKey$4(int i) {
        return new Tuple2.mcII.sp(i, i);
    }

    public static final /* synthetic */ Seq $anonfun$testFlatMapValues$2(Object nonLocalReturnKey15$1, int x$21) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey15$1, BoxedUnit.UNIT);
    }

    public DStreamClosureSuite() {
        LocalStreamingContext.$init$(this);
        this.test("user provided closures are actually cleaned", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyInputDStream dstream = new DummyInputDStream(this.ssc());
            DStream pairDstream = dstream.map((Function1 & Serializable & scala.Serializable)i -> DStreamClosureSuite.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
            this.testMap((DStream<Object>)dstream);
            this.testFlatMap((DStream<Object>)dstream);
            this.testFilter((DStream<Object>)dstream);
            this.testMapPartitions((DStream<Object>)dstream);
            this.testReduce((DStream<Object>)dstream);
            this.testForeachRDD((DStream<Object>)dstream);
            this.testTransform((DStream<Object>)dstream);
            this.testTransformWith((DStream<Object>)dstream);
            this.testReduceByWindow((DStream<Object>)dstream);
            this.testReduceByKey((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testCombineByKey((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testReduceByKeyAndWindow((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testUpdateStateByKey((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testMapValues((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testFlatMapValues((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testTransform2(this.ssc(), (DStream<Object>)dstream);
        }, new Position("DStreamClosureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
    }
}

