/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler.rate;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.scheduler.rate.PIDRateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Entry;
import org.scalatest.Inspectors$;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.enablers.Collecting$;
import org.scalatest.enablers.InspectorAsserting$;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.dsl.BeWord;
import org.scalatest.matchers.dsl.ContainWord;
import org.scalatest.matchers.dsl.DefinedWord;
import org.scalatest.matchers.dsl.EmptyWord;
import org.scalatest.matchers.dsl.EndWithWord;
import org.scalatest.matchers.dsl.ExistWord;
import org.scalatest.matchers.dsl.FullyMatchWord;
import org.scalatest.matchers.dsl.HaveWord;
import org.scalatest.matchers.dsl.IncludeWord;
import org.scalatest.matchers.dsl.LengthWord;
import org.scalatest.matchers.dsl.MatchPatternWord;
import org.scalatest.matchers.dsl.MatcherFactory1;
import org.scalatest.matchers.dsl.MatcherWords;
import org.scalatest.matchers.dsl.NoExceptionWord;
import org.scalatest.matchers.dsl.NotWord;
import org.scalatest.matchers.dsl.ReadableWord;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAllElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfAllOfApplication;
import org.scalatest.matchers.dsl.ResultOfAnTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfDefinedAt;
import org.scalatest.matchers.dsl.ResultOfGreaterThanComparison;
import org.scalatest.matchers.dsl.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfInOrderApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfLessThanComparison;
import org.scalatest.matchers.dsl.ResultOfLessThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfMessageWordApplication;
import org.scalatest.matchers.dsl.ResultOfNoElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfNoneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOfTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfThrownByApplication;
import org.scalatest.matchers.dsl.SizeWord;
import org.scalatest.matchers.dsl.SortedWord;
import org.scalatest.matchers.dsl.StartWithWord;
import org.scalatest.matchers.dsl.WritableWord;
import org.scalatest.matchers.must.Matchers;
import org.scalatest.matchers.must.Matchers$AtLeastCollected$;
import org.scalatest.matchers.must.Matchers$AtMostCollected$;
import org.scalatest.matchers.must.Matchers$BetweenCollected$;
import org.scalatest.matchers.must.Matchers$ExactlyCollected$;
import org.scalatest.matchers.should.Matchers$;
import org.scalatest.verbs.CompileWord;
import org.scalatest.verbs.MustVerb;
import org.scalatest.verbs.TypeCheckWord;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005%2Aa\u0001\u0003\u0001#!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C\u0005K\t)\u0002+\u0013#SCR,Wi\u001d;j[\u0006$xN]*vSR,'BA\u0003\u0007\u0003\u0011\u0011\u0018\r^3\u000b\u0005\u001dA\u0011!C:dQ\u0016$W\u000f\\3s\u0015\tI!\"A\u0005tiJ,\u0017-\\5oO*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011b\u0003\u0005\u0002\u0014)5\t!\"\u0003\u0002\u0016\u0015\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\t5,8\u000f\u001e\u0006\u00037q\t\u0001\"\\1uG\",'o\u001d\u0006\u0003;9\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005}A\"\u0001C'bi\u000eDWM]:\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005!\u0011AF2sK\u0006$X\rR3gCVdG/R:uS6\fGo\u001c:\u0015\u0003\u0019\u0002\"aI\u0014\n\u0005!\"!\u0001\u0005)J\tJ\u000bG/Z#ti&l\u0017\r^8s\u0001")
public class PIDRateEstimatorSuite
extends SparkFunSuite
implements Matchers {
    private Matchers.KeyWord key;
    private Matchers.ValueWord value;
    private Matchers.AWord a;
    private Matchers.AnWord an;
    private Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private Matchers.RegexWord regex;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    private Explicitly.DecidedWord decided;
    private Explicitly.DeterminedWord determined;
    private Explicitly.TheAfterWord after;
    private FullyMatchWord fullyMatch;
    private StartWithWord startWith;
    private EndWithWord endWith;
    private IncludeWord include;
    private HaveWord have;
    private BeWord be;
    private ContainWord contain;
    private NotWord not;
    private LengthWord length;
    private SizeWord size;
    private SortedWord sorted;
    private DefinedWord defined;
    private ExistWord exist;
    private ReadableWord readable;
    private WritableWord writable;
    private EmptyWord empty;
    private CompileWord compile;
    private TypeCheckWord typeCheck;
    private MatchPatternWord matchPattern;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(Iterable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(Iterable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(Iterable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(Iterable<Object> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(Iterable<Object> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(Iterable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(Iterable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(Iterable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, Iterable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyMustWrapper<T> convertToAnyMustWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyMustWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringMustWrapper convertToStringMustWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringMustWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public MustVerb.StringMustWrapperForVerb convertToStringMustWrapperForVerb(String o, Position position) {
        return MustVerb.convertToStringMustWrapperForVerb$((MustVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected() {
        return this.org$scalatest$matchers$must$Matchers$$AllCollected;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected() {
        return this.org$scalatest$matchers$must$Matchers$$EveryCollected;
    }

    public Matchers$BetweenCollected$ org$scalatest$matchers$must$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$matchers$must$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$matchers$must$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected() {
        return this.org$scalatest$matchers$must$Matchers$$NoCollected;
    }

    public Matchers$ExactlyCollected$ org$scalatest$matchers$must$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper() {
        return this.org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$AllCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$AllCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$EveryCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$EveryCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$NoCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$NoCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$MustMethodHelper_$eq(Matchers.MustMethodHelperClass x$1) {
        this.org$scalatest$matchers$must$Matchers$$MustMethodHelper = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    private PIDRateEstimator createDefaultEstimator() {
        return new PIDRateEstimator(20L, 1.0, 0.0, 0.0, 10.0);
    }

    private final void org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    public static final /* synthetic */ Some $anonfun$new$27(int x) {
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)(x + 1) * 1000.0)));
    }

    public static final /* synthetic */ Some $anonfun$new$34(int x) {
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)(50 - x) * 1000.0)));
    }

    public static final /* synthetic */ Object $anonfun$new$42(PIDRateEstimatorSuite $this, List res$1, List sched$4, List speeds$1, double minRate$2, int n) {
        BoxedUnit boxedUnit;
        Matchers$.MODULE$.convertToAnyShouldWrapper(res$1.apply(n), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150), Prettifier$.MODULE$.default()).should($this.not()).be((Object)None$.MODULE$);
        if (BoxesRunTime.unboxToDouble((Object)((Option)res$1.apply(n)).get()) > 0.0 && BoxesRunTime.unboxToInt((Object)sched$4.apply(n)) > 0) {
            Matchers$.MODULE$.convertToAnyShouldWrapper(((Option)res$1.apply(n)).get(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152), Prettifier$.MODULE$.default()).should($this.be().$less(speeds$1.apply(n), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
            boxedUnit = Matchers$.MODULE$.convertToAnyShouldWrapper(((Option)res$1.apply(n)).get(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153), Prettifier$.MODULE$.default()).should($this.be().$greater$eq((Object)BoxesRunTime.boxToDouble((double)minRate$2), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public PIDRateEstimatorSuite() {
        Tolerance.$init$((Tolerance)this);
        MustVerb.$init$((MustVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.test("the right estimator is created", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf();
            conf.set("spark.streaming.backpressure.rateEstimator", "pid");
            RateEstimator pid = RateEstimator$.MODULE$.create(conf, Seconds$.MODULE$.apply(1L));
            return Matchers$.MODULE$.convertToAnyShouldWrapper(pid.getClass(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35), Prettifier$.MODULE$.default()).should(this.equal(PIDRateEstimator.class), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("estimator checks ranges", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.intercept((Function0 & Serializable)() -> new PIDRateEstimator(0L, 1.0, 2.0, 3.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            this.intercept((Function0 & Serializable)() -> new PIDRateEstimator(100L, -1.0, 2.0, 3.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            this.intercept((Function0 & Serializable)() -> new PIDRateEstimator(100L, 0.0, -1.0, 3.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            this.intercept((Function0 & Serializable)() -> new PIDRateEstimator(100L, 0.0, 0.0, -1.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            this.intercept((Function0 & Serializable)() -> new PIDRateEstimator(100L, 0.0, 0.0, 0.0, 0.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> new PIDRateEstimator(100L, 0.0, 0.0, 0.0, -10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("first estimate is None", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(0L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("second estimate is not None", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(10L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)BoxesRunTime.boxToInteger((int)1000))), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("no estimate when no time difference between successive calls", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(10L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74), Prettifier$.MODULE$.default()).shouldNot(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(10L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("no estimate when no records in previous batch", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(10L, 0L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(20L, -10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("no estimate when there is no processing delay", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(10L, 10L, 0L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)p.compute(20L, 10L, -10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("estimate is never less than min rate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            double minRate = 5.0;
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 1.0, 0.0, minRate);
            List times = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> x * 20);
            List elements = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
            List proc = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> 20);
            List sched = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> 100);
            List res = ((List)package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))));
            Matchers$.MODULE$.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return Matchers$.MODULE$.convertToAnyShouldWrapper(res.tail(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().fill(49, (Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToDouble((double)minRate)))), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("with no accumulated or positive error, |I| > 0, follow the processing speed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 1.0, 0.0, 10.0);
            List times = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> x * 20);
            List elements = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> (x + 1) * 20);
            List proc = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> 20);
            List sched = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            List res = ((List)package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))));
            Matchers$.MODULE$.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return Matchers$.MODULE$.convertToAnyShouldWrapper(res.tail(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().tabulate(50, (Function1 & Serializable)x -> PIDRateEstimatorSuite.$anonfun$new$27(BoxesRunTime.unboxToInt((Object)x))).tail()), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("with no accumulated but some positive error, |I| > 0, follow the processing speed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 1.0, 0.0, 10.0);
            List times = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> x * 20);
            List elements = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> (50 - x) * 20);
            List proc = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> 20);
            List sched = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0);
            List res = ((List)package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))));
            Matchers$.MODULE$.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return Matchers$.MODULE$.convertToAnyShouldWrapper(res.tail(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().tabulate(50, (Function1 & Serializable)x -> PIDRateEstimatorSuite.$anonfun$new$34(BoxesRunTime.unboxToInt((Object)x))).tail()), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("with some accumulated and some positive error, |I| > 0, stay below the processing speed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            double minRate = 10.0;
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 0.01, 0.0, minRate);
            List times = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> x * 20);
            Random rng = new Random();
            List elements = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> rng.nextInt(1000) + 1000);
            int procDelayMs = 20;
            List proc = (List)package$.MODULE$.List().fill(50, (Function0)(JFunction0.mcI.sp & Serializable)() -> procDelayMs);
            List sched = (List)package$.MODULE$.List().tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable)x -> rng.nextInt(19) + 1);
            List speeds = elements.map((Function1)(JFunction1.mcDI.sp & Serializable)x -> (double)x / (double)procDelayMs * (double)1000);
            List res = ((List)package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))));
            Matchers$.MODULE$.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            Inspectors$.MODULE$.forAll(package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$), (Function1 & Serializable)n -> PIDRateEstimatorSuite.$anonfun$new$42(this, res, sched, speeds, minRate, BoxesRunTime.unboxToInt((Object)n)), Collecting$.MODULE$.collectingNatureOfGenTraversable(), InspectorAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        Statics.releaseFence();
    }
}

