/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestInputStream;
import org.apache.spark.streaming.TestOutputStreamWithPartitions;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r]daB\u0011#!\u0003\r\ta\u000b\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006#\u0002!\t!\u0012\u0005\u0006%\u0002!\ta\u0015\u0005\t1\u0002A)\u0019!C\u0001\u000b\")\u0011\f\u0001C\u00015\")a\f\u0001C\u00015\")q\f\u0001C\u0001A\")A\r\u0001C\u0001A\"9Q\r\u0001b\u0001\n\u00031\u0007b\u00026\u0001\u0005\u0004%\ta\u001b\u0005\u0006m\u0002!\t!\u0010\u0005\u0006o\u0002!\t!\u0010\u0005\u0006q\u0002!\t%\u0010\u0005\u0006s\u0002!\t%\u0010\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007B\u0011\"a'\u0001#\u0003%\t!!(\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002:\"9\u0011Q \u0001\u0005\u0002\u0005}\b\"\u0003B\u0014\u0001E\u0005I\u0011\u0001B\u0015\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005gA\u0011B!\u0015\u0001#\u0003%\tAa\u0015\t\u000f\t]\u0003\u0001\"\u0001\u0003Z!9!\u0011\u0010\u0001\u0005\u0002\tm\u0004\"\u0003BV\u0001E\u0005I\u0011\u0001BW\u0011\u001d\u0011I\b\u0001C\u0001\u0005oCqA!\u001f\u0001\t\u0003\u0011I\u000fC\u0004\u0003z\u0001!\taa\u000b\t\u001b\r=\u0004\u0001%A\u0002\u0002\u0003%I!PB9\u00115\u0019\u0019\b\u0001I\u0001\u0004\u0003\u0005I\u0011B\u001f\u0004v\tiA+Z:u'VLG/\u001a\"bg\u0016T!a\t\u0013\u0002\u0013M$(/Z1nS:<'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\f\u00197!\tic&D\u0001%\u0013\tyCEA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003cQj\u0011A\r\u0006\u0003g!\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005U\u0012$A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0013\u0002\u0011%tG/\u001a:oC2L!a\u000f\u001d\u0003\u000f1{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0005+:LG/A\u0005ge\u0006lWm^8sWV\ta\t\u0005\u0002H\u001d:\u0011\u0001\n\u0014\t\u0003\u0013\u0002k\u0011A\u0013\u0006\u0003\u0017*\na\u0001\u0010:p_Rt\u0014BA'A\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\u0003\u0015AB7bgR,'/A\u0007cCR\u001c\u0007\u000eR;sCRLwN\\\u000b\u0002)B\u0011QKV\u0007\u0002E%\u0011qK\t\u0002\t\tV\u0014\u0018\r^5p]\u0006i1\r[3dWB|\u0017N\u001c;ESJ\f!C\\;n\u0013:\u0004X\u000f\u001e)beRLG/[8ogV\t1\f\u0005\u0002@9&\u0011Q\f\u0011\u0002\u0004\u0013:$\u0018!E7bq^\u000b\u0017\u000e\u001e+j[\u0016l\u0015\u000e\u001c7jg\u0006qQo]3NC:,\u0018\r\\\"m_\u000e\\W#A1\u0011\u0005}\u0012\u0017BA2A\u0005\u001d\u0011un\u001c7fC:\fA\"Y2uk\u0006dG._,bSR\fAaY8oMV\tq\r\u0005\u0002.Q&\u0011\u0011\u000e\n\u0002\n'B\f'o[\"p]\u001a\f\u0011#\u001a<f]R,\u0018\r\u001c7z)&lWm\\;u+\u0005a\u0007CA7t\u001d\tq\u0017/D\u0001p\u0015\t\u0001('\u0001\u0006d_:\u001cWO\u001d:f]RL!A]8\u0002+A\u000bG/[3oG\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]&\u0011A/\u001e\u0002\b)&lWm\\;u\u0015\t\u0011x.\u0001\bcK\u001a|'/\u001a$v]\u000e$\u0018n\u001c8\u0002\u001b\u00054G/\u001a:Gk:\u001cG/[8o\u0003)\u0011WMZ8sK\u0016\u000b7\r[\u0001\nC\u001a$XM]#bG\"\fAc^5uQN#(/Z1nS:<7i\u001c8uKb$Xc\u0001?\u0002\u0002Q\u0019Q0a\t\u0015\u0007y\f\u0019\u0002E\u0002\u0000\u0003\u0003a\u0001\u0001B\u0004\u0002\u0004A\u0011\r!!\u0002\u0003\u0003I\u000bB!a\u0002\u0002\u000eA\u0019q(!\u0003\n\u0007\u0005-\u0001IA\u0004O_RD\u0017N\\4\u0011\u0007}\ny!C\u0002\u0002\u0012\u0001\u00131!\u00118z\u0011\u001d\t)\u0002\u0005a\u0001\u0003/\tQA\u00197pG.\u0004baPA\r\u0003;q\u0018bAA\u000e\u0001\nIa)\u001e8di&|g.\r\t\u0004+\u0006}\u0011bAA\u0011E\t\u00012\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u0003K\u0001\u0002\u0019AA\u000f\u0003\r\u00198oY\u0001\u000fo&$\b\u000eV3tiN+'O^3s+\u0011\tY#!\r\u0015\t\u00055\u0012Q\b\u000b\u0005\u0003_\t\u0019\u0004E\u0002\u0000\u0003c!q!a\u0001\u0012\u0005\u0004\t)\u0001C\u0004\u0002\u0016E\u0001\r!!\u000e\u0011\u000f}\nI\"a\u000e\u00020A\u0019Q+!\u000f\n\u0007\u0005m\"E\u0001\u0006UKN$8+\u001a:wKJDq!a\u0010\u0012\u0001\u0004\t9$\u0001\u0006uKN$8+\u001a:wKJ\fAb]3ukB\u001cFO]3b[N,b!!\u0012\u0002\\\u0005\u001dD\u0003CA$\u0003W\n\u0019)a&\u0015\r\u0005u\u0011\u0011JA0\u0011%\tYEEA\u0001\u0002\b\ti%\u0001\u0006fm&$WM\\2fIQ\u0002b!a\u0014\u0002V\u0005eSBAA)\u0015\r\t\u0019\u0006Q\u0001\be\u00164G.Z2u\u0013\u0011\t9&!\u0015\u0003\u0011\rc\u0017m]:UC\u001e\u00042a`A.\t\u001d\tiF\u0005b\u0001\u0003\u000b\u0011\u0011!\u0016\u0005\n\u0003C\u0012\u0012\u0011!a\u0002\u0003G\n!\"\u001a<jI\u0016t7-\u001a\u00136!\u0019\ty%!\u0016\u0002fA\u0019q0a\u001a\u0005\u000f\u0005%$C1\u0001\u0002\u0006\t\ta\u000bC\u0004\u0002nI\u0001\r!a\u001c\u0002\u000b%t\u0007/\u001e;\u0011\r\u0005E\u00141PAA\u001d\u0011\t\u0019(a\u001e\u000f\u0007%\u000b)(C\u0001B\u0013\r\tI\bQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti(a \u0003\u0007M+\u0017OC\u0002\u0002z\u0001\u0003b!!\u001d\u0002|\u0005e\u0003bBAC%\u0001\u0007\u0011qQ\u0001\n_B,'/\u0019;j_:\u0004raPA\r\u0003\u0013\u000b)\n\u0005\u0004\u0002\f\u0006E\u0015\u0011L\u0007\u0003\u0003\u001bS1!a$#\u0003\u001d!7\u000f\u001e:fC6LA!a%\u0002\u000e\n9Ai\u0015;sK\u0006l\u0007CBAF\u0003#\u000b)\u0007\u0003\u0005\u0002\u001aJ\u0001\n\u00111\u0001\\\u00035qW/\u001c)beRLG/[8og\u000612/\u001a;vaN#(/Z1ng\u0012\"WMZ1vYR$3'\u0006\u0004\u0002 \u0006U\u0016qW\u000b\u0003\u0003CS3aWARW\t\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u0013Ut7\r[3dW\u0016$'bAAX\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0016\u0011\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA/'\t\u0007\u0011Q\u0001\u0003\b\u0003S\u001a\"\u0019AA\u0003+!\tY,a2\u0002R\u0006mG\u0003CA_\u0003?\f9/a<\u0015\u0011\u0005u\u0011qXAe\u0003'D\u0011\"!1\u0015\u0003\u0003\u0005\u001d!a1\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007\u0005\u0004\u0002P\u0005U\u0013Q\u0019\t\u0004\u007f\u0006\u001dGaBA/)\t\u0007\u0011Q\u0001\u0005\n\u0003\u0017$\u0012\u0011!a\u0002\u0003\u001b\f!\"\u001a<jI\u0016t7-\u001a\u00138!\u0019\ty%!\u0016\u0002PB\u0019q0!5\u0005\u000f\u0005%DC1\u0001\u0002\u0006!I\u0011Q\u001b\u000b\u0002\u0002\u0003\u000f\u0011q[\u0001\u000bKZLG-\u001a8dK\u0012B\u0004CBA(\u0003+\nI\u000eE\u0002\u0000\u00037$q!!8\u0015\u0005\u0004\t)AA\u0001X\u0011\u001d\t\t\u000f\u0006a\u0001\u0003G\fa!\u001b8qkR\f\u0004CBA9\u0003w\n)\u000f\u0005\u0004\u0002r\u0005m\u0014Q\u0019\u0005\b\u0003S$\u0002\u0019AAv\u0003\u0019Ig\u000e];ueA1\u0011\u0011OA>\u0003[\u0004b!!\u001d\u0002|\u0005=\u0007bBAC)\u0001\u0007\u0011\u0011\u001f\t\n\u007f\u0005M\u0018q_A}\u0003wL1!!>A\u0005%1UO\\2uS>t'\u0007\u0005\u0004\u0002\f\u0006E\u0015Q\u0019\t\u0007\u0003\u0017\u000b\t*a4\u0011\r\u0005-\u0015\u0011SAm\u0003)\u0011XO\\*ue\u0016\fWn]\u000b\u0005\u0005\u0003\u0011Y\u0001\u0006\u0006\u0003\u0004\tM!Q\u0003B\r\u0005;!BA!\u0002\u0003\u000eA1\u0011\u0011OA>\u0005\u000f\u0001b!!\u001d\u0002|\t%\u0001cA@\u0003\f\u00119\u0011\u0011N\u000bC\u0002\u0005\u0015\u0001\"\u0003B\b+\u0005\u0005\t9\u0001B\t\u0003))g/\u001b3f]\u000e,G%\u000f\t\u0007\u0003\u001f\n)F!\u0003\t\u000f\u0005\u0015R\u00031\u0001\u0002\u001e!1!qC\u000bA\u0002m\u000b!B\\;n\u0005\u0006$8\r[3t\u0011\u0019\u0011Y\"\u0006a\u00017\u0006\tb.^7FqB,7\r^3e\u001fV$\b/\u001e;\t\u0013\t}Q\u0003%AA\u0002\t\u0005\u0012a\u00029sKN#x\u000e\u001d\t\u0005\u007f\t\rb(C\u0002\u0003&\u0001\u0013\u0011BR;oGRLwN\u001c\u0019\u0002)I,hn\u0015;sK\u0006l7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011YCa\f\u0016\u0005\t5\"\u0006\u0002B\u0011\u0003G#q!!\u001b\u0017\u0005\u0004\t)!\u0001\rsk:\u001cFO]3b[N<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]N,BA!\u000e\u0003BQQ!q\u0007B%\u0005\u0017\u0012iEa\u0014\u0015\t\te\"1\t\t\u0007\u0003c\nYHa\u000f\u0011\r\u0005E\u00141\u0010B\u001f!\u0019\t\t(a\u001f\u0003@A\u0019qP!\u0011\u0005\u000f\u0005%tC1\u0001\u0002\u0006!I!QI\f\u0002\u0002\u0003\u000f!qI\u0001\fKZLG-\u001a8dK\u0012\n\u0004\u0007\u0005\u0004\u0002P\u0005U#q\b\u0005\b\u0003K9\u0002\u0019AA\u000f\u0011\u0019\u00119b\u0006a\u00017\"1!1D\fA\u0002mC\u0011Ba\b\u0018!\u0003\u0005\rA!\t\u0002EI,hn\u0015;sK\u0006l7oV5uQB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011YC!\u0016\u0005\u000f\u0005%\u0004D1\u0001\u0002\u0006\u0005aa/\u001a:jMf|U\u000f\u001e9viV!!1\fB4)!\u0011iF!\u001b\u0003r\tUDc\u0001 \u0003`!I!\u0011M\r\u0002\u0002\u0003\u000f!1M\u0001\fKZLG-\u001a8dK\u0012\n\u0014\u0007\u0005\u0004\u0002P\u0005U#Q\r\t\u0004\u007f\n\u001dDaBA53\t\u0007\u0011Q\u0001\u0005\b\u0005WJ\u0002\u0019\u0001B7\u0003\u0019yW\u000f\u001e9viB1\u0011\u0011OA>\u0005_\u0002b!!\u001d\u0002|\t\u0015\u0004b\u0002B:3\u0001\u0007!QN\u0001\u000fKb\u0004Xm\u0019;fI>+H\u000f];u\u0011\u0019\u00119(\u0007a\u0001C\u00061Qo]3TKR\fQ\u0002^3ti>\u0003XM]1uS>tWC\u0002B?\u0005\u0013\u0013\u0019\n\u0006\u0006\u0003\u0000\tU%1\u0014BR\u0005S#RA\u0010BA\u0005\u0017C\u0011Ba!\u001b\u0003\u0003\u0005\u001dA!\"\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013G\r\t\u0007\u0003\u001f\n)Fa\"\u0011\u0007}\u0014I\tB\u0004\u0002^i\u0011\r!!\u0002\t\u0013\t5%$!AA\u0004\t=\u0015aC3wS\u0012,gnY3%cM\u0002b!a\u0014\u0002V\tE\u0005cA@\u0003\u0014\u00129\u0011\u0011\u000e\u000eC\u0002\u0005\u0015\u0001bBA75\u0001\u0007!q\u0013\t\u0007\u0003c\nYH!'\u0011\r\u0005E\u00141\u0010BD\u0011\u001d\t)I\u0007a\u0001\u0005;\u0003raPA\r\u0005?\u0013\t\u000b\u0005\u0004\u0002\f\u0006E%q\u0011\t\u0007\u0003\u0017\u000b\tJ!%\t\u000f\tM$\u00041\u0001\u0003&B1\u0011\u0011OA>\u0005O\u0003b!!\u001d\u0002|\tE\u0005\u0002\u0003B<5A\u0005\t\u0019A1\u0002/Q,7\u000f^(qKJ\fG/[8oI\u0011,g-Y;mi\u0012\"TC\u0002BX\u0005g\u0013),\u0006\u0002\u00032*\u001a\u0011-a)\u0005\u000f\u0005u3D1\u0001\u0002\u0006\u00119\u0011\u0011N\u000eC\u0002\u0005\u0015QC\u0002B]\u0005\u000b\u0014y\r\u0006\u0007\u0003<\nE'q\u001bBp\u0005K\u00149\u000fF\u0003?\u0005{\u00139\rC\u0005\u0003@r\t\t\u0011q\u0001\u0003B\u0006YQM^5eK:\u001cW\rJ\u00195!\u0019\ty%!\u0016\u0003DB\u0019qP!2\u0005\u000f\u0005uCD1\u0001\u0002\u0006!I!\u0011\u001a\u000f\u0002\u0002\u0003\u000f!1Z\u0001\fKZLG-\u001a8dK\u0012\nT\u0007\u0005\u0004\u0002P\u0005U#Q\u001a\t\u0004\u007f\n=GaBA59\t\u0007\u0011Q\u0001\u0005\b\u0003[b\u0002\u0019\u0001Bj!\u0019\t\t(a\u001f\u0003VB1\u0011\u0011OA>\u0005\u0007Dq!!\"\u001d\u0001\u0004\u0011I\u000eE\u0004@\u00033\u0011YN!8\u0011\r\u0005-\u0015\u0011\u0013Bb!\u0019\tY)!%\u0003N\"9!1\u000f\u000fA\u0002\t\u0005\bCBA9\u0003w\u0012\u0019\u000f\u0005\u0004\u0002r\u0005m$Q\u001a\u0005\u0007\u0005/a\u0002\u0019A.\t\r\t]D\u00041\u0001b+!\u0011YOa>\u0004\u0002\r-A\u0003\u0004Bw\u0007\u001b\u0019\u0019b!\u0007\u0004$\r%Bc\u0002 \u0003p\ne81\u0001\u0005\n\u0005cl\u0012\u0011!a\u0002\u0005g\f1\"\u001a<jI\u0016t7-\u001a\u00132mA1\u0011qJA+\u0005k\u00042a B|\t\u001d\ti&\bb\u0001\u0003\u000bA\u0011Ba?\u001e\u0003\u0003\u0005\u001dA!@\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013g\u000e\t\u0007\u0003\u001f\n)Fa@\u0011\u0007}\u001c\t\u0001B\u0004\u0002ju\u0011\r!!\u0002\t\u0013\r\u0015Q$!AA\u0004\r\u001d\u0011aC3wS\u0012,gnY3%ca\u0002b!a\u0014\u0002V\r%\u0001cA@\u0004\f\u00119\u0011Q\\\u000fC\u0002\u0005\u0015\u0001bBAq;\u0001\u00071q\u0002\t\u0007\u0003c\nYh!\u0005\u0011\r\u0005E\u00141\u0010B{\u0011\u001d\tI/\ba\u0001\u0007+\u0001b!!\u001d\u0002|\r]\u0001CBA9\u0003w\u0012y\u0010C\u0004\u0002\u0006v\u0001\raa\u0007\u0011\u0013}\n\u0019p!\b\u0004 \r\u0005\u0002CBAF\u0003#\u0013)\u0010\u0005\u0004\u0002\f\u0006E%q \t\u0007\u0003\u0017\u000b\tj!\u0003\t\u000f\tMT\u00041\u0001\u0004&A1\u0011\u0011OA>\u0007O\u0001b!!\u001d\u0002|\r%\u0001B\u0002B<;\u0001\u0007\u0011-\u0006\u0005\u0004.\re21IB')9\u0019yca\u0014\u0004V\rm3QMB6\u0007[\"rAPB\u0019\u0007w\u0019)\u0005C\u0005\u00044y\t\t\u0011q\u0001\u00046\u0005YQM^5eK:\u001cW\rJ\u0019:!\u0019\ty%!\u0016\u00048A\u0019qp!\u000f\u0005\u000f\u0005ucD1\u0001\u0002\u0006!I1Q\b\u0010\u0002\u0002\u0003\u000f1qH\u0001\fKZLG-\u001a8dK\u0012\u0012\u0004\u0007\u0005\u0004\u0002P\u0005U3\u0011\t\t\u0004\u007f\u000e\rCaBA5=\t\u0007\u0011Q\u0001\u0005\n\u0007\u000fr\u0012\u0011!a\u0002\u0007\u0013\n1\"\u001a<jI\u0016t7-\u001a\u00133cA1\u0011qJA+\u0007\u0017\u00022a`B'\t\u001d\tiN\bb\u0001\u0003\u000bAq!!9\u001f\u0001\u0004\u0019\t\u0006\u0005\u0004\u0002r\u0005m41\u000b\t\u0007\u0003c\nYha\u000e\t\u000f\u0005%h\u00041\u0001\u0004XA1\u0011\u0011OA>\u00073\u0002b!!\u001d\u0002|\r\u0005\u0003bBAC=\u0001\u00071Q\f\t\n\u007f\u0005M8qLB1\u0007G\u0002b!a#\u0002\u0012\u000e]\u0002CBAF\u0003#\u001b\t\u0005\u0005\u0004\u0002\f\u0006E51\n\u0005\b\u0005gr\u0002\u0019AB4!\u0019\t\t(a\u001f\u0004jA1\u0011\u0011OA>\u0007\u0017BaAa\u0006\u001f\u0001\u0004Y\u0006B\u0002B<=\u0001\u0007\u0011-\u0001\ttkB,'\u000f\n2fM>\u0014X-R1dQ&\u0011\u0001\u0010N\u0001\u0010gV\u0004XM\u001d\u0013bMR,'/R1dQ&\u0011\u0011\u0010\u000e")
public interface TestSuiteBase
extends BeforeAndAfterEach,
Logging {
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf var1);

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout var1);

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach();

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach();

    public static /* synthetic */ String framework$(TestSuiteBase $this) {
        return $this.framework();
    }

    default public String framework() {
        return this.getClass().getSimpleName();
    }

    public static /* synthetic */ String master$(TestSuiteBase $this) {
        return $this.master();
    }

    default public String master() {
        return "local[2]";
    }

    public static /* synthetic */ Duration batchDuration$(TestSuiteBase $this) {
        return $this.batchDuration();
    }

    default public Duration batchDuration() {
        return Seconds$.MODULE$.apply(1L);
    }

    public static /* synthetic */ String checkpointDir$(TestSuiteBase $this) {
        return $this.checkpointDir();
    }

    default public String checkpointDir() {
        File dir = Utils$.MODULE$.createTempDir();
        this.logDebug((Function0 & Serializable)() -> new StringBuilder(15).append("checkpointDir: ").append(dir).toString());
        return dir.toString();
    }

    public static /* synthetic */ int numInputPartitions$(TestSuiteBase $this) {
        return $this.numInputPartitions();
    }

    default public int numInputPartitions() {
        return 2;
    }

    public static /* synthetic */ int maxWaitTimeMillis$(TestSuiteBase $this) {
        return $this.maxWaitTimeMillis();
    }

    default public int maxWaitTimeMillis() {
        return 10000;
    }

    public static /* synthetic */ boolean useManualClock$(TestSuiteBase $this) {
        return $this.useManualClock();
    }

    default public boolean useManualClock() {
        return true;
    }

    public static /* synthetic */ boolean actuallyWait$(TestSuiteBase $this) {
        return $this.actuallyWait();
    }

    default public boolean actuallyWait() {
        return false;
    }

    public SparkConf conf();

    public PatienceConfiguration.Timeout eventuallyTimeout();

    public static /* synthetic */ void beforeFunction$(TestSuiteBase $this) {
        $this.beforeFunction();
    }

    default public void beforeFunction() {
        if (this.useManualClock()) {
            this.logInfo((Function0 & Serializable)() -> "Using manual clock");
            this.conf().set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
        } else {
            this.logInfo((Function0 & Serializable)() -> "Using real clock");
            this.conf().set("spark.streaming.clock", "org.apache.spark.util.SystemClock");
        }
    }

    public static /* synthetic */ void afterFunction$(TestSuiteBase $this) {
        $this.afterFunction();
    }

    default public void afterFunction() {
        System.clearProperty("spark.streaming.clock");
    }

    public static /* synthetic */ void beforeEach$(TestSuiteBase $this) {
        $this.beforeEach();
    }

    default public void beforeEach() {
        this.org$apache$spark$streaming$TestSuiteBase$$super$beforeEach();
        this.beforeFunction();
    }

    public static /* synthetic */ void afterEach$(TestSuiteBase $this) {
        $this.afterEach();
    }

    default public void afterEach() {
        try {
            this.afterFunction();
        }
        finally {
            this.org$apache$spark$streaming$TestSuiteBase$$super$afterEach();
        }
    }

    public static /* synthetic */ Object withStreamingContext$(TestSuiteBase $this, StreamingContext ssc, Function1 block) {
        return $this.withStreamingContext(ssc, block);
    }

    default public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        Object object;
        try {
            object = block.apply((Object)ssc);
        }
        finally {
            LocalStreamingContext$.MODULE$.stop(ssc, true);
        }
        return (R)object;
    }

    public static /* synthetic */ Object withTestServer$(TestSuiteBase $this, TestServer testServer, Function1 block) {
        return $this.withTestServer(testServer, block);
    }

    default public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        Object object;
        try {
            object = block.apply((Object)testServer);
        }
        catch (Throwable throwable) {
            try {
                testServer.stop();
            }
            catch (Exception e) {
                this.logError((Function0 & Serializable)() -> "Error stopping TestServer", e);
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            testServer.stop();
        }
        catch (Exception e) {
            this.logError((Function0 & Serializable)() -> "Error stopping TestServer", e);
        }
        return (R)object2;
    }

    public static /* synthetic */ StreamingContext setupStreams$(TestSuiteBase $this, Seq input, Function1 operation, int numPartitions, ClassTag evidence$4, ClassTag evidence$5) {
        return $this.setupStreams(input, operation, numPartitions, evidence$4, evidence$5);
    }

    default public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        StreamingContext ssc = new StreamingContext(this.conf(), this.batchDuration());
        if (this.checkpointDir() != null) {
            ssc.checkpoint(this.checkpointDir());
        }
        TestInputStream<U> inputStream = new TestInputStream<U>(ssc, input, numPartitions, evidence$4);
        DStream operatedStream = (DStream)operation.apply(inputStream);
        TestOutputStreamWithPartitions outputStream = new TestOutputStreamWithPartitions(operatedStream, new ConcurrentLinkedQueue(), evidence$5);
        outputStream.register();
        return ssc;
    }

    public static /* synthetic */ StreamingContext setupStreams$(TestSuiteBase $this, Seq input1, Seq input2, Function2 operation, ClassTag evidence$6, ClassTag evidence$7, ClassTag evidence$8) {
        return $this.setupStreams(input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    default public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        StreamingContext ssc = new StreamingContext(this.conf(), this.batchDuration());
        if (this.checkpointDir() != null) {
            ssc.checkpoint(this.checkpointDir());
        }
        TestInputStream<U> inputStream1 = new TestInputStream<U>(ssc, input1, this.numInputPartitions(), evidence$6);
        TestInputStream<V> inputStream2 = new TestInputStream<V>(ssc, input2, this.numInputPartitions(), evidence$7);
        DStream operatedStream = (DStream)operation.apply(inputStream1, inputStream2);
        TestOutputStreamWithPartitions outputStream = new TestOutputStreamWithPartitions(operatedStream, new ConcurrentLinkedQueue(), evidence$8);
        outputStream.register();
        return ssc;
    }

    public static /* synthetic */ int setupStreams$default$3$(TestSuiteBase $this) {
        return $this.setupStreams$default$3();
    }

    default public <U, V> int setupStreams$default$3() {
        return this.numInputPartitions();
    }

    public static /* synthetic */ Seq runStreams$(TestSuiteBase $this, StreamingContext ssc, int numBatches, int numExpectedOutput, Function0 preStop, ClassTag evidence$9) {
        return $this.runStreams(ssc, numBatches, numExpectedOutput, (Function0<BoxedUnit>)preStop, evidence$9);
    }

    default public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return (Seq)this.runStreamsWithPartitions(ssc, numBatches, numExpectedOutput, preStop, evidence$9).map((Function1 & Serializable)x$2 -> ((Seq)x$2.flatten(Predef$.MODULE$.$conforms())).toSeq());
    }

    public static /* synthetic */ Function0 runStreams$default$4$(TestSuiteBase $this) {
        return $this.runStreams$default$4();
    }

    default public <V> Function0<BoxedUnit> runStreams$default$4() {
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    public static /* synthetic */ Seq runStreamsWithPartitions$(TestSuiteBase $this, StreamingContext ssc, int numBatches, int numExpectedOutput, Function0 preStop, ClassTag evidence$10) {
        return $this.runStreamsWithPartitions(ssc, numBatches, numExpectedOutput, (Function0<BoxedUnit>)preStop, evidence$10);
    }

    default public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        int $org_scalatest_assert_macro_left = numBatches;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Number of batches to run stream computation is zero", Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        int $org_scalatest_assert_macro_left2 = numExpectedOutput;
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(41).append("Number of expected outputs after ").append(numBatches).append(" is zero").toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(35).append("numBatches = ").append(numBatches).append(", numExpectedOutput = ").append(numExpectedOutput).toString());
        TestOutputStreamWithPartitions outputStream = (TestOutputStreamWithPartitions)((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestSuiteBase.$anonfun$runStreamsWithPartitions$2(x$3))))));
        ConcurrentLinkedQueue output = outputStream.output();
        try {
            ssc.start();
            ManualClock clock = (ManualClock)ssc.scheduler().clock();
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(32).append("Manual clock before advancing = ").append(clock.getTimeMillis()).toString());
            if (this.actuallyWait()) {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numBatches).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    this.logInfo((Function0 & Serializable)() -> new StringBuilder(21).append("Actually waiting for ").append(this.batchDuration()).toString());
                    clock.advance(this.batchDuration().milliseconds());
                    Thread.sleep(this.batchDuration().milliseconds());
                });
            } else {
                clock.advance((long)numBatches * this.batchDuration().milliseconds());
            }
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(31).append("Manual clock after advancing = ").append(clock.getTimeMillis()).toString());
            long startTimeNs = System.nanoTime();
            while (output.size() < numExpectedOutput && TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs) < (long)this.maxWaitTimeMillis()) {
                this.logInfo((Function0 & Serializable)() -> new StringBuilder(36).append("output.size = ").append(output.size()).append(", numExpectedOutput = ").append(numExpectedOutput).toString());
                ssc.awaitTerminationOrTimeout(50L);
            }
            long timeTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(33).append("Output generated in ").append(timeTaken).append(" milliseconds").toString());
            ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(output).asScala()).foreach((Function1 & Serializable)x -> {
                this.logInfo((Function0 & Serializable)() -> new StringBuilder(2).append("[").append(x.mkString(",")).append("]").toString());
                return BoxedUnit.UNIT;
            });
            long $org_scalatest_assert_macro_left3 = timeTaken;
            int $org_scalatest_assert_macro_right3 = this.maxWaitTimeMillis();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(29).append("Operation timed out after ").append(timeTaken).append(" ms").toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = ((TripleEquals)this).convertToEqualizer((Object)BoxesRunTime.boxToInteger((int)output.size()));
            int $org_scalatest_assert_macro_right4 = numExpectedOutput;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Unexpected number of outputs generated", Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            Thread.sleep(100L);
            preStop.apply$mcV$sp();
        }
        finally {
            ssc.stop(true);
        }
        return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(output).asScala()).toSeq();
    }

    public static /* synthetic */ Function0 runStreamsWithPartitions$default$4$(TestSuiteBase $this) {
        return $this.runStreamsWithPartitions$default$4();
    }

    default public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    public static /* synthetic */ void verifyOutput$(TestSuiteBase $this, Seq output, Seq expectedOutput, boolean useSet, ClassTag evidence$11) {
        $this.verifyOutput(output, expectedOutput, useSet, evidence$11);
    }

    default public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        this.logInfo((Function0 & Serializable)() -> "--------------------------------");
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(14).append("output.size = ").append(output.size()).toString());
        this.logInfo((Function0 & Serializable)() -> "output");
        output.foreach((Function1 & Serializable)x -> {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(2).append("[").append(x.mkString(",")).append("]").toString());
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(23).append("expected output.size = ").append(expectedOutput.size()).toString());
        this.logInfo((Function0 & Serializable)() -> "expected output");
        expectedOutput.foreach((Function1 & Serializable)x -> {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(2).append("[").append(x.mkString(",")).append("]").toString());
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0 & Serializable)() -> "--------------------------------");
        output.indices().foreach((Function1 & Serializable)i -> TestSuiteBase.$anonfun$verifyOutput$11(this, useSet, output, expectedOutput, BoxesRunTime.unboxToInt((Object)i)));
        this.logInfo((Function0 & Serializable)() -> "Output verified successfully");
    }

    public static /* synthetic */ void testOperation$(TestSuiteBase $this, Seq input, Function1 operation, Seq expectedOutput, boolean useSet, ClassTag evidence$12, ClassTag evidence$13) {
        $this.testOperation(input, operation, expectedOutput, useSet, evidence$12, evidence$13);
    }

    default public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        this.testOperation(input, operation, expectedOutput, -1, useSet, evidence$12, evidence$13);
    }

    public static /* synthetic */ void testOperation$(TestSuiteBase $this, Seq input, Function1 operation, Seq expectedOutput, int numBatches, boolean useSet, ClassTag evidence$14, ClassTag evidence$15) {
        $this.testOperation(input, operation, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    default public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        int numBatches_ = numBatches > 0 ? numBatches : expectedOutput.size();
        this.withStreamingContext(this.setupStreams(input, operation, this.setupStreams$default$3(), evidence$14, evidence$15), (Function1 & Serializable)ssc -> {
            TestSuiteBase.$anonfun$testOperation$1(this, numBatches_, expectedOutput, evidence$15, useSet, ssc);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void testOperation$(TestSuiteBase $this, Seq input1, Seq input2, Function2 operation, Seq expectedOutput, boolean useSet, ClassTag evidence$16, ClassTag evidence$17, ClassTag evidence$18) {
        $this.testOperation(input1, input2, operation, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    default public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        this.testOperation(input1, input2, operation, expectedOutput, -1, useSet, evidence$16, evidence$17, evidence$18);
    }

    public static /* synthetic */ void testOperation$(TestSuiteBase $this, Seq input1, Seq input2, Function2 operation, Seq expectedOutput, int numBatches, boolean useSet, ClassTag evidence$19, ClassTag evidence$20, ClassTag evidence$21) {
        $this.testOperation(input1, input2, operation, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    default public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        int numBatches_ = numBatches > 0 ? numBatches : expectedOutput.size();
        this.withStreamingContext(this.setupStreams(input1, input2, operation, evidence$19, evidence$20, evidence$21), (Function1 & Serializable)ssc -> {
            TestSuiteBase.$anonfun$testOperation$2(this, numBatches_, expectedOutput, evidence$21, useSet, ssc);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean testOperation$default$4$(TestSuiteBase $this) {
        return $this.testOperation$default$4();
    }

    default public <U, V> boolean testOperation$default$4() {
        return false;
    }

    public static /* synthetic */ boolean $anonfun$runStreamsWithPartitions$2(DStream x$3) {
        return x$3 instanceof TestOutputStreamWithPartitions;
    }

    public static /* synthetic */ Assertion $anonfun$verifyOutput$11(TestSuiteBase $this, boolean useSet$1, Seq output$4, Seq expectedOutput$1, int i) {
        Assertion assertion;
        if (useSet$1) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)((IterableOnceOps)output$4.apply(i)).toSet());
            Set $org_scalatest_assert_macro_right = ((IterableOnceOps)expectedOutput$1.apply(i)).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(0).append("Set comparison failed\n").append(new StringBuilder(27).append("Expected output (").append(expectedOutput$1.size()).append(" items):\n").append(expectedOutput$1.mkString("\n")).append("\n").toString()).append(new StringBuilder(27).append("Generated output (").append(output$4.size()).append(" items): ").append(output$4.mkString("\n")).toString()).toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        } else {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)((IterableOnceOps)output$4.apply(i)).toList());
            List $org_scalatest_assert_macro_right = ((IterableOnceOps)expectedOutput$1.apply(i)).toList();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(0).append("Ordered list comparison failed\n").append(new StringBuilder(27).append("Expected output (").append(expectedOutput$1.size()).append(" items):\n").append(expectedOutput$1.mkString("\n")).append("\n").toString()).append(new StringBuilder(27).append("Generated output (").append(output$4.size()).append(" items): ").append(output$4.mkString("\n")).toString()).toString(), Prettifier$.MODULE$.default(), new Position("TestSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        }
        return assertion;
    }

    public static /* synthetic */ void $anonfun$testOperation$1(TestSuiteBase $this, int numBatches_$1, Seq expectedOutput$2, ClassTag evidence$15$1, boolean useSet$2, StreamingContext ssc) {
        Seq output = $this.runStreams(ssc, numBatches_$1, expectedOutput$2.size(), $this.runStreams$default$4(), evidence$15$1);
        $this.verifyOutput(output.toSeq(), expectedOutput$2, useSet$2, evidence$15$1);
    }

    public static /* synthetic */ void $anonfun$testOperation$2(TestSuiteBase $this, int numBatches_$2, Seq expectedOutput$3, ClassTag evidence$21$1, boolean useSet$3, StreamingContext ssc) {
        Seq output = $this.runStreams(ssc, numBatches_$2, expectedOutput$3.size(), $this.runStreams$default$4(), evidence$21$1);
        $this.verifyOutput(output.toSeq(), expectedOutput$3, useSet$3, evidence$21$1);
    }

    public static void $init$(TestSuiteBase $this) {
        $this.org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(new SparkConf().setMaster($this.master()).setAppName($this.framework()));
        $this.org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(Eventually$.MODULE$.timeout(Span$.MODULE$.apply(10L, (Units)org.scalatest.time.Seconds$.MODULE$)));
    }
}

