/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.StreamingListenerStreamingStarted;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005E4A\u0001F\u000b\u0001=!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0004/\u0001\u0001\u0007I\u0011B\u0018\t\u000fM\u0002\u0001\u0019!C\u0005i!1!\b\u0001Q!\nABqa\u000f\u0001A\u0002\u0013%q\u0006C\u0004=\u0001\u0001\u0007I\u0011B\u001f\t\r}\u0002\u0001\u0015)\u00031\u0011\u001d\u0001\u0005\u00011A\u0005\n\u0005Cq!\u0012\u0001A\u0002\u0013%a\t\u0003\u0004I\u0001\u0001\u0006KA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019q\u0005\u0001)A\u0005\u0017\")Q\u000b\u0001C\u0001_!)a\u000b\u0001C\u0001_!)q\u000b\u0001C\u0001\u0003\")\u0001\f\u0001C\u00013\")A\r\u0001C\u0001K\")\u0011\u000e\u0001C\u0005U\na!)\u0019;dQ\u000e{WO\u001c;fe*\u0011acF\u0001\ngR\u0014X-Y7j]\u001eT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0004gN\u001c\u0007CA\u0014)\u001b\u0005)\u0012BA\u0015\u0016\u0005A\u0019FO]3b[&twmQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0003Y5\u0002\"a\n\u0001\t\u000b\u0015\u0012\u0001\u0019\u0001\u0014\u0002'9,XnQ8na2,G/\u001a3CCR\u001c\u0007.Z:\u0016\u0003A\u0002\"\u0001I\u0019\n\u0005I\n#aA%oi\u00069b.^7D_6\u0004H.\u001a;fI\n\u000bGo\u00195fg~#S-\u001d\u000b\u0003ka\u0002\"\u0001\t\u001c\n\u0005]\n#\u0001B+oSRDq!\u000f\u0003\u0002\u0002\u0003\u0007\u0001'A\u0002yIE\nAC\\;n\u0007>l\u0007\u000f\\3uK\u0012\u0014\u0015\r^2iKN\u0004\u0013!\u00058v[N#\u0018M\u001d;fI\n\u000bGo\u00195fg\u0006)b.^7Ti\u0006\u0014H/\u001a3CCR\u001c\u0007.Z:`I\u0015\fHCA\u001b?\u0011\u001dIt!!AA\u0002A\n!C\\;n'R\f'\u000f^3e\u0005\u0006$8\r[3tA\u00051B.Y:u\u0007>l\u0007\u000f\\3uK\u0012\u0014\u0015\r^2i)&lW-F\u0001C!\t93)\u0003\u0002E+\t!A+[7f\u0003ia\u0017m\u001d;D_6\u0004H.\u001a;fI\n\u000bGo\u00195US6,w\fJ3r)\t)t\tC\u0004:\u0015\u0005\u0005\t\u0019\u0001\"\u0002/1\f7\u000f^\"p[BdW\r^3e\u0005\u0006$8\r\u001b+j[\u0016\u0004\u0013\u0001\u00037jgR,g.\u001a:\u0016\u0003-\u00132\u0001T\u0010P\r\u0011iU\u0002A&\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002\u00131L7\u000f^3oKJ\u0004\u0003C\u0001)T\u001b\u0005\t&B\u0001*\u0016\u0003%\u00198\r[3ek2,'/\u0003\u0002U#\n\t2\u000b\u001e:fC6Lgn\u001a'jgR,g.\u001a:\u0002-\u001d,GOT;n\u0007>l\u0007\u000f\\3uK\u0012\u0014\u0015\r^2iKN\fAcZ3u\u001dVl7\u000b^1si\u0016$')\u0019;dQ\u0016\u001c\u0018!G4fi2\u000b7\u000f^\"p[BdW\r^3e\u0005\u0006$8\r\u001b+j[\u0016\f\u0011d^1jiVsG/\u001b7CCR\u001c\u0007.Z:D_6\u0004H.\u001a;fIR\u0019!,X0\u0011\u0005\u0001Z\u0016B\u0001/\"\u0005\u001d\u0011un\u001c7fC:DQAX\tA\u0002A\n1$\u001a=qK\u000e$X\r\u001a(v[\u000e{W\u000e\u001d7fi\u0016$')\u0019;dQ\u0016\u001c\b\"\u00021\u0012\u0001\u0004\t\u0017a\u0002;j[\u0016|W\u000f\u001e\t\u0003A\tL!aY\u0011\u0003\t1{gnZ\u0001\u0018o\u0006LG/\u00168uS2\u0014\u0015\r^2iKN\u001cF/\u0019:uK\u0012$2A\u00174i\u0011\u00159'\u00031\u00011\u0003e)\u0007\u0010]3di\u0016$g*^7Ti\u0006\u0014H/\u001a3CCR\u001c\u0007.Z:\t\u000b\u0001\u0014\u0002\u0019A1\u00029]\f\u0017\u000e^+oi&d7i\u001c8eSRLwN\u001c\"fG>lW\r\u0016:vKR\u0019!l\u001b9\t\r1\u001cB\u00111\u0001n\u0003%\u0019wN\u001c3ji&|g\u000eE\u0002!]jK!a\\\u0011\u0003\u0011q\u0012\u0017P\\1nKzBQ\u0001Y\nA\u0002\u0005\u0004")
public class BatchCounter {
    private int org$apache$spark$streaming$BatchCounter$$numCompletedBatches = 0;
    private int org$apache$spark$streaming$BatchCounter$$numStartedBatches = 0;
    private Time org$apache$spark$streaming$BatchCounter$$lastCompletedBatchTime = null;
    private final StreamingListener listener = new StreamingListener(this){
        private final /* synthetic */ BatchCounter $outer;

        public void onStreamingStarted(StreamingListenerStreamingStarted streamingStarted) {
            StreamingListener.onStreamingStarted$((StreamingListener)this, (StreamingListenerStreamingStarted)streamingStarted);
        }

        public void onReceiverStarted(StreamingListenerReceiverStarted receiverStarted) {
            StreamingListener.onReceiverStarted$((StreamingListener)this, (StreamingListenerReceiverStarted)receiverStarted);
        }

        public void onReceiverError(StreamingListenerReceiverError receiverError) {
            StreamingListener.onReceiverError$((StreamingListener)this, (StreamingListenerReceiverError)receiverError);
        }

        public void onReceiverStopped(StreamingListenerReceiverStopped receiverStopped) {
            StreamingListener.onReceiverStopped$((StreamingListener)this, (StreamingListenerReceiverStopped)receiverStopped);
        }

        public void onBatchSubmitted(StreamingListenerBatchSubmitted batchSubmitted) {
            StreamingListener.onBatchSubmitted$((StreamingListener)this, (StreamingListenerBatchSubmitted)batchSubmitted);
        }

        public void onOutputOperationStarted(StreamingListenerOutputOperationStarted outputOperationStarted) {
            StreamingListener.onOutputOperationStarted$((StreamingListener)this, (StreamingListenerOutputOperationStarted)outputOperationStarted);
        }

        public void onOutputOperationCompleted(StreamingListenerOutputOperationCompleted outputOperationCompleted) {
            StreamingListener.onOutputOperationCompleted$((StreamingListener)this, (StreamingListenerOutputOperationCompleted)outputOperationCompleted);
        }

        public void onBatchStarted(StreamingListenerBatchStarted batchStarted) {
            BatchCounter batchCounter = this.$outer;
            synchronized (batchCounter) {
                this.$outer.org$apache$spark$streaming$BatchCounter$$numStartedBatches_$eq(this.$outer.org$apache$spark$streaming$BatchCounter$$numStartedBatches() + 1);
                this.$outer.notifyAll();
            }
        }

        public void onBatchCompleted(StreamingListenerBatchCompleted batchCompleted) {
            BatchCounter batchCounter = this.$outer;
            synchronized (batchCounter) {
                this.$outer.org$apache$spark$streaming$BatchCounter$$numCompletedBatches_$eq(this.$outer.org$apache$spark$streaming$BatchCounter$$numCompletedBatches() + 1);
                this.$outer.org$apache$spark$streaming$BatchCounter$$lastCompletedBatchTime_$eq(batchCompleted.batchInfo().batchTime());
                this.$outer.notifyAll();
            }
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            StreamingListener.$init$((StreamingListener)this);
        }
    };

    public int org$apache$spark$streaming$BatchCounter$$numCompletedBatches() {
        return this.org$apache$spark$streaming$BatchCounter$$numCompletedBatches;
    }

    public void org$apache$spark$streaming$BatchCounter$$numCompletedBatches_$eq(int x$1) {
        this.org$apache$spark$streaming$BatchCounter$$numCompletedBatches = x$1;
    }

    public int org$apache$spark$streaming$BatchCounter$$numStartedBatches() {
        return this.org$apache$spark$streaming$BatchCounter$$numStartedBatches;
    }

    public void org$apache$spark$streaming$BatchCounter$$numStartedBatches_$eq(int x$1) {
        this.org$apache$spark$streaming$BatchCounter$$numStartedBatches = x$1;
    }

    private Time lastCompletedBatchTime() {
        return this.org$apache$spark$streaming$BatchCounter$$lastCompletedBatchTime;
    }

    public void org$apache$spark$streaming$BatchCounter$$lastCompletedBatchTime_$eq(Time x$1) {
        this.org$apache$spark$streaming$BatchCounter$$lastCompletedBatchTime = x$1;
    }

    private StreamingListener listener() {
        return this.listener;
    }

    public synchronized int getNumCompletedBatches() {
        return this.org$apache$spark$streaming$BatchCounter$$numCompletedBatches();
    }

    public synchronized int getNumStartedBatches() {
        return this.org$apache$spark$streaming$BatchCounter$$numStartedBatches();
    }

    public synchronized Time getLastCompletedBatchTime() {
        return this.lastCompletedBatchTime();
    }

    public boolean waitUntilBatchesCompleted(int expectedNumCompletedBatches, long timeout) {
        return this.waitUntilConditionBecomeTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.org$apache$spark$streaming$BatchCounter$$numCompletedBatches() >= expectedNumCompletedBatches, timeout);
    }

    public boolean waitUntilBatchesStarted(int expectedNumStartedBatches, long timeout) {
        return this.waitUntilConditionBecomeTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.org$apache$spark$streaming$BatchCounter$$numStartedBatches() >= expectedNumStartedBatches, timeout);
    }

    private synchronized boolean waitUntilConditionBecomeTrue(Function0<Object> condition, long timeout) {
        long now = System.currentTimeMillis();
        long timeoutTick = now + timeout;
        while (!condition.apply$mcZ$sp() && timeoutTick > now) {
            this.wait(timeoutTick - now);
            now = System.currentTimeMillis();
        }
        return condition.apply$mcZ$sp();
    }

    public BatchCounter(StreamingContext ssc) {
        ssc.addStreamingListener(this.listener());
    }
}

