/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.File;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.DStreamCheckpointTester;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.State;
import org.apache.spark.streaming.StateImpl;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.StateSpec$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestInputStream;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStreamWithPartitions;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.InternalMapWithStateDStream;
import org.apache.spark.streaming.dstream.MapWithStateDStream;
import org.apache.spark.streaming.dstream.MapWithStateDStreamImpl;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\b\u0011\u0001eAQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001A\u0002\u0013%\u0011\u0006C\u0004.\u0001\u0001\u0007I\u0011\u0002\u0018\t\r]\u0002\u0001\u0015)\u0003+\u0011\u001dA\u0004\u00011A\u0005\u0012eBqA\u0011\u0001A\u0002\u0013E1\t\u0003\u0004F\u0001\u0001\u0006KA\u000f\u0005\b\r\u0002\u0011\r\u0011\"\u0005H\u0011\u0019Y\u0005\u0001)A\u0005\u0011\")A\n\u0001C!\u001b\")a\n\u0001C!\u001b\")q\n\u0001C\u0005!\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA5\u0001\u0011%\u00111\u000e\u0002\u0012\u001b\u0006\u0004x+\u001b;i'R\fG/Z*vSR,'BA\t\u0013\u0003%\u0019HO]3b[&twM\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u000e\u001fEA\u00111\u0004H\u0007\u0002%%\u0011QD\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005}\u0001S\"\u0001\t\n\u0005\u0005\u0002\"!\u0006'pG\u0006d7\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\t\u0003?\rJ!\u0001\n\t\u0003/\u0011\u001bFO]3b[\u000eCWmY6q_&tG\u000fV3ti\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001(!\ty\u0002!\u0001\u0002tGV\t!\u0006\u0005\u0002\u001cW%\u0011AF\u0005\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007g\u000e|F%Z9\u0015\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$\u0001B+oSRDqAN\u0002\u0002\u0002\u0003\u0007!&A\u0002yIE\n1a]2!\u00035\u0019\u0007.Z2la>Lg\u000e\u001e#jeV\t!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005\u0011\u0011n\u001c\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEH\u0001\u0003GS2,\u0017!E2iK\u000e\\\u0007o\\5oi\u0012K'o\u0018\u0013fcR\u0011q\u0006\u0012\u0005\bm\u0019\t\t\u00111\u0001;\u00039\u0019\u0007.Z2la>Lg\u000e\u001e#je\u0002\nQBY1uG\"$UO]1uS>tW#\u0001%\u0011\u0005}I\u0015B\u0001&\u0011\u0005!!UO]1uS>t\u0017A\u00042bi\u000eDG)\u001e:bi&|g\u000eI\u0001\u000bE\u00164wN]3FC\u000eDG#A\u0018\u0002\u0013\u00054G/\u001a:FC\u000eD\u0017!\u0004;fgR|\u0005/\u001a:bi&|g.\u0006\u0003R;*\u0004H\u0003\u0003*s\u0003\u0007\t\u0019\"a\u0007\u0015\t=\u001af\r\u001c\u0005\b)2\t\t\u0011q\u0001V\u0003))g/\u001b3f]\u000e,G%\r\t\u0004-f[V\"A,\u000b\u0005a\u000b\u0014a\u0002:fM2,7\r^\u0005\u00035^\u0013\u0001b\u00117bgN$\u0016m\u001a\t\u00039vc\u0001\u0001B\u0003_\u0019\t\u0007qLA\u0001L#\t\u00017\r\u0005\u00021C&\u0011!-\r\u0002\b\u001d>$\b.\u001b8h!\t\u0001D-\u0003\u0002fc\t\u0019\u0011I\\=\t\u000f\u001dd\u0011\u0011!a\u0002Q\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u0007YK\u0016\u000e\u0005\u0002]U\u0012)1\u000e\u0004b\u0001?\n\t1\u000bC\u0004n\u0019\u0005\u0005\t9\u00018\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002W3>\u0004\"\u0001\u00189\u0005\u000bEd!\u0019A0\u0003\u0003QCQa\u001d\u0007A\u0002Q\fQ!\u001b8qkR\u0004B!^?\u0002\u00029\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003sb\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001a\n\u0005q\f\u0014a\u00029bG.\fw-Z\u0005\u0003}~\u00141aU3r\u0015\ta\u0018\u0007E\u0002v{nCq!!\u0002\r\u0001\u0004\t9!\u0001\tnCB<\u0016\u000e\u001e5Ti\u0006$Xm\u00159fGBAq$!\u0003\\\u0003\u001bIw.C\u0002\u0002\fA\u0011\u0011b\u0015;bi\u0016\u001c\u0006/Z2\u0011\u0007A\ny!C\u0002\u0002\u0012E\u00121!\u00138u\u0011\u001d\t)\u0002\u0004a\u0001\u0003/\tq\"\u001a=qK\u000e$X\rZ(viB,Ho\u001d\t\u0005kv\fI\u0002E\u0002v{>Dq!!\b\r\u0001\u0004\ty\"\u0001\ffqB,7\r^3e'R\fG/Z*oCB\u001c\bn\u001c;t!\u0011)X0!\t\u0011\tUl\u00181\u0005\t\u0006a\u0005\u00152,[\u0005\u0004\u0003O\t$A\u0002+va2,''\u0001\nhKR|\u0005/\u001a:bi&|gnT;uaV$X\u0003CA\u0017\u0003\u0007\n9%!\u000f\u0015\u0011\u0005=\u00121LA1\u0003K\"\u0002\"!\r\u0002J\u0005=\u0013Q\u000b\t\ba\u0005\u0015\u00121GA\u001e!\u0011)X0!\u000e\u0011\tUl\u0018q\u0007\t\u00049\u0006eB!B9\u000e\u0005\u0004y\u0006\u0003B;~\u0003{\u0001B!^?\u0002@A9\u0001'!\n\u0002B\u0005\u0015\u0003c\u0001/\u0002D\u0011)a,\u0004b\u0001?B\u0019A,a\u0012\u0005\u000b-l!\u0019A0\t\u0013\u0005-S\"!AA\u0004\u00055\u0013AC3wS\u0012,gnY3%iA!a+WA!\u0011%\t\t&DA\u0001\u0002\b\t\u0019&\u0001\u0006fm&$WM\\2fIU\u0002BAV-\u0002F!I\u0011qK\u0007\u0002\u0002\u0003\u000f\u0011\u0011L\u0001\u000bKZLG-\u001a8dK\u00122\u0004\u0003\u0002,Z\u0003oAaa]\u0007A\u0002\u0005u\u0003\u0003B;~\u0003?\u0002B!^?\u0002B!9\u0011QA\u0007A\u0002\u0005\r\u0004cC\u0010\u0002\n\u0005\u0005\u0013QBA#\u0003oAq!a\u001a\u000e\u0001\u0004\ti!\u0001\u0006ok6\u0014\u0015\r^2iKN\fa!Y:tKJ$X\u0003BA7\u0003s\"raLA8\u0003{\n\t\tC\u0004\u0002r9\u0001\r!a\u001d\u0002\u0011\u0015D\b/Z2uK\u0012\u0004B!^?\u0002vA!Q/`A<!\ra\u0016\u0011\u0010\u0003\u0007\u0003wr!\u0019A0\u0003\u0003UCq!a \u000f\u0001\u0004\t\u0019(A\u0005d_2dWm\u0019;fI\"9\u00111\u0011\bA\u0002\u0005\u0015\u0015a\u0001;zaB!\u0011qQAH\u001d\u0011\tI)a#\u0011\u0005]\f\u0014bAAGc\u00051\u0001K]3eK\u001aLA!!%\u0002\u0014\n11\u000b\u001e:j]\u001eT1!!$2\u0001")
public class MapWithStateSuite
extends SparkFunSuite
implements LocalStreamingContext,
DStreamCheckpointTester {
    private SparkContext sc;
    private File checkpointDir;
    private final Duration batchDuration;
    private transient StreamingContext ssc;
    private transient boolean stopSparkContext;

    @Override
    public <U, V> void testCheckpointedOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatchesBeforeRestart, Duration batchDuration, boolean stopSparkContextAfterTest, ClassTag<U> evidence$1, ClassTag<V> evidence$2) {
        DStreamCheckpointTester.testCheckpointedOperation$(this, input, operation, expectedOutput, numBatchesBeforeRestart, batchDuration, stopSparkContextAfterTest, evidence$1, evidence$2);
    }

    @Override
    public <U, V> Duration testCheckpointedOperation$default$5() {
        return DStreamCheckpointTester.testCheckpointedOperation$default$5$(this);
    }

    @Override
    public <U, V> boolean testCheckpointedOperation$default$6() {
        return DStreamCheckpointTester.testCheckpointedOperation$default$6$(this);
    }

    @Override
    public StreamingContext createContextForCheckpointOperation(Duration batchDuration) {
        return DStreamCheckpointTester.createContextForCheckpointOperation$(this, batchDuration);
    }

    @Override
    public <V> TestOutputStreamWithPartitions<V> getTestOutputStream(DStream<?>[] streams, ClassTag<V> evidence$3) {
        return DStreamCheckpointTester.getTestOutputStream$(this, streams, evidence$3);
    }

    @Override
    public <V> Seq<Seq<V>> generateOutput(StreamingContext ssc, Time targetBatchTime, String checkpointDir, boolean stopSparkContext, ClassTag<V> evidence$4) {
        return DStreamCheckpointTester.generateOutput$(this, ssc, targetBatchTime, checkpointDir, stopSparkContext, evidence$4);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public File checkpointDir() {
        return this.checkpointDir;
    }

    public void checkpointDir_$eq(File x$1) {
        this.checkpointDir = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        SparkConf conf = new SparkConf().setMaster("local").setAppName("MapWithStateSuite");
        conf.set("spark.streaming.clock", ManualClock.class.getName());
        this.sc_$eq(new SparkContext(conf));
        String x$1 = "checkpoint";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.checkpointDir_$eq(Utils$.MODULE$.createTempDir(x$2, "checkpoint"));
    }

    @Override
    public void afterEach() {
        try {
            if (this.checkpointDir() != null) {
                Utils$.MODULE$.deleteRecursively(this.checkpointDir());
            }
        }
        finally {
            LocalStreamingContext.afterEach$(this);
        }
    }

    private <K, S, T> void testOperation(Seq<Seq<K>> input, StateSpec<K, Object, S, T> mapWithStateSpec, Seq<Seq<T>> expectedOutputs, Seq<Seq<Tuple2<K, S>>> expectedStateSnapshots, ClassTag<K> evidence$1, ClassTag<S> evidence$2, ClassTag<T> evidence$3) {
        Predef$.MODULE$.require(expectedOutputs.size() == expectedStateSnapshots.size());
        Tuple2<Seq<Seq<T>>, Seq<Seq<Tuple2<K, S>>>> tuple2 = this.getOperationOutput(input, mapWithStateSpec, expectedOutputs.size(), evidence$1, evidence$2, evidence$3);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq collectedOutputs = (Seq)tuple2._1();
        Seq collectedStateSnapshots = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)collectedOutputs, (Object)collectedStateSnapshots);
        Seq collectedOutputs2 = (Seq)tuple22._1();
        Seq collectedStateSnapshots2 = (Seq)tuple22._2();
        this.assert(expectedOutputs, collectedOutputs2, "outputs");
        this.assert(expectedStateSnapshots, collectedStateSnapshots2, "state snapshots");
    }

    private <K, S, T> Tuple2<Seq<Seq<T>>, Seq<Seq<Tuple2<K, S>>>> getOperationOutput(Seq<Seq<K>> input, StateSpec<K, Object, S, T> mapWithStateSpec, int numBatches, ClassTag<K> evidence$4, ClassTag<S> evidence$5, ClassTag<T> evidence$6) {
        StreamingContext ssc = new StreamingContext(this.sc(), Seconds$.MODULE$.apply(1L));
        TestInputStream<K> inputStream = new TestInputStream<K>(ssc, input, 2, evidence$4);
        DStream x$1 = inputStream.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag<K> x$2 = evidence$4;
        ManifestFactory.IntManifest x$3 = ClassTag$.MODULE$.Int();
        Null$ x$4 = DStream$.MODULE$.toPairDStreamFunctions$default$4(x$1);
        MapWithStateDStream trackedStateStream = DStream$.MODULE$.toPairDStreamFunctions(x$1, x$2, (ClassTag)x$3, null).mapWithState(mapWithStateSpec, evidence$5, evidence$6);
        ConcurrentLinkedQueue collectedOutputs = new ConcurrentLinkedQueue();
        TestOutputStream outputStream = new TestOutputStream(trackedStateStream, collectedOutputs, evidence$6);
        ConcurrentLinkedQueue collectedStateSnapshots = new ConcurrentLinkedQueue();
        TestOutputStream stateSnapshotStream = new TestOutputStream(trackedStateStream.stateSnapshots(), collectedStateSnapshots, ClassTag$.MODULE$.apply(Tuple2.class));
        outputStream.register();
        stateSnapshotStream.register();
        BatchCounter batchCounter = new BatchCounter(ssc);
        ssc.checkpoint(this.checkpointDir().toString());
        ssc.start();
        ManualClock clock = (ManualClock)ssc.scheduler().clock();
        clock.advance(this.batchDuration().milliseconds() * (long)numBatches);
        batchCounter.waitUntilBatchesCompleted(numBatches, 10000L);
        ssc.stop(false);
        return new Tuple2((Object)CollectionConverters$.MODULE$.CollectionHasAsScala(collectedOutputs).asScala().toSeq(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(collectedStateSnapshots).asScala().toSeq());
    }

    private <U> void assert(Seq<Seq<U>> expected, Seq<Seq<U>> collected, String typ) {
        String debugString = "\nExpected:\n" + expected.mkString("\n") + "\nCollected:\n" + collected.mkString("\n");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expected.size()));
        int $org_scalatest_assert_macro_right = collected.size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("number of collected " + typ + " (" + collected.size() + ") different from expected (" + expected.size() + ")" + debugString), Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        ((IterableOnceOps)expected.zip(collected)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq c = (Seq)tuple2._1();
                Seq e = (Seq)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(c.toSet());
                Set $org_scalatest_assert_macro_right = e.toSet();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("collected " + typ + " is different from expected " + debugString), Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final void testState$1(Option expectedData, boolean shouldBeUpdated, boolean shouldBeRemoved, boolean shouldBeTimingOut, ObjectRef state$1) {
        if (expectedData.isDefined()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((StateImpl)state$1.elem).exists(), "state.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((StateImpl)state$1.elem).get());
            int $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)expectedData.get());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((StateImpl)state$1.elem).getOption());
            Option $org_scalatest_assert_macro_right2 = expectedData;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(((StateImpl)state$1.elem).getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            int $org_scalatest_assert_macro_right3 = BoxesRunTime.unboxToInt((Object)expectedData.get());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        } else {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((StateImpl)state$1.elem).exists(), "state.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)((StateImpl)state$1.elem).get()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((StateImpl)state$1.elem).getOption());
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(((StateImpl)state$1.elem).getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
            int $org_scalatest_assert_macro_right4 = -1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)((StateImpl)state$1.elem).isTimingOut()));
        boolean $org_scalatest_assert_macro_right = shouldBeTimingOut;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        if (shouldBeTimingOut) {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((StateImpl)state$1.elem).remove(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            v1 = this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((StateImpl)state$1.elem).update((Object)BoxesRunTime.boxToInteger((int)-1)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        } else {
            v1 = BoxedUnit.UNIT;
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)((StateImpl)state$1.elem).isUpdated()));
        boolean $org_scalatest_assert_macro_right5 = shouldBeUpdated;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)((StateImpl)state$1.elem).isRemoved()));
        boolean $org_scalatest_assert_macro_right6 = shouldBeRemoved;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        if (shouldBeRemoved) {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((StateImpl)state$1.elem).remove(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((StateImpl)state$1.elem).update((Object)BoxesRunTime.boxToInteger((int)-1)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            return;
        }
    }

    private static final boolean testState$default$2$1() {
        return false;
    }

    private static final boolean testState$default$3$1() {
        return false;
    }

    private static final boolean testState$default$4$1() {
        return false;
    }

    public static final /* synthetic */ int $anonfun$new$10(String key, Option value, State state) {
        int sum = BoxesRunTime.unboxToInt((Object)value.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        state.update((Object)BoxesRunTime.boxToInteger((int)sum));
        return sum;
    }

    public static final /* synthetic */ long $anonfun$new$18(String key, Option value, State state) {
        return 0L;
    }

    private final void testTypes$1(MapWithStateDStream dstream) {
        MapWithStateDStreamImpl dstreamImpl = (MapWithStateDStreamImpl)dstream;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dstreamImpl.keyClass());
        Class<String> $org_scalatest_assert_macro_right = String.class;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dstreamImpl.valueClass());
        Class<Integer> $org_scalatest_assert_macro_right2 = Integer.TYPE;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dstreamImpl.stateClass());
        Class<Double> $org_scalatest_assert_macro_right3 = Double.TYPE;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(dstreamImpl.mappedClass());
        Class<Long> $org_scalatest_assert_macro_right4 = Long.TYPE;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
    }

    public static final /* synthetic */ boolean $anonfun$new$34(Seq x$2) {
        Set set = x$2.toSet();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}));
        return !(set != null ? !set.equals(object) : object != null);
    }

    public static final /* synthetic */ int $anonfun$new$37(int key, Option value, State state) {
        return 0;
    }

    private final void testCheckpointDuration$1(Duration batchDuration, Duration expectedCheckpointDuration, Option explicitCheckpointDuration, PrivateMethodTester.PrivateMethod privateMethod$1) {
        StreamingContext ssc = new StreamingContext(this.sc(), batchDuration);
        try {
            DStream inputStream = new TestInputStream(ssc, (Seq)package$.MODULE$.Seq().empty(), 2, ClassTag$.MODULE$.Int()).map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$3))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class));
            Function3 & Serializable dummyFunc = (Function3 & Serializable)(key, value, state) -> BoxesRunTime.boxToInteger((int)MapWithStateSuite.$anonfun$new$37(BoxesRunTime.unboxToInt((Object)key), value, state));
            MapWithStateDStream mapWithStateStream = DStream$.MODULE$.toPairDStreamFunctions(inputStream, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).mapWithState(StateSpec$.MODULE$.function((Function3)dummyFunc), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
            InternalMapWithStateDStream internalmapWithStateStream = (InternalMapWithStateDStream)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)mapWithStateStream).invokePrivate(privateMethod$1.apply((Seq)Nil$.MODULE$));
            explicitCheckpointDuration.foreach((Function1 & Serializable)d -> mapWithStateStream.checkpoint(d));
            mapWithStateStream.register();
            ssc.checkpoint(this.checkpointDir().toString());
            ssc.start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mapWithStateStream.checkpointDuration());
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(internalmapWithStateStream.checkpointDuration());
            Duration $org_scalatest_assert_macro_right2 = expectedCheckpointDuration;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        }
        finally {
            ssc.stop(false);
        }
    }

    private static final Option testCheckpointDuration$default$3$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ int $anonfun$new$40(String key, Option value, State state) {
        state.update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)value.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)))));
        return BoxesRunTime.unboxToInt((Object)state.get());
    }

    private final DStream operation$1(DStream dstream, Seq stateData$1) {
        Duration checkpointDuration = this.batchDuration().$times(stateData$1.size() / 2);
        Function3 & Serializable runningCount = (Function3 & Serializable)(key, value, state) -> BoxesRunTime.boxToInteger((int)MapWithStateSuite.$anonfun$new$40(key, value, state));
        MapWithStateDStream mapWithStateStream = DStream$.MODULE$.toPairDStreamFunctions(dstream.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapWithState(StateSpec$.MODULE$.function((Function3)runningCount), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        mapWithStateStream.checkpoint(checkpointDuration);
        return mapWithStateStream.stateSnapshots();
    }

    public static final /* synthetic */ DStream $anonfun$new$44(MapWithStateSuite $this, Seq stateData$1, DStream dstream) {
        return $this.operation$1(dstream, stateData$1);
    }

    public MapWithStateSuite() {
        LocalStreamingContext.$init$(this);
        DStreamCheckpointTester.$init$(this);
        this.sc = null;
        this.checkpointDir = null;
        this.batchDuration = Seconds$.MODULE$.apply(1L);
        this.test("state - get, exists, update, remove, ", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef state = ObjectRef.create(null);
            state.elem = new StateImpl();
            this.testState$1((Option)None$.MODULE$, MapWithStateSuite.testState$default$2$1(), MapWithStateSuite.testState$default$3$1(), MapWithStateSuite.testState$default$4$1(), state);
            ((StateImpl)state.elem).wrap((Option)None$.MODULE$);
            this.testState$1((Option)None$.MODULE$, MapWithStateSuite.testState$default$2$1(), MapWithStateSuite.testState$default$3$1(), MapWithStateSuite.testState$default$4$1(), state);
            ((StateImpl)state.elem).wrap((Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
            this.testState$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), MapWithStateSuite.testState$default$2$1(), MapWithStateSuite.testState$default$3$1(), MapWithStateSuite.testState$default$4$1(), state);
            ((StateImpl)state.elem).update((Object)BoxesRunTime.boxToInteger((int)2));
            this.testState$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), true, MapWithStateSuite.testState$default$3$1(), MapWithStateSuite.testState$default$4$1(), state);
            state.elem = new StateImpl();
            ((StateImpl)state.elem).update((Object)BoxesRunTime.boxToInteger((int)2));
            this.testState$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), true, MapWithStateSuite.testState$default$3$1(), MapWithStateSuite.testState$default$4$1(), state);
            ((StateImpl)state.elem).remove();
            None$ x$1 = None$.MODULE$;
            boolean x$2 = true;
            boolean x$3 = MapWithStateSuite.testState$default$2$1();
            boolean x$4 = MapWithStateSuite.testState$default$4$1();
            this.testState$1((Option)x$1, x$3, true, x$4, state);
            ((StateImpl)state.elem).wrapTimingOutState((Object)BoxesRunTime.boxToInteger((int)3));
            Some x$5 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            boolean x$6 = true;
            boolean x$7 = MapWithStateSuite.testState$default$2$1();
            boolean x$8 = MapWithStateSuite.testState$default$3$1();
            this.testState$1((Option)x$5, x$7, x$8, true, state);
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("mapWithState - basic operations with simple API", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon inputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            .colon.colon outputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            .colon.colon stateData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)Nil$.MODULE$)))))));
            Function3 & Serializable mappingFunc = (Function3 & Serializable)(key, value, state) -> BoxesRunTime.boxToInteger((int)MapWithStateSuite.$anonfun$new$10(key, value, state));
            this.testOperation((Seq)inputData, (StateSpec)StateSpec$.MODULE$.function((Function3)mappingFunc), (Seq)outputData, (Seq)stateData, (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("mapWithState - basic operations with advanced API", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon inputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            .colon.colon outputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "bb"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "bb", "cc"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "bb"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aa"}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            .colon.colon stateData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)Nil$.MODULE$)))))));
            Function4 & Serializable mappingFunc = (Function4 & Serializable)(batchTime, key, value, state) -> {
                int sum = BoxesRunTime.unboxToInt((Object)value.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                state.update((Object)BoxesRunTime.boxToInteger((int)sum));
                return new Some((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(key), 2));
            };
            this.testOperation((Seq)inputData, (StateSpec)StateSpec$.MODULE$.function((Function4)mappingFunc), (Seq)outputData, (Seq)stateData, (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(String.class));
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("mapWithState - type inferencing and class tags", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function3 & Serializable simpleFunc = (Function3 & Serializable)(key, value, state) -> BoxesRunTime.boxToLong((long)MapWithStateSuite.$anonfun$new$18(key, value, state));
            Function4 & Serializable advancedFunc = (Function4 & Serializable)(time, key, value, state) -> new Some((Object)BoxesRunTime.boxToLong((long)0L));
            StreamingContext ssc = new StreamingContext(this.sc(), this.batchDuration());
            TestInputStream inputStream = new TestInputStream(ssc, (Seq)package$.MODULE$.Seq().empty(), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            MapWithStateDStream simpleFunctionStateStream1 = DStream$.MODULE$.toPairDStreamFunctions(inputStream, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapWithState(StateSpec$.MODULE$.function((Function3)simpleFunc).numPartitions(1), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Long());
            this.testTypes$1(simpleFunctionStateStream1);
            StateSpec simpleFuncSpec = StateSpec$.MODULE$.function((Function3)simpleFunc);
            MapWithStateDStream simpleFunctionStateStream2 = DStream$.MODULE$.toPairDStreamFunctions(inputStream, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapWithState(simpleFuncSpec, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Long());
            this.testTypes$1(simpleFunctionStateStream2);
            StateSpec advFuncSpec1 = StateSpec$.MODULE$.function((Function4)advancedFunc);
            MapWithStateDStream advFunctionStateStream1 = DStream$.MODULE$.toPairDStreamFunctions(inputStream, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapWithState(advFuncSpec1, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Long());
            this.testTypes$1(advFunctionStateStream1);
            MapWithStateDStream advFunctionStateStream2 = DStream$.MODULE$.toPairDStreamFunctions(inputStream, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapWithState(StateSpec$.MODULE$.function((Function3)simpleFunc).numPartitions(1), (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Long());
            this.testTypes$1(advFunctionStateStream2);
            StateSpec advFuncSpec2 = StateSpec$.MODULE$.function((Function4)advancedFunc);
            MapWithStateDStream advFunctionStateStream3 = DStream$.MODULE$.toPairDStreamFunctions(inputStream, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapWithState(advFuncSpec2, (ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Long());
            this.testTypes$1(advFunctionStateStream3);
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("mapWithState - states as mapped data", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon inputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            .colon.colon outputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5))}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            .colon.colon stateData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)Nil$.MODULE$)))))));
            Function4 & Serializable mappingFunc = (Function4 & Serializable)(time, key, value, state) -> {
                int sum = BoxesRunTime.unboxToInt((Object)value.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                Tuple2 output = new Tuple2(key, (Object)BoxesRunTime.boxToInteger((int)sum));
                state.update((Object)BoxesRunTime.boxToInteger((int)sum));
                return new Some((Object)output);
            };
            this.testOperation((Seq)inputData, (StateSpec)StateSpec$.MODULE$.function((Function4)mappingFunc), (Seq)outputData, (Seq)stateData, (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("mapWithState - initial states, with nothing returned as from mapping function", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon initialState = new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)10)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-20)), (List)new .colon.colon((Object)new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))));
            .colon.colon inputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            Seq outputData = (Seq)package$.MODULE$.Seq().fill(inputData.size(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
            .colon.colon stateData = new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-20)), new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-20)), new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)7)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)11)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-20)), new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)8)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)12)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-19)), new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)9)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)13)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-19)), new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)13)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-19)), new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)10)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)13)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)-19)), new Tuple2((Object)"d", (Object)BoxesRunTime.boxToInteger((int)0))}))), (List)Nil$.MODULE$)))))));
            Function4 & Serializable mappingFunc = (Function4 & Serializable)(time, key, value, state) -> {
                int sum = BoxesRunTime.unboxToInt((Object)value.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                Tuple2 output = new Tuple2(key, (Object)BoxesRunTime.boxToInteger((int)sum));
                state.update((Object)BoxesRunTime.boxToInteger((int)sum));
                return None$.MODULE$;
            };
            SparkContext qual$1 = this.sc();
            .colon.colon x$9 = initialState;
            int x$10 = qual$1.makeRDD$default$2();
            StateSpec mapWithStateSpec = StateSpec$.MODULE$.function((Function4)mappingFunc).initialState(qual$1.makeRDD((Seq)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class)));
            this.testOperation((Seq)inputData, (StateSpec)mapWithStateSpec, (Seq)outputData, (Seq)stateData, (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("mapWithState - state removing", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Nil$.MODULE$, new .colon.colon((Object)"a", (List)Nil$.MODULE$), new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, new .colon.colon((Object)"a", (List)Nil$.MODULE$), new .colon.colon((Object)"b", (List)Nil$.MODULE$), new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$)), new .colon.colon((Object)"b", (List)Nil$.MODULE$), new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$}));
            Seq stateData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Nil$.MODULE$, new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$}));
            Function4 & Serializable mappingFunc = (Function4 & Serializable)(time, key, value, state) -> {
                if (state.exists()) {
                    state.remove();
                    return new Some(key);
                }
                state.update(value.get());
                return None$.MODULE$;
            };
            this.testOperation((Seq)inputData, (StateSpec)StateSpec$.MODULE$.function((Function4)mappingFunc).numPartitions(1), (Seq)outputData, (Seq)stateData, (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(String.class));
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        this.test("mapWithState - state timing out", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Function4 & Serializable mappingFunc;
            Seq inputData = (Seq)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (List)Nil$.MODULE$)))))).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(20, (Function0 & Serializable)() -> new .colon.colon((Object)"a", (List)Nil$.MODULE$)));
            Tuple2 tuple2 = this.getOperationOutput((Seq)inputData, (StateSpec)StateSpec$.MODULE$.function((Function4)(mappingFunc = (Function4 & Serializable)(time, key, value, state) -> {
                if (value.isDefined()) {
                    state.update((Object)BoxesRunTime.boxToInteger((int)1));
                }
                if (state.isTimingOut()) {
                    return new Some(key);
                }
                return None$.MODULE$;
            })).timeout(Seconds$.MODULE$.apply(3L)), 20, (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(String.class));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq collectedOutputs = (Seq)tuple2._1();
            Seq collectedStateSnapshots = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)collectedOutputs, (Object)collectedStateSnapshots);
            Seq collectedOutputs2 = (Seq)tuple22._1();
            Seq collectedStateSnapshots2 = (Seq)tuple22._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((SeqOps)collectedOutputs2.flatten(Predef$.MODULE$.$conforms())).sorted((Ordering)Ordering.String$.MODULE$));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(collectedStateSnapshots2.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MapWithStateSuite.$anonfun$new$34(x$2))), "collectedStateSnapshots.exists(((x$2: Seq[(String, Int)]) => x$2.toSet[(String, Int)].==(scala.Predef.Set.apply[(String, Int)](scala.Tuple2.apply[String, Int](\"a\", 1), scala.Tuple2.apply[String, Int](\"b\", 1), scala.Tuple2.apply[String, Int](\"c\", 1)))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((IterableOnceOps)collectedStateSnapshots2.last()).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        this.test("mapWithState - checkpoint durations", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            PrivateMethodTester.PrivateMethod privateMethod = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "internalStream"));
            this.testCheckpointDuration$1(Milliseconds$.MODULE$.apply(100L), Seconds$.MODULE$.apply(1L), MapWithStateSuite.testCheckpointDuration$default$3$1(), privateMethod);
            this.testCheckpointDuration$1(Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(10L), MapWithStateSuite.testCheckpointDuration$default$3$1(), privateMethod);
            this.testCheckpointDuration$1(Seconds$.MODULE$.apply(10L), Seconds$.MODULE$.apply(100L), MapWithStateSuite.testCheckpointDuration$default$3$1(), privateMethod);
            this.testCheckpointDuration$1(Milliseconds$.MODULE$.apply(100L), Seconds$.MODULE$.apply(2L), (Option)new Some((Object)Seconds$.MODULE$.apply(2L)), privateMethod);
            this.testCheckpointDuration$1(Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L), (Option)new Some((Object)Seconds$.MODULE$.apply(2L)), privateMethod);
            this.testCheckpointDuration$1(Seconds$.MODULE$.apply(10L), Seconds$.MODULE$.apply(20L), (Option)new Some((Object)Seconds$.MODULE$.apply(20L)), privateMethod);
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("mapWithState - driver failure recovery", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon inputData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            .colon.colon stateData = new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)Nil$.MODULE$)))))));
            this.testCheckpointedOperation((Seq)inputData, (Function1)((Function1 & Serializable)arg_0 -> MapWithStateSuite.$anonfun$new$44(this, (Seq)stateData, arg_0)), (Seq)stateData, inputData.size() / 2, this.batchDuration(), false, (ClassTag)ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("MapWithStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        Statics.releaseFence();
    }
}

