/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.File;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.SlowTestReceiver;
import org.apache.spark.streaming.SlowTestReceiver$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.StreamingContextState;
import org.apache.spark.streaming.StreamingContextSuite$;
import org.apache.spark.streaming.StreamingSource;
import org.apache.spark.streaming.TestException;
import org.apache.spark.streaming.TestInputStream;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestOutputStream$;
import org.apache.spark.streaming.TestReceiver;
import org.apache.spark.streaming.TestReceiver$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.testPackage$;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.ThreadSignaler$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.exceptions.TestFailedDueToTimeoutException;
import org.scalatest.time.SpanSugar$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileIntRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\u000f\u001f\u0001\u001dBQA\u0010\u0001\u0005\u0002}Bq!\u0011\u0001C\u0002\u0013\r!\t\u0003\u0004G\u0001\u0001\u0006Ia\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0003A\u0005BB*\u0001A\u0003%\u0011\nC\u0004U\u0001\t\u0007I\u0011A+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\u0002!Caa\u0017\u0001!\u0002\u0013I\u0005b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007I\u0002\u0001\u000b\u0011\u00020\t\u000f\u0015\u0004!\u0019!C\u0001M\"1!\u000e\u0001Q\u0001\n\u001dDQa\u001b\u0001\u0005\u00021DQa\u001f\u0001\u0005\u0002qDa!a\u0004\u0001\t\u0003axaBA\t=!%\u00111\u0003\u0004\u0007;yAI!!\u0006\t\ry\"B\u0011AA\u0019\u0011%\t\u0019\u0004\u0006b\u0001\n\u0013\t)\u0004\u0003\u0005\u0002`Q\u0001\u000b\u0011BA\u001c\u0011\u001d\t\t\u0007\u0006C\u0005\u0003GB\u0011\"!\u001d\u0015\u0005\u0004%I!a\u001d\t\u0011\u0005uD\u0003)A\u0005\u0003kBq!a \u0015\t\u0013\t\t\tC\u0005\u0002\bR\t\t\u0011\"\u0003\u0002\n\n)2\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010^*vSR,'BA\u0010!\u0003%\u0019HO]3b[&twM\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0015-aa\u0002\"!\u000b\u0016\u000e\u0003\u0001J!a\u000b\u0011\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tic&D\u0001\u001f\u0013\tycDA\u000bM_\u000e\fGn\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014AC2p]\u000e,(O]3oi*\u0011Q\u0007J\u0001\ng\u000e\fG.\u0019;fgRL!a\u000e\u001a\u0003\u0015QKW.\u001a'j[&$8\u000f\u0005\u0002:y5\t!H\u0003\u0002<A\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002>u\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001A!\ti\u0003!\u0001\u0005tS\u001et\u0017\r\\3s+\u0005\u0019\u0005CA\u0019E\u0013\t)%G\u0001\u0005TS\u001et\u0017\r\\3s\u0003%\u0019\u0018n\u001a8bY\u0016\u0014\b%\u0001\u0004nCN$XM]\u000b\u0002\u0013B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0005Y\u0006twMC\u0001O\u0003\u0011Q\u0017M^1\n\u0005A[%AB*ue&tw-A\u0004nCN$XM\u001d\u0011\u0002\u000f\u0005\u0004\bOT1nK\u0006A\u0011\r\u001d9OC6,\u0007%A\u0007cCR\u001c\u0007\u000eR;sCRLwN\\\u000b\u0002-B\u0011QfV\u0005\u00031z\u0011\u0001\u0002R;sCRLwN\\\u0001\u000fE\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8!\u0003%\u0019\b/\u0019:l\u0011>lW-\u0001\u0006ta\u0006\u00148\u000eS8nK\u0002\nq!\u001a8w!\u0006L'/F\u0001_!\u0011y&-S%\u000e\u0003\u0001T\u0011!Y\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0002\u0014a\u0001V;qY\u0016\u0014\u0014\u0001C3omB\u000b\u0017N\u001d\u0011\u0002\t\r|gNZ\u000b\u0002OB\u0011\u0011\u0006[\u0005\u0003S\u0002\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\u001d\u0005$G-\u00138qkR\u001cFO]3b[R\u0011QN\u001e\t\u0004]F\u001cX\"A8\u000b\u0005At\u0012a\u00023tiJ,\u0017-\\\u0005\u0003e>\u0014q\u0001R*ue\u0016\fW\u000e\u0005\u0002`i&\u0011Q\u000f\u0019\u0002\u0004\u0013:$\b\"B<\u0011\u0001\u0004A\u0018!A:\u0011\u00055J\u0018B\u0001>\u001f\u0005A\u0019FO]3b[&twmQ8oi\u0016DH/A\u000bde\u0016\fG/\u001a,bY&$7\t[3dWB|\u0017N\u001c;\u0015\u0003u\u00042A`A\u0006\u001d\ry\u0018q\u0001\t\u0004\u0003\u0003\u0001WBAA\u0002\u0015\r\t)AJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0001-\u0001\u0004Qe\u0016$WMZ\u0005\u0004!\u00065!bAA\u0005A\u0006I2M]3bi\u0016\u001cuN\u001d:vaR,Gm\u00115fG.\u0004x.\u001b8u\u0003U\u0019FO]3b[&twmQ8oi\u0016DHoU;ji\u0016\u0004\"!\f\u000b\u0014\u000fQ\t9\"!\b\u0002&A\u0019q,!\u0007\n\u0007\u0005m\u0001M\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003?\t\t#D\u00015\u0013\r\t\u0019\u0003\u000e\u0002\u0014!JLg/\u0019;f\u001b\u0016$\bn\u001c3UKN$XM\u001d\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F'\u0002\u0005%|\u0017\u0002BA\u0018\u0003S\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0005\u0002\u0011}\u001bx.\u001e:dKN,\"!a\u000e\u0011\r\u0005e\u00121HA \u001b\u0005!\u0012\u0002BA\u001f\u0003C\u0011Q\u0002\u0015:jm\u0006$X-T3uQ>$\u0007CBA!\u0003\u0017\ny%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u001diW\u000f^1cY\u0016T1!!\u0013a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n\u0019EA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0007g>,(oY3\u000b\u0007\u0005e\u0003%A\u0004nKR\u0014\u0018nY:\n\t\u0005u\u00131\u000b\u0002\u0007'>,(oY3\u0002\u0013}\u001bx.\u001e:dKN\u0004\u0013AC4fiN{WO]2fgR!\u0011qHA3\u0011\u001d\t9\u0007\u0007a\u0001\u0003S\nQ\"\\3ue&\u001c7oU=ti\u0016l\u0007\u0003BA6\u0003[j!!a\u0016\n\t\u0005=\u0014q\u000b\u0002\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u0002!}\u001bHO]3b[&twmU8ve\u000e,WCAA;!\u0019\tI$a\u000f\u0002xA\u0019Q&!\u001f\n\u0007\u0005mdDA\bTiJ,\u0017-\\5oON{WO]2f\u0003Ey6\u000f\u001e:fC6LgnZ*pkJ\u001cW\rI\u0001\u0013O\u0016$8\u000b\u001e:fC6LgnZ*pkJ\u001cW\r\u0006\u0003\u0002x\u0005\r\u0005BBAC7\u0001\u0007\u00010\u0001\ttiJ,\u0017-\\5oO\u000e{g\u000e^3yi\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u0012\t\u0004\u0015\u00065\u0015bAAH\u0017\n1qJ\u00196fGR\u0004")
public class StreamingContextSuite
extends SparkFunSuite
implements LocalStreamingContext {
    private final Signaler signaler;
    private final String master;
    private final String appName;
    private final Duration batchDuration;
    private final String sparkHome;
    private final Tuple2<String, String> envPair;
    private final SparkConf conf;
    private transient StreamingContext ssc;
    private transient boolean stopSparkContext;

    public static PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return StreamingContextSuite$.MODULE$.anyRefToInvoker(target);
    }

    public static PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        return StreamingContextSuite$.MODULE$.PrivateMethod();
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterEach() {
        LocalStreamingContext.afterEach$(this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public Signaler signaler() {
        return this.signaler;
    }

    public String master() {
        return this.master;
    }

    public String appName() {
        return this.appName;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public String sparkHome() {
        return this.sparkHome;
    }

    public Tuple2<String, String> envPair() {
        return this.envPair;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public DStream<Object> addInputStream(StreamingContext s) {
        IndexedSeq input = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable)i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), BoxesRunTime.unboxToInt((Object)i)));
        TestInputStream inputStream = new TestInputStream(s, input, 1, ClassTag$.MODULE$.Int());
        return inputStream;
    }

    public String createValidCheckpoint() {
        String testDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
        String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
        this.ssc_$eq(new StreamingContext(this.conf().clone().set("someKey", "someValue"), this.batchDuration()));
        this.ssc().checkpoint(checkpointDirectory);
        this.ssc().textFileStream(testDirectory).foreachRDD((Function1 & Serializable)rdd -> {
            rdd.count();
            return BoxedUnit.UNIT;
        });
        this.ssc().start();
        try {
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds()), (Function0 & Serializable)() -> {
                int $org_scalatest_assert_macro_left = Checkpoint$.MODULE$.getCheckpointFiles(checkpointDirectory, Checkpoint$.MODULE$.getCheckpointFiles$default$2()).size();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
        }
        finally {
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
        }
        return checkpointDirectory;
    }

    public String createCorruptedCheckpoint() {
        String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
        Path fakeCheckpointFile = Checkpoint$.MODULE$.checkpointFile(checkpointDirectory, new Time(1000L));
        FileUtils.write((File)new File(fakeCheckpointFile.toString()), (CharSequence)"blablabla", (Charset)StandardCharsets.UTF_8);
        Seq $org_scalatest_assert_macro_left = Checkpoint$.MODULE$.getCheckpointFiles(checkpointDirectory, Checkpoint$.MODULE$.getCheckpointFiles$default$2());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
        return checkpointDirectory;
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$19(int x) {
        return new Tuple2.mcII.sp(x, 1);
    }

    public static final /* synthetic */ void $anonfun$new$22(VolatileObjectRef jobGroupFound$1, SparkContext sc$1, VolatileObjectRef jobDescFound$1, VolatileObjectRef jobInterruptFound$1, VolatileObjectRef customPropFound$1, VolatileBooleanRef allFound$1, RDD rdd) {
        jobGroupFound$1.elem = sc$1.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID());
        jobDescFound$1.elem = sc$1.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        jobInterruptFound$1.elem = sc$1.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_INTERRUPT_ON_CANCEL());
        customPropFound$1.elem = sc$1.getLocalProperty("customPropKey");
        allFound$1.elem = true;
    }

    public static final /* synthetic */ void $anonfun$new$35(StreamingContextSuite $this, VolatileIntRef runningCount$1, RDD rdd) {
        long count = BoxesRunTime.unboxToLong((Object)rdd.first());
        runningCount$1.elem += (int)count;
        $this.logInfo((Function0 & Serializable)() -> "Count = " + count + ", Running count = " + runningCount$1.elem);
    }

    public static final /* synthetic */ void $anonfun$new$41(RDD x$1) {
    }

    public static final /* synthetic */ void $anonfun$new$45(StreamingContextSuite $this, IntRef runningCount$2, RDD rdd) {
        long count = BoxesRunTime.unboxToLong((Object)rdd.first());
        runningCount$2.elem += (int)count;
        $this.logInfo((Function0 & Serializable)() -> "Count = " + count + ", Running count = " + runningCount$2.elem);
    }

    private final StreamingContext creatingFunction$1(BooleanRef newContextCreated$1, SparkConf conf$1) {
        newContextCreated$1.elem = true;
        return new StreamingContext(conf$1, this.batchDuration());
    }

    private final void testGetOrCreate$1(Function0 body, BooleanRef newContextCreated$1) {
        newContextCreated$1.elem = false;
        try {
            body.apply$mcV$sp();
        }
        finally {
            if (this.ssc() != null) {
                StreamingContext qual$1 = this.ssc();
                boolean x$1 = qual$1.stop$default$1();
                qual$1.stop(x$1);
            }
            this.ssc_$eq(null);
        }
    }

    private final StreamingContext creatingFunc$1(SparkContext sc, BooleanRef newContextCreated$2) {
        newContextCreated$2.elem = true;
        StreamingContext newSsc = new StreamingContext(sc, this.batchDuration());
        DStream<Object> input = this.addInputStream(newSsc);
        input.foreachRDD((Function1 & Serializable)rdd -> {
            rdd.count();
            return BoxedUnit.UNIT;
        });
        return newSsc;
    }

    private final void testGetActiveOrCreate$1(Function0 body, BooleanRef newContextCreated$2) {
        newContextCreated$2.elem = false;
        try {
            body.apply$mcV$sp();
        }
        finally {
            if (this.ssc() != null) {
                this.ssc().stop(false);
            }
            this.ssc_$eq(null);
        }
    }

    private final StreamingContext creatingFunction$2(BooleanRef newContextCreated$3) {
        newContextCreated$3.elem = true;
        return new StreamingContext(this.conf(), this.batchDuration());
    }

    private final void testGetActiveOrCreate$2(Function0 body, BooleanRef newContextCreated$3) {
        Predef$.MODULE$.require(StreamingContext$.MODULE$.getActive().isEmpty());
        newContextCreated$3.elem = false;
        try {
            body.apply$mcV$sp();
        }
        finally {
            if (this.ssc() != null) {
                StreamingContext qual$1 = this.ssc();
                boolean x$1 = qual$1.stop$default$1();
                qual$1.stop(x$1);
            }
            this.ssc_$eq(null);
        }
    }

    private final void testForException$1(String clue, String expectedErrorMsg, Function0 body) {
        this.withClue(clue, (Function0 & Serializable)() -> {
            IllegalStateException ex = (IllegalStateException)this.intercept(body, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
            String $org_scalatest_assert_macro_left = ex.getMessage().toLowerCase(Locale.ROOT);
            String $org_scalatest_assert_macro_right = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
        });
    }

    private final StreamingContext creatingFunction$3(String checkpointDirectory$1) {
        StreamingContext _ssc = new StreamingContext(this.conf(), this.batchDuration());
        SparkContext qual$1 = _ssc.sparkContext();
        Range.Inclusive x$1 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10);
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$1, x$2, (ClassTag)ClassTag$.MODULE$.Int());
        _ssc.checkpoint(checkpointDirectory$1);
        _ssc.queueStream((Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RDD[]{rdd})), _ssc.queueStream$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).register();
        return _ssc;
    }

    public static final /* synthetic */ void $anonfun$new$133(StreamingContextSuite $this, VolatileBooleanRef stopping$1, CountDownLatch latch$1, RDD rdd) {
        if (BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.longArrayOps((long[])rdd.collect())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) > 0L && !stopping$1.elem) {
            stopping$1.elem = true;
            new Thread($this, latch$1){
                private final /* synthetic */ StreamingContextSuite $outer;
                private final CountDownLatch latch$1;

                public void run() {
                    this.$outer.ssc().stop(true, false);
                    this.latch$1.countDown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.latch$1 = latch$1;
                    this.setDaemon(true);
                }
            }.start();
            return;
        }
    }

    public StreamingContextSuite() {
        LocalStreamingContext.$init$(this);
        this.signaler = ThreadSignaler$.MODULE$;
        this.master = "local[2]";
        this.appName = this.getClass().getSimpleName();
        this.batchDuration = Milliseconds$.MODULE$.apply(500L);
        this.sparkHome = "someDir";
        this.envPair = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)"value");
        this.conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
        this.test("from no conf constructor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().sparkContext().conf().get("spark.master"));
            String $org_scalatest_assert_macro_right = this.master();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().sparkContext().conf().get("spark.app.name"));
            String $org_scalatest_assert_macro_right2 = this.appName();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("from no conf + spark home", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), this.sparkHome(), (Seq)Nil$.MODULE$, StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().conf().get("spark.home"));
            String $org_scalatest_assert_macro_right = this.sparkHome();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("from no conf + spark home + env", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), this.sparkHome(), (Seq)Nil$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.envPair()}))));
            Seq $org_scalatest_assert_macro_left = this.ssc().conf().getExecutorEnv();
            Tuple2<String, String> $org_scalatest_assert_macro_right = this.envPair();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("from conf with settings", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.dummyTimeConfig", "10s");
            this.ssc_$eq(new StreamingContext(myConf, this.batchDuration()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc().conf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("from existing SparkContext", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkContext sc = new SparkContext(this.master(), this.appName());
            this.ssc_$eq(new StreamingContext(sc, this.batchDuration()));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("from existing SparkContext with settings", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.dummyTimeConfig", "10s");
            this.ssc_$eq(new StreamingContext(myConf, this.batchDuration()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc().conf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("from checkpoint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.dummyTimeConfig", "10s");
            StreamingContext ssc1 = new StreamingContext(myConf, this.batchDuration());
            this.addInputStream(ssc1).register();
            ssc1.start();
            Checkpoint cp = new Checkpoint(ssc1, new Time(1000L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)Utils$.MODULE$.timeStringAsSeconds((String)Predef$.MODULE$.wrapRefArray((Object[])cp.sparkConfPairs()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse((Object)"spark.dummyTimeConfig", (Function0 & Serializable)() -> "-1"))));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            ssc1.stop(ssc1.stop$default$1());
            Checkpoint newCp = (Checkpoint)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize((Object)cp));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newCp.createSparkConf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            this.ssc_$eq(new StreamingContext(null, newCp, null));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.ssc().conf().getTimeAsSeconds("spark.dummyTimeConfig", "-1")));
            int $org_scalatest_assert_macro_right3 = 10;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("checkPoint from conf", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
            SparkConf myConf = SparkContext$.MODULE$.updatedConf(new SparkConf(false), this.master(), this.appName(), SparkContext$.MODULE$.updatedConf$default$4(), SparkContext$.MODULE$.updatedConf$default$5(), SparkContext$.MODULE$.updatedConf$default$6());
            myConf.set("spark.streaming.checkpoint.directory", checkpointDirectory);
            this.ssc_$eq(new StreamingContext(myConf, this.batchDuration()));
            String $org_scalatest_assert_macro_left = this.ssc().checkpointDir();
            Object $org_scalatest_assert_macro_right = null;
            String string = $org_scalatest_assert_macro_left;
            Object var6_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, string == null ? var6_5 != null : !string.equals(var6_5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("state matching", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StreamingContextState.INITIALIZED);
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.INITIALIZED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            StreamingContextState $org_scalatest_assert_macro_left2 = StreamingContextState.INITIALIZED;
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            StreamingContextState streamingContextState = $org_scalatest_assert_macro_left2;
            StreamingContextState streamingContextState2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, streamingContextState == null ? streamingContextState2 != null : !streamingContextState.equals(streamingContextState2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("start and stop state check", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.INITIALIZED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.ssc().start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right3 = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            return (Exception)this.intercept((Function0 & Serializable)() -> {
                SparkContext qual$2 = this.ssc().sparkContext();
                Range.Inclusive x$2 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10);
                int x$3 = qual$2.makeRDD$default$2();
                return qual$2.makeRDD((Seq)x$2, x$3, (ClassTag)ClassTag$.MODULE$.Int());
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("start with non-serializable DStream checkpoints", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            File checkpointDir = Utils$.MODULE$.createTempDir();
            this.ssc_$eq(new StreamingContext(this.conf(), this.batchDuration()));
            this.ssc().checkpoint(checkpointDir.getAbsolutePath());
            this.addInputStream(this.ssc()).foreachRDD((Function1 & Serializable)rdd -> {
                cfr_ignored_0 = rdd.count() + this.appName();
                return BoxedUnit.UNIT;
            });
            NotSerializableException exception = (NotSerializableException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc().start(), ClassTag$.MODULE$.apply(NotSerializableException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "DStreams with their functions are not serializable";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            Option $org_scalatest_assert_macro_left3 = StreamingContext$.MODULE$.getActive();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("start failure should stop internal components", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.conf(), this.batchDuration()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            Function2 & Serializable updateFunc = (Function2 & Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)))));
            DStream$.MODULE$.toPairDStreamFunctions(inputStream.map((Function1 & Serializable)x -> StreamingContextSuite.$anonfun$new$19(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey((Function2)updateFunc, (ClassTag)ClassTag$.MODULE$.Int());
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc().start(), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.ssc().scheduler().isStarted()));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("start should set local properties of streaming jobs correctly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.conf(), this.batchDuration()));
            this.ssc().sc().setJobGroup("non-streaming", "non-streaming", true);
            SparkContext sc = this.ssc().sc();
            VolatileObjectRef jobGroupFound = VolatileObjectRef.create((Object)"");
            VolatileObjectRef jobDescFound = VolatileObjectRef.create((Object)"");
            VolatileObjectRef jobInterruptFound = VolatileObjectRef.create((Object)"");
            VolatileObjectRef customPropFound = VolatileObjectRef.create((Object)"");
            VolatileBooleanRef allFound = VolatileBooleanRef.create((boolean)false);
            this.addInputStream(this.ssc()).foreachRDD((Function1 & Serializable)rdd -> {
                StreamingContextSuite.$anonfun$new$22(jobGroupFound, sc, jobDescFound, jobInterruptFound, customPropFound, allFound, rdd);
                return BoxedUnit.UNIT;
            });
            this.ssc().sc().setLocalProperty("customPropKey", "value1");
            this.ssc().start();
            this.ssc().sc().setLocalProperty("customPropKey", "value2");
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).milliseconds()), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(allFound$1.elem, "allFound", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer((String)jobGroupFound.elem);
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            String $org_scalatest_assert_macro_left2 = (String)jobDescFound.elem;
            String $org_scalatest_assert_macro_right2 = "Streaming job from";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer((String)jobInterruptFound.elem);
            String $org_scalatest_assert_macro_right3 = "false";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer((String)customPropFound.elem);
            String $org_scalatest_assert_macro_right4 = "value1";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID()));
            String $org_scalatest_assert_macro_right5 = "non-streaming";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION()));
            String $org_scalatest_assert_macro_right6 = "non-streaming";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_INTERRUPT_ON_CANCEL()));
            String $org_scalatest_assert_macro_right7 = "true";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(sc.getLocalProperty("customPropKey"));
            String $org_scalatest_assert_macro_right8 = "value2";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("start multiple times", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            this.ssc().start();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("stop multiple times", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            StreamingContext qual$3 = this.ssc();
            boolean x$4 = qual$3.stop$default$1();
            qual$3.stop(x$4);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            StreamingContext qual$4 = this.ssc();
            boolean x$5 = qual$4.stop$default$1();
            qual$4.stop(x$5);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right2 = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("stop before start", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            StreamingContext qual$5 = this.ssc();
            boolean x$6 = qual$5.stop$default$1();
            qual$5.stop(x$6);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        this.test("start after stop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            StreamingContext qual$6 = this.ssc();
            boolean x$7 = qual$6.stop$default$1();
            qual$6.stop(x$7);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc().start(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("stop only streaming context", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            SparkContext sc = this.ssc().sparkContext();
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            this.ssc().stop(false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            SparkContext qual$7 = sc;
            Range.Inclusive x$8 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100);
            int x$9 = qual$7.makeRDD$default$2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((int[])qual$7.makeRDD((Seq)x$8, x$9, (ClassTag)ClassTag$.MODULE$.Int()).collect()).length));
            int $org_scalatest_assert_macro_right2 = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            sc.stop();
            conf.set("spark.streaming.stopSparkContextByDefault", "false");
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            sc = this.ssc().sparkContext();
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            StreamingContext qual$8 = this.ssc();
            boolean x$10 = qual$8.stop$default$1();
            qual$8.stop(x$10);
            SparkContext qual$9 = sc;
            Range.Inclusive x$11 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100);
            int x$12 = qual$9.makeRDD$default$2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((int[])qual$9.makeRDD((Seq)x$11, x$12, (ClassTag)ClassTag$.MODULE$.Int()).collect()).length));
            int $org_scalatest_assert_macro_right3 = 100;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            sc.stop();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("stop(stopSparkContext=true) after stop(stopSparkContext=false)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            this.addInputStream(this.ssc()).register();
            this.ssc().stop(false);
            SparkContext qual$10 = this.ssc().sc();
            Range.Inclusive x$13 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100);
            int x$14 = qual$10.makeRDD$default$2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((int[])qual$10.makeRDD((Seq)x$13, x$14, (ClassTag)ClassTag$.MODULE$.Int()).collect()).length));
            int $org_scalatest_assert_macro_right = 100;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            this.ssc().stop(true);
            return (Exception)this.intercept((Function0 & Serializable)() -> {
                SparkContext qual$11 = this.ssc().sc();
                Range.Inclusive x$15 = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100);
                int x$16 = qual$11.makeRDD$default$2();
                return (int[])qual$11.makeRDD((Seq)x$15, x$16, (ClassTag)ClassTag$.MODULE$.Int()).collect();
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.test("stop gracefully", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set("spark.dummyTimeConfig", "3600s");
            SparkContext sc = new SparkContext(conf);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                this.logInfo((Function0 & Serializable)() -> "==================================\n\n\n");
                this.ssc_$eq(new StreamingContext(sc, Milliseconds$.MODULE$.apply(100L)));
                VolatileIntRef runningCount = VolatileIntRef.create((int)0);
                TestReceiver$.MODULE$.counter().set(1);
                ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new TestReceiver(), (ClassTag)ClassTag$.MODULE$.Int());
                input.count().foreachRDD((Function1 & Serializable)rdd -> {
                    StreamingContextSuite.$anonfun$new$35(this, runningCount, rdd);
                    return BoxedUnit.UNIT;
                });
                this.ssc().start();
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).millis()), (Function0 & Serializable)() -> {
                    int $org_scalatest_assert_macro_left = runningCount$1.elem;
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
                }, Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
                this.ssc().stop(false, true);
                this.logInfo((Function0 & Serializable)() -> "Running count = " + runningCount$1.elem);
                this.logInfo((Function0 & Serializable)() -> "TestReceiver.counter = " + TestReceiver$.MODULE$.counter().get());
                int $org_scalatest_assert_macro_left = TestReceiver$.MODULE$.counter().get();
                int $org_scalatest_assert_macro_right = runningCount.elem + 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Received records = " + TestReceiver$.MODULE$.counter().get() + ", processed records = " + runningCount.elem), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                Thread.sleep(100L);
            });
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("stop gracefully even if a receiver misses StopReceiver", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            SparkContext sc = new SparkContext(conf);
            this.ssc_$eq(new StreamingContext(sc, Milliseconds$.MODULE$.apply(100L)));
            ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new TestReceiver(), (ClassTag)ClassTag$.MODULE$.Int());
            input.foreachRDD((Function1 & Serializable)x$1 -> {
                StreamingContextSuite.$anonfun$new$41(x$1);
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc().stop(true, true), this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338), Timed$.MODULE$.timed());
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("stop slow receiver gracefully", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set("spark.streaming.gracefulStopTimeout", "20000s");
            SparkContext sc = new SparkContext(conf);
            this.logInfo((Function0 & Serializable)() -> "==================================\n\n\n");
            this.ssc_$eq(new StreamingContext(sc, Milliseconds$.MODULE$.apply(100L)));
            IntRef runningCount = IntRef.create((int)0);
            int totalNumRecords = 15;
            int recordsPerSecond = 1;
            ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new SlowTestReceiver(totalNumRecords, recordsPerSecond), (ClassTag)ClassTag$.MODULE$.Int());
            input.count().foreachRDD((Function1 & Serializable)rdd -> {
                StreamingContextSuite.$anonfun$new$45(this, runningCount, rdd);
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            this.ssc().awaitTerminationOrTimeout(500L);
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).millis()), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SlowTestReceiver$.MODULE$.initialized(), "SlowTestReceiver.initialized", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            this.ssc().stop(false, true);
            this.logInfo((Function0 & Serializable)() -> "Running count = " + runningCount$2.elem);
            int $org_scalatest_assert_macro_left = runningCount.elem;
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            int $org_scalatest_assert_macro_left2 = runningCount.elem;
            int $org_scalatest_assert_macro_right2 = totalNumRecords;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            Thread.sleep(100L);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        this.test("registering and de-registering of streamingSource", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right = StreamingContextState.INITIALIZED;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            ArrayBuffer<Source> sources = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getSources(this.ssc().env().metricsSystem());
            StreamingSource streamingSource = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getStreamingSource(this.ssc());
            ArrayBuffer<Source> $org_scalatest_assert_macro_left2 = sources;
            StreamingSource $org_scalatest_assert_macro_right2 = streamingSource;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right3 = StreamingContextState.ACTIVE;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            StreamingContext qual$12 = this.ssc();
            boolean x$17 = qual$12.stop$default$1();
            qual$12.stop(x$17);
            ArrayBuffer<Source> sourcesAfterStop = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getSources(this.ssc().env().metricsSystem());
            StreamingSource streamingSourceAfterStop = StreamingContextSuite$.MODULE$.org$apache$spark$streaming$StreamingContextSuite$$getStreamingSource(this.ssc());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.ssc().getState());
            StreamingContextState $org_scalatest_assert_macro_right4 = StreamingContextState.STOPPED;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            ArrayBuffer<Source> $org_scalatest_assert_macro_left5 = sourcesAfterStop;
            StreamingSource $org_scalatest_assert_macro_right5 = streamingSourceAfterStop;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        this.test("SPARK-28709 registering and de-registering of progressListener", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.ssc().sc().ui().isDefined(), "StreamingContextSuite.this.ssc.sc.ui.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Spark UI is not started!", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            SparkUI sparkUI = (SparkUI)this.ssc().sc().ui().get();
            this.addInputStream(this.ssc()).register();
            this.ssc().start();
            List $org_scalatest_assert_macro_left = this.ssc().scheduler().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            List $org_scalatest_assert_macro_left2 = this.ssc().sc().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right2 = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
            SparkListener $org_scalatest_assert_macro_left3 = (SparkListener)sparkUI.getStreamingJobProgressListener().get();
            StreamingJobProgressListener $org_scalatest_assert_macro_right3 = this.ssc().progressListener();
            SparkListener sparkListener = $org_scalatest_assert_macro_left3;
            StreamingJobProgressListener streamingJobProgressListener = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(sparkListener != null ? !sparkListener.equals(streamingJobProgressListener) : streamingJobProgressListener != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            StreamingContext qual$13 = this.ssc();
            boolean x$18 = qual$13.stop$default$1();
            qual$13.stop(x$18);
            List $org_scalatest_assert_macro_left4 = this.ssc().scheduler().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right4 = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            List $org_scalatest_assert_macro_left5 = this.ssc().sc().listenerBus().listeners();
            StreamingJobProgressListener $org_scalatest_assert_macro_right5 = this.ssc().progressListener();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            Option $org_scalatest_assert_macro_left6 = sparkUI.getStreamingJobProgressListener();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        this.test("awaitTermination", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Exception exception;
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable)x -> x, (ClassTag)ClassTag$.MODULE$.Int()).register();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(2).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc().start(), this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419), Timed$.MODULE$.timed());
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second(), (Function0)(JFunction0.mcZ.sp & Serializable)() -> this.ssc().awaitTerminationOrTimeout(500L), this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424), Timed$.MODULE$.timed());
            Exception $org_scalatest_assert_macro_left = exception = (Exception)this.intercept((Function0 & Serializable)() -> (Nothing$)this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second(), (Function0 & Serializable)() -> {
                this.ssc().awaitTermination();
                throw new Exception("Did not wait for stop");
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430), Timed$.MODULE$.timed()), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.scalatest.exceptions.TestFailedDueToTimeoutException", $org_scalatest_assert_macro_left instanceof TestFailedDueToTimeoutException, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Did not wait for stop", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            ObjectRef t = ObjectRef.create(null);
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                t$1.elem = new Thread(this){
                    private final /* synthetic */ StreamingContextSuite $outer;

                    public void run() {
                        Thread.sleep(500L);
                        StreamingContext qual$1 = this.$outer.ssc();
                        boolean x$1 = qual$1.stop$default$1();
                        qual$1.stop(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                ((Thread)t$1.elem).start();
                this.ssc().awaitTermination();
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439), Timed$.MODULE$.timed());
            ((Thread)t.elem).join();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        this.test("awaitTermination after stop", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable)x -> x, (ClassTag)ClassTag$.MODULE$.Int()).register();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.ssc().start();
                StreamingContext qual$14 = this.ssc();
                boolean x$19 = qual$14.stop$default$1();
                qual$14.stop(x$19);
                this.ssc().awaitTermination();
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460), Timed$.MODULE$.timed());
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
        this.test("awaitTermination with error in task", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable)x -> {
                throw new TestException("error in map task");
            }, (ClassTag)ClassTag$.MODULE$.Int()).foreachRDD((Function1 & Serializable)x$2 -> {
                x$2.count();
                return BoxedUnit.UNIT;
            });
            Exception exception = (Exception)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                this.ssc().start();
                return this.ssc().awaitTerminationOrTimeout(5000L);
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "map task";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Expected exception not thrown", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        this.test("awaitTermination with error in job generation", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.transform((Function1 & Serializable)rdd -> {
                throw new TestException("error in transform");
            }, (ClassTag)ClassTag$.MODULE$.Int()).register();
            TestException exception = (TestException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                this.ssc().start();
                return this.ssc().awaitTerminationOrTimeout(5000L);
            }, ClassTag$.MODULE$.apply(TestException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "transform";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Expected exception not thrown", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        this.test("awaitTerminationOrTimeout", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> inputStream = this.addInputStream(this.ssc());
            inputStream.map((Function1)(JFunction1.mcII.sp & Serializable)x -> x, (ClassTag)ClassTag$.MODULE$.Int()).register();
            this.ssc().start();
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).second(), (Function0 & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)this.ssc().awaitTerminationOrTimeout(500L)));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500), Timed$.MODULE$.timed());
            ObjectRef t = ObjectRef.create(null);
            this.failAfter(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds(), (Function0 & Serializable)() -> {
                t$2.elem = new Thread(this){
                    private final /* synthetic */ StreamingContextSuite $outer;

                    public void run() {
                        Thread.sleep(500L);
                        StreamingContext qual$1 = this.$outer.ssc();
                        boolean x$1 = qual$1.stop$default$1();
                        qual$1.stop(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                ((Thread)t$2.elem).start();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.ssc().awaitTerminationOrTimeout(10000L), "StreamingContextSuite.this.ssc.awaitTerminationOrTimeout(10000L)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
            }, this.signaler(), Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506), Timed$.MODULE$.timed());
            ((Thread)t.elem).join();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("getOrCreate", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            BooleanRef newContextCreated = BooleanRef.create((boolean)false);
            String emptyPath = Utils$.MODULE$.createTempDir().getAbsolutePath();
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(emptyPath, (Function0 & Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var7_6 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var7_6 != null : !streamingContext.equals(var7_6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            }, newContextCreated);
            String corruptedCheckpointPath = this.createCorruptedCheckpoint();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(corruptedCheckpointPath, (Function0 & Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4())), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$20 = corruptedCheckpointPath;
                Function0 & Serializable x$21 = (Function0 & Serializable)() -> this.creatingFunction$1(newContextCreated, conf);
                boolean x$22 = false;
                Configuration x$23 = StreamingContext$.MODULE$.getOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(x$20, (Function0)x$21, x$23, false));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$24 = corruptedCheckpointPath;
                Function0 & Serializable x$25 = (Function0 & Serializable)() -> this.creatingFunction$1(newContextCreated, conf);
                boolean x$26 = true;
                Configuration x$27 = StreamingContext$.MODULE$.getOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(x$24, (Function0)x$25, x$27, true));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var11_10 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var11_10 != null : !streamingContext.equals(var11_10), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            }, newContextCreated);
            String checkpointPath = this.createValidCheckpoint();
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointPath, (Function0 & Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var7_6 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var7_6 != null : !streamingContext.equals(var7_6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"old context not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().conf().get("someKey"));
                String $org_scalatest_assert_macro_right2 = "someValue";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"checkpointed config not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
            }, newContextCreated);
            this.testGetOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                SparkContext sc = new SparkContext(conf);
                this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointPath, (Function0 & Serializable)() -> this.creatingFunction$1(newContextCreated, conf), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var8_7 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var8_7 != null : !streamingContext.equals(var8_7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$1.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"old context not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
                SparkConf $org_scalatest_assert_macro_left2 = this.ssc().conf();
                String $org_scalatest_assert_macro_right2 = "someKey";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"checkpointed config unexpectedly recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            }, newContextCreated);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        this.test("getActive and getActiveOrCreate", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Predef$.MODULE$.require(StreamingContext$.MODULE$.getActive().isEmpty(), (Function0 & Serializable)() -> "context exists from before");
            BooleanRef newContextCreated = BooleanRef.create((boolean)false);
            this.testGetActiveOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                SparkContext sc = new SparkContext(this.conf());
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var6_5 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var6_5 != null : !streamingContext.equals(var6_5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$2.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
                Option $org_scalatest_assert_macro_left2 = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"new initialized context returned before starting", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
                this.ssc().start();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(StreamingContext$.MODULE$.getActive());
                Some $org_scalatest_assert_macro_right2 = new Some((Object)this.ssc());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_right3 = this.ssc();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
                StreamingContext qual$15 = this.ssc();
                boolean x$28 = qual$15.stop$default$1();
                qual$15.stop(x$28);
                Option $org_scalatest_assert_macro_left5 = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"inactive context returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_right4 = this.ssc();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"inactive context returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            }, newContextCreated);
            this.testGetActiveOrCreate$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                SparkContext sc = new SparkContext(this.conf());
                this.ssc_$eq(this.creatingFunc$1(sc, newContextCreated));
                Option $org_scalatest_assert_macro_left = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"new initialized context returned before starting", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
                this.ssc().start();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(StreamingContext$.MODULE$.getActive());
                Some $org_scalatest_assert_macro_right = new Some((Object)this.ssc());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(StreamingContext$.MODULE$.getActiveOrCreate((Function0 & Serializable)() -> this.creatingFunc$1(sc, newContextCreated)));
                StreamingContext $org_scalatest_assert_macro_right2 = this.ssc();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"active context not returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
                StreamingContext qual$16 = this.ssc();
                boolean x$29 = qual$16.stop$default$1();
                qual$16.stop(x$29);
                Option $org_scalatest_assert_macro_left4 = StreamingContext$.MODULE$.getActive();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"inactive context returned", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
            }, newContextCreated);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        this.test("getActiveOrCreate with checkpoint", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BooleanRef newContextCreated = BooleanRef.create((boolean)false);
            String emptyPath = Utils$.MODULE$.createTempDir().getAbsolutePath();
            String corruptedCheckpointPath = this.createCorruptedCheckpoint();
            String checkpointPath = this.createValidCheckpoint();
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.ssc_$eq(new StreamingContext(this.conf().clone().set("spark.streaming.clock", "org.apache.spark.util.ManualClock"), this.batchDuration()));
                this.addInputStream(this.ssc()).register();
                this.ssc().start();
                StreamingContext returnedSsc = StreamingContext$.MODULE$.getActiveOrCreate(checkpointPath, (Function0 & Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getActiveOrCreate$default$3(), StreamingContext$.MODULE$.getActiveOrCreate$default$4());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"new context created instead of returning", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
                StreamingContext $org_scalatest_assert_macro_left = returnedSsc;
                StreamingContext $org_scalatest_assert_macro_right = this.ssc();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"returned context is not the activated context", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            }, newContextCreated);
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(emptyPath, (Function0 & Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getActiveOrCreate$default$3(), StreamingContext$.MODULE$.getActiveOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var6_5 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var6_5 != null : !streamingContext.equals(var6_5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            }, newContextCreated);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(corruptedCheckpointPath, (Function0 & Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4())), ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$30 = corruptedCheckpointPath;
                Function0 & Serializable x$31 = (Function0 & Serializable)() -> this.creatingFunction$2(newContextCreated);
                boolean x$32 = false;
                Configuration x$33 = StreamingContext$.MODULE$.getActiveOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(x$30, (Function0)x$31, x$33, false));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$34 = corruptedCheckpointPath;
                Function0 & Serializable x$35 = (Function0 & Serializable)() -> this.creatingFunction$2(newContextCreated);
                boolean x$36 = true;
                Configuration x$37 = StreamingContext$.MODULE$.getActiveOrCreate$default$3();
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(x$34, (Function0)x$35, x$37, true));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var10_9 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var10_9 != null : !streamingContext.equals(var10_9), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"new context not created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
            }, newContextCreated);
            this.testGetActiveOrCreate$2((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.ssc_$eq(StreamingContext$.MODULE$.getActiveOrCreate(checkpointPath, (Function0 & Serializable)() -> this.creatingFunction$2(newContextCreated), StreamingContext$.MODULE$.getActiveOrCreate$default$3(), StreamingContext$.MODULE$.getActiveOrCreate$default$4()));
                StreamingContext $org_scalatest_assert_macro_left = this.ssc();
                Object $org_scalatest_assert_macro_right = null;
                StreamingContext streamingContext = $org_scalatest_assert_macro_left;
                Object var6_5 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext == null ? var6_5 != null : !streamingContext.equals(var6_5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no context created", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(newContextCreated$3.elem, "newContextCreated", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"old context not recovered", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.ssc().conf().get("someKey"));
                String $org_scalatest_assert_macro_right2 = "someValue";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
            }, newContextCreated);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
        this.test("multiple streaming contexts", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkContext sc = new SparkContext(this.conf().clone().set("spark.streaming.clock", "org.apache.spark.util.ManualClock"));
            this.ssc_$eq(new StreamingContext(sc, Seconds$.MODULE$.apply(1L)));
            DStream<Object> input = this.addInputStream(this.ssc());
            input.foreachRDD((Function1 & Serializable)rdd -> {
                rdd.count();
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            StreamingContext anotherSsc = new StreamingContext(sc, Seconds$.MODULE$.apply(10L));
            DStream<Object> anotherInput = this.addInputStream(anotherSsc);
            anotherInput.foreachRDD((Function1 & Serializable)rdd -> {
                rdd.count();
                return BoxedUnit.UNIT;
            });
            IllegalStateException exception = (IllegalStateException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> anotherSsc.start(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "StreamingContext";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Did not get the right exception", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        this.test("DStream and generated RDD creation sites", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> testPackage$.MODULE$.test(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
        this.test("throw exception on using active or stopped context", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName()).set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
            this.ssc_$eq(new StreamingContext(conf, this.batchDuration()));
            Predef$.MODULE$.require(this.convertToEqualizer(this.ssc().getState()).$eq$eq$eq((Object)StreamingContextState.INITIALIZED, Equality$.MODULE$.default()));
            DStream<Object> input = this.addInputStream(this.ssc());
            DStream transformed = input.map((Function1)(JFunction1.mcII.sp & Serializable)x -> x, (ClassTag)ClassTag$.MODULE$.Int());
            transformed.foreachRDD((Function1 & Serializable)rdd -> {
                rdd.count();
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            Predef$.MODULE$.require(this.convertToEqualizer(this.ssc().getState()).$eq$eq$eq((Object)StreamingContextState.ACTIVE, Equality$.MODULE$.default()));
            this.testForException$1("no error on adding input after start", "start", (Function0)(JFunction0.mcV.sp & Serializable)() -> this.addInputStream(this.ssc()));
            this.testForException$1("no error on adding transformation after start", "start", (Function0)(JFunction0.mcV.sp & Serializable)() -> input.map((Function1)(JFunction1.mcII.sp & Serializable)x -> x * 2, (ClassTag)ClassTag$.MODULE$.Int()));
            this.testForException$1("no error on adding output operation after start", "start", (Function0)(JFunction0.mcV.sp & Serializable)() -> transformed.foreachRDD((Function1 & Serializable)rdd -> {
                rdd.collect();
                return BoxedUnit.UNIT;
            }));
            StreamingContext qual$17 = this.ssc();
            boolean x$38 = qual$17.stop$default$1();
            qual$17.stop(x$38);
            Predef$.MODULE$.require(this.convertToEqualizer(this.ssc().getState()).$eq$eq$eq((Object)StreamingContextState.STOPPED, Equality$.MODULE$.default()));
            this.testForException$1("no error on adding input after stop", "stop", (Function0)(JFunction0.mcV.sp & Serializable)() -> this.addInputStream(this.ssc()));
            this.testForException$1("no error on adding transformation after stop", "stop", (Function0)(JFunction0.mcV.sp & Serializable)() -> input.map((Function1)(JFunction1.mcII.sp & Serializable)x -> x * 2, (ClassTag)ClassTag$.MODULE$.Int()));
            this.testForException$1("no error on adding output operation after stop", "stop", (Function0)(JFunction0.mcV.sp & Serializable)() -> transformed.foreachRDD((Function1 & Serializable)rdd -> {
                rdd.collect();
                return BoxedUnit.UNIT;
            }));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        this.test("queueStream doesn't support checkpointing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String checkpointDirectory = Utils$.MODULE$.createTempDir().getAbsolutePath();
            this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointDirectory, (Function0 & Serializable)() -> this.creatingFunction$3(checkpointDirectory), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4()));
            this.ssc().start();
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable)() -> {
                int $org_scalatest_assert_macro_left = Checkpoint$.MODULE$.getCheckpointFiles(checkpointDirectory, Checkpoint$.MODULE$.getCheckpointFiles$default$2()).size();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
            StreamingContext qual$18 = this.ssc();
            boolean x$39 = qual$18.stop$default$1();
            qual$18.stop(x$39);
            SparkException e = (SparkException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.ssc_$eq(StreamingContext$.MODULE$.getOrCreate(checkpointDirectory, (Function0 & Serializable)() -> this.creatingFunction$3(checkpointDirectory), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4())), ClassTag$.MODULE$.apply(SparkException.class), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808))));
            String $org_scalatest_assert_macro_left = e.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "queueStream doesn't support checkpointing. Please don't use queueStream when checkpointing is enabled.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
        this.test("Creating an InputDStream but not using it should not crash", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.ssc_$eq(new StreamingContext(this.master(), this.appName(), this.batchDuration(), StreamingContext$.MODULE$.$lessinit$greater$default$4(), StreamingContext$.MODULE$.$lessinit$greater$default$5(), StreamingContext$.MODULE$.$lessinit$greater$default$6()));
            DStream<Object> input1 = this.addInputStream(this.ssc());
            DStream<Object> input2 = this.addInputStream(this.ssc());
            TestOutputStream<Object> output = new TestOutputStream<Object>(input2, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), (ClassTag<Object>)ClassTag$.MODULE$.Int());
            output.register();
            BatchCounter batchCount = new BatchCounter(this.ssc());
            this.ssc().start();
            batchCount.waitUntilBatchesCompleted(2, 10000L);
            this.ssc().awaitTerminationOrTimeout(1L);
            StreamingContext qual$19 = this.ssc();
            boolean x$40 = qual$19.stop$default$1();
            qual$19.stop(x$40);
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        this.test("SPARK-18560 Receiver data should be deserialized properly.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local-cluster[2,1,1024]").setAppName(this.appName());
            this.ssc_$eq(new StreamingContext(conf, Milliseconds$.MODULE$.apply(100L)));
            ReceiverInputDStream input = this.ssc().receiverStream((Receiver)new TestReceiver(), (ClassTag)ClassTag$.MODULE$.Int());
            CountDownLatch latch = new CountDownLatch(1);
            VolatileBooleanRef stopping = VolatileBooleanRef.create((boolean)false);
            input.count().foreachRDD((Function1 & Serializable)rdd -> {
                StreamingContextSuite.$anonfun$new$133(this, stopping, latch, rdd);
                return BoxedUnit.UNIT;
            });
            this.ssc().start();
            this.ssc().awaitTerminationOrTimeout(60000L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(latch.await(60L, TimeUnit.SECONDS), "latch.await(60L, SECONDS)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
        this.test("SPARK-22955 graceful shutdown shouldn't lead to job generation error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster(this.master()).setAppName(this.appName());
            conf.set("spark.streaming.clock", ManualClock.class.getName());
            conf.set("spark.streaming.gracefulStopTimeout", "60s");
            this.ssc_$eq(new StreamingContext(conf, Milliseconds$.MODULE$.apply(100L)));
            new InputDStream<Object>(this){
                private volatile boolean stopped;

                private boolean stopped() {
                    return this.stopped;
                }

                private void stopped_$eq(boolean x$1) {
                    this.stopped = x$1;
                }

                public void start() {
                }

                public void stop() {
                    this.stopped_$eq(true);
                }

                public Option<RDD<Object>> compute(Time validTime) {
                    if (this.stopped()) {
                        throw new IllegalStateException("Already stopped");
                    }
                    return new Some((Object)this.ssc().sc().emptyRDD((ClassTag)ClassTag$.MODULE$.Int()));
                }
                {
                    this.stopped = false;
                }
            }.register();
            this.ssc().start();
            ((ManualClock)this.ssc().scheduler().clock()).setTime(Long.MAX_VALUE);
            this.ssc().stop(true, true);
            this.ssc().awaitTermination();
        }, new Position("StreamingContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
        Statics.releaseFence();
    }
}

