/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.rdd;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogWriter;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001\u0002\u0010 \u0001)BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019\u0011\u0005\u0001)A\u0005w!91\t\u0001a\u0001\n\u0003!\u0005b\u0002%\u0001\u0001\u0004%\t!\u0013\u0005\u0007%\u0002\u0001\u000b\u0015B#\t\u000fM\u0003\u0001\u0019!C\u0001)\"91\f\u0001a\u0001\n\u0003a\u0006B\u00020\u0001A\u0003&Q\u000bC\u0004`\u0001\u0001\u0007I\u0011\u00011\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\"1!\u000e\u0001Q!\n\u0005Dqa\u001b\u0001A\u0002\u0013\u0005A\u000eC\u0004v\u0001\u0001\u0007I\u0011\u0001<\t\ra\u0004\u0001\u0015)\u0003n\u0011\u0015I\b\u0001\"\u0011{\u0011\u0015Y\b\u0001\"\u0011{\u0011\u0015a\b\u0001\"\u0011{\u0011\u0015i\b\u0001\"\u0003\u007f\u0011%\tI\u0001AI\u0001\n\u0013\tY\u0001\u0003\u0004\u0002\"\u0001!IA\u001f\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011%\tY\u0005AI\u0001\n\u0013\ti\u0005C\u0005\u0002R\u0001\t\n\u0011\"\u0003\u0002N!I\u00111\u000b\u0001\u0012\u0002\u0013%\u0011Q\n\u0005\b\u0003+\u0002A\u0011BA,\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u0013\u0001e\u0016:ji\u0016\f\u0005.Z1e\u0019><')Y2lK\u0012\u0014En\\2l%\u0012#5+^5uK*\u0011\u0001%I\u0001\u0004e\u0012$'B\u0001\u0012$\u0003%\u0019HO]3b[&twM\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0016\u0011\u00051jS\"A\u0012\n\u00059\u001a#!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u0002?\u0005!1m\u001c8g+\u0005)\u0004C\u0001\u00177\u0013\t94EA\u0005Ta\u0006\u00148nQ8oM\u0006)1m\u001c8gA\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003m\u0002\"\u0001\u0010!\u000e\u0003uR!a\r \u000b\u0005}*\u0013A\u00025bI>|\u0007/\u0003\u0002B{\ti1i\u001c8gS\u001e,(/\u0019;j_:\f1\u0002[1e_>\u00048i\u001c8gA\u0005a1\u000f]1sW\u000e{g\u000e^3yiV\tQ\t\u0005\u0002-\r&\u0011qi\t\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0011gB\f'o[\"p]R,\u0007\u0010^0%KF$\"A\u0013)\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\tUs\u0017\u000e\u001e\u0005\b#\u001e\t\t\u00111\u0001F\u0003\rAH%M\u0001\u000egB\f'o[\"p]R,\u0007\u0010\u001e\u0011\u0002\u0019\tdwnY6NC:\fw-\u001a:\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001W\u0012\u0002\u000fM$xN]1hK&\u0011!l\u0016\u0002\r\u00052|7m['b]\u0006<WM]\u0001\u0011E2|7m['b]\u0006<WM]0%KF$\"AS/\t\u000fES\u0011\u0011!a\u0001+\u0006i!\r\\8dW6\u000bg.Y4fe\u0002\n\u0011c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013$\u0003)\u0019XM]5bY&TXM]\u0005\u0003M\u000e\u0014\u0011cU3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s\u0003U\u0019XM]5bY&TXM]'b]\u0006<WM]0%KF$\"AS5\t\u000fEk\u0011\u0011!a\u0001C\u0006\u00112/\u001a:jC2L'0\u001a:NC:\fw-\u001a:!\u0003\r!\u0017N]\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0003S>T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n!a)\u001b7f\u0003\u001d!\u0017N]0%KF$\"AS<\t\u000fE\u0003\u0012\u0011!a\u0001[\u0006!A-\u001b:!\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002\u0015\u0006I\u0011M\u001a;fe\u0016\u000b7\r[\u0001\tC\u001a$XM]!mY\u0006\u0001\u0012N\\5u'B\f'o[\"p]R,\u0007\u0010\u001e\u000b\u0003\u0015~D\u0011\"!\u0001\u0016!\u0003\u0005\r!a\u0001\u0002\u000b}\u001bwN\u001c4\u0011\t-\u000b)!N\u0005\u0004\u0003\u000fa%AB(qi&|g.\u0001\u000ej]&$8\u000b]1sW\u000e{g\u000e^3yi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e)\"\u00111AA\bW\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000e\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0011Q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E:u_B\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u001d!Xm\u001d;S\t\u0012#RBSA\u0014\u0003c\t)$!\u000f\u0002D\u0005\u001d\u0003bBA\u00151\u0001\u0007\u00111F\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0011\u0007-\u000bi#C\u0002\u000201\u00131!\u00138u\u0011\u001d\t\u0019\u0004\u0007a\u0001\u0003W\t\u0011C\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018J\u001c\"N\u0011\u001d\t9\u0004\u0007a\u0001\u0003W\t!C\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018J\\,B\u0019\"I\u00111\b\r\u0011\u0002\u0003\u0007\u0011QH\u0001\u0011i\u0016\u001cH/S:CY>\u001c7NV1mS\u0012\u00042aSA \u0013\r\t\t\u0005\u0014\u0002\b\u0005>|G.Z1o\u0011%\t)\u0005\u0007I\u0001\u0002\u0004\ti$A\buKN$(\t\\8dWJ+Wn\u001c<f\u0011%\tI\u0005\u0007I\u0001\u0002\u0004\ti$A\u0007uKN$8\u000b^8sK&s')T\u0001\u0012i\u0016\u001cHO\u0015#EI\u0011,g-Y;mi\u0012\"TCAA(U\u0011\ti$a\u0004\u0002#Q,7\u000f\u001e*E\t\u0012\"WMZ1vYR$S'A\tuKN$(\u000b\u0012#%I\u00164\u0017-\u001e7uIY\n\u0001dZ3oKJ\fG/Z,B\u0019J+7m\u001c:e\u0011\u0006tG\r\\3t)\u0019\tI&! \u0002\u0016B1\u00111LA6\u0003crA!!\u0018\u0002h9!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d%\na\u0001\u0010:p_Rt\u0014\"A'\n\u0007\u0005%D*A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0014q\u000e\u0002\u0004'\u0016\f(bAA5\u0019B!\u00111OA=\u001b\t\t)HC\u0002\u0002x\u0005\nA!\u001e;jY&!\u00111PA;\u0005u1\u0015\u000e\\3CCN,Gm\u0016:ji\u0016\f\u0005.Z1e\u0019><7+Z4nK:$\bbBA@9\u0001\u0007\u0011\u0011Q\u0001\nE2|7m\u001b#bi\u0006\u0004b!a\u0017\u0002l\u0005\r\u0005CBA.\u0003W\n)\t\u0005\u0003\u0002\b\u0006=e\u0002BAE\u0003\u0017\u00032!a\u0018M\u0013\r\ti\tT\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055E\nC\u0004\u0002\u0018r\u0001\r!!'\u0002\u0011\tdwnY6JIN\u0004b!a\u0017\u0002l\u0005m\u0005c\u0001,\u0002\u001e&\u0019\u0011qT,\u0003\u000f\tcwnY6JI\u0006Ir-\u001a8fe\u0006$XMR1lKJ+7m\u001c:e\u0011\u0006tG\r\\3t)\u0011\tI&!*\t\u000f\u0005\u001dV\u00041\u0001\u0002,\u0005)1m\\;oi\u0002")
public class WriteAheadLogBackedBlockRDDSuite
extends SparkFunSuite {
    private final SparkConf conf = new SparkConf().setMaster("local[2]").setAppName(this.getClass().getSimpleName());
    private final Configuration hadoopConf = new Configuration();
    private SparkContext sparkContext = null;
    private BlockManager blockManager = null;
    private SerializerManager serializerManager = null;
    private File dir = null;

    public SparkConf conf() {
        return this.conf;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public BlockManager blockManager() {
        return this.blockManager;
    }

    public void blockManager_$eq(BlockManager x$1) {
        this.blockManager = x$1;
    }

    public SerializerManager serializerManager() {
        return this.serializerManager;
    }

    public void serializerManager_$eq(SerializerManager x$1) {
        this.serializerManager = x$1;
    }

    public File dir() {
        return this.dir;
    }

    public void dir_$eq(File x$1) {
        this.dir = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.initSparkContext(this.initSparkContext$default$1());
        this.dir_$eq(Utils$.MODULE$.createTempDir());
    }

    public void afterEach() {
        try {
            Utils$.MODULE$.deleteRecursively(this.dir());
        }
        finally {
            BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        }
    }

    public void afterAll() {
        try {
            this.stopSparkContext();
        }
        finally {
            super.afterAll();
        }
    }

    private void initSparkContext(Option<SparkConf> _conf) {
        if (this.sparkContext() == null) {
            this.sparkContext_$eq(new SparkContext((SparkConf)_conf.getOrElse((Function0 & Serializable)() -> this.conf())));
            this.blockManager_$eq(this.sparkContext().env().blockManager());
            this.serializerManager_$eq(this.sparkContext().env().serializerManager());
            return;
        }
    }

    private Option<SparkConf> initSparkContext$default$1() {
        return None$.MODULE$;
    }

    private void stopSparkContext() {
        try {
            if (this.sparkContext() != null) {
                this.sparkContext().stop();
            }
            System.clearProperty("spark.driver.port");
            this.blockManager_$eq(null);
            this.serializerManager_$eq(null);
        }
        finally {
            this.sparkContext_$eq(null);
        }
    }

    private void testRDD(int numPartitions, int numPartitionsInBM, int numPartitionsInWAL, boolean testIsBlockValid, boolean testBlockRemove, boolean testStoreInBM) {
        Predef$.MODULE$.require(numPartitionsInBM <= numPartitions, (Function0 & Serializable)() -> "Can't put more partitions in BlockManager than that in RDD");
        Predef$.MODULE$.require(numPartitionsInWAL <= numPartitions, (Function0 & Serializable)() -> "Can't put more partitions in write ahead log than that in RDD");
        Seq data = (Seq)package$.MODULE$.Seq().fill(numPartitions, 10, (Function0 & Serializable)() -> Random$.MODULE$.nextString(50));
        StreamBlockId[] blockIds = (StreamBlockId[])Array$.MODULE$.fill(numPartitions, (Function0 & Serializable)() -> new StreamBlockId(Random$.MODULE$.nextInt(), (long)Random$.MODULE$.nextInt()), ClassTag$.MODULE$.apply(StreamBlockId.class));
        ((IterableOnceOps)((IterableOps)data.zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])blockIds))).take(numPartitionsInBM)).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$5(this, x0$1)));
        Seq recordHandles = (Seq)this.generateFakeRecordHandles(numPartitions - numPartitionsInWAL).$plus$plus(this.generateWALRecordHandles((Seq<Seq<String>>)((Seq)data.takeRight(numPartitionsInWAL)), (Seq<BlockId>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), numPartitionsInWAL)).toImmutableArraySeq()));
        Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), numPartitionsInBM)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$6(this, x$1))), (Function0 & Serializable)() -> "Expected blocks not in BlockManager");
        Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), numPartitions - numPartitionsInBM)), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$8(this, x$2))), (Function0 & Serializable)() -> "Unexpected blocks in BlockManager");
        Predef$.MODULE$.require(((IterableOnceOps)recordHandles.takeRight(numPartitionsInWAL)).forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$10(s))), (Function0 & Serializable)() -> "Expected blocks not in write ahead log");
        Predef$.MODULE$.require(((IterableOnceOps)recordHandles.take(numPartitions - numPartitionsInWAL)).forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$12(s))), (Function0 & Serializable)() -> "Unexpected blocks in write ahead log");
        SparkContext x$5 = this.sparkContext();
        BlockId[] x$6 = (BlockId[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), ClassTag$.MODULE$.apply(BlockId.class));
        WriteAheadLogRecordHandle[] x$7 = (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
        boolean x$8 = false;
        boolean[] x$9 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$4();
        StorageLevel x$10 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6();
        WriteAheadLogBackedBlockRDD rdd = new WriteAheadLogBackedBlockRDD(x$5, x$6, x$7, x$9, false, x$10, ClassTag$.MODULE$.apply(String.class));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rdd.collect());
        Seq $org_scalatest_assert_macro_right = (Seq)data.flatten(Predef$.MODULE$.$conforms());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        if (testIsBlockValid) {
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInBM)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitions), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "All partitions must be in BlockManager");
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInWAL)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "No partitions must be in WAL");
            WriteAheadLogBackedBlockRDD rdd2 = new WriteAheadLogBackedBlockRDD(this.sparkContext(), (BlockId[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), ClassTag$.MODULE$.apply(BlockId.class)), (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class)), (boolean[])Array$.MODULE$.fill(blockIds.length, (Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (ClassTag)ClassTag$.MODULE$.Boolean()), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), ClassTag$.MODULE$.apply(String.class));
            v0 = this.intercept((Function0 & Serializable)() -> (String[])rdd2.collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        if (testBlockRemove) {
            Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitions)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitionsInWAL), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "All partitions must be in WAL for this test");
            Predef$.MODULE$.require(numPartitionsInBM > 0, (Function0 & Serializable)() -> "Some partitions must be in BlockManager for this test");
            rdd.removeBlocks();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.collect());
            Seq $org_scalatest_assert_macro_right2 = (Seq)data.flatten(Predef$.MODULE$.$conforms());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            v1 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        } else {
            v1 = BoxedUnit.UNIT;
        }
        if (testStoreInBM) {
            SparkContext x$11 = this.sparkContext();
            BlockId[] x$12 = (BlockId[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), ClassTag$.MODULE$.apply(BlockId.class));
            WriteAheadLogRecordHandle[] x$13 = (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
            boolean x$14 = true;
            StorageLevel x$15 = StorageLevel$.MODULE$.MEMORY_ONLY();
            boolean[] x$16 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$4();
            WriteAheadLogBackedBlockRDD rdd2 = new WriteAheadLogBackedBlockRDD(x$11, x$12, x$13, x$16, true, x$15, ClassTag$.MODULE$.apply(String.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rdd2.collect());
            Seq $org_scalatest_assert_macro_right3 = (Seq)data.flatten(Predef$.MODULE$.$conforms());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$20(this, x$3))), "scala.Predef.refArrayOps[org.apache.spark.storage.StreamBlockId](blockIds).forall(((x$3: org.apache.spark.storage.StreamBlockId) => WriteAheadLogBackedBlockRDDSuite.this.blockManager.get[Nothing](x$3)((ClassTag.Nothing: scala.reflect.ClassTag[Nothing])).nonEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"All blocks not found in block manager", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            return;
        }
    }

    private boolean testRDD$default$4() {
        return false;
    }

    private boolean testRDD$default$5() {
        return false;
    }

    private boolean testRDD$default$6() {
        return false;
    }

    private Seq<FileBasedWriteAheadLogSegment> generateWALRecordHandles(Seq<Seq<String>> blockData, Seq<BlockId> blockIds) {
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)blockData.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)blockIds.size()), Equality$.MODULE$.default()));
        FileBasedWriteAheadLogWriter writer = new FileBasedWriteAheadLogWriter(new File(this.dir(), "logFile").toString(), this.hadoopConf());
        Seq segments = (Seq)((IterableOps)blockData.zip(blockIds)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq data = (Seq)tuple2._1();
                BlockId id = (BlockId)tuple2._2();
                return writer.write(this.serializerManager().dataSerialize(id, data.iterator(), ClassTag$.MODULE$.apply(String.class)).toByteBuffer());
            }
            throw new MatchError((Object)tuple2);
        });
        writer.close();
        return segments;
    }

    private Seq<FileBasedWriteAheadLogSegment> generateFakeRecordHandles(int count) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(Array$.MODULE$.fill(count, (Function0 & Serializable)() -> new FileBasedWriteAheadLogSegment("random", 0L, 0), ClassTag$.MODULE$.apply(FileBasedWriteAheadLogSegment.class))).toImmutableArraySeq();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$5(WriteAheadLogBackedBlockRDDSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq block = (Seq)tuple2._1();
            StreamBlockId blockId = (StreamBlockId)tuple2._2();
            BlockManager qual$1 = $this.blockManager();
            StreamBlockId x$1 = blockId;
            Iterator x$2 = block.iterator();
            StorageLevel x$3 = StorageLevel$.MODULE$.MEMORY_ONLY_SER();
            boolean x$4 = qual$1.putIterator$default$4();
            return qual$1.putIterator((BlockId)x$1, x$2, x$3, x$4, ClassTag$.MODULE$.apply(String.class));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$6(WriteAheadLogBackedBlockRDDSuite $this, StreamBlockId x$1) {
        return $this.blockManager().get((BlockId)x$1, ClassTag$.MODULE$.Nothing()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$8(WriteAheadLogBackedBlockRDDSuite $this, StreamBlockId x$2) {
        return $this.blockManager().get((BlockId)x$2, ClassTag$.MODULE$.Nothing()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$10(FileBasedWriteAheadLogSegment s) {
        return new File(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s.path()), "file://")).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$12(FileBasedWriteAheadLogSegment s) {
        return !new File(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s.path()), "file://")).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$20(WriteAheadLogBackedBlockRDDSuite $this, StreamBlockId x$3) {
        return $this.blockManager().get((BlockId)x$3, ClassTag$.MODULE$.Nothing()).nonEmpty();
    }

    public WriteAheadLogBackedBlockRDDSuite() {
        this.test("Read data available in both block manager and write ahead log", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 5, 5, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Read data available only in block manager, not in write ahead log", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 5, 0, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("Read data available only in write ahead log, not in block manager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 0, 5, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("Read data with partially available in block manager, and rest in write ahead log", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 3, 2, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("Test isBlockValid skips block fetching from BlockManager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 5, 0, true, this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("Test whether RDD is valid after removing blocks from block manager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$1 = 5;
            int x$2 = 5;
            int x$3 = 5;
            boolean x$4 = true;
            boolean x$5 = this.testRDD$default$4();
            boolean x$6 = this.testRDD$default$6();
            this.testRDD(5, 5, 5, x$5, true, x$6);
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("Test storing of blocks recovered from write ahead log back into block manager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$7 = 5;
            boolean x$8 = false;
            int x$9 = 5;
            boolean x$10 = true;
            boolean x$11 = this.testRDD$default$4();
            boolean x$12 = this.testRDD$default$5();
            this.testRDD(5, 0, 5, x$11, x$12, true);
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("read data in block manager and WAL with encryption on", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            this.stopSparkContext();
            try {
                SparkConf testConf = this.conf().clone().set(org.apache.spark.internal.config.package$.MODULE$.IO_ENCRYPTION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                this.initSparkContext((Option<SparkConf>)new Some((Object)testConf));
                this.testRDD(5, 3, 2, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6());
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.stopSparkContext();
            }
            return boxedUnit;
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }
}

