/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.util.CommonWriteAheadLogTests$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogSuite$;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc!\u0002\u000e\u001c\u0003\u00031\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011a\u0002!\u0011!Q\u0001\nIB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0005N\u0011\u00191\u0006\u0001)A\u0005\u001d\"9q\u000b\u0001a\u0001\n#A\u0006bB1\u0001\u0001\u0004%\tB\u0019\u0005\u0007Q\u0002\u0001\u000b\u0015B-\t\u000f%\u0004\u0001\u0019!C\tU\"91\u000e\u0001a\u0001\n#a\u0007B\u00028\u0001A\u0003&!\bC\u0004p\u0001\u0001\u0007I\u0011\u00036\t\u000fA\u0004\u0001\u0019!C\tc\"11\u000f\u0001Q!\niBq\u0001\u001e\u0001A\u0002\u0013EQ\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0003>\t\rq\u0004\u0001\u0015)\u0003w\u0011\u0015i\b\u0001\"\u0005\u007f\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u00179\u0011\"!\u0005\u001c\u0003\u0003E\t!a\u0005\u0007\u0011iY\u0012\u0011!E\u0001\u0003+Aa!\u0012\f\u0005\u0002\u0005\r\u0002\"CA\u0013-E\u0005I\u0011AA\u0014\u0011%\tiDFA\u0001\n\u0013\tyD\u0001\rD_6lwN\\,sSR,\u0017\t[3bI2{w\rV3tiNT!\u0001H\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003=}\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001O-\u0002\"\u0001K\u0015\u000e\u0003}I!AK\u0010\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tas&D\u0001.\u0015\tq3%A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0001'\f\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u00035\tG\u000e\\8x\u0005\u0006$8\r[5oOB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9!i\\8mK\u0006t\u0017aE2m_N,g)\u001b7f\u0003\u001a$XM],sSR,\u0017a\u0002;fgR$\u0016m\u001a\t\u0003w\ts!\u0001\u0010!\u0011\u0005u\"T\"\u0001 \u000b\u0005}*\u0013A\u0002\u001fs_>$h(\u0003\u0002Bi\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\tE'\u0001\u0004=S:LGO\u0010\u000b\u0005\u000f&S5\n\u0005\u0002I\u00015\t1\u0004C\u00032\t\u0001\u0007!\u0007C\u00039\t\u0001\u0007!\u0007C\u0004:\tA\u0005\t\u0019\u0001\u001e\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0003d_:4'BA*\"\u0003\u0019A\u0017\rZ8pa&\u0011Q\u000b\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0017!\fGm\\8q\u0007>tg\rI\u0001\bi\u0016l\u0007\u000fR5s+\u0005I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\tIwNC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001\\&\u0001\u0002$jY\u0016\f1\u0002^3na\u0012K'o\u0018\u0013fcR\u00111M\u001a\t\u0003g\u0011L!!\u001a\u001b\u0003\tUs\u0017\u000e\u001e\u0005\bO\"\t\t\u00111\u0001Z\u0003\rAH%M\u0001\ti\u0016l\u0007\u000fR5sA\u00059A/Z:u\t&\u0014X#\u0001\u001e\u0002\u0017Q,7\u000f\u001e#je~#S-\u001d\u000b\u0003G6DqaZ\u0006\u0002\u0002\u0003\u0007!(\u0001\u0005uKN$H)\u001b:!\u0003!!Xm\u001d;GS2,\u0017\u0001\u0004;fgR4\u0015\u000e\\3`I\u0015\fHCA2s\u0011\u001d9g\"!AA\u0002i\n\u0011\u0002^3ti\u001aKG.\u001a\u0011\u0002\u001b]\u0014\u0018\u000e^3BQ\u0016\fG\rT8h+\u00051\bC\u0001%x\u0013\tA8DA\u0007Xe&$X-\u00115fC\u0012dunZ\u0001\u0012oJLG/Z!iK\u0006$Gj\\4`I\u0015\fHCA2|\u0011\u001d9\u0017#!AA\u0002Y\fab\u001e:ji\u0016\f\u0005.Z1e\u0019><\u0007%\u0001\u0006uKN$\bK]3gSb,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA/\u0002\t1\fgnZ\u0005\u0004\u0007\u0006\r\u0011A\u00047pO\u000ecW-\u00198VaR+7\u000f\u001e\u000b\u0004G\u00065\u0001BBA\b)\u0001\u0007!'A\txC&$hi\u001c:D_6\u0004H.\u001a;j_:\f\u0001dQ8n[>twK]5uK\u0006CW-\u00193M_\u001e$Vm\u001d;t!\tAecE\u0003\u0017\u0003/\ti\u0002E\u00024\u00033I1!a\u00075\u0005\u0019\te.\u001f*fMB\u0019!,a\b\n\u0007\u0005\u00052L\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\u0014\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!\u000b+\u0007i\nYc\u000b\u0002\u0002.A!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012!C;oG\",7m[3e\u0015\r\t9\u0004N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001e\u0003c\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\t\u0005\u0005\u0003\u0002\u0002\u0005\r\u0013\u0002BA#\u0003\u0007\u0011aa\u00142kK\u000e$\b")
public abstract class CommonWriteAheadLogTests
extends SparkFunSuite
implements BeforeAndAfter {
    private final boolean allowBatching;
    private final boolean closeFileAfterWrite;
    private final String testTag;
    private final Configuration hadoopConf;
    private File tempDir;
    private String testDir;
    private String testFile;
    private WriteAheadLog writeAheadLog;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public static String $lessinit$greater$default$3() {
        return CommonWriteAheadLogTests$.MODULE$.$lessinit$greater$default$3();
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public String testDir() {
        return this.testDir;
    }

    public void testDir_$eq(String x$1) {
        this.testDir = x$1;
    }

    public String testFile() {
        return this.testFile;
    }

    public void testFile_$eq(String x$1) {
        this.testFile = x$1;
    }

    public WriteAheadLog writeAheadLog() {
        return this.writeAheadLog;
    }

    public void writeAheadLog_$eq(WriteAheadLog x$1) {
        this.writeAheadLog = x$1;
    }

    public String testPrefix() {
        String string = this.testTag;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return this.testTag + " - ";
        }
        return this.testTag;
    }

    private void logCleanUpTest(boolean waitForCompletion) {
        ManualClock manualClock = new ManualClock();
        Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
        this.writeAheadLog_$eq(WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog(this.testDir(), dataToWrite, this.closeFileAfterWrite, this.allowBatching, manualClock, false, WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$7()));
        Seq<String> logFiles = WriteAheadLogSuite$.MODULE$.getLogFilesInDirectory(this.testDir());
        int $org_scalatest_assert_macro_left = logFiles.size();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.writeAheadLog().clean(manualClock.getTimeMillis() / 2L, waitForCompletion);
        if (waitForCompletion) {
            int $org_scalatest_assert_macro_left2 = WriteAheadLogSuite$.MODULE$.getLogFilesInDirectory(this.testDir()).size();
            int $org_scalatest_assert_macro_right2 = logFiles.size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        } else {
            v0 = Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).milliseconds())), (Function0 & Serializable)() -> {
                int $org_scalatest_assert_macro_left = WriteAheadLogSuite$.MODULE$.getLogFilesInDirectory(this.testDir()).size();
                int $org_scalatest_assert_macro_right = logFiles.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }
        this.writeAheadLog().close();
        this.writeAheadLog().close();
    }

    public static final /* synthetic */ Seq $anonfun$new$4(CommonWriteAheadLogTests $this, int i) {
        Seq<String> data = WriteAheadLogSuite$.MODULE$.generateRandomData();
        String file = $this.testDir() + "/log-" + i + "-" + i;
        WriteAheadLogSuite$.MODULE$.writeDataManually(data, file, $this.allowBatching);
        return data;
    }

    public static final /* synthetic */ void $anonfun$new$10(String f) {
        FileChannel raf = new FileOutputStream(f, true).getChannel();
        raf.truncate(1L);
        raf.close();
    }

    public static final /* synthetic */ Seq $anonfun$new$14(CommonWriteAheadLogTests $this, int i) {
        Seq<String> data = WriteAheadLogSuite$.MODULE$.generateRandomData();
        String file = $this.testDir() + "/log-" + i + "-" + i;
        WriteAheadLogSuite$.MODULE$.writeDataManually(data, file, $this.allowBatching);
        return data;
    }

    public CommonWriteAheadLogTests(boolean allowBatching, boolean closeFileAfterWrite, String testTag) {
        this.allowBatching = allowBatching;
        this.closeFileAfterWrite = closeFileAfterWrite;
        this.testTag = testTag;
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.hadoopConf = new Configuration();
        this.tempDir = null;
        this.testDir = null;
        this.testFile = null;
        this.writeAheadLog = null;
        this.before((Function0<Object>)(Function0 & Serializable)() -> {
            this.tempDir_$eq(Utils$.MODULE$.createTempDir());
            this.testDir_$eq(this.tempDir().toString());
            this.testFile_$eq(new File(this.tempDir(), "testFile").toString());
            if (this.writeAheadLog() != null) {
                this.writeAheadLog().close();
                this.writeAheadLog_$eq(null);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> Utils$.MODULE$.deleteRecursively(this.tempDir()), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test(this.testPrefix() + "read all logs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IndexedSeq writtenData = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable)i -> CommonWriteAheadLogTests.$anonfun$new$4(this, BoxesRunTime.unboxToInt((Object)i)));
            Path logDirectoryPath = new Path(this.testDir());
            FileSystem fileSystem = HdfsUtils$.MODULE$.getFileSystemForPath(logDirectoryPath, this.hadoopConf());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fileSystem.exists(logDirectoryPath), "fileSystem.exists(logDirectoryPath)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Seq<String> readData = WriteAheadLogSuite$.MODULE$.readDataUsingWriteAheadLog(this.testDir(), $this.closeFileAfterWrite, $this.allowBatching);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(readData);
            IndexedSeq $org_scalatest_assert_macro_right = writtenData;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test(this.testPrefix() + "write logs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
            WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog(this.testDir(), dataToWrite, $this.closeFileAfterWrite, $this.allowBatching, WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$5(), WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$6(), WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$7());
            Seq<String> logFiles = WriteAheadLogSuite$.MODULE$.getLogFilesInDirectory(this.testDir());
            int $org_scalatest_assert_macro_left = logFiles.size();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Seq<String> writtenData = WriteAheadLogSuite$.MODULE$.readAndDeserializeDataManually(logFiles, $this.allowBatching);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(writtenData);
            Seq<String> $org_scalatest_assert_macro_right2 = dataToWrite;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test(this.testPrefix() + "read all logs after write", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<String> dataToWrite = WriteAheadLogSuite$.MODULE$.generateRandomData();
            WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog(this.testDir(), dataToWrite, $this.closeFileAfterWrite, $this.allowBatching, WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$5(), WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$6(), WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$7());
            Seq<String> logFiles = WriteAheadLogSuite$.MODULE$.getLogFilesInDirectory(this.testDir());
            int $org_scalatest_assert_macro_left = logFiles.size();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Seq<String> readData = WriteAheadLogSuite$.MODULE$.readDataUsingWriteAheadLog(this.testDir(), $this.closeFileAfterWrite, $this.allowBatching);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dataToWrite);
            Seq<String> $org_scalatest_assert_macro_right2 = readData;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test(this.testPrefix() + "clean old logs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.logCleanUpTest(false), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test(this.testPrefix() + "clean old logs synchronously", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.logCleanUpTest(true), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test(this.testPrefix() + "handling file errors while reading rotating logs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ManualClock manualClock = new ManualClock();
            Seq<String> dataToWrite1 = WriteAheadLogSuite$.MODULE$.generateRandomData();
            WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog(this.testDir(), dataToWrite1, $this.closeFileAfterWrite, $this.allowBatching, manualClock, WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$6(), WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$7());
            Seq<String> logFiles1 = WriteAheadLogSuite$.MODULE$.getLogFilesInDirectory(this.testDir());
            int $org_scalatest_assert_macro_left = logFiles1.size();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            Seq<String> dataToWrite2 = WriteAheadLogSuite$.MODULE$.generateRandomData();
            manualClock.advance(100000L);
            WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog(this.testDir(), dataToWrite2, $this.closeFileAfterWrite, $this.allowBatching, manualClock, WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$6(), WriteAheadLogSuite$.MODULE$.writeDataUsingWriteAheadLog$default$7());
            Seq<String> logFiles2 = WriteAheadLogSuite$.MODULE$.getLogFilesInDirectory(this.testDir());
            int $org_scalatest_assert_macro_left2 = logFiles2.size();
            int $org_scalatest_assert_macro_right2 = logFiles1.size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            Seq<String> readData1 = WriteAheadLogSuite$.MODULE$.readDataUsingWriteAheadLog(this.testDir(), $this.closeFileAfterWrite, $this.allowBatching);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(readData1);
            Seq $org_scalatest_assert_macro_right3 = (Seq)dataToWrite1.$plus$plus(dataToWrite2);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            logFiles1.foreach((Function1 & Serializable)f -> {
                CommonWriteAheadLogTests.$anonfun$new$10(f);
                return BoxedUnit.UNIT;
            });
            Seq<String> readData = WriteAheadLogSuite$.MODULE$.readDataUsingWriteAheadLog(this.testDir(), $this.closeFileAfterWrite, $this.allowBatching);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(readData);
            Seq<String> $org_scalatest_assert_macro_right4 = dataToWrite2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test(this.testPrefix() + "do not create directories or files unless write", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            File nonexistentTempPath = File.createTempFile("test", "");
            nonexistentTempPath.delete();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(nonexistentTempPath.exists(), "nonexistentTempPath.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            Seq<FileBasedWriteAheadLogSegment> writtenSegment = WriteAheadLogSuite$.MODULE$.writeDataManually(WriteAheadLogSuite$.MODULE$.generateRandomData(), this.testFile(), $this.allowBatching);
            WriteAheadLog wal = WriteAheadLogSuite$.MODULE$.createWriteAheadLog(this.testDir(), $this.closeFileAfterWrite, $this.allowBatching);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(nonexistentTempPath.exists(), "nonexistentTempPath.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Directory created just by creating log object", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            Object object = $this.allowBatching ? this.intercept((Function0 & Serializable)() -> wal.read((WriteAheadLogRecordHandle)writtenSegment.head()), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192)) : wal.read((WriteAheadLogRecordHandle)writtenSegment.head());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(nonexistentTempPath.exists(), "nonexistentTempPath.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Directory created just by attempting to read segment", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test(this.testPrefix() + "parallel recovery not enabled if closeFileAfterWrite = false", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IndexedSeq writtenData = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable)i -> CommonWriteAheadLogTests.$anonfun$new$14(this, BoxesRunTime.unboxToInt((Object)i)));
            WriteAheadLog wal = WriteAheadLogSuite$.MODULE$.createWriteAheadLog(this.testDir(), $this.closeFileAfterWrite, $this.allowBatching);
            Iterator readData = CollectionConverters$.MODULE$.IteratorHasAsScala(wal.readAll()).asScala().map((Function1 & Serializable)byteBuffer -> WriteAheadLogSuite$.MODULE$.byteBufferToString((ByteBuffer)byteBuffer));
            wal.close();
            if ($this.closeFileAfterWrite) {
                return this.intercept((Function0 & Serializable)() -> (String[])readData.toArray(ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(RejectedExecutionException.class), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            }
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(readData.toSeq());
            IndexedSeq $org_scalatest_assert_macro_right = writtenData;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        }, new Position("WriteAheadLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        Statics.releaseFence();
    }
}

