/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kafka010;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.io.Text;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.kafka010.KafkaDelegationTokenTest;
import org.apache.spark.kafka010.KafkaRedactionUtil$;
import org.apache.spark.kafka010.KafkaTokenClusterConf;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005a1AAA\u0002\u0001\u0019!)Q\u0003\u0001C\u0001-\t92*\u00194lCJ+G-Y2uS>tW\u000b^5m'VLG/\u001a\u0006\u0003\t\u0015\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\r\u001d\tQa\u001d9be.T!\u0001C\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0011aA8sO\u000e\u00011c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u000b%\u0011\u0001#\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005I\u0019R\"A\u0002\n\u0005Q\u0019!\u0001G&bM.\fG)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000eV3ti\u00061A(\u001b8jiz\"\u0012a\u0006\t\u0003%\u0001\u0001")
public class KafkaRedactionUtilSuite
extends SparkFunSuite
implements KafkaDelegationTokenTest {
    private SparkEnv org$apache$spark$kafka010$KafkaDelegationTokenTest$$savedSparkEnv;
    private String tokenId1;
    private String tokenPassword1;
    private String tokenId2;
    private String tokenPassword2;
    private String identifier1;
    private String identifier2;
    private Text tokenService1;
    private Text tokenService2;
    private String bootStrapServers;
    private String matchingTargetServersRegex;
    private String nonMatchingTargetServersRegex;
    private String trustStoreType;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String keyStoreType;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyPassword;
    private String keytab;
    private String principal;

    @Override
    public /* synthetic */ void org$apache$spark$kafka010$KafkaDelegationTokenTest$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$kafka010$KafkaDelegationTokenTest$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void beforeEach() {
        KafkaDelegationTokenTest.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        KafkaDelegationTokenTest.afterEach$(this);
    }

    @Override
    public void setGlobalKafkaClientConfig() {
        KafkaDelegationTokenTest.setGlobalKafkaClientConfig$(this);
    }

    @Override
    public void addTokenToUGI(Text tokenService, String tokenId, String tokenPassword) {
        KafkaDelegationTokenTest.addTokenToUGI$(this, tokenService, tokenId, tokenPassword);
    }

    @Override
    public void setSparkEnv(Iterable<Tuple2<String, String>> settings) {
        KafkaDelegationTokenTest.setSparkEnv$(this, settings);
    }

    @Override
    public KafkaTokenClusterConf createClusterConf(String identifier, String securityProtocol, Map<String, String> specifiedKafkaParams) {
        return KafkaDelegationTokenTest.createClusterConf$(this, identifier, securityProtocol, specifiedKafkaParams);
    }

    @Override
    public Map<String, String> createClusterConf$default$3() {
        return KafkaDelegationTokenTest.createClusterConf$default$3$(this);
    }

    @Override
    public SparkEnv org$apache$spark$kafka010$KafkaDelegationTokenTest$$savedSparkEnv() {
        return this.org$apache$spark$kafka010$KafkaDelegationTokenTest$$savedSparkEnv;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$$savedSparkEnv_$eq(SparkEnv x$1) {
        this.org$apache$spark$kafka010$KafkaDelegationTokenTest$$savedSparkEnv = x$1;
    }

    @Override
    public String tokenId1() {
        return this.tokenId1;
    }

    @Override
    public String tokenPassword1() {
        return this.tokenPassword1;
    }

    @Override
    public String tokenId2() {
        return this.tokenId2;
    }

    @Override
    public String tokenPassword2() {
        return this.tokenPassword2;
    }

    @Override
    public String identifier1() {
        return this.identifier1;
    }

    @Override
    public String identifier2() {
        return this.identifier2;
    }

    @Override
    public Text tokenService1() {
        return this.tokenService1;
    }

    @Override
    public Text tokenService2() {
        return this.tokenService2;
    }

    @Override
    public String bootStrapServers() {
        return this.bootStrapServers;
    }

    @Override
    public String matchingTargetServersRegex() {
        return this.matchingTargetServersRegex;
    }

    @Override
    public String nonMatchingTargetServersRegex() {
        return this.nonMatchingTargetServersRegex;
    }

    @Override
    public String trustStoreType() {
        return this.trustStoreType;
    }

    @Override
    public String trustStoreLocation() {
        return this.trustStoreLocation;
    }

    @Override
    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public String keyStoreType() {
        return this.keyStoreType;
    }

    @Override
    public String keyStoreLocation() {
        return this.keyStoreLocation;
    }

    @Override
    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public String keyPassword() {
        return this.keyPassword;
    }

    @Override
    public String keytab() {
        return this.keytab;
    }

    @Override
    public String principal() {
        return this.principal;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$tokenId1_$eq(String x$1) {
        this.tokenId1 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$tokenPassword1_$eq(String x$1) {
        this.tokenPassword1 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$tokenId2_$eq(String x$1) {
        this.tokenId2 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$tokenPassword2_$eq(String x$1) {
        this.tokenPassword2 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$identifier1_$eq(String x$1) {
        this.identifier1 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$identifier2_$eq(String x$1) {
        this.identifier2 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$tokenService1_$eq(Text x$1) {
        this.tokenService1 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$tokenService2_$eq(Text x$1) {
        this.tokenService2 = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$bootStrapServers_$eq(String x$1) {
        this.bootStrapServers = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$matchingTargetServersRegex_$eq(String x$1) {
        this.matchingTargetServersRegex = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$nonMatchingTargetServersRegex_$eq(String x$1) {
        this.nonMatchingTargetServersRegex = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$trustStoreType_$eq(String x$1) {
        this.trustStoreType = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$trustStoreLocation_$eq(String x$1) {
        this.trustStoreLocation = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$trustStorePassword_$eq(String x$1) {
        this.trustStorePassword = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$keyStoreType_$eq(String x$1) {
        this.keyStoreType = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$keyStoreLocation_$eq(String x$1) {
        this.keyStoreLocation = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$keyStorePassword_$eq(String x$1) {
        this.keyStorePassword = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$keyPassword_$eq(String x$1) {
        this.keyPassword = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$keytab_$eq(String x$1) {
        this.keytab = x$1;
    }

    @Override
    public void org$apache$spark$kafka010$KafkaDelegationTokenTest$_setter_$principal_$eq(String x$1) {
        this.principal = x$1;
    }

    public KafkaRedactionUtilSuite() {
        KafkaDelegationTokenTest.$init$(this);
        this.test("redactParams shouldn't throw exception when no SparkEnv available", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(KafkaRedactionUtil$.MODULE$.redactParams((Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)));
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("redactParams should give back empty parameters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.setSparkEnv((Iterable<Tuple2<String, String>>)Predef$.MODULE$.Map().empty());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(KafkaRedactionUtil$.MODULE$.redactParams((Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)));
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("redactParams should give back null value", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.setSparkEnv((Iterable<Tuple2<String, String>>)Predef$.MODULE$.Map().empty());
            Seq kafkaParams = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), null)}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(KafkaRedactionUtil$.MODULE$.redactParams(kafkaParams));
            Seq $org_scalatest_assert_macro_right = kafkaParams;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("redactParams should redact non String parameters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.setSparkEnv((Iterable<Tuple2<String, String>>)((Iterable)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN().key()), (Object)"key.deserializer")}))));
            Seq kafkaParams = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), StringDeserializer.class)}));
            Map redactedParams = KafkaRedactionUtil$.MODULE$.redactParams(kafkaParams).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)redactedParams.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(redactedParams.get((Object)"key.deserializer").get());
            String $org_scalatest_assert_macro_right2 = Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("redactParams should redact token password from parameters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String redactedJaasParams;
            this.setSparkEnv((Iterable<Tuple2<String, String>>)Predef$.MODULE$.Map().empty());
            String groupId = new StringBuilder(3).append("id-").append(UUID.randomUUID().toString()).toString();
            this.addTokenToUGI(this.tokenService1(), this.tokenId1(), this.tokenPassword1());
            KafkaTokenClusterConf clusterConf = this.createClusterConf(this.identifier1(), SecurityProtocol.SASL_SSL.name, this.createClusterConf$default$3());
            String jaasParams = KafkaTokenUtil$.MODULE$.getTokenJaasParams(clusterConf);
            Seq kafkaParams = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)jaasParams)}));
            Map redactedParams = KafkaRedactionUtil$.MODULE$.redactParams(kafkaParams).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)redactedParams.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(redactedParams.get((Object)"group.id").get());
            String $org_scalatest_assert_macro_right2 = groupId;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            String $org_scalatest_assert_macro_left3 = redactedJaasParams = (String)redactedParams.get((Object)"sasl.jaas.config").get();
            String $org_scalatest_assert_macro_right3 = this.tokenId1();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            String $org_scalatest_assert_macro_left4 = redactedJaasParams;
            String $org_scalatest_assert_macro_right4 = this.tokenPassword1();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("redactParams should redact passwords from parameters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.setSparkEnv((Iterable<Tuple2<String, String>>)Predef$.MODULE$.Map().empty());
            String groupId = new StringBuilder(3).append("id-").append(UUID.randomUUID().toString()).toString();
            Seq kafkaParams = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.truststore.password"), (Object)this.trustStorePassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)this.keyStorePassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.key.password"), (Object)this.keyPassword())}));
            Map redactedParams = KafkaRedactionUtil$.MODULE$.redactParams(kafkaParams).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)redactedParams.size()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(redactedParams.apply((Object)"group.id"));
            String $org_scalatest_assert_macro_right2 = groupId;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(redactedParams.apply((Object)"ssl.truststore.password"));
            String $org_scalatest_assert_macro_right3 = Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(redactedParams.apply((Object)"ssl.keystore.password"));
            String $org_scalatest_assert_macro_right4 = Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(redactedParams.apply((Object)"ssl.key.password"));
            String $org_scalatest_assert_macro_right5 = Utils$.MODULE$.REDACTION_REPLACEMENT_TEXT();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("redactJaasParam should give back null", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(KafkaRedactionUtil$.MODULE$.redactJaasParam(null));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("redactJaasParam should give back empty string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(KafkaRedactionUtil$.MODULE$.redactJaasParam(""));
            String $org_scalatest_assert_macro_right = "";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("redactJaasParam should redact token password", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String redactedJaasParams;
            this.addTokenToUGI(this.tokenService1(), this.tokenId1(), this.tokenPassword1());
            KafkaTokenClusterConf clusterConf = this.createClusterConf(this.identifier1(), SecurityProtocol.SASL_SSL.name, this.createClusterConf$default$3());
            String jaasParams = KafkaTokenUtil$.MODULE$.getTokenJaasParams(clusterConf);
            String $org_scalatest_assert_macro_left = redactedJaasParams = KafkaRedactionUtil$.MODULE$.redactJaasParam(jaasParams);
            String $org_scalatest_assert_macro_right = this.tokenId1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            String $org_scalatest_assert_macro_left2 = redactedJaasParams;
            String $org_scalatest_assert_macro_right2 = this.tokenPassword1();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("KafkaRedactionUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        Statics.releaseFence();
    }
}

