/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.hash;

import org.apache.spark.unsafe.Platform;

public final class Murmur3_x86_32 {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;

    public Murmur3_x86_32(int seed) {
        this.seed = seed;
    }

    public String toString() {
        return "Murmur3_32(seed=" + this.seed + ")";
    }

    public int hashInt(int input) {
        int k1 = Murmur3_x86_32.mixK1(input);
        int h1 = Murmur3_x86_32.mixH1(this.seed, k1);
        return Murmur3_x86_32.fmix(h1, 4);
    }

    public int hashUnsafeWords(Object base, long offset, int lengthInBytes) {
        return Murmur3_x86_32.hashUnsafeWords(base, offset, lengthInBytes, this.seed);
    }

    public static int hashUnsafeWords(Object base, long offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 8 == 0) : "lengthInBytes must be a multiple of 8 (word-aligned)";
        int h1 = seed;
        for (int i = 0; i < lengthInBytes; i += 4) {
            int halfWord = Platform.getInt(base, offset + (long)i);
            int k1 = Murmur3_x86_32.mixK1(halfWord);
            h1 = Murmur3_x86_32.mixH1(h1, k1);
        }
        return Murmur3_x86_32.fmix(h1, lengthInBytes);
    }

    public int hashLong(long input) {
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k1 = Murmur3_x86_32.mixK1(low);
        int h1 = Murmur3_x86_32.mixH1(this.seed, k1);
        k1 = Murmur3_x86_32.mixK1(high);
        h1 = Murmur3_x86_32.mixH1(h1, k1);
        return Murmur3_x86_32.fmix(h1, 8);
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

