/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe;

import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.HeapMemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.junit.Assert;
import org.junit.Test;

public class PlatformUtilSuite {
    @Test
    public void overlappingCopyMemory() {
        int i;
        byte[] data = new byte[0x300000];
        int size = 0x200000;
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        Platform.copyMemory((Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (long)size);
        for (i = 0; i < data.length; ++i) {
            Assert.assertEquals((long)((byte)i), (long)data[i]);
        }
        Platform.copyMemory((Object)data, (long)(Platform.BYTE_ARRAY_OFFSET + 1), (Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (long)size);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)((byte)(i + 1)), (long)data[i]);
        }
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        Platform.copyMemory((Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (Object)data, (long)(Platform.BYTE_ARRAY_OFFSET + 1), (long)size);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)((byte)i), (long)data[i + 1]);
        }
    }

    @Test
    public void onHeapMemoryAllocatorPoolingReUsesLongArrays() {
        MemoryBlock block1 = MemoryAllocator.HEAP.allocate(0x100000L);
        Object baseObject1 = block1.getBaseObject();
        MemoryAllocator.HEAP.free(block1);
        MemoryBlock block2 = MemoryAllocator.HEAP.allocate(0x100000L);
        Object baseObject2 = block2.getBaseObject();
        Assert.assertSame((Object)baseObject1, (Object)baseObject2);
        MemoryAllocator.HEAP.free(block2);
    }

    @Test
    public void freeingOnHeapMemoryBlockResetsBaseObjectAndOffset() {
        MemoryBlock block = MemoryAllocator.HEAP.allocate(1024L);
        Assert.assertNotNull((Object)block.getBaseObject());
        MemoryAllocator.HEAP.free(block);
        Assert.assertNull((Object)block.getBaseObject());
        Assert.assertEquals((long)0L, (long)block.getBaseOffset());
        Assert.assertEquals((long)-3L, (long)block.pageNumber);
    }

    @Test
    public void freeingOffHeapMemoryBlockResetsOffset() {
        MemoryBlock block = MemoryAllocator.UNSAFE.allocate(1024L);
        Assert.assertNull((Object)block.getBaseObject());
        Assert.assertNotEquals((long)0L, (long)block.getBaseOffset());
        MemoryAllocator.UNSAFE.free(block);
        Assert.assertNull((Object)block.getBaseObject());
        Assert.assertEquals((long)0L, (long)block.getBaseOffset());
        Assert.assertEquals((long)-3L, (long)block.pageNumber);
    }

    @Test(expected=AssertionError.class)
    public void onHeapMemoryAllocatorThrowsAssertionErrorOnDoubleFree() {
        MemoryBlock block = MemoryAllocator.HEAP.allocate(1024L);
        MemoryAllocator.HEAP.free(block);
        MemoryAllocator.HEAP.free(block);
    }

    @Test(expected=AssertionError.class)
    public void offHeapMemoryAllocatorThrowsAssertionErrorOnDoubleFree() {
        MemoryBlock block = MemoryAllocator.UNSAFE.allocate(1024L);
        MemoryAllocator.UNSAFE.free(block);
        MemoryAllocator.UNSAFE.free(block);
    }

    @Test
    public void memoryDebugFillEnabledInTest() {
        Assert.assertTrue((boolean)MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED);
        MemoryBlock onheap = MemoryAllocator.HEAP.allocate(1L);
        Assert.assertEquals((long)Platform.getByte((Object)onheap.getBaseObject(), (long)onheap.getBaseOffset()), (long)-91L);
        MemoryBlock onheap1 = MemoryAllocator.HEAP.allocate(0x100000L);
        Object onheap1BaseObject = onheap1.getBaseObject();
        long onheap1BaseOffset = onheap1.getBaseOffset();
        MemoryAllocator.HEAP.free(onheap1);
        Assert.assertEquals((long)Platform.getByte((Object)onheap1BaseObject, (long)onheap1BaseOffset), (long)90L);
        MemoryBlock onheap2 = MemoryAllocator.HEAP.allocate(0x100000L);
        Assert.assertEquals((long)Platform.getByte((Object)onheap2.getBaseObject(), (long)onheap2.getBaseOffset()), (long)-91L);
        MemoryBlock offheap = MemoryAllocator.UNSAFE.allocate(1L);
        Assert.assertEquals((long)Platform.getByte((Object)offheap.getBaseObject(), (long)offheap.getBaseOffset()), (long)-91L);
        MemoryAllocator.UNSAFE.free(offheap);
    }

    @Test
    public void heapMemoryReuse() {
        HeapMemoryAllocator heapMem = new HeapMemoryAllocator();
        MemoryBlock onheap1 = heapMem.allocate(513L);
        Object obj1 = onheap1.getBaseObject();
        heapMem.free(onheap1);
        MemoryBlock onheap2 = heapMem.allocate(514L);
        Assert.assertNotEquals((Object)obj1, (Object)onheap2.getBaseObject());
        MemoryBlock onheap3 = heapMem.allocate(0x100001L);
        Assert.assertEquals((long)onheap3.size(), (long)0x100001L);
        Object obj3 = onheap3.getBaseObject();
        heapMem.free(onheap3);
        MemoryBlock onheap4 = heapMem.allocate(0x100007L);
        Assert.assertEquals((long)onheap4.size(), (long)0x100007L);
        Assert.assertEquals((Object)obj3, (Object)onheap4.getBaseObject());
    }
}

