/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public final class CalendarInterval
implements Serializable,
Comparable<CalendarInterval> {
    public final int months;
    public final int days;
    public final long microseconds;
    public static CalendarInterval MIN_VALUE = new CalendarInterval(Integer.MIN_VALUE, Integer.MIN_VALUE, Long.MIN_VALUE);
    public static CalendarInterval MAX_VALUE = new CalendarInterval(Integer.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE);

    public CalendarInterval(int months, int days, long microseconds) {
        this.months = months;
        this.days = days;
        this.microseconds = microseconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarInterval that = (CalendarInterval)o;
        return this.months == that.months && this.days == that.days && this.microseconds == that.microseconds;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.microseconds);
    }

    @Override
    public int compareTo(CalendarInterval that) {
        long thisAdjustDays = this.microseconds / 86400000000L + (long)this.days + (long)this.months * 30L;
        long thatAdjustDays = that.microseconds / 86400000000L + (long)that.days + (long)that.months * 30L;
        long daysDiff = thisAdjustDays - thatAdjustDays;
        if (daysDiff == 0L) {
            long msDiff = this.microseconds % 86400000000L - that.microseconds % 86400000000L;
            if (msDiff == 0L) {
                return 0;
            }
            if (msDiff > 0L) {
                return 1;
            }
            return -1;
        }
        if (daysDiff > 0L) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        if (this.months == 0 && this.days == 0 && this.microseconds == 0L) {
            return "0 seconds";
        }
        StringBuilder sb = new StringBuilder();
        if (this.months != 0) {
            this.appendUnit(sb, this.months / 12, "years");
            this.appendUnit(sb, this.months % 12, "months");
        }
        this.appendUnit(sb, this.days, "days");
        if (this.microseconds != 0L) {
            long rest = this.microseconds;
            this.appendUnit(sb, rest / 3600000000L, "hours");
            this.appendUnit(sb, (rest %= 3600000000L) / 60000000L, "minutes");
            if ((rest %= 60000000L) != 0L) {
                String s = BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString();
                sb.append(s).append(" seconds ");
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void appendUnit(StringBuilder sb, long value, String unit) {
        if (value != 0L) {
            sb.append(value).append(' ').append(unit).append(' ');
        }
    }

    public Period extractAsPeriod() {
        return Period.of(0, this.months, this.days);
    }

    public Duration extractAsDuration() {
        return Duration.of(this.microseconds, ChronoUnit.MICROS);
    }
}

