/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.StringSearch;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.types.UTF8String;

public class CollationAwareUTF8String {
    public static UTF8String replace(UTF8String src, UTF8String search, UTF8String replace, int collationId) {
        int byteEnd;
        if (src.numBytes() == 0 || search.numBytes() == 0) {
            return src;
        }
        StringSearch stringSearch = CollationFactory.getStringSearch(src, search, collationId);
        int end = stringSearch.next();
        if (end == -1) {
            return src;
        }
        int c = 0;
        int byteStart = 0;
        for (byteEnd = 0; byteEnd < src.numBytes() && c < end; byteEnd += UTF8String.numBytesForFirstByte(src.getByte(byteEnd)), ++c) {
        }
        int increase = Math.max(0, Math.abs(replace.numBytes() - search.numBytes())) * 16;
        UTF8StringBuilder buf = new UTF8StringBuilder(src.numBytes() + increase);
        while (end != -1) {
            buf.appendBytes(src.getBaseObject(), src.getBaseOffset() + (long)byteStart, byteEnd - byteStart);
            buf.append(replace);
            byteStart = byteEnd;
            for (int cs = c; byteStart < src.numBytes() && cs < c + stringSearch.getMatchLength(); byteStart += UTF8String.numBytesForFirstByte(src.getByte(byteStart)), ++cs) {
            }
            end = stringSearch.next();
            while (byteEnd < src.numBytes() && c < end) {
                byteEnd += UTF8String.numBytesForFirstByte(src.getByte(byteEnd));
                ++c;
            }
        }
        buf.appendBytes(src.getBaseObject(), src.getBaseOffset() + (long)byteStart, src.numBytes() - byteStart);
        return buf.build();
    }

    public static UTF8String lowercaseReplace(UTF8String src, UTF8String search, UTF8String replace) {
        int byteEnd;
        if (src.numBytes() == 0 || search.numBytes() == 0) {
            return src;
        }
        UTF8String lowercaseString = src.toLowerCase();
        UTF8String lowercaseSearch = search.toLowerCase();
        int start = 0;
        int end = lowercaseString.indexOf(lowercaseSearch, 0);
        if (end == -1) {
            return src;
        }
        int c = 0;
        int byteStart = 0;
        for (byteEnd = 0; byteEnd < src.numBytes() && c < end; byteEnd += UTF8String.numBytesForFirstByte(src.getByte(byteEnd)), ++c) {
        }
        int increase = Math.max(0, replace.numBytes() - search.numBytes()) * 16;
        UTF8StringBuilder buf = new UTF8StringBuilder(src.numBytes() + increase);
        while (end != -1) {
            buf.appendBytes(src.getBaseObject(), src.getBaseOffset() + (long)byteStart, byteEnd - byteStart);
            buf.append(replace);
            start = end + lowercaseSearch.numChars();
            end = lowercaseString.indexOf(lowercaseSearch, start);
            byteStart = byteEnd + search.numBytes();
            while (byteEnd < src.numBytes() && c < end) {
                byteEnd += UTF8String.numBytesForFirstByte(src.getByte(byteEnd));
                ++c;
            }
        }
        buf.appendBytes(src.getBaseObject(), src.getBaseOffset() + (long)byteStart, src.numBytes() - byteStart);
        return buf.build();
    }

    public static String toUpperCase(String target, int collationId) {
        ULocale locale = CollationFactory.fetchCollation((int)collationId).collator.getLocale(ULocale.ACTUAL_LOCALE);
        return UCharacter.toUpperCase((ULocale)locale, (String)target);
    }

    public static String toLowerCase(String target, int collationId) {
        ULocale locale = CollationFactory.fetchCollation((int)collationId).collator.getLocale(ULocale.ACTUAL_LOCALE);
        return UCharacter.toLowerCase((ULocale)locale, (String)target);
    }

    public static String toTitleCase(String target, int collationId) {
        ULocale locale = CollationFactory.fetchCollation((int)collationId).collator.getLocale(ULocale.ACTUAL_LOCALE);
        return UCharacter.toTitleCase((ULocale)locale, (String)target, (BreakIterator)BreakIterator.getWordInstance((ULocale)locale));
    }

    public static int findInSet(UTF8String match, UTF8String set, int collationId) {
        if (match.contains(UTF8String.fromString(","))) {
            return 0;
        }
        String setString = set.toString();
        StringSearch stringSearch = CollationFactory.getStringSearch(setString, match.toString(), collationId);
        int wordStart = 0;
        while ((wordStart = stringSearch.next()) != -1) {
            boolean isValidEnd;
            boolean isValidStart = wordStart == 0 || setString.charAt(wordStart - 1) == ',';
            boolean bl = isValidEnd = wordStart + stringSearch.getMatchLength() == setString.length() || setString.charAt(wordStart + stringSearch.getMatchLength()) == ',';
            if (!isValidStart || !isValidEnd) continue;
            int pos = 0;
            for (int i = 0; i < setString.length() && i < wordStart; ++i) {
                if (setString.charAt(i) != ',') continue;
                ++pos;
            }
            return pos + 1;
        }
        return 0;
    }

    public static int indexOf(UTF8String target, UTF8String pattern, int start, int collationId) {
        if (pattern.numBytes() == 0) {
            return 0;
        }
        StringSearch stringSearch = CollationFactory.getStringSearch(target, pattern, collationId);
        stringSearch.setIndex(start);
        return stringSearch.next();
    }

    public static int find(UTF8String target, UTF8String pattern, int start, int collationId) {
        assert (pattern.numBytes() > 0);
        StringSearch stringSearch = CollationFactory.getStringSearch(target, pattern, collationId);
        stringSearch.setIndex(target.bytePosToChar(start));
        return target.charPosToByte(stringSearch.next());
    }

    public static UTF8String subStringIndex(UTF8String string, UTF8String delimiter, int count, int collationId) {
        if (delimiter.numBytes() == 0 || count == 0 || string.numBytes() == 0) {
            return UTF8String.EMPTY_UTF8;
        }
        if (count > 0) {
            int idx = -1;
            while (count > 0) {
                if ((idx = CollationAwareUTF8String.find(string, delimiter, idx + 1, collationId)) >= 0) {
                    --count;
                    continue;
                }
                return string;
            }
            if (idx == 0) {
                return UTF8String.EMPTY_UTF8;
            }
            byte[] bytes = new byte[idx];
            Platform.copyMemory(string.getBaseObject(), string.getBaseOffset(), bytes, Platform.BYTE_ARRAY_OFFSET, idx);
            return UTF8String.fromBytes(bytes);
        }
        StringSearch stringSearch = CollationFactory.getStringSearch(string, delimiter, collationId);
        int start = string.numChars() - 1;
        int lastMatchLength = 0;
        int prevStart = -1;
        for (count = -count; count > 0; --count) {
            stringSearch.reset();
            prevStart = -1;
            int matchStart = stringSearch.next();
            lastMatchLength = stringSearch.getMatchLength();
            while (matchStart <= start && matchStart != -1) {
                prevStart = matchStart;
                matchStart = stringSearch.next();
            }
            if (prevStart == -1) {
                return string;
            }
            start = prevStart - 1;
        }
        int resultStart = prevStart + lastMatchLength;
        if (resultStart == string.numChars()) {
            return UTF8String.EMPTY_UTF8;
        }
        return string.substring(resultStart, string.numChars());
    }

    public static UTF8String lowercaseSubStringIndex(UTF8String string, UTF8String delimiter, int count) {
        if (delimiter.numBytes() == 0 || count == 0) {
            return UTF8String.EMPTY_UTF8;
        }
        UTF8String lowercaseString = string.toLowerCase();
        UTF8String lowercaseDelimiter = delimiter.toLowerCase();
        if (count > 0) {
            int idx = -1;
            while (count > 0) {
                if ((idx = lowercaseString.find(lowercaseDelimiter, idx + 1)) >= 0) {
                    --count;
                    continue;
                }
                return string;
            }
            if (idx == 0) {
                return UTF8String.EMPTY_UTF8;
            }
            byte[] bytes = new byte[idx];
            Platform.copyMemory(string.getBaseObject(), string.getBaseOffset(), bytes, Platform.BYTE_ARRAY_OFFSET, idx);
            return UTF8String.fromBytes(bytes);
        }
        int idx = string.numBytes() - delimiter.numBytes() + 1;
        for (count = -count; count > 0; --count) {
            if ((idx = lowercaseString.rfind(lowercaseDelimiter, idx - 1)) >= 0) {
                continue;
            }
            return string;
        }
        if (idx + delimiter.numBytes() == string.numBytes()) {
            return UTF8String.EMPTY_UTF8;
        }
        int size = string.numBytes() - delimiter.numBytes() - idx;
        byte[] bytes = new byte[size];
        Platform.copyMemory(string.getBaseObject(), string.getBaseOffset() + (long)idx + (long)delimiter.numBytes(), bytes, Platform.BYTE_ARRAY_OFFSET, size);
        return UTF8String.fromBytes(bytes);
    }

    public static Map<String, String> getCollationAwareDict(UTF8String string, Map<String, String> dict, int collationId) {
        String srcStr = string.toString();
        HashMap<String, String> collationAwareDict = new HashMap<String, String>();
        for (String key : dict.keySet()) {
            StringSearch stringSearch = CollationFactory.getStringSearch(string, UTF8String.fromString(key), collationId);
            int pos = 0;
            while ((pos = stringSearch.next()) != -1) {
                int codePoint = srcStr.codePointAt(pos);
                int charCount = Character.charCount(codePoint);
                String newKey = srcStr.substring(pos, pos + charCount);
                boolean exists = false;
                for (String existingKey : collationAwareDict.keySet()) {
                    if (stringSearch.getCollator().compare(existingKey, newKey) != 0) continue;
                    collationAwareDict.put(newKey, (String)collationAwareDict.get(existingKey));
                    exists = true;
                    break;
                }
                if (exists) continue;
                collationAwareDict.put(newKey, dict.get(key));
            }
        }
        return collationAwareDict;
    }

    public static UTF8String lowercaseTrim(UTF8String srcString, UTF8String trimString) {
        if (trimString == null) {
            return null;
        }
        UTF8String leftTrimmed = CollationAwareUTF8String.lowercaseTrimLeft(srcString, trimString);
        return CollationAwareUTF8String.lowercaseTrimRight(leftTrimmed, trimString);
    }

    public static UTF8String lowercaseTrimLeft(UTF8String srcString, UTF8String trimString) {
        int searchIdx;
        int searchCharBytes;
        if (trimString == null) {
            return null;
        }
        int trimByteIdx = 0;
        int numBytes = srcString.numBytes();
        UTF8String lowercaseTrimString = trimString.toLowerCase();
        for (searchIdx = 0; searchIdx < numBytes; searchIdx += searchCharBytes) {
            UTF8String searchChar = srcString.copyUTF8String(searchIdx, searchIdx + UTF8String.numBytesForFirstByte(srcString.getByte(searchIdx)) - 1);
            searchCharBytes = searchChar.numBytes();
            if (lowercaseTrimString.find(searchChar.toLowerCase(), 0) < 0) break;
            trimByteIdx += searchCharBytes;
        }
        if (searchIdx == 0) {
            return srcString;
        }
        if (trimByteIdx >= numBytes) {
            return UTF8String.EMPTY_UTF8;
        }
        return srcString.copyUTF8String(trimByteIdx, numBytes - 1);
    }

    public static UTF8String lowercaseTrimRight(UTF8String srcString, UTF8String trimString) {
        UTF8String searchChar;
        if (trimString == null) {
            return null;
        }
        int byteIdx = 0;
        int numChars = 0;
        int numBytes = srcString.numBytes();
        int[] stringCharLen = new int[numBytes];
        int[] stringCharPos = new int[numBytes];
        UTF8String lowercaseTrimString = trimString.toLowerCase();
        while (byteIdx < numBytes) {
            stringCharPos[numChars] = byteIdx;
            stringCharLen[numChars] = UTF8String.numBytesForFirstByte(srcString.getByte(byteIdx));
            byteIdx += stringCharLen[numChars];
            ++numChars;
        }
        int trimByteIdx = numBytes - 1;
        while (numChars > 0 && lowercaseTrimString.find((searchChar = srcString.copyUTF8String(stringCharPos[numChars - 1], stringCharPos[numChars - 1] + stringCharLen[numChars - 1] - 1)).toLowerCase(), 0) >= 0) {
            trimByteIdx -= stringCharLen[numChars - 1];
            --numChars;
        }
        if (trimByteIdx == numBytes - 1) {
            return srcString;
        }
        if (trimByteIdx < 0) {
            return UTF8String.EMPTY_UTF8;
        }
        return srcString.copyUTF8String(0, trimByteIdx);
    }
}

