/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.ibm.icu.text.StringSearch;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.util.CollationAwareUTF8String;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.unsafe.types.UTF8String;

public final class CollationSupport {
    private static final int lowercaseRegexFlags = 66;
    private static final UTF8String lowercaseRegexPrefix = UTF8String.fromString("(?ui)");

    public static boolean supportsLowercaseRegex(int collationId) {
        return CollationFactory.fetchCollation((int)collationId).supportsLowercaseEquality;
    }

    public static int collationAwareRegexFlags(int collationId) {
        return CollationSupport.supportsLowercaseRegex(collationId) ? 66 : 0;
    }

    public static UTF8String lowercaseRegex(UTF8String regex) {
        return UTF8String.concat(lowercaseRegexPrefix, regex);
    }

    public static UTF8String collationAwareRegex(UTF8String regex, int collationId) {
        return CollationSupport.supportsLowercaseRegex(collationId) ? CollationSupport.lowercaseRegex(regex) : regex;
    }

    public static class StringTrimRight {
        public static UTF8String exec(UTF8String srcString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringTrimRight.execBinary(srcString);
            }
            return StringTrimRight.execLowercase(srcString);
        }

        public static UTF8String exec(UTF8String srcString, UTF8String trimString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringTrimRight.execBinary(srcString, trimString);
            }
            return StringTrimRight.execLowercase(srcString, trimString);
        }

        public static String genCode(String srcString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringTrimRight.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s)", srcString);
            }
            return String.format(expr + "Lowercase(%s)", srcString);
        }

        public static String genCode(String srcString, String trimString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringTrimRight.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", srcString, trimString);
            }
            return String.format(expr + "Lowercase(%s, %s)", srcString, trimString);
        }

        public static UTF8String execBinary(UTF8String srcString) {
            return srcString.trimRight();
        }

        public static UTF8String execBinary(UTF8String srcString, UTF8String trimString) {
            return srcString.trimRight(trimString);
        }

        public static UTF8String execLowercase(UTF8String srcString) {
            return srcString.trimRight();
        }

        public static UTF8String execLowercase(UTF8String srcString, UTF8String trimString) {
            return CollationAwareUTF8String.lowercaseTrimRight(srcString, trimString);
        }
    }

    public static class StringTrimLeft {
        public static UTF8String exec(UTF8String srcString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringTrimLeft.execBinary(srcString);
            }
            return StringTrimLeft.execLowercase(srcString);
        }

        public static UTF8String exec(UTF8String srcString, UTF8String trimString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringTrimLeft.execBinary(srcString, trimString);
            }
            return StringTrimLeft.execLowercase(srcString, trimString);
        }

        public static String genCode(String srcString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringTrimLeft.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s)", srcString);
            }
            return String.format(expr + "Lowercase(%s)", srcString);
        }

        public static String genCode(String srcString, String trimString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringTrimLeft.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", srcString, trimString);
            }
            return String.format(expr + "Lowercase(%s, %s)", srcString, trimString);
        }

        public static UTF8String execBinary(UTF8String srcString) {
            return srcString.trimLeft();
        }

        public static UTF8String execBinary(UTF8String srcString, UTF8String trimString) {
            return srcString.trimLeft(trimString);
        }

        public static UTF8String execLowercase(UTF8String srcString) {
            return srcString.trimLeft();
        }

        public static UTF8String execLowercase(UTF8String srcString, UTF8String trimString) {
            return CollationAwareUTF8String.lowercaseTrimLeft(srcString, trimString);
        }
    }

    public static class StringTrim {
        public static UTF8String exec(UTF8String srcString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringTrim.execBinary(srcString);
            }
            return StringTrim.execLowercase(srcString);
        }

        public static UTF8String exec(UTF8String srcString, UTF8String trimString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringTrim.execBinary(srcString, trimString);
            }
            return StringTrim.execLowercase(srcString, trimString);
        }

        public static String genCode(String srcString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringTrim.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s)", srcString);
            }
            return String.format(expr + "Lowercase(%s)", srcString);
        }

        public static String genCode(String srcString, String trimString, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringTrim.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", srcString, trimString);
            }
            return String.format(expr + "Lowercase(%s, %s)", srcString, trimString);
        }

        public static UTF8String execBinary(UTF8String srcString) {
            return srcString.trim();
        }

        public static UTF8String execBinary(UTF8String srcString, UTF8String trimString) {
            return srcString.trim(trimString);
        }

        public static UTF8String execLowercase(UTF8String srcString) {
            return srcString.trim();
        }

        public static UTF8String execLowercase(UTF8String srcString, UTF8String trimString) {
            return CollationAwareUTF8String.lowercaseTrim(srcString, trimString);
        }
    }

    public static class StringTranslate {
        public static UTF8String exec(UTF8String source, Map<String, String> dict, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringTranslate.execBinary(source, dict);
            }
            if (collation.supportsLowercaseEquality) {
                return StringTranslate.execLowercase(source, dict);
            }
            return StringTranslate.execICU(source, dict, collationId);
        }

        public static String genCode(String source, String dict, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.EndsWith.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", source, dict);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s)", source, dict);
            }
            return String.format(expr + "ICU(%s, %s, %d)", source, dict, collationId);
        }

        public static UTF8String execBinary(UTF8String source, Map<String, String> dict) {
            return source.translate(dict);
        }

        public static UTF8String execLowercase(UTF8String source, Map<String, String> dict) {
            String srcStr = source.toString();
            StringBuilder sb = new StringBuilder();
            int charCount = 0;
            for (int k = 0; k < srcStr.length(); k += charCount) {
                int codePoint = srcStr.codePointAt(k);
                charCount = Character.charCount(codePoint);
                String subStr = srcStr.substring(k, k + charCount);
                String translated = dict.get(subStr.toLowerCase());
                if (null == translated) {
                    sb.append(subStr);
                    continue;
                }
                if ("\u0000".equals(translated)) continue;
                sb.append(translated);
            }
            return UTF8String.fromString(sb.toString());
        }

        public static UTF8String execICU(UTF8String source, Map<String, String> dict, int collationId) {
            return source.translate(CollationAwareUTF8String.getCollationAwareDict(source, dict, collationId));
        }
    }

    public static class SubstringIndex {
        public static UTF8String exec(UTF8String string, UTF8String delimiter, int count, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return SubstringIndex.execBinary(string, delimiter, count);
            }
            if (collation.supportsLowercaseEquality) {
                return SubstringIndex.execLowercase(string, delimiter, count);
            }
            return SubstringIndex.execICU(string, delimiter, count, collationId);
        }

        public static String genCode(String string, String delimiter, int count, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.SubstringIndex.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s, %d)", string, delimiter, count);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s, %d)", string, delimiter, count);
            }
            return String.format(expr + "ICU(%s, %s, %d, %d)", string, delimiter, count, collationId);
        }

        public static UTF8String execBinary(UTF8String string, UTF8String delimiter, int count) {
            return string.subStringIndex(delimiter, count);
        }

        public static UTF8String execLowercase(UTF8String string, UTF8String delimiter, int count) {
            return CollationAwareUTF8String.lowercaseSubStringIndex(string, delimiter, count);
        }

        public static UTF8String execICU(UTF8String string, UTF8String delimiter, int count, int collationId) {
            return CollationAwareUTF8String.subStringIndex(string, delimiter, count, collationId);
        }
    }

    public static class StringLocate {
        public static int exec(UTF8String string, UTF8String substring, int start, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringLocate.execBinary(string, substring, start);
            }
            if (collation.supportsLowercaseEquality) {
                return StringLocate.execLowercase(string, substring, start);
            }
            return StringLocate.execICU(string, substring, start, collationId);
        }

        public static String genCode(String string, String substring, int start, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringLocate.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s, %d)", string, substring, start);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s, %d)", string, substring, start);
            }
            return String.format(expr + "ICU(%s, %s, %d, %d)", string, substring, start, collationId);
        }

        public static int execBinary(UTF8String string, UTF8String substring, int start) {
            return string.indexOf(substring, start);
        }

        public static int execLowercase(UTF8String string, UTF8String substring, int start) {
            return string.toLowerCase().indexOf(substring.toLowerCase(), start);
        }

        public static int execICU(UTF8String string, UTF8String substring, int start, int collationId) {
            return CollationAwareUTF8String.indexOf(string, substring, start, collationId);
        }
    }

    public static class StringReplace {
        public static UTF8String exec(UTF8String src, UTF8String search, UTF8String replace, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringReplace.execBinary(src, search, replace);
            }
            if (collation.supportsLowercaseEquality) {
                return StringReplace.execLowercase(src, search, replace);
            }
            return StringReplace.execICU(src, search, replace, collationId);
        }

        public static String genCode(String src, String search, String replace, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringReplace.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s, %s)", src, search, replace);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s, %s)", src, search, replace);
            }
            return String.format(expr + "ICU(%s, %s, %s, %d)", src, search, replace, collationId);
        }

        public static UTF8String execBinary(UTF8String src, UTF8String search, UTF8String replace) {
            return src.replace(search, replace);
        }

        public static UTF8String execLowercase(UTF8String src, UTF8String search, UTF8String replace) {
            return CollationAwareUTF8String.lowercaseReplace(src, search, replace);
        }

        public static UTF8String execICU(UTF8String src, UTF8String search, UTF8String replace, int collationId) {
            return CollationAwareUTF8String.replace(src, search, replace, collationId);
        }
    }

    public static class StringInstr {
        public static int exec(UTF8String string, UTF8String substring, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringInstr.execBinary(string, substring);
            }
            if (collation.supportsLowercaseEquality) {
                return StringInstr.execLowercase(string, substring);
            }
            return StringInstr.execICU(string, substring, collationId);
        }

        public static String genCode(String string, String substring, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringInstr.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", string, substring);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s)", string, substring);
            }
            return String.format(expr + "ICU(%s, %s, %d)", string, substring, collationId);
        }

        public static int execBinary(UTF8String string, UTF8String substring) {
            return string.indexOf(substring, 0);
        }

        public static int execLowercase(UTF8String string, UTF8String substring) {
            return string.toLowerCase().indexOf(substring.toLowerCase(), 0);
        }

        public static int execICU(UTF8String string, UTF8String substring, int collationId) {
            return CollationAwareUTF8String.indexOf(string, substring, 0, collationId);
        }
    }

    public static class FindInSet {
        public static int exec(UTF8String word, UTF8String set, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return FindInSet.execBinary(word, set);
            }
            if (collation.supportsLowercaseEquality) {
                return FindInSet.execLowercase(word, set);
            }
            return FindInSet.execICU(word, set, collationId);
        }

        public static String genCode(String word, String set, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.FindInSet.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", word, set);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s)", word, set);
            }
            return String.format(expr + "ICU(%s, %s, %d)", word, set, collationId);
        }

        public static int execBinary(UTF8String word, UTF8String set) {
            return set.findInSet(word);
        }

        public static int execLowercase(UTF8String word, UTF8String set) {
            return set.toLowerCase().findInSet(word.toLowerCase());
        }

        public static int execICU(UTF8String word, UTF8String set, int collationId) {
            return CollationAwareUTF8String.findInSet(word, set, collationId);
        }
    }

    public static class InitCap {
        public static UTF8String exec(UTF8String v, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality || collation.supportsLowercaseEquality) {
                return InitCap.execUTF8(v);
            }
            return InitCap.execICU(v, collationId);
        }

        public static String genCode(String v, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.InitCap.exec";
            if (collation.supportsBinaryEquality || collation.supportsLowercaseEquality) {
                return String.format(expr + "UTF8(%s)", v);
            }
            return String.format(expr + "ICU(%s, %d)", v, collationId);
        }

        public static UTF8String execUTF8(UTF8String v) {
            return v.toLowerCase().toTitleCase();
        }

        public static UTF8String execICU(UTF8String v, int collationId) {
            return UTF8String.fromString(CollationAwareUTF8String.toTitleCase(CollationAwareUTF8String.toLowerCase(v.toString(), collationId), collationId));
        }
    }

    public static class Lower {
        public static UTF8String exec(UTF8String v, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality || collation.supportsLowercaseEquality) {
                return Lower.execUTF8(v);
            }
            return Lower.execICU(v, collationId);
        }

        public static String genCode(String v, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.Lower.exec";
            if (collation.supportsBinaryEquality || collation.supportsLowercaseEquality) {
                return String.format(expr + "UTF8(%s)", v);
            }
            return String.format(expr + "ICU(%s, %d)", v, collationId);
        }

        public static UTF8String execUTF8(UTF8String v) {
            return v.toLowerCase();
        }

        public static UTF8String execICU(UTF8String v, int collationId) {
            return UTF8String.fromString(CollationAwareUTF8String.toLowerCase(v.toString(), collationId));
        }
    }

    public static class Upper {
        public static UTF8String exec(UTF8String v, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality || collation.supportsLowercaseEquality) {
                return Upper.execUTF8(v);
            }
            return Upper.execICU(v, collationId);
        }

        public static String genCode(String v, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.Upper.exec";
            if (collation.supportsBinaryEquality || collation.supportsLowercaseEquality) {
                return String.format(expr + "UTF8(%s)", v);
            }
            return String.format(expr + "ICU(%s, %d)", v, collationId);
        }

        public static UTF8String execUTF8(UTF8String v) {
            return v.toUpperCase();
        }

        public static UTF8String execICU(UTF8String v, int collationId) {
            return UTF8String.fromString(CollationAwareUTF8String.toUpperCase(v.toString(), collationId));
        }
    }

    public static class EndsWith {
        public static boolean exec(UTF8String l, UTF8String r, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return EndsWith.execBinary(l, r);
            }
            if (collation.supportsLowercaseEquality) {
                return EndsWith.execLowercase(l, r);
            }
            return EndsWith.execICU(l, r, collationId);
        }

        public static String genCode(String l, String r, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.EndsWith.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", l, r);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s)", l, r);
            }
            return String.format(expr + "ICU(%s, %s, %d)", l, r, collationId);
        }

        public static boolean execBinary(UTF8String l, UTF8String r) {
            return l.endsWith(r);
        }

        public static boolean execLowercase(UTF8String l, UTF8String r) {
            return l.endsWithInLowerCase(r);
        }

        public static boolean execICU(UTF8String l, UTF8String r, int collationId) {
            if (r.numBytes() == 0) {
                return true;
            }
            if (l.numBytes() == 0) {
                return false;
            }
            StringSearch stringSearch = CollationFactory.getStringSearch(l, r, collationId);
            int endIndex = stringSearch.getTarget().getEndIndex();
            return stringSearch.last() == endIndex - stringSearch.getMatchLength();
        }
    }

    public static class StartsWith {
        public static boolean exec(UTF8String l, UTF8String r, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StartsWith.execBinary(l, r);
            }
            if (collation.supportsLowercaseEquality) {
                return StartsWith.execLowercase(l, r);
            }
            return StartsWith.execICU(l, r, collationId);
        }

        public static String genCode(String l, String r, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StartsWith.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", l, r);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s)", l, r);
            }
            return String.format(expr + "ICU(%s, %s, %d)", l, r, collationId);
        }

        public static boolean execBinary(UTF8String l, UTF8String r) {
            return l.startsWith(r);
        }

        public static boolean execLowercase(UTF8String l, UTF8String r) {
            return l.startsWithInLowerCase(r);
        }

        public static boolean execICU(UTF8String l, UTF8String r, int collationId) {
            if (r.numBytes() == 0) {
                return true;
            }
            if (l.numBytes() == 0) {
                return false;
            }
            StringSearch stringSearch = CollationFactory.getStringSearch(l, r, collationId);
            return stringSearch.first() == 0;
        }
    }

    public static class Contains {
        public static boolean exec(UTF8String l, UTF8String r, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return Contains.execBinary(l, r);
            }
            if (collation.supportsLowercaseEquality) {
                return Contains.execLowercase(l, r);
            }
            return Contains.execICU(l, r, collationId);
        }

        public static String genCode(String l, String r, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.Contains.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", l, r);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s)", l, r);
            }
            return String.format(expr + "ICU(%s, %s, %d)", l, r, collationId);
        }

        public static boolean execBinary(UTF8String l, UTF8String r) {
            return l.contains(r);
        }

        public static boolean execLowercase(UTF8String l, UTF8String r) {
            return l.containsInLowerCase(r);
        }

        public static boolean execICU(UTF8String l, UTF8String r, int collationId) {
            if (r.numBytes() == 0) {
                return true;
            }
            if (l.numBytes() == 0) {
                return false;
            }
            StringSearch stringSearch = CollationFactory.getStringSearch(l, r, collationId);
            return stringSearch.first() != -1;
        }
    }

    public static class StringSplitSQL {
        public static UTF8String[] exec(UTF8String s, UTF8String d, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            if (collation.supportsBinaryEquality) {
                return StringSplitSQL.execBinary(s, d);
            }
            if (collation.supportsLowercaseEquality) {
                return StringSplitSQL.execLowercase(s, d);
            }
            return StringSplitSQL.execICU(s, d, collationId);
        }

        public static String genCode(String s, String d, int collationId) {
            CollationFactory.Collation collation = CollationFactory.fetchCollation(collationId);
            String expr = "CollationSupport.StringSplitSQL.exec";
            if (collation.supportsBinaryEquality) {
                return String.format(expr + "Binary(%s, %s)", s, d);
            }
            if (collation.supportsLowercaseEquality) {
                return String.format(expr + "Lowercase(%s, %s)", s, d);
            }
            return String.format(expr + "ICU(%s, %s, %d)", s, d, collationId);
        }

        public static UTF8String[] execBinary(UTF8String string, UTF8String delimiter) {
            return string.splitSQL(delimiter, -1);
        }

        public static UTF8String[] execLowercase(UTF8String string, UTF8String delimiter) {
            if (delimiter.numBytes() == 0) {
                return new UTF8String[]{string};
            }
            if (string.numBytes() == 0) {
                return new UTF8String[]{UTF8String.EMPTY_UTF8};
            }
            Pattern pattern = Pattern.compile(Pattern.quote(delimiter.toString()), 66);
            String[] splits = pattern.split(string.toString(), -1);
            UTF8String[] res = new UTF8String[splits.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = UTF8String.fromString(splits[i]);
            }
            return res;
        }

        public static UTF8String[] execICU(UTF8String string, UTF8String delimiter, int collationId) {
            int end;
            if (delimiter.numBytes() == 0) {
                return new UTF8String[]{string};
            }
            if (string.numBytes() == 0) {
                return new UTF8String[]{UTF8String.EMPTY_UTF8};
            }
            ArrayList<UTF8String> strings = new ArrayList<UTF8String>();
            String target = string.toString();
            String pattern = delimiter.toString();
            StringSearch stringSearch = CollationFactory.getStringSearch(target, pattern, collationId);
            int start = 0;
            while ((end = stringSearch.next()) != -1) {
                strings.add(UTF8String.fromString(target.substring(start, end)));
                start = end + stringSearch.getMatchLength();
            }
            if (start <= target.length()) {
                strings.add(UTF8String.fromString(target.substring(start)));
            }
            return strings.toArray(new UTF8String[0]);
        }
    }
}

