/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.lang.invoke.CallSite;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.util.CollationAwareUTF8String;
import org.apache.spark.unsafe.types.UTF8String;

public final class CollationFactory {
    public static final String CATALOG = "SYSTEM";
    public static final String SCHEMA = "BUILTIN";
    public static final String PROVIDER_SPARK = "spark";
    public static final String PROVIDER_ICU = "icu";
    public static final List<String> SUPPORTED_PROVIDERS = List.of("spark", "icu");
    public static final String COLLATION_PAD_ATTRIBUTE = "NO_PAD";
    public static final int UTF8_BINARY_COLLATION_ID = Collation.CollationSpecUTF8.UTF8_BINARY_COLLATION_ID;
    public static final int UTF8_LCASE_COLLATION_ID = Collation.CollationSpecUTF8.UTF8_LCASE_COLLATION_ID;
    public static final int UNICODE_COLLATION_ID = Collation.CollationSpecICU.UNICODE_COLLATION_ID;
    public static final int UNICODE_CI_COLLATION_ID = Collation.CollationSpecICU.UNICODE_CI_COLLATION_ID;
    public static final int INDETERMINATE_COLLATION_ID = -1;

    public static StringSearch getStringSearch(UTF8String targetUTF8String, UTF8String patternUTF8String, int collationId) {
        return CollationFactory.getStringSearch(targetUTF8String.toValidString(), patternUTF8String.toValidString(), collationId);
    }

    public static StringSearch getStringSearch(String targetString, String patternString, int collationId) {
        StringCharacterIterator target = new StringCharacterIterator(targetString);
        Collator collator = CollationFactory.fetchCollation((int)collationId).collator;
        return new StringSearch(patternString, (CharacterIterator)target, (RuleBasedCollator)collator);
    }

    public static StringSearch getStringSearch(UTF8String targetUTF8String, UTF8String patternUTF8String) {
        return new StringSearch(patternUTF8String.toValidString(), targetUTF8String.toValidString());
    }

    public static int collationNameToId(String collationName) throws SparkException {
        return Collation.CollationSpec.collationNameToId(collationName);
    }

    public static void assertValidProvider(String provider) throws SparkException {
        if (!SUPPORTED_PROVIDERS.contains(provider.toLowerCase())) {
            Map<String, String> params = Map.of("provider", provider, "supportedProviders", String.join((CharSequence)", ", SUPPORTED_PROVIDERS));
            throw new SparkException("COLLATION_INVALID_PROVIDER", SparkException.constructMessageParams(params), null);
        }
    }

    public static Collation fetchCollation(int collationId) {
        return Collation.CollationSpec.fetchCollation(collationId);
    }

    public static Collation fetchCollation(String collationName) throws SparkException {
        return CollationFactory.fetchCollation(CollationFactory.collationNameToId(collationName));
    }

    public static String[] getICULocaleNames() {
        return Collation.CollationSpecICU.ICULocaleNames;
    }

    public static UTF8String getCollationKey(UTF8String input, int collationId) {
        Collation collation = CollationFactory.fetchCollation(collationId);
        if (collation.supportsBinaryEquality) {
            return input;
        }
        if (collation.supportsLowercaseEquality) {
            return CollationAwareUTF8String.lowerCaseCodePoints(input);
        }
        CollationKey collationKey = collation.collator.getCollationKey(input.toValidString());
        return UTF8String.fromBytes(collationKey.toByteArray());
    }

    public static byte[] getCollationKeyBytes(UTF8String input, int collationId) {
        Collation collation = CollationFactory.fetchCollation(collationId);
        if (collation.supportsBinaryEquality) {
            return input.getBytes();
        }
        if (collation.supportsLowercaseEquality) {
            return CollationAwareUTF8String.lowerCaseCodePoints(input).getBytes();
        }
        return collation.collator.getCollationKey(input.toValidString()).toByteArray();
    }

    public static String getClosestSuggestionsOnInvalidName(String collationName, int maxSuggestions) {
        String[] validModifiers;
        String[] validRootNames;
        if (collationName.startsWith("UTF8_")) {
            validRootNames = new String[]{Collation.CollationSpecUTF8.UTF8_BINARY_COLLATION.collationName, Collation.CollationSpecUTF8.UTF8_LCASE_COLLATION.collationName};
            validModifiers = new String[]{};
        } else {
            validRootNames = CollationFactory.getICULocaleNames();
            validModifiers = new String[]{"_CI", "_AI", "_CS", "_AS"};
        }
        int MODIFIER_LENGTH = 3;
        String localeName = collationName.toUpperCase();
        List<String> modifiers = new ArrayList<String>();
        while (Arrays.stream(validModifiers).anyMatch(localeName::endsWith)) {
            modifiers.add(localeName.substring(localeName.length() - 3));
            localeName = localeName.substring(0, localeName.length() - 3);
        }
        Collections.reverse(modifiers);
        modifiers = modifiers.stream().distinct().toList();
        if (modifiers.contains("_CI") && modifiers.contains("_CS")) {
            modifiers = modifiers.stream().filter(m -> !m.equals("_CI")).toList();
        }
        if (modifiers.contains("_AI") && modifiers.contains("_AS")) {
            modifiers = modifiers.stream().filter(m -> !m.equals("_AI")).toList();
        }
        String finalLocaleName = localeName;
        Comparator distanceComparator = (c1, c2) -> {
            int distance1 = UTF8String.fromString(c1.toUpperCase()).levenshteinDistance(UTF8String.fromString(finalLocaleName));
            int distance2 = UTF8String.fromString(c2.toUpperCase()).levenshteinDistance(UTF8String.fromString(finalLocaleName));
            return Integer.compare(distance1, distance2);
        };
        String[] rootNamesByDistance = Arrays.copyOf(validRootNames, validRootNames.length);
        Arrays.sort(rootNamesByDistance, distanceComparator);
        Function<String, Boolean> isCollationNameValid = name -> {
            try {
                CollationFactory.collationNameToId(name);
                return true;
            }
            catch (SparkException e) {
                return false;
            }
        };
        int suggestionThreshold = 3;
        ArrayList<CallSite> suggestions = new ArrayList<CallSite>(maxSuggestions);
        for (int i = 0; i < maxSuggestions; ++i) {
            String suggestion = rootNamesByDistance[i] + String.join((CharSequence)"", modifiers);
            assert (isCollationNameValid.apply(suggestion).booleanValue());
            if (suggestions.isEmpty()) {
                suggestions.add((CallSite)((Object)suggestion));
                continue;
            }
            int distance = UTF8String.fromString(suggestion.toUpperCase()).levenshteinDistance(UTF8String.fromString(collationName.toUpperCase()));
            if (distance >= 3) break;
            suggestions.add((CallSite)((Object)suggestion));
        }
        return String.join((CharSequence)", ", suggestions);
    }

    public static List<CollationIdentifier> listCollations() {
        return Collation.CollationSpec.listCollations();
    }

    public static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
        return Collation.CollationSpec.loadCollationMeta(collationIdentifier);
    }

    public static class Collation {
        public final String collationName;
        public final String provider;
        public final Collator collator;
        public final Comparator<UTF8String> comparator;
        public final String version;
        public final ToLongFunction<UTF8String> hashFunction;
        public final BiFunction<UTF8String, UTF8String, Boolean> equalsFunction;
        public final boolean supportsBinaryEquality;
        public final boolean supportsBinaryOrdering;
        public final boolean supportsLowercaseEquality;

        public Collation(String collationName, String provider, Collator collator, Comparator<UTF8String> comparator, String version, ToLongFunction<UTF8String> hashFunction, boolean supportsBinaryEquality, boolean supportsBinaryOrdering, boolean supportsLowercaseEquality) {
            this.collationName = collationName;
            this.provider = provider;
            this.collator = collator;
            this.comparator = comparator;
            this.version = version;
            this.hashFunction = hashFunction;
            this.supportsBinaryEquality = supportsBinaryEquality;
            this.supportsBinaryOrdering = supportsBinaryOrdering;
            this.supportsLowercaseEquality = supportsLowercaseEquality;
            assert (!supportsBinaryOrdering || supportsBinaryEquality);
            assert (!supportsBinaryEquality || !supportsLowercaseEquality);
            assert (SUPPORTED_PROVIDERS.contains(provider));
            this.equalsFunction = supportsBinaryEquality ? UTF8String::equals : (s1, s2) -> this.comparator.compare((UTF8String)s1, (UTF8String)s2) == 0;
        }

        public CollationIdentifier identifier() {
            return new CollationIdentifier(this.provider, this.collationName, this.version);
        }

        private static class SpecifierUtils {
            private SpecifierUtils() {
            }

            private static int getSpecValue(int collationId, int offset, int mask) {
                return collationId >> offset & mask;
            }

            private static int removeSpec(int collationId, int offset, int mask) {
                return collationId & ~(mask << offset);
            }

            private static int setSpecValue(int collationId, int offset, Enum spec) {
                return collationId | spec.ordinal() << offset;
            }
        }

        private static class CollationSpecICU
        extends CollationSpec {
            private static final int CASE_SENSITIVITY_OFFSET = 17;
            private static final int CASE_SENSITIVITY_MASK = 1;
            private static final int ACCENT_SENSITIVITY_OFFSET = 16;
            private static final int ACCENT_SENSITIVITY_MASK = 1;
            private static final String[] ICULocaleNames;
            private static final Map<String, ULocale> ICULocaleMap;
            private static final Map<String, String> ICULocaleMapUppercase;
            private static final Map<String, Integer> ICULocaleToId;
            private static final String ICU_COLLATOR_VERSION = "153.120.0.0";
            private static final int UNICODE_COLLATION_ID;
            private static final int UNICODE_CI_COLLATION_ID;
            private final CaseSensitivity caseSensitivity;
            private final AccentSensitivity accentSensitivity;
            private final String locale;
            private final int collationId;

            private CollationSpecICU(String locale, CaseSensitivity caseSensitivity, AccentSensitivity accentSensitivity) {
                this.locale = locale;
                this.caseSensitivity = caseSensitivity;
                this.accentSensitivity = accentSensitivity;
                int collationId = ICULocaleToId.get(locale);
                collationId = SpecifierUtils.setSpecValue(collationId, 29, CollationSpec.ImplementationProvider.ICU);
                collationId = SpecifierUtils.setSpecValue(collationId, 17, caseSensitivity);
                this.collationId = collationId = SpecifierUtils.setSpecValue(collationId, 16, accentSensitivity);
            }

            private static int collationNameToId(String originalName, String collationName) throws SparkException {
                AccentSensitivity accentSensitivity;
                CaseSensitivity caseSensitivity;
                int lastPos = -1;
                for (int i = 1; i <= collationName.length(); ++i) {
                    String localeName = collationName.substring(0, i);
                    if (!ICULocaleMapUppercase.containsKey(localeName)) continue;
                    lastPos = i;
                }
                if (lastPos == -1) {
                    throw CollationSpecICU.collationInvalidNameException(originalName);
                }
                String locale = collationName.substring(0, lastPos);
                int collationId = ICULocaleToId.get(ICULocaleMapUppercase.get(locale));
                if (collationName.equals(locale) || collationName.equals(locale + "_AS") || collationName.equals(locale + "_CS") || collationName.equals(locale + "_AS_CS") || collationName.equals(locale + "_CS_AS")) {
                    caseSensitivity = CaseSensitivity.CS;
                    accentSensitivity = AccentSensitivity.AS;
                } else if (collationName.equals(locale + "_CI") || collationName.equals(locale + "_AS_CI") || collationName.equals(locale + "_CI_AS")) {
                    caseSensitivity = CaseSensitivity.CI;
                    accentSensitivity = AccentSensitivity.AS;
                } else if (collationName.equals(locale + "_AI") || collationName.equals(locale + "_CS_AI") || collationName.equals(locale + "_AI_CS")) {
                    caseSensitivity = CaseSensitivity.CS;
                    accentSensitivity = AccentSensitivity.AI;
                } else if (collationName.equals(locale + "_AI_CI") || collationName.equals(locale + "_CI_AI")) {
                    caseSensitivity = CaseSensitivity.CI;
                    accentSensitivity = AccentSensitivity.AI;
                } else {
                    throw CollationSpecICU.collationInvalidNameException(originalName);
                }
                collationId = SpecifierUtils.setSpecValue(collationId, 29, CollationSpec.ImplementationProvider.ICU);
                collationId = SpecifierUtils.setSpecValue(collationId, 17, caseSensitivity);
                collationId = SpecifierUtils.setSpecValue(collationId, 16, accentSensitivity);
                return collationId;
            }

            private static CollationSpecICU fromCollationId(int collationId) {
                int caseSensitivityOrdinal = SpecifierUtils.getSpecValue(collationId, 17, 1);
                int accentSensitivityOrdinal = SpecifierUtils.getSpecValue(collationId, 16, 1);
                collationId = SpecifierUtils.removeSpec(collationId, 29, 1);
                collationId = SpecifierUtils.removeSpec(collationId, 17, 1);
                int localeId = collationId = SpecifierUtils.removeSpec(collationId, 16, 1);
                assert (localeId >= 0 && localeId < ICULocaleNames.length);
                CaseSensitivity caseSensitivity = CaseSensitivity.values()[caseSensitivityOrdinal];
                AccentSensitivity accentSensitivity = AccentSensitivity.values()[accentSensitivityOrdinal];
                String locale = ICULocaleNames[localeId];
                return new CollationSpecICU(locale, caseSensitivity, accentSensitivity);
            }

            @Override
            protected Collation buildCollation() {
                ULocale.Builder builder = new ULocale.Builder();
                builder.setLocale(ICULocaleMap.get(this.locale));
                if (this.caseSensitivity == CaseSensitivity.CS && this.accentSensitivity == AccentSensitivity.AS) {
                    builder.setUnicodeLocaleKeyword("ks", "level3");
                } else if (this.caseSensitivity == CaseSensitivity.CS && this.accentSensitivity == AccentSensitivity.AI) {
                    builder.setUnicodeLocaleKeyword("ks", "level1").setUnicodeLocaleKeyword("kc", "true");
                } else if (this.caseSensitivity == CaseSensitivity.CI && this.accentSensitivity == AccentSensitivity.AS) {
                    builder.setUnicodeLocaleKeyword("ks", "level2");
                } else if (this.caseSensitivity == CaseSensitivity.CI && this.accentSensitivity == AccentSensitivity.AI) {
                    builder.setUnicodeLocaleKeyword("ks", "level1");
                }
                ULocale resultLocale = builder.build();
                Collator collator = Collator.getInstance((ULocale)resultLocale);
                collator.freeze();
                return new Collation(this.collationName(), CollationFactory.PROVIDER_ICU, collator, (s1, s2) -> collator.compare(s1.toValidString(), s2.toValidString()), ICU_COLLATOR_VERSION, s -> collator.getCollationKey(s.toValidString()).hashCode(), false, false, false);
            }

            @Override
            protected CollationMeta buildCollationMeta() {
                return new CollationMeta(CollationFactory.CATALOG, CollationFactory.SCHEMA, this.collationName(), ICULocaleMap.get(this.locale).getDisplayLanguage(), ICULocaleMap.get(this.locale).getDisplayCountry(), VersionInfo.ICU_VERSION.toString(), CollationFactory.COLLATION_PAD_ATTRIBUTE, this.caseSensitivity == CaseSensitivity.CS, this.accentSensitivity == AccentSensitivity.AS);
            }

            private String collationName() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.locale);
                if (this.caseSensitivity != CaseSensitivity.CS) {
                    builder.append('_');
                    builder.append(this.caseSensitivity.toString());
                }
                if (this.accentSensitivity != AccentSensitivity.AS) {
                    builder.append('_');
                    builder.append(this.accentSensitivity.toString());
                }
                return builder.toString();
            }

            private static List<String> allCollationNames() {
                ArrayList<Object> collationNames = new ArrayList<Object>();
                for (String locale : ICULocaleToId.keySet()) {
                    collationNames.add(locale);
                    collationNames.add(locale + "_AI");
                    collationNames.add(locale + "_CI");
                    collationNames.add(locale + "_CI_AI");
                }
                return collationNames.stream().sorted().toList();
            }

            static List<CollationIdentifier> listCollations() {
                return CollationSpecICU.allCollationNames().stream().map(name -> new CollationIdentifier(CollationFactory.PROVIDER_ICU, (String)name, VersionInfo.ICU_VERSION.toString())).toList();
            }

            static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
                try {
                    int collationId = CollationSpecICU.collationNameToId(collationIdentifier.name, collationIdentifier.name.toUpperCase());
                    return CollationSpecICU.fromCollationId(collationId).buildCollationMeta();
                }
                catch (SparkException ignored) {
                    return null;
                }
            }

            static {
                ICULocaleMap = new HashMap<String, ULocale>();
                ICULocaleMapUppercase = new HashMap<String, String>();
                ICULocaleToId = new HashMap<String, Integer>();
                ICULocaleMap.put("UNICODE", ULocale.ROOT);
                ULocale[] locales = Collator.getAvailableULocales();
                for (ULocale locale : locales) {
                    String country;
                    if (!locale.getVariant().isEmpty()) continue;
                    String language = locale.getLanguage();
                    assert (!language.isEmpty());
                    StringBuilder builder = new StringBuilder(language);
                    String script = locale.getScript();
                    if (!script.isEmpty()) {
                        builder.append('_');
                        builder.append(script);
                    }
                    if (!(country = locale.getISO3Country()).isEmpty()) {
                        builder.append('_');
                        builder.append(country);
                    }
                    String localeName = builder.toString();
                    assert (!ICULocaleMap.containsKey(localeName));
                    ICULocaleMap.put(localeName, locale);
                }
                for (String localeName : ICULocaleMap.keySet()) {
                    String localeUppercase = localeName.toUpperCase();
                    assert (!ICULocaleMapUppercase.containsKey(localeUppercase));
                    ICULocaleMapUppercase.put(localeUppercase, localeName);
                }
                ICULocaleNames = ICULocaleMap.keySet().toArray(new String[0]);
                Arrays.sort(ICULocaleNames);
                assert (ICULocaleNames.length <= 4096);
                for (int i = 0; i < ICULocaleNames.length; ++i) {
                    ICULocaleToId.put(ICULocaleNames[i], i);
                }
                UNICODE_COLLATION_ID = new CollationSpecICU((String)"UNICODE", (CaseSensitivity)CaseSensitivity.CS, (AccentSensitivity)AccentSensitivity.AS).collationId;
                UNICODE_CI_COLLATION_ID = new CollationSpecICU((String)"UNICODE", (CaseSensitivity)CaseSensitivity.CI, (AccentSensitivity)AccentSensitivity.AS).collationId;
            }

            private static enum CaseSensitivity {
                CS,
                CI;

            }

            private static enum AccentSensitivity {
                AS,
                AI;

            }
        }

        private static class CollationSpecUTF8
        extends CollationSpec {
            private static final int CASE_SENSITIVITY_OFFSET = 0;
            private static final int CASE_SENSITIVITY_MASK = 1;
            private static final String UTF8_BINARY_COLLATION_NAME = "UTF8_BINARY";
            private static final String UTF8_LCASE_COLLATION_NAME = "UTF8_LCASE";
            private static final int UTF8_BINARY_COLLATION_ID = new CollationSpecUTF8((CaseSensitivity)CaseSensitivity.UNSPECIFIED).collationId;
            private static final int UTF8_LCASE_COLLATION_ID = new CollationSpecUTF8((CaseSensitivity)CaseSensitivity.LCASE).collationId;
            protected static Collation UTF8_BINARY_COLLATION = new CollationSpecUTF8(CaseSensitivity.UNSPECIFIED).buildCollation();
            protected static Collation UTF8_LCASE_COLLATION = new CollationSpecUTF8(CaseSensitivity.LCASE).buildCollation();
            private final int collationId;

            private CollationSpecUTF8(CaseSensitivity caseSensitivity) {
                this.collationId = SpecifierUtils.setSpecValue(0, 0, caseSensitivity);
            }

            private static int collationNameToId(String originalName, String collationName) throws SparkException {
                if (CollationSpecUTF8.UTF8_BINARY_COLLATION.collationName.equals(collationName)) {
                    return UTF8_BINARY_COLLATION_ID;
                }
                if (CollationSpecUTF8.UTF8_LCASE_COLLATION.collationName.equals(collationName)) {
                    return UTF8_LCASE_COLLATION_ID;
                }
                throw CollationSpecUTF8.collationInvalidNameException(originalName);
            }

            private static CollationSpecUTF8 fromCollationId(int collationId) {
                int caseConversionOrdinal = SpecifierUtils.getSpecValue(collationId, 0, 1);
                assert (SpecifierUtils.removeSpec(collationId, 0, 1) == 0);
                return new CollationSpecUTF8(CaseSensitivity.values()[caseConversionOrdinal]);
            }

            @Override
            protected Collation buildCollation() {
                if (this.collationId == UTF8_BINARY_COLLATION_ID) {
                    return new Collation(UTF8_BINARY_COLLATION_NAME, CollationFactory.PROVIDER_SPARK, null, UTF8String::binaryCompare, "1.0", s -> s.hashCode(), true, true, false);
                }
                return new Collation(UTF8_LCASE_COLLATION_NAME, CollationFactory.PROVIDER_SPARK, null, CollationAwareUTF8String::compareLowerCase, "1.0", s -> CollationAwareUTF8String.lowerCaseCodePoints(s).hashCode(), false, false, true);
            }

            @Override
            protected CollationMeta buildCollationMeta() {
                if (this.collationId == UTF8_BINARY_COLLATION_ID) {
                    return new CollationMeta(CollationFactory.CATALOG, CollationFactory.SCHEMA, UTF8_BINARY_COLLATION_NAME, null, null, null, CollationFactory.COLLATION_PAD_ATTRIBUTE, true, true);
                }
                return new CollationMeta(CollationFactory.CATALOG, CollationFactory.SCHEMA, UTF8_LCASE_COLLATION_NAME, null, null, null, CollationFactory.COLLATION_PAD_ATTRIBUTE, true, false);
            }

            static List<CollationIdentifier> listCollations() {
                CollationIdentifier UTF8_BINARY_COLLATION_IDENT = new CollationIdentifier(CollationFactory.PROVIDER_SPARK, UTF8_BINARY_COLLATION_NAME, "1.0");
                CollationIdentifier UTF8_LCASE_COLLATION_IDENT = new CollationIdentifier(CollationFactory.PROVIDER_SPARK, UTF8_LCASE_COLLATION_NAME, "1.0");
                return Arrays.asList(UTF8_BINARY_COLLATION_IDENT, UTF8_LCASE_COLLATION_IDENT);
            }

            static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
                try {
                    int collationId = CollationSpecUTF8.collationNameToId(collationIdentifier.name, collationIdentifier.name.toUpperCase());
                    return CollationSpecUTF8.fromCollationId(collationId).buildCollationMeta();
                }
                catch (SparkException ignored) {
                    return null;
                }
            }

            private static enum CaseSensitivity {
                UNSPECIFIED,
                LCASE;

            }
        }

        private static abstract class CollationSpec {
            private static final int DEFINITION_ORIGIN_OFFSET = 30;
            private static final int DEFINITION_ORIGIN_MASK = 1;
            protected static final int IMPLEMENTATION_PROVIDER_OFFSET = 29;
            protected static final int IMPLEMENTATION_PROVIDER_MASK = 1;
            private static final int INDETERMINATE_COLLATION_ID = -1;
            private static final Map<Integer, Collation> collationMap = new ConcurrentHashMap<Integer, Collation>();

            private CollationSpec() {
            }

            private static ImplementationProvider getImplementationProvider(int collationId) {
                return ImplementationProvider.values()[SpecifierUtils.getSpecValue(collationId, 29, 1)];
            }

            private static DefinitionOrigin getDefinitionOrigin(int collationId) {
                return DefinitionOrigin.values()[SpecifierUtils.getSpecValue(collationId, 30, 1)];
            }

            private static Collation fetchCollation(int collationId) {
                assert (collationId >= 0 && CollationSpec.getDefinitionOrigin(collationId) == DefinitionOrigin.PREDEFINED);
                if (collationId == UTF8_BINARY_COLLATION_ID) {
                    return CollationSpecUTF8.UTF8_BINARY_COLLATION;
                }
                if (collationMap.containsKey(collationId)) {
                    return collationMap.get(collationId);
                }
                ImplementationProvider implementationProvider = CollationSpec.getImplementationProvider(collationId);
                CollationSpec spec = implementationProvider == ImplementationProvider.UTF8_BINARY ? CollationSpecUTF8.fromCollationId(collationId) : CollationSpecICU.fromCollationId(collationId);
                Collation collation = spec.buildCollation();
                collationMap.put(collationId, collation);
                return collation;
            }

            protected static SparkException collationInvalidNameException(String collationName) {
                HashMap<String, String> params = new HashMap<String, String>();
                int maxSuggestions = 3;
                params.put("collationName", collationName);
                params.put("proposals", CollationFactory.getClosestSuggestionsOnInvalidName(collationName, 3));
                return new SparkException("COLLATION_INVALID_NAME", SparkException.constructMessageParams(params), null);
            }

            private static int collationNameToId(String collationName) throws SparkException {
                String collationNameUpper = collationName.toUpperCase();
                if (collationNameUpper.startsWith("UTF8_")) {
                    return CollationSpecUTF8.collationNameToId(collationName, collationNameUpper);
                }
                return CollationSpecICU.collationNameToId(collationName, collationNameUpper);
            }

            protected abstract Collation buildCollation();

            protected abstract CollationMeta buildCollationMeta();

            static List<CollationIdentifier> listCollations() {
                return Stream.concat(CollationSpecUTF8.listCollations().stream(), CollationSpecICU.listCollations().stream()).toList();
            }

            static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
                CollationMeta collationSpecUTF8 = CollationSpecUTF8.loadCollationMeta(collationIdentifier);
                if (collationSpecUTF8 == null) {
                    return CollationSpecICU.loadCollationMeta(collationIdentifier);
                }
                return collationSpecUTF8;
            }

            protected static enum ImplementationProvider {
                UTF8_BINARY,
                ICU;

            }

            private static enum DefinitionOrigin {
                PREDEFINED,
                USER_DEFINED;

            }
        }
    }

    public static class CollationIdentifier {
        private final String provider;
        private final String name;
        private final String version;

        public CollationIdentifier(String provider, String collationName, String version) {
            this.provider = provider;
            this.name = collationName;
            this.version = version;
        }

        public static CollationIdentifier fromString(String identifier) {
            long numDots = identifier.chars().filter(ch -> ch == 46).count();
            assert (numDots > 0L);
            if (numDots == 1L) {
                String[] parts = identifier.split("\\.", 2);
                return new CollationIdentifier(parts[0], parts[1], null);
            }
            String[] parts = identifier.split("\\.", 3);
            return new CollationIdentifier(parts[0], parts[1], parts[2]);
        }

        public String toStringWithoutVersion() {
            return String.format("%s.%s", this.provider, this.name);
        }

        public String getProvider() {
            return this.provider;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getVersion() {
            return Optional.ofNullable(this.version);
        }
    }

    public record CollationMeta(String catalog, String schema, String collationName, String language, String country, String icuVersion, String padAttribute, boolean accentSensitivity, boolean caseSensitivity) {
    }
}

