/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.types.variant;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.UUID;
import org.apache.spark.types.variant.VariantUtil;

public final class Variant {
    final byte[] value;
    final byte[] metadata;
    final int pos;
    private static final DateTimeFormatter TIMESTAMP_NTZ_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter(Locale.US);
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().append(TIMESTAMP_NTZ_FORMATTER).appendOffset("+HH:MM", "+00:00").toFormatter(Locale.US);

    public Variant(byte[] value, byte[] metadata) {
        this(value, metadata, 0);
    }

    Variant(byte[] value, byte[] metadata, int pos) {
        this.value = value;
        this.metadata = metadata;
        this.pos = pos;
        if (metadata.length < 1 || (metadata[0] & 0xF) != 1) {
            throw VariantUtil.malformedVariant();
        }
        if (metadata.length > 0x8000000 || value.length > 0x8000000) {
            throw VariantUtil.variantConstructorSizeLimit();
        }
    }

    public byte[] getValue() {
        if (this.pos == 0) {
            return this.value;
        }
        int size = VariantUtil.valueSize(this.value, this.pos);
        VariantUtil.checkIndex(this.pos + size - 1, this.value.length);
        return Arrays.copyOfRange(this.value, this.pos, this.pos + size);
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public boolean getBoolean() {
        return VariantUtil.getBoolean(this.value, this.pos);
    }

    public long getLong() {
        return VariantUtil.getLong(this.value, this.pos);
    }

    public double getDouble() {
        return VariantUtil.getDouble(this.value, this.pos);
    }

    public BigDecimal getDecimal() {
        return VariantUtil.getDecimal(this.value, this.pos);
    }

    public float getFloat() {
        return VariantUtil.getFloat(this.value, this.pos);
    }

    public byte[] getBinary() {
        return VariantUtil.getBinary(this.value, this.pos);
    }

    public String getString() {
        return VariantUtil.getString(this.value, this.pos);
    }

    public int getTypeInfo() {
        return VariantUtil.getTypeInfo(this.value, this.pos);
    }

    public VariantUtil.Type getType() {
        return VariantUtil.getType(this.value, this.pos);
    }

    public UUID getUuid() {
        return VariantUtil.getUuid(this.value, this.pos);
    }

    public int objectSize() {
        return VariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> size);
    }

    public Variant getFieldByKey(String key) {
        return VariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
            int BINARY_SEARCH_THRESHOLD = 32;
            if (size < 32) {
                for (int i = 0; i < size; ++i) {
                    int id = VariantUtil.readUnsigned(this.value, idStart + idSize * i, idSize);
                    if (!key.equals(VariantUtil.getMetadataKey(this.metadata, id))) continue;
                    int offset = VariantUtil.readUnsigned(this.value, offsetStart + offsetSize * i, offsetSize);
                    return new Variant(this.value, this.metadata, dataStart + offset);
                }
            } else {
                int low = 0;
                int high = size - 1;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int id = VariantUtil.readUnsigned(this.value, idStart + idSize * mid, idSize);
                    int cmp = VariantUtil.getMetadataKey(this.metadata, id).compareTo(key);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    int offset = VariantUtil.readUnsigned(this.value, offsetStart + offsetSize * mid, offsetSize);
                    return new Variant(this.value, this.metadata, dataStart + offset);
                }
            }
            return null;
        });
    }

    public ObjectField getFieldAtIndex(int index) {
        return VariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
            if (index < 0 || index >= size) {
                return null;
            }
            int id = VariantUtil.readUnsigned(this.value, idStart + idSize * index, idSize);
            int offset = VariantUtil.readUnsigned(this.value, offsetStart + offsetSize * index, offsetSize);
            String key = VariantUtil.getMetadataKey(this.metadata, id);
            Variant v = new Variant(this.value, this.metadata, dataStart + offset);
            return new ObjectField(key, v);
        });
    }

    public int getDictionaryIdAtIndex(int index) {
        return VariantUtil.handleObject(this.value, this.pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
            if (index < 0 || index >= size) {
                throw VariantUtil.malformedVariant();
            }
            return VariantUtil.readUnsigned(this.value, idStart + idSize * index, idSize);
        });
    }

    public int arraySize() {
        return VariantUtil.handleArray(this.value, this.pos, (size, offsetSize, offsetStart, dataStart) -> size);
    }

    public Variant getElementAtIndex(int index) {
        return VariantUtil.handleArray(this.value, this.pos, (size, offsetSize, offsetStart, dataStart) -> {
            if (index < 0 || index >= size) {
                return null;
            }
            int offset = VariantUtil.readUnsigned(this.value, offsetStart + offsetSize * index, offsetSize);
            return new Variant(this.value, this.metadata, dataStart + offset);
        });
    }

    public String toJson(ZoneId zoneId) {
        StringBuilder sb = new StringBuilder();
        Variant.toJsonImpl(this.value, this.metadata, this.pos, sb, zoneId);
        return sb.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static String escapeJson(String str) {
        try (CharArrayWriter writer = new CharArrayWriter();){
            String string;
            block13: {
                JsonGenerator gen = new JsonFactory().createGenerator((Writer)writer);
                try {
                    gen.writeString(str);
                    gen.flush();
                    string = writer.toString();
                    if (gen == null) break block13;
                }
                catch (Throwable throwable) {
                    if (gen != null) {
                        try {
                            gen.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                gen.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void appendQuoted(StringBuilder sb, String str) {
        sb.append('\"');
        sb.append(str);
        sb.append('\"');
    }

    private static Instant microsToInstant(long timestamp) {
        return Instant.EPOCH.plus(timestamp, ChronoUnit.MICROS);
    }

    static void toJsonImpl(byte[] value, byte[] metadata, int pos, StringBuilder sb, ZoneId zoneId) {
        switch (VariantUtil.getType(value, pos)) {
            case OBJECT: {
                VariantUtil.handleObject(value, pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> {
                    sb.append('{');
                    for (int i = 0; i < size; ++i) {
                        int id = VariantUtil.readUnsigned(value, idStart + idSize * i, idSize);
                        int offset = VariantUtil.readUnsigned(value, offsetStart + offsetSize * i, offsetSize);
                        int elementPos = dataStart + offset;
                        if (i != 0) {
                            sb.append(',');
                        }
                        sb.append(Variant.escapeJson(VariantUtil.getMetadataKey(metadata, id)));
                        sb.append(':');
                        Variant.toJsonImpl(value, metadata, elementPos, sb, zoneId);
                    }
                    sb.append('}');
                    return null;
                });
                break;
            }
            case ARRAY: {
                VariantUtil.handleArray(value, pos, (size, offsetSize, offsetStart, dataStart) -> {
                    sb.append('[');
                    for (int i = 0; i < size; ++i) {
                        int offset = VariantUtil.readUnsigned(value, offsetStart + offsetSize * i, offsetSize);
                        int elementPos = dataStart + offset;
                        if (i != 0) {
                            sb.append(',');
                        }
                        Variant.toJsonImpl(value, metadata, elementPos, sb, zoneId);
                    }
                    sb.append(']');
                    return null;
                });
                break;
            }
            case NULL: {
                sb.append("null");
                break;
            }
            case BOOLEAN: {
                sb.append(VariantUtil.getBoolean(value, pos));
                break;
            }
            case LONG: {
                sb.append(VariantUtil.getLong(value, pos));
                break;
            }
            case STRING: {
                sb.append(Variant.escapeJson(VariantUtil.getString(value, pos)));
                break;
            }
            case DOUBLE: {
                sb.append(VariantUtil.getDouble(value, pos));
                break;
            }
            case DECIMAL: {
                sb.append(VariantUtil.getDecimal(value, pos).toPlainString());
                break;
            }
            case DATE: {
                Variant.appendQuoted(sb, LocalDate.ofEpochDay((int)VariantUtil.getLong(value, pos)).toString());
                break;
            }
            case TIMESTAMP: {
                Variant.appendQuoted(sb, TIMESTAMP_FORMATTER.format(Variant.microsToInstant(VariantUtil.getLong(value, pos)).atZone(zoneId)));
                break;
            }
            case TIMESTAMP_NTZ: {
                Variant.appendQuoted(sb, TIMESTAMP_NTZ_FORMATTER.format(Variant.microsToInstant(VariantUtil.getLong(value, pos)).atZone(ZoneOffset.UTC)));
                break;
            }
            case FLOAT: {
                sb.append(VariantUtil.getFloat(value, pos));
                break;
            }
            case BINARY: {
                Variant.appendQuoted(sb, Base64.getEncoder().encodeToString(VariantUtil.getBinary(value, pos)));
                break;
            }
            case UUID: {
                Variant.appendQuoted(sb, VariantUtil.getUuid(value, pos).toString());
            }
        }
    }

    public static final class ObjectField {
        public final String key;
        public final Variant value;

        public ObjectField(String key, Variant value) {
            this.key = key;
            this.value = value;
        }
    }
}

