/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0001\u0002\u0001\u00051\u0011\u0001$Q'EK2,w-\u0019;j_:$vn[3o%\u0016tWm^3s\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\ngB\f'o[\"p]\u001a\u001c\u0001\u0001\u0005\u0002\u00157%\u0011AD\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0011B\u0011A\u00025bI>|\u0007/\u0003\u0002'C\ti1i\u001c8gS\u001e,(/\u0019;j_:DQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtDc\u0001\u0016-[A\u00111\u0006A\u0007\u0002\u0005!)\u0001d\na\u00015!)ad\na\u0001?!9q\u0006\u0001a\u0001\n\u0013\u0001\u0014!\u00077bgR\u001c%/\u001a3f]RL\u0017\r\\:GS2,7+\u001e4gSb,\u0012!\r\t\u0003\u001dIJ!aM\b\u0003\u0007%sG\u000fC\u00046\u0001\u0001\u0007I\u0011\u0002\u001c\u0002;1\f7\u000f^\"sK\u0012,g\u000e^5bYN4\u0015\u000e\\3Tk\u001a4\u0017\u000e_0%KF$\"a\u000e\u001e\u0011\u00059A\u0014BA\u001d\u0010\u0005\u0011)f.\u001b;\t\u000fm\"\u0014\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\ru\u0002\u0001\u0015)\u00032\u0003ia\u0017m\u001d;De\u0016$WM\u001c;jC2\u001ch)\u001b7f'V4g-\u001b=!\u0011\u001dy\u0004A1A\u0005\n\u0001\u000ba\u0003Z3mK\u001e\fG/[8o)>\\WM\u001c*f]\u0016<XM]\u000b\u0002\u0003B\u0011!)S\u0007\u0002\u0007*\u0011A)R\u0001\u000bG>t7-\u001e:sK:$(B\u0001$H\u0003\u0011)H/\u001b7\u000b\u0003!\u000bAA[1wC&\u0011!j\u0011\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007B\u0002'\u0001A\u0003%\u0011)A\feK2,w-\u0019;j_:$vn[3o%\u0016tWm^3sA!9a\n\u0001b\u0001\n\u0013y\u0015A\u00035bI>|\u0007/\u0016;jYV\t\u0001\u000b\u0005\u0002,#&\u0011!K\u0001\u0002\u00143\u0006\u0014hn\u00159be.D\u0015\rZ8paV#\u0018\u000e\u001c\u0005\u0007)\u0002\u0001\u000b\u0011\u0002)\u0002\u0017!\fGm\\8q+RLG\u000e\t\u0005\b-\u0002\u0011\r\u0011\"\u00031\u0003=!\u0017-_:U_.+W\r\u001d$jY\u0016\u001c\bB\u0002-\u0001A\u0003%\u0011'\u0001\teCf\u001cHk\\&fKB4\u0015\u000e\\3tA!9!\f\u0001b\u0001\n\u0013\u0001\u0014A\u00048v[\u001aKG.Z:U_.+W\r\u001d\u0005\u00079\u0002\u0001\u000b\u0011B\u0019\u0002\u001f9,XNR5mKN$vnS3fa\u0002BaA\u0018\u0001\u0005\u0002\u0019y\u0016aF:dQ\u0016$W\u000f\\3M_\u001eLgN\u0012:p[.+\u0017\u0010^1c)\u00059\u0004\"B1\u0001\t\u0013y\u0016aD2mK\u0006tW\u000f](mI\u001aKG.Z:\t\u000b\r\u0004A\u0011\u00023\u0002)]\u0014\u0018\u000e^3OK^$vn[3ogR{\u0007\n\u0012$T)\r9TM\u001c\u0005\u0006M\n\u0004\raZ\u0001\naJLgnY5qC2\u0004\"\u0001[6\u000f\u00059I\u0017B\u00016\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)|\u0001\"B8c\u0001\u00049\u0017AB6fsR\f'\rC\u0003r\u0001\u0011\u0005q,\u0001\u0003ti>\u0004\b")
public class AMDelegationTokenRenewer
implements Logging {
    public final SparkConf org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf;
    public final Configuration org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopConf;
    private int org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix;
    private final ScheduledExecutorService org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer;
    private final YarnSparkHadoopUtil org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil;
    private final int daysToKeepFiles;
    private final int numFilesToKeep;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private int org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix() {
        return this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix;
    }

    public void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix = x$1;
    }

    public ScheduledExecutorService org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer() {
        return this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer;
    }

    public YarnSparkHadoopUtil org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil() {
        return this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil;
    }

    private int daysToKeepFiles() {
        return this.daysToKeepFiles;
    }

    private int numFilesToKeep() {
        return this.numFilesToKeep;
    }

    public void scheduleLoginFromKeytab() {
        String principal = this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf.get("spark.yarn.principal");
        String keytab = this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf.get("spark.yarn.keytab");
        Runnable driverTokenRenewerRunnable = new Runnable(this, principal, keytab){
            private final /* synthetic */ AMDelegationTokenRenewer $outer;
            private final String principal$1;
            private final String keytab$1;

            public void run() {
                try {
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$writeNewTokensToHDFS(this.principal$1, this.keytab$1);
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$cleanupOldFiles();
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$scheduleRenewal$1(this);
                    return;
                }
                catch (Exception exception) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Failed to write out new credentials to HDFS, will try again in an hour! If this happens too often tasks will fail.";
                        }
                    }, exception);
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer().schedule(this, 1L, TimeUnit.HOURS);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.keytab$1 = keytab$1;
            }
        };
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$scheduleRenewal$1(driverTokenRenewerRunnable);
    }

    public void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$cleanupOldFiles() {
        try {
            FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopConf);
            Path credentialsPath = new Path(this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf.get("spark.yarn.credentials.file"));
            long thresholdTime = System.currentTimeMillis() - new package.DurationInt(package$.MODULE$.DurationInt(this.daysToKeepFiles())).days().toMillis();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).dropRight(this.numFilesToKeep())).takeWhile((Function1)new Serializable(this, thresholdTime){
                public static final long serialVersionUID = 0L;
                private final long thresholdTime$1;

                public final boolean apply(FileStatus x$1) {
                    return x$1.getModificationTime() < this.thresholdTime$1;
                }
                {
                    this.thresholdTime$1 = thresholdTime$1;
                }
            })).foreach((Function1)new Serializable(this, remoteFs){
                public static final long serialVersionUID = 0L;
                private final FileSystem remoteFs$1;

                public final boolean apply(FileStatus x) {
                    return this.remoteFs$1.delete(x.getPath(), true);
                }
                {
                    this.remoteFs$1 = remoteFs$1;
                }
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while attempting to cleanup old tokens. If you are seeing many such warnings there may be an issue with your HDFS cluster.";
                }
            }, exception);
        }
    }

    public void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$writeNewTokensToHDFS(String principal, String keytab) {
        this.logInfo((Function0<String>)new Serializable(this, principal){
            public static final long serialVersionUID = 0L;
            private final String principal$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to login to KDC using principal: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principal$2}));
            }
            {
                this.principal$2 = principal$2;
            }
        });
        UserGroupInformation keytabLoggedInUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Successfully logged into KDC.";
            }
        });
        Credentials tempCreds = keytabLoggedInUGI.getCredentials();
        Path credentialsPath = new Path(this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf.get("spark.yarn.credentials.file"));
        Path dst = credentialsPath.getParent();
        keytabLoggedInUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(this, tempCreds, dst){
            private final /* synthetic */ AMDelegationTokenRenewer $outer;
            private final Credentials tempCreds$1;
            private final Path dst$1;

            public Void run() {
                Set nns = (Set)YarnSparkHadoopUtil$.MODULE$.get().getNameNodesToAccess(this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf).$plus((Object)this.dst$1);
                this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().obtainTokensForNamenodes((Set<Path>)nns, this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopConf, this.tempCreds$1, this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().obtainTokensForNamenodes$default$4());
                return null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tempCreds$1 = tempCreds$1;
                this.dst$1 = dst$1;
            }
        });
        UserGroupInformation.getCurrentUser().addCredentials(tempCreds);
        FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopConf);
        if (this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix() == 0) {
            Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).lastOption().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AMDelegationTokenRenewer $outer;

                public final void apply(FileStatus status) {
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix_$eq(this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().getSuffixForCredentialsPath(status.getPath()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        int nextSuffix = this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix() + 1;
        String tokenPathStr = new StringBuilder().append((Object)this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf.get("spark.yarn.credentials.file")).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()).append((Object)BoxesRunTime.boxToInteger((int)nextSuffix)).toString();
        Path tokenPath = new Path(tokenPathStr);
        Path tempTokenPath = new Path(new StringBuilder().append((Object)tokenPathStr).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION()).toString());
        this.logInfo((Function0<String>)new Serializable(this, tempTokenPath){
            public static final long serialVersionUID = 0L;
            private final Path tempTokenPath$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Writing out delegation tokens to ").append((Object)this.tempTokenPath$1.toString()).toString();
            }
            {
                this.tempTokenPath$1 = tempTokenPath$1;
            }
        });
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        credentials.writeTokenStorageFile(tempTokenPath, this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopConf);
        this.logInfo((Function0<String>)new Serializable(this, tokenPathStr){
            public static final long serialVersionUID = 0L;
            private final String tokenPathStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation Tokens written out successfully. Renaming file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenPathStr$1}));
            }
            {
                this.tokenPathStr$1 = tokenPathStr$1;
            }
        });
        remoteFs.rename(tempTokenPath, tokenPath);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delegation token file rename complete.";
            }
        });
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix_$eq(nextSuffix);
    }

    public void stop() {
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer().shutdown();
    }

    public final void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$scheduleRenewal$1(Runnable runnable) {
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        long renewalInterval = this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().getTimeFromNowToRenewal(this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf, 0.75, credentials);
        if (renewalInterval <= 0L) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "HDFS tokens have expired, creating new tokens now.";
                }
            });
            runnable.run();
        } else {
            this.logInfo((Function0<String>)new Serializable(this, renewalInterval){
                public static final long serialVersionUID = 0L;
                private final long renewalInterval$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling login from keytab in ", " millis."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.renewalInterval$1)}));
                }
                {
                    this.renewalInterval$1 = renewalInterval$1;
                }
            });
            this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer().schedule(runnable, renewalInterval, TimeUnit.MILLISECONDS);
        }
    }

    public AMDelegationTokenRenewer(SparkConf sparkConf, Configuration hadoopConf) {
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix = 0;
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer = Executors.newSingleThreadScheduledExecutor(ThreadUtils$.MODULE$.namedThreadFactory("Delegation Token Refresh Thread"));
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil = YarnSparkHadoopUtil$.MODULE$.get();
        this.daysToKeepFiles = sparkConf.getInt("spark.yarn.credentials.file.retention.days", 5);
        this.numFilesToKeep = sparkConf.getInt("spark.yarn.credentials.file.retention.count", 5);
    }
}

