/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataInputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.ExecutorDelegationTokenUpdater$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\u0001\u0003\u0001\u0019a!AH#yK\u000e,Ho\u001c:EK2,w-\u0019;j_:$vn[3o+B$\u0017\r^3s\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\ngB\f'o[\"p]\u001a\u001c\u0001\u0001\u0005\u0002\u00157%\u0011AD\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0011B\u0011A\u00025bI>|\u0007/\u0003\u0002'C\ti1i\u001c8gS\u001e,(/\u0019;j_:DQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtDc\u0001\u0016-[A\u00111\u0006A\u0007\u0002\u0005!)\u0001d\na\u00015!)ad\na\u0001?!9q\u0006\u0001b\u0001\n\u0013\u0001\u0014aD2sK\u0012,g\u000e^5bYN4\u0015\u000e\\3\u0016\u0003E\u0002\"AM\u001b\u000f\u00059\u0019\u0014B\u0001\u001b\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Qz\u0001BB\u001d\u0001A\u0003%\u0011'\u0001\tde\u0016$WM\u001c;jC2\u001ch)\u001b7fA!91\b\u0001b\u0001\n\u0013a\u0014A\u00063fY\u0016<\u0017\r^5p]R{7.\u001a8SK:,w/\u001a:\u0016\u0003u\u0002\"AP#\u000e\u0003}R!\u0001Q!\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002C\u0007\u0006!Q\u000f^5m\u0015\u0005!\u0015\u0001\u00026bm\u0006L!AR \u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0004I\u0001\u0001\u0006I!P\u0001\u0018I\u0016dWmZ1uS>tGk\\6f]J+g.Z<fe\u0002BqA\u0013\u0001C\u0002\u0013%1*A\ffq\u0016\u001cW\u000f^8s+B$\u0017\r^3s%Vtg.\u00192mKV\tAJE\u0002N#^3AAT(\u0001\u0019\naAH]3gS:,W.\u001a8u}!1\u0001\u000b\u0001Q\u0001\n1\u000b\u0001$\u001a=fGV$xN]+qI\u0006$XM\u001d*v]:\f'\r\\3!!\t\u0011V+D\u0001T\u0015\t!6)\u0001\u0003mC:<\u0017B\u0001,T\u0005\u0019y%M[3diB\u0011!\u000bW\u0005\u00033N\u0013\u0001BU;o]\u0006\u0014G.\u001a\u0005\u00067\u0002!\t\u0001X\u0001\u001ckB$\u0017\r^3De\u0016$WM\u001c;jC2\u001c\u0018J\u001a*fcVL'/\u001a3\u0015\u0003u\u0003\"A\u00040\n\u0005}{!\u0001B+oSRDQ!\u0019\u0001\u0005\n\t\f!dZ3u\u0007J,G-\u001a8uS\u0006d7O\u0012:p[\"#ei\u0015$jY\u0016$2aY5r!\t!w-D\u0001f\u0015\t17%\u0001\u0005tK\u000e,(/\u001b;z\u0013\tAWMA\u0006De\u0016$WM\u001c;jC2\u001c\b\"\u00026a\u0001\u0004Y\u0017\u0001\u0003:f[>$XMR:\u0011\u00051|W\"A7\u000b\u00059\u001c\u0013A\u00014t\u0013\t\u0001XN\u0001\u0006GS2,7+_:uK6DQA\u001d1A\u0002M\f\u0011\u0002^8lK:\u0004\u0016\r\u001e5\u0011\u00051$\u0018BA;n\u0005\u0011\u0001\u0016\r\u001e5\t\u000b]\u0004A\u0011\u0001/\u0002\tM$x\u000e\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0003ea\u0017m\u001d;De\u0016$WM\u001c;jC2\u001ch)\u001b7f'V4g-\u001b=\u0016\u0003m\u0004\"A\u0004?\n\u0005u|!aA%oi\"Aq\u0010\u0001a\u0001\n\u0013\t\t!A\u000fmCN$8I]3eK:$\u0018.\u00197t\r&dWmU;gM&Dx\fJ3r)\ri\u00161\u0001\u0005\t\u0003\u000bq\u0018\u0011!a\u0001w\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005%\u0001\u0001)Q\u0005w\u0006QB.Y:u\u0007J,G-\u001a8uS\u0006d7OR5mKN+hMZ5yA!\"\u0011qAA\u0007!\rq\u0011qB\u0005\u0004\u0003#y!\u0001\u0003<pY\u0006$\u0018\u000e\\3")
public class ExecutorDelegationTokenUpdater
implements Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final String credentialsFile;
    private final ScheduledExecutorService org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer;
    private final Runnable org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable;
    private volatile int org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix() {
        return this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix;
    }

    public void org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix = x$1;
    }

    private String credentialsFile() {
        return this.credentialsFile;
    }

    public ScheduledExecutorService org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer() {
        return this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer;
    }

    public Runnable org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable() {
        return this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable;
    }

    public void updateCredentialsIfRequired() {
        block7: {
            Object object = new Object();
            try {
                try {
                    Path credentialsFilePath = new Path(this.credentialsFile());
                    FileSystem remoteFs = FileSystem.get((Configuration)this.hadoopConf);
                    Predef$.MODULE$.refArrayOps((Object[])SparkHadoopUtil$.MODULE$.get().listFilesSorted(remoteFs, credentialsFilePath.getParent(), credentialsFilePath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).lastOption().foreach((Function1)new Serializable(this, remoteFs, object){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ExecutorDelegationTokenUpdater $outer;
                        private final FileSystem remoteFs$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(FileStatus credentialsStatus) {
                            int suffix = SparkHadoopUtil$.MODULE$.get().getSuffixForCredentialsPath(credentialsStatus.getPath());
                            if (suffix > this.$outer.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix()) {
                                this.$outer.logInfo((Function0<String>)new Serializable(this, credentialsStatus){
                                    public static final long serialVersionUID = 0L;
                                    private final FileStatus credentialsStatus$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Reading new delegation tokens from ").append((Object)this.credentialsStatus$1.getPath()).toString();
                                    }
                                    {
                                        this.credentialsStatus$1 = credentialsStatus$1;
                                    }
                                });
                                Credentials newCredentials = this.$outer.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$getCredentialsFromHDFSFile(this.remoteFs$1, credentialsStatus.getPath());
                                this.$outer.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix_$eq(suffix);
                                UserGroupInformation.getCurrentUser().addCredentials(newCredentials);
                                this.$outer.logInfo((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Tokens updated from credentials file.";
                                    }
                                });
                                return;
                            }
                            this.$outer.logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Updated delegation tokens were expected, but the driver has not updated the tokens yet, will check again in an hour.";
                                }
                            });
                            this.$outer.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer().schedule(this.$outer.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable(), 1L, TimeUnit.HOURS);
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.remoteFs$1 = remoteFs$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    long timeFromNowToRenewal = SparkHadoopUtil$.MODULE$.get().getTimeFromNowToRenewal(this.sparkConf, 0.8, UserGroupInformation.getCurrentUser().getCredentials());
                    if (timeFromNowToRenewal <= 0L) {
                        this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable().run();
                        break block7;
                    }
                    this.logInfo((Function0<String>)new Serializable(this, timeFromNowToRenewal){
                        public static final long serialVersionUID = 0L;
                        private final long timeFromNowToRenewal$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling token refresh from HDFS in ", " millis."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeFromNowToRenewal$1)}));
                        }
                        {
                            this.timeFromNowToRenewal$1 = timeFromNowToRenewal$1;
                        }
                    });
                    this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer().schedule(this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable(), timeFromNowToRenewal, TimeUnit.MILLISECONDS);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error while trying to update credentials, will try again in 1 hour";
                        }
                    }, e);
                    this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer().schedule(this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable(), 1L, TimeUnit.HOURS);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl) {
                if (nonLocalReturnControl.key() == object) {
                    nonLocalReturnControl.value$mcV$sp();
                }
                throw nonLocalReturnControl;
            }
        }
    }

    public Credentials org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$getCredentialsFromHDFSFile(FileSystem remoteFs, Path tokenPath) {
        FSDataInputStream stream = remoteFs.open(tokenPath);
        try {
            Credentials newCredentials = new Credentials();
            newCredentials.readTokenStorageStream((DataInputStream)stream);
            return newCredentials;
        }
        finally {
            stream.close();
        }
    }

    public void stop() {
        this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer().shutdown();
    }

    public ExecutorDelegationTokenUpdater(SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$lastCredentialsFileSuffix = 0;
        this.credentialsFile = sparkConf.get("spark.yarn.credentials.file");
        this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$delegationTokenRenewer = Executors.newSingleThreadScheduledExecutor(ThreadUtils$.MODULE$.namedThreadFactory("Delegation Token Refresh Thread"));
        this.org$apache$spark$deploy$yarn$ExecutorDelegationTokenUpdater$$executorUpdaterRunnable = new $anon$1(this);
    }
}

