/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u00015\u0011\u0001#\u0012=fGV$xN\u001d*v]:\f'\r\\3\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u000191\u0012\u0004\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\tyq#\u0003\u0002\u0019!\tA!+\u001e8oC\ndW\r\u0005\u0002\u001b75\ta!\u0003\u0002\u001d\r\t9Aj\\4hS:<\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0013\r|g\u000e^1j]\u0016\u0014\bC\u0001\u0011)\u001b\u0005\t#B\u0001\u0012$\u0003\u001d\u0011XmY8sINT!\u0001J\u0013\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0004M)\u0011q\u0005C\u0001\u0007Q\u0006$wn\u001c9\n\u0005%\n#!C\"p]R\f\u0017N\\3s\u0011!Y\u0003A!A!\u0002\u0013a\u0013\u0001B2p]\u001a\u0004\"!L\u0018\u000e\u00039R!a\u000b\u0014\n\u0005Ar#!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002\u001bi%\u0011QG\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u000e[\u0006\u001cH/\u001a:BI\u0012\u0014Xm]:\u0011\u0005ezdB\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ\u0014A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!AP\u001e\t\u0011\r\u0003!\u0011!Q\u0001\na\nqa\u001d7bm\u0016LE\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u00039\u0003!Awn\u001d;oC6,\u0007\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\u0002\u001d\u0015DXmY;u_JlU-\\8ssB\u0011!(S\u0005\u0003\u0015n\u00121!\u00138u\u0011!a\u0005A!A!\u0002\u0013A\u0015!D3yK\u000e,Ho\u001c:D_J,7\u000f\u0003\u0005O\u0001\t\u0005\t\u0015!\u00039\u0003\u0015\t\u0007\u000f]%e\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0016aC:fGV\u0014\u0018\u000e^=NOJ\u0004\"A\u0007*\n\u0005M3!aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\t\u000bU\u0003A\u0011\u0001,\u0002\rqJg.\u001b;?)-9\u0016LW.];z{\u0006-\u00192\u0011\u0005a\u0003Q\"\u0001\u0002\t\u000by!\u0006\u0019A\u0010\t\u000b-\"\u0006\u0019\u0001\u0017\t\u000bI\"\u0006\u0019A\u001a\t\u000b]\"\u0006\u0019\u0001\u001d\t\u000b\r#\u0006\u0019\u0001\u001d\t\u000b\u0015#\u0006\u0019\u0001\u001d\t\u000b\u001d#\u0006\u0019\u0001%\t\u000b1#\u0006\u0019\u0001%\t\u000b9#\u0006\u0019\u0001\u001d\t\u000bA#\u0006\u0019A)\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\u0006\u0019!\u000f]2\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!![\u0013\u0002\u0007%\u00048-\u0003\u0002lQ\n9\u0011,\u0019:o%B\u001b\u0005bB7\u0001\u0001\u0004%\tA\\\u0001\beB\u001cw\fJ3r)\ty'\u000f\u0005\u0002;a&\u0011\u0011o\u000f\u0002\u0005+:LG\u000fC\u0004tY\u0006\u0005\t\u0019\u00014\u0002\u0007a$\u0013\u0007\u0003\u0004v\u0001\u0001\u0006KAZ\u0001\u0005eB\u001c\u0007\u0005C\u0005x\u0001\u0001\u0007\t\u0019!C\u0001q\u0006Aa.\\\"mS\u0016tG/F\u0001z!\tQh0D\u0001|\u0015\t!CP\u0003\u0002~K\u000511\r\\5f]RL!a`>\u0003\u00119k5\t\\5f]RD1\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006\u0005aa.\\\"mS\u0016tGo\u0018\u0013fcR\u0019q.a\u0002\t\u0011M\f\t!!AA\u0002eDq!a\u0003\u0001A\u0003&\u00110A\u0005o[\u000ec\u0017.\u001a8uA!I\u0011q\u0002\u0001C\u0002\u0013\u0005\u0011\u0011C\u0001\ts\u0006\u0014hnQ8oMV\u0011\u00111\u0003\t\u0005\u0003+\tI\"\u0004\u0002\u0002\u0018)\u00111&J\u0005\u0005\u00037\t9BA\tZCJt7i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"a\b\u0001A\u0003%\u00111C\u0001\ns\u0006\u0014hnQ8oM\u0002B!\"a\t\u0001\u0011\u000b\u0007I\u0011AA\u0013\u0003\r)gN^\u000b\u0003\u0003O\u0001b!!\u000b\u00024aBTBAA\u0016\u0015\u0011\ti#a\f\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011G\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00026\u0005-\"a\u0002%bg\"l\u0015\r\u001d\u0005\u000b\u0003s\u0001\u0001\u0012!Q!\n\u0005\u001d\u0012\u0001B3om\u0002Bq!!\u0010\u0001\t\u0003\ny$A\u0002sk:$\u0012a\u001c\u0005\b\u0003\u0007\u0002A\u0011AA#\u00039\u0019H/\u0019:u\u0007>tG/Y5oKJ$\"!a\u0012\u0011\u000f\u0005%\u0013q\n\u001d\u0002T5\u0011\u00111\n\u0006\u0004\u0003\u001b\u0012\u0012\u0001B;uS2LA!!\u0015\u0002L\t\u0019Q*\u00199\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\u0013\u0003\rq\u0017n\\\u0005\u0005\u0003;\n9F\u0001\u0006CsR,')\u001e4gKJDq!!\u0019\u0001\t\u0013\t\u0019'\u0001\bqe\u0016\u0004\u0018M]3D_6l\u0017M\u001c3\u0015!\u0005\u0015\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u0005#BA4\u0003oBd\u0002BA5\u0003grA!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_b\u0011A\u0002\u001fs_>$h(C\u0001=\u0013\r\t)hO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI(a\u001f\u0003\t1K7\u000f\u001e\u0006\u0004\u0003kZ\u0004BB\u001c\u0002`\u0001\u0007\u0001\b\u0003\u0004D\u0003?\u0002\r\u0001\u000f\u0005\u0007\u000b\u0006}\u0003\u0019\u0001\u001d\t\r\u001d\u000by\u00061\u0001I\u0011\u0019a\u0015q\fa\u0001\u0011\"1a*a\u0018A\u0002aB\u0001\"a#\u0002`\u0001\u0007\u0011QR\u0001\u000fY>\u001c\u0017\r\u001c*fg>,(oY3t!\u001d\tI#a\r9\u0003\u001f\u00032\u0001IAI\u0013\r\t\u0019*\t\u0002\u000e\u0019>\u001c\u0017\r\u001c*fg>,(oY3\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\u0006)2/\u001a;va\u0012K7\u000f\u001e:jEV$X\rZ\"bG\",G#D8\u0002\u001c\u0006}\u0015\u0011VAV\u0003_\u000b\u0019\fC\u0004\u0002\u001e\u0006U\u0005\u0019\u0001\u001d\u0002\t\u0019LG.\u001a\u0005\t\u0003C\u000b)\n1\u0001\u0002$\u0006)!\u000f^=qKB\u0019\u0001%!*\n\u0007\u0005\u001d\u0016EA\tM_\u000e\fGNU3t_V\u00148-\u001a+za\u0016D\u0001\"a#\u0002\u0016\u0002\u0007\u0011Q\u0012\u0005\b\u0003[\u000b)\n1\u00019\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0004\u00022\u0006U\u0005\u0019\u0001\u001d\u0002\tML'0\u001a\u0005\b\u0003k\u000b)\n1\u00019\u0003\r1\u0018n\u001d\u0005\b\u0003s\u0003A\u0011BA^\u0003U\u0001(/\u001a9be\u0016dunY1m%\u0016\u001cx.\u001e:dKN,\"!!$\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\u0006\u0011\u0002O]3qCJ,WI\u001c<je>tW.\u001a8u)\u0011\t9#a1\t\ry\ti\f1\u0001 \u0001")
public class ExecutorRunnable
implements Runnable,
Logging {
    private final Container container;
    private final SparkConf sparkConf;
    private final String masterAddress;
    private final String slaveId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private YarnRPC rpc;
    private NMClient nmClient;
    private final YarnConfiguration yarnConf;
    private HashMap<String, String> env;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private HashMap env$lzycompute() {
        ExecutorRunnable executorRunnable = this;
        synchronized (executorRunnable) {
            if (!this.bitmap$0) {
                this.env = this.prepareEnvironment(this.container);
                this.bitmap$0 = true;
            }
            return this.env;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    public HashMap<String, String> env() {
        return this.bitmap$0 ? this.env : this.env$lzycompute();
    }

    @Override
    public void run() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting Executor Container";
            }
        });
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.yarnConf());
        this.nmClient().start();
        this.startContainer();
    }

    public java.util.Map<String, ByteBuffer> startContainer() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up ContainerLaunchContext";
            }
        });
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        HashMap<String, LocalResource> localResources = this.prepareLocalResources();
        ctx.setLocalResources(JavaConversions$.MODULE$.mutableMapAsJavaMap(localResources));
        ctx.setEnvironment(JavaConversions$.MODULE$.mutableMapAsJavaMap(this.env()));
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand(this.masterAddress, this.slaveId, this.hostname, this.executorMemory, this.executorCores, this.appId, localResources);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting up executor with environment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.env()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, commands){
            public static final long serialVersionUID = 0L;
            private final List commands$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Setting up executor with commands: ").append((Object)this.commands$1).toString();
            }
            {
                this.commands$1 = commands$1;
            }
        });
        ctx.setCommands(JavaConversions$.MODULE$.seqAsJavaList(commands));
        ctx.setApplicationACLs(JavaConversions$.MODULE$.mapAsJavaMap(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)));
        if (this.sparkConf.getBoolean("spark.shuffle.service.enabled", false)) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString == null ? ByteBuffer.allocate(0) : JavaUtils.stringToBytes((String)secretString);
            ctx.setServiceData(JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"spark_shuffle"), (Object)secretBytes)}))));
        }
        try {
            return this.nmClient().startContainer(this.container, ctx);
        }
        catch (Exception exception) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while starting container ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.container.getId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" on host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname}))).toString(), (Throwable)exception);
        }
    }

    private List<String> prepareCommand(String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId, HashMap<String, LocalResource> localResources) {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef prefixEnv = new ObjectRef((Object)None$.MODULE$);
        String executorMemoryString = new StringBuilder().append(executorMemory).append((Object)"m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xms").append((Object)executorMemoryString).toString());
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)executorMemoryString).toString());
        package$.MODULE$.props().get("spark.executor.extraJavaOptions").foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        package$.MODULE$.props().get("spark.executor.extraLibraryPath").foreach((Function1)new Serializable(this, prefixEnv){
            public static final long serialVersionUID = 0L;
            private final ObjectRef prefixEnv$1;

            public final void apply(String p) {
                this.prefixEnv$1.elem = new Some((Object)Utils$.MODULE$.libraryPathEnvPrefix((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}))));
            }
            {
                this.prefixEnv$1 = prefixEnv$1;
            }
        });
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)new Path(YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), "./tmp")).toString());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.sparkConf.getAll()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ListBuffer listBuffer = this.javaOpts$1.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}))));
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        Seq userClassPath = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Client$.MODULE$.getUserClasspath(this.sparkConf)).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(URI uri) {
                String absPath = new File(uri.getPath()).isAbsolute() ? uri.getPath() : Client$.MODULE$.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$(), uri.getPath()}));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--user-class-path", new StringBuilder().append((Object)"file:").append((Object)absPath).toString()}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSeq();
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable((Option)prefixEnv.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.JAVA_HOME)).append((Object)"/bin/java").toString(), "-server", "-XX:OnOutOfMemoryError='kill %p'"})), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.CoarseGrainedExecutorBackend", "--driver-url", masterAddress.toString(), "--executor-id", slaveId.toString(), "--hostname", hostname.toString(), "--cores", ((Object)BoxesRunTime.boxToInteger((int)executorCores)).toString(), "--app-id", appId})), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userClassPath, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1>", "<LOG_DIR>/stdout", "2>", "<LOG_DIR>/stderr"})), Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public void org$apache$spark$deploy$yarn$ExecutorRunnable$$setupDistributedCache(String file, LocalResourceType rtype, HashMap<String, LocalResource> localResources, String timestamp, String size, String vis) {
        URI uri = new URI(file);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(rtype);
        amJarRsrc.setVisibility(LocalResourceVisibility.valueOf((String)vis));
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromURI((URI)uri));
        amJarRsrc.setTimestamp(new StringOps(Predef$.MODULE$.augmentString(timestamp)).toLong());
        amJarRsrc.setSize(new StringOps(Predef$.MODULE$.augmentString(size)).toLong());
        localResources.update((Object)uri.getFragment(), (Object)amJarRsrc);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, LocalResource> prepareLocalResources() {
        void var1_1;
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Preparing Local resources";
            }
        });
        HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (System.getenv("SPARK_YARN_CACHE_FILES") != null) {
            String[] timeStamps = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_TIME_STAMPS"))).split(',');
            String[] fileSizes = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_FILE_SIZES"))).split(',');
            String[] distFiles = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES"))).split(',');
            String[] visibilities = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_VISIBILITIES"))).split(',');
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), distFiles.length - 1).foreach$mVc$sp((Function1)new Serializable(this, localResources, timeStamps, fileSizes, distFiles, visibilities){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorRunnable $outer;
                private final HashMap localResources$1;
                private final String[] timeStamps$1;
                private final String[] fileSizes$1;
                private final String[] distFiles$1;
                private final String[] visibilities$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$setupDistributedCache(this.distFiles$1[i], LocalResourceType.FILE, (HashMap<String, LocalResource>)this.localResources$1, this.timeStamps$1[i], this.fileSizes$1[i], this.visibilities$1[i]);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.localResources$1 = localResources$1;
                    this.timeStamps$1 = timeStamps$1;
                    this.fileSizes$1 = fileSizes$1;
                    this.distFiles$1 = distFiles$1;
                    this.visibilities$1 = visibilities$1;
                }
            });
        }
        if (System.getenv("SPARK_YARN_CACHE_ARCHIVES") != null) {
            String[] timeStamps = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_TIME_STAMPS"))).split(',');
            String[] fileSizes = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_FILE_SIZES"))).split(',');
            String[] distArchives = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES"))).split(',');
            String[] visibilities = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_VISIBILITIES"))).split(',');
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), distArchives.length - 1).foreach$mVc$sp((Function1)new Serializable(this, localResources, timeStamps, fileSizes, distArchives, visibilities){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorRunnable $outer;
                private final HashMap localResources$1;
                private final String[] timeStamps$2;
                private final String[] fileSizes$2;
                private final String[] distArchives$1;
                private final String[] visibilities$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$setupDistributedCache(this.distArchives$1[i], LocalResourceType.ARCHIVE, (HashMap<String, LocalResource>)this.localResources$1, this.timeStamps$2[i], this.fileSizes$2[i], this.visibilities$2[i]);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.localResources$1 = localResources$1;
                    this.timeStamps$2 = timeStamps$2;
                    this.fileSizes$2 = fileSizes$2;
                    this.distArchives$1 = distArchives$1;
                    this.visibilities$2 = visibilities$2;
                }
            });
        }
        this.logInfo((Function0<String>)new Serializable(this, localResources){
            public static final long serialVersionUID = 0L;
            private final HashMap localResources$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Prepared Local resources ").append((Object)this.localResources$1).toString();
            }
            {
                this.localResources$1 = localResources$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> prepareEnvironment(Container container) {
        void var2_2;
        String yarnHttpPolicy;
        HashMap env = new HashMap();
        Option extraCp = this.sparkConf.getOption("spark.executor.extraClassPath");
        Client$.MODULE$.populateClasspath(null, (Configuration)this.yarnConf(), this.sparkConf, (HashMap<String, String>)env, false, (Option<String>)extraCp);
        this.sparkConf.getExecutorEnv().foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        String string = yarnHttpPolicy = this.yarnConf().get("yarn.http.policy", "HTTP_ONLY");
        String string2 = "HTTPS_ONLY";
        String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
        package$.MODULE$.env().get((Object)"SPARK_USER").foreach((Function1)new Serializable(this, container, env, httpScheme){
            public static final long serialVersionUID = 0L;
            private final Container container$1;
            private final HashMap env$1;
            private final String httpScheme$1;

            public final void apply(String user) {
                String containerId = ConverterUtils.toString((ContainerId)this.container$1.getId());
                String address = this.container$1.getNodeHttpAddress();
                String baseUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "/node/containerlogs/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.httpScheme$1, address, containerId, user}));
                this.env$1.update((Object)"SPARK_LOG_URL_STDERR", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stderr?start=0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
                this.env$1.update((Object)"SPARK_LOG_URL_STDOUT", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stdout?start=0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
            }
            {
                this.container$1 = container$1;
                this.env$1 = env$1;
                this.httpScheme$1 = httpScheme$1;
            }
        });
        JavaConversions$.MODULE$.mapAsScalaMap(System.getenv()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.startsWith("SPARK");
            }
        }).foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.env$1.update((Object)k, (Object)v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var2_2;
    }

    public ExecutorRunnable(Container container, Configuration conf, SparkConf sparkConf, String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr) {
        this.container = container;
        this.sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.slaveId = slaveId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        Logging.class.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
        this.yarnConf = new YarnConfiguration(conf);
    }
}

