/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.remote.DisassociatedEvent;
import akka.remote.RemotingLifecycleEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.history.HistoryServer$;
import org.apache.spark.deploy.yarn.ApplicationMaster$;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.YarnAllocator;
import org.apache.spark.deploy.yarn.YarnRMClient;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.AkkaUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005c!B\u0001\u0003\u0001\u0019a!!E!qa2L7-\u0019;j_:l\u0015m\u001d;fe*\u00111\u0001B\u0001\u0005s\u0006\u0014hN\u0003\u0002\u0006\r\u00051A-\u001a9m_fT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\ta!\u0003\u0002\u0017\r\t9Aj\\4hS:<\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\t\u0005\u0014xm]\u0002\u0001!\tYB$D\u0001\u0003\u0013\ti\"A\u0001\u000eBaBd\u0017nY1uS>tW*Y:uKJ\f%oZ;nK:$8\u000f\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003\u0019\u0019G.[3oiB\u00111$I\u0005\u0003E\t\u0011A\"W1s]Jk5\t\\5f]RDQ\u0001\n\u0001\u0005\u0002\u0015\na\u0001P5oSRtDc\u0001\u0014(QA\u00111\u0004\u0001\u0005\u00061\r\u0002\rA\u0007\u0005\u0006?\r\u0002\r\u0001\t\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003%\u0019\b/\u0019:l\u0007>tg-F\u0001-!\t!R&\u0003\u0002/\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0007a\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0015M\u0004\u0018M]6D_:4\u0007\u0005C\u00043\u0001\t\u0007I\u0011B\u001a\u0002\u0011e\f'O\\\"p]\u001a,\u0012\u0001\u000e\t\u0003kmj\u0011A\u000e\u0006\u0003oa\nAaY8oM*\u00111!\u000f\u0006\u0003u!\ta\u0001[1e_>\u0004\u0018B\u0001\u001f7\u0005EI\u0016M\u001d8D_:4\u0017nZ;sCRLwN\u001c\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u0013e\f'O\\\"p]\u001a\u0004\u0003b\u0002!\u0001\u0005\u0004%I!Q\u0001\tSN$%/\u001b<feV\t!\t\u0005\u0002\u000f\u0007&\u0011Ai\u0004\u0002\b\u0005>|G.Z1o\u0011\u00191\u0005\u0001)A\u0005\u0005\u0006I\u0011n\u001d#sSZ,'\u000f\t\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0003Yi\u0017\r\u001f(v[\u0016CXmY;u_J4\u0015-\u001b7ve\u0016\u001cX#\u0001&\u0011\u00059Y\u0015B\u0001'\u0010\u0005\rIe\u000e\u001e\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002&\u0002/5\f\u0007PT;n\u000bb,7-\u001e;pe\u001a\u000b\u0017\u000e\\;sKN\u0004\u0003\"\u0003)\u0001\u0001\u0004\u0005\r\u0011\"\u0003R\u00039\u0011X\r]8si\u0016\u0014H\u000b\u001b:fC\u0012,\u0012A\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bA\u0001\\1oO*\tq+\u0001\u0003kCZ\f\u0017BA-U\u0005\u0019!\u0006N]3bI\"I1\f\u0001a\u0001\u0002\u0004%I\u0001X\u0001\u0013e\u0016\u0004xN\u001d;feRC'/Z1e?\u0012*\u0017\u000f\u0006\u0002^AB\u0011aBX\u0005\u0003?>\u0011A!\u00168ji\"9\u0011MWA\u0001\u0002\u0004\u0011\u0016a\u0001=%c!11\r\u0001Q!\nI\u000bqB]3q_J$XM\u001d+ie\u0016\fG\r\t\u0005\nK\u0002\u0001\r\u00111A\u0005\n\u0019\f\u0011\"\u00197m_\u000e\fGo\u001c:\u0016\u0003\u001d\u0004\"a\u00075\n\u0005%\u0014!!D-be:\fE\u000e\\8dCR|'\u000fC\u0005l\u0001\u0001\u0007\t\u0019!C\u0005Y\u0006i\u0011\r\u001c7pG\u0006$xN]0%KF$\"!X7\t\u000f\u0005T\u0017\u0011!a\u0001O\"1q\u000e\u0001Q!\n\u001d\f!\"\u00197m_\u000e\fGo\u001c:!\u0011\u001d\t\b\u00011A\u0005\nI\f1\"Y2u_J\u001c\u0016p\u001d;f[V\t1\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006)\u0011m\u0019;pe*\t\u00010\u0001\u0003bW.\f\u0017B\u0001>v\u0005-\t5\r^8s'f\u001cH/Z7\t\u000fq\u0004\u0001\u0019!C\u0005{\u0006y\u0011m\u0019;peNK8\u000f^3n?\u0012*\u0017\u000f\u0006\u0002^}\"9\u0011m_A\u0001\u0002\u0004\u0019\bbBA\u0001\u0001\u0001\u0006Ka]\u0001\rC\u000e$xN]*zgR,W\u000e\t\u0005\u000bm\u0002\u0001\r\u00111A\u0005\n\u0005\u0015QCAA\u0004!\r!\u0018\u0011B\u0005\u0004\u0003\u0017)(\u0001C!di>\u0014(+\u001a4\t\u0017\u0005=\u0001\u00011AA\u0002\u0013%\u0011\u0011C\u0001\nC\u000e$xN]0%KF$2!XA\n\u0011%\t\u0017QBA\u0001\u0002\u0004\t9\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0015BA\u0004\u0003\u0019\t7\r^8sA!I\u00111\u0004\u0001C\u0002\u0013%\u0011QD\u0001\u0010gB\f'o[\"p]R,\u0007\u0010\u001e*fMV\u0011\u0011q\u0004\t\u0007\u0003C\ty#a\r\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\ta!\u0019;p[&\u001c'\u0002BA\u0015\u0003W\t!bY8oGV\u0014(/\u001a8u\u0015\r\tiCV\u0001\u0005kRLG.\u0003\u0003\u00022\u0005\r\"aD!u_6L7MU3gKJ,gnY3\u0011\u0007Q\t)$C\u0002\u00028\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\"a\u000f\u0001A\u0003%\u0011qD\u0001\u0011gB\f'o[\"p]R,\u0007\u0010\u001e*fM\u0002Bq!a\u0010\u0001\t\u000b\t\t%A\u0002sk:$\u0012A\u0013\u0005\b\u0003\u000b\u0002AQAA$\u0003U9W\r\u001e#fM\u0006,H\u000e\u001e$j]\u0006d7\u000b^1ukN$\"!!\u0013\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u00059!/Z2pe\u0012\u001c(bAA*q\u0005\u0019\u0011\r]5\n\t\u0005]\u0013Q\n\u0002\u0017\r&t\u0017\r\\!qa2L7-\u0019;j_:\u001cF/\u0019;vg\"9\u00111\f\u0001\u0005\u0006\u0005u\u0013AC;oe\u0016<\u0017n\u001d;feR)Q,a\u0018\u0002d!A\u0011\u0011MA-\u0001\u0004\tI%\u0001\u0004ti\u0006$Xo\u001d\u0005\u000b\u0003K\nI\u0006%AA\u0002\u0005\u001d\u0014a\u00033jC\u001etwn\u001d;jGN\u0004B!!\u001b\u0002p9\u0019a\"a\u001b\n\u0007\u00055t\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\n\u0019H\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[z\u0001bBA<\u0001\u0011\u0015\u0011\u0011P\u0001\u0007M&t\u0017n\u001d5\u0015\u000fu\u000bY(! \u0002\u0002\"A\u0011\u0011MA;\u0001\u0004\tI\u0005C\u0004\u0002\u0000\u0005U\u0004\u0019\u0001&\u0002\t\r|G-\u001a\u0005\u000b\u0003\u0007\u000b)\b%AA\u0002\u0005\u001d\u0014aA7tO\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015aF:qCJ\\7i\u001c8uKb$\u0018J\\5uS\u0006d\u0017N_3e)\ri\u00161\u0012\u0005\t\u0003\u001b\u000b)\t1\u0001\u00024\u0005\u00111o\u0019\u0005\b\u0003#\u0003A\u0011BAJ\u0003M\u0019\b/\u0019:l\u0007>tG/\u001a=u'R|\u0007\u000f]3e)\r\u0011\u0015Q\u0013\u0005\t\u0003\u001b\u000by\t1\u0001\u00024!9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0015A\u0003:fO&\u001cH/\u001a:B\u001bR)Q,!(\u0002\"\"A\u0011qTAL\u0001\u0004\t9'A\u0005vS\u0006#GM]3tg\"A\u00111UAL\u0001\u0004\t)+A\u0006tK\u000e,(/\u001b;z\u001b\u001e\u0014\bc\u0001\u000b\u0002(&\u0019\u0011\u0011\u0016\u0004\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJDq!!,\u0001\t\u0013\ty+A\u0005sk:$%/\u001b<feR\u0019Q,!-\t\u0011\u0005\r\u00161\u0016a\u0001\u0003KCq!!.\u0001\t\u0013\t9,A\nsk:,\u00050Z2vi>\u0014H*Y;oG\",'\u000fF\u0002^\u0003sC\u0001\"a)\u00024\u0002\u0007\u0011Q\u0015\u0005\b\u0003{\u0003A\u0011BA`\u0003Qa\u0017-\u001e8dQJ+\u0007o\u001c:uKJ$\u0006N]3bIR\t!\u000bC\u0004\u0002D\u0002!I!!2\u0002#\rdW-\u00198vaN#\u0018mZ5oO\u0012K'\u000fF\u0002^\u0003\u000fD\u0001\"!3\u0002B\u0002\u0007\u00111Z\u0001\u0003MN\u0004B!!4\u0002R6\u0011\u0011q\u001a\u0006\u0004\u0003\u0013L\u0014\u0002BAj\u0003\u001f\u0014!BR5mKNK8\u000f^3n\u0011\u001d\t9\u000e\u0001C\u0005\u00033\fad^1ji\u001a{'o\u00159be.\u001cuN\u001c;fqRLe.\u001b;jC2L'0\u001a3\u0015\u0005\u0005M\u0002bBAo\u0001\u0011%\u0011q\\\u0001\u0013o\u0006LGOR8s'B\f'o\u001b#sSZ,'\u000f\u0006\u0002\u0002\b!9\u00111\u001d\u0001\u0005\n\u0005\u0015\u0018!D1eI\u0006k\u0017\n\u001d$jYR,'\u000fF\u0001^\u0011\u001d\tI\u000f\u0001C\u0005\u0003\u007f\u000bab\u001d;beR,6/\u001a:DY\u0006\u001c8O\u0002\u0004\u0002n\u0002!\u0011q\u001e\u0002\b\u00036\u000b5\r^8s'\u0015\tY/DAy!\r!\u00181_\u0005\u0004\u0003k,(!B!di>\u0014\bbCA}\u0003W\u0014\t\u0011)A\u0005\u0003O\n\u0011\u0002\u001a:jm\u0016\u0014XK\u001d7\t\u000f\u0011\nY\u000f\"\u0001\u0002~R!\u0011q B\u0002!\u0011\u0011\t!a;\u000e\u0003\u0001A\u0001\"!?\u0002|\u0002\u0007\u0011q\r\u0005\r\u0005\u000f\tY\u000f1AA\u0002\u0013\u0005!\u0011B\u0001\u0007IJLg/\u001a:\u0016\u0005\t-\u0001c\u0001;\u0003\u000e%\u0019!qB;\u0003\u001d\u0005\u001bGo\u001c:TK2,7\r^5p]\"a!1CAv\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u0016\u0005QAM]5wKJ|F%Z9\u0015\u0007u\u00139\u0002C\u0005b\u0005#\t\t\u00111\u0001\u0003\f!I!1DAvA\u0003&!1B\u0001\bIJLg/\u001a:!\u0011!\u0011y\"a;\u0005B\u0005\u0015\u0018\u0001\u00039sKN#\u0018M\u001d;\t\u0011\t\r\u00121\u001eC!\u0005K\tqA]3dK&4X-\u0006\u0002\u0003(A1aB!\u000b\u0003.uK1Aa\u000b\u0010\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007c\u0001\b\u00030%\u0019!\u0011G\b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u00036\u0001\u0001\r\u0011\"\u0003J\u0003!)\u00070\u001b;D_\u0012,\u0007\"\u0003B\u001d\u0001\u0001\u0007I\u0011\u0002B\u001e\u00031)\u00070\u001b;D_\u0012,w\fJ3r)\ri&Q\b\u0005\tC\n]\u0012\u0011!a\u0001\u0015\"9!\u0011\t\u0001!B\u0013Q\u0015!C3ySR\u001cu\u000eZ3!Q\u0011\u0011yD!\u0012\u0011\u00079\u00119%C\u0002\u0003J=\u0011\u0001B^8mCRLG.\u001a\u0005\t\u0005\u001b\u0002\u0001\u0019!C\u0005\u0003\u0006aQO\u001c:fO&\u001cH/\u001a:fI\"I!\u0011\u000b\u0001A\u0002\u0013%!1K\u0001\u0011k:\u0014XmZ5ti\u0016\u0014X\rZ0%KF$2!\u0018B+\u0011!\t'qJA\u0001\u0002\u0004\u0011\u0005b\u0002B-\u0001\u0001\u0006KAQ\u0001\u000ek:\u0014XmZ5ti\u0016\u0014X\r\u001a\u0011)\t\t]#Q\t\u0005\t\u0005?\u0002\u0001\u0019!C\u0005\u0003\u0006Aa-\u001b8jg\",G\rC\u0005\u0003d\u0001\u0001\r\u0011\"\u0003\u0003f\u0005aa-\u001b8jg\",Gm\u0018\u0013fcR\u0019QLa\u001a\t\u0011\u0005\u0014\t'!AA\u0002\tCqAa\u001b\u0001A\u0003&!)A\u0005gS:L7\u000f[3eA!\"!\u0011\u000eB#\u0011%\u0011\t\b\u0001a\u0001\n\u0013\u0011\u0019(A\u0006gS:\fGn\u0015;biV\u001cXCAA%\u0011%\u00119\b\u0001a\u0001\n\u0013\u0011I(A\bgS:\fGn\u0015;biV\u001cx\fJ3r)\ri&1\u0010\u0005\nC\nU\u0014\u0011!a\u0001\u0003\u0013B\u0001Ba \u0001A\u0003&\u0011\u0011J\u0001\rM&t\u0017\r\\*uCR,8\u000f\t\u0015\u0005\u0005{\u0012)\u0005C\u0005\u0003\u0006\u0002\u0001\r\u0011\"\u0003\u0003\b\u0006Aa-\u001b8bY6\u001bx-\u0006\u0002\u0002h!I!1\u0012\u0001A\u0002\u0013%!QR\u0001\rM&t\u0017\r\\'tO~#S-\u001d\u000b\u0004;\n=\u0005\"C1\u0003\n\u0006\u0005\t\u0019AA4\u0011!\u0011\u0019\n\u0001Q!\n\u0005\u001d\u0014!\u00034j]\u0006dWj]4!Q\u0011\u0011\tJ!\u0012\t\u0015\te\u0005\u00011AA\u0002\u0013%\u0011+A\bvg\u0016\u00148\t\\1tgRC'/Z1e\u0011-\u0011i\n\u0001a\u0001\u0002\u0004%IAa(\u0002'U\u001cXM]\"mCN\u001cH\u000b\u001b:fC\u0012|F%Z9\u0015\u0007u\u0013\t\u000b\u0003\u0005b\u00057\u000b\t\u00111\u0001S\u0011\u001d\u0011)\u000b\u0001Q!\nI\u000b\u0001#^:fe\u000ec\u0017m]:UQJ,\u0017\r\u001a\u0011)\t\t\r&Q\t\u0005\n\u0005W\u0003\u0011\u0013!C\u0003\u0005[\u000b\u0001CZ5oSNDG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t=&\u0006BA4\u0005c[#Aa-\u0011\t\tU&qX\u0007\u0003\u0005oSAA!/\u0003<\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005{{\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u0019B\\\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005\u000b\u0004\u0011\u0013!C\u0003\u0005[\u000bA#\u001e8sK\u001eL7\u000f^3sI\u0011,g-Y;mi\u0012\u0012ta\u0002Be\u0005!\u0005!1Z\u0001\u0012\u0003B\u0004H.[2bi&|g.T1ti\u0016\u0014\bcA\u000e\u0003N\u001a1\u0011A\u0001E\u0001\u0005\u001f\u001cBA!4\u000e'!9AE!4\u0005\u0002\tMGC\u0001Bf\u0011%\u00119N!4C\u0002\u0013\u0005\u0011*\u0001\fT\u0011V#FiT,O?\"{ujS0Q%&{%+\u0013+Z\u0011!\u0011YN!4!\u0002\u0013Q\u0015aF*I+R#uj\u0016(`\u0011>{5j\u0018)S\u0013>\u0013\u0016\nV-!\u0011%\u0011yN!4C\u0002\u0013%\u0011*\u0001\u0007F1&#vlU+D\u0007\u0016\u001b6\u000b\u0003\u0005\u0003d\n5\u0007\u0015!\u0003K\u00035)\u0005,\u0013+`'V\u001b5)R*TA!I!q\u001dBg\u0005\u0004%I!S\u0001\u0018\u000bbKEkX+O\u0007\u0006+v\t\u0013+`\u000bb\u001bU\t\u0015+J\u001f:C\u0001Ba;\u0003N\u0002\u0006IAS\u0001\u0019\u000bbKEkX+O\u0007\u0006+v\t\u0013+`\u000bb\u001bU\t\u0015+J\u001f:\u0003\u0003\"\u0003Bx\u0005\u001b\u0014\r\u0011\"\u0003J\u0003i)\u0005,\u0013+`\u001b\u0006Cv,\u0012-F\u0007V#vJU0G\u0003&cUKU#T\u0011!\u0011\u0019P!4!\u0002\u0013Q\u0015aG#Y\u0013R{V*\u0011-`\u000bb+5)\u0016+P%~3\u0015)\u0013'V%\u0016\u001b\u0006\u0005C\u0005\u0003x\n5'\u0019!C\u0005\u0013\u0006)R\tW%U?J+\u0005k\u0014*U\u000bJ{f)Q%M+J+\u0005\u0002\u0003B~\u0005\u001b\u0004\u000b\u0011\u0002&\u0002-\u0015C\u0016\nV0S\u000bB{%\u000bV#S?\u001a\u000b\u0015\nT+S\u000b\u0002B\u0011Ba@\u0003N\n\u0007I\u0011B%\u0002%\u0015C\u0016\nV0T\u0007~su\nV0J\u001d&#V\t\u0012\u0005\t\u0007\u0007\u0011i\r)A\u0005\u0015\u0006\u0019R\tW%U?N\u001buLT(U?&s\u0015\nV#EA!I1q\u0001Bg\u0005\u0004%I!S\u0001\u000e\u000bbKEkX*F\u0007V\u0013\u0016\nV-\t\u0011\r-!Q\u001aQ\u0001\n)\u000ba\"\u0012-J)~\u001bViQ+S\u0013RK\u0006\u0005C\u0005\u0004\u0010\t5'\u0019!C\u0005\u0013\u0006IR\tW%U?\u0016C6)\u0012)U\u0013>su,V*F%~\u001bE*Q*T\u0011!\u0019\u0019B!4!\u0002\u0013Q\u0015AG#Y\u0013R{V\tW\"F!RKuJT0V'\u0016\u0013vl\u0011'B'N\u0003\u0003\u0002DB\f\u0005\u001b\u0004\r\u00111A\u0005\n\re\u0011AB7bgR,'/F\u0001'\u00111\u0019iB!4A\u0002\u0003\u0007I\u0011BB\u0010\u0003)i\u0017m\u001d;fe~#S-\u001d\u000b\u0004;\u000e\u0005\u0002\u0002C1\u0004\u001c\u0005\u0005\t\u0019\u0001\u0014\t\u0011\r\u0015\"Q\u001aQ!\n\u0019\nq!\\1ti\u0016\u0014\b\u0005\u0003\u0005\u0004*\t5G\u0011AB\u0016\u0003\u0011i\u0017-\u001b8\u0015\u0007u\u001bi\u0003C\u0004\u0019\u0007O\u0001\raa\f\u0011\u000b9\u0019\t$a\u001a\n\u0007\rMrBA\u0003BeJ\f\u0017\u0010C\u0005\u0002\b\n5G\u0011\u0001\u0004\u00048Q\u0019Ql!\u000f\t\u0011\u000555Q\u0007a\u0001\u0003gA\u0011\"!%\u0003N\u0012\u0005aa!\u0010\u0015\u0007\t\u001by\u0004\u0003\u0005\u0002\u000e\u000em\u0002\u0019AA\u001a\u0001")
public class ApplicationMaster
implements Logging {
    public final ApplicationMasterArguments org$apache$spark$deploy$yarn$ApplicationMaster$$args;
    public final YarnRMClient org$apache$spark$deploy$yarn$ApplicationMaster$$client;
    private final SparkConf sparkConf;
    private final YarnConfiguration org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf;
    private final boolean isDriver;
    private final int org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumExecutorFailures;
    private Thread reporterThread;
    private YarnAllocator org$apache$spark$deploy$yarn$ApplicationMaster$$allocator;
    private ActorSystem actorSystem;
    private ActorRef actor;
    private final AtomicReference<SparkContext> org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef;
    private volatile int exitCode;
    private volatile boolean org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered;
    private volatile boolean org$apache$spark$deploy$yarn$ApplicationMaster$$finished;
    private volatile FinalApplicationStatus org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus;
    private volatile String org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg;
    private volatile Thread userClassThread;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        ApplicationMaster$.MODULE$.main(stringArray);
    }

    public static int SHUTDOWN_HOOK_PRIORITY() {
        return ApplicationMaster$.MODULE$.SHUTDOWN_HOOK_PRIORITY();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    public YarnConfiguration org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf;
    }

    private boolean isDriver() {
        return this.isDriver;
    }

    public int org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumExecutorFailures() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumExecutorFailures;
    }

    private int exitCode() {
        return this.exitCode;
    }

    private void exitCode_$eq(int x$1) {
        this.exitCode = x$1;
    }

    public boolean org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered_$eq(boolean x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered = x$1;
    }

    public boolean org$apache$spark$deploy$yarn$ApplicationMaster$$finished() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$finished;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$finished_$eq(boolean x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$finished = x$1;
    }

    public FinalApplicationStatus org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus_$eq(FinalApplicationStatus x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus = x$1;
    }

    public String org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg_$eq(String x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg = x$1;
    }

    private Thread userClassThread() {
        return this.userClassThread;
    }

    private void userClassThread_$eq(Thread x$1) {
        this.userClassThread = x$1;
    }

    private Thread reporterThread() {
        return this.reporterThread;
    }

    private void reporterThread_$eq(Thread x$1) {
        this.reporterThread = x$1;
    }

    public YarnAllocator org$apache$spark$deploy$yarn$ApplicationMaster$$allocator() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$allocator;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$allocator_$eq(YarnAllocator x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$allocator = x$1;
    }

    private ActorSystem actorSystem() {
        return this.actorSystem;
    }

    private void actorSystem_$eq(ActorSystem x$1) {
        this.actorSystem = x$1;
    }

    private ActorRef actor() {
        return this.actor;
    }

    private void actor_$eq(ActorRef x$1) {
        this.actor = x$1;
    }

    public AtomicReference<SparkContext> org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef;
    }

    public final int run() {
        try {
            Object object;
            ApplicationAttemptId appAttemptId = this.org$apache$spark$deploy$yarn$ApplicationMaster$$client.getAttemptId();
            if (this.isDriver()) {
                System.setProperty("spark.ui.port", "0");
                System.setProperty("spark.master", "yarn-cluster");
                object = System.setProperty("spark.yarn.app.id", appAttemptId.getApplicationId().toString());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.logInfo((Function0<String>)new Serializable(this, appAttemptId){
                private final ApplicationAttemptId appAttemptId$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"ApplicationAttemptId: ").append((Object)this.appAttemptId$1).toString();
                }
                {
                    this.appAttemptId$1 = appAttemptId$1;
                }
            });
            FileSystem fs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf());
            Runnable cleanupHook = new Runnable(this, fs){
                private final /* synthetic */ ApplicationMaster $outer;
                private final FileSystem fs$1;

                public void run() {
                    boolean isLastAttempt;
                    SparkContext sc = this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().get();
                    if (sc != null) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this){

                            public final String apply() {
                                return "Invoking sc stop from shutdown hook";
                            }
                        });
                        sc.stop();
                    }
                    int maxAppAttempts = this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$client.getMaxRegAttempts(this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf());
                    boolean bl = isLastAttempt = this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$client.getAttemptId().getAttemptId() >= maxAppAttempts;
                    if (!this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$finished()) {
                        this.$outer.finish(this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus(), ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_SUCCESS(), "Shutdown hook called before final status was reported.");
                    }
                    if (!this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered()) {
                        FinalApplicationStatus finalApplicationStatus = this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus();
                        FinalApplicationStatus finalApplicationStatus2 = FinalApplicationStatus.SUCCEEDED;
                        if (!(finalApplicationStatus == null ? finalApplicationStatus2 != null : !finalApplicationStatus.equals(finalApplicationStatus2)) || isLastAttempt) {
                            this.$outer.unregister(this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus(), this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg());
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$cleanupStagingDir(this.fs$1);
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fs$1 = fs$1;
                }
            };
            Predef$.MODULE$.assert(ApplicationMaster$.MODULE$.SHUTDOWN_HOOK_PRIORITY() > 10);
            ShutdownHookManager.get().addShutdownHook(cleanupHook, ApplicationMaster$.MODULE$.SHUTDOWN_HOOK_PRIORITY());
            SecurityManager securityMgr = new SecurityManager(this.sparkConf());
            if (this.isDriver()) {
                this.runDriver(securityMgr);
            } else {
                this.runExecutorLauncher(securityMgr);
            }
        }
        catch (Exception exception) {
            this.logError((Function0<String>)new Serializable(this){

                public final String apply() {
                    return "Uncaught exception: ";
                }
            }, exception);
            this.finish(FinalApplicationStatus.FAILED, ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_UNCAUGHT_EXCEPTION(), new StringBuilder().append((Object)"Uncaught exception: ").append((Object)exception.getMessage()).toString());
        }
        return this.exitCode();
    }

    public final FinalApplicationStatus getDefaultFinalStatus() {
        return this.isDriver() ? FinalApplicationStatus.SUCCEEDED : FinalApplicationStatus.UNDEFINED;
    }

    public final synchronized void unregister(FinalApplicationStatus status, String diagnostics) {
        if (!this.org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered()) {
            this.logInfo((Function0<String>)new Serializable(this, status, diagnostics){
                private final FinalApplicationStatus status$2;
                private final String diagnostics$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unregistering ApplicationMaster with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$2}))).append(Option$.MODULE$.apply((Object)this.diagnostics$1).map((Function1)new Serializable(this){

                        public final String apply(String msg) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (diag message: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg}));
                        }
                    }).getOrElse((Function0)new Serializable(this){

                        public final String apply() {
                            return "";
                        }
                    })).toString();
                }
                {
                    this.status$2 = status$2;
                    this.diagnostics$1 = diagnostics$1;
                }
            });
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered_$eq(true);
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$client.unregister(status, (String)Option$.MODULE$.apply((Object)diagnostics).getOrElse((Function0)new Serializable(this){

                public final String apply() {
                    return "";
                }
            }));
        }
    }

    public final String unregister$default$2() {
        return null;
    }

    public final synchronized void finish(FinalApplicationStatus status, int code, String msg) {
        if (!this.org$apache$spark$deploy$yarn$ApplicationMaster$$finished()) {
            boolean inShutdown = Utils$.MODULE$.inShutdown();
            this.logInfo((Function0<String>)new Serializable(this, status, code, msg){
                private final FinalApplicationStatus status$1;
                private final int code$1;
                private final String msg$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final app status: ", ", exitCode: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$1, BoxesRunTime.boxToInteger((int)this.code$1)}))).append(Option$.MODULE$.apply((Object)this.msg$1).map((Function1)new Serializable(this){

                        public final String apply(String msg) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", (reason: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg}));
                        }
                    }).getOrElse((Function0)new Serializable(this){

                        public final String apply() {
                            return "";
                        }
                    })).toString();
                }
                {
                    this.status$1 = status$1;
                    this.code$1 = code$1;
                    this.msg$1 = msg$1;
                }
            });
            this.exitCode_$eq(code);
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus_$eq(status);
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg_$eq(msg);
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$finished_$eq(true);
            if (!inShutdown) {
                Thread thread = Thread.currentThread();
                Thread thread2 = this.reporterThread();
                if ((thread == null ? thread2 != null : !thread.equals(thread2)) && this.reporterThread() != null) {
                    this.logDebug((Function0<String>)new Serializable(this){

                        public final String apply() {
                            return "shutting down reporter thread";
                        }
                    });
                    this.reporterThread().interrupt();
                }
            }
            if (!inShutdown) {
                Thread thread = Thread.currentThread();
                Thread thread3 = this.userClassThread();
                if ((thread == null ? thread3 != null : !thread.equals(thread3)) && this.userClassThread() != null) {
                    this.logDebug((Function0<String>)new Serializable(this){

                        public final String apply() {
                            return "shutting down user thread";
                        }
                    });
                    this.userClassThread().interrupt();
                }
            }
        }
    }

    public final String finish$default$3() {
        return null;
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextInitialized(SparkContext sc) {
        AtomicReference<SparkContext> atomicReference = this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef();
        synchronized (atomicReference) {
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().compareAndSet(null, sc);
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().notifyAll();
            return;
        }
    }

    public boolean org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextStopped(SparkContext sc) {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().compareAndSet(sc, null);
    }

    private void registerAM(String uiAddress, SecurityManager securityMgr) {
        SparkContext sc = this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().get();
        String appId = this.org$apache$spark$deploy$yarn$ApplicationMaster$$client.getAttemptId().getApplicationId().toString();
        String historyAddress = (String)this.sparkConf().getOption("spark.yarn.historyServer.address").map((Function1)new Serializable(this, appId){
            private final String appId$1;

            public final String apply(String address) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address, HistoryServer$.MODULE$.UI_PATH_PREFIX(), this.appId$1}));
            }
            {
                this.appId$1 = appId$1;
            }
        }).getOrElse((Function0)new Serializable(this){

            public final String apply() {
                return "";
            }
        });
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$allocator_$eq(this.org$apache$spark$deploy$yarn$ApplicationMaster$$client.register(this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf(), sc == null ? this.sparkConf() : sc.getConf(), (Map<String, Set<SplitInfo>>)(sc == null ? (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$) : sc.preferredNodeLocationData()), uiAddress, historyAddress, securityMgr));
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$allocator().allocateResources();
        this.reporterThread_$eq(this.launchReporterThread());
    }

    private void runDriver(SecurityManager securityMgr) {
        this.addAmIpFilter();
        this.userClassThread_$eq(this.startUserClass());
        SparkContext sc = this.waitForSparkContextInitialized();
        if (sc == null) {
            this.finish(FinalApplicationStatus.FAILED, ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_SC_NOT_INITED(), "Timed out waiting for SparkContext.");
        } else {
            this.registerAM((String)sc.ui().map((Function1)new Serializable(this){

                public final String apply(SparkUI x$1) {
                    return x$1.appUIAddress();
                }
            }).getOrElse((Function0)new Serializable(this){

                public final String apply() {
                    return "";
                }
            }), securityMgr);
            this.userClassThread().join();
        }
    }

    private void runExecutorLauncher(SecurityManager securityMgr) {
        this.actorSystem_$eq((ActorSystem)AkkaUtils$.MODULE$.createActorSystem("sparkYarnAM", Utils$.MODULE$.localHostName(), 0, this.sparkConf(), securityMgr)._1());
        this.actor_$eq(this.waitForSparkDriver());
        this.addAmIpFilter();
        this.registerAM(this.sparkConf().get("spark.driver.appUIAddress", ""), securityMgr);
        this.reporterThread().join();
    }

    private Thread launchReporterThread() {
        int expiryInterval = this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf().getInt("yarn.am.liveness-monitor.expiry-interval-ms", 120000);
        long schedulerInterval = this.sparkConf().getLong("spark.yarn.scheduler.heartbeat.interval-ms", 5000L);
        long interval = scala.math.package$.MODULE$.max(0L, scala.math.package$.MODULE$.min((long)(expiryInterval / 2), schedulerInterval));
        int reporterMaxFailures = this.sparkConf().getInt("spark.yarn.scheduler.reporterThread.maxFailures", 5);
        Thread t = new Thread(this, interval, reporterMaxFailures){
            private final /* synthetic */ ApplicationMaster $outer;
            private final long interval$1;
            private final int reporterMaxFailures$1;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                IntRef failureCount = IntRef.create((int)0);
                while (!this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$finished()) {
                    try {
                        if (this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$allocator().getNumExecutorsFailed() >= this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumExecutorFailures()) {
                            this.$outer.finish(FinalApplicationStatus.FAILED, ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_MAX_EXECUTOR_FAILURES(), "Max number of executor failures reached");
                        } else {
                            this.$outer.logDebug((Function0<String>)new Serializable(this){

                                public final String apply() {
                                    return "Sending progress";
                                }
                            });
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$allocator().allocateResources();
                        }
                        failureCount.elem = 0;
                    }
                    catch (Throwable throwable) {
                        ++failureCount.elem;
                        if (NonFatal$.MODULE$.apply(throwable) && failureCount.elem < this.reporterMaxFailures$1) {
                            this.$outer.logWarning((Function0<String>)new Serializable(this, failureCount){
                                private final IntRef failureCount$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reporter thread fails ", " time(s) in a row."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.failureCount$1.elem)}));
                                }
                                {
                                    this.failureCount$1 = failureCount$1;
                                }
                            }, throwable);
                        } else {
                            this.$outer.finish(FinalApplicationStatus.FAILED, ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_REPORTER_FAILURE(), new StringBuilder().append((Object)"Exception was thrown ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " time(s) from Reporter thread."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)failureCount.elem)}))).toString());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    {
                        Thread.sleep(this.interval$1);
                        continue;
                    }
                    break;
                }
                return;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.interval$1 = interval$1;
                this.reporterMaxFailures$1 = reporterMaxFailures$1;
            }
        };
        t.setDaemon(true);
        t.setName("Reporter");
        t.start();
        this.logInfo((Function0<String>)new Serializable(this, interval){
            private final long interval$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Started progress reporter thread - sleep time : ").append((Object)BoxesRunTime.boxToLong((long)this.interval$1)).toString();
            }
            {
                this.interval$1 = interval$1;
            }
        });
        return t;
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$cleanupStagingDir(FileSystem fs) {
        ObjectRef stagingDirPath = ObjectRef.create(null);
        try {
            boolean preserveFiles = new StringOps(Predef$.MODULE$.augmentString(this.sparkConf().get("spark.yarn.preserve.staging.files", "false"))).toBoolean();
            if (!preserveFiles) {
                stagingDirPath.elem = new Path(System.getenv("SPARK_YARN_STAGING_DIR"));
                if ((Path)stagingDirPath.elem == null) {
                    this.logError((Function0<String>)new Serializable(this){

                        public final String apply() {
                            return "Staging directory is null";
                        }
                    });
                    return;
                }
                this.logInfo((Function0<String>)new Serializable(this, stagingDirPath){
                    private final ObjectRef stagingDirPath$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Deleting staging directory ").append((Object)((Path)this.stagingDirPath$1.elem)).toString();
                    }
                    {
                        this.stagingDirPath$1 = stagingDirPath$1;
                    }
                });
                fs.delete((Path)stagingDirPath.elem, true);
            }
        }
        catch (IOException iOException) {
            this.logError((Function0<String>)new Serializable(this, stagingDirPath){
                private final ObjectRef stagingDirPath$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to cleanup staging dir ").append((Object)((Path)this.stagingDirPath$1.elem)).toString();
                }
                {
                    this.stagingDirPath$1 = stagingDirPath$1;
                }
            }, iOException);
        }
    }

    private SparkContext waitForSparkContextInitialized() {
        this.logInfo((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Waiting for spark context initialization";
            }
        });
        AtomicReference<SparkContext> atomicReference = this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef();
        synchronized (atomicReference) {
            IntRef count = IntRef.create((int)0);
            long waitTime = 10000L;
            int numTries = this.sparkConf().getInt("spark.yarn.applicationMaster.waitTries", 10);
            while (this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().get() == null && count.elem < numTries && !this.org$apache$spark$deploy$yarn$ApplicationMaster$$finished()) {
                this.logInfo((Function0<String>)new Serializable(this, count){
                    private final IntRef count$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Waiting for spark context initialization ... ").append((Object)BoxesRunTime.boxToInteger((int)this.count$1.elem)).toString();
                    }
                    {
                        this.count$1 = count$1;
                    }
                });
                ++count.elem;
                this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().wait(waitTime);
            }
            SparkContext sparkContext = this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef().get();
            if (sparkContext == null) {
                this.logError((Function0<String>)new Serializable(this, waitTime, numTries){
                    private final long waitTime$1;
                    private final int numTries$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("SparkContext did not initialize after waiting for %d ms. Please check earlier log output for errors. Failing the application.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((long)this.numTries$1 * this.waitTime$1))}));
                    }
                    {
                        this.waitTime$1 = waitTime$1;
                        this.numTries$1 = numTries$1;
                    }
                });
            }
            SparkContext sparkContext2 = sparkContext;
            return sparkContext2;
        }
    }

    /*
     * Exception decompiling
     */
    private ActorRef waitForSparkDriver() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 170->213)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addAmIpFilter() {
        String proxyBase = System.getenv("APPLICATION_WEB_PROXY_BASE");
        String amFilter = "org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter";
        Map<String, String> params = this.org$apache$spark$deploy$yarn$ApplicationMaster$$client.getAmIpFilterParams(this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf(), proxyBase);
        if (this.isDriver()) {
            System.setProperty("spark.ui.filters", amFilter);
            params.foreach((Function1)new Serializable(this, amFilter){
                private final String amFilter$1;

                public final String apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        String string = System.setProperty(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".param.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.amFilter$1, k})), v);
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.amFilter$1 = amFilter$1;
                }
            });
        } else {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.actor());
            CoarseGrainedClusterMessages.AddWebUIFilter x$3 = new CoarseGrainedClusterMessages.AddWebUIFilter(amFilter, params.toMap(Predef$.MODULE$.$conforms()), proxyBase);
            ActorRef x$4 = qual$1.$bang$default$2((Object)x$3);
            qual$1.$bang((Object)x$3, x$4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Thread startUserClass() {
        void var2_2;
        this.logInfo((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Starting the user JAR in a separate Thread";
            }
        });
        System.setProperty("spark.executor.instances", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numExecutors())).toString());
        Method mainMethod = Class.forName(this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userClass(), false, Thread.currentThread().getContextClassLoader()).getMethod("main", String[].class);
        Thread userThread = new Thread(this, mainMethod){
            private final /* synthetic */ ApplicationMaster $outer;
            private final Method mainMethod$1;

            public void run() {
                Throwable throwable;
                block3: {
                    try {
                        String[] mainArgs = new String[this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().size()];
                        this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().copyToArray((Object)mainArgs, 0, this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().size());
                        this.mainMethod$1.invoke(null, new Object[]{mainArgs});
                        this.$outer.finish(FinalApplicationStatus.SUCCEEDED, ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_SUCCESS(), this.$outer.finish$default$3());
                        this.$outer.logDebug((Function0<String>)new Serializable(this){

                            public final String apply() {
                                return "Done running users class";
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throwable = invocationTargetException.getCause();
                        if (!(throwable instanceof InterruptedException)) break block3;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    this.$outer.finish(FinalApplicationStatus.FAILED, ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_EXCEPTION_USER_CLASS(), new StringBuilder().append((Object)"User class threw exception: ").append((Object)throwable2.getMessage()).toString());
                    throw throwable2;
                }
                throw new MatchError((Object)throwable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mainMethod$1 = mainMethod$1;
            }
        };
        userThread.setName("Driver");
        userThread.start();
        return var2_2;
    }

    public ApplicationMaster(ApplicationMasterArguments args, YarnRMClient client) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$args = args;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$client = client;
        Logging.class.$init$((Logging)this);
        this.sparkConf = new SparkConf();
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnConf = (YarnConfiguration)SparkHadoopUtil$.MODULE$.get().newConfiguration(this.sparkConf());
        this.isDriver = args.userClass() != null;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumExecutorFailures = this.sparkConf().getInt("spark.yarn.max.executor.failures", this.sparkConf().getInt("spark.yarn.max.worker.failures", scala.math.package$.MODULE$.max(args.numExecutors() * 2, 3)));
        this.exitCode = 0;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$unregistered = false;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$finished = false;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalStatus = this.getDefaultFinalStatus();
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$finalMsg = "";
        this.actorSystem = null;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkContextRef = new AtomicReference<Object>(null);
    }

    public class AMActor
    implements Actor {
        public final String org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$driverUrl;
        private ActorSelection driver;
        public final /* synthetic */ ApplicationMaster $outer;
        private final ActorContext context;
        private final ActorRef self;

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public final ActorRef sender() {
            return Actor.class.sender((Actor)this);
        }

        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
            Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
        }

        public void aroundPreStart() {
            Actor.class.aroundPreStart((Actor)this);
        }

        public void aroundPostStop() {
            Actor.class.aroundPostStop((Actor)this);
        }

        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
        }

        public void aroundPostRestart(Throwable reason) {
            Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.class.supervisorStrategy((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.class.postStop((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.class.postRestart((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.class.unhandled((Actor)this, (Object)message);
        }

        public ActorSelection driver() {
            return this.driver;
        }

        public void driver_$eq(ActorSelection x$1) {
            this.driver = x$1;
        }

        public void preStart() {
            this.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().logInfo((Function0<String>)new Serializable(this){
                private final /* synthetic */ AMActor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Listen to driver: ").append((Object)this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$driverUrl).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.driver_$eq(this.context().actorSelection(this.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$driverUrl));
            ActorSelection$.MODULE$.toScala(this.driver()).$bang((Object)"Hello", this.self());
            ActorSelection$.MODULE$.toScala(this.driver()).$bang((Object)CoarseGrainedClusterMessages.RegisterClusterManager$.MODULE$, this.self());
            this.context().system().eventStream().subscribe(this.self(), RemotingLifecycleEvent.class);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private final /* synthetic */ AMActor $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof DisassociatedEvent) {
                        DisassociatedEvent disassociatedEvent = (DisassociatedEvent)A1;
                        this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().logInfo((Function0<String>)new Serializable(this, disassociatedEvent){
                            private final DisassociatedEvent x4$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver terminated or disconnected! Shutting down. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x4$1}));
                            }
                            {
                                this.x4$1 = x4$1;
                            }
                        });
                        this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().finish(FinalApplicationStatus.SUCCEEDED, ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$EXIT_SUCCESS(), this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().finish$default$3());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.AddWebUIFilter) {
                        CoarseGrainedClusterMessages.AddWebUIFilter addWebUIFilter = (CoarseGrainedClusterMessages.AddWebUIFilter)A1;
                        this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().logInfo((Function0<String>)new Serializable(this, addWebUIFilter){
                            private final CoarseGrainedClusterMessages.AddWebUIFilter x5$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Add WebUI Filter. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x5$1}));
                            }
                            {
                                this.x5$1 = x5$1;
                            }
                        });
                        ActorSelection$.MODULE$.toScala(this.$outer.driver()).$bang((Object)addWebUIFilter, this.$outer.self());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.RequestExecutors) {
                        CoarseGrainedClusterMessages.RequestExecutors requestExecutors = (CoarseGrainedClusterMessages.RequestExecutors)A1;
                        int requestedTotal = requestExecutors.requestedTotal();
                        this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().logInfo((Function0<String>)new Serializable(this, requestedTotal){
                            private final int requestedTotal$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver requested a total number of ", " executor(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.requestedTotal$1)}));
                            }
                            {
                                this.requestedTotal$1 = requestedTotal$1;
                            }
                        });
                        Option option = Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().org$apache$spark$deploy$yarn$ApplicationMaster$$allocator());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            YarnAllocator a = (YarnAllocator)some.x();
                            a.requestTotalExecutors(requestedTotal);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().logWarning((Function0<String>)new Serializable(this){

                                public final String apply() {
                                    return "Container allocator is not ready to request executors yet.";
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillExecutors) {
                        CoarseGrainedClusterMessages.KillExecutors killExecutors = (CoarseGrainedClusterMessages.KillExecutors)A1;
                        Seq executorIds = killExecutors.executorIds();
                        this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().logInfo((Function0<String>)new Serializable(this, executorIds){
                            private final Seq executorIds$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver requested to kill executor(s) ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorIds$1.mkString(", ")}));
                            }
                            {
                                this.executorIds$1 = executorIds$1;
                            }
                        });
                        Option option = Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().org$apache$spark$deploy$yarn$ApplicationMaster$$allocator());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            YarnAllocator a = (YarnAllocator)some.x();
                            executorIds.foreach((Function1)new Serializable(this, a){
                                private final YarnAllocator a$1;

                                public final void apply(String executorId) {
                                    this.a$1.killExecutor(executorId);
                                }
                                {
                                    this.a$1 = a$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer().logWarning((Function0<String>)new Serializable(this){

                                public final String apply() {
                                    return "Container allocator is not ready to kill executors yet.";
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof DisassociatedEvent ? true : (object instanceof CoarseGrainedClusterMessages.AddWebUIFilter ? true : (object instanceof CoarseGrainedClusterMessages.RequestExecutors ? true : object instanceof CoarseGrainedClusterMessages.KillExecutors));
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ ApplicationMaster org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$$outer() {
            return this.$outer;
        }

        public AMActor(ApplicationMaster $outer, String driverUrl) {
            this.org$apache$spark$deploy$yarn$ApplicationMaster$AMActor$$driverUrl = driverUrl;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Actor.class.$init$((Actor)this);
        }
    }
}

