/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ExecutorRunnableUtil;
import org.apache.spark.deploy.yarn.ExecutorRunnableUtil$class;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.network.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u00015\u0011\u0001#\u0012=fGV$xN\u001d*v]:\f'\r\\3\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u000191\u0012$\b\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qbF\u0005\u00031A\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u00035mi\u0011AA\u0005\u00039\t\u0011A#\u0012=fGV$xN\u001d*v]:\f'\r\\3Vi&d\u0007C\u0001\u0010 \u001b\u00051\u0011B\u0001\u0011\u0007\u0005\u001daunZ4j]\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\nG>tG/Y5oKJ\u0004\"\u0001\n\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\u000fI,7m\u001c:eg*\u0011\u0001&K\u0001\u0004CBL'BA\u0002+\u0015\tY\u0003\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003[\u0015\u0012\u0011bQ8oi\u0006Lg.\u001a:\t\u0011=\u0002!\u0011!Q\u0001\nA\nAaY8oMB\u0011\u0011gM\u0007\u0002e)\u0011qFK\u0005\u0003iI\u0012QbQ8oM&<WO]1uS>t\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\rM\u00048i\u001c8g!\tq\u0002(\u0003\u0002:\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005iQ.Y:uKJ\fE\r\u001a:fgN\u0004\"!P\"\u000f\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005~B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\bg2\fg/Z%e\u0011!I\u0005A!A!\u0002\u0013a\u0014\u0001\u00035pgRt\u0017-\\3\t\u0011-\u0003!\u0011!Q\u0001\n1\u000ba\"\u001a=fGV$xN]'f[>\u0014\u0018\u0010\u0005\u0002?\u001b&\u0011aj\u0010\u0002\u0004\u0013:$\b\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u001b\u0015DXmY;u_J\u001cuN]3t\u0011!\u0011\u0006A!A!\u0002\u0013a\u0014!B1qa&#\u0007\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\u0002\u0017M,7-\u001e:jifluM\u001d\t\u0003=YK!a\u0016\u0004\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJDQ!\u0017\u0001\u0005\u0002i\u000ba\u0001P5oSRtDcC.];z{\u0006-\u00192dI\u0016\u0004\"A\u0007\u0001\t\u000b\tB\u0006\u0019A\u0012\t\u000b=B\u0006\u0019\u0001\u0019\t\u000bYB\u0006\u0019A\u001c\t\u000bmB\u0006\u0019\u0001\u001f\t\u000b\u001dC\u0006\u0019\u0001\u001f\t\u000b%C\u0006\u0019\u0001\u001f\t\u000b-C\u0006\u0019\u0001'\t\u000bAC\u0006\u0019\u0001'\t\u000bIC\u0006\u0019\u0001\u001f\t\u000bQC\u0006\u0019A+\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\u0006\u0019!\u000f]2\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\\u0015\u0002\u0007%\u00048-\u0003\u0002oW\n9\u0011,\u0019:o%B\u001b\u0005b\u00029\u0001\u0001\u0004%\t!]\u0001\beB\u001cw\fJ3r)\t\u0011X\u000f\u0005\u0002?g&\u0011Ao\u0010\u0002\u0005+:LG\u000fC\u0004w_\u0006\u0005\t\u0019A5\u0002\u0007a$\u0013\u0007\u0003\u0004y\u0001\u0001\u0006K![\u0001\u0005eB\u001c\u0007\u0005C\u0005{\u0001\u0001\u0007\t\u0019!C\u0001w\u0006Aa.\\\"mS\u0016tG/F\u0001}!\ri\u00181A\u0007\u0002}*\u0011\u0001f \u0006\u0004\u0003\u0003I\u0013AB2mS\u0016tG/C\u0002\u0002\u0006y\u0014\u0001BT'DY&,g\u000e\u001e\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0003\tY!\u0001\u0007o[\u000ec\u0017.\u001a8u?\u0012*\u0017\u000fF\u0002s\u0003\u001bA\u0001B^A\u0004\u0003\u0003\u0005\r\u0001 \u0005\b\u0003#\u0001\u0001\u0015)\u0003}\u0003%qWn\u00117jK:$\b\u0005C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0001\u0002\u0018\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002o!9\u00111\u0004\u0001!\u0002\u00139\u0014AC:qCJ\\7i\u001c8gA!I\u0011q\u0004\u0001C\u0002\u0013\u0005\u0011\u0011E\u0001\ts\u0006\u0014hnQ8oMV\u0011\u00111\u0005\t\u0005\u0003K\tI#\u0004\u0002\u0002()\u0011q&K\u0005\u0005\u0003W\t9CA\tZCJt7i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"a\f\u0001A\u0003%\u00111E\u0001\ns\u0006\u0014hnQ8oM\u0002Bq!a\r\u0001\t\u0003\t)$A\u0002sk:$\u0012A\u001d\u0005\b\u0003s\u0001A\u0011AA\u001e\u00039\u0019H/\u0019:u\u0007>tG/Y5oKJ,\"!!\u0010\u0011\u0011\u0005}\u0012QIA%\u0003\u001bj!!!\u0011\u000b\u0007\u0005\r##\u0001\u0003vi&d\u0017\u0002BA$\u0003\u0003\u00121!T1q!\ry\u00111J\u0005\u0003\tB\u0001B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\u0012\u0012a\u00018j_&!\u0011qKA)\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d")
public class ExecutorRunnable
implements Runnable,
ExecutorRunnableUtil {
    private final Container container;
    private final String masterAddress;
    private final String slaveId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private YarnRPC rpc;
    private NMClient nmClient;
    private final SparkConf sparkConf;
    private final YarnConfiguration yarnConf;
    private final HashMap<String, String> env;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private HashMap env$lzycompute() {
        ExecutorRunnable executorRunnable = this;
        synchronized (executorRunnable) {
            if (!this.bitmap$0) {
                this.env = ExecutorRunnableUtil$class.env(this);
                this.bitmap$0 = true;
            }
            return this.env;
        }
    }

    @Override
    public HashMap<String, String> env() {
        return this.bitmap$0 ? this.env : this.env$lzycompute();
    }

    @Override
    public List<String> prepareCommand(String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId, HashMap<String, LocalResource> localResources) {
        return ExecutorRunnableUtil$class.prepareCommand(this, masterAddress, slaveId, hostname, executorMemory, executorCores, appId, localResources);
    }

    @Override
    public HashMap<String, LocalResource> prepareLocalResources() {
        return ExecutorRunnableUtil$class.prepareLocalResources(this);
    }

    @Override
    public HashMap<String, String> prepareEnvironment() {
        return ExecutorRunnableUtil$class.prepareEnvironment(this);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    @Override
    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    @Override
    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    @Override
    public void run() {
        this.logInfo((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Starting Executor Container";
            }
        });
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.yarnConf());
        this.nmClient().start();
        this.startContainer();
    }

    public java.util.Map<String, ByteBuffer> startContainer() {
        this.logInfo((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Setting up ContainerLaunchContext";
            }
        });
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        HashMap<String, LocalResource> localResources = this.prepareLocalResources();
        ctx.setLocalResources(JavaConversions$.MODULE$.mutableMapAsJavaMap(localResources));
        ctx.setEnvironment(JavaConversions$.MODULE$.mutableMapAsJavaMap(this.env()));
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand(this.masterAddress, this.slaveId, this.hostname, this.executorMemory, this.executorCores, this.appId, localResources);
        this.logInfo((Function0<String>)new Serializable(this){
            private final /* synthetic */ ExecutorRunnable $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting up executor with environment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.env()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, commands){
            private final List commands$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Setting up executor with commands: ").append((Object)this.commands$1).toString();
            }
            {
                this.commands$1 = commands$1;
            }
        });
        ctx.setCommands(JavaConversions$.MODULE$.seqAsJavaList(commands));
        ctx.setApplicationACLs(JavaConversions$.MODULE$.mapAsJavaMap(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)));
        if (this.sparkConf().getBoolean("spark.shuffle.service.enabled", false)) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString == null ? ByteBuffer.allocate(0) : JavaUtils.stringToBytes((String)secretString);
            ctx.setServiceData(JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_shuffle"), (Object)secretBytes)}))));
        }
        return this.nmClient().startContainer(this.container, ctx);
    }

    public ExecutorRunnable(Container container, Configuration conf, SparkConf spConf, String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr) {
        this.container = container;
        this.masterAddress = masterAddress;
        this.slaveId = slaveId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        Logging.class.$init$((Logging)this);
        ExecutorRunnableUtil$class.$init$(this);
        this.rpc = YarnRPC.create((Configuration)conf);
        this.sparkConf = spConf;
        this.yarnConf = new YarnConfiguration(conf);
    }
}

