/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SparkConf$;
import org.apache.spark.deploy.yarn.ClientBase$;
import org.apache.spark.deploy.yarn.ExecutorRunnableUtil;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.sys.package$;

public abstract class ExecutorRunnableUtil$class {
    public static HashMap env(ExecutorRunnableUtil $this) {
        return $this.prepareEnvironment();
    }

    public static List prepareCommand(ExecutorRunnableUtil $this, String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId, HashMap localResources) {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef prefixEnv = ObjectRef.create((Object)None$.MODULE$);
        String executorMemoryString = new StringBuilder().append(executorMemory).append((Object)"m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xms").append((Object)executorMemoryString).toString());
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)executorMemoryString).toString());
        package$.MODULE$.props().get("spark.executor.extraJavaOptions").foreach((Function1)new Serializable($this, javaOpts){
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable($this, javaOpts){
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        package$.MODULE$.props().get("spark.executor.extraLibraryPath").foreach((Function1)new Serializable($this, prefixEnv){
            private final ObjectRef prefixEnv$1;

            public final void apply(String p) {
                this.prefixEnv$1.elem = new Some((Object)Utils$.MODULE$.libraryPathEnvPrefix((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p}))));
            }
            {
                this.prefixEnv$1 = prefixEnv$1;
            }
        });
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)new Path(ApplicationConstants.Environment.PWD.$(), "./tmp")).toString());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$this.sparkConf().getAll()).filter((Function1)new Serializable($this){

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).foreach((Function1)new Serializable($this, javaOpts){
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ListBuffer listBuffer = this.javaOpts$1.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}))));
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable((Option)prefixEnv.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)ApplicationConstants.Environment.JAVA_HOME.$()).append((Object)"/bin/java").toString(), "-server", "-XX:OnOutOfMemoryError='kill %p'"})), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.CoarseGrainedExecutorBackend", masterAddress.toString(), slaveId.toString(), hostname.toString(), ((Object)BoxesRunTime.boxToInteger((int)executorCores)).toString(), appId, "1>", "<LOG_DIR>/stdout", "2>", "<LOG_DIR>/stderr"})), Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1)new Serializable($this){

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public static void org$apache$spark$deploy$yarn$ExecutorRunnableUtil$$setupDistributedCache(ExecutorRunnableUtil $this, String file, LocalResourceType rtype, HashMap localResources, String timestamp, String size, String vis) {
        URI uri = new URI(file);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(rtype);
        amJarRsrc.setVisibility(LocalResourceVisibility.valueOf((String)vis));
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromURI((URI)uri));
        amJarRsrc.setTimestamp(new StringOps(Predef$.MODULE$.augmentString(timestamp)).toLong());
        amJarRsrc.setSize(new StringOps(Predef$.MODULE$.augmentString(size)).toLong());
        localResources.update((Object)uri.getFragment(), (Object)amJarRsrc);
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap prepareLocalResources(ExecutorRunnableUtil $this) {
        void var1_1;
        $this.logInfo((Function0)new Serializable($this){

            public final String apply() {
                return "Preparing Local resources";
            }
        });
        HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (System.getenv("SPARK_YARN_CACHE_FILES") != null) {
            String[] timeStamps = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_TIME_STAMPS"))).split(',');
            String[] fileSizes = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_FILE_SIZES"))).split(',');
            String[] distFiles = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES"))).split(',');
            String[] visibilities = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_VISIBILITIES"))).split(',');
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), distFiles.length - 1).foreach$mVc$sp((Function1)new Serializable($this, localResources, timeStamps, fileSizes, distFiles, visibilities){
                private final /* synthetic */ ExecutorRunnableUtil $outer;
                private final HashMap localResources$1;
                private final String[] timeStamps$1;
                private final String[] fileSizes$1;
                private final String[] distFiles$1;
                private final String[] visibilities$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ExecutorRunnableUtil$class.org$apache$spark$deploy$yarn$ExecutorRunnableUtil$$setupDistributedCache(this.$outer, this.distFiles$1[i], LocalResourceType.FILE, this.localResources$1, this.timeStamps$1[i], this.fileSizes$1[i], this.visibilities$1[i]);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.localResources$1 = localResources$1;
                    this.timeStamps$1 = timeStamps$1;
                    this.fileSizes$1 = fileSizes$1;
                    this.distFiles$1 = distFiles$1;
                    this.visibilities$1 = visibilities$1;
                }
            });
        }
        if (System.getenv("SPARK_YARN_CACHE_ARCHIVES") != null) {
            String[] timeStamps = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_TIME_STAMPS"))).split(',');
            String[] fileSizes = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_FILE_SIZES"))).split(',');
            String[] distArchives = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES"))).split(',');
            String[] visibilities = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_VISIBILITIES"))).split(',');
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), distArchives.length - 1).foreach$mVc$sp((Function1)new Serializable($this, localResources, timeStamps, fileSizes, distArchives, visibilities){
                private final /* synthetic */ ExecutorRunnableUtil $outer;
                private final HashMap localResources$1;
                private final String[] timeStamps$2;
                private final String[] fileSizes$2;
                private final String[] distArchives$1;
                private final String[] visibilities$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    ExecutorRunnableUtil$class.org$apache$spark$deploy$yarn$ExecutorRunnableUtil$$setupDistributedCache(this.$outer, this.distArchives$1[i], LocalResourceType.ARCHIVE, this.localResources$1, this.timeStamps$2[i], this.fileSizes$2[i], this.visibilities$2[i]);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.localResources$1 = localResources$1;
                    this.timeStamps$2 = timeStamps$2;
                    this.fileSizes$2 = fileSizes$2;
                    this.distArchives$1 = distArchives$1;
                    this.visibilities$2 = visibilities$2;
                }
            });
        }
        $this.logInfo((Function0)new Serializable($this, localResources){
            private final HashMap localResources$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Prepared Local resources ").append((Object)this.localResources$1).toString();
            }
            {
                this.localResources$1 = localResources$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap prepareEnvironment(ExecutorRunnableUtil $this) {
        void var1_1;
        HashMap env = new HashMap();
        Option extraCp = $this.sparkConf().getOption("spark.executor.extraClassPath");
        ClientBase$.MODULE$.populateClasspath(null, (Configuration)$this.yarnConf(), $this.sparkConf(), (HashMap<String, String>)env, (Option<String>)extraCp);
        $this.sparkConf().getExecutorEnv().foreach((Function1)new Serializable($this, env){
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable($this, env){
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        JavaConversions$.MODULE$.mapAsScalaMap(System.getenv()).filterKeys((Function1)new Serializable($this){

            public final boolean apply(String x$1) {
                return x$1.startsWith("SPARK");
            }
        }).foreach((Function1)new Serializable($this, env){
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.env$1.update((Object)k, (Object)v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var1_1;
    }

    public static void $init$(ExecutorRunnableUtil $this) {
    }
}

