/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.spark.SecurityManager;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class YarnSparkHadoopUtil$ {
    public static final YarnSparkHadoopUtil$ MODULE$;
    private final double MEMORY_OVERHEAD_FACTOR;
    private final int MEMORY_OVERHEAD_MIN;
    private final String ANY_HOST;
    private final int DEFAULT_NUMBER_EXECUTORS;
    private final int RM_REQUEST_PRIORITY;
    private final ConcurrentHashMap<String, String> hostToRack;
    private final ConcurrentHashMap<String, Set<String>> rackToHostSet;
    private final String environmentVariableRegex;

    static {
        new YarnSparkHadoopUtil$();
    }

    public double MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    public int MEMORY_OVERHEAD_MIN() {
        return this.MEMORY_OVERHEAD_MIN;
    }

    public String ANY_HOST() {
        return this.ANY_HOST;
    }

    public int DEFAULT_NUMBER_EXECUTORS() {
        return this.DEFAULT_NUMBER_EXECUTORS;
    }

    public int RM_REQUEST_PRIORITY() {
        return this.RM_REQUEST_PRIORITY;
    }

    private ConcurrentHashMap<String, String> hostToRack() {
        return this.hostToRack;
    }

    private ConcurrentHashMap<String, Set<String>> rackToHostSet() {
        return this.rackToHostSet;
    }

    public void addPathToEnvironment(HashMap<String, String> env, String key, String value) {
        String newValue = env.contains((Object)key) ? new StringBuilder().append((Object)((String)env.apply((Object)key))).append((Object)File.pathSeparator).append((Object)value).toString() : value;
        env.put((Object)key, (Object)newValue);
    }

    public void setEnvFromInputString(HashMap<String, String> env, String inputString) {
        if (inputString != null && inputString.length() > 0) {
            String[] childEnvs = inputString.split(",");
            Pattern p = Pattern.compile(this.environmentVariableRegex());
            Predef$.MODULE$.refArrayOps((Object[])childEnvs).foreach((Function1)new Serializable(env, p){
                private final HashMap env$1;
                private final Pattern p$1;

                public final void apply(String cEnv) {
                    String[] parts = cEnv.split("=");
                    Matcher m = this.p$1.matcher(parts[1]);
                    StringBuffer sb = new StringBuffer();
                    while (m.find()) {
                        String variable = m.group(1);
                        String replace = "";
                        Option option = this.env$1.get((Object)variable);
                        None$ none$ = None$.MODULE$;
                        if (!(option != null ? !option.equals(none$) : none$ != null)) {
                            replace = System.getenv(variable);
                            if (replace == null) {
                                replace = "";
                            }
                        } else {
                            replace = (String)this.env$1.get((Object)variable).get();
                        }
                        m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                    }
                    m.appendTail(sb);
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, parts[0], sb.toString());
                }
                {
                    this.env$1 = env$1;
                    this.p$1 = p$1;
                }
            });
        }
    }

    private String environmentVariableRegex() {
        return this.environmentVariableRegex;
    }

    public String escapeForShell(String arg) {
        String string;
        if (arg == null) {
            string = arg;
        } else {
            StringBuilder escaped = new StringBuilder("'");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), arg.length() - 1).foreach((Function1)new Serializable(arg, escaped){
                private final String arg$1;
                private final StringBuilder escaped$1;

                public final StringBuilder apply(int i) {
                    StringBuilder stringBuilder;
                    char c = this.arg$1.charAt(i);
                    switch (c) {
                        default: {
                            stringBuilder = this.escaped$1.append(c);
                            break;
                        }
                        case '\'': {
                            stringBuilder = this.escaped$1.append("'\\''");
                            break;
                        }
                        case '\"': {
                            stringBuilder = this.escaped$1.append("\\\"");
                            break;
                        }
                        case '$': {
                            stringBuilder = this.escaped$1.append("\\$");
                        }
                    }
                    return stringBuilder;
                }
                {
                    this.arg$1 = arg$1;
                    this.escaped$1 = escaped$1;
                }
            });
            string = escaped.append("'").toString();
        }
        return string;
    }

    public String lookupRack(Configuration conf, String host) {
        if (!this.hostToRack().contains(host)) {
            this.populateRackInfo(conf, host);
        }
        return this.hostToRack().get(host);
    }

    public void populateRackInfo(Configuration conf, String hostname) {
        Node rackInfo;
        Utils$.MODULE$.checkHost(hostname, Utils$.MODULE$.checkHost$default$2());
        if (!this.hostToRack().containsKey(hostname) && (rackInfo = RackResolver.resolve((Configuration)conf, (String)hostname)) != null && rackInfo.getNetworkLocation() != null) {
            String rack = rackInfo.getNetworkLocation();
            this.hostToRack().put(hostname, rack);
            Object object = this.rackToHostSet().containsKey(rack) ? BoxedUnit.UNIT : this.rackToHostSet().putIfAbsent(rack, Collections.newSetFromMap(new ConcurrentHashMap()));
            this.rackToHostSet().get(rack).add(hostname);
        }
    }

    public Map<ApplicationAccessType, String> getApplicationAclsForYarn(SecurityManager securityMgr) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)securityMgr.getViewAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)securityMgr.getModifyAcls())}));
    }

    private YarnSparkHadoopUtil$() {
        MODULE$ = this;
        this.MEMORY_OVERHEAD_FACTOR = 0.07;
        this.MEMORY_OVERHEAD_MIN = 384;
        this.ANY_HOST = "*";
        this.DEFAULT_NUMBER_EXECUTORS = 2;
        this.RM_REQUEST_PRIORITY = 1;
        this.hostToRack = new ConcurrentHashMap();
        this.rackToHostSet = new ConcurrentHashMap();
        this.environmentVariableRegex = Utils$.MODULE$.isWindows() ? "%([A-Za-z_][A-Za-z0-9_]*?)%" : "\\$([A-Za-z_][A-Za-z0-9_]*)";
    }
}

