/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md!B\u0001\u0003\u0001\u0019a!!H\"mS\u0016tG\u000fR5tiJL'-\u001e;fI\u000e\u000b7\r[3NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000b\u000e\u0003\u0019I!A\u0006\u0004\u0003\u000f1{wmZ5oO\")\u0001\u0004\u0001C\u00015\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\n}\ta\u0002Z5ti\u000e\u000b7\r[3GS2,7/F\u0001!!\u0011\tc\u0005K\u0018\u000e\u0003\tR!a\t\u0013\u0002\u000f5,H/\u00192mK*\u0011QeD\u0001\u000bG>dG.Z2uS>t\u0017BA\u0014#\u0005\ri\u0015\r\u001d\t\u0003S1r!A\u0004\u0016\n\u0005-z\u0011A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!aK\b\u0011\u000b9\u0001\u0004\u0006\u000b\u0015\n\u0005Ez!A\u0002+va2,7\u0007\u0003\u00044\u0001\u0001\u0006I\u0001I\u0001\u0010I&\u001cHoQ1dQ\u00164\u0015\u000e\\3tA!9Q\u0007\u0001b\u0001\n\u0013y\u0012!\u00053jgR\u001c\u0015m\u00195f\u0003J\u001c\u0007.\u001b<fg\"1q\u0007\u0001Q\u0001\n\u0001\n!\u0003Z5ti\u000e\u000b7\r[3Be\u000eD\u0017N^3tA!)\u0011\b\u0001C\u0001u\u0005Y\u0011\r\u001a3SKN|WO]2f)%Ydh\u0012(TC\u001aDg\u000f\u0005\u0002\u000fy%\u0011Qh\u0004\u0002\u0005+:LG\u000fC\u0003@q\u0001\u0007\u0001)\u0001\u0002ggB\u0011\u0011)R\u0007\u0002\u0005*\u0011qh\u0011\u0006\u0003\t\"\ta\u0001[1e_>\u0004\u0018B\u0001$C\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\u0006\u0011b\u0002\r!S\u0001\u0005G>tg\r\u0005\u0002K\u00196\t1J\u0003\u0002I\u0007&\u0011Qj\u0013\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b=C\u0004\u0019\u0001)\u0002\u0011\u0011,7\u000f\u001e)bi\"\u0004\"!Q)\n\u0005I\u0013%\u0001\u0002)bi\"DQ\u0001\u0016\u001dA\u0002U\u000ba\u0002\\8dC2\u0014Vm]8ve\u000e,7\u000f\u0005\u0003\"-\"B\u0016BA,#\u0005\u001dA\u0015m\u001d5NCB\u0004\"!W0\u000e\u0003iS!a\u0017/\u0002\u000fI,7m\u001c:eg*\u0011QLX\u0001\u0004CBL'BA\u0002D\u0013\t\u0001'LA\u0007M_\u000e\fGNU3t_V\u00148-\u001a\u0005\u0006Eb\u0002\raY\u0001\re\u0016\u001cx.\u001e:dKRK\b/\u001a\t\u00033\u0012L!!\u001a.\u0003#1{7-\u00197SKN|WO]2f)f\u0004X\rC\u0003hq\u0001\u0007\u0001&\u0001\u0003mS:\\\u0007\"B59\u0001\u0004Q\u0017!C:uCR\u001c\u0015m\u00195f!\u0011\tce[:\u0011\u00051\fX\"A7\u000b\u00059|\u0017a\u00018fi*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\r)&+\u0013\t\u0003\u0003RL!!\u001e\"\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0004xqA\u0005\t\u0019\u0001=\u0002\u001b\u0005\u0004\b/T1ti\u0016\u0014xJ\u001c7z!\tq\u00110\u0003\u0002{\u001f\t9!i\\8mK\u0006t\u0007\"\u0002?\u0001\t\u0003i\u0018aD:fi\u0012K7\u000f\u001e$jY\u0016\u001cXI\u001c<\u0015\u0005mr\bBB@|\u0001\u0004\t\t!A\u0002f]Z\u0004B!\t\u0014)Q!9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0011AE:fi\u0012K7\u000f^!sG\"Lg/Z:F]Z$2aOA\u0005\u0011\u001dy\u00181\u0001a\u0001\u0003\u0003Aq!!\u0004\u0001\t\u0003\ty!A\u0007hKR4\u0016n]5cS2LG/\u001f\u000b\t\u0003#\t9\"!\u0007\u0002\u001eA\u0019\u0011,a\u0005\n\u0007\u0005U!LA\fM_\u000e\fGNU3t_V\u00148-\u001a,jg&\u0014\u0017\u000e\\5us\"1\u0001*a\u0003A\u0002%Cq!a\u0007\u0002\f\u0001\u00071.A\u0002ve&Da![A\u0006\u0001\u0004Q\u0007bBA\u0011\u0001\u0011\u0005\u00111E\u0001\tSN\u0004VO\u00197jGR9\u00010!\n\u0002(\u0005%\u0002B\u0002%\u0002 \u0001\u0007\u0011\nC\u0004\u0002\u001c\u0005}\u0001\u0019A6\t\r%\fy\u00021\u0001k\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\tq$\u00198dKN$xN]:ICZ,W\t_3dkR,\u0007+\u001a:nSN\u001c\u0018n\u001c8t)\u001dA\u0018\u0011GA\u001a\u0003oAaaPA\u0016\u0001\u0004\u0001\u0005bBA\u001b\u0003W\u0001\r\u0001U\u0001\u0005a\u0006$\b\u000e\u0003\u0004j\u0003W\u0001\rA\u001b\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003Y\u0019\u0007.Z2l!\u0016\u0014X.[:tS>twJZ(uQ\u0016\u0014H#\u0003=\u0002@\u0005\u0005\u00131IA*\u0011\u0019y\u0014\u0011\ba\u0001\u0001\"9\u0011QGA\u001d\u0001\u0004\u0001\u0006\u0002CA#\u0003s\u0001\r!a\u0012\u0002\r\u0005\u001cG/[8o!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'\u0005\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\n\t\u0005E\u00131\n\u0002\t\rN\f5\r^5p]\"1\u0011.!\u000fA\u0002)Dq!a\u0016\u0001\t\u0003\tI&A\u0007hKR4\u0015\u000e\\3Ti\u0006$Xo\u001d\u000b\bg\u0006m\u0013QLA0\u0011\u0019y\u0014Q\u000ba\u0001\u0001\"9\u00111DA+\u0001\u0004Y\u0007BB5\u0002V\u0001\u0007!\u000eC\u0005\u0002d\u0001\t\n\u0011\"\u0001\u0002f\u0005)\u0012\r\u001a3SKN|WO]2fI\u0011,g-Y;mi\u0012BTCAA4U\rA\u0018\u0011N\u0016\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0005v]\u000eDWmY6fI*\u0019\u0011QO\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0005=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ClientDistributedCacheManager
implements Logging {
    private final Map<String, Tuple3<String, String, String>> distCacheFiles;
    private final Map<String, Tuple3<String, String, String>> distCacheArchives;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private Map<String, Tuple3<String, String, String>> distCacheFiles() {
        return this.distCacheFiles;
    }

    private Map<String, Tuple3<String, String, String>> distCacheArchives() {
        return this.distCacheArchives;
    }

    public void addResource(FileSystem fs, Configuration conf, Path destPath, HashMap<String, LocalResource> localResources, LocalResourceType resourceType, String link, Map<URI, FileStatus> statCache, boolean appMasterOnly) {
        FileStatus destStatus = fs.getFileStatus(destPath);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(resourceType);
        LocalResourceVisibility visibility = this.getVisibility(conf, destPath.toUri(), statCache);
        amJarRsrc.setVisibility(visibility);
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)destPath));
        amJarRsrc.setTimestamp(destStatus.getModificationTime());
        amJarRsrc.setSize(destStatus.getLen());
        if (link == null || link.isEmpty()) {
            throw new Exception("You must specify a valid link name");
        }
        localResources.update((Object)link, (Object)amJarRsrc);
        if (!appMasterOnly) {
            URI uri = destPath.toUri();
            URI pathURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, link);
            LocalResourceType localResourceType = resourceType;
            LocalResourceType localResourceType2 = LocalResourceType.FILE;
            if (!(localResourceType != null ? !localResourceType.equals(localResourceType2) : localResourceType2 != null)) {
                this.distCacheFiles().update((Object)pathURI.toString(), (Object)new Tuple3((Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getLen())).toString(), (Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getModificationTime())).toString(), (Object)visibility.name()));
            } else {
                this.distCacheArchives().update((Object)pathURI.toString(), (Object)new Tuple3((Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getLen())).toString(), (Object)((Object)BoxesRunTime.boxToLong((long)destStatus.getModificationTime())).toString(), (Object)visibility.name()));
            }
        }
    }

    public boolean addResource$default$8() {
        return false;
    }

    public void setDistFilesEnv(Map<String, String> env) {
        Tuple2 tuple2 = this.distCacheFiles().unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable keys = (Iterable)tuple2._1();
            Iterable tupleValues = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys, (Object)tupleValues);
            Iterable keys2 = (Iterable)tuple23._1();
            Iterable tupleValues2 = (Iterable)tuple23._2();
            Tuple3 tuple3 = tupleValues2.unzip3((Function1)Predef$.MODULE$.$conforms());
            if (tuple3 != null) {
                Tuple3 tuple32;
                Iterable sizes = (Iterable)tuple3._1();
                Iterable timeStamps = (Iterable)tuple3._2();
                Iterable visibilities = (Iterable)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)sizes, (Object)timeStamps, (Object)visibilities);
                Iterable sizes2 = (Iterable)tuple33._1();
                Iterable timeStamps2 = (Iterable)tuple33._2();
                Iterable visibilities2 = (Iterable)tuple33._3();
                if (keys2.size() > 0) {
                    env.update((Object)"SPARK_YARN_CACHE_FILES", keys2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_FILES_TIME_STAMPS", timeStamps2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_FILES_FILE_SIZES", sizes2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_FILES_VISIBILITIES", visibilities2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    public void setDistArchivesEnv(Map<String, String> env) {
        Tuple2 tuple2 = this.distCacheArchives().unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable keys = (Iterable)tuple2._1();
            Iterable tupleValues = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys, (Object)tupleValues);
            Iterable keys2 = (Iterable)tuple23._1();
            Iterable tupleValues2 = (Iterable)tuple23._2();
            Tuple3 tuple3 = tupleValues2.unzip3((Function1)Predef$.MODULE$.$conforms());
            if (tuple3 != null) {
                Tuple3 tuple32;
                Iterable sizes = (Iterable)tuple3._1();
                Iterable timeStamps = (Iterable)tuple3._2();
                Iterable visibilities = (Iterable)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)sizes, (Object)timeStamps, (Object)visibilities);
                Iterable sizes2 = (Iterable)tuple33._1();
                Iterable timeStamps2 = (Iterable)tuple33._2();
                Iterable visibilities2 = (Iterable)tuple33._3();
                if (keys2.size() > 0) {
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES", keys2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES_TIME_STAMPS", timeStamps2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES_FILE_SIZES", sizes2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                    env.update((Object)"SPARK_YARN_CACHE_ARCHIVES_VISIBILITIES", visibilities2.reduceLeft((Function2)new Serializable(this){

                        public final String apply(String acc, String n) {
                            return new StringBuilder().append((Object)acc).append((Object)",").append((Object)n).toString();
                        }
                    }));
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    public LocalResourceVisibility getVisibility(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        return this.isPublic(conf, uri, statCache) ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE;
    }

    public boolean isPublic(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        Path current;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (this.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ, statCache)) {
            return this.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
        }
        return false;
    }

    public boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, Map<URI, FileStatus> statCache) {
        Path current = path;
        while (true) {
            Path path2;
            if (current == null) {
                return true;
            }
            if (!this.checkPermissionOfOther(fs, path2, FsAction.EXECUTE, statCache)) break;
            path2 = path2.getParent();
        }
        return false;
    }

    public boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, Map<URI, FileStatus> statCache) {
        FileStatus status = this.getFileStatus(fs, path.toUri(), statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    public FileStatus getFileStatus(FileSystem fs, URI uri, Map<URI, FileStatus> statCache) {
        Option option;
        block4: {
            FileStatus fileStatus;
            block3: {
                block2: {
                    FileStatus existstat;
                    option = statCache.get((Object)uri);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    fileStatus = existstat = (FileStatus)some.x();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                FileStatus newStat = fs.getFileStatus(new Path(uri));
                statCache.put((Object)uri, (Object)newStat);
                fileStatus = newStat;
            }
            FileStatus stat = fileStatus;
            return stat;
        }
        throw new MatchError((Object)option);
    }

    public ClientDistributedCacheManager() {
        Logging.class.$init$((Logging)this);
        this.distCacheFiles = (Map)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.distCacheArchives = (Map)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

