/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.slf4j.Logger;
import org.spark-project.guava.base.Objects;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Client$
implements Logging {
    public static final Client$ MODULE$;
    private final String SPARK_JAR;
    private final String APP_JAR;
    private final String LOCAL_SCHEME;
    private final String SPARK_STAGING;
    private final String CONF_SPARK_JAR;
    private final String ENV_SPARK_JAR;
    private final String CONF_SPARK_USER_JAR;
    private final String CONF_SPARK_YARN_SECONDARY_JARS;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final FsPermission APP_FILE_PERMISSION;
    private final String ENV_DIST_CLASSPATH;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new Client$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void main(String[] argStrings) {
        if (!package$.MODULE$.props().contains("SPARK_SUBMIT")) {
            Predef$.MODULE$.println((Object)"WARNING: This client is deprecated and will be removed in a future version of Spark. Use ./bin/spark-submit with \"--master yarn\"");
        }
        System.setProperty("SPARK_YARN_MODE", "true");
        SparkConf sparkConf = new SparkConf();
        ClientArguments args = new ClientArguments(argStrings, sparkConf);
        new Client(args, sparkConf).run();
    }

    public String SPARK_JAR() {
        return this.SPARK_JAR;
    }

    public String APP_JAR() {
        return this.APP_JAR;
    }

    public String LOCAL_SCHEME() {
        return this.LOCAL_SCHEME;
    }

    public String SPARK_STAGING() {
        return this.SPARK_STAGING;
    }

    public String CONF_SPARK_JAR() {
        return this.CONF_SPARK_JAR;
    }

    public String ENV_SPARK_JAR() {
        return this.ENV_SPARK_JAR;
    }

    public String CONF_SPARK_USER_JAR() {
        return this.CONF_SPARK_USER_JAR;
    }

    public String CONF_SPARK_YARN_SECONDARY_JARS() {
        return this.CONF_SPARK_YARN_SECONDARY_JARS;
    }

    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    public FsPermission APP_FILE_PERMISSION() {
        return this.APP_FILE_PERMISSION;
    }

    public String ENV_DIST_CLASSPATH() {
        return this.ENV_DIST_CLASSPATH;
    }

    public String org$apache$spark$deploy$yarn$Client$$sparkJar(SparkConf conf) {
        String string;
        if (conf.contains(this.CONF_SPARK_JAR())) {
            string = conf.get(this.CONF_SPARK_JAR());
        } else if (System.getenv(this.ENV_SPARK_JAR()) == null) {
            string = (String)Option$.MODULE$.option2Iterable(SparkContext$.MODULE$.jarOfClass(this.getClass())).head();
        } else {
            this.logWarning((Function0<String>)new Serializable(){

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " detected in the system environment. This variable has been deprecated "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Client$.MODULE$.ENV_SPARK_JAR()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in favor of the ", " configuration variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Client$.MODULE$.CONF_SPARK_JAR()}))).toString();
                }
            });
            string = System.getenv(this.ENV_SPARK_JAR());
        }
        return string;
    }

    public String org$apache$spark$deploy$yarn$Client$$getAppStagingDir(ApplicationId appId) {
        return this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SPARK_STAGING(), appId.toString()}));
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        Iterable classPathElementsToAdd = (Iterable)Option$.MODULE$.option2Iterable(this.getYarnAppClasspath(conf)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.getMRAppClasspath(conf)), Iterable$.MODULE$.canBuildFrom());
        ((IterableLike)classPathElementsToAdd.flatten((Function1)Predef$.MODULE$.$conforms())).foreach((Function1)new Serializable(env){
            private final HashMap env$3;

            public final void apply(String c) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$3, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
            }
            {
                this.env$3 = env$3;
            }
        });
    }

    private Option<Seq<String>> getYarnAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                some = this.getDefaultYarnApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    private Option<Seq<String>> getMRAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                some = this.getDefaultMRApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public Option<Seq<String>> getDefaultYarnApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){

                        public final Seq<String> apply() {
                            Field field = YarnConfiguration.class.getField("DEFAULT_YARN_APPLICATION_CLASSPATH");
                            String[] value = (String[])field.get(null);
                            return Predef$.MODULE$.refArrayOps((Object[])value).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){

                        public final String apply() {
                            return "Unable to obtain the default YARN Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    private final Success x3$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default YARN application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$1.get()).mkString(",")}));
                    }
                    {
                        this.x3$1 = x3$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public Option<Seq<String>> getDefaultMRApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){

                        public final Seq<String> apply() {
                            Field field = MRJobConfig.class.getField("DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH");
                            Class<?> clazz = field.getType();
                            Class<String> clazz2 = String.class;
                            String[] value = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? (String[])Predef$.MODULE$.refArrayOps((Object[])StringUtils.getStrings((String)((String)field.get(null)))).toArray(ClassTag$.MODULE$.apply(String.class)) : (String[])field.get(null);
                            return Predef$.MODULE$.refArrayOps((Object[])value).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x2);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){

                        public final String apply() {
                            return "Unable to obtain the default MR Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    private final Success x3$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default MR application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$2.get()).mkString(",")}));
                    }
                    {
                        this.x3$2 = x3$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public void populateClasspath(ClientArguments args, Configuration conf, SparkConf sparkConf, HashMap<String, String> env, Option<String> extraClassPath) {
        extraClassPath.foreach((Function1)new Serializable(env){
            private final HashMap env$2;

            public final void apply(String x$7) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(x$7, (HashMap<String, String>)this.env$2);
            }
            {
                this.env$2 = env$2;
            }
        });
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), env);
        if (sparkConf.getBoolean("spark.yarn.user.classpath.first", false)) {
            URI[] userClassPath = args == null ? this.getUserClasspath(sparkConf) : this.getUserClasspath((Option<String>)Option$.MODULE$.apply((Object)args.userJar()), (Option<String>)Option$.MODULE$.apply((Object)args.addJars()));
            Predef$.MODULE$.refArrayOps((Object[])userClassPath).foreach((Function1)new Serializable(env){
                private final HashMap env$2;

                public final void apply(URI x) {
                    Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(x, null, (HashMap<String, String>)this.env$2);
                }
                {
                    this.env$2 = env$2;
                }
            });
        }
        this.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(new URI(this.org$apache$spark$deploy$yarn$Client$$sparkJar(sparkConf)), this.SPARK_JAR(), env);
        this.populateHadoopClasspath(conf, env);
        package$.MODULE$.env().get((Object)this.ENV_DIST_CLASSPATH()).foreach((Function1)new Serializable(env){
            private final HashMap env$2;

            public final void apply(String x$8) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(x$8, (HashMap<String, String>)this.env$2);
            }
            {
                this.env$2 = env$2;
            }
        });
    }

    public Option<String> populateClasspath$default$5() {
        return None$.MODULE$;
    }

    public URI[] getUserClasspath(SparkConf conf) {
        return this.getUserClasspath((Option<String>)conf.getOption(this.CONF_SPARK_USER_JAR()), (Option<String>)conf.getOption(this.CONF_SPARK_YARN_SECONDARY_JARS()));
    }

    private URI[] getUserClasspath(Option<String> mainJar, Option<String> secondaryJars) {
        Option mainUri = mainJar.orElse((Function0)new Serializable(){

            public final Some<String> apply() {
                return new Some((Object)Client$.MODULE$.APP_JAR());
            }
        }).map((Function1)new Serializable(){

            public final URI apply(String x$9) {
                return new URI(x$9);
            }
        });
        Seq secondaryUris = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(secondaryJars.map((Function1)new Serializable(){

            public final String[] apply(String x$10) {
                return x$10.split(",");
            }
        })).toSeq().flatten((Function1)new Serializable(){

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        })).map((Function1)new Serializable(){

            public final URI apply(String x$11) {
                return new URI(x$11);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (URI[])((TraversableOnce)Option$.MODULE$.option2Iterable(mainUri).$plus$plus((GenTraversableOnce)secondaryUris, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URI.class));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void org$apache$spark$deploy$yarn$Client$$addFileToClasspath(URI uri, String fileName, HashMap<String, String> env) {
        if (uri != null) {
            String string = uri.getScheme();
            String string2 = this.LOCAL_SCHEME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(uri.getPath(), env);
                return;
            }
        }
        if (fileName == null) return;
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), fileName})), env);
    }

    public void org$apache$spark$deploy$yarn$Client$$addClasspathEntry(String path, HashMap<String, String> env) {
        YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path);
    }

    public Set<Path> getNameNodesToAccess(SparkConf sparkConf) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sparkConf.get("spark.yarn.access.namenodes", "").split(",")).map((Function1)new Serializable(){

            public final String apply(String x$12) {
                return x$12.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){

            public final boolean apply(String x$13) {
                return !x$13.isEmpty();
            }
        })).map((Function1)new Serializable(){

            public final Path apply(String x$14) {
                return new Path(x$14);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public String getTokenRenewer(Configuration conf) {
        void var2_2;
        String delegTokenRenewer = Master.getMasterPrincipal((Configuration)conf);
        this.logDebug((Function0<String>)new Serializable(delegTokenRenewer){
            private final String delegTokenRenewer$1;

            public final String apply() {
                return new StringBuilder().append((Object)"delegation token renewer is: ").append((Object)this.delegTokenRenewer$1).toString();
            }
            {
                this.delegTokenRenewer$1 = delegTokenRenewer$1;
            }
        });
        if (delegTokenRenewer == null || delegTokenRenewer.length() == 0) {
            String errorMessage = "Can't get Master Kerberos principal for use as renewer";
            this.logError((Function0<String>)new Serializable(errorMessage){
                private final String errorMessage$1;

                public final String apply() {
                    return this.errorMessage$1;
                }
                {
                    this.errorMessage$1 = errorMessage$1;
                }
            });
            throw new SparkException(errorMessage);
        }
        return var2_2;
    }

    public void org$apache$spark$deploy$yarn$Client$$obtainTokensForNamenodes(Set<Path> paths, Configuration conf, Credentials creds) {
        if (UserGroupInformation.isSecurityEnabled()) {
            String delegTokenRenewer = this.getTokenRenewer(conf);
            paths.foreach((Function1)new Serializable(conf, creds, delegTokenRenewer){
                private final Configuration conf$1;
                private final Credentials creds$1;
                private final String delegTokenRenewer$2;

                public final Token<?>[] apply(Path dst) {
                    FileSystem dstFs = dst.getFileSystem(this.conf$1);
                    Client$.MODULE$.logDebug((Function0<String>)new Serializable(this, dst){
                        private final Path dst$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"getting token for namenode: ").append((Object)this.dst$2).toString();
                        }
                        {
                            this.dst$2 = dst$2;
                        }
                    });
                    return dstFs.addDelegationTokens(this.delegTokenRenewer$2, this.creds$1);
                }
                {
                    this.conf$1 = conf$1;
                    this.creds$1 = creds$1;
                    this.delegTokenRenewer$2 = delegTokenRenewer$2;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean org$apache$spark$deploy$yarn$Client$$compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) return false;
        String string = srcUri.getScheme();
        String string2 = dstUri.getScheme();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            String string3 = srcHost;
            String string4 = dstHost;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                try {
                    srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                    dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }
        }
        if (!Objects.equal((Object)srcHost, (Object)dstHost)) return false;
        if (srcUri.getPort() != dstUri.getPort()) return false;
        return true;
    }

    public Path org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(URI localURI, Configuration hadoopConf) {
        URI qualifiedURI = localURI.getScheme() == null ? new URI(FileSystem.getLocal((Configuration)hadoopConf).makeQualified(new Path(localURI)).toString()) : localURI;
        return new Path(qualifiedURI);
    }

    public boolean isUserClassPathFirst(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getBoolean("spark.driver.userClassPathFirst", false) : conf.getBoolean("spark.executor.userClassPathFirst", conf.getBoolean("spark.files.userClassPathFirst", false));
    }

    public String buildPath(Seq<String> components) {
        return components.mkString("/");
    }

    private Client$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.SPARK_JAR = "__spark__.jar";
        this.APP_JAR = "__app__.jar";
        this.LOCAL_SCHEME = "local";
        this.SPARK_STAGING = ".sparkStaging";
        this.CONF_SPARK_JAR = "spark.yarn.jar";
        this.ENV_SPARK_JAR = "SPARK_JAR";
        this.CONF_SPARK_USER_JAR = "spark.yarn.user.jar";
        this.CONF_SPARK_YARN_SECONDARY_JARS = "spark.yarn.secondary.jars";
        this.STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8)));
        this.APP_FILE_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8)));
        this.ENV_DIST_CLASSPATH = "SPARK_DIST_CLASSPATH";
    }
}

