/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.slf4j.Logger;
import org.spark-project.guava.base.Objects;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Client$
implements Logging {
    public static final Client$ MODULE$;
    private final String SPARK_JAR;
    private final String APP_JAR;
    private final String LOCAL_SCHEME;
    private final String SPARK_STAGING;
    private final String CONF_SPARK_JAR;
    private final String ENV_SPARK_JAR;
    private final String CONF_SPARK_USER_JAR;
    private final String CONF_SPARK_YARN_SECONDARY_JARS;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final FsPermission APP_FILE_PERMISSION;
    private final String ENV_DIST_CLASSPATH;
    private final String LOCALIZED_HADOOP_CONF_DIR;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new Client$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void main(String[] argStrings) {
        if (!scala.sys.package$.MODULE$.props().contains("SPARK_SUBMIT")) {
            Predef$.MODULE$.println((Object)"WARNING: This client is deprecated and will be removed in a future version of Spark. Use ./bin/spark-submit with \"--master yarn\"");
        }
        System.setProperty("SPARK_YARN_MODE", "true");
        SparkConf sparkConf = new SparkConf();
        ClientArguments args = new ClientArguments(argStrings, sparkConf);
        new Client(args, sparkConf).run();
    }

    public String SPARK_JAR() {
        return this.SPARK_JAR;
    }

    public String APP_JAR() {
        return this.APP_JAR;
    }

    public String LOCAL_SCHEME() {
        return this.LOCAL_SCHEME;
    }

    public String SPARK_STAGING() {
        return this.SPARK_STAGING;
    }

    public String CONF_SPARK_JAR() {
        return this.CONF_SPARK_JAR;
    }

    public String ENV_SPARK_JAR() {
        return this.ENV_SPARK_JAR;
    }

    public String CONF_SPARK_USER_JAR() {
        return this.CONF_SPARK_USER_JAR;
    }

    public String CONF_SPARK_YARN_SECONDARY_JARS() {
        return this.CONF_SPARK_YARN_SECONDARY_JARS;
    }

    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    public FsPermission APP_FILE_PERMISSION() {
        return this.APP_FILE_PERMISSION;
    }

    public String ENV_DIST_CLASSPATH() {
        return this.ENV_DIST_CLASSPATH;
    }

    public String LOCALIZED_HADOOP_CONF_DIR() {
        return this.LOCALIZED_HADOOP_CONF_DIR;
    }

    public String org$apache$spark$deploy$yarn$Client$$sparkJar(SparkConf conf) {
        String string;
        if (conf.contains(this.CONF_SPARK_JAR())) {
            string = conf.get(this.CONF_SPARK_JAR());
        } else if (System.getenv(this.ENV_SPARK_JAR()) == null) {
            string = (String)Option$.MODULE$.option2Iterable(SparkContext$.MODULE$.jarOfClass(this.getClass())).head();
        } else {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " detected in the system environment. This variable has been deprecated "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Client$.MODULE$.ENV_SPARK_JAR()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in favor of the ", " configuration variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Client$.MODULE$.CONF_SPARK_JAR()}))).toString();
                }
            });
            string = System.getenv(this.ENV_SPARK_JAR());
        }
        return string;
    }

    public String org$apache$spark$deploy$yarn$Client$$getAppStagingDir(ApplicationId appId) {
        return this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SPARK_STAGING(), appId.toString()}));
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        Iterable classPathElementsToAdd = (Iterable)Option$.MODULE$.option2Iterable(this.getYarnAppClasspath(conf)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.getMRAppClasspath(conf)), Iterable$.MODULE$.canBuildFrom());
        ((IterableLike)classPathElementsToAdd.flatten((Function1)Predef$.MODULE$.$conforms())).foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$3;

            public final void apply(String c) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$3, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
            }
            {
                this.env$3 = env$3;
            }
        });
    }

    private Option<Seq<String>> getYarnAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                some = this.getDefaultYarnApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    private Option<Seq<String>> getMRAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                some = this.getDefaultMRApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public Option<Seq<String>> getDefaultYarnApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<String> apply() {
                            Field field = YarnConfiguration.class.getField("DEFAULT_YARN_APPLICATION_CLASSPATH");
                            String[] value = (String[])field.get(null);
                            return Predef$.MODULE$.refArrayOps((Object[])value).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unable to obtain the default YARN Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    public static final long serialVersionUID = 0L;
                    private final Success x3$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default YARN application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$1.get()).mkString(",")}));
                    }
                    {
                        this.x3$1 = x3$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public Option<Seq<String>> getDefaultMRApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<String> apply() {
                            Field field = MRJobConfig.class.getField("DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH");
                            Class<?> clazz = field.getType();
                            Class<String> clazz2 = String.class;
                            String[] value = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? (String[])Predef$.MODULE$.refArrayOps((Object[])StringUtils.getStrings((String)((String)field.get(null)))).toArray(ClassTag$.MODULE$.apply(String.class)) : (String[])field.get(null);
                            return Predef$.MODULE$.refArrayOps((Object[])value).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x2);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unable to obtain the default MR Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    public static final long serialVersionUID = 0L;
                    private final Success x3$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default MR application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$2.get()).mkString(",")}));
                    }
                    {
                        this.x3$2 = x3$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public void populateClasspath(ClientArguments args, Configuration conf, SparkConf sparkConf, HashMap<String, String> env, boolean isAM, Option<String> extraClassPath) {
        extraClassPath.foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$2;

            public final void apply(String x$8) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(x$8, (HashMap<String, String>)this.env$2);
            }
            {
                this.env$2 = env$2;
            }
        });
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), env);
        if (isAM) {
            this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(new StringBuilder().append((Object)YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD)).append((Object)"/").append((Object)this.LOCALIZED_HADOOP_CONF_DIR()).toString(), env);
        }
        if (sparkConf.getBoolean("spark.yarn.user.classpath.first", false)) {
            URI[] userClassPath = args == null ? this.getUserClasspath(sparkConf) : this.getUserClasspath((Option<String>)Option$.MODULE$.apply((Object)args.userJar()), (Option<String>)Option$.MODULE$.apply((Object)args.addJars()));
            Predef$.MODULE$.refArrayOps((Object[])userClassPath).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final HashMap env$2;

                public final void apply(URI x) {
                    Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(x, null, (HashMap<String, String>)this.env$2);
                }
                {
                    this.env$2 = env$2;
                }
            });
        }
        this.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(new URI(this.org$apache$spark$deploy$yarn$Client$$sparkJar(sparkConf)), this.SPARK_JAR(), env);
        this.populateHadoopClasspath(conf, env);
        scala.sys.package$.MODULE$.env().get((Object)this.ENV_DIST_CLASSPATH()).foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$2;

            public final void apply(String x$9) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(x$9, (HashMap<String, String>)this.env$2);
            }
            {
                this.env$2 = env$2;
            }
        });
    }

    public Option<String> populateClasspath$default$6() {
        return None$.MODULE$;
    }

    public URI[] getUserClasspath(SparkConf conf) {
        return this.getUserClasspath((Option<String>)conf.getOption(this.CONF_SPARK_USER_JAR()), (Option<String>)conf.getOption(this.CONF_SPARK_YARN_SECONDARY_JARS()));
    }

    private URI[] getUserClasspath(Option<String> mainJar, Option<String> secondaryJars) {
        Option mainUri = mainJar.orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<String> apply() {
                return new Some((Object)Client$.MODULE$.APP_JAR());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String x$10) {
                return new URI(x$10);
            }
        });
        Seq secondaryUris = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(secondaryJars.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$11) {
                return x$11.split(",");
            }
        })).toSeq().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String x$12) {
                return new URI(x$12);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (URI[])((TraversableOnce)Option$.MODULE$.option2Iterable(mainUri).$plus$plus((GenTraversableOnce)secondaryUris, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URI.class));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void org$apache$spark$deploy$yarn$Client$$addFileToClasspath(URI uri, String fileName, HashMap<String, String> env) {
        if (uri != null) {
            String string = uri.getScheme();
            String string2 = this.LOCAL_SCHEME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(uri.getPath(), env);
                return;
            }
        }
        if (fileName == null) return;
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), fileName})), env);
    }

    public void org$apache$spark$deploy$yarn$Client$$addClasspathEntry(String path, HashMap<String, String> env) {
        YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void org$apache$spark$deploy$yarn$Client$$obtainTokenForHiveMetastore(Configuration conf, Credentials credentials) {
        if (!UserGroupInformation.isSecurityEnabled()) return;
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        try {
            block6: {
                Option username;
                Option principal;
                Object hive;
                Class<?> hiveClass;
                block8: {
                    block7: {
                        Option metastore_uri;
                        hiveClass = mirror.classLoader().loadClass("org.apache.hadoop.hive.ql.metadata.Hive");
                        hive = hiveClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                        Object hiveConf = hiveClass.getMethod("getConf", new Class[0]).invoke(hive, new Object[0]);
                        Class<?> hiveConfClass = mirror.classLoader().loadClass("org.apache.hadoop.hive.conf.HiveConf");
                        Serializable hiveConfGet = new Serializable(hiveConf, hiveConfClass){
                            public static final long serialVersionUID = 0L;
                            private final Object hiveConf$1;
                            private final Class hiveConfClass$1;

                            public final Option<Object> apply(String param) {
                                return Option$.MODULE$.apply(this.hiveConfClass$1.getMethod("get", String.class).invoke(this.hiveConf$1, param));
                            }
                            {
                                this.hiveConf$1 = hiveConf$1;
                                this.hiveConfClass$1 = hiveConfClass$1;
                            }
                        };
                        Option option = metastore_uri = (Option)hiveConfGet.apply((Object)"hive.metastore.uris");
                        None$ none$ = None$.MODULE$;
                        if (!(option == null ? none$ != null : !option.equals(none$)) || new StringOps(Predef$.MODULE$.augmentString(metastore_uri.get().toString())).size() <= 0) break block6;
                        String metastore_kerberos_principal_conf_var = mirror.classLoader().loadClass("org.apache.hadoop.hive.conf.HiveConf$ConfVars").getField("METASTORE_KERBEROS_PRINCIPAL").get("varname").toString();
                        principal = (Option)hiveConfGet.apply((Object)metastore_kerberos_principal_conf_var);
                        username = Option$.MODULE$.apply((Object)UserGroupInformation.getCurrentUser().getUserName());
                        Option option2 = principal;
                        None$ none$2 = None$.MODULE$;
                        if (!(option2 == null ? none$2 != null : !option2.equals(none$2))) break block7;
                        Option option3 = username;
                        None$ none$3 = None$.MODULE$;
                        if (option3 != null ? !option3.equals(none$3) : none$3 != null) break block8;
                    }
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Username or principal == NULL";
                        }
                    });
                    this.logError((Function0<String>)new Serializable(username){
                        public static final long serialVersionUID = 0L;
                        private final Option username$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"username=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.username$1.getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "(NULL)";
                                }
                            })}));
                        }
                        {
                            this.username$1 = username$1;
                        }
                    });
                    this.logError((Function0<String>)new Serializable(principal){
                        public static final long serialVersionUID = 0L;
                        private final Option principal$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"principal=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principal$1.getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "(NULL)";
                                }
                            })}));
                        }
                        {
                            this.principal$1 = principal$1;
                        }
                    });
                    throw new IllegalArgumentException("username and/or principal is equal to null!");
                }
                String tokenStr = (String)hiveClass.getMethod("getDelegationToken", String.class, String.class).invoke(hive, username.get(), principal.get());
                Token hive2Token = new Token();
                hive2Token.decodeFromUrlString(tokenStr);
                credentials.addToken(new Text("hive.server2.delegation.token"), hive2Token);
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Added hive.Server2.delegation.token to conf.";
                    }
                });
                hiveClass.getMethod("closeCurrent", new Class[0]).invoke(null, new Object[0]);
                return;
            }
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "HiveMetaStore configured in localmode";
                }
            });
            return;
        }
        catch (Exception exception) {
            this.logError((Function0<String>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$3;

                public final String apply() {
                    return new StringBuilder().append((Object)"Unexpected Exception ").append((Object)this.e$3).toString();
                }
                {
                    this.e$3 = e$3;
                }
            });
            throw new RuntimeException("Unexpected exception", exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logInfo((Function0<String>)new Serializable(classNotFoundException){
                public static final long serialVersionUID = 0L;
                private final ClassNotFoundException e$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Hive Class not found ").append((Object)this.e$2).toString();
                }
                {
                    this.e$2 = e$2;
                }
            });
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logInfo((Function0<String>)new Serializable(noSuchMethodException){
                public static final long serialVersionUID = 0L;
                private final NoSuchMethodException e$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Hive Method not found ").append((Object)this.e$1).toString();
                }
                {
                    this.e$1 = e$1;
                }
            });
            return;
        }
    }

    public void obtainTokenForHBase(Configuration conf, Credentials credentials) {
        if (UserGroupInformation.isSecurityEnabled()) {
            JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            try {
                Method confCreate = mirror.classLoader().loadClass("org.apache.hadoop.hbase.HBaseConfiguration").getMethod("create", Configuration.class);
                Method obtainToken = mirror.classLoader().loadClass("org.apache.hadoop.hbase.security.token.TokenUtil").getMethod("obtainToken", Configuration.class);
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Attempting to fetch HBase security token.";
                    }
                });
                Object hbaseConf = confCreate.invoke(null, conf);
                Token token = (Token)obtainToken.invoke(null, hbaseConf);
                credentials.addToken(token.getService(), token);
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Added HBase security token to credentials.";
                    }
                });
            }
            catch (Exception exception) {
                this.logError((Function0<String>)new Serializable(exception){
                    public static final long serialVersionUID = 0L;
                    private final Exception e$7;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Exception when obtaining HBase security token: ").append((Object)this.e$7).toString();
                    }
                    {
                        this.e$7 = e$7;
                    }
                });
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.logDebug((Function0<String>)new Serializable(noClassDefFoundError){
                    public static final long serialVersionUID = 0L;
                    private final NoClassDefFoundError e$6;

                    public final String apply() {
                        return new StringBuilder().append((Object)"HBase Class not found: ").append((Object)this.e$6).toString();
                    }
                    {
                        this.e$6 = e$6;
                    }
                });
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logDebug((Function0<String>)new Serializable(classNotFoundException){
                    public static final long serialVersionUID = 0L;
                    private final ClassNotFoundException e$5;

                    public final String apply() {
                        return new StringBuilder().append((Object)"HBase Class not found: ").append((Object)this.e$5).toString();
                    }
                    {
                        this.e$5 = e$5;
                    }
                });
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.logInfo((Function0<String>)new Serializable(noSuchMethodException){
                    public static final long serialVersionUID = 0L;
                    private final NoSuchMethodException e$4;

                    public final String apply() {
                        return new StringBuilder().append((Object)"HBase Method not found: ").append((Object)this.e$4).toString();
                    }
                    {
                        this.e$4 = e$4;
                    }
                });
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean org$apache$spark$deploy$yarn$Client$$compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) return false;
        String string = srcUri.getScheme();
        String string2 = dstUri.getScheme();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            String string3 = srcHost;
            String string4 = dstHost;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                try {
                    srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                    dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }
        }
        if (!Objects.equal((Object)srcHost, (Object)dstHost)) return false;
        if (srcUri.getPort() != dstUri.getPort()) return false;
        return true;
    }

    public Path org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(URI localURI, Configuration hadoopConf) {
        URI qualifiedURI = localURI.getScheme() == null ? new URI(FileSystem.getLocal((Configuration)hadoopConf).makeQualified(new Path(localURI)).toString()) : localURI;
        return new Path(qualifiedURI);
    }

    public boolean isUserClassPathFirst(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getBoolean("spark.driver.userClassPathFirst", false) : conf.getBoolean("spark.executor.userClassPathFirst", false);
    }

    public String buildPath(Seq<String> components) {
        return components.mkString("/");
    }

    private Client$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.SPARK_JAR = "__spark__.jar";
        this.APP_JAR = "__app__.jar";
        this.LOCAL_SCHEME = "local";
        this.SPARK_STAGING = ".sparkStaging";
        this.CONF_SPARK_JAR = "spark.yarn.jar";
        this.ENV_SPARK_JAR = "SPARK_JAR";
        this.CONF_SPARK_USER_JAR = "spark.yarn.user.jar";
        this.CONF_SPARK_YARN_SECONDARY_JARS = "spark.yarn.secondary.jars";
        this.STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8)));
        this.APP_FILE_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8)));
        this.ENV_DIST_CLASSPATH = "SPARK_DIST_CLASSPATH";
        this.LOCALIZED_HADOOP_CONF_DIR = "__hadoop_conf__";
    }
}

