/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.log4j.Level;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.ContainerLocalityPreferences;
import org.apache.spark.deploy.yarn.ExecutorRunnable;
import org.apache.spark.deploy.yarn.LocalityPreferredContainerPlacementStrategy;
import org.apache.spark.deploy.yarn.YarnAllocator$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.slf4j.Logger;
import org.spark-project.guava.util.concurrent.ThreadFactoryBuilder;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rUd!B\u0001\u0003\u0001\ta!!D-be:\fE\u000e\\8dCR|'O\u0003\u0002\u0004\t\u0005!\u00110\u0019:o\u0015\t)a!\u0001\u0004eKBdw.\u001f\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\t\u0011\u0002\u001a:jm\u0016\u0014XK\u001d7\u0004\u0001A\u00111D\b\b\u0003\u001dqI!!H\b\u0002\rA\u0013X\rZ3g\u0013\ty\u0002E\u0001\u0004TiJLgn\u001a\u0006\u0003;=A\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\nIJLg/\u001a:SK\u001a\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u0007I\u00048-\u0003\u0002)K\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\t\r|gN\u001a\t\u0003YAj\u0011!\f\u0006\u0003U9R!a\f\u0005\u0002\r!\fGm\\8q\u0013\t\tTFA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\tg\u0001\u0011\t\u0011)A\u0005i\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003)UJ!A\u000e\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0011\u0005l7\t\\5f]R\u00042A\u000f!C\u001b\u0005Y$B\u0001\u001f>\u0003\r\t\u0007/\u001b\u0006\u0003}}\naa\u00197jK:$(BA\u0002/\u0013\t\t5H\u0001\u0006B\u001bJk5\t\\5f]R\u0004\"aQ+\u000f\u0005\u0011\u001bfBA#S\u001d\t1\u0015K\u0004\u0002H!:\u0011\u0001j\u0014\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001T\r\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\ty\u0003\"\u0003\u0002\u0004]%\u0011ahP\u0005\u0003yuJ!\u0001V\u001e\u0002\u0015\u0005k%+T\"mS\u0016tG/\u0003\u0002W/\n\u00012i\u001c8uC&tWM\u001d*fcV,7\u000f\u001e\u0006\u0003)nB\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IAW\u0001\rCB\u0004\u0018\t\u001e;f[B$\u0018\n\u001a\t\u00037~k\u0011\u0001\u0018\u0006\u0003;z\u000bqA]3d_J$7O\u0003\u0002=\u007f%\u0011\u0001\r\u0018\u0002\u0015\u0003B\u0004H.[2bi&|g.\u0011;uK6\u0004H/\u00133\t\u0011\t\u0004!\u0011!Q\u0001\n\r\fA!\u0019:hgB\u0011A-Z\u0007\u0002\u0005%\u0011aM\u0001\u0002\u001b\u0003B\u0004H.[2bi&|g.T1ti\u0016\u0014\u0018I]4v[\u0016tGo\u001d\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\u0006Y1/Z2ve&$\u00180T4s!\t!\".\u0003\u0002l\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000fC\u0003n\u0001\u0011\u0005a.\u0001\u0004=S:LGO\u0010\u000b\n_B\f(o\u001d;vm^\u0004\"\u0001\u001a\u0001\t\u000baa\u0007\u0019\u0001\u000e\t\u000b\tb\u0007\u0019A\u0012\t\u000b)b\u0007\u0019A\u0016\t\u000bMb\u0007\u0019\u0001\u001b\t\u000bab\u0007\u0019A\u001d\t\u000bec\u0007\u0019\u0001.\t\u000b\td\u0007\u0019A2\t\u000b!d\u0007\u0019A5\t\u000fe\u0004!\u0019!C\u0001u\u0006a\u0012\r\u001c7pG\u0006$X\r\u001a%pgR$vnQ8oi\u0006Lg.\u001a:t\u001b\u0006\u0004X#A>\u0011\rq\f\u0019AGA\u0004\u001b\u0005i(B\u0001@\u0000\u0003\u001diW\u000f^1cY\u0016T1!!\u0001\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u000bi(a\u0002%bg\"l\u0015\r\u001d\t\u0006y\u0006%\u0011QB\u0005\u0004\u0003\u0017i(aA*fiB\u00191,a\u0004\n\u0007\u0005EALA\u0006D_:$\u0018-\u001b8fe&#\u0007bBA\u000b\u0001\u0001\u0006Ia_\u0001\u001eC2dwnY1uK\u0012Dun\u001d;U_\u000e{g\u000e^1j]\u0016\u00148/T1qA!I\u0011\u0011\u0004\u0001C\u0002\u0013\u0005\u00111D\u0001\u001cC2dwnY1uK\u0012\u001cuN\u001c;bS:,'\u000fV8I_N$X*\u00199\u0016\u0005\u0005u\u0001C\u0002?\u0002\u0004\u00055!\u0004\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u000f\u0003q\tG\u000e\\8dCR,GmQ8oi\u0006Lg.\u001a:U_\"{7\u000f^'ba\u0002B\u0011\"!\n\u0001\u0005\u0004%I!a\n\u0002%I,G.Z1tK\u0012\u001cuN\u001c;bS:,'o]\u000b\u0003\u0003S\u0001b!a\u000b\u00026\u00055QBAA\u0017\u0015\u0011\ty#!\r\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003g\tAA[1wC&!\u00111BA\u0017\u0011!\tI\u0004\u0001Q\u0001\n\u0005%\u0012a\u0005:fY\u0016\f7/\u001a3D_:$\u0018-\u001b8feN\u0004\u0003\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0003MqW/\\#yK\u000e,Ho\u001c:t%Vtg.\u001b8h+\t\t\t\u0005E\u0002\u000f\u0003\u0007J1!!\u0012\u0010\u0005\rIe\u000e\u001e\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017\nqC\\;n\u000bb,7-\u001e;peN\u0014VO\u001c8j]\u001e|F%Z9\u0015\t\u00055\u00131\u000b\t\u0004\u001d\u0005=\u0013bAA)\u001f\t!QK\\5u\u0011)\t)&a\u0012\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0004q\u0012\n\u0004\u0002CA-\u0001\u0001\u0006K!!\u0011\u0002)9,X.\u0012=fGV$xN]:Sk:t\u0017N\\4!Q\u0011\t9&!\u0018\u0011\u00079\ty&C\u0002\u0002b=\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003K\u0002\u0001\u0019!C\u0005\u0003\u007f\t\u0011#\u001a=fGV$xN]%e\u0007>,h\u000e^3s\u0011%\tI\u0007\u0001a\u0001\n\u0013\tY'A\u000bfq\u0016\u001cW\u000f^8s\u0013\u0012\u001cu.\u001e8uKJ|F%Z9\u0015\t\u00055\u0013Q\u000e\u0005\u000b\u0003+\n9'!AA\u0002\u0005\u0005\u0003\u0002CA9\u0001\u0001\u0006K!!\u0011\u0002%\u0015DXmY;u_JLEmQ8v]R,'\u000f\t\u0005\n\u0003k\u0002\u0001\u0019!C\u0005\u0003\u007f\t!C\\;n\u000bb,7-\u001e;peN4\u0015-\u001b7fI\"I\u0011\u0011\u0010\u0001A\u0002\u0013%\u00111P\u0001\u0017]VlW\t_3dkR|'o\u001d$bS2,Gm\u0018\u0013fcR!\u0011QJA?\u0011)\t)&a\u001e\u0002\u0002\u0003\u0007\u0011\u0011\t\u0005\t\u0003\u0003\u0003\u0001\u0015)\u0003\u0002B\u0005\u0019b.^7Fq\u0016\u001cW\u000f^8sg\u001a\u000b\u0017\u000e\\3eA!\"\u0011qPA/\u0011%\t9\t\u0001a\u0001\n\u0013\ty$\u0001\nuCJ<W\r\u001e(v[\u0016CXmY;u_J\u001c\b\"CAF\u0001\u0001\u0007I\u0011BAG\u0003Y!\u0018M]4fi:+X.\u0012=fGV$xN]:`I\u0015\fH\u0003BA'\u0003\u001fC!\"!\u0016\u0002\n\u0006\u0005\t\u0019AA!\u0011!\t\u0019\n\u0001Q!\n\u0005\u0005\u0013a\u0005;be\u001e,GOT;n\u000bb,7-\u001e;peN\u0004\u0003\u0006BAI\u0003;B!\"!'\u0001\u0005\u0004%\tAAAN\u0003U)\u00070Z2vi>\u0014\u0018\n\u001a+p\u0007>tG/Y5oKJ,\"!!(\u0011\rq\f\u0019AGAP!\rY\u0016\u0011U\u0005\u0004\u0003Gc&!C\"p]R\f\u0017N\\3s\u0011!\t9\u000b\u0001Q\u0001\n\u0005u\u0015AF3yK\u000e,Ho\u001c:JIR{7i\u001c8uC&tWM\u001d\u0011\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0016!\b8v[VsW\r\u001f9fGR,GmQ8oi\u0006Lg.\u001a:SK2,\u0017m]3\u0016\u0005\u0005=\u0006c\u0001\b\u00022&\u0019\u00111W\b\u0003\t1{gn\u001a\u0005\n\u0003o\u0003\u0001\u0019!C\u0005\u0003s\u000b\u0011E\\;n+:,\u0007\u0010]3di\u0016$7i\u001c8uC&tWM\u001d*fY\u0016\f7/Z0%KF$B!!\u0014\u0002<\"Q\u0011QKA[\u0003\u0003\u0005\r!a,\t\u0011\u0005}\u0006\u0001)Q\u0005\u0003_\u000baD\\;n+:,\u0007\u0010]3di\u0016$7i\u001c8uC&tWM\u001d*fY\u0016\f7/\u001a\u0011\t\u0013\u0005\r\u0007A1A\u0005\n\u0005m\u0011aF2p]R\f\u0017N\\3s\u0013\u0012$v.\u0012=fGV$xN]%e\u0011!\t9\r\u0001Q\u0001\n\u0005u\u0011\u0001G2p]R\f\u0017N\\3s\u0013\u0012$v.\u0012=fGV$xN]%eA!I\u00111\u001a\u0001C\u0002\u0013E\u0011qH\u0001\u000fKb,7-\u001e;pe6+Wn\u001c:z\u0011!\ty\r\u0001Q\u0001\n\u0005\u0005\u0013aD3yK\u000e,Ho\u001c:NK6|'/\u001f\u0011\t\u0013\u0005M\u0007A1A\u0005\u0012\u0005}\u0012AD7f[>\u0014\u0018p\u0014<fe\",\u0017\r\u001a\u0005\t\u0003/\u0004\u0001\u0015!\u0003\u0002B\u0005yQ.Z7pef|e/\u001a:iK\u0006$\u0007\u0005C\u0005\u0002\\\u0002\u0011\r\u0011\"\u0005\u0002@\u0005iQ\r_3dkR|'oQ8sKND\u0001\"a8\u0001A\u0003%\u0011\u0011I\u0001\u000fKb,7-\u001e;pe\u000e{'/Z:!\u0011)\t\u0019\u000f\u0001b\u0001\n\u0003\u0011\u0011Q]\u0001\te\u0016\u001cx.\u001e:dKV\u0011\u0011q\u001d\t\u00047\u0006%\u0018bAAv9\nA!+Z:pkJ\u001cW\r\u0003\u0005\u0002p\u0002\u0001\u000b\u0011BAt\u0003%\u0011Xm]8ve\u000e,\u0007\u0005C\u0005\u0002t\u0002\u0011\r\u0011\"\u0003\u0002v\u0006aA.Y;oG\",'\u000fU8pYV\u0011\u0011q\u001f\t\u0005\u0003s\fy0\u0004\u0002\u0002|*!\u0011Q`A\u0017\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005\u0003\tYP\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\b\u0002\u0003B\u0003\u0001\u0001\u0006I!a>\u0002\u001b1\fWO\\2iKJ\u0004vn\u001c7!\u0011%\u0011I\u0001\u0001b\u0001\n\u0013\u0011Y!\u0001\tmCVt7\r[\"p]R\f\u0017N\\3sgV\u0011!Q\u0002\t\u0004\u001d\t=\u0011b\u0001B\t\u001f\t9!i\\8mK\u0006t\u0007\u0002\u0003B\u000b\u0001\u0001\u0006IA!\u0004\u0002#1\fWO\\2i\u0007>tG/Y5oKJ\u001c\b\u0005C\u0005\u0003\u001a\u0001\u0011\r\u0011\"\u0003\u0003\u001c\u0005yA.\u00192fY\u0016C\bO]3tg&|g.\u0006\u0002\u0003\u001eA!aBa\b\u001b\u0013\r\u0011\tc\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\t\u0015\u0002\u0001)A\u0005\u0005;\t\u0001\u0003\\1cK2,\u0005\u0010\u001d:fgNLwN\u001c\u0011\t\u0013\t%\u0002A1A\u0005\n\t-\u0012\u0001\u00068pI\u0016d\u0015MY3m\u0007>t7\u000f\u001e:vGR|'/\u0006\u0002\u0003.A)aBa\b\u00030A)!\u0011\u0007B\u001e\u00056\u0011!1\u0007\u0006\u0005\u0005k\u00119$A\u0004sK\u001adWm\u0019;\u000b\t\te\u0012\u0011G\u0001\u0005Y\u0006tw-\u0003\u0003\u0003>\tM\"aC\"p]N$(/^2u_JD\u0001B!\u0011\u0001A\u0003%!QF\u0001\u0016]>$W\rT1cK2\u001cuN\\:ueV\u001cGo\u001c:!\u0011%\u0011)\u0005\u0001a\u0001\n\u0013\u00119%A\u000bi_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e^:\u0016\u0005\t%\u0003CB\u000e\u0003Li\t\t%C\u0002\u0003N\u0001\u00121!T1q\u0011%\u0011\t\u0006\u0001a\u0001\n\u0013\u0011\u0019&A\ri_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e^:`I\u0015\fH\u0003BA'\u0005+B!\"!\u0016\u0003P\u0005\u0005\t\u0019\u0001B%\u0011!\u0011I\u0006\u0001Q!\n\t%\u0013A\u00065pgR$v\u000eT8dC2$\u0016m]6D_VtGo\u001d\u0011\t\u0013\tu\u0003\u00011A\u0005\n\u0005}\u0012!\u00068v[2{7-\u00197jif\fu/\u0019:f)\u0006\u001c8n\u001d\u0005\n\u0005C\u0002\u0001\u0019!C\u0005\u0005G\n\u0011D\\;n\u0019>\u001c\u0017\r\\5us\u0006;\u0018M]3UCN\\7o\u0018\u0013fcR!\u0011Q\nB3\u0011)\t)Fa\u0018\u0002\u0002\u0003\u0007\u0011\u0011\t\u0005\t\u0005S\u0002\u0001\u0015)\u0003\u0002B\u00051b.^7M_\u000e\fG.\u001b;z\u0003^\f'/\u001a+bg.\u001c\b\u0005\u0003\u0006\u0003n\u0001\u0011\r\u0011\"\u0001\u0003\u0005_\n!dY8oi\u0006Lg.\u001a:QY\u0006\u001cW-\\3oiN#(/\u0019;fOf,\"A!\u001d\u0011\u0007\u0011\u0014\u0019(C\u0002\u0003v\t\u00111\u0006T8dC2LG/\u001f)sK\u001a,'O]3e\u0007>tG/Y5oKJ\u0004F.Y2f[\u0016tGo\u0015;sCR,w-\u001f\u0005\t\u0005s\u0002\u0001\u0015!\u0003\u0003r\u0005Y2m\u001c8uC&tWM\u001d)mC\u000e,W.\u001a8u'R\u0014\u0018\r^3hs\u0002BqA! \u0001\t\u0003\ty$\u0001\fhKRtU/\\#yK\u000e,Ho\u001c:t%Vtg.\u001b8h\u0011\u001d\u0011\t\t\u0001C\u0001\u0003\u007f\tQcZ3u\u001dVlW\t_3dkR|'o\u001d$bS2,G\rC\u0004\u0003\u0006\u0002!\t!a\u0010\u0002+\u001d,GOT;n!\u0016tG-\u001b8h\u00032dwnY1uK\"9!\u0011\u0012\u0001\u0005\n\t-\u0015aF4fi:+X\u000eU3oI&tw-\u0011;M_\u000e\fG/[8o)\u0011\t\tE!$\t\u000f\t=%q\u0011a\u00015\u0005AAn\\2bi&|g\u000eC\u0004\u0003\u0014\u0002!\tA!&\u0002YI,\u0017/^3tiR{G/\u00197Fq\u0016\u001cW\u000f^8sg^KG\u000f\u001b)sK\u001a,'O]3e\u0019>\u001c\u0017\r\\5uS\u0016\u001cH\u0003\u0003B\u0007\u0005/\u0013YJa(\t\u0011\te%\u0011\u0013a\u0001\u0003\u0003\naB]3rk\u0016\u001cH/\u001a3U_R\fG\u000e\u0003\u0005\u0003\u001e\nE\u0005\u0019AA!\u0003IawnY1mSRL\u0018i^1sKR\u000b7o[:\t\u0011\t\u0005&\u0011\u0013a\u0001\u0005\u0013\nA\u0003[8tiR{Gj\\2bYR\u000b7o[\"pk:$\bb\u0002BS\u0001\u0011\u0005!qU\u0001\rW&dG.\u0012=fGV$xN\u001d\u000b\u0005\u0003\u001b\u0012I\u000bC\u0004\u0003,\n\r\u0006\u0019\u0001\u000e\u0002\u0015\u0015DXmY;u_JLE\rC\u0004\u00030\u0002!\tA!-\u0002#\u0005dGn\\2bi\u0016\u0014Vm]8ve\u000e,7\u000f\u0006\u0002\u0002N!9!Q\u0017\u0001\u0005\u0002\tE\u0016AF;qI\u0006$XMU3t_V\u00148-\u001a*fcV,7\u000f^:\t\u000f\te\u0006\u0001\"\u0005\u0003<\u000612M]3bi\u0016\u001cuN\u001c;bS:,'OU3rk\u0016\u001cH\u000fF\u0004C\u0005{\u0013yL!3\t\u0011\u0005\r(q\u0017a\u0001\u0003OD\u0001B!1\u00038\u0002\u0007!1Y\u0001\u0006]>$Wm\u001d\t\u0005\u001d\t\u0015'$C\u0002\u0003H>\u0011Q!\u0011:sCfD\u0001Ba3\u00038\u0002\u0007!1Y\u0001\u0006e\u0006\u001c7n\u001d\u0005\b\u0005\u001f\u0004A\u0011\u0001Bi\u0003eA\u0017M\u001c3mK\u0006cGn\\2bi\u0016$7i\u001c8uC&tWM]:\u0015\t\u00055#1\u001b\u0005\t\u0005+\u0014i\r1\u0001\u0003X\u0006\u0019\u0012\r\u001c7pG\u0006$X\rZ\"p]R\f\u0017N\\3sgB1!\u0011\u001cBr\u0003?sAAa7\u0003`:\u0019!J!8\n\u0003AI1A!9\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LAA!:\u0003h\n\u00191+Z9\u000b\u0007\t\u0005x\u0002C\u0004\u0003l\u0002!IA!<\u0002/5\fGo\u00195D_:$\u0018-\u001b8feR{'+Z9vKN$HCCA'\u0005_\u0014\u0019P!>\u0003\u0000\"A!\u0011\u001fBu\u0001\u0004\ty*\u0001\nbY2|7-\u0019;fI\u000e{g\u000e^1j]\u0016\u0014\bb\u0002BH\u0005S\u0004\rA\u0007\u0005\t\u0005o\u0014I\u000f1\u0001\u0003z\u0006y1m\u001c8uC&tWM]:U_V\u001bX\rE\u0003}\u0005w\fy*C\u0002\u0003~v\u00141\"\u0011:sCf\u0014UO\u001a4fe\"A1\u0011\u0001Bu\u0001\u0004\u0011I0A\u0005sK6\f\u0017N\\5oO\"91Q\u0001\u0001\u0005\n\r\u001d\u0011A\u0006:v]\u0006cGn\\2bi\u0016$7i\u001c8uC&tWM]:\u0015\t\u000553\u0011\u0002\u0005\t\u0005o\u001c\u0019\u00011\u0001\u0003z\"A1Q\u0002\u0001\u0005\u0002\t\u0019y!\u0001\u000eqe>\u001cWm]:D_6\u0004H.\u001a;fI\u000e{g\u000e^1j]\u0016\u00148\u000f\u0006\u0003\u0002N\rE\u0001\u0002CB\n\u0007\u0017\u0001\ra!\u0006\u0002'\r|W\u000e\u001d7fi\u0016$7i\u001c8uC&tWM]:\u0011\r\te'1]B\f!\rY6\u0011D\u0005\u0004\u00077a&aD\"p]R\f\u0017N\\3s'R\fG/^:\t\u000f\r}\u0001\u0001\"\u0003\u0004\"\u0005A\u0012N\u001c;fe:\fGNU3mK\u0006\u001cXmQ8oi\u0006Lg.\u001a:\u0015\t\u0005531\u0005\u0005\t\u0007K\u0019i\u00021\u0001\u0002 \u0006I1m\u001c8uC&tWM\u001d\u0005\t\u0007S\u0001A\u0011\u0001\u0002\u0002.\u0006\u0001s-\u001a;Ok6,f.\u001a=qK\u000e$X\rZ\"p]R\f\u0017N\\3s%\u0016dW-Y:f\u000f\u001d\u0019iC\u0001E\u0005\u0007_\tQ\"W1s]\u0006cGn\\2bi>\u0014\bc\u00013\u00042\u00191\u0011A\u0001E\u0005\u0007g\u00192a!\r\u000e\u0011\u001di7\u0011\u0007C\u0001\u0007o!\"aa\f\t\u0015\rm2\u0011\u0007b\u0001\n\u0003\u0019i$A\u0005N\u000b6{&+R$F1V\u00111q\b\t\u0005\u0007\u0003\u001a\u0019%\u0004\u0002\u00038%\u0019qDa\u000e\t\u0013\r\u001d3\u0011\u0007Q\u0001\n\r}\u0012AC'F\u001b~\u0013ViR#YA!Q11JB\u0019\u0005\u0004%\ta!\u0014\u0002+AkU)T0F1\u000e+U\tR#E?B\u000bE\u000bV#S\u001dV\u00111q\n\t\u0005\u0007#\u001a9&\u0004\u0002\u0004T)!1QKA\u0017\u0003\u0015\u0011XmZ3y\u0013\u0011\u0019Ifa\u0015\u0003\u000fA\u000bG\u000f^3s]\"I1QLB\u0019A\u0003%1qJ\u0001\u0017!6+UjX#Y\u0007\u0016+E)\u0012#`!\u0006#F+\u0012*OA!Q1\u0011MB\u0019\u0005\u0004%\ta!\u0014\u0002+YkU)T0F1\u000e+U\tR#E?B\u000bE\u000bV#S\u001d\"I1QMB\u0019A\u0003%1qJ\u0001\u0017-6+UjX#Y\u0007\u0016+E)\u0012#`!\u0006#F+\u0012*OA!A1\u0011NB\u0019\t\u0003\u0019Y'\u0001\u000enK6d\u0015.\\5u\u000bb\u001cW-\u001a3fI2{w-T3tg\u0006<W\rF\u0003\u001b\u0007[\u001a\t\bC\u0004\u0004p\r\u001d\u0004\u0019\u0001\u000e\u0002\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u0005\t\u0007g\u001a9\u00071\u0001\u0004P\u00059\u0001/\u0019;uKJt\u0007")
public class YarnAllocator
implements Logging {
    public final String org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl;
    public final RpcEndpointRef org$apache$spark$deploy$yarn$YarnAllocator$$driverRef;
    public final Configuration org$apache$spark$deploy$yarn$YarnAllocator$$conf;
    public final SparkConf org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf;
    public final AMRMClient<AMRMClient.ContainerRequest> org$apache$spark$deploy$yarn$YarnAllocator$$amClient;
    public final ApplicationAttemptId org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId;
    public final SecurityManager org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr;
    private final HashMap<String, scala.collection.mutable.Set<ContainerId>> allocatedHostToContainersMap;
    private final HashMap<ContainerId, String> allocatedContainerToHostMap;
    private final Set<ContainerId> org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers;
    private volatile int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning;
    private int org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter;
    private volatile int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed;
    private volatile int org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors;
    private final HashMap<String, Container> executorIdToContainer;
    private long org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease;
    private final HashMap<ContainerId, String> org$apache$spark$deploy$yarn$YarnAllocator$$containerIdToExecutorId;
    private final int executorMemory;
    private final int memoryOverhead;
    private final int executorCores;
    private final Resource resource;
    private final ThreadPoolExecutor org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool;
    private final boolean org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers;
    private final Option<String> org$apache$spark$deploy$yarn$YarnAllocator$$labelExpression;
    private final Option<Constructor<AMRMClient.ContainerRequest>> nodeLabelConstructor;
    private Map<String, Object> hostToLocalTaskCounts;
    private int numLocalityAwareTasks;
    private final LocalityPreferredContainerPlacementStrategy containerPlacementStrategy;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String memLimitExceededLogMessage(String string, Pattern pattern) {
        return YarnAllocator$.MODULE$.memLimitExceededLogMessage(string, pattern);
    }

    public static Pattern VMEM_EXCEEDED_PATTERN() {
        return YarnAllocator$.MODULE$.VMEM_EXCEEDED_PATTERN();
    }

    public static Pattern PMEM_EXCEEDED_PATTERN() {
        return YarnAllocator$.MODULE$.PMEM_EXCEEDED_PATTERN();
    }

    public static String MEM_REGEX() {
        return YarnAllocator$.MODULE$.MEM_REGEX();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public HashMap<String, scala.collection.mutable.Set<ContainerId>> allocatedHostToContainersMap() {
        return this.allocatedHostToContainersMap;
    }

    public HashMap<ContainerId, String> allocatedContainerToHostMap() {
        return this.allocatedContainerToHostMap;
    }

    public Set<ContainerId> org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning;
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning = x$1;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter;
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter = x$1;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed;
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed = x$1;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors;
    }

    private void org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors = x$1;
    }

    public HashMap<String, Container> executorIdToContainer() {
        return this.executorIdToContainer;
    }

    public long org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease;
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease_$eq(long x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease = x$1;
    }

    public HashMap<ContainerId, String> org$apache$spark$deploy$yarn$YarnAllocator$$containerIdToExecutorId() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$containerIdToExecutorId;
    }

    public int executorMemory() {
        return this.executorMemory;
    }

    public int memoryOverhead() {
        return this.memoryOverhead;
    }

    public int executorCores() {
        return this.executorCores;
    }

    public Resource resource() {
        return this.resource;
    }

    public ThreadPoolExecutor org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool;
    }

    public boolean org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers;
    }

    public Option<String> org$apache$spark$deploy$yarn$YarnAllocator$$labelExpression() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$labelExpression;
    }

    private Option<Constructor<AMRMClient.ContainerRequest>> nodeLabelConstructor() {
        return this.nodeLabelConstructor;
    }

    private Map<String, Object> hostToLocalTaskCounts() {
        return this.hostToLocalTaskCounts;
    }

    private void hostToLocalTaskCounts_$eq(Map<String, Object> x$1) {
        this.hostToLocalTaskCounts = x$1;
    }

    private int numLocalityAwareTasks() {
        return this.numLocalityAwareTasks;
    }

    private void numLocalityAwareTasks_$eq(int x$1) {
        this.numLocalityAwareTasks = x$1;
    }

    public LocalityPreferredContainerPlacementStrategy containerPlacementStrategy() {
        return this.containerPlacementStrategy;
    }

    public int getNumExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning();
    }

    public int getNumExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed();
    }

    public int getNumPendingAllocate() {
        return this.getNumPendingAtLocation(YarnSparkHadoopUtil$.MODULE$.ANY_HOST());
    }

    private int getNumPendingAtLocation(String location) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.getMatchingRequests(YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY(), location, this.resource())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Collection x$1) {
                return x$1.size();
            }
        }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public synchronized boolean requestTotalExecutorsWithPreferredLocalities(int requestedTotal, int localityAwareTasks, Map<String, Object> hostToLocalTaskCount) {
        boolean bl;
        this.numLocalityAwareTasks_$eq(localityAwareTasks);
        this.hostToLocalTaskCounts_$eq(hostToLocalTaskCount);
        if (requestedTotal != this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors()) {
            this.logInfo((Function0<String>)new Serializable(this, requestedTotal){
                public static final long serialVersionUID = 0L;
                private final int requestedTotal$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver requested a total number of ", " executor(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.requestedTotal$1)}));
                }
                {
                    this.requestedTotal$1 = requestedTotal$1;
                }
            });
            this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors_$eq(requestedTotal);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized void killExecutor(String executorId) {
        if (this.executorIdToContainer().contains((Object)executorId)) {
            Container container = (Container)this.executorIdToContainer().remove((Object)executorId).get();
            this.org$apache$spark$deploy$yarn$YarnAllocator$$containerIdToExecutorId().remove((Object)container.getId());
            this.org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
            this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() - 1);
        } else {
            this.logWarning((Function0<String>)new Serializable(this, executorId){
                public static final long serialVersionUID = 0L;
                private final String executorId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to kill unknown executor ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1}));
                }
                {
                    this.executorId$1 = executorId$1;
                }
            });
        }
    }

    public synchronized void allocateResources() {
        List completedContainers;
        this.updateResourceRequests();
        float progressIndicator = 0.1f;
        AllocateResponse allocateResponse = this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.allocate(progressIndicator);
        List allocatedContainers = allocateResponse.getAllocatedContainers();
        if (allocatedContainers.size() > 0) {
            this.logDebug((Function0<String>)new Serializable(this, allocateResponse, allocatedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final AllocateResponse allocateResponse$1;
                private final List allocatedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Allocated containers: %d. Current executor count: %d. Cluster resources: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allocatedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning()), this.allocateResponse$1.getAvailableResources()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.allocateResponse$1 = allocateResponse$1;
                    this.allocatedContainers$1 = allocatedContainers$1;
                }
            });
            this.handleAllocatedContainers((Seq<Container>)JavaConversions$.MODULE$.asScalaBuffer(allocatedContainers));
        }
        if ((completedContainers = allocateResponse.getCompletedContainersStatuses()).size() > 0) {
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Completed %d containers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size())}));
                }
                {
                    this.completedContainers$1 = completedContainers$1;
                }
            });
            this.processCompletedContainers((Seq<ContainerStatus>)JavaConversions$.MODULE$.asScalaBuffer(completedContainers));
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Finished processing %d completed containers. Current running executor count: %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.completedContainers$1 = completedContainers$1;
                }
            });
        }
    }

    public void updateResourceRequests() {
        int numPendingAllocate = this.getNumPendingAllocate();
        int missing = this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors() - numPendingAllocate - this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning();
        if (missing > 0) {
            this.logInfo((Function0<String>)new Serializable(this, missing){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final int missing$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will request ", " executor containers, each with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.missing$1), BoxesRunTime.boxToInteger((int)this.$outer.resource().getVirtualCores())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cores and ", " MB memory including ", " MB overhead"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.resource().getMemory()), BoxesRunTime.boxToInteger((int)this.$outer.memoryOverhead())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.missing$1 = missing$1;
                }
            });
            ContainerLocalityPreferences[] containerLocalityPreferences = this.containerPlacementStrategy().localityOfRequestedContainers(missing, this.numLocalityAwareTasks(), this.hostToLocalTaskCounts(), this.allocatedHostToContainersMap());
            Predef$.MODULE$.refArrayOps((Object[])containerLocalityPreferences).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;

                public final void apply(ContainerLocalityPreferences locality) {
                    AMRMClient.ContainerRequest request = this.$outer.createContainerRequest(this.$outer.resource(), locality.nodes(), locality.racks());
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.addContainerRequest(request);
                    List nodes = request.getNodes();
                    String hostStr = nodes == null || nodes.isEmpty() ? "Any" : (String)JavaConversions$.MODULE$.asScalaBuffer(nodes).last();
                    this.$outer.logInfo((Function0<String>)new Serializable(this, hostStr){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$updateResourceRequests$2 $outer;
                        private final String hostStr$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Container request (host: ", ", capability: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostStr$1, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().resource()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.hostStr$1 = hostStr$1;
                        }
                    });
                }

                public /* synthetic */ YarnAllocator org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else if (missing < 0) {
            int numToCancel = package$.MODULE$.min(numPendingAllocate, -missing);
            this.logInfo((Function0<String>)new Serializable(this, numToCancel){
                public static final long serialVersionUID = 0L;
                private final int numToCancel$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Canceling requests for ", " executor containers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numToCancel$1)}));
                }
                {
                    this.numToCancel$1 = numToCancel$1;
                }
            });
            List matchingRequests = this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.getMatchingRequests(YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY(), YarnSparkHadoopUtil$.MODULE$.ANY_HOST(), this.resource());
            if (matchingRequests.isEmpty()) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Expected to find pending requests, but found none.";
                    }
                });
            } else {
                ((IterableLike)JavaConversions$.MODULE$.collectionAsScalaIterable((Collection)JavaConversions$.MODULE$.asScalaBuffer(matchingRequests).head()).take(numToCancel)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ YarnAllocator $outer;

                    public final void apply(AMRMClient.ContainerRequest x$1) {
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.removeContainerRequest(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
    }

    public AMRMClient.ContainerRequest createContainerRequest(Resource resource, String[] nodes, String[] racks) {
        return (AMRMClient.ContainerRequest)this.nodeLabelConstructor().map((Function1)new Serializable(this, resource, nodes, racks){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;
            private final Resource resource$1;
            private final String[] nodes$1;
            private final String[] racks$1;

            public final AMRMClient.ContainerRequest apply(Constructor<AMRMClient.ContainerRequest> constructor) {
                return constructor.newInstance(this.resource$1, this.nodes$1, this.racks$1, YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY(), Predef$.MODULE$.boolean2Boolean(true), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$labelExpression().orNull(Predef$.MODULE$.$conforms()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resource$1 = resource$1;
                this.nodes$1 = nodes$1;
                this.racks$1 = racks$1;
            }
        }).getOrElse((Function0)new Serializable(this, resource, nodes, racks){
            public static final long serialVersionUID = 0L;
            private final Resource resource$1;
            private final String[] nodes$1;
            private final String[] racks$1;

            public final AMRMClient.ContainerRequest apply() {
                return new AMRMClient.ContainerRequest(this.resource$1, this.nodes$1, this.racks$1, YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY());
            }
            {
                this.resource$1 = resource$1;
                this.nodes$1 = nodes$1;
                this.racks$1 = racks$1;
            }
        });
    }

    public void handleAllocatedContainers(Seq<Container> allocatedContainers) {
        ArrayBuffer containersToUse = new ArrayBuffer(allocatedContainers.size());
        ArrayBuffer remainingAfterHostMatches = new ArrayBuffer();
        allocatedContainers.foreach((Function1)new Serializable(this, containersToUse, remainingAfterHostMatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;
            private final ArrayBuffer containersToUse$1;
            private final ArrayBuffer remainingAfterHostMatches$1;

            public final void apply(Container allocatedContainer) {
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(allocatedContainer, allocatedContainer.getNodeId().getHost(), (ArrayBuffer<Container>)this.containersToUse$1, (ArrayBuffer<Container>)this.remainingAfterHostMatches$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.containersToUse$1 = containersToUse$1;
                this.remainingAfterHostMatches$1 = remainingAfterHostMatches$1;
            }
        });
        ArrayBuffer remainingAfterRackMatches = new ArrayBuffer();
        remainingAfterHostMatches.foreach((Function1)new Serializable(this, containersToUse, remainingAfterRackMatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;
            private final ArrayBuffer containersToUse$1;
            private final ArrayBuffer remainingAfterRackMatches$1;

            public final void apply(Container allocatedContainer) {
                String rack = RackResolver.resolve((Configuration)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, (String)allocatedContainer.getNodeId().getHost()).getNetworkLocation();
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(allocatedContainer, rack, (ArrayBuffer<Container>)this.containersToUse$1, (ArrayBuffer<Container>)this.remainingAfterRackMatches$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.containersToUse$1 = containersToUse$1;
                this.remainingAfterRackMatches$1 = remainingAfterRackMatches$1;
            }
        });
        ArrayBuffer remainingAfterOffRackMatches = new ArrayBuffer();
        remainingAfterRackMatches.foreach((Function1)new Serializable(this, containersToUse, remainingAfterOffRackMatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;
            private final ArrayBuffer containersToUse$1;
            private final ArrayBuffer remainingAfterOffRackMatches$1;

            public final void apply(Container allocatedContainer) {
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(allocatedContainer, YarnSparkHadoopUtil$.MODULE$.ANY_HOST(), (ArrayBuffer<Container>)this.containersToUse$1, (ArrayBuffer<Container>)this.remainingAfterOffRackMatches$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.containersToUse$1 = containersToUse$1;
                this.remainingAfterOffRackMatches$1 = remainingAfterOffRackMatches$1;
            }
        });
        if (!remainingAfterOffRackMatches.isEmpty()) {
            this.logDebug((Function0<String>)new Serializable(this, remainingAfterOffRackMatches){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer remainingAfterOffRackMatches$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Releasing ", " unneeded containers that were "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.remainingAfterOffRackMatches$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"allocated to us"})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.remainingAfterOffRackMatches$1 = remainingAfterOffRackMatches$1;
                }
            });
            remainingAfterOffRackMatches.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;

                public final void apply(Container container) {
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.runAllocatedContainers((ArrayBuffer<Container>)containersToUse);
        this.logInfo((Function0<String>)new Serializable(this, allocatedContainers, containersToUse){
            public static final long serialVersionUID = 0L;
            private final Seq allocatedContainers$2;
            private final ArrayBuffer containersToUse$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Received %d containers from YARN, launching executors on %d of them.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allocatedContainers$2.size()), BoxesRunTime.boxToInteger((int)this.containersToUse$1.size())}));
            }
            {
                this.allocatedContainers$2 = allocatedContainers$2;
                this.containersToUse$1 = containersToUse$1;
            }
        });
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(Container allocatedContainer, String location, ArrayBuffer<Container> containersToUse, ArrayBuffer<Container> remaining) {
        Resource matchingResource = Resource.newInstance((int)allocatedContainer.getResource().getMemory(), (int)this.resource().getVirtualCores());
        List matchingRequests = this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.getMatchingRequests(allocatedContainer.getPriority(), location, matchingResource);
        if (matchingRequests.isEmpty()) {
            remaining.$plus$eq((Object)allocatedContainer);
        } else {
            AMRMClient.ContainerRequest containerRequest = (AMRMClient.ContainerRequest)((Collection)matchingRequests.get(0)).iterator().next();
            this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.removeContainerRequest(containerRequest);
            containersToUse.$plus$eq((Object)allocatedContainer);
        }
    }

    private void runAllocatedContainers(ArrayBuffer<Container> containersToUse) {
        containersToUse.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;

            public final void apply(Container container) {
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() + 1);
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() <= this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors());
                String executorHostname = container.getNodeId().getHost();
                ContainerId containerId = container.getId();
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter() + 1);
                String executorId = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter())).toString();
                Predef$.MODULE$.assert(container.getResource().getMemory() >= this.$outer.resource().getMemory());
                this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, containerId){
                    public static final long serialVersionUID = 0L;
                    private final String executorHostname$1;
                    private final ContainerId containerId$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Launching container %s for on host %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$1, this.executorHostname$1}));
                    }
                    {
                        this.executorHostname$1 = executorHostname$1;
                        this.containerId$1 = containerId$1;
                    }
                });
                this.$outer.executorIdToContainer().update((Object)executorId, (Object)container);
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$containerIdToExecutorId().update((Object)container.getId(), (Object)executorId);
                scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)this.$outer.allocatedHostToContainersMap().getOrElseUpdate((Object)executorHostname, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final HashSet<ContainerId> apply() {
                        return new HashSet();
                    }
                });
                containerSet.$plus$eq((Object)containerId);
                this.$outer.allocatedContainerToHostMap().put((Object)containerId, (Object)executorHostname);
                ExecutorRunnable executorRunnable = new ExecutorRunnable(container, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl, executorId, executorHostname, this.$outer.executorMemory(), this.$outer.executorCores(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId.getApplicationId().toString(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr);
                if (this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers()) {
                    this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$runAllocatedContainers$1 $outer;
                        private final String executorHostname$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Launching ExecutorRunnable. driverUrl: %s,  executorHostname: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl, this.executorHostname$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executorHostname$1 = executorHostname$1;
                        }
                    });
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool().execute(executorRunnable);
                }
            }

            public /* synthetic */ YarnAllocator org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void processCompletedContainers(Seq<ContainerStatus> completedContainers) {
        completedContainers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;

            public final void apply(ContainerStatus completedContainer) {
                BoxedUnit boxedUnit;
                ContainerId containerId = completedContainer.getContainerId();
                boolean alreadyReleased = this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().remove(containerId);
                if (!alreadyReleased) {
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() - 1);
                    this.$outer.logInfo((Function0<String>)new Serializable(this, containerId, completedContainer){
                        public static final long serialVersionUID = 0L;
                        private final ContainerId containerId$2;
                        private final ContainerStatus completedContainer$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Completed container %s (state: %s, exit status: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$2, this.completedContainer$1.getState(), BoxesRunTime.boxToInteger((int)this.completedContainer$1.getExitStatus())}));
                        }
                        {
                            this.containerId$2 = containerId$2;
                            this.completedContainer$1 = completedContainer$1;
                        }
                    });
                    if (completedContainer.getExitStatus() == -102) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, containerId){
                            public static final long serialVersionUID = 0L;
                            private final ContainerId containerId$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Container preempted: ").append((Object)this.containerId$2).toString();
                            }
                            {
                                this.containerId$2 = containerId$2;
                            }
                        });
                    } else if (completedContainer.getExitStatus() == -103) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, completedContainer){
                            public static final long serialVersionUID = 0L;
                            private final ContainerStatus completedContainer$1;

                            public final String apply() {
                                return YarnAllocator$.MODULE$.memLimitExceededLogMessage(this.completedContainer$1.getDiagnostics(), YarnAllocator$.MODULE$.VMEM_EXCEEDED_PATTERN());
                            }
                            {
                                this.completedContainer$1 = completedContainer$1;
                            }
                        });
                    } else if (completedContainer.getExitStatus() == -104) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, completedContainer){
                            public static final long serialVersionUID = 0L;
                            private final ContainerStatus completedContainer$1;

                            public final String apply() {
                                return YarnAllocator$.MODULE$.memLimitExceededLogMessage(this.completedContainer$1.getDiagnostics(), YarnAllocator$.MODULE$.PMEM_EXCEEDED_PATTERN());
                            }
                            {
                                this.completedContainer$1 = completedContainer$1;
                            }
                        });
                    } else if (completedContainer.getExitStatus() != 0) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, containerId, completedContainer){
                            public static final long serialVersionUID = 0L;
                            private final ContainerId containerId$2;
                            private final ContainerStatus completedContainer$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Container marked as failed: ").append((Object)this.containerId$2).append((Object)". Exit status: ").append((Object)BoxesRunTime.boxToInteger((int)this.completedContainer$1.getExitStatus())).append((Object)". Diagnostics: ").append((Object)this.completedContainer$1.getDiagnostics()).toString();
                            }
                            {
                                this.containerId$2 = containerId$2;
                                this.completedContainer$1 = completedContainer$1;
                            }
                        });
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed() + 1);
                    }
                }
                if (JavaConversions$.MODULE$.mutableMapAsJavaMap(this.$outer.allocatedContainerToHostMap()).containsKey(containerId)) {
                    Option option;
                    String host = (String)this.$outer.allocatedContainerToHostMap().get((Object)containerId).get();
                    scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)this.$outer.allocatedHostToContainersMap().get((Object)host).get();
                    containerSet.remove((Object)containerId);
                    if (containerSet.isEmpty()) {
                        option = this.$outer.allocatedHostToContainersMap().remove((Object)host);
                    } else {
                        this.$outer.allocatedHostToContainersMap().update((Object)host, (Object)containerSet);
                        option = BoxedUnit.UNIT;
                    }
                    boxedUnit = this.$outer.allocatedContainerToHostMap().remove((Object)containerId);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$containerIdToExecutorId().remove((Object)containerId).foreach((Function1)new Serializable(this, containerId, alreadyReleased){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$processCompletedContainers$1 $outer;
                    private final ContainerId containerId$2;
                    private final boolean alreadyReleased$1;

                    public final void apply(String eid) {
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().executorIdToContainer().remove((Object)eid);
                        if (!this.alreadyReleased$1) {
                            this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease() + 1L);
                            this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().org$apache$spark$deploy$yarn$YarnAllocator$$driverRef.send((Object)new CoarseGrainedClusterMessages.RemoveExecutor(eid, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Yarn deallocated the executor ", " (container ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eid, this.containerId$2}))));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.containerId$2 = containerId$2;
                        this.alreadyReleased$1 = alreadyReleased$1;
                    }
                });
            }

            public /* synthetic */ YarnAllocator org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(Container container) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().add(container.getId());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.releaseAssignedContainer(container.getId());
    }

    public long getNumUnexpectedContainerRelease() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease();
    }

    public YarnAllocator(String driverUrl, RpcEndpointRef driverRef, Configuration conf, SparkConf sparkConf, AMRMClient<AMRMClient.ContainerRequest> amClient, ApplicationAttemptId appAttemptId, ApplicationMasterArguments args, SecurityManager securityMgr) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl = driverUrl;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$driverRef = driverRef;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$conf = conf;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient = amClient;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId = appAttemptId;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr = securityMgr;
        Logging.class.$init$((Logging)this);
        if (org.apache.log4j.Logger.getLogger(RackResolver.class).getLevel() == null) {
            org.apache.log4j.Logger.getLogger(RackResolver.class).setLevel(Level.WARN);
        }
        this.allocatedHostToContainersMap = new HashMap();
        this.allocatedContainerToHostMap = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning = 0;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter = 0;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed = 0;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors = YarnSparkHadoopUtil$.MODULE$.getInitialTargetExecutorNumber(sparkConf);
        this.executorIdToContainer = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numUnexpectedContainerRelease = 0L;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$containerIdToExecutorId = new HashMap();
        this.executorMemory = args.executorMemory();
        this.memoryOverhead = sparkConf.getInt("spark.yarn.executor.memoryOverhead", package$.MODULE$.max((int)(YarnSparkHadoopUtil$.MODULE$.MEMORY_OVERHEAD_FACTOR() * (double)this.executorMemory()), YarnSparkHadoopUtil$.MODULE$.MEMORY_OVERHEAD_MIN()));
        this.executorCores = args.executorCores();
        this.resource = Resource.newInstance((int)(this.executorMemory() + this.memoryOverhead()), (int)this.executorCores());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool = new ThreadPoolExecutor(sparkConf.getInt("spark.yarn.containerLauncherMaxThreads", 25), Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool().allowCoreThreadTimeOut(true);
        this.org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers = sparkConf.getBoolean("spark.yarn.launchContainers", true);
        this.org$apache$spark$deploy$yarn$YarnAllocator$$labelExpression = sparkConf.getOption("spark.yarn.executor.nodeLabelExpression");
        this.nodeLabelConstructor = this.org$apache$spark$deploy$yarn$YarnAllocator$$labelExpression().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;

            public final Option<Constructor<AMRMClient.ContainerRequest>> apply(String expr) {
                Some some;
                try {
                    some = new Some(AMRMClient.ContainerRequest.class.getConstructor(Resource.class, String[].class, String[].class, Priority.class, Boolean.TYPE, String.class));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, expr){
                        public static final long serialVersionUID = 0L;
                        private final String expr$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Node label expression ", " will be ignored because YARN version on"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expr$1}))).append((Object)" classpath does not support it.").toString();
                        }
                        {
                            this.expr$1 = expr$1;
                        }
                    });
                    some = None$.MODULE$;
                }
                return some;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.hostToLocalTaskCounts = Predef$.MODULE$.Map().empty();
        this.numLocalityAwareTasks = 0;
        this.containerPlacementStrategy = new LocalityPreferredContainerPlacementStrategy(sparkConf, conf, this.resource());
    }
}

