/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class YarnAllocator$ {
    public static final YarnAllocator$ MODULE$;
    private final String MEM_REGEX;
    private final Pattern PMEM_EXCEEDED_PATTERN;
    private final Pattern VMEM_EXCEEDED_PATTERN;
    private final int VMEM_EXCEEDED_EXIT_CODE;
    private final int PMEM_EXCEEDED_EXIT_CODE;

    static {
        new YarnAllocator$();
    }

    public String MEM_REGEX() {
        return this.MEM_REGEX;
    }

    public Pattern PMEM_EXCEEDED_PATTERN() {
        return this.PMEM_EXCEEDED_PATTERN;
    }

    public Pattern VMEM_EXCEEDED_PATTERN() {
        return this.VMEM_EXCEEDED_PATTERN;
    }

    public int VMEM_EXCEEDED_EXIT_CODE() {
        return this.VMEM_EXCEEDED_EXIT_CODE;
    }

    public int PMEM_EXCEEDED_EXIT_CODE() {
        return this.PMEM_EXCEEDED_EXIT_CODE;
    }

    public String memLimitExceededLogMessage(String diagnostics, Pattern pattern) {
        Matcher matcher = pattern.matcher(diagnostics);
        String diag = matcher.find() ? new StringBuilder().append((Object)" ").append((Object)matcher.group()).append((Object)".").toString() : "";
        return new StringBuilder().append((Object)"Container killed by YARN for exceeding memory limits.").append((Object)diag).append((Object)" Consider boosting spark.yarn.executor.memoryOverhead.").toString();
    }

    private YarnAllocator$() {
        MODULE$ = this;
        this.MEM_REGEX = "[0-9.]+ [KMG]B";
        this.PMEM_EXCEEDED_PATTERN = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of ", " physical memory used"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.MEM_REGEX(), this.MEM_REGEX()})));
        this.VMEM_EXCEEDED_PATTERN = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of ", " virtual memory used"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.MEM_REGEX(), this.MEM_REGEX()})));
        this.VMEM_EXCEEDED_EXIT_CODE = -103;
        this.PMEM_EXCEEDED_EXIT_CODE = -104;
    }
}

