/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}4Q!\u0001\u0002\u0001\u00051\u0011\u0001$Q'EK2,w-\u0019;j_:$vn[3o%\u0016tWm^3s\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\ngB\f'o[\"p]\u001a\u001c\u0001\u0001\u0005\u0002\u001e=5\ta!\u0003\u0002 \r\tI1\u000b]1sW\u000e{gN\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B2p]\u001aT!a\n\u0005\u0002\r!\fGm\\8q\u0013\tICEA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075z\u0003\u0007\u0005\u0002/\u00015\t!\u0001C\u0003\u001bU\u0001\u0007A\u0004C\u0003\"U\u0001\u0007!\u0005C\u00043\u0001\u0001\u0007I\u0011B\u001a\u000231\f7\u000f^\"sK\u0012,g\u000e^5bYN4\u0015\u000e\\3Tk\u001a4\u0017\u000e_\u000b\u0002iA\u0011a\"N\u0005\u0003m=\u00111!\u00138u\u0011\u001dA\u0004\u00011A\u0005\ne\nQ\u0004\\1ti\u000e\u0013X\rZ3oi&\fGn\u001d$jY\u0016\u001cVO\u001a4jq~#S-\u001d\u000b\u0003uu\u0002\"AD\u001e\n\u0005qz!\u0001B+oSRDqAP\u001c\u0002\u0002\u0003\u0007A'A\u0002yIEBa\u0001\u0011\u0001!B\u0013!\u0014A\u00077bgR\u001c%/\u001a3f]RL\u0017\r\\:GS2,7+\u001e4gSb\u0004\u0003b\u0002\"\u0001\u0005\u0004%IaQ\u0001\u0017I\u0016dWmZ1uS>tGk\\6f]J+g.Z<feV\tA\t\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%S\u0015\u0001B;uS2T\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\r\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\r=\u0003\u0001\u0015!\u0003E\u0003]!W\r\\3hCRLwN\u001c+pW\u0016t'+\u001a8fo\u0016\u0014\b\u0005C\u0004R\u0001\t\u0007I\u0011\u0002*\u0002\u0015!\fGm\\8q+RLG.F\u0001T!\tqC+\u0003\u0002V\u0005\t\u0019\u0012,\u0019:o'B\f'o\u001b%bI>|\u0007/\u0016;jY\"1q\u000b\u0001Q\u0001\nM\u000b1\u0002[1e_>\u0004X\u000b^5mA!9\u0011\f\u0001b\u0001\n\u0013Q\u0016aD2sK\u0012,g\u000e^5bYN4\u0015\u000e\\3\u0016\u0003m\u0003\"\u0001X0\u000f\u00059i\u0016B\u00010\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y{\u0001BB2\u0001A\u0003%1,\u0001\tde\u0016$WM\u001c;jC2\u001ch)\u001b7fA!9Q\r\u0001b\u0001\n\u0013\u0019\u0014a\u00043bsN$vnS3fa\u001aKG.Z:\t\r\u001d\u0004\u0001\u0015!\u00035\u0003A!\u0017-_:U_.+W\r\u001d$jY\u0016\u001c\b\u0005C\u0004j\u0001\t\u0007I\u0011B\u001a\u0002\u001d9,XNR5mKN$vnS3fa\"11\u000e\u0001Q\u0001\nQ\nqB\\;n\r&dWm\u001d+p\u0017\u0016,\u0007\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u0003=1'/Z:i\u0011\u0006$wn\u001c9D_:4W#\u0001\u0012\t\rA\u0004\u0001\u0015!\u0003#\u0003A1'/Z:i\u0011\u0006$wn\u001c9D_:4\u0007\u0005\u0003\u0004s\u0001\u0011\u0005aa]\u0001\u0018g\u000eDW\rZ;mK2{w-\u001b8Ge>l7*Z=uC\n$\u0012A\u000f\u0005\u0006k\u0002!Ia]\u0001\u0010G2,\u0017M\\;q\u001f2$g)\u001b7fg\")q\u000f\u0001C\u0005q\u0006!rO]5uK:+w\u000fV8lK:\u001cHk\u001c%E\rN#2AO=|\u0011\u0015Qh\u000f1\u0001\\\u0003%\u0001(/\u001b8dSB\fG\u000eC\u0003}m\u0002\u00071,\u0001\u0004lKf$\u0018M\u0019\u0005\u0006}\u0002!\ta]\u0001\u0005gR|\u0007\u000f")
public class AMDelegationTokenRenewer
implements Logging {
    public final SparkConf org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf;
    private int org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix;
    private final ScheduledExecutorService org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer;
    private final YarnSparkHadoopUtil org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil;
    private final String credentialsFile;
    private final int daysToKeepFiles;
    private final int numFilesToKeep;
    private final Configuration org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private int org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix() {
        return this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix;
    }

    public void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix = x$1;
    }

    public ScheduledExecutorService org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer() {
        return this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer;
    }

    public YarnSparkHadoopUtil org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil() {
        return this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil;
    }

    private String credentialsFile() {
        return this.credentialsFile;
    }

    private int daysToKeepFiles() {
        return this.daysToKeepFiles;
    }

    private int numFilesToKeep() {
        return this.numFilesToKeep;
    }

    public Configuration org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf() {
        return this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf;
    }

    public void scheduleLoginFromKeytab() {
        String principal = (String)((Option)this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL())).get();
        String keytab = (String)((Option)this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.KEYTAB())).get();
        Runnable driverTokenRenewerRunnable = new Runnable(this, principal, keytab){
            private final /* synthetic */ AMDelegationTokenRenewer $outer;
            private final String principal$1;
            private final String keytab$1;

            public void run() {
                try {
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$writeNewTokensToHDFS(this.principal$1, this.keytab$1);
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$cleanupOldFiles();
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$scheduleRenewal$1(this);
                    return;
                }
                catch (Exception exception) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Failed to write out new credentials to HDFS, will try again in an hour! If this happens too often tasks will fail.";
                        }
                    }, exception);
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer().schedule(this, 1L, TimeUnit.HOURS);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.keytab$1 = keytab$1;
            }
        };
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$scheduleRenewal$1(driverTokenRenewerRunnable);
    }

    public void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$cleanupOldFiles() {
        try {
            FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf());
            Path credentialsPath = new Path(this.credentialsFile());
            long thresholdTime = System.currentTimeMillis() - new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(this.daysToKeepFiles())).days().toMillis();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).dropRight(this.numFilesToKeep())).takeWhile((Function1)new Serializable(this, thresholdTime){
                public static final long serialVersionUID = 0L;
                private final long thresholdTime$1;

                public final boolean apply(FileStatus x$1) {
                    return x$1.getModificationTime() < this.thresholdTime$1;
                }
                {
                    this.thresholdTime$1 = thresholdTime$1;
                }
            })).foreach((Function1)new Serializable(this, remoteFs){
                public static final long serialVersionUID = 0L;
                private final FileSystem remoteFs$1;

                public final boolean apply(FileStatus x) {
                    return this.remoteFs$1.delete(x.getPath(), true);
                }
                {
                    this.remoteFs$1 = remoteFs$1;
                }
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while attempting to cleanup old tokens. If you are seeing many such warnings there may be an issue with your HDFS cluster.";
                }
            }, exception);
        }
    }

    public void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$writeNewTokensToHDFS(String principal, String keytab) {
        this.logInfo((Function0<String>)new Serializable(this, principal){
            public static final long serialVersionUID = 0L;
            private final String principal$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to login to KDC using principal: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principal$2}));
            }
            {
                this.principal$2 = principal$2;
            }
        });
        UserGroupInformation keytabLoggedInUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Successfully logged into KDC.";
            }
        });
        Credentials tempCreds = keytabLoggedInUGI.getCredentials();
        Path credentialsPath = new Path(this.credentialsFile());
        Path dst = credentialsPath.getParent();
        keytabLoggedInUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(this, tempCreds, dst){
            private final /* synthetic */ AMDelegationTokenRenewer $outer;
            private final Credentials tempCreds$1;
            private final Path dst$1;

            public Void run() {
                Set nns = (Set)YarnSparkHadoopUtil$.MODULE$.get().getNameNodesToAccess(this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf).$plus((Object)this.dst$1);
                this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().obtainTokensForNamenodes((Set<Path>)nns, this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf(), this.tempCreds$1, this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().obtainTokensForNamenodes$default$4());
                this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().obtainTokenForHiveMetastore(this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf, this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf(), this.tempCreds$1);
                this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().obtainTokenForHBase(this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf, this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf(), this.tempCreds$1);
                return null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tempCreds$1 = tempCreds$1;
                this.dst$1 = dst$1;
            }
        });
        UserGroupInformation.getCurrentUser().addCredentials(tempCreds);
        FileSystem remoteFs = FileSystem.get((Configuration)this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf());
        if (this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix() == 0) {
            Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().listFilesSorted(remoteFs, credentialsPath.getParent(), credentialsPath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).lastOption().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AMDelegationTokenRenewer $outer;

                public final void apply(FileStatus status) {
                    this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix_$eq(this.$outer.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().getSuffixForCredentialsPath(status.getPath()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        int nextSuffix = this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix() + 1;
        String tokenPathStr = new StringBuilder().append((Object)this.credentialsFile()).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()).append((Object)BoxesRunTime.boxToInteger((int)nextSuffix)).toString();
        Path tokenPath = new Path(tokenPathStr);
        Path tempTokenPath = new Path(new StringBuilder().append((Object)tokenPathStr).append((Object)SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION()).toString());
        this.logInfo((Function0<String>)new Serializable(this, tempTokenPath){
            public static final long serialVersionUID = 0L;
            private final Path tempTokenPath$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Writing out delegation tokens to ").append((Object)this.tempTokenPath$1.toString()).toString();
            }
            {
                this.tempTokenPath$1 = tempTokenPath$1;
            }
        });
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        credentials.writeTokenStorageFile(tempTokenPath, this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf());
        this.logInfo((Function0<String>)new Serializable(this, tokenPathStr){
            public static final long serialVersionUID = 0L;
            private final String tokenPathStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation Tokens written out successfully. Renaming file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenPathStr$1}));
            }
            {
                this.tokenPathStr$1 = tokenPathStr$1;
            }
        });
        remoteFs.rename(tempTokenPath, tokenPath);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delegation token file rename complete.";
            }
        });
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix_$eq(nextSuffix);
    }

    public void stop() {
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer().shutdown();
    }

    public final void org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$scheduleRenewal$1(Runnable runnable) {
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        long renewalInterval = this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().getTimeFromNowToRenewal(this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf, 0.75, credentials);
        if (renewalInterval <= 0L) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "HDFS tokens have expired, creating new tokens now.";
                }
            });
            runnable.run();
        } else {
            this.logInfo((Function0<String>)new Serializable(this, renewalInterval){
                public static final long serialVersionUID = 0L;
                private final long renewalInterval$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling login from keytab in ", " millis."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.renewalInterval$1)}));
                }
                {
                    this.renewalInterval$1 = renewalInterval$1;
                }
            });
            this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer().schedule(runnable, renewalInterval, TimeUnit.MILLISECONDS);
        }
    }

    public AMDelegationTokenRenewer(SparkConf sparkConf, Configuration hadoopConf) {
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$sparkConf = sparkConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$lastCredentialsFileSuffix = 0;
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$delegationTokenRenewer = Executors.newSingleThreadScheduledExecutor(ThreadUtils$.MODULE$.namedThreadFactory("Delegation Token Refresh Thread"));
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil = YarnSparkHadoopUtil$.MODULE$.get();
        this.credentialsFile = (String)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_PATH());
        this.daysToKeepFiles = BoxesRunTime.unboxToInt((Object)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_MAX_RETENTION()));
        this.numFilesToKeep = BoxesRunTime.unboxToInt((Object)sparkConf.get(package$.MODULE$.CREDENTIAL_FILE_MAX_COUNT()));
        this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$freshHadoopConf = this.org$apache$spark$deploy$yarn$AMDelegationTokenRenewer$$hadoopUtil().getConfBypassingFSCache(hadoopConf, new Path(this.credentialsFile()).toUri().getScheme());
    }
}

