/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u0001\u0003\u0001\ta!\u0001E#yK\u000e,Ho\u001c:Sk:t\u0017M\u00197f\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0003\u0001\u001bUA\u0002C\u0001\b\u0014\u001b\u0005y!B\u0001\t\u0012\u0003\u0011a\u0017M\\4\u000b\u0003I\tAA[1wC&\u0011Ac\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u000591\u0012BA\f\u0010\u0005!\u0011VO\u001c8bE2,\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\u000f\u001b\u0005\u001daunZ4j]\u001eD\u0001b\b\u0001\u0003\u0002\u0003\u0006I!I\u0001\nG>tG/Y5oKJ\u001c\u0001\u0001\u0005\u0002#U5\t1E\u0003\u0002%K\u00059!/Z2pe\u0012\u001c(B\u0001\u0014(\u0003\r\t\u0007/\u001b\u0006\u0003\u0007!R!!\u000b\u0005\u0002\r!\fGm\\8q\u0013\tY3EA\u0005D_:$\u0018-\u001b8fe\"AQ\u0006\u0001B\u0001B\u0003%a&\u0001\u0003d_:4\u0007CA\u00182\u001b\u0005\u0001$BA\u0017)\u0013\t\u0011\u0004GA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003m]j\u0011AB\u0005\u0003q\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011i\u0002!\u0011!Q\u0001\nm\nQ\"\\1ti\u0016\u0014\u0018\t\u001a3sKN\u001c\bC\u0001\u001fC\u001d\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005s\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u000fMd\u0017M^3JI\"A\u0001\n\u0001B\u0001B\u0003%1(\u0001\u0005i_N$h.Y7f\u0011!Q\u0005A!A!\u0002\u0013Y\u0015AD3yK\u000e,Ho\u001c:NK6|'/\u001f\t\u0003{1K!!\u0014 \u0003\u0007%sG\u000f\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003L\u00035)\u00070Z2vi>\u00148i\u001c:fg\"A\u0011\u000b\u0001B\u0001B\u0003%1(A\u0003baBLE\r\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0003-\u0019XmY;sSRLXj\u001a:\u0011\u0005Y*\u0016B\u0001,\u0007\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\b\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\u0002\u001d1|7-\u00197SKN|WO]2fgB!AHW\u001e]\u0013\tYFIA\u0002NCB\u0004\"AI/\n\u0005y\u001b#!\u0004'pG\u0006d'+Z:pkJ\u001cW\rC\u0003a\u0001\u0011\u0005\u0011-\u0001\u0004=S:LGO\u0010\u000b\rE\u0012,gm\u001a5jU.dWN\u001c\t\u0003G\u0002i\u0011A\u0001\u0005\u0006?}\u0003\r!\t\u0005\u0006[}\u0003\rA\f\u0005\u0006i}\u0003\r!\u000e\u0005\u0006u}\u0003\ra\u000f\u0005\u0006\r~\u0003\ra\u000f\u0005\u0006\u0011~\u0003\ra\u000f\u0005\u0006\u0015~\u0003\ra\u0013\u0005\u0006\u001f~\u0003\ra\u0013\u0005\u0006#~\u0003\ra\u000f\u0005\u0006'~\u0003\r\u0001\u0016\u0005\u00061~\u0003\r!\u0017\u0005\ba\u0002\u0001\r\u0011\"\u0001r\u0003\r\u0011\boY\u000b\u0002eB\u00111O^\u0007\u0002i*\u0011QoJ\u0001\u0004SB\u001c\u0017BA<u\u0005\u001dI\u0016M\u001d8S!\u000eCq!\u001f\u0001A\u0002\u0013\u0005!0A\u0004sa\u000e|F%Z9\u0015\u0005mt\bCA\u001f}\u0013\tihH\u0001\u0003V]&$\bbB@y\u0003\u0003\u0005\rA]\u0001\u0004q\u0012\n\u0004bBA\u0002\u0001\u0001\u0006KA]\u0001\u0005eB\u001c\u0007\u0005C\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\u0002\u0005%\u0011\u0001\u00038n\u00072LWM\u001c;\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003+i!!a\u0004\u000b\u0007\u0019\n\tBC\u0002\u0002\u0014\u001d\naa\u00197jK:$\u0018\u0002BA\f\u0003\u001f\u0011\u0001BT'DY&,g\u000e\u001e\u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0003\ti\"\u0001\u0007o[\u000ec\u0017.\u001a8u?\u0012*\u0017\u000fF\u0002|\u0003?A\u0011b`A\r\u0003\u0003\u0005\r!a\u0003\t\u0011\u0005\r\u0002\u0001)Q\u0005\u0003\u0017\t\u0011B\\7DY&,g\u000e\u001e\u0011\t\u0013\u0005\u001d\u0002A1A\u0005\u0002\u0005%\u0012\u0001C=be:\u001cuN\u001c4\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003ci!!a\f\u000b\u00055:\u0013\u0002BA\u001a\u0003_\u0011\u0011#W1s]\u000e{gNZ5hkJ\fG/[8o\u0011!\t9\u0004\u0001Q\u0001\n\u0005-\u0012!C=be:\u001cuN\u001c4!\u0011)\tY\u0004\u0001EC\u0002\u0013\u0005\u0011QH\u0001\u0004K:4XCAA !\u0019\t\t%a\u0013<w5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0004nkR\f'\r\\3\u000b\u0007\u0005%c(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0014\u0002D\t9\u0001*Y:i\u001b\u0006\u0004\bBCA)\u0001!\u0005\t\u0015)\u0003\u0002@\u0005!QM\u001c<!\u0011\u001d\t)\u0006\u0001C!\u0003/\n1A];o)\u0005Y\bbBA.\u0001\u0011\u0005\u0011QL\u0001\u000fgR\f'\u000f^\"p]R\f\u0017N\\3s)\t\ty\u0006E\u0004\u0002b\u0005\u001d4(!\u001b\u000e\u0005\u0005\r$bAA3#\u0005!Q\u000f^5m\u0013\rY\u00161\r\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN\t\u0002\u00079Lw.\u0003\u0003\u0002t\u00055$A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u0011q\u000f\u0001\u0005\n\u0005e\u0014A\u00049sKB\f'/Z\"p[6\fg\u000e\u001a\u000b\u000f\u0003w\n\u0019*!&\u0002\u0018\u0006e\u00151TAO!\u0015\ti(!$<\u001d\u0011\ty(!#\u000f\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"!\u0003\u0019a$o\\8u}%\tq(C\u0002\u0002\fz\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0010\u0006E%\u0001\u0002'jgRT1!a#?\u0011\u0019Q\u0014Q\u000fa\u0001w!1a)!\u001eA\u0002mBa\u0001SA;\u0001\u0004Y\u0004B\u0002&\u0002v\u0001\u00071\n\u0003\u0004P\u0003k\u0002\ra\u0013\u0005\u0007#\u0006U\u0004\u0019A\u001e\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\u0006\u0011\u0002O]3qCJ,WI\u001c<je>tW.\u001a8u)\u0011\ty$!*\t\r}\ty\n1\u0001\"\u0001")
public class ExecutorRunnable
implements Runnable,
Logging {
    private final Container container;
    public final SparkConf org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf;
    private final String masterAddress;
    private final String slaveId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private final scala.collection.immutable.Map<String, LocalResource> localResources;
    private YarnRPC rpc;
    private NMClient nmClient;
    private final YarnConfiguration yarnConf;
    private HashMap<String, String> env;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    private HashMap env$lzycompute() {
        ExecutorRunnable executorRunnable = this;
        synchronized (executorRunnable) {
            if (!this.bitmap$0) {
                this.env = this.prepareEnvironment(this.container);
                this.bitmap$0 = true;
            }
            return this.env;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    public HashMap<String, String> env() {
        return this.bitmap$0 ? this.env : this.env$lzycompute();
    }

    @Override
    public void run() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting Executor Container";
            }
        });
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.yarnConf());
        this.nmClient().start();
        this.startContainer();
    }

    public Map<String, ByteBuffer> startContainer() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up ContainerLaunchContext";
            }
        });
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        ctx.setLocalResources((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.localResources).asJava());
        ctx.setEnvironment((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.env()).asJava());
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand(this.masterAddress, this.slaveId, this.hostname, this.executorMemory, this.executorCores, this.appId);
        this.logInfo((Function0<String>)new Serializable(this, commands){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;
            private final List commands$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |===============================================================================\n      |YARN executor launch context:\n      |  env:\n      |", "\n      |  command:\n      |    ", "\n      |===============================================================================\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.$outer.env().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", " -> ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString(), this.commands$1.mkString(" ")})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commands$1 = commands$1;
            }
        });
        ctx.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commands).asJava());
        ctx.setApplicationACLs((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)).asJava());
        if (BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString == null ? ByteBuffer.allocate(0) : JavaUtils.stringToBytes((String)secretString);
            ctx.setServiceData(Collections.singletonMap("spark_shuffle", secretBytes));
        }
        try {
            return this.nmClient().startContainer(this.container, ctx);
        }
        catch (Exception exception) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while starting container ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.container.getId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" on host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname}))).toString(), (Throwable)exception);
        }
    }

    private List<String> prepareCommand(String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId) {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef prefixEnv = ObjectRef.create((Object)None$.MODULE$);
        String executorMemoryString = new StringBuilder().append(executorMemory).append((Object)"m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Xmx").append((Object)executorMemoryString).toString());
        ((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_JAVA_OPTS").foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(String opts) {
                return this.javaOpts$1.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(opts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String arg) {
                        return YarnSparkHadoopUtil$.MODULE$.escapeForShell(arg);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        ((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_LIBRARY_PATH())).foreach((Function1)new Serializable(this, prefixEnv){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;
            private final ObjectRef prefixEnv$1;

            public final void apply(String p) {
                this.prefixEnv$1.elem = new Some((Object)Client$.MODULE$.getClusterPath(this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, Utils$.MODULE$.libraryPathEnvPrefix((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{p})))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.prefixEnv$1 = prefixEnv$1;
            }
        });
        javaOpts.$plus$eq((Object)new StringBuilder().append((Object)"-Djava.io.tmpdir=").append((Object)new Path(YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), "./tmp")).toString());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.getAll()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).foreach((Function1)new Serializable(this, javaOpts){
            public static final long serialVersionUID = 0L;
            private final ListBuffer javaOpts$1;

            public final ListBuffer<String> apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ListBuffer listBuffer = this.javaOpts$1.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-D", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}))));
                    return listBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.javaOpts$1 = javaOpts$1;
            }
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        YarnCommandBuilderUtils$.MODULE$.addPermGenSizeOpt((ListBuffer<String>)javaOpts);
        Seq userClassPath = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Client$.MODULE$.getUserClasspath(this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf)).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunnable $outer;

            public final Seq<String> apply(URI uri) {
                String absPath = new File(uri.getPath()).isAbsolute() ? Client$.MODULE$.getClusterPath(this.$outer.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, uri.getPath()) : Client$.MODULE$.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$(), uri.getPath()}));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--user-class-path", new StringBuilder().append((Object)"file:").append((Object)absPath).toString()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSeq();
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable((Option)prefixEnv.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.JAVA_HOME)).append((Object)"/bin/java").toString(), "-server", YarnSparkHadoopUtil$.MODULE$.getOutOfMemoryErrorArgument()})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.CoarseGrainedExecutorBackend", "--driver-url", masterAddress.toString(), "--executor-id", slaveId.toString(), "--hostname", hostname.toString(), "--cores", ((Object)BoxesRunTime.boxToInteger((int)executorCores)).toString(), "--app-id", appId})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userClassPath, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1>", "<LOG_DIR>/stdout", "2>", "<LOG_DIR>/stderr"})), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s == null ? "null" : s;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> prepareEnvironment(Container container) {
        void var2_2;
        String yarnHttpPolicy;
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath(null, (Configuration)this.yarnConf(), this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf, (HashMap<String, String>)env, (Option<String>)((Option)this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_CLASS_PATH())));
        this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf.getExecutorEnv().foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_YARN_USER_ENV").foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(String userEnvs) {
                YarnSparkHadoopUtil$.MODULE$.setEnvFromInputString((HashMap<String, String>)this.env$1, userEnvs);
            }
            {
                this.env$1 = env$1;
            }
        });
        String string = yarnHttpPolicy = this.yarnConf().get("yarn.http.policy", "HTTP_ONLY");
        String string2 = "HTTPS_ONLY";
        String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_USER").foreach((Function1)new Serializable(this, container, env, httpScheme){
            public static final long serialVersionUID = 0L;
            private final Container container$1;
            private final HashMap env$1;
            private final String httpScheme$1;

            public final void apply(String user) {
                String containerId = ConverterUtils.toString((ContainerId)this.container$1.getId());
                String address = this.container$1.getNodeHttpAddress();
                String baseUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "/node/containerlogs/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.httpScheme$1, address, containerId, user}));
                this.env$1.update((Object)"SPARK_LOG_URL_STDERR", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stderr?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
                this.env$1.update((Object)"SPARK_LOG_URL_STDOUT", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stdout?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
            }
            {
                this.container$1 = container$1;
                this.env$1 = env$1;
                this.httpScheme$1 = httpScheme$1;
            }
        });
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.startsWith("SPARK");
            }
        }).foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$5) {
                Tuple2<String, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.env$1.update((Object)k, (Object)v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var2_2;
    }

    public ExecutorRunnable(Container container, Configuration conf, SparkConf sparkConf, String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr, scala.collection.immutable.Map<String, LocalResource> localResources) {
        this.container = container;
        this.org$apache$spark$deploy$yarn$ExecutorRunnable$$sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.slaveId = slaveId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        this.localResources = localResources;
        Logging.class.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
        this.yarnConf = new YarnConfiguration(conf);
    }
}

