/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.HDFSCredentialProvider$;
import org.apache.spark.deploy.yarn.security.ServiceCredentialProvider;
import org.apache.spark.deploy.yarn.security.ServiceCredentialProvider$class;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0001\u00059\u0011a\u0003\u0013#G'\u000e\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\u0006\u0003\u0007\u0011\t\u0001b]3dkJLG/\u001f\u0006\u0003\u000b\u0019\tA!_1s]*\u0011q\u0001C\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001cB\u0001A\b\u00163A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u00033M+'O^5dK\u000e\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\t\u00035ui\u0011a\u0007\u0006\u00039!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!\u0001\u0011\u0005!%\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0003C\u0001\f\u0001\u0011\u001d)\u0003\u00011A\u0005\n\u0019\nA\u0003^8lK:\u0014VM\\3xC2Le\u000e^3sm\u0006dW#A\u0014\u0011\u0007AA#&\u0003\u0002*#\t1q\n\u001d;j_:\u0004\"\u0001E\u0016\n\u00051\n\"\u0001\u0002'p]\u001eDqA\f\u0001A\u0002\u0013%q&\u0001\ru_.,gNU3oK^\fG.\u00138uKJ4\u0018\r\\0%KF$\"\u0001M\u001a\u0011\u0005A\t\u0014B\u0001\u001a\u0012\u0005\u0011)f.\u001b;\t\u000fQj\u0013\u0011!a\u0001O\u0005\u0019\u0001\u0010J\u0019\t\rY\u0002\u0001\u0015)\u0003(\u0003U!xn[3o%\u0016tWm^1m\u0013:$XM\u001d<bY\u0002Bq\u0001\u000f\u0001C\u0002\u0013\u0005\u0013(A\u0006tKJ4\u0018nY3OC6,W#\u0001\u001e\u0011\u0005mrdB\u0001\t=\u0013\ti\u0014#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f\u0012\u0011\u0019\u0011\u0005\u0001)A\u0005u\u0005a1/\u001a:wS\u000e,g*Y7fA!)A\t\u0001C!\u000b\u0006\trN\u0019;bS:\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\u001d2\u0005K\u0016\u0005\u0006\u000f\u000e\u0003\r\u0001S\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007CA%O\u001b\u0005Q%BA&M\u0003\u0011\u0019wN\u001c4\u000b\u00055S\u0011A\u00025bI>|\u0007/\u0003\u0002P\u0015\ni1i\u001c8gS\u001e,(/\u0019;j_:DQ!U\"A\u0002I\u000b\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005M#V\"\u0001\u0005\n\u0005UC!!C*qCJ\\7i\u001c8g\u0011\u001596\t1\u0001Y\u0003\u0015\u0019'/\u001a3t!\tI6,D\u0001[\u0015\t\u0019A*\u0003\u0002]5\nY1I]3eK:$\u0018.\u00197t\u0011\u0015q\u0006\u0001\"\u0003`\u0003]9W\r\u001e+pW\u0016t'+\u001a8fo\u0006d\u0017J\u001c;feZ\fG\u000eF\u0002(A\u0006DQaR/A\u0002!CQ!U/A\u0002ICQa\u0019\u0001\u0005\n\u0011\fqbZ3u)>\\WM\u001c*f]\u0016<XM\u001d\u000b\u0003u\u0015DQa\u00132A\u0002!CQa\u001a\u0001\u0005\n!\f1B\u001c8t)>\f5mY3tgR\u0019\u0011N]:\u0011\u0007mRG.\u0003\u0002l\u0001\n\u00191+\u001a;\u0011\u00055\u0004X\"\u00018\u000b\u0005=d\u0015A\u00014t\u0013\t\thN\u0001\u0003QCRD\u0007\"B$g\u0001\u0004A\u0005\"B)g\u0001\u0004\u0011\u0006")
public class HDFSCredentialProvider
implements ServiceCredentialProvider,
Logging {
    private Option<Object> tokenRenewalInterval;
    private final String serviceName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public boolean credentialsRequired(Configuration hadoopConf) {
        return ServiceCredentialProvider$class.credentialsRequired(this, hadoopConf);
    }

    private Option<Object> tokenRenewalInterval() {
        return this.tokenRenewalInterval;
    }

    private void tokenRenewalInterval_$eq(Option<Object> x$1) {
        this.tokenRenewalInterval = x$1;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public Option<Object> obtainCredentials(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        this.org$apache$spark$deploy$yarn$security$HDFSCredentialProvider$$nnsToAccess(hadoopConf, sparkConf).foreach((Function1)new Serializable(this, hadoopConf, creds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSCredentialProvider $outer;
            private final Configuration hadoopConf$1;
            private final Credentials creds$1;

            public final Token<?>[] apply(Path dst) {
                FileSystem dstFs = dst.getFileSystem(this.hadoopConf$1);
                this.$outer.logInfo((Function0<String>)new Serializable(this, dst){
                    public static final long serialVersionUID = 0L;
                    private final Path dst$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"getting token for namenode: ").append((Object)this.dst$1).toString();
                    }
                    {
                        this.dst$1 = dst$1;
                    }
                });
                return dstFs.addDelegationTokens(this.$outer.org$apache$spark$deploy$yarn$security$HDFSCredentialProvider$$getTokenRenewer(this.hadoopConf$1), this.creds$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hadoopConf$1 = hadoopConf$1;
                this.creds$1 = creds$1;
            }
        });
        if (this.tokenRenewalInterval() == null) {
            this.tokenRenewalInterval_$eq(this.getTokenRenewalInterval(hadoopConf, sparkConf));
        }
        return this.tokenRenewalInterval().map((Function1)new Serializable(this, creds){
            public static final long serialVersionUID = 0L;
            private final Credentials creds$1;

            public final long apply(long interval) {
                return this.apply$mcJJ$sp(interval);
            }

            public long apply$mcJJ$sp(long interval) {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.creds$1.getAllTokens()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Token<? extends TokenIdentifier> x$1) {
                        Text text = x$1.getKind();
                        Text text2 = DelegationTokenIdentifier.HDFS_DELEGATION_KIND;
                        return !(text != null ? !text.equals(text2) : text2 != null);
                    }
                })).map((Function1)new Serializable(this, interval){
                    public static final long serialVersionUID = 0L;
                    private final long interval$2;

                    public final long apply(Token<? extends TokenIdentifier> t) {
                        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
                        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(t.getIdentifier())));
                        return identifier.getIssueDate() + this.interval$2;
                    }
                    {
                        this.interval$2 = interval$2;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x, long y) {
                        return this.apply$mcJJJ$sp(x, y);
                    }

                    public long apply$mcJJJ$sp(long x, long y) {
                        return scala.math.package$.MODULE$.max(x, y);
                    }
                }));
            }
            {
                this.creds$1 = creds$1;
            }
        });
    }

    private Option<Object> getTokenRenewalInterval(Configuration hadoopConf, SparkConf sparkConf) {
        return ((Option)sparkConf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL())).flatMap((Function1)new Serializable(this, hadoopConf, sparkConf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSCredentialProvider $outer;
            public final Configuration hadoopConf$3;
            private final SparkConf sparkConf$1;

            public final Option<Object> apply(String renewer) {
                Credentials creds = new Credentials();
                this.$outer.org$apache$spark$deploy$yarn$security$HDFSCredentialProvider$$nnsToAccess(this.hadoopConf$3, this.sparkConf$1).foreach((Function1)new Serializable(this, creds, renewer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTokenRenewalInterval$1 $outer;
                    private final Credentials creds$2;
                    private final String renewer$1;

                    public final Token<?>[] apply(Path dst) {
                        FileSystem dstFs = dst.getFileSystem(this.$outer.hadoopConf$3);
                        return dstFs.addDelegationTokens(this.renewer$1, this.creds$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.creds$2 = creds$2;
                        this.renewer$1 = renewer$1;
                    }
                });
                Option hdfsToken = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(creds.getAllTokens()).asScala()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Token<? extends TokenIdentifier> x$2) {
                        Text text = x$2.getKind();
                        Text text2 = DelegationTokenIdentifier.HDFS_DELEGATION_KIND;
                        return !(text != null ? !text.equals(text2) : text2 != null);
                    }
                });
                return hdfsToken.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTokenRenewalInterval$1 $outer;

                    public final long apply(Token<? extends TokenIdentifier> t) {
                        long newExpiration = t.renew(this.$outer.hadoopConf$3);
                        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
                        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(t.getIdentifier())));
                        long interval = newExpiration - identifier.getIssueDate();
                        this.$outer.org$apache$spark$deploy$yarn$security$HDFSCredentialProvider$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this, interval){
                            public static final long serialVersionUID = 0L;
                            private final long interval$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Renewal Interval is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.interval$1)}));
                            }
                            {
                                this.interval$1 = interval$1;
                            }
                        });
                        return interval;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ HDFSCredentialProvider org$apache$spark$deploy$yarn$security$HDFSCredentialProvider$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hadoopConf$3 = hadoopConf$3;
                this.sparkConf$1 = sparkConf$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public String org$apache$spark$deploy$yarn$security$HDFSCredentialProvider$$getTokenRenewer(Configuration conf) {
        void var2_2;
        String delegTokenRenewer = Master.getMasterPrincipal((Configuration)conf);
        this.logDebug((Function0<String>)new Serializable(this, delegTokenRenewer){
            public static final long serialVersionUID = 0L;
            private final String delegTokenRenewer$1;

            public final String apply() {
                return new StringBuilder().append((Object)"delegation token renewer is: ").append((Object)this.delegTokenRenewer$1).toString();
            }
            {
                this.delegTokenRenewer$1 = delegTokenRenewer$1;
            }
        });
        if (delegTokenRenewer == null || delegTokenRenewer.length() == 0) {
            String errorMessage = "Can't get Master Kerberos principal for use as renewer";
            this.logError((Function0<String>)new Serializable(this, errorMessage){
                public static final long serialVersionUID = 0L;
                private final String errorMessage$1;

                public final String apply() {
                    return this.errorMessage$1;
                }
                {
                    this.errorMessage$1 = errorMessage$1;
                }
            });
            throw new SparkException(errorMessage);
        }
        return var2_2;
    }

    public Set<Path> org$apache$spark$deploy$yarn$security$HDFSCredentialProvider$$nnsToAccess(Configuration hadoopConf, SparkConf sparkConf) {
        return (Set)((TraversableOnce)((TraversableLike)sparkConf.get(package$.MODULE$.NAMENODES_TO_ACCESS())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$3) {
                return new Path(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().$plus(((Option)sparkConf.get(package$.MODULE$.STAGING_DIR())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$4) {
                return new Path(x$4);
            }
        }).getOrElse((Function0)new Serializable(this, hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$2;

            public final Path apply() {
                return FileSystem.get((Configuration)this.hadoopConf$2).getHomeDirectory();
            }
            {
                this.hadoopConf$2 = hadoopConf$2;
            }
        }));
    }

    public HDFSCredentialProvider() {
        ServiceCredentialProvider$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.tokenRenewalInterval = null;
        this.serviceName = "hdfs";
    }
}

